package ibase.webitm.ejb.gst;




import ibase.webitm.ejb.*;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
//import ibase.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.w3c.dom.*;

@javax.ejb.Stateless
public class GstClearDataIC extends ValidatorEJB implements GstClearDataICRemote, GstClearDataICLocal
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	//GenericUtility genericUtility = new GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		
		try
		{
			System.out.println("Inside GstDataIC wfValData");
			if(currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currXmlDataStr);
			}
			if(hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr);
			}
			if(allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allXmlDataStr);
			}
			errString = wfValData( currDom, hdrDom, allDom, objContext, editFlag, xtraParams );

		}//end of try
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}//end of catch
		
		return errString ;
	}//end of wfvalData() of xml string

	public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		String errString = "",sql = "";
		ResultSet rSet = null;
		Connection connObject = null;
		PreparedStatement pstmt = null;
		
		NodeList parentList = null;
		NodeList childList = null;
		int noOfChilds = 0;
		String childNodeName = "";
		Node childNode =null;
		boolean isNumber = true;
		String columnValue = "";
		int currentFormNo = 0,count = 0;
		
		try
		{
			connObject = getConnection();
			/*ConnDriver connDriver = new ConnDriver();
			connObject = connDriver.getConnectDB("DriverITM");
			connObject.setAutoCommit(false);
			connDriver = null;*/
			
			String userID = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "LoginCode" );
	
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}

			parentList = currDom.getElementsByTagName("Detail" + currentFormNo );
			childList = parentList.item( 0 ).getChildNodes();
			noOfChilds = childList.getLength();
			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item( ctr );
				childNodeName = childNode.getNodeName();
				
				System.out.println("childNodeName"+childNodeName);
				
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				if ( "prd_code".equalsIgnoreCase( childNodeName ) )
				{
					if (childNode.getFirstChild()==null)
					{
					   errString = getErrorString("prd_code","VTBLNKPRD",userID);
					   break;
					}
					else
					{
						isNumber = checkNumeric( columnValue );
						System.out.println("isNumber =["+isNumber+"]");
						if ( !isNumber )
						{
							errString = getErrorString("prd_code","NOTANUMBR1",userID);
							break;
						}
						
						/*sql = " SELECT COUNT(*) AS CNT FROM PERIOD WHERE TO_CHAR(TO_DATE(code,'yyyymm'),'mmyyyy') = ? ";
						pstmt = connObject.prepareStatement(sql);
						pstmt.setString(1, columnValue);
						rSet = pstmt.executeQuery();
						if (rSet.next())
						{
							count = rSet.getInt(1);
						}
						if (rSet != null) 
						{					
							rSet.close();rSet = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();pstmt = null;
						}*/
						
						/*if(count == 0)
						{
							errString =  itmDBAccessEJB.getErrorString("","VMPRDNTDF","","",connObject);
							break;
						}*/
					}
				}
				if ("gst_type".equalsIgnoreCase( childNodeName ) )
				{
					if (childNode.getFirstChild()==null)
					{
					   errString = getErrorString("gst_type","VTBLNKTYPE",userID);
					   break;
					}
				}
			}
		}	
		catch(Exception e)
		{
			System.out.println("Exception in GstDataIC  wfValData == >"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();rSet = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if( connObject != null && ! connObject.isClosed() )
				{
					connObject.close();connObject = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}//end of catch
		} //end of finally
		return (errString);
	}

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			System.out.println("Inside GstDataIC itemChanged");
			
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			valueXmlString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
        return valueXmlString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int currentFormNo = 0 ;
		String sql = "",currDateStr = "", loginSiteCode="",gstin="";
		Timestamp monthDate = null;
		Calendar calendar = new GregorianCalendar(); 
		String prdCode = "", fromDateStr = "", toDateStr = "";
		Date fromDate = null, toDate = null;
		
		try
		{   
			conn = getConnection();
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;*/
			
			
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			System.out.println("currentColumn["+currentColumn+"] && currentFormNo["+currentFormNo+"]");

			switch(currentFormNo)
			{
				case 1 :
				{
					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
					
					valueXmlString.append("<Detail1>\r\n");
				    if("itm_default".equalsIgnoreCase(currentColumn))
					{
				    	calendar.setTime(new Date());
						calendar.add(Calendar.MONTH, -1);
						currDateStr = sdf.format(calendar.getTime());
						
				    	monthDate = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
						
				    	/*sql = "SELECT TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') AS CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, monthDate);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							prdCode = rs.getString("CODE");
						}
						if(rs != null)
						{
							rs.close();rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();pstmt = null;
						}*/
				    	sql = "SELECT TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') AS PRD_CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
				    	pstmt = conn.prepareStatement(sql);
				    	pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateString(new Date(), genericUtility.getDBDateTimeFormat())));
				    	
				    	rs = pstmt.executeQuery();
				    	
				    	if(rs.next())
				    	{
				    		prdCode = rs.getString("PRD_CODE") == null ? "" : rs.getString("PRD_CODE");
				    	}
				    	if(pstmt != null)
				    	{
				    		pstmt.close();
				    		pstmt = null;
				    	}
				    	if(rs != null)
				    	{
				    		rs.close();
				    		rs = null;
				    	}
				    	
				    	if(prdCode != null && prdCode.trim().length() > 0)
				    	{
				    		sql = "SELECT FR_DATE, TO_DATE  FROM PERIOD WHERE TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') = ?";
					    	pstmt = conn.prepareStatement(sql);
					    	pstmt.setString(1, prdCode);
					    	
					    	rs = pstmt.executeQuery();
					    	
					    	if(rs.next())
					    	{
					    		fromDate = rs.getDate("FR_DATE");
					    		toDate = rs.getDate("TO_DATE");
					    	}
					    	if(pstmt != null)
					    	{
					    		pstmt.close();
					    		pstmt = null;
					    	}
					    	if(rs != null)
					    	{
					    		rs.close();
					    		rs = null;
					    	}
				    	}
				    	
				    	fromDateStr = sdf.format(fromDate);
				    	toDateStr = sdf.format(toDate);
				    	
				    	System.out.println("fromDateStr ["+fromDateStr+"] toDateStr ["+toDateStr+"]");
				    	
				    	sql="SELECT SITE_CODE,REG_NO FROM SITEREGNO WHERE REF_CODE IN ('GSTIN_NO')	AND SITE_CODE = ?" ;
				    	pstmt = conn.prepareStatement(sql);
				    	pstmt.setString(1, loginSiteCode);
				    	
				    	rs = pstmt.executeQuery();
				    	
				    	if(rs.next())
				    	{
				    		gstin = rs.getString("REG_NO");
				    	}
				    	if(pstmt != null)
				    	{
				    		pstmt.close();
				    		pstmt = null;
				    	}
				    	if(rs != null)
				    	{
				    		rs.close();
				    		rs = null;
				    	}
				    	
						
						valueXmlString.append("<prd_code>").append("<![CDATA["+prdCode+"]]>").append("</prd_code>");
						valueXmlString.append("<from_date>").append("<![CDATA["+fromDateStr+"]]>").append("</from_date>");
						valueXmlString.append("<to_date>").append("<![CDATA["+toDateStr+"]]>").append("</to_date>");
						valueXmlString.append("<gst_type>").append("").append("</gst_type>");
						valueXmlString.append("<site_code>").append("<![CDATA["+loginSiteCode+"]]>").append("</site_code>");
						valueXmlString.append("<gstin>").append("<![CDATA["+gstin+"]]>").append("</gstin>");
	                }
				    else if ("prd_code".equalsIgnoreCase(currentColumn))
				    {
				    	prdCode = genericUtility.getColumnValue("prd_code", dom1);
				    	
				    	prdCode = prdCode == null ? "" : prdCode;
				    	
				    	if(prdCode != null && prdCode.trim().length() > 0)
				    	{
				    		sql = "SELECT FR_DATE, TO_DATE  FROM PERIOD WHERE TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') = ?";
					    	pstmt = conn.prepareStatement(sql);
					    	pstmt.setString(1, prdCode);
					    	
					    	rs = pstmt.executeQuery();
					    	
					    	if(rs.next())
					    	{
					    		fromDate = rs.getDate("FR_DATE");
					    		toDate = rs.getDate("TO_DATE");
					    	}
					    	if(pstmt != null)
					    	{
					    		pstmt.close();
					    		pstmt = null;
					    	}
					    	if(rs != null)
					    	{
					    		rs.close();
					    		rs = null;
					    	}
				    	}
				    	
				    	if(fromDate != null)
				    	{
				    		fromDateStr = sdf.format(fromDate);
				    	}
				    	if(toDate != null)
				    	{
				    		toDateStr = sdf.format(toDate);
				    	}
				    	
				    	System.out.println("fromDateStr ["+fromDateStr+"] toDateStr ["+toDateStr+"]");
				    	
						
						valueXmlString.append("<prd_code>").append("<![CDATA["+prdCode+"]]>").append("</prd_code>");
						valueXmlString.append("<from_date>").append("<![CDATA["+fromDateStr+"]]>").append("</from_date>");
						valueXmlString.append("<to_date>").append("<![CDATA["+toDateStr+"]]>").append("</to_date>");
				    }
				    	valueXmlString.append("</Detail1>");
				}     	
	            break;
			} 
			
			valueXmlString.append("</Root>");
		}
		catch(Exception e)	
		{
			System.out.println("Exception inside GSTDataIC===>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}	
				if(rs != null)
				{	
					rs.close();rs = null;
				}	
				if(conn != null)
				{	
					conn.close();conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}
	
	private boolean checkNumeric( String noOfLabel ) throws Exception
	{
		char[] cArray = noOfLabel.toCharArray();
		boolean isNumber = true;
		for(int i = 0; i < cArray.length;i++) 
		{
			if( !Character.isDigit(cArray[i]) ) 
			{
				isNumber = false;
			}
		}
		return isNumber;
	}
}
