package ibase.e12ria.e12widgets.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;

/**
 * @author Harshada
 * Description: Reads log file from android sdcard.
 */
public class AndroidReader {

	public static class Result extends JavaScriptObject {
		protected Result() {
		}

		public final native String getLog() /*-{

			return this.log;
		}-*/;
	}

	public static interface Callback {
		void onError(Exception e);
		void onSuccess(Result result);
	}

	public native static JSONObject readFiles(String fileName, Callback callback)/*-{
		var successCallback = function(result) {
			callback.@ibase.e12ria.e12widgets.client.AndroidReader.Callback::onSuccess(Libase/e12ria/e12widgets/client/AndroidReader$Result;)(result);
		};
		
		$wnd.plugins.logReader.readFile(fileName, successCallback);
	}-*/;

	protected void throwPluginNotFoundException(Callback callback) {
		NullPointerException nullPointerException = new NullPointerException(
				"window.plugins is undefined");
		callback.onError(nullPointerException);
	}

}
