package ibase.webitm.ejb.mfg.adv;
import ibase.utility.E12GenericUtility;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.ITMDBAccessEJB;

import java.rmi.RemoteException;

import javax.naming.InitialContext;
import javax.ejb.Stateless;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;

import javax.xml.rpc.ParameterMode;

import java.text.SimpleDateFormat;

//import ibase.utility.GenericUtility;
import ibase.webitm.ejb.MasterStatefulLocal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;


@Stateless
public class WoClosePobConf extends ActionHandlerEJB implements WoClosePobConfLocal,WoClosePobConfRemote
{
	E12GenericUtility genericUtility= new  E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	public String confirm(String tranID, String xtraParams, String forcedFlag) throws RemoteException, ITMException
	{
		String retString = "";
		boolean isConn = false;
		Connection conn = null;

		try
		{
			retString = confirm(tranID, xtraParams, forcedFlag, conn, isConn);

			if (retString != null && retString.length() > 0)
			{
				throw new Exception("Exception while calling confirm for tran  Id:[" + tranID + "]");
			}
		} catch (Exception exception)
		{
			System.out.println("Exception in [WoClosePobConf] getCurrdateAppFormat " + exception.getMessage());
		}
		return retString;
	}

	public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn, boolean connStatus) throws RemoteException, ITMException
	       {
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs = null;
		String workOrder = null;
		String siteCode="";
		String errCode = "";
		String errString = "";
		String chgUser = "";
		String userId = null;
		String chgTerm = "";
		String sql = null;
		String remarks="";
		String status = "",loginEmpCode="",confirm="";
		int cnt = 0,checkCount=0,updateCount=0;
		boolean updateFlag = false;
		Timestamp sysDate = null;
		String tranID="";
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		try {
			if (conn == null)
			{
				ConnDriver connDriver = null;
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				connDriver = null;
				connStatus = true;
			}
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			userId = chgUser;
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDateStr = sdf.format(currentDate.getTime());
			
			sysDate = Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
	
			sql = "select Status , WORK_ORDER from Wo_Close where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				confirm = rs.getString("Status");
				workOrder=rs.getString("WORK_ORDER");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("confirmed...[" + confirm + "]");
			System.out.println("WORK_ORDER...[" + workOrder + "]");
			if ("C".equalsIgnoreCase(confirm))
			{
				System.out.println("Wo CLose  already confirm");
				errString = itmDBAccessEJB.getErrorString("", "VTRCONF1", "", "", conn);
				return errString;
			}
			else
			{ 
				
				remarks="WorkOrder Close Through WorkOrder Close Pull Out Batches";      
				sql = "update Workorder set Status = 'C', REMARKS = ?, Status_Date = ? where WORK_ORDER = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,remarks);
				pstmt.setTimestamp(2,sysDate);
				pstmt.setString(3,workOrder);
				cnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				System.out.println("@@@@@@ cnt...[" + cnt + "]");
				if (cnt > 0)
				{
					System.out.println(">>>>>>>>>>>>>>>>Count from update:"+ cnt);
				}
				sql = "update WO_CLOSE set STATUS='C', emp_code__aprv=? where tran_id=?";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, loginEmpCode);		// Log in employee code
				pstmt1.setString(2, tranId);
				updateCount = pstmt1.executeUpdate();
				pstmt1.close();
				pstmt = null;
				System.out.println("Update count :- [" + updateCount + "]");
				if(updateCount>0)
				{
					System.out.println("WO_CLOSEis confirm !!");
					errString = itmDBAccessEJB.getErrorString("", "VTCONFIRM", "", "", conn);	//Confirm successfully
				}
				
			}
			System.out.println("@@@@@@Error String is" + errString);
			if(errString.indexOf("VTCONFIRM") > -1)
			{
				conn.commit();  
				
			}
			else
			{
				conn.rollback();	
			}
		}		catch(Exception e)
		{
			System.out.println("Exception :WoClosePobConf :Confirm(String xmlString2, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("Closing Connection....");
			try
			{
				conn.close();
				conn = null;
			}
			catch(Exception e)
			{
				errString = e.getMessage();
				e.printStackTrace();
				return errString ;
			}
		}
		
		
		/*catch (Exception e)
		{
			if (conn != null)
			{
				try
				{
					conn.rollback();
				} catch (java.sql.SQLException e1)
				{
					e1.printStackTrace();
				}
			}
			System.out.println("Exception : " + e);
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (errString != null && errString.trim().length() > 0)
				{
					if (conn != null && !conn.isClosed() && connStatus)
					{
						if (errString.indexOf("VTCONFIRM") > -1)
						{
							conn.commit();
						} else
						{
							conn.rollback();
						}
						conn.close();
						conn = null;
					}
				}
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e)
			{
				System.out.println("Exception : " + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}*/
		return errString;
	}

	@Override
	public String getData(String arg0, String arg1, String arg2, String arg3)
			throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getData(Document arg0, Document arg1, String arg2, String arg3)
			throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String process() throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String process(Document arg0, Document arg1, String arg2, String arg3)
			throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String process(String arg0, String arg1, String arg2, String arg3)
			throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void remove() {
		// TODO Auto-generated method stub
		
	}

}