package ibase.dashboard.gst.ejb;

import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map.Entry;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

/**
 * Session Bean implementation class ProfitLossBalSheet
 */
@Stateless

public class TransactionInOutEJB extends ValidatorEJB  implements TransactionInOutEJBLocal, TransactionInOutEJBRemote 
{
	 @SuppressWarnings("unchecked")
	 @Override
	 public JSONObject getOutTransactionTypeSummary(String dataSourceName,String month, String year, String status, String gstCode, String sessionSiteCode ) throws RemoteException, ITMException
	 {
   		JSONObject rawDataTranTypeSummJson = new JSONObject();
   		JSONObject rowData             = null;
   		ResultSet rs                   = null;
   		PreparedStatement pstmt        = null;
   		Connection conn                = null;
   		ConnDriver connDriver          = new ConnDriver();
   		int count  					   = 0, rowCount = 0;
   		String sql 					   = "";
   		String periodCode = "", prvFinancialYear = "", currentFinancialYear = "";
   		String transactionType = "", turnover = null, tranCount = "", tranAmount = "", tran_image = "";
   		StringBuffer rowBuffer = null;
   		String statusSQLString = "", gstCodeSQLString = "";
   		DashboardUtility dashboardUtility = null;
   		try
   		{
   			conn       = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;
   			
   			month = checkNull(month);
   			year = checkNull(year);
   			System.out.println("Selected month: "+month+" year: "+year+" status: "+status+" gstCode: "+gstCode);
   			/*sql = "Select Acct_Prd From Period Where To_Date(Sysdate) Between Fr_Date and To_Date";
			pstmt = conn.prepareStatement(sql);
   			rs = pstmt.executeQuery();
   			if (rs.next())
   			{
   				currentFinancialYear = checkNull(rs.getString("Acct_Prd"));
   			}
   			rs.close();
   			rs = null;
   			pstmt.close();
   			pstmt = null;*/
   			System.out.println("================currentFinancialYear: "+currentFinancialYear);
   			if(("".equalsIgnoreCase(month)) && ("".equalsIgnoreCase(year)))
   			{
   				sql = "Select Acct_Prd,Code,Descr From Period Where To_Date(Sysdate) Between Fr_Date and To_Date";
   				pstmt = conn.prepareStatement(sql);
   	   			rs = pstmt.executeQuery();
   	   			if (rs.next())
   	   			{
   	   				periodCode = checkNull(rs.getString("Code"));
   	   				prvFinancialYear   = checkNull(rs.getString("Acct_Prd"));
   	   				
   	   				String monthLocal = periodCode.substring(0, 2);
	   				if(Integer.parseInt(monthLocal)>12)
	   				{
	   					String yearLocal = periodCode.substring(0, 4);
	   					monthLocal       = periodCode.substring(4);
	   					periodCode  = monthLocal + yearLocal;
	   				}
	   				System.out.println("periodCode: "+periodCode);
   	   			}
   	   			rs.close();
   	   			rs = null;
   	   			pstmt.close();
   	   			pstmt = null;
   	   		}
   			else
   			{
   				if(month.length()>2)
   				{
	   				SimpleDateFormat inputFormat = new SimpleDateFormat("MMMM");
	   				Calendar cal = Calendar.getInstance();
	   				cal.setTime(inputFormat.parse(month));
	   				SimpleDateFormat outputFormat = new SimpleDateFormat("MM");
	   				month = outputFormat.format(cal.getTime());
   				}
   				String date = month+"/"+month+"/"+year;
   				Timestamp timeStampFormat = getTimeStamp(date);
   				sql = "Select Acct_Prd From Period Where to_char(?,'dd-mon-yy') Between Fr_Date and To_Date";
   				pstmt = conn.prepareStatement(sql);
   				pstmt.setTimestamp(1, timeStampFormat);
   	   			rs = pstmt.executeQuery();
   	   			if (rs.next())
   	   			{
   	   				periodCode = month+""+year;
   	   				prvFinancialYear   = checkNull(rs.getString("Acct_Prd"));
   	   				System.out.println("periodCode: "+periodCode);
   	   			}
   	   			rs.close();
	   			rs = null;
	   			pstmt.close();
	   			pstmt = null;
   			}
   			System.out.println("============periodCode: "+periodCode+" acctCode: "+prvFinancialYear+" month: "+month);
			
			/*if(Integer.parseInt(prvFinancialYear)<Integer.parseInt(currentFinancialYear))
			{
				String site_code = "", fin_entity = "";
				sql = "select site_code, fin_entity, facility_code from site where site_code='"+sessionSiteCode+"' ";
   				pstmt = conn.prepareStatement(sql);
   	   			rs = pstmt.executeQuery();
   	   			if (rs.next())
   	   			{
   	   				site_code = checkNull(rs.getString("site_code"));
   	   				fin_entity   = checkNull(rs.getString("fin_entity"));
   	   			}
   	   			rs.close();
	   			rs = null;
	   			pstmt.close();
	   			pstmt = null;
	   			sql = "select reg_no from siteregno where ref_code='GST_GT' and site_code='"+site_code+"' and fin_entity = '"+fin_entity+"' ";
	   			pstmt = conn.prepareStatement(sql);
   	   			rs = pstmt.executeQuery();
   	   			if (rs.next())
   	   			{
   	   				turnover = checkNull(rs.getString("reg_no"));
   	   			}
   	   			rs.close();
	   			rs = null;
	   			pstmt.close();
	   			pstmt = null;
			}*/
			
			status = checkNull(status);
			dashboardUtility = new DashboardUtility();
			String statusUtility = dashboardUtility.getCommaSeparated(status);
			if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
			{
				statusSQLString = " and SUBMIT_STATUS in('P','T','S') ";
			}
			else
			{
				statusSQLString = " and SUBMIT_STATUS in ("+statusUtility+") ";
			}
			gstCode = checkNull(gstCode);
			String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
			if("".equalsIgnoreCase(gstCode))
			{
				gstCodeSQLString = " ";
			}
			/*else if(gstCode.equalsIgnoreCase("Unregistered"))
			{
				gstCodeSQLString = " and TAX_REG_NO is null ";
			}*/
			else
			{
				gstCodeSQLString = " and TAX_REG_NO in ("+gstCodeUtility+") ";
			}
			String userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator;
   			
			/*sql = "select 'Invoice' as Transaction,count(1) as cnt , sum(amount) as amount from gst_data_hdr " +
   				"where rec_type='1' and tran_type in('01','02','03','04','05','08','09','10','11','12','13','14') and prd_code='"+periodCode+"' " +
   				"and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all select 'Debit Note' as Transaction,count(1) " +
   				"as cnt, sum(amount) as amount from gst_data_hdr where rec_type='1' and tran_type in ('30','32','34','36') and " +
   				"prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+"  union all " +
				"select 'Credit Note' as Transaction,count(1) as cnt, sum(amount)as amount from " +
				"gst_data_hdr where rec_type='1' and tran_type in ('29','31','33','35') and " +
				"prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all select 'Nil Rate' " +
				"as Transaction,count(1)as cnt, sum(amount) as amount from gst_data_hdr where rec_type='1' and " +
				"tran_type in ('15','16','17','18','19','20','21','22','23','24','25','26') and prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all " +
				"select 'Export' as Transaction,count(1)as cnt, sum(amount)as amount from gst_data_hdr " +
				"where rec_type='1' and tran_type in ('05','06','27','28') and prd_code='"+periodCode+"' and " +
				"site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all  select 'Advance Tax Paid' as Transaction,count(1)as" +
				" cnt, sum(amount)as amount from gst_data_hdr where rec_type='1' and tran_type in ('14') " +
				"and prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString;
   			*/
			sql = "select transaction, sum(cnt) as cnt, sum(amount) as amount from (" +
				"select (case when tran_type in('01','03','04','05','08','09','10','11','12','13','14') " +
				"then 'Invoice' when tran_type in('02') then 'Outward RCM' when " +
				"tran_type in ('30','32','34','36') then 'Debit note' when tran_type in ('29','31','33','35') " +
				"then 'Credit note' when tran_type in ('15','16','17','18','19','20','21','22','23','24','25','26')" +
				" then 'Nil rated' when tran_type in ('06','07','27','28')  then 'Export' " +
				"when tran_type in ('41','42','45','46') then 'Advance receipt' when " +
				"tran_type in ('43','44','47','48') then 'Advance adjusted'   " +
				"else 'GST type is not available in database' end) as Transaction,1 as cnt,amount " +
				"from gst_data_hdr where rec_type='1' and prd_code='"+periodCode+"' and " +
				"site_code='"+sessionSiteCode+"' "+ statusSQLString + gstCodeSQLString+") group by transaction";
   			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
   			rs    = pstmt.executeQuery();
   			rowCount = 0;
   			rs.last();
			rowCount = rs.getRow();
			rs.beforeFirst();
			rowBuffer = new StringBuffer();
			if(rowCount == 0)
			{
				rowBuffer = new StringBuffer("<table  id='htmlTable' cellpadding='2' align='center'><tr><td align = 'center' class='gwt-ScrollTable'>No Data to Display</td></tr>");
			}
   			
			rowData = new JSONObject();
   			while (rs.next())
			{
   				rowData = new JSONObject();
   				transactionType = checkNumberNull(rs.getString("transaction")).trim();
   				tranCount 		= checkNumberNull(rs.getString("cnt")).trim();
   				tranAmount		= checkNumberNull(rs.getString("amount")).trim();
   				File file = new File(userImagePath+transactionType+".png");
				if(file.exists())
				{
					tran_image = "<img class='cardProdImg2' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+transactionType+".png'/>";
				}
				else
				{
					String[] splited = transactionType.split(" ");
					System.out.println("::::::::::::::::splited getOutTranTypeSummary : "+Arrays.toString(splited));
					String defaultUserImg = ""+splited[0].charAt(0);
					if(splited.length==2)
					{
						String lastWord = ""+splited[1].charAt(0);
						System.out.println("lastWord  getTodayAgenda :"+lastWord);
						defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
					}
					else if(splited.length>2)
					{
						defaultUserImg = defaultUserImg + splited[splited.length - 1].charAt(0);
					}
					defaultUserImg = defaultUserImg.toUpperCase();
					System.out.println("defaultUserImg :"+defaultUserImg);
					
					tran_image = "<span class='defaultUserImg1'> "+defaultUserImg+" </span>";
				}
				String updatedTranType = transactionType.replace(" ", "%20");
				gstCode = gstCode.replace(" ", "%20");
				if(count == 0)
				{
					rowData.put("cardBorderTop","border-top: 1px solid #E8E8E8;");
				}
				else
				{
					rowData.put("cardBorderTop","");
				}
				if(count == rowCount-1)
				{
					rowData.put("BottomCSS","border-bottom: 1px solid #E8E8E8;");
					rowData.put("tableForSpace","<table style='height:10px;'></table>");
				}
				else
				{
					rowData.put("BottomCSS","border-bottom: 1px solid #E8E8E8;");
					rowData.put("tableForSpace","");
					
				}
				rowData.put("tran_image", tran_image);
				rowData.put("yearCode", periodCode);
				rowData.put("orgTran", transactionType);
				rowData.put("updatedTran", updatedTranType);
				rowData.put("tranCount", tranCount);
				rowData.put("tranAmount", tranAmount);
				rowData.put("status", status);
				rowData.put("gstCode", gstCode);
   				/*if(turnover == null)
   				{*/
   					rowData.put("turnover",checkNumberNull(rs.getString("amount")));
   				/*}
   				else
   				{
   					rowData.put("turnover",turnover);
   					turnover = "";
   				}*/
				rawDataTranTypeSummJson.put(count, rowData);
				count++;
   			}
   			
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			}
   			catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataTranTypeSummJson;
   	 }
	 
	 @SuppressWarnings("unchecked")
	 @Override
	 public JSONObject getInTransactionTypeSummary(String dataSourceName,String month, String year, String status, String gstCode, String sessionSiteCode ) throws RemoteException, ITMException
	 {
	   		JSONObject rawDataTranTypeSummJson = new JSONObject();
	   		JSONObject rowData             = null;
	   		ResultSet rs                   = null;
	   		PreparedStatement pstmt        = null;
	   		Connection conn                = null;
	   		ConnDriver connDriver          = new ConnDriver();
	   		int count  					   = 0, rowCount = 0;
	   		String sql 					   = "";
	   		String periodCode = "", prvFinancialYear = "", currentFinancialYear = "";
	   		String transactionType = "", turnover = null, tranCount = "", tranAmount = "", tran_image = "";
	   		StringBuffer rowBuffer = null;
	   		String statusSQLString = "", gstCodeSQLString = "";
	   		DashboardUtility dashboardUtility = null;
	   		try
	   		{
	   			conn       = connDriver.getConnectDB(dataSourceName);
	   			connDriver = null;
	   			
	   			month = checkNull(month);
	   			year = checkNull(year);
	   			System.out.println("Selected month: "+month+" year: "+year+" status: "+status+" gstCode: "+gstCode);
	   			/*sql = "Select Acct_Prd From Period Where To_Date(Sysdate) Between Fr_Date and To_Date";
				pstmt = conn.prepareStatement(sql);
	   			rs = pstmt.executeQuery();
	   			if (rs.next())
	   			{
	   				currentFinancialYear = checkNull(rs.getString("Acct_Prd"));
	   			}
	   			System.out.println("================currentFinancialYear: "+currentFinancialYear);
	   			rs.close();
	   			rs = null;
	   			pstmt.close();
	   			pstmt = null;*/
	   			if(("".equalsIgnoreCase(month)) && ("".equalsIgnoreCase(year)))
	   			{
	   				sql = "Select Acct_Prd,Code,Descr From Period Where To_Date(Sysdate) Between Fr_Date and To_Date";
	   				pstmt = conn.prepareStatement(sql);
	   	   			rs = pstmt.executeQuery();
	   	   			if (rs.next())
	   	   			{
	   	   				periodCode = checkNull(rs.getString("Code"));
	   	   				prvFinancialYear   = checkNull(rs.getString("Acct_Prd"));
	   	   				
	   	   				String monthLocal = periodCode.substring(0, 2);
		   				if(Integer.parseInt(monthLocal)>12)
		   				{
		   					String yearLocal = periodCode.substring(0, 4);
		   					monthLocal       = periodCode.substring(4);
		   					periodCode  = monthLocal + yearLocal;
		   				}
		   				System.out.println("periodCode: "+periodCode);
	   	   			}
	   	   			rs.close();
	   	   			rs = null;
	   	   			pstmt.close();
	   	   			pstmt = null;
	   	   		}
	   			else
	   			{
	   				if(month.length()>2)
	   				{
		   				SimpleDateFormat inputFormat = new SimpleDateFormat("MMMM");
		   				Calendar cal = Calendar.getInstance();
		   				cal.setTime(inputFormat.parse(month));
		   				SimpleDateFormat outputFormat = new SimpleDateFormat("MM");
		   				month = outputFormat.format(cal.getTime());
	   				}
	   				String date = month+"/"+month+"/"+year;
	   				Timestamp timeStampFormat = getTimeStamp(date);
	   				sql = "Select Acct_Prd From Period Where to_char(?,'dd-mon-yy') Between Fr_Date and To_Date";
	   				pstmt = conn.prepareStatement(sql);
	   				pstmt.setTimestamp(1, timeStampFormat);
	   	   			rs = pstmt.executeQuery();
	   	   			if (rs.next())
	   	   			{
	   	   				periodCode = month+""+year;
	   	   				prvFinancialYear   = checkNull(rs.getString("Acct_Prd"));
	   	   				System.out.println("periodCode: "+periodCode);
	   	   			}
	   	   			rs.close();
		   			rs = null;
		   			pstmt.close();
		   			pstmt = null;
	   			}
	   			System.out.println("============periodCode: "+periodCode+" acctCode: "+prvFinancialYear+" month: "+month);
				
				/*if(Integer.parseInt(prvFinancialYear)<Integer.parseInt(currentFinancialYear))
				{
					String site_code = "", fin_entity = "";
					sql = "select site_code, fin_entity, facility_code from site where site_code='"+sessionSiteCode+"' ";
	   				pstmt = conn.prepareStatement(sql);
	   	   			rs = pstmt.executeQuery();
	   	   			if (rs.next())
	   	   			{
	   	   				site_code = checkNull(rs.getString("site_code"));
	   	   				fin_entity   = checkNull(rs.getString("fin_entity"));
	   	   			}
	   	   			rs.close();
		   			rs = null;
		   			pstmt.close();
		   			pstmt = null;
		   			sql = "select reg_no from siteregno where ref_code='GST_GT' and site_code='"+site_code+"' and fin_entity = '"+fin_entity+"' ";
		   			pstmt = conn.prepareStatement(sql);
	   	   			rs = pstmt.executeQuery();
	   	   			if (rs.next())
	   	   			{
	   	   				turnover = checkNull(rs.getString("reg_no"));
	   	   			}
	   	   			rs.close();
		   			rs = null;
		   			pstmt.close();
		   			pstmt = null;
				}*/
				
				status = checkNull(status);
				dashboardUtility = new DashboardUtility();
				String statusUtility = dashboardUtility.getCommaSeparated(status);
				if(("All".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
				{
					statusSQLString = " and SUBMIT_STATUS in('P','T','S') ";
				}
				else
				{
					statusSQLString = " and SUBMIT_STATUS in ("+statusUtility+") ";
				}
				gstCode = checkNull(gstCode);
				String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
				if("".equalsIgnoreCase(gstCode))
				{
					gstCodeSQLString = " ";
				}
				/*else if(gstCode.equalsIgnoreCase("Unregistered"))
				{
					gstCodeSQLString = " and TAX_REG_NO is null ";
				}*/
				else
				{
					gstCodeSQLString = " and TAX_REG_NO in ("+gstCodeUtility+") ";
				}
				String userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator;
	   			
				/*sql = "select 'Invoice' as Transaction,count(1) as cnt , sum(amount) as amount from gst_data_hdr " +
   				"where rec_type='2' and tran_type in('01','02','03','04','05','08','09','10','11','12','13','14') and prd_code='"+periodCode+"' " +
   				"and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all select 'Debit Note' as Transaction,count(1) " +
   				"as cnt, sum(amount) as amount from gst_data_hdr where rec_type='2' and tran_type in ('30','32','34','36') and " +
   				"prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+"  union all " +
				"select 'Credit Note' as Transaction,count(1) as cnt, sum(amount)as amount from " +
				"gst_data_hdr where rec_type='2' and tran_type in ('29','31','33','35') and " +
				"prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all select 'Nil Rate' " +
				"as Transaction,count(1)as cnt, sum(amount) as amount from gst_data_hdr where rec_type='2' and " +
				"tran_type in ('15','16','17','18','19','20','21','22','23','24','25','26') and prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all " +
				"select 'Export' as Transaction,count(1)as cnt, sum(amount)as amount from gst_data_hdr " +
				"where rec_type='2' and tran_type in ('05','06','27','28') and prd_code='"+periodCode+"' and " +
				"site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all  select 'Advance Tax Paid' as Transaction,count(1)as" +
				" cnt, sum(amount)as amount from gst_data_hdr where rec_type='2' and tran_type in ('14') " +
				"and prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString;*/
	   			
				sql = "select transaction, sum(cnt) as cnt, sum(amount) as amount from (" +
					"select (case when tran_type in('01','03','04','05','08','09','10','11','12','13','14') " +
					"then 'Invoice' when tran_type in('02') then 'Inward RCM' when " +
					"tran_type in ('30','32','34','36') then 'Debit note' when tran_type in ('29','31','33','35') " +
					"then 'Credit note' when tran_type in ('15','16','17','18','19','20','21','22','23','24','25','26')" +
					" then 'Nil rated' when tran_type in ('06','07','27','28')  then 'Export' " +
					"when tran_type in ('41','42','45','46') then 'Advance receipt' when " +
					"tran_type in ('43','44','47','48') then 'Advance adjusted'   " +
					"else 'GST type is not available in database' end) as Transaction,1 as cnt,amount " +
					"from gst_data_hdr where rec_type='2' and prd_code='"+periodCode+"' and " +
					"site_code='"+sessionSiteCode+"' "+ statusSQLString + gstCodeSQLString+") group by transaction";
				
	   			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
	   			rs    = pstmt.executeQuery();
	   			rowCount = 0;
	   			rs.last();
				rowCount = rs.getRow();
				rs.beforeFirst();
				rowBuffer = new StringBuffer();
				if(rowCount == 0)
				{
					rowBuffer = new StringBuffer("<table  id='htmlTable' cellpadding='2' align='center'><tr><td align = 'center' class='gwt-ScrollTable'>No Data to Display</td></tr>");
				}
	   			
				rowData = new JSONObject();
	   			while (rs.next())
				{
	   				rowData = new JSONObject();
	   				transactionType = checkNull(rs.getString("transaction")).trim();
	   				tranCount 		= checkNumberNull(rs.getString("cnt")).trim();
	   				tranAmount		= checkNumberNull(rs.getString("amount")).trim();
	   				File file = new File(userImagePath+transactionType+".png");
					if(file.exists())
					{
						tran_image = "<img class='cardProdImg2' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+transactionType+".png'/>";
					}
					else
					{
						String[] splited = transactionType.split(" ");
						System.out.println("::::::::::::::::splited getOutTranTypeSummary : "+Arrays.toString(splited));
						String defaultUserImg = ""+splited[0].charAt(0);
						if(splited.length==2)
						{
							String lastWord = ""+splited[1].charAt(0);
							System.out.println("lastWord  getTodayAgenda :"+lastWord);
							defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
						}
						else if(splited.length>2)
						{
							defaultUserImg = defaultUserImg + splited[splited.length - 1].charAt(0);
						}
						defaultUserImg = defaultUserImg.toUpperCase();
						System.out.println("defaultUserImg :"+defaultUserImg);
						
						tran_image = "<span class='defaultUserImg1'> "+defaultUserImg+" </span>";
					}
					String updatedTranType = transactionType.replace(" ", "%20");
					gstCode = gstCode.replace(" ", "%20");
					System.out.println("============rowCount: "+rowCount+" count: "+count);
					if(count == 0)
					{
						rowData.put("cardBorderTop","border-top: 1px solid #E8E8E8;");
					}
					else
					{
						rowData.put("cardBorderTop","");
					}
					if(count == rowCount-1)
					{
						rowData.put("BottomCSS","border-bottom: 1px solid #E8E8E8;");
						rowData.put("tableForSpace","<table style='height:10px;'></table>");
					}
					else
					{
						rowData.put("BottomCSS","border-bottom: 1px solid #E8E8E8;");
						rowData.put("tableForSpace","");
						
					}
					rowData.put("tran_image", tran_image);
					rowData.put("yearCode", periodCode);
					rowData.put("orgTran", transactionType);
					rowData.put("updatedTran", updatedTranType);
					rowData.put("tranCount", tranCount);
					rowData.put("tranAmount", tranAmount);
					rowData.put("status", status);
					rowData.put("gstCode", gstCode);
	   				/*if(turnover == null)
	   				{*/
	   					rowData.put("turnover",checkNumberNull(rs.getString("amount")));
	   				/*}
	   				else
	   				{
	   					rowData.put("turnover",turnover);
	   					turnover = "";
	   				}*/
					rawDataTranTypeSummJson.put(count, rowData);
					count++;
	   			}
	   			
	   		}
	   		catch (Exception e)
	   		{
	   			e.printStackTrace();
	   			throw new ITMException(e);
	   		}
	   		finally
	   		{
	   			try
	   			{
	   				if (conn != null)
	   				{
	   					if (rs != null)
	   					rs.close();
	   					rs = null;
	   					if (pstmt != null)
	   					pstmt.close();
	   					pstmt = null;
	   					conn.close();
	   					conn = null;
	   				}
	   				conn = null;
	   			}
	   			catch (Exception d)
	   			{
	   				d.printStackTrace();
	   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
	   				throw new ITMException(d);
	   			}
	   		}
	   		return rawDataTranTypeSummJson;
	   	 }
	 
	 
	 @SuppressWarnings("unchecked")
	 @Override
	 public JSONObject getTransactionTypeDetail(String dataSourceName,String periodCode, String sessionSiteCode, String titleTran, String tranType,String status,String gstCode) throws RemoteException, ITMException
	 {
	   		JSONObject rawDataTranTypeSummJson = new JSONObject();
	   		JSONObject rowData             = null;
	   		ResultSet rs                   = null;
	   		PreparedStatement pstmt        = null;
	   		Connection conn                = null;
	   		ConnDriver connDriver          = new ConnDriver();
	   		int count  					   = 0, rowCount = 0;
	   		String sql = ""; 
	   		int rec_type = 0;
	   		String statusSQLString = "",gstCodeSQLString = "";
	   		DashboardUtility dashboardUtility = null;
	   		StringBuffer rowBuffer = null;
	   		try
	   		{
	   			System.out.println("Selected transaction type is: "+titleTran+ " sessionSiteCode: "+sessionSiteCode+" tranType: "+tranType+" periodCode: "+periodCode);
	   			conn       = connDriver.getConnectDB(dataSourceName);
	   			connDriver = null;
	   			if(tranType.equalsIgnoreCase("Outward"))
	   			{
	   				rec_type = 1;
	   			}
	   			else
	   			{
	   				rec_type = 2;
	   			}
	   			status = checkNull(status);
				dashboardUtility = new DashboardUtility();
				String statusUtility = dashboardUtility.getCommaSeparated(status);
				if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in('P','T','S') ";
				}
				else
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in ("+statusUtility+") ";
				}
				gstCode = checkNull(gstCode);
				String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
				if("".equalsIgnoreCase(gstCode))
				{
					gstCodeSQLString = " ";
				}
				/*else if(gstCode.equalsIgnoreCase("Unregistered"))
				{
					gstCodeSQLString = " and gsthdr.TAX_REG_NO is null ";
				}*/
				else
				{
					gstCodeSQLString = " and gsthdr.TAX_REG_NO in ("+gstCodeUtility+") ";
				}
				String tran_type = "";
				titleTran = titleTran.trim();
	   			if(titleTran.trim().equalsIgnoreCase("Invoice"))
	   			{
	   				tran_type = "and   gsthdr.tran_type in('01','03','04','05','08','09','10','11','12','13','14')  ";
	   			}
	   			else if(titleTran.trim().equalsIgnoreCase("Outward RCM"))
	   			{
	   				tran_type = "and   gsthdr.tran_type in('02')  ";
	   			}
	   			else if(titleTran.trim().equalsIgnoreCase("Debit note"))
	   			{
	   				tran_type = "and   gsthdr.tran_type in('30','32','34','36')  ";
	   			}
	   			else if(titleTran.trim().equalsIgnoreCase("Credit note"))
	   			{
	   				tran_type = "and   gsthdr.tran_type in('29','31','33','35')  ";
	   			}
	   			else if(titleTran.trim().equalsIgnoreCase("Nil rated"))
	   			{
	   				tran_type = "and   gsthdr.tran_type in('15','16','17','18','19','20','21','22','23','24','25','26')  ";
	   			}
	   			else if(titleTran.trim().equalsIgnoreCase("Export"))
	   			{
	   				tran_type = "and   gsthdr.tran_type in('06','07','27','28')  ";
	   			}
	   			else if(titleTran.trim().equalsIgnoreCase("Advance receipt"))
	   			{
	   				tran_type = "and   gsthdr.tran_type in('41','42','45','46')  ";
	   			}
	   			else if(titleTran.trim().equalsIgnoreCase("Advance adjusted"))
	   			{
	   				tran_type = "and   gsthdr.tran_type in('43','44','47','48')  ";
	   			}
	   			sql = "select '"+titleTran+"' as Transaction,gsthdr.tran_id,gsthdr.doc_no,to_char(gsthdr.tran_date,'dd-MON-yy') as tran_date," +
	   				 "sum(gstdet.taxable_amt) as taxable_amt,sum(gstdet.igst_amt) as igst_amt,sum(gstdet.cgst_amt) as cgst_amt," +
	   				 "sum(gstdet.sgst_amt) as sgst_amt,sum(gstdet.cess_amt) as cess_amt from gst_data_hdr gsthdr inner join  " +
	   				 "gst_data_det gstdet on gsthdr.tran_id=gstdet.tran_id where gsthdr.rec_type='"+rec_type+"'  " +tran_type+
	   				 " and gsthdr.prd_code='"+periodCode+"' and   gsthdr.SITE_CODE='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+
	   				 " group by gsthdr.tran_id, gsthdr.doc_no,gsthdr.tran_date order by gsthdr.tran_id";
	   			pstmt = conn.prepareStatement(sql);
	   			rs = pstmt.executeQuery();
	   			while (rs.next())
				{
	   				rowData = new JSONObject();
	   				rowData.put("doc_no",checkNull(rs.getString("doc_no")));
	   				rowData.put("tran_date",checkNumberNull(rs.getString("tran_date")));
	   				rowData.put("taxable_amt",checkNumberNull(rs.getString("taxable_amt")));
	   				rowData.put("igst_amt",checkNumberNull(rs.getString("igst_amt")));
	   				rowData.put("cgst_amt",checkNumberNull(rs.getString("cgst_amt")));
	   				rowData.put("sgst_amt",checkNumberNull(rs.getString("sgst_amt")));
	   				rowData.put("cess_amt",checkNumberNull(rs.getString("cess_amt")));
	   				
	   				rawDataTranTypeSummJson.put(count, rowData);
	   	   			count++;
				}
	   			/*pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
	   			rs    = pstmt.executeQuery();
	   			rowCount = 0;
	   			rs.last();
				rowCount = rs.getRow();
				rs.beforeFirst();
				rowBuffer = new StringBuffer();
				if(rowCount != 0)
				{
					rowBuffer = new StringBuffer("<table class = 'mtBorderWhite' border='1' id='htmlTable' cellpadding='2' style='line-height:35px;'>"+
		                        "<thead class='mtBackgroundWhitethead'><tr style='border-bottom: 1px solid #e8e8e8; border-top: 1px solid #e8e8e8;'><td class = 'tblHeaderLeft' style='width: 10%;'>Tran date</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 10%;'>Document number</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 10%;'>Taxable amount</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 10%;'>IGST amount</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 10%;'>CGST amount</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 10%;'>SGST amount</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 10%;'>CESS amount</td></tr></thead><tbody class='mtBackgroundWhitetbody'>");
				}
	   			else
				{
					rowBuffer = new StringBuffer("<table  id='htmlTable' cellpadding='2' align='center'><tbody><tr><td align = 'center' class='gwt-ScrollTable'>No Data to Display</td></tr>");
				}
	   			while (rs.next())
				{
	   				rowBuffer.append("<tr class='mtBackgroundWhitetbodytr' style='border-bottom: 1px solid #e8e8e8;'><td class='tdCardPadding'>"+checkNull(rs.getString("tran_date"))+"</td><td align='right' class='tdCardPadding'>"+checkNull(rs.getString("doc_no"))+"</td><td align='right' class='tdCardPadding'>"+checkNumberNull(rs.getString("taxable_amt"))+"</td><td align='right' class='tdCardPadding'>"+checkNumberNull(rs.getString("igst_amt"))+"</td><td align='right' class='tdCardPadding'>"+checkNumberNull(rs.getString("cgst_amt"))+"</td><td align='right' class='tdCardPadding'>"+checkNumberNull(rs.getString("sgst_amt"))+"</td><td align='right' class='tdCardPadding'>"+checkNumberNull(rs.getString("cess_amt"))+"</td></tr>");	   	   			
				}
	   			rowBuffer.append("</tbody></table>");
	   			rowData = new JSONObject();
	   			rowData.put("transactionDetail", rowBuffer.toString());
				rowData.put("exportToExcel", "<td><img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png' width='20px' height='20px' alt='Export to Excel' id='excel' name='excel' onclick='exportExcel(this.parentNode.id)' align='right' style='padding : 16px;'></td>");
				rawDataTranTypeSummJson.put(count,rowData);*/
	   			  			
	   		}
	   		catch (Exception e)
	   		{
	   			e.printStackTrace();
	   			throw new ITMException(e);
	   		}
	   		finally
	   		{
	   			try
	   			{
	   				if (conn != null)
	   				{
	   					if (rs != null)
	   					rs.close();
	   					rs = null;
	   					if (pstmt != null)
	   					pstmt.close();
	   					pstmt = null;
	   					conn.close();
	   					conn = null;
	   				}
	   				conn = null;
	   			} 
	   			catch (Exception d)
	   			{
	   				d.printStackTrace();
	   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
	   				throw new ITMException(d);
	   			}
	   		}
	   		return rawDataTranTypeSummJson;
	   	 }
	 /*
	 @SuppressWarnings("unchecked")
	 @Override
	 public JSONObject getOutTaxTypeSummary(String dataSourceName,String month, String year, String status, String gstCode, String sessionSiteCode ) throws RemoteException, ITMException
	 {
	   		JSONObject rawDataTranTypeSummJson = new JSONObject();
	   		JSONObject rowData             = null;
	   		ResultSet rs                   = null;
	   		PreparedStatement pstmt        = null;
	   		Connection conn                = null;
	   		ConnDriver connDriver          = new ConnDriver();
	   		int count  					   = 0;
	   		String sql = "";
	   		String statusSQLString = "", gstCodeSQLString = "";
	   		DashboardUtility dashboardUtility = null;
	   		try
	   		{
	   			conn       = connDriver.getConnectDB(dataSourceName);
	   			connDriver = null;	
	   			String periodCode = generatePeriodCode(month,year,dataSourceName);
	   			status = checkNull(status);
				dashboardUtility = new DashboardUtility();
				String statusUtility = dashboardUtility.getCommaSeparated(status);
				if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in('P','T','S') ";
				}
				else
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in ("+statusUtility+") ";
				}
				gstCode = checkNull(gstCode);
				String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
				if("".equalsIgnoreCase(gstCode))
				{
					gstCodeSQLString = " ";
				}
				else if(gstCode.equalsIgnoreCase("Unregistered"))
				{
					gstCodeSQLString = " and gsthdr.TAX_REG_NO is null ";
				}
				else
				{
					gstCodeSQLString = " and gsthdr.TAX_REG_NO in ("+gstCodeUtility+") ";
				}
	   			sql = "select sum(gstdet.igst_amt) as igst_amt ,sum(gstdet.cgst_amt) as cgst_amt ," +
	   				"sum(gstdet.sgst_amt) as sgst_amt,sum(gstdet.cess_amt) as cess_amt" +
	   				" from gst_data_hdr gsthdr, gst_data_det gstdet  where  gsthdr.tran_id=gstdet.tran_id " +
	   				"and gsthdr.rec_type='1' and gsthdr.tran_type in('01','02','03','04','05','06','07','09'," +
	   				"'10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28','29','30','31','32','33','34','35','36') " +
	   				"and gsthdr.prd_code='"+periodCode+"' and gsthdr.SITE_CODE='"+sessionSiteCode+"' " +statusSQLString+gstCodeSQLString+
	   				"order by gsthdr.rec_type";
	   			
	   			pstmt = conn.prepareStatement(sql);
	   			rs = pstmt.executeQuery();
	   			StringBuffer taxTypeTableBuffer = new StringBuffer();
	   			rowData = new JSONObject();
	   			double  igst_amnt = 0.0, cgst_amt = 0.0, sgst_amt = 0.0, cess_amt = 0.0, totalTax = 0.0;
	   			if(rs.next())
				{
	   				System.out.println("============igst_amt: "+rs.getString("igst_amt")+" cgst_amt: "+rs.getString("igst_amt")+" sgst_amt: "+rs.getString("igst_amt")+" cess_amt: "+rs.getString("igst_amt"));
	   				igst_amnt = Double.parseDouble(checkNumber(rs.getString("igst_amt")));
	   				totalTax += igst_amnt;
	   				cgst_amt = Double.parseDouble(checkNumber(rs.getString("cgst_amt")));
	   				totalTax += cgst_amt;
	   				sgst_amt = Double.parseDouble(checkNumber(rs.getString("sgst_amt")));
	   				totalTax += sgst_amt;
	   				cess_amt = Double.parseDouble(checkNumber(rs.getString("cess_amt")));
	   				totalTax += cess_amt;
	   				rowData.put("yearCode",periodCode);
	   				rowData.put("igst_amnt",igst_amnt);
	   				rowData.put("cgst_amt",cgst_amt);
	   				rowData.put("sgst_amt",sgst_amt);
	   				rowData.put("cess_amt",cess_amt);
	   				rowData.put("totalTax",totalTax);
	   				rowData.put("status", status);
					rowData.put("gstCode", gstCode);
	   				rowData.put("exportToExcel", "<td><img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png' width='20px' height='20px' alt='Export to Excel' id='excel' name='excel' onclick='exportExcel(this.parentNode.id)' align='right' style='padding : 22px 12px 10px 0px;'></td>");
	   			}
	   			else
	   			{
	   				taxTypeTableBuffer.append("<table  id='htmlTable' cellpadding='2' align='center' width='100%'><tr><td align = 'center' class='gwt-ScrollTable'>No Data Found</td></tr></table>");
				}
	   			
	   			System.out.println("taxTypeTableBuffer value: "+taxTypeTableBuffer);
				
				rowData.put("taxTypeTableData", taxTypeTableBuffer.toString());
				rawDataTranTypeSummJson.put(count, rowData);
	   		}
	   		catch (Exception e)
	   		{
	   			e.printStackTrace();
	   			throw new ITMException(e);
	   		}
	   		finally
	   		{
	   			try
	   			{
	   				if (conn != null)
	   				{
	   					if (rs != null)
	   					rs.close();
	   					rs = null;
	   					if (pstmt != null)
	   					pstmt.close();
	   					pstmt = null;
	   					conn.close();
	   					conn = null;
	   				}
	   				conn = null;
	   			} 
	   			catch (Exception d)
	   			{
	   				d.printStackTrace();
	   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
	   				throw new ITMException(d);
	   			}
	   		}
	   		return rawDataTranTypeSummJson;
	   	 }
	 
	 @SuppressWarnings("unchecked")
	 public JSONObject getInTaxTypeSummary(String dataSourceName,String month, String year, String status, String gstCode, String sessionSiteCode ) throws RemoteException, ITMException
	 {
	   		JSONObject rawDataTranTypeSummJson = new JSONObject();
	   		JSONObject rowData             = null;
	   		ResultSet rs                   = null;
	   		PreparedStatement pstmt        = null;
	   		Connection conn                = null;
	   		ConnDriver connDriver          = new ConnDriver();
	   		int count  					   = 0;
	   		String sql = "";
	   		String statusSQLString = "", gstCodeSQLString = "";
	   		DashboardUtility dashboardUtility = null;
	   		try
	   		{
	   			conn       = connDriver.getConnectDB(dataSourceName);
	   			connDriver = null;	
	   			String periodCode = generatePeriodCode(month, year, dataSourceName);
	   			status = checkNull(status);
				dashboardUtility = new DashboardUtility();
				String statusUtility = dashboardUtility.getCommaSeparated(status);
				if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in('P','T','S') ";
				}
				else
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in ("+statusUtility+") ";
				}
				gstCode = checkNull(gstCode);
				String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
				if("".equalsIgnoreCase(gstCode))
				{
					gstCodeSQLString = " ";
				}
				else if(gstCode.equalsIgnoreCase("Unregistered"))
				{
					gstCodeSQLString = " and gsthdr.TAX_REG_NO is null ";
				}
				else
				{
					gstCodeSQLString = " and gsthdr.TAX_REG_NO in ("+gstCodeUtility+") ";
				}
	   			sql = "select sum(gstdet.igst_amt) as igst_amt ,sum(gstdet.cgst_amt) as cgst_amt ," +
	   				"sum(gstdet.sgst_amt) as sgst_amt,sum(gstdet.cess_amt) as cess_amt" +
	   				" from gst_data_hdr gsthdr, gst_data_det gstdet  where  gsthdr.tran_id=gstdet.tran_id " +
	   				"and gsthdr.rec_type='2' and gsthdr.tran_type in('01','02','03','04','05','06','07','09'," +
	   				"'10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28','29','30','31','32','33','34','35','36') " +
	   				"and gsthdr.prd_code='"+periodCode+"' and gsthdr.SITE_CODE='"+sessionSiteCode+"' " +statusSQLString+gstCodeSQLString+
	   				"order by gsthdr.rec_type";
	   			
	   			pstmt = conn.prepareStatement(sql);
	   			rs = pstmt.executeQuery();
	   			StringBuffer taxTypeTableBuffer = new StringBuffer();
	   			rowData = new JSONObject();
	   			double  igst_amnt = 0.0, cgst_amt = 0.0, sgst_amt = 0.0, cess_amt = 0.0, totalTax = 0.0;
	   			if(rs.next())
				{
	   				
	   				igst_amnt = Double.parseDouble(checkNumber(rs.getString("igst_amt")));
	   				totalTax += igst_amnt;
	   				cgst_amt = Double.parseDouble(checkNumber(rs.getString("cgst_amt")));
	   				totalTax += cgst_amt;
	   				sgst_amt = Double.parseDouble(checkNumber(rs.getString("sgst_amt")));
	   				totalTax += sgst_amt;
	   				cess_amt = Double.parseDouble(checkNumber(rs.getString("cess_amt")));
	   				totalTax += cess_amt;
	   				rowData.put("yearCode",periodCode);
	   				rowData.put("igst_amnt",igst_amnt);
	   				rowData.put("cgst_amt",cgst_amt);
	   				rowData.put("sgst_amt",sgst_amt);
	   				rowData.put("cess_amt",cess_amt);
	   				rowData.put("totalTax",totalTax);
	   				rowData.put("status", status);
					rowData.put("gstCode", gstCode);
	   				rowData.put("exportToExcel", "<td><img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png' width='20px' height='20px' alt='Export to Excel' id='excel' name='excel' onclick='exportExcel(this.parentNode.id)' align='right' style='padding : 22px 12px 10px 0px;'></td>");
	   			}
	   			else
	   			{
	   				taxTypeTableBuffer.append("<table  id='htmlTable' cellpadding='2' align='center' width='100%'><tr><td align = 'center' class='gwt-ScrollTable'>No Data Found</td></tr></table>");
				}
	   			
	   			System.out.println("taxTypeTableBuffer value: "+taxTypeTableBuffer);
				
				rowData.put("taxTypeTableData", taxTypeTableBuffer.toString());
				rawDataTranTypeSummJson.put(count, rowData);
	   		}
	   		catch (Exception e)
	   		{
	   			e.printStackTrace();
	   			throw new ITMException(e);
	   		}
	   		finally
	   		{
	   			try
	   			{
	   				if (conn != null)
	   				{
	   					if (rs != null)
	   					rs.close();
	   					rs = null;
	   					if (pstmt != null)
	   					pstmt.close();
	   					pstmt = null;
	   					conn.close();
	   					conn = null;
	   				}
	   				conn = null;
	   			} 
	   			catch (Exception d)
	   			{
	   				d.printStackTrace();
	   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
	   				throw new ITMException(d);
	   			}
	   		}
	   		return rawDataTranTypeSummJson;
	   	 }
	 */
	 @SuppressWarnings("unchecked")
	 @Override
	 public JSONObject getTaxTypeDetail(String dataSourceName,String periodCode, String sessionSiteCode, String tranType, String status, String gstCode) throws RemoteException, ITMException
	 {
	   		JSONObject rawDataTranTypeSummJson = new JSONObject();
	   		JSONObject rowData             = null;
	   		ResultSet rs                   = null;
	   		PreparedStatement pstmt        = null;
	   		Connection conn                = null;
	   		ConnDriver connDriver          = new ConnDriver();
	   		int count  					   = 0;
	   		String sql = "";
	   		String statusSQLString = "",gstCodeSQLString = "";
	   		DashboardUtility dashboardUtility = null;
	   		try
	   		{
	   			System.out.println("::::::::::::::::::periodCode: "+periodCode+" sessionSiteCode: "+sessionSiteCode+" tranType: "+tranType+" gstCode: "+gstCode+" status: "+status);
	   			conn       = connDriver.getConnectDB(dataSourceName);
	   			connDriver = null;
	   			status = checkNull(status);
				dashboardUtility = new DashboardUtility();
				String statusUtility = dashboardUtility.getCommaSeparated(status);
				if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in('P','T','S') ";
				}
				else
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in ("+statusUtility+") ";
				}
				gstCode = checkNull(gstCode);
				String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
				if("".equalsIgnoreCase(gstCode))
				{
					gstCodeSQLString = " ";
				}
				else if(gstCode.equalsIgnoreCase("Unregistered"))
				{
					gstCodeSQLString = " and gsthdr.TAX_REG_NO is null ";
				}
				else
				{
					gstCodeSQLString = " and gsthdr.TAX_REG_NO in ("+gstCodeUtility+") ";
				}
	   			if((periodCode!=null && periodCode.length()>0) && (sessionSiteCode!=null && sessionSiteCode.length()>0))
	   			{
	   				if(tranType.equalsIgnoreCase("Outward"))
	   				{
	   					System.out.println("In Outward query execution");
	   					sql = "select 'Invoice' as Transaction ,gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') " +
	   		   			    	"as tran_date,gsthdr.doc_no,sum(gstdet.taxable_amt) as taxable_amt, sum(gstdet.igst_amt) as igst_amt," +
	   		   			    	"sum(gstdet.cgst_amt) as cgst_amt,sum(gstdet.sgst_amt) as sgst_amt,sum(gstdet.cess_amt) as cess_amt from gst_data_hdr gsthdr," +
	   		   			    	"gst_data_det gstdet  where  gsthdr.tran_id=gstdet.tran_id and    gsthdr.rec_type='1' and " +
	   		   			    	" gsthdr.tran_type in('01','02','03','04','05','08','09','10','11','12','13','14') and    gsthdr.prd_code='"+periodCode+"' and" +
	   		   			    	" gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" group by gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date   " +
	   		   			    	"union all select 'Debit Note' as Transaction,gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') as tran_date," +
	   		   			    	"gsthdr.doc_no,sum(gstdet.taxable_amt), sum(gstdet.igst_amt),sum(gstdet.cgst_amt)," +
	   		   			    	"sum(gstdet.sgst_amt),sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet  " +
	   		   			    	"where  gsthdr.tran_id =gstdet.tran_id and gsthdr.rec_type ='1' and gsthdr.tran_type " +
	   		   			    	"in ('30','32','34','36') and gsthdr.prd_code='"+periodCode+"' and gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+
	   		   			    	"group by gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date  union all  select 'Credit Note' as Transaction," +
	   		   			    	"gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') as tran_date ,gsthdr.doc_no," +
	   		   			    	"sum(gstdet.taxable_amt), sum(gstdet.igst_amt),sum(gstdet.cgst_amt),sum(gstdet.sgst_amt)," +
	   		   			    	"sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet  where  " +
	   		   			    	"gsthdr.tran_id =gstdet.tran_id and gsthdr.rec_type ='1' and gsthdr.tran_type in ('29','31','33','35') and " +
	   		   			    	"  gsthdr.prd_code='"+periodCode+"' and   gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" group by " +
	   		   			    	"gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date  union all select 'Nil Rate' as Transaction," +
	   		   			    	"gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') as tran_date,gsthdr.doc_no," +
	   		   			    	"sum(gstdet.taxable_amt), sum(gstdet.igst_amt),sum(gstdet.cgst_amt),sum(gstdet.sgst_amt)," +
	   		   			    	"sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet where gsthdr.tran_id =gstdet.tran_id " +
	   		   			    	"and gsthdr.rec_type ='1'  and gsthdr.tran_type in ('15','16','17','18','19','20','21','22','23','24','25','26')  and gsthdr.prd_code='"+periodCode+"' and" +
	   		   			    	"  gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" group by gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date " +
	   		   			    	"union all select 'Export' as Transaction,gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') " +
	   		   			    	"as tran_date ,gsthdr.doc_no,sum(gstdet.taxable_amt),sum(gstdet.igst_amt),sum(gstdet.cgst_amt)," +
	   		   			    	"sum(gstdet.sgst_amt),sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet  " +
	   		   			    	"where  gsthdr.tran_id =gstdet.tran_id and    gsthdr.rec_type ='1'  and   " +
	   		   			    	"gsthdr.tran_type in ('05','06','27','28') and gsthdr.prd_code='"+periodCode+"' and gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+
	   		   			    	" group by gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date  union all " +
	   		   			    	"select 'Advance Tax Paid' as Transaction,gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') " +
	   		   			    	"as tran_date ,gsthdr.doc_no,sum(gstdet.taxable_amt), sum(gstdet.igst_amt)," +
	   		   			    	"sum(gstdet.cgst_amt),sum(gstdet.sgst_amt),sum(gstdet.cess_amt) from gst_data_hdr gsthdr," +
	   		   			    	"gst_data_det gstdet  where  gsthdr.tran_id =gstdet.tran_id and gsthdr.rec_type ='1' and  " +
	   		   			    	"gsthdr.tran_type in ('14')  and  gsthdr.prd_code='"+periodCode+"' and  gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+
	   		   			    	" group by gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date";
	   				}
	   				else
	   				{
	   					System.out.println("In Inward query execution");
	   					sql = "select 'Invoice' as Transaction ,gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') " +
	   		   			    	"as tran_date,gsthdr.doc_no,sum(gstdet.taxable_amt) as taxable_amt, sum(gstdet.igst_amt) as igst_amt," +
	   		   			    	"sum(gstdet.cgst_amt) as cgst_amt,sum(gstdet.sgst_amt) as sgst_amt,sum(gstdet.cess_amt) as cess_amt from gst_data_hdr gsthdr," +
	   		   			    	"gst_data_det gstdet  where  gsthdr.tran_id=gstdet.tran_id and    gsthdr.rec_type='2' and " +
	   		   			    	" gsthdr.tran_type in('01','02','03','04','05','08','09','10','11','12','13','14') and    gsthdr.prd_code='"+periodCode+"' and" +
	   		   			    	" gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" group by gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date   " +
	   		   			    	"union all select 'Debit Note' as Transaction,gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') as tran_date," +
	   		   			    	"gsthdr.doc_no,sum(gstdet.taxable_amt), sum(gstdet.igst_amt),sum(gstdet.cgst_amt)," +
	   		   			    	"sum(gstdet.sgst_amt),sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet  " +
	   		   			    	"where  gsthdr.tran_id =gstdet.tran_id and gsthdr.rec_type ='2' and gsthdr.tran_type " +
	   		   			    	"in ('30','32','34','36') and gsthdr.prd_code='"+periodCode+"' and gsthdr.site_code=' "+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+
	   		   			    	"group by gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date  union all  select 'Credit Note' as Transaction," +
	   		   			    	"gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') as tran_date ,gsthdr.doc_no," +
	   		   			    	"sum(gstdet.taxable_amt), sum(gstdet.igst_amt),sum(gstdet.cgst_amt),sum(gstdet.sgst_amt)," +
	   		   			    	"sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet  where  " +
	   		   			    	"gsthdr.tran_id =gstdet.tran_id and gsthdr.rec_type ='2' and gsthdr.tran_type in ('29','31','33','35') and " +
	   		   			    	"  gsthdr.prd_code='"+periodCode+"' and   gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" group by " +
	   		   			    	"gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date  union all select 'Nil Rate' as Transaction," +
	   		   			    	"gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') as tran_date,gsthdr.doc_no," +
	   		   			    	"sum(gstdet.taxable_amt), sum(gstdet.igst_amt),sum(gstdet.cgst_amt),sum(gstdet.sgst_amt)," +
	   		   			    	"sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet where gsthdr.tran_id =gstdet.tran_id " +
	   		   			    	"and gsthdr.rec_type ='2'  and gsthdr.tran_type in ('15','16','17','18','19','20','21','22','23','24','25','26')  and gsthdr.prd_code='"+periodCode+"' and" +
	   		   			    	"  gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" group by gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date " +
	   		   			    	"union all select 'Export' as Transaction,gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') " +
	   		   			    	"as tran_date ,gsthdr.doc_no,sum(gstdet.taxable_amt),sum(gstdet.igst_amt),sum(gstdet.cgst_amt)," +
	   		   			    	"sum(gstdet.sgst_amt),sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet  " +
	   		   			    	"where  gsthdr.tran_id =gstdet.tran_id and    gsthdr.rec_type ='2'  and   " +
	   		   			    	"gsthdr.tran_type in ('05','06','27','28') and gsthdr.prd_code='"+periodCode+"' and gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" " +
	   		   			    	"group by gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date  union all " +
	   		   			    	"select 'Advance Tax Paid' as Transaction,gsthdr.tran_id,to_char(gsthdr.tran_date,'dd-MON-yy') " +
	   		   			    	"as tran_date ,gsthdr.doc_no,sum(gstdet.taxable_amt), sum(gstdet.igst_amt)," +
	   		   			    	"sum(gstdet.cgst_amt),sum(gstdet.sgst_amt),sum(gstdet.cess_amt) from gst_data_hdr gsthdr," +
	   		   			    	"gst_data_det gstdet  where  gsthdr.tran_id =gstdet.tran_id and gsthdr.rec_type ='2' and  " +
	   		   			    	"gsthdr.tran_type in ('14')  and  gsthdr.prd_code='"+periodCode+"' and  gsthdr.site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" " +
	   		   			    	"group by gsthdr.tran_id,gsthdr.doc_no,gsthdr.tran_date";
	   				}
		   			pstmt = conn.prepareStatement(sql);
		   			rs = pstmt.executeQuery();
		   			while (rs.next())
					{
		   				rowData = new JSONObject();
		   				rowData.put("transaction",checkNull(rs.getString("Transaction")));
		   				rowData.put("tran_id",checkNull(rs.getString("tran_id")));
		   				rowData.put("tran_date",checkNull(rs.getString("tran_date")));
		   				rowData.put("doc_no",checkNull(rs.getString("doc_no")));		   				
		   				rowData.put("taxable_amt",checkNumber(rs.getString("taxable_amt")));
		   				rowData.put("igst_amt",checkNumber(rs.getString("igst_amt")));
		   				rowData.put("cgst_amt",checkNumber(rs.getString("cgst_amt")));
		   				rowData.put("sgst_amt",checkNumber(rs.getString("sgst_amt")));
		   				rowData.put("cess_amt",checkNumber(rs.getString("cess_amt")));
		   				rawDataTranTypeSummJson.put(count, rowData);
		   	   			count++;
					}
	   			}
	   			
	   		}
	   		catch (Exception e)
	   		{
	   			e.printStackTrace();
	   			throw new ITMException(e);
	   		}
	   		finally
	   		{
	   			try
	   			{
	   				if (conn != null)
	   				{
	   					if (rs != null)
	   					rs.close();
	   					rs = null;
	   					if (pstmt != null)
	   					pstmt.close();
	   					pstmt = null;
	   					conn.close();
	   					conn = null;
	   				}
	   				conn = null;
	   			} 
	   			catch (Exception d)
	   			{
	   				d.printStackTrace();
	   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
	   				throw new ITMException(d);
	   			}
	   		}
	   		return rawDataTranTypeSummJson;
	   	 }
	 
	 /*
	 @SuppressWarnings("unchecked")
	 @Override
	 public JSONObject getOutMismatchSummary(String dataSourceName,String month, String year, String status, String gstCode, String sessionSiteCode ) throws RemoteException, ITMException
	 {
	   		JSONObject rawDataTranTypeSummJson = new JSONObject();
	   		JSONObject rowData             = null;
	   		ResultSet rs                   = null;
	   		PreparedStatement pstmt        = null;
	   		Connection conn                = null;
	   		ConnDriver connDriver          = new ConnDriver();
	   		int count  					   = 0;
	   		String sql = "";
	   		String statusSQLString = "", gstCodeSQLString = "";
	   		DashboardUtility dashboardUtility = null;
	   		try
	   		{
	   			conn       = connDriver.getConnectDB(dataSourceName);
	   			connDriver = null;	
	   			String periodCode = generatePeriodCode(month, year,dataSourceName);
	   			status = checkNull(status);
				dashboardUtility = new DashboardUtility();
				String statusUtility = dashboardUtility.getCommaSeparated(status);
				if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
				{
					statusSQLString = " and SUBMIT_STATUS in('P','T','S') ";
				}
				else
				{
					statusSQLString = " and SUBMIT_STATUS in ("+statusUtility+") ";
				}
				gstCode = checkNull(gstCode);
				String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
				if("".equalsIgnoreCase(gstCode))
				{
					gstCodeSQLString = " ";
				}
				else if(gstCode.equalsIgnoreCase("Unregistered"))
				{
					gstCodeSQLString = " and TAX_REG_NO is null ";
				}
				else
				{
					gstCodeSQLString = " and TAX_REG_NO in ("+gstCodeUtility+") ";
				}
	   			sql = "Select 'Outward' as Transaction,count(1) as count ,sum(amount) as amount from gst_data_hdr  " +
	   				"where rec_type='1' and  tran_type in ('01','02','03','04','05','06','07','09'," +
	   				"'10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28','29','30','31','32','33','34','35','36') and site_code='"+sessionSiteCode+"' " 
	   				+statusSQLString+gstCodeSQLString+"and prd_code='"+periodCode+"'";
	   			
	   			pstmt = conn.prepareStatement(sql);
	   			rs = pstmt.executeQuery();
	   			StringBuffer taxTypeTableBuffer = new StringBuffer();
	   			rowData = new JSONObject();
	   			if(rs.next())
				{
	   				rowData.put("yearCode",periodCode);
	   				rowData.put("transaction",checkNull(rs.getString("Transaction")));
	   				rowData.put("status", status);
					rowData.put("gstCode", gstCode);
	   				rowData.put("count",checkNumber(rs.getString("count")));
	   				rowData.put("amount",checkNumber(rs.getString("amount")));
	   				rowData.put("exportToExcel", "<td><img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png' width='20px' height='20px' alt='Export to Excel' id='excel' name='excel' onclick='exportExcel(this.parentNode.id)' align='right' style='padding : 22px 12px 10px 0px;'></td>");
	   			}
	   			else
	   			{
	   				taxTypeTableBuffer.append("<table  id='htmlTable' cellpadding='2' align='center' width='100%'><tr><td align = 'center' class='gwt-ScrollTable'>No Data Found</td></tr></table>");
				}
	   			
	   			System.out.println("taxTypeTableBuffer value: "+taxTypeTableBuffer);
				
				rowData.put("taxTypeTableData", taxTypeTableBuffer.toString());
				rawDataTranTypeSummJson.put(count, rowData);
	   		}
	   		catch (Exception e)
	   		{
	   			e.printStackTrace();
	   			throw new ITMException(e);
	   		}
	   		finally
	   		{
	   			try
	   			{
	   				if (conn != null)
	   				{
	   					if (rs != null)
	   					rs.close();
	   					rs = null;
	   					if (pstmt != null)
	   					pstmt.close();
	   					pstmt = null;
	   					conn.close();
	   					conn = null;
	   				}
	   				conn = null;
	   			} 
	   			catch (Exception d)
	   			{
	   				d.printStackTrace();
	   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
	   				throw new ITMException(d);
	   			}
	   		}
	   		return rawDataTranTypeSummJson;
	   	 }
	 
	 @SuppressWarnings("unchecked")
	public JSONObject getInMismatchSummary(String dataSourceName,String month, String year, String status, String gstCode, String sessionSiteCode ) throws RemoteException, ITMException
	 {
	   		JSONObject rawDataTranTypeSummJson = new JSONObject();
	   		JSONObject rowData             = null;
	   		ResultSet rs                   = null;
	   		PreparedStatement pstmt        = null;
	   		Connection conn                = null;
	   		ConnDriver connDriver          = new ConnDriver();
	   		int count  					   = 0;
	   		String sql = "";
	   		String statusSQLString = "", gstCodeSQLString = "";
	   		DashboardUtility dashboardUtility = null;
	   		try
	   		{
	   			conn       = connDriver.getConnectDB(dataSourceName);
	   			connDriver = null;	
	   			String periodCode = generatePeriodCode(month, year,dataSourceName);
	   			status = checkNull(status);
				dashboardUtility = new DashboardUtility();
				String statusUtility = dashboardUtility.getCommaSeparated(status);
				if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
				{
					statusSQLString = " and SUBMIT_STATUS in('P','T','S') ";
				}
				else
				{
					statusSQLString = " and SUBMIT_STATUS in ("+statusUtility+") ";
				}
				gstCode = checkNull(gstCode);
				String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
				if("".equalsIgnoreCase(gstCode))
				{
					gstCodeSQLString = " ";
				}
				else if(gstCode.equalsIgnoreCase("Unregistered"))
				{
					gstCodeSQLString = " and TAX_REG_NO is null ";
				}
				else
				{
					gstCodeSQLString = " and TAX_REG_NO in ("+gstCodeUtility+") ";
				}
	   			sql = "Select 'Inward' as Transaction,count(1) as count ,sum(amount) as amount from gst_data_hdr  " +
	   				"where rec_type='2' and  tran_type in ('01','02','03','04','05','06','07','09'," +
	   				"'10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28','29','30','31','32','33','34','35','36') and site_code='"+sessionSiteCode+"' " +statusSQLString+gstCodeSQLString+
	   				"and prd_code='"+periodCode+"'";
	   			
	   			pstmt = conn.prepareStatement(sql);
	   			rs = pstmt.executeQuery();
	   			StringBuffer taxTypeTableBuffer = new StringBuffer();
	   			rowData = new JSONObject();
	   			if(rs.next())
				{
	   				rowData.put("yearCode",periodCode);
	   				rowData.put("transaction",checkNull(rs.getString("Transaction")));
	   				rowData.put("status", status);
					rowData.put("gstCode", gstCode);
	   				rowData.put("count",checkNumber(rs.getString("count")));
	   				rowData.put("amount",checkNumber(rs.getString("amount")));
	   				rowData.put("exportToExcel", "<td><img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png' width='20px' height='20px' alt='Export to Excel' id='excel' name='excel' onclick='exportExcel(this.parentNode.id)' align='right' style='padding : 22px 12px 10px 0px;'></td>");
	   			}
	   			else
	   			{
	   				taxTypeTableBuffer.append("<table  id='htmlTable' cellpadding='2' align='center' width='100%'><tr><td align = 'center' class='gwt-ScrollTable'>No Data Found</td></tr></table>");
				}
	   			
	   			System.out.println("taxTypeTableBuffer value: "+taxTypeTableBuffer);
				
				rowData.put("taxTypeTableData", taxTypeTableBuffer.toString());
				rawDataTranTypeSummJson.put(count, rowData);
	   		}
	   		catch (Exception e)
	   		{
	   			e.printStackTrace();
	   			throw new ITMException(e);
	   		}
	   		finally
	   		{
	   			try
	   			{
	   				if (conn != null)
	   				{
	   					if (rs != null)
	   					rs.close();
	   					rs = null;
	   					if (pstmt != null)
	   					pstmt.close();
	   					pstmt = null;
	   					conn.close();
	   					conn = null;
	   				}
	   				conn = null;
	   			} 
	   			catch (Exception d)
	   			{
	   				d.printStackTrace();
	   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
	   				throw new ITMException(d);
	   			}
	   		}
	   		return rawDataTranTypeSummJson;
	   	 }
	 */
	 @SuppressWarnings("unchecked")
	 @Override
	 public JSONObject getMismatchDetail(String dataSourceName,String periodCode, String sessionSiteCode , String tranType, String status, String gstCode) throws RemoteException, ITMException
	 {
	   		JSONObject rawDataTranTypeSummJson = new JSONObject();
	   		JSONObject rowData             = null;
	   		ResultSet rs                   = null;
	   		PreparedStatement pstmt        = null;
	   		Connection conn                = null;
	   		ConnDriver connDriver          = new ConnDriver();
	   		int count  					   = 0;
	   		String sql = "";
	   		String statusSQLString = "",gstCodeSQLString = "";
	   		DashboardUtility dashboardUtility = null;
	   		try
	   		{
	   			System.out.println("================periodCode: "+periodCode+ " sessionSiteCode: "+sessionSiteCode+" tranType: "+tranType+" gstCode: "+gstCode+" status: "+status);
	   			conn       = connDriver.getConnectDB(dataSourceName);
	   			connDriver = null;	
	   			status = checkNull(status);
				dashboardUtility = new DashboardUtility();
				String statusUtility = dashboardUtility.getCommaSeparated(status);
				if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
				{
					statusSQLString = " and SUBMIT_STATUS in('P','T','S') ";
				}
				else
				{
					statusSQLString = " and SUBMIT_STATUS in ("+statusUtility+") ";
				}
				gstCode = checkNull(gstCode);
				String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
				if("".equalsIgnoreCase(gstCode))
				{
					gstCodeSQLString = " ";
				}
				else if(gstCode.equalsIgnoreCase("Unregistered"))
				{
					gstCodeSQLString = " and TAX_REG_NO is null ";
				}
				else
				{
					gstCodeSQLString = " and TAX_REG_NO in ("+gstCodeUtility+") ";
				}
	   			if((periodCode!=null && periodCode.length()>0) && (sessionSiteCode!=null && sessionSiteCode.length()>0))
	   			{
	   				if(tranType.equalsIgnoreCase("Outward"))
	   				{
	   					System.out.println("In Outward query execution");
	   					sql = "select 'Invoice' as Transaction,count(1) as cnt , sum(amount) as amount from " +
	   		   					"gst_data_hdr where rec_type='1' and tran_type in('01','02','03','04','05','08','09','10','11','12','13','14') and " +
	   		   					" prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+"  union all select " +
	   		   					"'Debit Note' as Transaction,count(1) as cnt, sum(amount) as amount from gst_data_hdr " +
	   		   					"where rec_type='1' and tran_type in ('30','32','34','36') and " +
	   		   					"prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+"  union all select 'Credit Note' as Transaction," +
	   		   					"count(1) as cnt, sum(amount)as amount from gst_data_hdr where rec_type='1' and " +
	   		   					"tran_type in ('29','31','33','35')  and prd_code='"+periodCode+"' and " +
	   		   					"site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all select 'Nil Rate' as Transaction,count(1)as cnt, " +
	   		   					"sum(amount) as amount from gst_data_hdr where rec_type='1' and tran_type in ('15','16','17','18','19','20','21','22','23','24','25','26') " +
	   		   					" and prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+"  union all " +
	   		   					"select 'Export' as Transaction,count(1)as cnt, sum(amount)as amount from " +
	   		   					"gst_data_hdr where rec_type='1' and tran_type in ('05','06','27','28')  " +
	   		   					"and prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all select 'Advance Tax Paid' " +
	   		   					"as Transaction,count(1)as cnt, sum(amount)as amount from gst_data_hdr where " +
	   		   					"rec_type='1' and tran_type in ('14')  and prd_code='"+periodCode+"' " +
	   		   					"and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" ";
	   				}
	   				else
	   				{
	   					System.out.println("In Inward query execution");
	   					sql = "select 'Invoice' as Transaction,count(1) as cnt , sum(amount) as amount from " +
	   		   					"gst_data_hdr where rec_type='2' and tran_type in('01','02','03','04','05','08','09','10','11','12','13','14') and " +
	   		   					" prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+"  union all select " +
	   		   					"'Debit Note' as Transaction,count(1) as cnt, sum(amount) as amount from gst_data_hdr " +
	   		   					"where rec_type='2' and tran_type in ('30','32','34','36') and " +
	   		   					"prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+"  union all select 'Credit Note' as Transaction," +
	   		   					"count(1) as cnt, sum(amount)as amount from gst_data_hdr where rec_type='2' and " +
	   		   					"tran_type in ('29','31','33','35') and prd_code='"+periodCode+"' and " +
	   		   					"site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all select 'Nil Rate' as Transaction,count(1)as cnt, " +
	   		   					"sum(amount) as amount from gst_data_hdr where rec_type='2' and tran_type in ('15','16','17','18','19','20','21','22','23','24','25','26') " +
	   		   					"and prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+"  union all " +
	   		   					"select 'Export' as Transaction,count(1)as cnt, sum(amount)as amount from " +
	   		   					"gst_data_hdr where rec_type='2' and tran_type in ('05','06','27','28') " +
	   		   					"and prd_code='"+periodCode+"' and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" union all select 'Advance Tax Paid' " +
	   		   					"as Transaction,count(1)as cnt, sum(amount)as amount from gst_data_hdr where " +
	   		   					"rec_type='2' and tran_type in ('14') and prd_code='"+periodCode+"' " +
	   		   					"and site_code='"+sessionSiteCode+"' "+statusSQLString+gstCodeSQLString+" ";
	   				}
	   				pstmt = conn.prepareStatement(sql);
		   			rs = pstmt.executeQuery();
		   			while (rs.next())
					{
		   				rowData = new JSONObject();
		   				rowData.put("transaction",checkNumberNull(rs.getString("Transaction")));
		   				rowData.put("count",checkNumberNull(rs.getString("cnt")));
		   				rowData.put("amount",checkNumberNull(rs.getString("amount")));
		   				
		   				rawDataTranTypeSummJson.put(count, rowData);
		   	   			count++;
					}
	   			}   			
	   		}
	   		catch (Exception e)
	   		{
	   			e.printStackTrace();
	   			throw new ITMException(e);
	   		}
	   		finally
	   		{
	   			try
	   			{
	   				if (conn != null)
	   				{
	   					if (rs != null)
	   					rs.close();
	   					rs = null;
	   					if (pstmt != null)
	   					pstmt.close();
	   					pstmt = null;
	   					conn.close();
	   					conn = null;
	   				}
	   				conn = null;
	   			} 
	   			catch (Exception d)
	   			{
	   				d.printStackTrace();
	   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
	   				throw new ITMException(d);
	   			}
	   		}
	   		return rawDataTranTypeSummJson;
	   	 }
	 
	 @SuppressWarnings("unchecked")
	 @Override
	 public JSONObject getOutLedgerBalSummary(String dataSourceName,String month, String year, String status, String gstCode, String sessionSiteCode ) throws RemoteException, ITMException
	 {
	   		JSONObject rawDataTranTypeSummJson = new JSONObject();
	   		JSONObject rowData             = null;
	   		ResultSet rs                   = null;
	   		PreparedStatement pstmt        = null;
	   		Connection conn                = null;
	   		ConnDriver connDriver          = new ConnDriver();
	   		int count  					   = 0, rowCount = 0;
	   		String sql = "";
	   		StringBuffer rowBuffer = null, liability = null;
	   		LinkedHashMap< String, String> ledgerTypeMap = null;
	   		String statusSQLString = "", gstCodeSQLString = "";
	   		DashboardUtility dashboardUtility = null;
	   		try
	   		{
	   			conn       = connDriver.getConnectDB(dataSourceName);
	   			connDriver = null;	
	   			String periodCode = generatePeriodCode(month, year,dataSourceName);
	   			status = checkNull(status);
				dashboardUtility = new DashboardUtility();
				String statusUtility = dashboardUtility.getCommaSeparated(status);
				if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in('P','T','S') ";
				}
				else
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in ("+statusUtility+") ";
				}
				gstCode = checkNull(gstCode);
				String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
				if("".equalsIgnoreCase(gstCode))
				{
					gstCodeSQLString = " ";
				}
				else if(gstCode.equalsIgnoreCase("Unregistered"))
				{
					gstCodeSQLString = " and gsthdr.TAX_REG_NO is null ";
				}
				else
				{
					gstCodeSQLString = " and gsthdr.TAX_REG_NO in ("+gstCodeUtility+") ";
				}
	   			sql = "select 'Liability' as LedgerType ,sum(gstdet.igst_amt) as igst,sum(gstdet.cgst_amt) as cgst,sum(gstdet.sgst_amt) as sgst,sum(gstdet.cess_amt) as cess from gst_data_hdr gsthdr,gst_data_det gstdet "+
	   				"where  gsthdr.tran_id=gstdet.tran_id "+
	   				 "and    gsthdr.rec_type='1' "+
	   				 "and    gsthdr.tran_type in('01','02','03','04','05','06') "+
	   				 "and    gsthdr.prd_code='"+periodCode+"' "+statusSQLString+gstCodeSQLString+
	   				 "and    gsthdr.site_code='"+sessionSiteCode+"' "+
	   				 "union all "+
	   				 "select 'Cash in hand' as LedgerType,sum(gstdet.igst_amt),sum(gstdet.cgst_amt),sum(gstdet.sgst_amt),sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet "+
	   				 "where  gsthdr.tran_id =gstdet.tran_id "+
	   				 "and    gsthdr.rec_type ='1' "+
	   				 "and    gsthdr.tran_type in ('07')  "+
	   				 "and    gsthdr.prd_code='"+periodCode+"' "+statusSQLString+gstCodeSQLString+
	   				 "and    gsthdr.site_code='"+sessionSiteCode+"' "+
	   				 "union all "+
	   				 "select 'I.TC' as LedgerType, sum(gstdet.igst_amt),sum(gstdet.cgst_amt),sum(gstdet.sgst_amt),sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet "+
	   				 "where  gsthdr.tran_id =gstdet.tran_id "+
	   				 "and    gsthdr.rec_type ='1' "+
	   				 "and    gsthdr.tran_type in ('07')  "+
	   				 "and   gsthdr.prd_code='"+periodCode+"' "+statusSQLString+gstCodeSQLString+
	   				 "and   gsthdr.site_code='"+sessionSiteCode+"' ";
	   			
	   			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
	   			rs    = pstmt.executeQuery();
	   			rowCount = 0;
	   			rs.last();
				rowCount = rs.getRow();
				rs.beforeFirst();
				rowBuffer = new StringBuffer();
				if(rowCount != 0)
				{
					rowBuffer = new StringBuffer("<table class = 'mtBorderWhite' border='1' id='htmlTable' cellpadding='2' style='line-height:35px;'>"+
		                        "<tr style='border-bottom: 1px solid #e8e8e8; border-top: 1px solid #e8e8e8;'><td class = 'tblHeaderLeft' style='width: 20%;'>Ledger type</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 5%;'>IGST</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 5%;'>CGST</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 5%;'>SGST</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 5%;'>CESS</td></tr>");
				}
	   			else
				{
					rowBuffer = new StringBuffer("<table  id='htmlTable' cellpadding='2' align='center'><tr><td align = 'center' class='gwt-ScrollTable'>No Data to Display</td></tr></table>");
				}
				ledgerTypeMap = new LinkedHashMap<String, String>();
				while(rs.next())
				{
					ledgerTypeMap.put(rs.getString("LedgerType"), checkNumberNull(rs.getString("IGST"))+'@'+checkNumberNull(rs.getString("CGST"))+'@'+checkNumberNull(rs.getString("SGST"))+'@'+checkNumberNull(rs.getString("CESS")));
				}
				
				double igstTotal = 0.0,cgstTotal = 0.0,sgstTotal = 0.0,cessTotal = 0.0;
				liability = new StringBuffer();
				for(Entry<String, String> entry: ledgerTypeMap.entrySet())
				{
					String mapKey = entry.getKey();
					String mapValue= entry.getValue();
					System.out.println("mapKey: "+mapKey);
					String[] splitMapValue = mapValue.split("@");
					System.out.println("============splitMapValue: "+Arrays.toString(splitMapValue));
					liability.append("<tr style='border-bottom: 1px solid #e8e8e8;'><td class='tdCardPadding'>"+mapKey+"</td><td align='right' class='tdCardPadding'>"+splitMapValue[0]+"</td><td align='right' class='tdCardPadding'>"+splitMapValue[1]+"</td><td align='right' class='tdCardPadding'>"+splitMapValue[2]+"</td><td align='right' class='tdCardPadding'>"+splitMapValue[3]+"</td></tr>");
					
					igstTotal+=Double.parseDouble(splitMapValue[0]);
					cgstTotal+=Double.parseDouble(splitMapValue[1]);
					sgstTotal+=Double.parseDouble(splitMapValue[2]);
					cessTotal+=Double.parseDouble(splitMapValue[3]);
				}
				liability.append("<tr style='border-bottom: 1px solid #e8e8e8;'><td class='tdCardPadding'><b>To Pay</b></td><td align='right' class='tdCardPadding'><b>"+Math.round(igstTotal)+"</b></td><td align='right' class='tdCardPadding'><b>"+Math.round(cgstTotal)+"</b></td><td align='right' class='tdCardPadding'><b>"+Math.round(sgstTotal)+"</b></td><td align='right' class='tdCardPadding'><b>"+Math.round(cessTotal)+"</b></td></tr>");
				
				rowBuffer.append(liability);
				rowBuffer.append("</tbody></table>");
				System.out.println("RowBuffer "+rowBuffer);
				rowData = new JSONObject();
				rowData.put("ledgerTableData", rowBuffer.toString());
				rowData.put("exportToExcel", "<td><img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png' width='20px' height='20px' alt='Export to Excel' id='excel' name='excel' onclick='exportExcel(this.parentNode.id)' align='right' style='padding : 16px;'></td>");
				
				rawDataTranTypeSummJson.put(count,rowData);
	   		}
	   		catch (Exception e)
	   		{
	   			e.printStackTrace();
	   			throw new ITMException(e);
	   		}
	   		finally
	   		{
	   			try
	   			{
	   				if (conn != null)
	   				{
	   					if (rs != null)
	   					rs.close();
	   					rs = null;
	   					if (pstmt != null)
	   					pstmt.close();
	   					pstmt = null;
	   					conn.close();
	   					conn = null;
	   				}
	   				conn = null;
	   			} 
	   			catch (Exception d)
	   			{
	   				d.printStackTrace();
	   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
	   				throw new ITMException(d);
	   			}
	   		}
	   		return rawDataTranTypeSummJson;
	   	 }
	 
	 @SuppressWarnings("unchecked")
	public JSONObject getInLedgerBalSummary(String dataSourceName,String month, String year, String status, String gstCode, String sessionSiteCode ) throws RemoteException, ITMException
	 {
	   		JSONObject rawDataTranTypeSummJson = new JSONObject();
	   		JSONObject rowData             = null;
	   		ResultSet rs                   = null;
	   		PreparedStatement pstmt        = null;
	   		Connection conn                = null;
	   		ConnDriver connDriver          = new ConnDriver();
	   		int count  					   = 0, rowCount = 0;
	   		String sql = "";
	   		StringBuffer rowBuffer = null, liability = null;
	   		LinkedHashMap< String, String> ledgerTypeMap = null;
	   		String statusSQLString = "", gstCodeSQLString = "";
	   		DashboardUtility dashboardUtility = null;
	   		try
	   		{
	   			conn       = connDriver.getConnectDB(dataSourceName);
	   			connDriver = null;	
	   			String periodCode = generatePeriodCode(month, year, dataSourceName);
	   			status = checkNull(status);
				dashboardUtility = new DashboardUtility();
				String statusUtility = dashboardUtility.getCommaSeparated(status);
				if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in('P','T','S') ";
				}
				else
				{
					statusSQLString = " and gsthdr.SUBMIT_STATUS in ("+statusUtility+") ";
				}
				gstCode = checkNull(gstCode);
				String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
				if("".equalsIgnoreCase(gstCode))
				{
					gstCodeSQLString = " ";
				}
				else if(gstCode.equalsIgnoreCase("Unregistered"))
				{
					gstCodeSQLString = " and TAX_REG_NO is null ";
				}
				else
				{
					gstCodeSQLString = " and TAX_REG_NO in ("+gstCodeUtility+") ";
				}
	   			sql = "select 'Liability' as LedgerType ,sum(gstdet.igst_amt) as igst,sum(gstdet.cgst_amt) as cgst,sum(gstdet.sgst_amt) as sgst,sum(gstdet.cess_amt) as cess from gst_data_hdr gsthdr,gst_data_det gstdet "+
	   				"where  gsthdr.tran_id=gstdet.tran_id "+
	   				 "and    gsthdr.rec_type='2' "+
	   				 "and    gsthdr.tran_type in('01','02','03','04','05','06') "+
	   				 "and    gsthdr.prd_code='"+periodCode+"' "+statusSQLString+gstCodeSQLString+
	   				 "and    gsthdr.site_code='"+sessionSiteCode+"' "+
	   				 "union all "+
	   				 "select 'Cash in hand' as LedgerType,sum(gstdet.igst_amt),sum(gstdet.cgst_amt),sum(gstdet.sgst_amt),sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet "+
	   				 "where  gsthdr.tran_id =gstdet.tran_id "+
	   				 "and    gsthdr.rec_type ='2' "+
	   				 "and    gsthdr.tran_type in ('07')  "+
	   				 "and    gsthdr.prd_code='"+periodCode+"' "+statusSQLString+gstCodeSQLString+
	   				 "and    gsthdr.site_code='"+sessionSiteCode+"' "+
	   				 "union all "+
	   				 "select 'I.TC' as LedgerType, sum(gstdet.igst_amt),sum(gstdet.cgst_amt),sum(gstdet.sgst_amt),sum(gstdet.cess_amt) from gst_data_hdr gsthdr,gst_data_det gstdet "+
	   				 "where  gsthdr.tran_id =gstdet.tran_id "+
	   				 "and    gsthdr.rec_type ='2' "+
	   				 "and    gsthdr.tran_type in ('07')  "+
	   				 "and   gsthdr.prd_code='"+periodCode+"' "+statusSQLString+gstCodeSQLString+
	   				 "and   gsthdr.site_code='"+sessionSiteCode+"'";
	   			
	   			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
	   			rs    = pstmt.executeQuery();
	   			rowCount = 0;
	   			rs.last();
				rowCount = rs.getRow();
				rs.beforeFirst();
				rowBuffer = new StringBuffer();
				if(rowCount != 0)
				{
					rowBuffer = new StringBuffer("<table class = 'mtBorderWhite' border='1' id='htmlTable' cellpadding='2' style='line-height:35px;'>"+
		                        "<tr style='border-bottom: 1px solid #e8e8e8; border-top: 1px solid #e8e8e8;'><td class = 'tblHeaderLeft' style='width: 20%;'>Ledger type</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 5%;'>IGST</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 5%;'>CGST</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 5%;'>SGST</td>"+
		                        "<td class = 'tblHeaderRight' style='width: 5%;'>CESS</td></tr>");
				}
	   			else
				{
					rowBuffer = new StringBuffer("<table  id='htmlTable' cellpadding='2' align='center'><tr><td align = 'center' class='gwt-ScrollTable'>No Data to Display</td></tr></table>");
				}
				ledgerTypeMap = new LinkedHashMap<String, String>();
				while(rs.next())
				{
					ledgerTypeMap.put(rs.getString("LedgerType"), checkNumberNull(rs.getString("IGST"))+'@'+checkNumberNull(rs.getString("CGST"))+'@'+checkNumberNull(rs.getString("SGST"))+'@'+checkNumberNull(rs.getString("CESS")));
				}
				
				double igstTotal = 0.0,cgstTotal = 0.0,sgstTotal = 0.0,cessTotal = 0.0;
				liability = new StringBuffer();
				for(Entry<String, String> entry: ledgerTypeMap.entrySet())
				{
					String mapKey = entry.getKey();
					String mapValue= entry.getValue();
					System.out.println("mapKey: "+mapKey);
					String[] splitMapValue = mapValue.split("@");
					System.out.println("============splitMapValue: "+Arrays.toString(splitMapValue));
					liability.append("<tr style='border-bottom: 1px solid #e8e8e8;'><td class='tdCardPadding'>"+mapKey+"</td><td align='right' class='tdCardPadding'>"+splitMapValue[0]+"</td><td align='right' class='tdCardPadding'>"+splitMapValue[1]+"</td><td align='right' class='tdCardPadding'>"+splitMapValue[2]+"</td><td align='right' class='tdCardPadding'>"+splitMapValue[3]+"</td></tr>");
					
					igstTotal+=Double.parseDouble(splitMapValue[0]);
					cgstTotal+=Double.parseDouble(splitMapValue[1]);
					sgstTotal+=Double.parseDouble(splitMapValue[2]);
					cessTotal+=Double.parseDouble(splitMapValue[3]);
				}
				liability.append("<tr style='border-bottom: 1px solid #e8e8e8;'><td class='tdCardPadding'><b>To Pay</b></td><td align='right' class='tdCardPadding'><b>"+Math.round(igstTotal)+"</b></td><td align='right' class='tdCardPadding'><b>"+Math.round(cgstTotal)+"</b></td><td align='right' class='tdCardPadding'><b>"+Math.round(sgstTotal)+"</b></td><td align='right' class='tdCardPadding'><b>"+Math.round(cessTotal)+"</b></td></tr>");
				
				rowBuffer.append(liability);
				rowBuffer.append("</tbody></table>");
				System.out.println("RowBuffer "+rowBuffer);
				rowData = new JSONObject();
				rowData.put("ledgerTableData", rowBuffer.toString());
				rowData.put("exportToExcel", "<td><img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png' width='20px' height='20px' alt='Export to Excel' id='excel' name='excel' onclick='exportExcel(this.parentNode.id)' align='right' style='padding : 16px;'></td>");
				rawDataTranTypeSummJson.put(count,rowData);
	   		}
	   		catch (Exception e)
	   		{
	   			e.printStackTrace();
	   			throw new ITMException(e);
	   		}
	   		finally
	   		{
	   			try
	   			{
	   				if (conn != null)
	   				{
	   					if (rs != null)
	   					rs.close();
	   					rs = null;
	   					if (pstmt != null)
	   					pstmt.close();
	   					pstmt = null;
	   					conn.close();
	   					conn = null;
	   				}
	   				conn = null;
	   			} 
	   			catch (Exception d)
	   			{
	   				d.printStackTrace();
	   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
	   				throw new ITMException(d);
	   			}
	   		}
	   		return rawDataTranTypeSummJson;
	   	 }
	 

	 private String checkNull(String str)
	   	{
	   		if(str == null)
	   		{
	   			return "";
	   		}
	   		else
	   		{
	   			return str.trim();
	   		}
	   	} 	
	   	
	private String checkNumber(String str)
	{
   		if (str == null)
   		{
   			return "0";
   		} 
   		else
   		{
   			int strFormat = 0;
   			if(str.length()>0)
   			{
   				strFormat= Integer.parseInt(str.trim());
   			}
   			 
   			return strFormat+"";
   		}
   		
	}
	private String checkNumberNull(String str)
	{
   		if (str == null)
   		{
   			return "0";
   		} 
   		else
   		{
   			return str.trim();
   		}
   		
	}
	public String generatePeriodCode(String month, String year, String dataSourceName)
	{
		String sql= "", periodCode = "";
		ResultSet rs                   = null;
   		PreparedStatement pstmt        = null;
   		Connection conn                = null;
   		ConnDriver connDriver          = new ConnDriver();
   		try 
   		{
			conn       = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			month = checkNull(month);
   			year = checkNull(year);
   			System.out.println("Selected month: "+month+" year: "+year);
   			
   			if(("".equalsIgnoreCase(month)) && ("".equalsIgnoreCase(year)))
   			{
   				sql = "Select Acct_Prd,Code,Descr From Period Where To_Date(Sysdate) Between Fr_Date and To_Date";
   				pstmt = conn.prepareStatement(sql);
   	   			rs = pstmt.executeQuery();
   	   			if (rs.next())
   	   			{
   	   				periodCode = checkNull(rs.getString("Code"));
   	   				
   	   				String monthLocal = periodCode.substring(0, 2);
	   				if(Integer.parseInt(monthLocal)>12)
	   				{
	   					String yearLocal = periodCode.substring(0, 4);
	   					monthLocal       = periodCode.substring(4);
	   					periodCode  = monthLocal + yearLocal;
	   				}
	   				System.out.println("periodCode: "+periodCode);
   	   			}
   	   			rs.close();
   	   			rs = null;
   	   			pstmt.close();
   	   			pstmt = null;
   	   		}
   			else
   			{
   				if(month.length()>2)
   				{
	   				SimpleDateFormat inputFormat = new SimpleDateFormat("MMMM");
	   				Calendar cal = Calendar.getInstance();
	   				cal.setTime(inputFormat.parse(month));
	   				SimpleDateFormat outputFormat = new SimpleDateFormat("MM");
	   				month = outputFormat.format(cal.getTime());
   				}
   				periodCode = month+""+year;
   	   			System.out.println("periodCode: "+periodCode);
   	   			
   			}
   			System.out.println("============periodCode: "+periodCode);
			
   		}
   		catch (Exception e) 
   		{
   			e.printStackTrace();
   		}
		return periodCode;
	}
	
	private Timestamp getTimeStamp(String dateStr) throws ITMException, Exception 
	{ 
		 String dbDateStr = "";
		 if(dateStr != null && !dateStr.equals(""))
		 {
			 if(dateStr.indexOf(":") != -1)
			 {
				 System.out.println("inside logic");
				 System.out.println("inside logic"+dateStr);
				 
				/* if(dateStr.indexOf(".") != -1)
				 {
				 dateStr = dateStr.substring(0, dateStr.indexOf("."));
				 }*/
				 
				 return java.sql.Timestamp.valueOf(dateStr);      
			 }
			 else
			 {
				 System.out.println("inside ");
				 dbDateStr =(new E12GenericUtility()).getValidDateTimeString(dateStr, (new E12GenericUtility()).getApplDateTimeFormat(), (new E12GenericUtility()).getDBDateTimeFormat());
				 return java.sql.Timestamp.valueOf(dbDateStr); 
			 }
		}
		else
		{
			return null;
		}
	}

	@SuppressWarnings("unchecked")
	public JSONObject getTaxMismatchSummary(String dataSourceName, String month, String year, String status, String gstCode, String sessionSiteCode)
	{
   		JSONObject rawDataTaxMismatchSummJson = new JSONObject();
   		JSONObject rowData             = null;
   		ResultSet rs                   = null;
   		PreparedStatement pstmt        = null;
   		Connection conn                = null;
   		ConnDriver connDriver          = new ConnDriver();
   		int count  					   = 0;
   		String sql = "";
   		String statusSQLString = "", gstCodeSQLString = "";
   		LinkedHashMap<String, String> imageTransactionMap = null;
   		LinkedHashMap<String, String> totalAmountMap = null;
   		LinkedHashMap<String, String> labelTitleTypeMap = null;
   		DashboardUtility dashboardUtility = null;
   		String totalTax = "";
   		try
   		{
   			System.out.println("Inside getTaxMismatchSummary*******************");
   			conn       = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;	
   			String periodCode = generatePeriodCode(month,year,dataSourceName);
   			status = checkNull(status);
			dashboardUtility = new DashboardUtility();
			String statusUtility = dashboardUtility.getCommaSeparated(status);
			if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
			{
				statusSQLString = " and gsthdr.SUBMIT_STATUS in('P','T','S') ";
			}
			else
			{
				statusSQLString = " and gsthdr.SUBMIT_STATUS in ("+statusUtility+") ";
			}
			gstCode = checkNull(gstCode);
			String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
			if("".equalsIgnoreCase(gstCode))
			{
				gstCodeSQLString = " ";
			}
			/*else if(gstCode.equalsIgnoreCase("Unregistered"))
			{
				gstCodeSQLString = " and gsthdr.TAX_REG_NO is null ";
			}*/
			else
			{
				gstCodeSQLString = " and gsthdr.TAX_REG_NO in ("+gstCodeUtility+") ";
			}
			imageTransactionMap = new LinkedHashMap<String, String>();
			imageTransactionMap.put("outwardTax", "<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/OutwardTax.png' width='30px' height='30px' alt='Outward Tax' id='transactionImage'>");
			imageTransactionMap.put("inwardTax", "<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/InwardTax.png' width='30px' height='30px' alt='Inward Tax' id='transactionImage'>");
			imageTransactionMap.put("outwardMismatch", "<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/OutwardMismatch.png' width='30px' height='30px' alt='Outward Mismatch' id='transactionImage'>");
			imageTransactionMap.put("inwardMismatch","<img src='"+CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/InwardMismatch.png' width='30px' height='30px' alt='Inward Mismatch' id='transactionImage'>");
			
			totalAmountMap =  new LinkedHashMap<String, String>();
   			
			System.out.println("---------------------------Outward Tax");
			//**********************Outward Tax***********************************
   			/*sql = "select sum(gstdet.igst_amt) as igst_amt ,sum(gstdet.cgst_amt) as cgst_amt ," +
   				"sum(gstdet.sgst_amt) as sgst_amt,sum(gstdet.cess_amt) as cess_amt" +
   				" from gst_data_hdr gsthdr, gst_data_det gstdet  where  gsthdr.tran_id=gstdet.tran_id " +
   				"and gsthdr.rec_type='1' and gsthdr.tran_type in('01','02','03','04','05','06','07','09'," +
   				"'10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28','29','30','31','32','33','34','35','36') " +
   				"and gsthdr.prd_code='"+periodCode+"' and gsthdr.SITE_CODE='"+sessionSiteCode+"' " +statusSQLString+gstCodeSQLString+
   				"order by gsthdr.rec_type";*/
   			
			sql="SELECT SUM(gstdet.igst_amt) AS igst_amt ,SUM(gstdet.cgst_amt) AS cgst_amt ,"+
			"SUM(gstdet.sgst_amt) AS sgst_amt ,SUM(GSTDET.CESS_AMT) AS CESS_AMT ,"+
			"round(SUM(COALESCE(GSTDET.IGST_AMT,0) + COALESCE(GSTDET.CGST_AMT,0)+ COALESCE(GSTDET.sgst_amt,0)+ "+
			"COALESCE(GSTDET.CESS_AMT,0))) AS total_tax ,SUM(CASE WHEN GSTHDR.SUBMIT_STATUS = 'P' THEN 1 ELSE 0 "+
			"END) AS total_pending ,SUM(CASE WHEN GSTHDR.SUBMIT_STATUS = 'T' THEN 1 ELSE 0 END) AS total_saved"+
			" ,SUM(CASE WHEN GSTHDR.SUBMIT_STATUS = 'S' THEN 1 ELSE 0 END) AS total_submitted ,"+
			"SUM(CASE WHEN GSTHDR.SUBMIT_STATUS IN ('P','T','S') THEN 1 ELSE 0 END) AS final_total FROM "+
			"GST_DATA_HDR GSTHDR ,gst_data_det gstdet WHERE gsthdr.tran_id = gstdet.tran_id "+
			"AND gsthdr.rec_type = '1' AND gsthdr.tran_type IN('01','02','03','04','05','06','07','09','10'"+
			",'11','12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28','29','30'"+
			",'31','32','33','34','35','36','41','42','43','44','45','46','47','48') "+
			"AND gsthdr.prd_code = '"+periodCode+"' AND GSTHDR.SITE_CODE = '"+sessionSiteCode+"' "+
			statusSQLString+gstCodeSQLString+
			" GROUP BY GSTHDR.SUBMIT_STATUS ORDER BY GSTHDR.SUBMIT_STATUS";
			
   			pstmt = conn.prepareStatement(sql);
   			rs = pstmt.executeQuery();
   			if(rs.next())
			{
   				System.out.println("============igst_amt: "+rs.getString("igst_amt")+" cgst_amt: "+rs.getString("cgst_amt")+" sgst_amt: "+rs.getString("sgst_amt")+" cess_amt: "+rs.getString("cess_amt"));
   				totalTax = checkNumberNull(rs.getString("total_tax"));
   				totalAmountMap.put("outwardTax","<font style='font-size: 15px; font-weight: 500;'>INR</font>  "+totalTax);
   				
   			}
   			else
   			{
   				System.out.println("SQL does not return any data---------------------------Outward Tax");
   				totalAmountMap.put("outwardTax","<font style='font-size: 15px; font-weight: 500;'>INR</font>  "+"0");
   			}
   			rs.close();
	   		rs = null;
	   		pstmt.close();
	   		pstmt = null;
	   		System.out.println("---------------------------Inward Tax");
	   		//***************************Inward Tax***********************************
	   		/*sql = "select sum(gstdet.igst_amt) as igst_amt ,sum(gstdet.cgst_amt) as cgst_amt ," +
	   				"sum(gstdet.sgst_amt) as sgst_amt,sum(gstdet.cess_amt) as cess_amt" +
	   				" from gst_data_hdr gsthdr, gst_data_det gstdet  where  gsthdr.tran_id=gstdet.tran_id " +
	   				"and gsthdr.rec_type='2' and gsthdr.tran_type in('01','02','03','04','05','06','07','09'," +
	   				"'10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28','29','30','31','32','33','34','35','36') " +
	   				"and gsthdr.prd_code='"+periodCode+"' and gsthdr.SITE_CODE='"+sessionSiteCode+"' " +statusSQLString+gstCodeSQLString+
	   				"order by gsthdr.rec_type";*/
	   		sql="SELECT SUM(gstdet.igst_amt) AS igst_amt ,SUM(gstdet.cgst_amt) AS cgst_amt ,"+
			"SUM(gstdet.sgst_amt) AS sgst_amt ,SUM(GSTDET.CESS_AMT) AS CESS_AMT ,"+
			"round(SUM(COALESCE(GSTDET.IGST_AMT,0) + COALESCE(GSTDET.CGST_AMT,0)+ COALESCE(GSTDET.sgst_amt,0)+ "+
			"COALESCE(GSTDET.CESS_AMT,0))) AS total_tax ,SUM(CASE WHEN GSTHDR.SUBMIT_STATUS = 'P' THEN 1 ELSE 0 "+
			"END) AS total_pending ,SUM(CASE WHEN GSTHDR.SUBMIT_STATUS = 'T' THEN 1 ELSE 0 END) AS total_saved"+
			" ,SUM(CASE WHEN GSTHDR.SUBMIT_STATUS = 'S' THEN 1 ELSE 0 END) AS total_submitted ,"+
			"SUM(CASE WHEN GSTHDR.SUBMIT_STATUS IN ('P','T','S') THEN 1 ELSE 0 END) AS final_total FROM "+
			"GST_DATA_HDR GSTHDR ,gst_data_det gstdet WHERE gsthdr.tran_id = gstdet.tran_id "+
			"AND gsthdr.rec_type = '2' AND gsthdr.tran_type IN('01','02','03','04','05','06','07','09','10'"+
			",'11','12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28','29','30'"+
			",'31','32','33','34','35','36','41','42','43','44','45','46','47','48') "+
			"AND gsthdr.prd_code = '"+periodCode+"' AND GSTHDR.SITE_CODE = '"+sessionSiteCode+"' "+
			statusSQLString+gstCodeSQLString+
			" GROUP BY GSTHDR.SUBMIT_STATUS ORDER BY GSTHDR.SUBMIT_STATUS";
	   		totalTax = "";	
   			pstmt = conn.prepareStatement(sql);
   			rs = pstmt.executeQuery();
   			
   			if(rs.next())
			{
				System.out.println("============igst_amt: "+rs.getString("igst_amt")+" cgst_amt: "+rs.getString("cgst_amt")+" sgst_amt: "+rs.getString("sgst_amt")+" cess_amt: "+rs.getString("cess_amt"));
   				totalTax = checkNumberNull(rs.getString("total_tax"));
   				totalAmountMap.put("inwardTax","<font style='font-size: 15px; font-weight: 500;'>INR</font>  "+totalTax);
   			}
   			else
   			{
   				System.out.println("SQL does not return any data---------------------------Inward Tax");
   				totalAmountMap.put("inwardTax","<font style='font-size: 15px; font-weight: 500;'>INR</font>  "+"0");
   			}
   			rs.close();
	   		rs = null;
	   		pstmt.close();
	   		pstmt = null;
	   		System.out.println("---------------------------Outward Mismatch");
	   		
			gstCode = checkNull(gstCode);
			gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
			if("".equalsIgnoreCase(gstCode))
			{
				gstCodeSQLString = " ";
			}
			/*else if(gstCode.equalsIgnoreCase("Unregistered"))
			{
				gstCodeSQLString = " and TAX_REG_NO is null ";
			}*/
			else
			{
				gstCodeSQLString = " and TAX_REG_NO in ("+gstCodeUtility+") ";
			}
	   	    //**********************Outward Mismatch***********************************
	   		sql = "Select 'Outward' as Transaction,count(1) as count ,round(sum(amount)) as amount from gst_data_hdr " +
	   			"  where rec_type='1'  and  tran_type in ('01','02','03','04','05','06','07','09','10','11'," +
	   			"'12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28','29','30'," +
	   			"'31','32','33','34','35','36','41','42','43','44','45','46','47','48') " +
	   			"and site_code='TA821'   AND SUBMIT_STATUS='P' " +gstCodeSQLString+
	   			"and prd_code='"+periodCode+"'";
	   			
   			pstmt = conn.prepareStatement(sql);
   			rs = pstmt.executeQuery();
   			if(rs.next())
			{
   				totalAmountMap.put("outwardMismatch","<font style='font-size: 15px; font-weight: 500;'>INR</font>  "+checkNumberNull(rs.getString("amount")));
   			}
   			else
   			{
   				System.out.println("SQL does not return any data---------------------------Outward Mismatch");
   				totalAmountMap.put("outwardMismatch","<font style='font-size: 15px; font-weight: 500;'>INR</font>  "+"0");
   			}
   			rs.close();
	   		rs = null;
	   		pstmt.close();
	   		pstmt = null;
	   		System.out.println("---------------------------Inward Mismatch");
	   		//**********************Inward Mismatch***********************************
	   		sql = "Select 'Inward' as Transaction,count(1) as count ,round(sum(amount)) as amount from gst_data_hdr " +
	   			"  where rec_type='2'  and  tran_type in ('01','02','03','04','05','06','07','09','10','11'," +
	   			"'12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28','29','30'," +
	   			"'31','32','33','34','35','36','41','42','43','44','45','46','47','48') " +
	   			"and site_code='TA821'   AND SUBMIT_STATUS='P' " +gstCodeSQLString+
	   			"and prd_code='"+periodCode+"'";
   			pstmt = conn.prepareStatement(sql);
   			rs = pstmt.executeQuery();
   			if(rs.next())
			{
   				int amount = Integer.parseInt(checkNumberNull(rs.getString("amount")));
   				if(amount>0)
   				{
   					totalAmountMap.put("inwardMismatch","<font style='font-size: 15px; font-weight: 500;'>INR</font>  "+checkNumberNull(rs.getString("amount")));
   				}
   				else
   				{
   					totalAmountMap.put("inwardMismatch","No mismatch");
   				}
   			}
   			else
   			{
   				System.out.println("SQL does not return any data---------------------------Inward Mismatch");
   				totalAmountMap.put("inwardMismatch","No mismatch");
   			}
   			rs.close();
	   		rs = null;
	   		pstmt.close();
	   		pstmt = null;
	   		
   			labelTitleTypeMap =  new LinkedHashMap<String, String>();
   			labelTitleTypeMap.put("outwardTax", "Outward Tax");
   			labelTitleTypeMap.put("inwardTax", "Inward Tax");
   			labelTitleTypeMap.put("outwardMismatch", "Outward Mismatch");
   			labelTitleTypeMap.put("inwardMismatch", "Inward Mismatch");
   			
   			System.out.println("After map entry==============================\n imageTransactionMap: "+imageTransactionMap+"\n totalAmountMap: "+totalAmountMap+"\n labelTitleTypeMap: "+labelTitleTypeMap);
   			rowData = new JSONObject();
   			for(Entry<String, String> entry: labelTitleTypeMap.entrySet())
			{
   				
   				String mapKey = entry.getKey();
   				String imageName = imageTransactionMap.get(mapKey);
   				String totalAmount = totalAmountMap.get(mapKey);
   				String labelTitleType = labelTitleTypeMap.get(mapKey);
   				rowData.put("imageName"+count, imageName);
   				rowData.put("totalAmount"+count, totalAmount);
   				rowData.put("labelTitleType"+count, labelTitleType);
   				
   				count++;
			}
   			int cnt = 0;
   			rawDataTaxMismatchSummJson.put(cnt, rowData);
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} 
   			catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
   			}
   		}
   		return rawDataTaxMismatchSummJson;
   	 }
	@SuppressWarnings("unchecked")
	public JSONObject getInTransactionStatusSummary(String dataSourceName, String month, String year, String status, String gstCode, String sessionSiteCode ) throws RemoteException, ITMException
	{
		JSONObject rawDataTransactionStatusSummJson = new JSONObject();
   		JSONObject rowData             = null;
   		ResultSet rs                   = null;
   		PreparedStatement pstmt        = null;
   		Connection conn                = null;
   		ConnDriver connDriver          = new ConnDriver();
   		int count  					   = 0;
   		String sql = "";
   		String statusSQLString = "", gstCodeSQLString = "";
   		LinkedHashMap<String , String> tranStatusMap = new LinkedHashMap<String, String>();
   		DashboardUtility dashboardUtility = null;
   		try
   		{
   			conn       = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;	
   			String periodCode = generatePeriodCode(month, year,dataSourceName);
   			status = checkNull(status);
			dashboardUtility = new DashboardUtility();
			String statusUtility = dashboardUtility.getCommaSeparated(status);
			if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
			{
				statusSQLString = " and SUBMIT_STATUS in('P','T','S') ";
			}
			else
			{
				statusSQLString = " and SUBMIT_STATUS in ("+statusUtility+") ";
			}
			gstCode = checkNull(gstCode);
			String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
			if("".equalsIgnoreCase(gstCode))
			{
				gstCodeSQLString = " ";
			}
			/*else if(gstCode.equalsIgnoreCase("Unregistered"))
			{
				gstCodeSQLString = " and TAX_REG_NO is null ";
			}*/
			else
			{
				gstCodeSQLString = " and TAX_REG_NO in ("+gstCodeUtility+") ";
			}
   			sql = "SELECT SUM( CASE WHEN GSTHDR.SUBMIT_STATUS = 'P' THEN 1 ELSE 0 END) AS total_pending , " +
   				"SUM( CASE WHEN GSTHDR.SUBMIT_STATUS = 'T' THEN 1 ELSE 0 END) AS total_saved , " +
   				"SUM( CASE WHEN GSTHDR.SUBMIT_STATUS = 'S' THEN 1 ELSE 0 END) AS total_submitted , " +
   				"SUM( CASE WHEN GSTHDR.SUBMIT_STATUS IN ('P','T','S')  THEN 1 ELSE 0 END) AS final_total " +
   				"FROM GST_DATA_HDR GSTHDR , gst_data_det gstdet WHERE gsthdr.tran_id = gstdet.tran_id " +
   				"AND gsthdr.rec_type = '2' AND gsthdr.tran_type IN('01','02','03','04','05','06','07','09'," +
   				"'10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28'," +
   				"'29','30','31','32','33','34','35','36','41','42','43','44','45','46','47','48') " +
   				"AND gsthdr.prd_code = '"+periodCode+"' AND GSTHDR.SITE_CODE = '"+sessionSiteCode+"' " +
   				"AND gsthdr.SUBMIT_STATUS IN('P','T','S') "+gstCodeSQLString+" GROUP BY GSTHDR.SUBMIT_STATUS ORDER BY GSTHDR.SUBMIT_STATUS";
   			
   			pstmt = conn.prepareStatement(sql);
   			rs = pstmt.executeQuery();
   			if(rs.next())
			{
   				tranStatusMap.put("Pending Transaction", checkNumber(rs.getString("total_pending")));
   				tranStatusMap.put("Saved transaction", checkNumber(rs.getString("total_saved")));
   				tranStatusMap.put("Submitted transaction", checkNumber(rs.getString("total_submitted")));
   			}
   			System.out.println("===============tranStatusMap: "+tranStatusMap.toString());
   			for(Entry<String, String> entry: tranStatusMap.entrySet())
			{
   				rowData = new JSONObject();
   				String mapKey = entry.getKey();
   				String mapValue = entry.getValue();
   				rowData.put("label",mapKey);
   				rowData.put("value",mapValue);
   				rawDataTransactionStatusSummJson.put(count, rowData);
   				count++;
			}
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} 
   			catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataTransactionStatusSummJson;
	}
	
	@SuppressWarnings("unchecked")
	public JSONObject getOutTransactionStatusSummary(String dataSourceName, String month, String year, String status, String gstCode, String sessionSiteCode ) throws RemoteException, ITMException
	{
		JSONObject rawDataTransactionStatusSummJson = new JSONObject();
   		JSONObject rowData             = null;
   		ResultSet rs                   = null;
   		PreparedStatement pstmt        = null;
   		Connection conn                = null;
   		ConnDriver connDriver          = new ConnDriver();
   		int count  					   = 0;
   		String sql = "";
   		String statusSQLString = "", gstCodeSQLString = "";
   		LinkedHashMap<String , String> tranStatusMap = new LinkedHashMap<String, String>();
   		DashboardUtility dashboardUtility = null;
   		try
   		{
   			conn       = connDriver.getConnectDB(dataSourceName);
   			connDriver = null;	
   			String periodCode = generatePeriodCode(month, year,dataSourceName);
   			status = checkNull(status);
			dashboardUtility = new DashboardUtility();
			String statusUtility = dashboardUtility.getCommaSeparated(status);
			if(("Submitted,Saved,Pending".equalsIgnoreCase(status)) || ("".equalsIgnoreCase(status)))
			{
				statusSQLString = " and SUBMIT_STATUS in('P','T','S') ";
			}
			else
			{
				statusSQLString = " and SUBMIT_STATUS in ("+statusUtility+") ";
			}
			gstCode = checkNull(gstCode);
			String gstCodeUtility = dashboardUtility.getCommaSeparated(gstCode);
			if("".equalsIgnoreCase(gstCode))
			{
				gstCodeSQLString = " ";
			}
			/*else if(gstCode.equalsIgnoreCase("Unregistered"))
			{
				gstCodeSQLString = " and TAX_REG_NO is null ";
			}*/
			else
			{
				gstCodeSQLString = " and TAX_REG_NO in ("+gstCodeUtility+") ";
			}
   			sql = "SELECT SUM( CASE WHEN GSTHDR.SUBMIT_STATUS = 'P' THEN 1 ELSE 0 END) AS total_pending , " +
   				"SUM( CASE WHEN GSTHDR.SUBMIT_STATUS = 'T' THEN 1 ELSE 0 END) AS total_saved , " +
   				"SUM( CASE WHEN GSTHDR.SUBMIT_STATUS = 'S' THEN 1 ELSE 0 END) AS total_submitted , " +
   				"SUM( CASE WHEN GSTHDR.SUBMIT_STATUS IN ('P','T','S')  THEN 1 ELSE 0 END) AS final_total " +
   				"FROM GST_DATA_HDR GSTHDR , gst_data_det gstdet WHERE gsthdr.tran_id = gstdet.tran_id " +
   				"AND gsthdr.rec_type = '1' AND gsthdr.tran_type IN('01','02','03','04','05','06','07','09'," +
   				"'10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','26','27','28'," +
   				"'29','30','31','32','33','34','35','36','41','42','43','44','45','46','47','48') " +
   				"AND gsthdr.prd_code = '"+periodCode+"' AND GSTHDR.SITE_CODE = '"+sessionSiteCode+"' " +
   				"AND gsthdr.SUBMIT_STATUS IN('P','T','S') "+gstCodeSQLString+" GROUP BY GSTHDR.SUBMIT_STATUS ORDER BY GSTHDR.SUBMIT_STATUS";
   			
   			pstmt = conn.prepareStatement(sql);
   			String finalCount = "";
   			rs = pstmt.executeQuery();
   			if(rs.next())
			{
   				tranStatusMap.put("Pending Transaction", checkNumber(rs.getString("total_pending")));
   				tranStatusMap.put("Saved transaction", checkNumber(rs.getString("total_saved")));
   				tranStatusMap.put("Submitted transaction", checkNumber(rs.getString("total_submitted")));
   				finalCount = checkNumber(rs.getString("final_total"));
   			}
   			System.out.println("===============tranStatusMap: "+tranStatusMap.toString());
   			for(Entry<String, String> entry: tranStatusMap.entrySet())
			{
   				rowData = new JSONObject();
   				String mapKey = entry.getKey();
   				String mapValue = entry.getValue();
   				rowData.put("label",mapKey);
   				rowData.put("value",mapValue);
   				rowData.put("finalCount","#"+finalCount);
   				rawDataTransactionStatusSummJson.put(count, rowData);
   				count++;
   				finalCount = "0";
			}
   		}
   		catch (Exception e)
   		{
   			e.printStackTrace();
   			throw new ITMException(e);
   		}
   		finally
   		{
   			try
   			{
   				if (conn != null)
   				{
   					if (rs != null)
   					rs.close();
   					rs = null;
   					if (pstmt != null)
   					pstmt.close();
   					pstmt = null;
   					conn.close();
   					conn = null;
   				}
   				conn = null;
   			} 
   			catch (Exception d)
   			{
   				d.printStackTrace();
   				System.out.println("Exception in :TransactionInOutEJB:" + d.getMessage());
   				throw new ITMException(d);
   			}
   		}
   		return rawDataTransactionStatusSummJson;
	}
}
