/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.Skein;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersForSkein;

public class SkeinMac
implements Mac {
    private Skein skein;
    private long[] Xsave;

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        ParametersForSkein parametersForSkein = (ParametersForSkein)cipherParameters;
        KeyParameter keyParameter = (KeyParameter)parametersForSkein.getParameters();
        this.skein = new Skein(parametersForSkein.getStateSize(), parametersForSkein.getMacSize(), 0L, keyParameter.getKey());
        this.Xsave = this.skein.getState();
    }

    public String getAlgorithmName() {
        return this.skein.getAlgorithmName() + "/MAC";
    }

    public int getMacSize() {
        return this.skein.getDigestSize();
    }

    public void update(byte by) throws IllegalStateException {
        this.skein.update(by);
    }

    public void updateBits(byte[] byArray, int n, int n2) throws DataLengthException, IllegalStateException {
        this.skein.updateBits(byArray, n, n2);
    }

    public void update(byte[] byArray, int n, int n2) throws DataLengthException, IllegalStateException {
        this.skein.update(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        int n2 = this.skein.doFinal(byArray, n);
        this.reset();
        return n2;
    }

    public void reset() {
        this.skein.initialize(this.Xsave);
    }
}

