/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public abstract class BooleanFunction
implements Function {
    public final ValueEval evaluate(ValueEval[] args, int srcRow, short srcCol) {
        boolean boolResult;
        if (args.length < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            boolResult = this.calculate(args);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return BoolEval.valueOf(boolResult);
    }

    private boolean calculate(ValueEval[] args) throws EvaluationException {
        boolean result = this.getInitialResultValue();
        boolean atleastOneNonBlank = false;
        for (ValueEval arg : args) {
            Boolean tempVe;
            if (arg instanceof AreaEval) {
                AreaEval ae = (AreaEval)arg;
                int height = ae.getHeight();
                int width = ae.getWidth();
                for (int rrIx = 0; rrIx < height; ++rrIx) {
                    for (int rcIx = 0; rcIx < width; ++rcIx) {
                        ValueEval ve = ae.getRelativeValue(rrIx, rcIx);
                        Boolean tempVe2 = OperandResolver.coerceValueToBoolean(ve, true);
                        if (tempVe2 == null) continue;
                        result = this.partialEvaluate(result, tempVe2);
                        atleastOneNonBlank = true;
                    }
                }
                continue;
            }
            if (arg instanceof RefEval) {
                ValueEval ve = ((RefEval)arg).getInnerValueEval();
                tempVe = OperandResolver.coerceValueToBoolean(ve, true);
            } else {
                tempVe = OperandResolver.coerceValueToBoolean(arg, false);
            }
            if (tempVe == null) continue;
            result = this.partialEvaluate(result, tempVe);
            atleastOneNonBlank = true;
        }
        if (!atleastOneNonBlank) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return result;
    }

    protected abstract boolean getInitialResultValue();

    protected abstract boolean partialEvaluate(boolean var1, boolean var2);
}

