package ibase.e12ria.e12widgets.client;

import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * The E12PopupPanel class is component. It has been some action.
 * <BR><BR> <B> Action: </B> <BR>
 * When click on close (X) button then hide the Popup Panel
 * 
 * @author Dnyaneshwar Chavan    
 * */

public class E12PopupPanel extends PopupPanel implements ClickHandler
{
	/**The container is content all widgets of Popup Panel*/
	protected VerticalPanel container;
	
	/**The close label is hide a Popup panel when click it*/
	protected Label close;
	
	public E12PopupPanel()
	{
		this( true, true, "top", true );
	}
	
	public E12PopupPanel( boolean isClosable )
	{
		this(isClosable, false);
	}
	
	public E12PopupPanel( boolean isClosable, boolean isGradient )
	{
		this(isClosable, isGradient, "" );
	}
	
	public E12PopupPanel( boolean isClosable, boolean isGradient, String calloutPosition )
	{
		this(isClosable, isGradient, calloutPosition, false);
	}
	
	public E12PopupPanel( boolean isClosable, boolean isGradient, String calloutPosition, boolean isGlassEffect )
	{
		container = new VerticalPanel();

		setModal( true );
		setStyleName( "poupPanel" );

		if( isGlassEffect )
		{
			setGlassEnabled( true );
			setGlassStyleName( "bgGlass" );
		}
		
		if( isGradient )
		{
			container.addStyleName( "bubbleBox-grad" );
		}
		else
		{
			container.addStyleName( "bubbleBox-no-grad" );
		}
		
		if( calloutPosition.trim().length() > 0 )
		{
			container.addStyleName( "bubbleBox-grad" );
			container.addStyleName( calloutPosition );
		}
		
		if( isClosable )
		{
			close = new Label( "x" );
			close.addStyleName( "close" );
			close.addClickHandler( this );
			container.add( close );
			
			Element element =  (Element) close.getElement().getParentElement();
			
			if( element != null)
			{
				element.getParentElement().getStyle().setHeight(0, Unit.PX);
			}
		}
		setAutoHideEnabled( !isClosable );
	}
	
	@Override
	public void setWidget(Widget w) 
	{
		container.add( w );
		super.setWidget( container );
	}

	@Override
	public void onClick( ClickEvent event ) 
	{
		/* TODO: 
		if( E12Global.getInstance().getCurFrameOFTNC() != null )
		{
			E12Global.getInstance().getCurFrameOFTNC().setUrl( "null" );
		}
		*/
		container.clear();
//		container = null;
//		super.setWidget( container );
		super.hide();
	}
    @Override
    public void add(Widget w) 
    {
    	container.add( w );
    	super.add(w);
    }
    
    /**
     * This method added style name to container.
     * 
     * @param styleName is a secondary style name to added
     * */
    public void addStyleNameToContainer( String styleName )
    {
    	container.addStyleName( styleName );
    }
    
    /**
     * Clear the all style names of container.
     * set it to the given style name
     * 
     * @param styleName the new style name
     * 
     * */
    public void setStyleNameToContainer( String styleName )
    {
    	container.setStyleName( styleName );
    }
    
    /**
     * Clear the all style names of close label.
     * set it to the given style name
     * 
     * @param styleName the new style name
     * 
     * */
    public void setStyleNameToCloseLabel( String styleName )
    {
    	close.setStyleName(styleName);
    }
    
    @Override
    public void hide() 
    {
    	onClick( null );
    }

}
