package ibase.dashboard.scm.servlet;
import ibase.dashboard.scm.ejb.SalesInventoryRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class SalesInventoryDivWiseServlet extends HttpServlet
{
	
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		SalesInventoryRemote  salesInventoryRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String month = "";
		String nomns = "";		
		try
		{
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");

			dataSourceName          = request.getParameter("dataSourceName"); 
			month                   = (request.getParameter("month"));	
			nomns                   = (request.getParameter("nomns"));			
			System.out.println(" month======" + month+"nomns==="+nomns);
			context                 = new InitialContext(appConnectParm.getProperty());
			salesInventoryRemote    = (SalesInventoryRemote) context.lookup("ibase/SalesInventory/remote");
			//Here invoke EJB define method 
			/*setUserInfo(userInfo) for DB connection on dated:14062016*/
			salesInventoryRemote.setUserInfo(userInfo);
			JSONObject jsonObjData      = (JSONObject)salesInventoryRemote.getSalesInventoryDivWise(dataSourceName, month,nomns);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for SalesInventoryServlet build to Graph and Grid===" + jsonObjData);	
			
		} catch (Exception e)
		{
			System.out.println("Exception in: SalesInventoryDivWiseServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}