package ibase.webitm.ejb.dis;

import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class CustomerDetails extends ValidatorEJB
{
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ArrayList getCustomerDetails(String custCode) 
	{
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ArrayList custList = new ArrayList();
		boolean isExists = false;
		try 
		{
			conn = getConnection();
			/*sql = "SELECT  CUSTOMER.CUST_NAME ,  CUSTOMER.CURR_CODE,(SELECT COUNT(*) FROM SORDER WHERE CUST_CODE = ? AND ORDER_DATE <= SYSDATE) AS TOTAL_ORDER_TILL_DATE, "
			+ "  CONTACT.TELE1  AS CONTACT, CONTACT.NAME AS CONTACT_NAME, CONTACT.EMAIL_ADDR , "
			+ " (SELECT COUNT(*) FROM SORDER SORDER, DESPATCH DESPATCH WHERE SORDER.CUST_CODE = ? AND SORDER.STATUS NOT IN ('C','X','H')  "
				 + "	AND DESPATCH.SORD_NO = SORDER.SALE_ORDER AND DESPATCH.CONFIRMED = 'N') AS OPENORDERS, CUSTOMER.CUST_PRIORITY AS RANK, "
			     + "     CASE WHEN CRTERM.DESCR  IS NULL THEN CUSTOMER.CR_TERM ELSE CRTERM.DESCR END AS CRTERM_DESC ,CASE WHEN DELIVERY_TERM.DESCR IS NULL THEN CUSTOMER.DLV_TERM ELSE DELIVERY_TERM.DESCR END "
			     + "    AS DLVTERM_DESC, SALES_PERS.SP_NAME , SALES_PERS.EMAIL_ADDR AS SALES_EMAIL, CUSTOMER.BLACK_LISTED, 		CUSTOMER.BLACK_LISTED_DATE, (SELECT FN_OUVERDUE_CHECK(?) FROM DUAL) AS DUE_AMOUNT_TILL_DATE, CUSTOMER.CREDIT_LMT, CUSTOMER.WAVE_TYPE  "
				 + "	FROM CUSTOMER  CUSTOMER, CONTACT CONTACT ,CRTERM CRTERM, DELIVERY_TERM DELIVERY_TERM, SALES_PERS SALES_PERS "
				 + "	WHERE CUSTOMER.CONTACT_CODE = CONTACT.CONTACT_CODE "
			     + "	AND CUSTOMER.CR_TERM = CRTERM.CR_TERM(+) "
				 + "	AND CUSTOMER.DLV_TERM = DELIVERY_TERM.DLV_TERM(+) "
			     + "	AND SALES_PERS.SALES_PERS = CUSTOMER.SALES_PERS(+) "
				 + "	AND CUSTOMER.CUST_CODE = ? " ;*/
			sql="SELECT CUSTOMER.CUST_NAME , " +
					"  CUSTOMER.CURR_CODE, " +
					"  (SELECT COUNT(*) " +
					"  FROM SORDER " +
					"  WHERE CUST_CODE = ? " +
					//Commented by Santosh on 24/03/2017
					/*"  AND ORDER_DATE <= SYSDATE " +*/
					"  )             AS TOTAL_ORDER_TILL_DATE, " +
					"  CONTACT.TELE1 AS CONTACT, " +
					"  CONTACT.NAME  AS CONTACT_NAME, " +
					"  CONTACT.EMAIL_ADDR , " +
					"  (SELECT COUNT(*) " +
					//Commented by Santosh on 24/03/2017
					/*"  FROM SORDER SORDER, " +
					"    DESPATCH DESPATCH " +*/
					"  FROM SORDER SORDER " +
					"  WHERE SORDER.CUST_CODE = ? " +
					"  AND SORDER.STATUS NOT IN ('C','X','H') " +
					//Commented by Santosh on 24/03/2017
					/*"  AND DESPATCH.SORD_NO   = SORDER.SALE_ORDER " +
					"  AND DESPATCH.CONFIRMED = 'N' " +*/
					"  )                      AS OPENORDERS, " +
					"  CUSTOMER.CUST_PRIORITY AS RANK, " +
					"  CASE " +
					"    WHEN CRTERM.DESCR IS NULL " +
					"    THEN CUSTOMER.CR_TERM " +
					"    ELSE CRTERM.DESCR " +
					"  END AS CRTERM_DESC , " +
					"  CASE " +
					"    WHEN DELIVERY_TERM.DESCR IS NULL " +
					"    THEN CUSTOMER.DLV_TERM " +
					"    ELSE DELIVERY_TERM.DESCR " +
					"  END AS DLVTERM_DESC, " +
					"  SALES_PERS.SP_NAME , " +
					"  SALES_PERS.EMAIL_ADDR AS SALES_EMAIL, " +
					"  CUSTOMER.BLACK_LISTED, " +
					"  CUSTOMER.BLACK_LISTED_DATE, " +
					"  (SELECT FN_OUVERDUE_CHECK(?) FROM DUAL " +
					"  ) AS DUE_AMOUNT_TILL_DATE, " +
					"  CUSTOMER.CREDIT_LMT, " +
					"  CUSTOMER.WAVE_TYPE, " +
					"  (SELECT FN_PAYAMT_CHECK(?) FROM DUAL " +
					"  ) AS PAY_AMOUNT, " +
					" CUSTOMER.TAX_REG_2 AS GST_TAX_REG"+//Added by PriyankaC on 28July2017.
					" FROM CUSTOMER CUSTOMER, " +
					"  CONTACT CONTACT , " +
					"  CRTERM CRTERM, " +
					"  DELIVERY_TERM DELIVERY_TERM, " +
					"  SALES_PERS SALES_PERS " +
					" WHERE CUSTOMER.CONTACT_CODE = CONTACT.CONTACT_CODE " +
					" AND CUSTOMER.CR_TERM        = CRTERM.CR_TERM(+) " +
					" AND CUSTOMER.DLV_TERM       = DELIVERY_TERM.DLV_TERM(+) " +
					" AND SALES_PERS.SALES_PERS   = CUSTOMER.SALES_PERS(+) " +
					" AND CUSTOMER.CUST_CODE      = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, checkNull(custCode));
			pstmt.setString(2, checkNull(custCode));
			pstmt.setString(3, checkNull(custCode));
			pstmt.setString(4, checkNull(custCode));
			pstmt.setString(5, checkNull(custCode));

			rs = pstmt.executeQuery();
			if ( rs.next())
			{
				custList.add(checkNull(rs.getString("CUST_NAME")));
				custList.add(checkNull(rs.getString("CURR_CODE")));
				custList.add(checkNull(rs.getString("TOTAL_ORDER_TILL_DATE")));
				custList.add(checkNull(rs.getString("CONTACT")));
				custList.add(checkNull(rs.getString("EMAIL_ADDR")));
				custList.add(checkNull(rs.getString("OPENORDERS")));
				custList.add(checkNull(rs.getString("RANK")));
				custList.add(checkNull(rs.getString("CRTERM_DESC")));
				custList.add(checkNull(rs.getString("DLVTERM_DESC")));
				custList.add(checkNull(rs.getString("SP_NAME")));
				custList.add(checkNull(rs.getString("SALES_EMAIL")));
				custList.add(checkNull(rs.getString("BLACK_LISTED")));
				custList.add(rs.getDate("BLACK_LISTED_DATE")== null?"":rs.getDate("BLACK_LISTED_DATE"));
				System.out.println("rs.getDate(BLACK_LISTED_DATE) ::::: "+rs.getDate("BLACK_LISTED_DATE"));
				custList.add(checkNull(rs.getString("DUE_AMOUNT_TILL_DATE")));
				System.out.println("Due Amount");
				custList.add(checkNull(rs.getString("CREDIT_LMT")));
				custList.add(checkNull(rs.getString("CONTACT_NAME")));
				custList.add(checkNull(rs.getString("WAVE_TYPE")));
				custList.add(checkNull(rs.getString("PAY_AMOUNT")));
				custList.add(checkNull(rs.getString("GST_TAX_REG")));
				isExists = true;
			}
			if(!isExists)
			{
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
				custList.add("");
			}
			if (rs != null) 
			{					
				rs.close();
				rs = null;
			}
			if (pstmt != null ) 
			{					
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e) 
		{
			System.out.println(" Exception in CustomerDetails.getCustomerDetails()["+e.getMessage()+"]");
			e.printStackTrace();
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{					
					rs.close();
					rs = null;
				}
				if (pstmt != null ) 
				{					
					pstmt.close();
					pstmt = null;
				}
				if (conn != null ) 
				{					
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception in CustomerDetails.getCustomerDetails()");
				e.printStackTrace();
			}
		}
		System.out.println("return String :" + custList);
		return custList;
	}
	public String getCustomerImage(String custCode, String custName) throws ITMException
	{
		String custImg = "";
		try
		{
			//Changed by Santosh on 24/03/2017
			/*WavegenWizEJB wavegenWizEJB = new WavegenWizEJB();
			
			custImg = wavegenWizEJB.getCustomImagePath(custCode, custName, "customer");*/
			DistUtility distUtility = new DistUtility();
			custImg = distUtility.getImagePath("w_customer", custCode, custName, "customer", null);
			System.out.println("ItemListBean.getItemListDetails()["+custImg+"]");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return custImg;
	}
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}

}
