/**
* PURPOSE : PalletizationPos component
* AUTHOR : Sneha Mestry
* DATE : 05-10-2015
*/

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.InvAllocTraceBean;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.wms.CommonWmsUtil;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@javax.ejb.Stateless
public class PalletizationPos extends ValidatorEJB implements PalletizationPosLocal, PalletizationPosRemote
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave( String domString, String tranId, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException
	{
		InvAllocTraceBean invAllocTrace = new InvAllocTraceBean();
		
		String errString = "", siteCode = "",lineNo = "", locCode = "", itemCode = "", lotNo = "", lotSl = "", quantity = "", objName = "",
				updateFlag = "", palletNo = "",  allocQty = "";
        double actualQuantity = 0, actualAllocQty = 0;
        HashMap strAllocate = new HashMap();
        Connection conn1 = null;
        boolean isError = false;
        boolean isDelete = false;		        
        try
		{
        	//Changed and Commented By Santosh on 14-06-2016 :[START]
    		//ConnDriver connDriver = new ConnDriver();
			//conn1 = connDriver.getConnectDB("DriverITM");
        	conn1 = getConnection();
			conn1.setAutoCommit(false);
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
	
			E12GenericUtility genericUtility = new E12GenericUtility();
			Document dom = null;
			dom = genericUtility.parseString(domString);
			
			String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();
			java.util.Date currDate1 = new java.util.Date();
			SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);
			String currDateStr = sdf.format(currDate1);
			Timestamp tranDate = Timestamp.valueOf(genericUtility.getValidDateString( currDateStr , applDateFormat, dbDateFormat ) + " 00:00:00.0");

			
			
			System.out.println("Calling Post Save for Palletization @@@@@@@@ ::::::::::::: " );
			System.out.println("domString ::::::::::::: " + domString);
			System.out.println("xtraParams ::::::::::::: " + xtraParams);
			System.out.println("tranId ::::::::::::: " + tranId);
			
			lineNo = checkNullAndTrim(genericUtility.getColumnValue("line_no", dom, "3" ));
			updateFlag = getUpdateFlagFromDom(dom, "3");
			System.out.println("updateFlag--------->>["+updateFlag+"]");
			
			if(!"E".equalsIgnoreCase(updateFlag))
			{
				
				if( tranId != null && tranId.trim().length() > 0 && lineNo != null && lineNo.trim().length() > 0)
				{
					System.out.println("Inside if loop for post save palletization ::::::::: " );
					
					siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));	
					itemCode = checkNull(genericUtility.getColumnValue("item_code", dom, "3" ));
					palletNo = checkNull(genericUtility.getColumnValue("pallet_no", dom, "3" ));
					locCode = checkNull(genericUtility.getColumnValue("loc_code", dom, "3" ));	
					lotNo = checkNull(genericUtility.getColumnValue("lot_no", dom, "3" ));
					lotSl = checkNull(genericUtility.getColumnValue("lot_sl", dom, "3" ));
					quantity = checkNull(genericUtility.getColumnValue("quantity", dom, "3" ));
					allocQty = checkNull(genericUtility.getColumnValue("alloc_qty", dom, "3" ));
					actualQuantity = Double.parseDouble(quantity);
					actualAllocQty = Double.parseDouble(allocQty);
					/*
					System.out.println("lineNo----------->>["+lineNo+"]");
					System.out.println("siteCode----------->>["+siteCode+"]");
					System.out.println("itemCode----------->>["+itemCode+"]");
					System.out.println("locCode----------->>["+locCode+"]");
					System.out.println("lotNo----------->>["+lotNo+"]");
					System.out.println("lotSl----------->>["+lotSl+"]");
					System.out.println("allocQty----------->>["+allocQty+"]");
					System.out.println("quantity----------->>["+quantity+"]");
			        
			        System.out.println("actualQuantity from DOM ----------->>["+actualQuantity+"]");
			        System.out.println("actualAllocQty----------->>["+actualAllocQty+"]");*/
			        
			        actualQuantity = actualQuantity - actualAllocQty;
			        System.out.println("actualQuantity to be allocated ----------->>["+actualQuantity+"]");
			        
					if("D".equalsIgnoreCase(updateFlag))
					{
						isDelete = true;
					}

					if (actualQuantity != 0)
					{
						strAllocate.put("tran_date", tranDate);
						strAllocate.put("ref_ser","PZ");
						strAllocate.put("ref_id", tranId);
						strAllocate.put("ref_line", lineNo);
						strAllocate.put("site_code", siteCode);
						strAllocate.put("item_code", itemCode);
						strAllocate.put("loc_code", locCode);
						strAllocate.put("lot_no", lotNo);
						strAllocate.put("lot_sl", lotSl);
						
						if(isDelete)
						{
							strAllocate.put("alloc_qty", -actualQuantity);
						}
						else
						{
							strAllocate.put("alloc_qty", actualQuantity);
						}
						
						strAllocate.put("chg_user", genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));
						strAllocate.put("chg_term", genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));
						strAllocate.put("chg_win", "W_PALLETIZATION");
						
						errString = invAllocTrace.updateInvallocTrace(strAllocate, conn1);
					}
					
					
					System.out.println("errString ::: " + errString);
					if (errString != null && errString.trim().length() > 0 )
					{
						isError = true;
						return errString;
					}
					strAllocate = null;
					System.out.println("Allocated complete for the quantity in stock::::::::::: ");
				}
			}
		}	
		catch(Exception e)
		{
			try
			{
				System.out.println("Exception "+e.getMessage());
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				isError = true;
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		}
		finally
		{
			try
			{	
				if( !isError  )
				{
					System.out.println("commmit");
					conn1.commit();  
				}
				else if ( isError )
				{
					System.out.println("rollback");
					conn1.rollback();
				}			
				if (conn1 != null)
				{
					conn1.close();
					conn1 = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}	
	
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input.trim();
	}
	
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}

	private String getUpdateFlagFromDom( Document dom,  String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node attrbNode = null, detailNode = null, reqDetail = null;
		String retString = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();			
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{				
				detailNode = detailList.item(ctr);
				System.out.println("detail node::::::::::: ");
				
				if(detailNode != null)
				{
					System.out.println("detail node::::::::::: "+detailNode.getNodeName());
					NodeList attrbNodeList = detailNode.getChildNodes();
					
					for (int ctrA = 0; ctrA < attrbNodeList.getLength(); ctrA++)
					{
						attrbNode = attrbNodeList.item(ctrA);
					
						if(attrbNode != null)
						{
							if( attrbNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							System.out.println("attrbNode node::::::::::: "+attrbNode.getNodeName());
							if(attrbNode != null && "attribute".equalsIgnoreCase(attrbNode.getNodeName()))
							{
								System.out.println("attrbNode node::::::::::: ");
								retString = attrbNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
								//return retString;
							}
						}
					}
				}
			}			
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return retString;
	}
}


