package ibase.webitm.utility.wms;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

public class DDInvoiceConfSchedule implements Schedule
{
	String chgUser = null;
	String chgTerm = null;
	static long count_records=0;
	boolean isError = false;
	static int Lineno =0;

	public String schedulePriority( String wrkflwPriority )throws Exception
	{
		return "";
	}
	public String schedule(HashMap map)throws Exception
	{
		return "";
	}
	public String schedule(String scheduleParamXML)throws Exception
	{
		String siteCode = "";
		ibase.utility.UserInfoBean userInfo = null;
		String xtraParams = "";
		try
		{
			System.out.println("Schedule Param ["+scheduleParamXML+"]");
			userInfo = new ibase.utility.UserInfoBean(scheduleParamXML);
			xtraParams= getXtraParams( userInfo );
			System.out.println("xtraParams=======["+xtraParams+"]");
			invoiceSchdule(xtraParams);
			System.out.println("Final Return from schedular");
		}
		catch(Exception e)
		{
			throw new Exception(e);
		}
		return "";
	}
	public String invoiceSchdule(String xtraParams) throws RemoteException,ITMException
	{

		String sql = "", invoiceId = "";
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;


		try
		{
			ConnDriver connDriver = new ConnDriver(); 
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);
			System.out.println(" Calling Invoice Confirm process *************$$$$$$$$**********************");
			System.out.println("xtraParams=======["+xtraParams+"]");
			sql = " SELECT INVOICE_ID FROM INVOICE WHERE CONFIRMED = 'N' ";
			pstmt = conn.prepareStatement(sql);
			rs=pstmt.executeQuery();
			while(rs.next())
			{
				invoiceId = rs.getString(1);
				errString = confirmInvoice("invoice", invoiceId, xtraParams, "", conn);
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
		}
		catch(Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{

			try
			{
				System.out.println("Error in finally"+isError);
				if(isError)
				{	
					System.out.println("in rollback");
					conn.rollback();				
				}
				else
				{
					System.out.println("in commit");
					conn.commit();
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(conn != null)
				{	
					conn.close();
					conn = null;
				}
			}
			catch(Exception ex)
			{
				System.out.println("Exception is "+ex.getMessage());
			}
		}
		return errString;
	} //verify vendor schdule()

	public String confirmInvoice(String businessObj, String tranIdFr,String xtraParams, String forcedFlag, Connection conn) throws ITMException
	{

		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("-------in confirmInvoice mothod@@----------------["+xtraParams+"]");			
			tranIdFr=tranIdFr==null ? "" :tranIdFr.trim();
			System.out.println("Tran id for Invoice--->>"+tranIdFr+"]");
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;

			sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'pre_confirm' ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,businessObj);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				serviceCode = rs.getString("SERVICE_CODE");
				compName = rs.getString("COMP_NAME");
			}
			compName=compName==null ? "" :compName.trim();
			System.out.println("serviceCode = ["+serviceCode+"]   compName ["+compName+"]");
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,serviceCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				serviceURI = rs.getString("SERVICE_URI");
			}
			serviceURI=serviceURI==null ? "" :serviceURI.trim();
			System.out.println("serviceURI = ["+serviceURI+"]---> compName = ["+compName+"]");
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI);
			Object[] aobj = new Object[4];

			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(compName);
			aobj[1] = new String(tranIdFr);
			aobj[2] = new String(xtraParams);
			aobj[3] = new String(forcedFlag);
			//System.out.println("@@@@@@@@@@loginEmpCode:" +genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode")+":");
			System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) executed........");
			call.setReturnType(XMLType.XSD_STRING);

			retString = (String)call.invoke(aobj);

			System.out.println("Confirm Complete @@@@@@@@@@@ Return string from NVO is:==>["+retString+"]");

		}
		catch(Exception e)
		{			
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{		
			try{
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (rs !=null)
				{
					rs.close();
					rs=null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				try{
					conn.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		return retString;

	}
	public String getXtraParams( UserInfoBean userInfoBean )throws Exception
	{
		String XTRA_PARAMS_SEPARATOR = "~~";
		StringBuffer xtraParamsBuff = new StringBuffer();
		xtraParamsBuff.append("loginCode=" + userInfoBean.getLoginCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + userInfoBean.getEmpCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + userInfoBean.getSiteCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + userInfoBean.getEntityCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + userInfoBean.getProfileId());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userInfoBean.getUserType());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userInfoBean.getUserLanguage());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userInfoBean.getUserCountry());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + userInfoBean.getCharEnc());		
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId="+userInfoBean.getRemoteHost());

		String chgTerm = userInfoBean.getRemoteHostName();
		if( chgTerm != null && chgTerm.length() > 15 )
		{
			chgTerm = chgTerm.substring(0, 15);
		}
		else if( chgTerm == null || chgTerm.length() == 0 )
		{
			chgTerm = userInfoBean.getRemoteHost();
		}
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm );

		System.out.println("xtraParamsBuff ["+xtraParamsBuff+"]");

		return xtraParamsBuff.toString();
	}
}
