/*
 * Author:Samadhan Pawar
 * Date:14-07-2017
 * Request ID:S16EBAS006 (GST Wizard)
 */

package ibase.webitm.servlet.gst;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.gst.GstRegNoICRemote;
import ibase.webitm.ejb.gst.GstrCustomTranEJBRemote;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GstrCustomTranServlet extends HttpServlet 
{
	private static final long serialVersionUID = 1L;
	InitialContext ctx = null;

    public GstrCustomTranServlet() {
        super();
    }

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		doPost( request, response );
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ GstrCustomTranServlet START]XXXXXXXXXXXXXXXXXXXX");
		request.setCharacterEncoding(CommonConstants.ENCODING);
		String action = "", responseXML = "", htmlData = "";
		try 
		{	
			action = request.getParameter("action");
			System.out.println("GstrCustomTranServlet ACTION ["+action+"]");

			if("SAVE_DATA".equalsIgnoreCase(action))
			{
				ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )request.getSession().getAttribute( "USER_INFO" );
				if(userInfo != null)
				{
					String objName 	= request.getParameter("OBJ_NAME");
					String tranXml 	= request.getParameter("ALL_ELEMENTS");
					
				
					System.out.println("OBJ_NAME["+objName+"]");
					
					ctx=getInitialContext();
					GstrCustomTranEJBRemote GstrCustomTranEJBRemote = (ibase.webitm.ejb.gst.GstrCustomTranEJBRemote) ctx.lookup("ibase/GstrCustomTranEJB/remote");
					responseXML = GstrCustomTranEJBRemote.saveRecord(objName, tranXml, userInfo);
					
					//responseXML = gstRegNoRemote.handleRequest(requestParamMap);
				}
				else
				{
					responseXML = "GstrCustomTranServlet_notLoggedIn";
					System.out.println("htmlData ["+htmlData+"]");
				}
			}
			if("UPDATE_DATA".equalsIgnoreCase(action))
			{
				ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )request.getSession().getAttribute( "USER_INFO" );
				if(userInfo != null)
				{
					String objName 	= request.getParameter("OBJ_NAME");
					String tranXml 	= request.getParameter("ALL_ELEMENTS");
					
					System.out.println("OBJ_NAME["+objName+"]");
					
					ctx=getInitialContext();
					GstrCustomTranEJBRemote GstrCustomTranEJBRemote = (ibase.webitm.ejb.gst.GstrCustomTranEJBRemote) ctx.lookup("ibase/GstrCustomTranEJB/remote");
					responseXML = GstrCustomTranEJBRemote.updateRecord(objName, tranXml, userInfo);
					
					//responseXML = gstRegNoRemote.handleRequest(requestParamMap);
				}
				else
				{
					responseXML = "GstrCustomTranServlet_notLoggedIn";
					System.out.println("htmlData ["+htmlData+"]");
				}
			}
			if("GET_DATA".equalsIgnoreCase(action))
			{
				ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )request.getSession().getAttribute( "USER_INFO" );
				if(userInfo != null)
				{
					String objName 	= request.getParameter("OBJ_NAME");
					String prdCode 	= request.getParameter("PRD_CODE");
					
					System.out.println("OBJ_NAME["+objName+"]");
					
					ctx=getInitialContext();
					GstrCustomTranEJBRemote GstrCustomTranEJBRemote = (ibase.webitm.ejb.gst.GstrCustomTranEJBRemote) ctx.lookup("ibase/GstrCustomTranEJB/remote");
					responseXML = GstrCustomTranEJBRemote.getRecords(objName, prdCode, userInfo);
					
					//responseXML = gstRegNoRemote.handleRequest(requestParamMap);
				}
				else
				{
					responseXML = "GstrCustomTranServlet_notLoggedIn";
					System.out.println("htmlData ["+htmlData+"]");
				}
			}


			if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
			{
				response.setHeader("Content-Encoding", "gzip");
				GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
				gzOutStream.write(responseXML.getBytes());
				gzOutStream.flush();
				gzOutStream.close();
			}
			else
			{
				response.setHeader("Content-Encoding", "");
				OutputStream outStream = response.getOutputStream();
				outStream.write(responseXML.getBytes());
				outStream.flush();
				outStream.close();
			}

		} 
		catch (Exception e) 
		{
			System.out.println("GstrCustomTranServlet.doPost():doPost"+e.getMessage());
			e.printStackTrace();
			response.setHeader("Content-Encoding", "");
			OutputStream outStream = response.getOutputStream();
			outStream.write(e.getMessage().getBytes());
			outStream.flush();
			outStream.close();
		}

		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ GstrCustomTranServlet END]XXXXXXXXXXXXXXXXXXXX");
	}
	
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("GstrCustomTranServlet.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("GstrCustomTranServlet.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}
}
