/* 
	Developed by : vijay
	Company : Base Information Management Pvt. Ltd
	Version : 1.0
	Date :12/01/2011
*/

package ibase.webitm.ejb.mfg.adv;

import java.rmi.RemoteException;
import java.lang.String;
import java.sql.*;
import org.w3c.dom.*;
import javax.ejb.*;

import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
//import ibase.webitm.utility.GenericUtility;
import ibase.system.config.*;
import ibase.webitm.ejb.ITMDBAccessEJB;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3
public class WoEnchAct extends ActionHandlerEJB implements WoEnchActLocal, WoEnchActRemote
{
	

    public String actionHandler() throws RemoteException,ITMException
	{
		return "";
	}

	public String actionHandler(String actionType, String xmlString,String xmlString1, String objContext, String xtraParams) throws RemoteException,ITMException
	{
		
		Document dom = null;
		Document dom1 = null;
		String  resString = null;
		try
		{
			//GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new E12GenericUtility();
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString);
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				System.out.println("XML String1 :"+xmlString1);
				dom1 = genericUtility.parseString(xmlString1); 
			}
			System.out.println("actionType:"+actionType);
			if (actionType.equalsIgnoreCase("Stock"))
			{
				resString = actionStock(dom,dom1,objContext,xtraParams);
			}
			System.out.println("actionType:"+actionType);
			if (actionType.equalsIgnoreCase("Allocate"))
			{
				resString = actionAllocate(dom,dom1,objContext,xtraParams);
			}
			
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :WoEnhancement :actionHandler(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning from action[Stock] actionHandler"+resString);
	    return (resString);
	}

	public String actionHandlerTransform(String actionType, String xmlString, String xmlString1, String objContext, String xtraParams, String selDataStr) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document selDataDom = null;

		String  retString = null;
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				//dom = GenericUtility.getInstance().parseString(xmlString); 
				dom = genericUtility.parseString(xmlString); 
				//dom1 = GenericUtility.getInstance().parseString(xmlString1);
				dom1 = genericUtility.parseString(xmlString1);
				if(selDataStr != null && selDataStr.length() > 0)
				{
					//selDataDom = GenericUtility.getInstance().parseString(selDataStr);
					selDataDom = genericUtility.parseString(selDataStr);
				}
			}
			System.out.println("actionType:"+actionType+":");
						
			if (actionType.equalsIgnoreCase("Stock"))
			{
				retString = stockTransform(dom, dom1, objContext, xtraParams, selDataDom);
			}
			
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :WoEnhancement :actionHandlerTransform(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from WoEnhancement : actionHandlerTransform"+retString);
	    return retString;
	}

	private String actionStock(Document dom,Document dom1, String objContext, String xtraParams) throws RemoteException , ITMException
	{
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		String sql = "";
		String errCode = "";
		String siteCode = "";
		String itemCode = "";
		String quantity = "";
		String ccQuantity = "";
		String locCode = "";
		String lotNo = "";
		String itemSer = "";
		String unit = "";
		String lotSl = "";
		java.sql.Date expDate = null;
		java.sql.Date retestDate = null;
		String packCode = "";
		String stkRetestDate = "";
		String stkExpDate = "";
		
		int row = 0;
		StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
		if (dom == null)
		{
			valueXmlString.append("</Root>\r\n");
			return valueXmlString.toString();
		}
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new E12GenericUtility();
		ConnDriver connDriver = new ConnDriver();
		try
		{		
			//Changed by Poonam Gole for changing connection object :Start
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection() ;
			//Changed by Poonam Gole for changing connection object :End
		
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			siteCode = genericUtility.getColumnValue("site_code",dom1);
			itemCode = genericUtility.getColumnValue("item_code",dom);
			quantity = genericUtility.getColumnValue("quantity",dom);
			locCode = genericUtility.getColumnValue("loc_code",dom);
			lotNo = genericUtility.getColumnValue("lot_no",dom);
			
			System.out.println("FRom DOM:siteCode:"+siteCode+":itemCode:"+itemCode+":quantity:"+quantity+":");
			System.out.println("FRom DOM:lotNo:"+lotNo+":locCode:"+locCode+":");
			
			
			sql=" SELECT COUNT(*) FROM STOCK A, INVSTAT B "+
				" WHERE A.INV_STAT  = B.INV_STAT AND A.ITEM_CODE =?"+
				" AND A.SITE_CODE =?"+
				" AND (CASE WHEN ((CASE WHEN A.QUANTITY IS NULL THEN 0 ELSE A.QUANTITY END) - (CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END)) "+
				" IS NULL THEN 0 ELSE ((CASE WHEN A.QUANTITY IS NULL THEN 0 ELSE A.QUANTITY END) - (CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END)) END )  > 0 ";
			System.out.println("sql:"+sql);
			stmt = conn.prepareStatement(sql);
			stmt.setString(1,itemCode);
			stmt.setString(2,siteCode);
			rs1 = stmt.executeQuery();
			if(rs1.next())
			{
				row = rs1.getInt(1);
			}
			rs1.close();
			rs1 = null;
			
			
			System.out.println("row:"+row);
			if(row > 0)
			{
				//errCode = "VTSTOCK1";
				if(lotNo == null)
				{
					lotNo = "";
				}
				if(locCode == null)
				{
					locCode = "";
				}
				if(quantity == null)
				{
					quantity = "0";
				}
				
				sql = "SELECT STOCK.ITEM_SER,STOCK.ITEM_CODE, "+
						 "STOCK.UNIT,STOCK.LOC_CODE,STOCK.LOT_NO, "+
						 "STOCK.LOT_SL, "+
						 "STOCK.QUANTITY - STOCK.ALLOC_QTY - "+
						 "(CASE WHEN STOCK.HOLD_QTY IS NULL THEN 0 "+
						 "ELSE STOCK.HOLD_QTY END ) AS QUANTITY, "+  
						 "STOCK.SITE_CODE,STOCK.EXP_DATE,STOCK.RETEST_DATE, "+
						 "STOCK.PACK_CODE, "+
						 "STOCK.QUANTITY - STOCK.ALLOC_QTY - (CASE WHEN STOCK.HOLD_QTY IS "+
					     "NULL THEN 0 ELSE STOCK.HOLD_QTY END) AS CC_QUANTITY, "+
					     "STOCK.RETEST_DATE "+ 
						 "FROM STOCK,INVSTAT "+ 
						 "WHERE ( STOCK.INV_STAT = INVSTAT.INV_STAT ) AND "+ 
						 "( STOCK.ITEM_CODE = ? ) AND "+
						 "( STOCK.SITE_CODE = ? ) AND "+ 
						 "((STOCK.QUANTITY - STOCK.ALLOC_QTY - CASE WHEN STOCK.HOLD_QTY "+ 
						 "IS NULL THEN 0 ELSE STOCK.HOLD_QTY END) > 0 ) AND "+ 
						 "( NVL(INVSTAT.STAT_TYPE,' ') <> 'S') AND "+  
					     "(STOCK.EXP_DATE IS NULL OR "+
					     "STOCK.EXP_DATE >sysdate or "+
					     "STOCK.RETEST_DATE >sysdate) and "+
					     "( INVSTAT.AVAILABLE = 'Y' ) "+  
					     "ORDER BY STOCK.PARTIAL_USED ASC, NVL(STOCK.EXP_DATE, "+
					     "STOCK.CREA_DATE) ASC, STOCK.LOT_NO ASC, "+ 
					     "STOCK.LOT_SL ASC ";
				stmt = conn.prepareStatement(sql);
				stmt.setString(1,itemCode);
				stmt.setString(2,siteCode);
				rs = stmt.executeQuery();
				while(rs.next())
				{
					itemSer = rs.getString(1);
					itemCode = rs.getString(2);
					unit = rs.getString(3);
					locCode = rs.getString(4);
					lotNo =( rs.getString(5) ==null ?"" :rs.getString(5));
					lotSl = rs.getString(6);
					quantity = rs.getString(7);
					siteCode = rs.getString(8);
					expDate = rs.getDate(9) ;
					retestDate = rs.getDate(10);
					packCode = rs.getString(11);
					ccQuantity = rs.getString(12);
					valueXmlString.append("<Detail>\r\n");
					
					if(lotNo.trim().length() ==0)
					{
						lotNo =" ";
					}
					if(locCode.trim().length() ==0)
					{
						locCode =" ";
					}
					if(lotSl.trim().length() ==0)
					{
						lotSl =" ";
					}
					if(unit.trim().length() ==0)
					{
						unit =" ";
					}
					if(siteCode.trim().length() ==0)
					{
						siteCode =" ";
					}
					if(itemSer.trim().length() ==0)
					{
						siteCode =" ";
					}
					valueXmlString.append("<item_ser>").append("<![CDATA[").append(itemSer == null?"":itemSer.trim()).append("]]>").append("</item_ser>\r\n");
					valueXmlString.append("<item_code>").append("<![CDATA[").append(itemCode == null?"":itemCode.trim()).append("]]>").append("</item_code>\r\n");
					valueXmlString.append("<unit>").append("<![CDATA[").append(unit == null?"":unit.trim()).append("]]>").append("</unit>\r\n");
					valueXmlString.append("<loc_code>").append("<![CDATA[").append(locCode == null?"":locCode.trim()).append("]]>").append("</loc_code>\r\n");
					valueXmlString.append("<lot_no>").append("<![CDATA[").append(lotNo ==null ?"":lotNo).append("]]>").append("</lot_no>\r\n");
					valueXmlString.append("<lot_sl>").append("<![CDATA[").append(lotSl ==null ?"":lotSl).append("]]>").append("</lot_sl>\r\n");
					valueXmlString.append("<quantity>").append("<![CDATA[").append(quantity).append("]]>").append("</quantity>\r\n");
					valueXmlString.append("<site_code>").append("<![CDATA[").append(siteCode).append("]]>").append("</site_code>\r\n");
					
					if(expDate != null)
					{
						stkExpDate = sdf.format(expDate);
					}
					System.out.println("stkExpDate....:"+stkExpDate);
					if(stkExpDate.trim().length() ==0)
					{
					  stkExpDate =" ";
					}
					if(retestDate != null)					 
					{
						stkRetestDate = sdf.format(retestDate);
					}
					System.out.println("stkRetestDate....:"+stkRetestDate);
					
					if(stkRetestDate.trim().length() ==0)
					{
					  stkRetestDate =" ";
					}
					
					
					valueXmlString.append("<exp_date>").append("<![CDATA[").append(stkExpDate).append("]]>").append("</exp_date>\r\n");
					valueXmlString.append("<retest_date>").append("<![CDATA[").append(stkRetestDate).append("]]>").append("</retest_date>\r\n");
					valueXmlString.append("</Detail>\r\n");
				}//end while
			}
			valueXmlString.append("</Root>\r\n");
		}
		catch(SQLException e)
		{
			System.out.println("Exception : WoEnhancement : actionStock " +e.getMessage());
			throw new ITMException(e);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception : WoEnhancement : actionHandler :(Document dom)" +e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try{
				
				rs.close();
				rs =null;
				stmt.close();
				stmt=null;
				conn.close();
				conn = null;
			}catch(Exception e){}
		}
		System.out.println("valueXmlString.toString() "+valueXmlString.toString());
		return valueXmlString.toString();		
	}
	private String actionAllocate(Document dom,Document dom1, String objContext, String xtraParams) throws RemoteException , ITMException
	{
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		String sql = "";
		String errCode = "";
		String siteCode = "";
		String itemCode = "";
		String quantity = "";
		String ccQuantity = "";
		String locCode = "";
		String lotNo = "";
		String itemSer = "";
		String unit = "";
		String lotSl = "";
		java.sql.Date expDate = null;
		java.sql.Date retestDate = null;
		String packCode = "";
		String stkRetestDate = "";
		String stkExpDate = "";
		double orderedQuantity = 0,stkQuantity = 0,totalStkQuantity = 0;
		ArrayList stockDetailList=new ArrayList();
		StockStructRec stockRec =null;
		String userId ="",issCriteria = "", errString = "",expLevel = "",lineNo = null;
		ITMDBAccessEJB itmDbAccess = new ITMDBAccessEJB();
		
		int row = 0;
		StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
		if (dom == null)
		{
			valueXmlString.append("</Root>\r\n");
			return valueXmlString.toString();
		}
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new E12GenericUtility();
		ConnDriver connDriver = new ConnDriver();
		try
		{		
			//Changed by Poonam Gole for changing connection object :Start
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection() ;
			//Changed by Poonam Gole for changing connection object :End
		
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			//GenericUtility genUtlty=GenericUtility.getInstance();
			E12GenericUtility genUtlty = new E12GenericUtility();
			userId = genUtlty.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			siteCode = genUtlty.getColumnValue("site_code",dom1);
			lineNo = genUtlty.getColumnValue("line_no",dom1);
			expLevel = genUtlty.getColumnValue("exp_lev",dom);
			itemCode = genUtlty.getColumnValue("item_code",dom);
			quantity = genUtlty.getColumnValue("quantity",dom);
			locCode = genUtlty.getColumnValue("loc_code",dom);
			lotNo = genUtlty.getColumnValue("lot_no",dom);
			lotSl =  genUtlty.getColumnValue("lot_sl", dom);
			
			orderedQuantity = Double.parseDouble(quantity);
			if (orderedQuantity == 0)
			{
				errCode = "VTQUAN";
				errString = itmDbAccess.getErrorString("quantity", errCode, userId, "", conn);
				return errString;
			}
			System.out.println("selQty ::"+orderedQuantity);
			System.out.println("FRom DOM:siteCode:"+siteCode+":itemCode:"+itemCode+":quantity:"+quantity+":");
			System.out.println("FRom DOM:lotNo:"+lotNo+":locCode:"+locCode+":");
			
			
			sql=" SELECT COUNT(*) FROM STOCK A, INVSTAT B "+
				" WHERE A.INV_STAT  = B.INV_STAT AND A.ITEM_CODE =?"+
				" AND A.SITE_CODE =?"+
				" AND (CASE WHEN ((CASE WHEN A.QUANTITY IS NULL THEN 0 ELSE A.QUANTITY END) - (CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END)) "+
				" IS NULL THEN 0 ELSE ((CASE WHEN A.QUANTITY IS NULL THEN 0 ELSE A.QUANTITY END) - (CASE WHEN A.ALLOC_QTY IS NULL THEN 0 ELSE A.ALLOC_QTY END)) END )  > 0 ";
			System.out.println("sql:"+sql);
			stmt = conn.prepareStatement(sql);
			stmt.setString(1,itemCode);
			stmt.setString(2,siteCode);
			rs1 = stmt.executeQuery();
			if(rs1.next())
			{
				row = rs1.getInt(1);
			}
			rs1.close();
			rs1 = null;
			
			
			System.out.println("row:"+row);
			if(row > 0)
			{
				//errCode = "VTSTOCK1";
				if(lotNo == null)
				{
					lotNo = "";
				}
				if(locCode == null)
				{
					locCode = "";
				}
				if(quantity == null)
				{
					quantity = "0";
				}
				
				sql = "SELECT STOCK.ITEM_SER,STOCK.ITEM_CODE, "+
						 "STOCK.UNIT,STOCK.LOC_CODE,STOCK.LOT_NO, "+
						 "STOCK.LOT_SL, "+
						 "STOCK.QUANTITY - STOCK.ALLOC_QTY - "+
						 "(CASE WHEN STOCK.HOLD_QTY IS NULL THEN 0 "+
						 "ELSE STOCK.HOLD_QTY END ) AS QUANTITY, "+  
						 "STOCK.SITE_CODE,STOCK.EXP_DATE,STOCK.RETEST_DATE, "+
						 "STOCK.PACK_CODE, "+
						 "STOCK.QUANTITY - STOCK.ALLOC_QTY - (CASE WHEN STOCK.HOLD_QTY IS "+
					     "NULL THEN 0 ELSE STOCK.HOLD_QTY END) AS CC_QUANTITY, "+
					     "STOCK.RETEST_DATE "+ 
						 "FROM STOCK,INVSTAT "+ 
						 "WHERE ( STOCK.INV_STAT = INVSTAT.INV_STAT ) AND "+ 
						 "( STOCK.ITEM_CODE = ? ) AND "+
						 "( STOCK.SITE_CODE = ? ) AND "+ 
						 "((STOCK.QUANTITY - STOCK.ALLOC_QTY - CASE WHEN STOCK.HOLD_QTY "+ 
						 "IS NULL THEN 0 ELSE STOCK.HOLD_QTY END) > 0 ) AND "+ 
						 "( NVL(INVSTAT.STAT_TYPE,' ') <> 'S') AND "+  
					     "(STOCK.EXP_DATE IS NULL OR "+
					     "STOCK.EXP_DATE >sysdate or "+
					     "STOCK.RETEST_DATE >sysdate) and "+
					     "( INVSTAT.AVAILABLE = 'Y' ) "+  
					     "ORDER BY STOCK.PARTIAL_USED ASC, NVL(STOCK.EXP_DATE, "+
					     "STOCK.CREA_DATE) ASC, STOCK.LOT_NO ASC, "+ 
					     "STOCK.LOT_SL ASC ";
				stmt = conn.prepareStatement(sql);
				stmt.setString(1,itemCode);
				stmt.setString(2,siteCode);
				rs = stmt.executeQuery();
				while(rs.next())
				{
					stockRec = new StockStructRec();
					stockRec.itemSer = rs.getString(1);
					stockRec.itemCode = rs.getString(2);
					stockRec.unit = rs.getString(3);
					stockRec.locCode = rs.getString(4);
					stockRec.lotNo =( rs.getString(5) ==null ?"" :rs.getString(5));
					stockRec.lotSl = rs.getString(6);
					quantity = rs.getString(7);
					if(quantity != null)
					totalStkQuantity += Double.parseDouble(quantity);
					stockRec.quantity = quantity;
					stockRec.siteCode = rs.getString(8);
					stockRec.expDate = rs.getDate(9) ;
					stockRec.retestDate = rs.getDate(10);
					stockRec.packCode = rs.getString(11);
					stockRec.ccQuantity = rs.getString(12);
					stockDetailList.add(stockRec);
					stockRec = null;
				}
				stmt.close();
				stmt = null;
				rs.close();
				rs = null;
				
				if(orderedQuantity > totalStkQuantity)
				{
					errCode = "VTSTOCK1";
					errString = itmDbAccess.getErrorString("quantity", errCode, userId, "", conn); 
					return errString;
				}
				sql = "SELECT ISS_CRITERIA FROM ITEM WHERE ITEM_CODE = ?";
				stmt = conn.prepareStatement(sql);
				stmt.setString(1,itemCode);
				rs = stmt.executeQuery();
				if (rs.next())
				{
					issCriteria = rs.getString("ISS_CRITERIA");
				}
				rs.close();
				rs =null;
				stmt.close();
				stmt=null;
				
				for( int structIdx = 0,
						stuctListLen = stockDetailList.size(); structIdx < stuctListLen ; structIdx++ )
				{
					stockRec = ( StockStructRec )stockDetailList.get( structIdx );
					
					itemSer =stockRec.itemSer;
					itemCode = stockRec.itemCode;
					unit = stockRec.unit;
					locCode = stockRec.locCode ;
					lotNo =( stockRec.lotNo ==null ?"" :stockRec.lotNo);
					lotSl = stockRec.lotSl;
					quantity = stockRec.quantity;
					siteCode = stockRec.siteCode;
					expDate = stockRec.expDate;
					retestDate = stockRec.retestDate;
					packCode = stockRec.packCode;
					ccQuantity = stockRec.ccQuantity;
					
					
					if(lotNo.trim().length() ==0)
					{
						lotNo =" ";
					}
					if(locCode.trim().length() ==0)
					{
						locCode =" ";
					}
					if(lotSl.trim().length() ==0)
					{
						lotSl =" ";
					}
					if(unit.trim().length() ==0)
					{
						unit =" ";
					}
					if(siteCode.trim().length() ==0)
					{
						siteCode =" ";
					}
					if(itemSer.trim().length() ==0)
					{
						siteCode =" ";
					}
					if(quantity == null)
					{
						quantity = "0";
					}
					else if(quantity.trim().length() ==0)
					{
						quantity ="0";
					}
					valueXmlString.append("<Detail>\r\n");
					valueXmlString.append("<item_code isSrvCallOnChg='1'>").append(itemCode).append("</item_code>");
					
					if (expLevel != null && expLevel.trim().length() > 0)
					{
						valueXmlString.append("<exp_lev>").append(expLevel).append("</exp_lev>");
					}
					if (lineNo != null && lineNo.trim().length() > 0)
					{
						valueXmlString.append("<line_no>").append(lineNo).append("</line_no>");
					}
					if (unit != null && unit.trim().length() > 0)
					{
						valueXmlString.append("<unit>").append(unit).append("</unit>");
					}
					if (locCode != null && locCode.trim().length() > 0)
					{
						valueXmlString.append("<loc_code isSrvCallOnChg='1'>").append(locCode).append("</loc_code>");
					}
					if (lotNo != null && lotNo.trim().length() > 0)
					{
						valueXmlString.append("<lot_no isSrvCallOnChg='1'>").append(lotNo).append("</lot_no>");
					}
					if (lotSl != null && lotSl.trim().length() > 0)
					{
						valueXmlString.append("<lot_sl isSrvCallOnChg='1'>").append(lotSl).append("</lot_sl>");
					}
					if (itemCode != null && itemCode.trim().length() > 0)
					{
						valueXmlString.append("<item_code>").append(itemCode).append("</item_code>");
					}
					
					stkQuantity = Double.parseDouble(quantity);
					if (stkQuantity < orderedQuantity)
					{
						//valueXmlString.append("<quantity>").append(stkQuantity).append("</quantity>");
						orderedQuantity = orderedQuantity - stkQuantity;
					}
					else
					{
						if (issCriteria != null && issCriteria.equalsIgnoreCase("W"))
						{
							orderedQuantity = 0;  
						}
						else
						{
							
							stkQuantity= orderedQuantity;
							orderedQuantity = 0;  
						}	
					}
					valueXmlString.append("<quantity>").append(stkQuantity).append("</quantity>");
					
					valueXmlString.append("</Detail>");
					if (orderedQuantity == 0)
					{
						break;
					}
					
				}//end while
			}
			valueXmlString.append("</Root>\r\n");
		}
		catch(SQLException e)
		{
			System.out.println("Exception : WoEnhancement : actionStock " +e.getMessage());
			throw new ITMException(e);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception : WoEnhancement : actionHandler :(Document dom)" +e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try{
				conn.close();
				conn = null;
			}catch(Exception e){}
		}
		System.out.println("valueXmlString.toString() "+valueXmlString.toString());
		return valueXmlString.toString();		
	}

	private String stockTransform(Document dom,Document dom1, String objContext, String xtraParams, Document selDataDom)throws ITMException
	{
		String tranId = "",siteCode = "",itemCode = "",locCode = "",lotNo = "",lotSl = "";
		String quantity = "";
		String selLocCode= "",selLotNo ="",selLotSl ="",selUnit = "",selQuantity= "";
		String userId ="",issCriteria = "",stkQtyStr = "",sql = "",errCode = "", errString = "";
		
		String lineNo= "" ,expLevel = "" ;
		double stkQty = 0,ordQuantity = 0,selQty = 0;
		NodeList detailList = null;
		int detailListLength = 0;
		StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
		ConnDriver connDriver = new ConnDriver();
		ITMDBAccessEJB itmDbAccess = new ITMDBAccessEJB();   
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		try
		{
			//Changed by Poonam Gole for changing connection object :Start
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection() ;
			//Changed by Poonam Gole for changing connection object :End
			//GenericUtility genUtlty=GenericUtility.getInstance();
			E12GenericUtility genUtlty = new E12GenericUtility();
			userId = genUtlty.getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			tranId = genUtlty.getColumnValue("tran_id",dom1);
			siteCode = genUtlty.getColumnValue("site_code",dom1);
			expLevel = genUtlty.getColumnValue("exp_lev",dom1);
			lineNo = genUtlty.getColumnValue("line_no",dom1);
			itemCode = genUtlty.getColumnValue("item_code",dom);
			locCode = genUtlty.getColumnValue("loc_code", dom);
			lotNo = genUtlty.getColumnValue("lot_no", dom);
			lotSl =  genUtlty.getColumnValue("lot_sl", dom);
			quantity = genUtlty.getColumnValue("quantity", dom);
			
			if (Double.parseDouble(quantity) == 0)
			{
				errCode = "VTQUAN";
				errString = itmDbAccess.getErrorString("quantity", errCode, userId, "", conn);
				return errString;
			}
			
			sql = "SELECT ISS_CRITERIA FROM ITEM WHERE ITEM_CODE = ?";
			stmt = conn.prepareStatement(sql);
			stmt.setString(1,itemCode);
			rs = stmt.executeQuery();
			if (rs.next())
			{
				issCriteria = rs.getString("ISS_CRITERIA");
			}
			detailList = selDataDom.getElementsByTagName("Detail");
			detailListLength = detailList.getLength();
			for (int i = 0;i < detailListLength;i++ )
			{
				//stkQtyStr = GenericUtility.getInstance().getColumnValueFromNode("quantity",detailList.item(i));
				stkQtyStr = genUtlty.getColumnValueFromNode("quantity",detailList.item(i));
				if (stkQtyStr != null)
				{
					stkQty = stkQty + Double.parseDouble(stkQtyStr);
				}				
			}
			if (stkQty < Double.parseDouble(quantity))
			{
				errCode = "VTSTOCK1";
				errString = itmDbAccess.getErrorString("quantity", errCode, userId, "", conn); 
				return errString;  
			}
			ordQuantity = Double.parseDouble(quantity);
			
			System.out.println("issCriteria ::"+issCriteria);
			System.out.println("ordQuantity ::"+ordQuantity);

			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				//selLocCode = GenericUtility.getInstance().getColumnValueFromNode("loc_code",detailList.item(ctr));
				//selLotNo = GenericUtility.getInstance().getColumnValueFromNode("lot_no",detailList.item(ctr));
				//selLotSl = GenericUtility.getInstance().getColumnValueFromNode("lot_sl",detailList.item(ctr));
				//selUnit = GenericUtility.getInstance().getColumnValueFromNode("unit",detailList.item(ctr));
				//selQuantity = GenericUtility.getInstance().getColumnValueFromNode("quantity",detailList.item(ctr));
			  
				selLocCode = genUtlty.getColumnValueFromNode("loc_code",detailList.item(ctr));
				selLotNo = genUtlty.getColumnValueFromNode("lot_no",detailList.item(ctr));
				selLotSl = genUtlty.getColumnValueFromNode("lot_sl",detailList.item(ctr));
				selUnit = genUtlty.getColumnValueFromNode("unit",detailList.item(ctr));
				selQuantity = genUtlty.getColumnValueFromNode("quantity",detailList.item(ctr));
				
				valueXmlString.append("<Detail>");
				valueXmlString.append("<item_code isSrvCallOnChg='1'>").append(itemCode).append("</item_code>");
				
				if (expLevel != null && expLevel.trim().length() > 0)
				{
					valueXmlString.append("<exp_lev>").append(expLevel).append("</exp_lev>");
				}
				if (lineNo != null && lineNo.trim().length() > 0)
				{
					valueXmlString.append("<line_no>").append(lineNo).append("</line_no>");
				}
				if (selUnit != null && selUnit.trim().length() > 0)
				{
					valueXmlString.append("<unit>").append(selUnit).append("</unit>");
				}
				if (selLocCode != null && selLocCode.trim().length() > 0)
				{
					valueXmlString.append("<loc_code isSrvCallOnChg='1'>").append(selLocCode).append("</loc_code>");
				}
				if (selLotNo != null && selLotNo.trim().length() > 0)
				{
					valueXmlString.append("<lot_no isSrvCallOnChg='1'>").append(selLotNo).append("</lot_no>");
				}
				if (selLotSl != null && selLotSl.trim().length() > 0)
				{
					valueXmlString.append("<lot_sl isSrvCallOnChg='1'>").append(selLotSl).append("</lot_sl>");
				}
				if (itemCode != null && itemCode.trim().length() > 0)
				{
					valueXmlString.append("<item_code>").append(itemCode).append("</item_code>");
				}
				
				selQty = Double.parseDouble(selQuantity);
				System.out.println("selQty ::"+selQty);
				if (selQty < ordQuantity)
				{
					valueXmlString.append("<quantity>").append(selQty).append("</quantity>");
					ordQuantity = ordQuantity - selQty;
				}
				else
				{
					if (issCriteria != null && issCriteria.equalsIgnoreCase("W"))
					{
						ordQuantity = 0;
					}
					else
					{
						
						selQty= ordQuantity;
						ordQuantity = 0;  
					}	
				}
				valueXmlString.append("<quantity>").append(selQty).append("</quantity>");
				
				valueXmlString.append("</Detail>");
				if (ordQuantity == 0)
				{
					break;
				}
			}
			valueXmlString.append("</Root>\r\n");				
		}
		catch (Exception e)
		{
			System.out.println("Exception WoEnhancement "+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				conn.close();
				conn = null;
			}
			catch (Exception se){}
		}
		return valueXmlString.toString();
	}
	private class StockStructRec
	{
		String itemSer = null;
		String itemCode = null;
		String unit = null;
		String locCode = null;
		String  lotNo = null;
		String lotSl = null;
		String quantity = null;
		String siteCode = null;
		java.sql.Date expDate = null;
		java.sql.Date retestDate = null;
		String packCode = null;
		String ccQuantity = null;
		
	}
}