package ibase.dashboard.sfa.ejb;

import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;

@Stateless
public class PendingStatus extends ValidatorEJB implements PendingStatusLocal,
PendingStatusRemote
{
	public PendingStatus()
	{
	}

	@SuppressWarnings("unchecked")
	public JSONObject getPendingStatus(String dataSourceName, String empCode,String empSite)
			throws RemoteException, ITMException
	{
		JSONObject rowDataPendingTaskJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		int count = 0;
		DashboardUtility dashboardUtility = null;
		try
		{
			SimpleDateFormat convertToDbDate =new SimpleDateFormat(new GenericUtility().getDBDateFormat());
			SimpleDateFormat simpleDateFormat =new SimpleDateFormat(new GenericUtility().getApplDateFormat());
			conn = connDriver.getConnectDB(dataSourceName);
			dashboardUtility = new DashboardUtility();
			empSite = dashboardUtility.getCommaSeparated(empSite);
	sql =   " WITH PRD AS  "
			+" (SELECT E.EMP_CODE, (E.EMP_FNAME||' '||E.EMP_MNAME||' '||E.EMP_LNAME) AS EMP__NAME, E.DATE_JOIN, E.EMP_SITE, "
			+" E.CCTR_CODE__SAL AS DIV, E.RELIEVE_DATE, SYSDATE AS CURR_DATE, TO_CHAR(SYSDATE,'YYYYMM') AS CMON, G.CODE, "
			+" G.FR_DATE, G.TO_DATE "
			+" FROM EMPLOYEE E, "
			    +" (SELECT MIN(X.ADATE) AS FR_DATE, MAX(X.ADATE) AS TO_DATE FROM NSRNO X "
			    +"     WHERE X.ADATE >= TRUNC(SYSDATE-365) "
			    +"     AND X.ADATE <= ADD_MONTHS(SYSDATE,1)) F, PERIOD G "
			+" WHERE E.EMP_CODE = '"+empCode+"'"
			+" AND G.FR_DATE >= (CASE WHEN E.DATE_JOIN > F.FR_DATE THEN TRUNC(E.DATE_JOIN,'MONTH') ELSE TRUNC(F.FR_DATE,'MONTH') END) "
			+" AND G.TO_DATE <= (CASE WHEN E.RELIEVE_DATE IS NULL THEN LAST_DAY(F.TO_DATE) " 
			+" WHEN E.RELIEVE_DATE <= F.TO_DATE THEN LAST_DAY(E.RELIEVE_DATE) ELSE LAST_DAY(F.TO_DATE) END) "
			//--- AND 'N' = (CASE WHEN E.WITH_HELD = 'Y' OR E.RELIEVE_DATE IS NOT NULL OR E.RESI_DATE IS NOT NULL THEN 'Y' ELSE 'N' END) "
					+" ), "
			+" DATA  AS (SELECT 'C' AS TAG, 'EXPENSES STATUS' AS ACCT_DSCR, A.CODE AS MONTH, 'PENDING' AS DET "
			+" FROM PRD A "
			+" WHERE 0 = NVL((SELECT MAX(1) AS CC "
			  +"       FROM MISC_VOUCHER B "
			   +"      WHERE B.SUNDRY_TYPE IN('E','P') "
			   +"       AND (B.SUNDRY_CODE = A.EMP_CODE) "
			   +"       AND B.BILL_NO = A.CODE "
			    +"      AND B.VOUCH_TYPE = 'F' "
			    +"      AND (CASE WHEN B.TRAN_ID IS NULL THEN 0 ELSE 1 END) = 1),0) "
			+" AND A.CODE < TO_CHAR(SYSDATE,'YYYYMM') "
			+" AND A.EMP_SITE in ("+empSite+") " //Check EmpSite----
			+" UNION ALL "
			+" SELECT 'A' AS TAG, 'DAILY ACTIVITY REPORT' AS ACCT_DSCR, A.CODE AS MONTH, "
			+" GET_MISSING_REPORT(A.EMP_CODE, (CASE WHEN A.DATE_JOIN >= A.FR_DATE THEN A.DATE_JOIN ELSE A.FR_DATE END), "
			+" (CASE WHEN A.RELIEVE_DATE IS NULL AND A.CMON > A.CODE THEN A.TO_DATE WHEN A.RELIEVE_DATE IS NULL AND A.CMON = A.CODE THEN SYSDATE-1 WHEN A.TO_DATE >= A.RELIEVE_DATE THEN A.RELIEVE_DATE ELSE A.TO_DATE END)) AS DET "
			+" FROM PRD A "
			+" WHERE GET_MISSING_REPORT(A.EMP_CODE, (CASE WHEN A.DATE_JOIN >= A.FR_DATE THEN A.DATE_JOIN ELSE A.FR_DATE END), "
			     +"       (CASE WHEN A.RELIEVE_DATE IS NULL AND A.CMON > A.CODE THEN A.TO_DATE "
			     +"    WHEN A.RELIEVE_DATE IS NULL AND A.CMON = A.CODE THEN SYSDATE-1 "
			     +"    WHEN A.TO_DATE >= A.RELIEVE_DATE THEN A.RELIEVE_DATE ELSE A.TO_DATE END)) IS NOT NULL "
			+" AND A.CODE <= TO_CHAR(SYSDATE,'YYYYMM') "
			+" AND A.EMP_SITE IN ("+empSite+") " //Check EmpSite----
			+" UNION ALL "
			+" SELECT 'B' AS TAG, 'MONTHLY ACTIVITY REPORT' AS ACCT_DSCR, A.CODE AS MONTH, 'PENDING' AS DET "
			+" FROM PRD A "
			+" WHERE 0 = NVL((SELECT MAX(1) AS TT FROM SPRS_PLAN_FROZEN "
			   +"      WHERE SPRS_PLAN_FROZEN.PLAN_DATE >= A.FR_DATE "
			   +"        AND SPRS_PLAN_FROZEN.PLAN_DATE <= A.TO_DATE "
			   +"        AND SPRS_PLAN_FROZEN.SPRS_CODE__FOR = A.EMP_CODE),0) "
			+" AND TO_CHAR(A.DATE_JOIN,'YYYYMM') < A.CODE "
			+" AND 1 = (CASE WHEN STR_TO_NUM(TO_CHAR(SYSDATE,'DD')) > 20 "
			+" AND A.CODE > TO_CHAR(SYSDATE,'YYYYMM') THEN 1 WHEN A.CODE <= TO_CHAR(SYSDATE,'YYYYMM') THEN 1 ELSE 0 END) "
			+" AND A.EMP_SITE in ("+empSite+") " //Check EmpSite----
			+" AND A.DIV <> 'H205' "
			+" UNION ALL "
			+" SELECT (CASE WHEN SAMPLE_RCP.TRAN_TYPE = 'R' AND SAMPLE_RCP.LR_NO IS NULL THEN 'F' "
			 +"         WHEN SAMPLE_RCP.TRAN_TYPE = 'R' AND SAMPLE_RCP.LR_NO IS NOT NULL THEN 'D' ELSE 'H' END) AS TAG, "
			 +"       (CASE WHEN SAMPLE_RCP.TRAN_TYPE = 'R' AND SAMPLE_RCP.LR_NO IS NULL THEN 'RECEIPT' "
			 +"             WHEN SAMPLE_RCP.TRAN_TYPE = 'R' AND SAMPLE_RCP.LR_NO IS NOT NULL THEN 'CONSIGNMENT ACKNOWLEDGEMENT' "
			 +"             ELSE 'ADJUSTMENT RECEIPT' END) AS ACCT_DSCR, "
			+" NULL AS MONTH, (SAMPLE_RCP.TRAN_ID||'  #  DATED  #  '||TO_CHAR(SAMPLE_RCP.TRAN_DATE,'DD-MON-YY')) AS DET "
			+" FROM SAMPLE_RCP , EMPLOYEE E "
			+" WHERE (E.EMP_CODE = '"+empCode+"') "
			+" AND SAMPLE_RCP.CONFIRMED = 'N' "
			+" AND SAMPLE_RCP.TRAN_DATE >= TRUNC(SYSDATE-365) "
			+" AND SAMPLE_RCP.TRAN_DATE <= TRUNC(SYSDATE) "
			+" AND SAMPLE_RCP.EMP_CODE__RCP = E.EMP_CODE "
			+" AND SAMPLE_RCP.STATUS = 'O' "
			+" AND E.CCTR_CODE__SAL <> 'H205' "
			+" UNION ALL "
			+" SELECT (CASE WHEN SAMPLE_ISS.TRAN_TYPE = 'I' THEN 'E' ELSE 'G' END) AS TAG, "
			+"        (CASE WHEN SAMPLE_ISS.TRAN_TYPE = 'I' THEN 'ISSUE' ELSE 'ADJUSTMENT ISSUE' END) AS ACCT_DSCR, NULL AS MONTH, "
			+" SAMPLE_ISS.TRAN_ID||'  #  DATED  #  '||TO_CHAR(SAMPLE_ISS.TRAN_DATE,'DD-MON-YY') AS DET "
			+" FROM SAMPLE_ISS , EMPLOYEE E "
			+" WHERE (E.EMP_CODE = '"+empCode+"') "
			+" AND SAMPLE_ISS.TRAN_TYPE IN ('A','I') "
			+" AND SAMPLE_ISS.EMP_CODE__ISS = E.EMP_CODE "
			+" AND SAMPLE_ISS.TRAN_DATE >= TRUNC(SYSDATE-365) "
			+" AND SAMPLE_ISS.TRAN_DATE <= TRUNC(SYSDATE) "
			+" AND SAMPLE_ISS.CONFIRMED = 'N' "
			+" AND SAMPLE_ISS.STATUS = 'O' "
			+" AND E.CCTR_CODE__SAL <> 'H205' "
			+" UNION ALL "
			+" SELECT 'I' AS TAG, 'STOCK TRANSFER RECEIVER' AS ACCT_DSCR, NULL AS MONTH, "
			+" SAMPLE_ISS.TRAN_ID||'  #  DATED  #  '||TO_CHAR(SAMPLE_ISS.TRAN_DATE,'DD-MON-YY') AS DET "
			+" FROM SAMPLE_ISS , EMPLOYEE E "
			+" WHERE (E.EMP_CODE = '"+empCode+"') "
			+" AND SAMPLE_ISS.TRAN_TYPE = 'T' "
			+" AND SAMPLE_ISS.EMP_CODE__RCP = E.EMP_CODE "
			+" AND SAMPLE_ISS.TRAN_DATE >= TRUNC(SYSDATE-365) "
			+" AND SAMPLE_ISS.TRAN_DATE <= TRUNC(SYSDATE) "
			+" AND SAMPLE_ISS.CONFIRMED = 'N' "
			+" AND SAMPLE_ISS.STATUS = 'O' "
			+" AND E.CCTR_CODE__SAL <> 'H205') "
			+" SELECT TAG, ACCT_DSCR, MONTH, DET "
			+" FROM DATA "
			+" UNION ALL "
			+" SELECT NULL AS TAG, 'NOTHING PENDING' AS ACCT_DSCR, NULL AS MONTH, NULL AS DET "
			+" FROM DUAL "
			+" WHERE NOT EXISTS (SELECT 1 FROM DATA WHERE ROWNUM = 1) ";
	
	pstmt = conn.prepareStatement(sql);
	rs = pstmt.executeQuery();

	while (rs.next())
	{
		rowData = new JSONObject();
		rowData.put("tag",   checkNull(rs.getString("tag")));
		rowData.put("particular",       checkNull(rs.getString("ACCT_DSCR")));
		rowData.put("month",      checkNull(rs.getString("month")));
		rowData.put("detail",     checkNull(rs.getString("det")));
		rowDataPendingTaskJson.put(Integer.valueOf(count), rowData);
		count++;
	}
			System.out.println(" rowDataPendingTaskJson is =" + rowDataPendingTaskJson);

		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			}
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getTask():" + d.getMessage());
				throw new ITMException(d);
			}
		}

		return rowDataPendingTaskJson;
	}

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}

}
