
package ibase.webitm.ejb.dis;

import ibase.bean.GetServersStatusBean;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.adv.DespatchAct;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

import javax.ejb.Stateless;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class DespatchWiz extends ValidatorEJB implements DespatchWizLocal, DespatchWizRemote {

	GenericUtility genericUtility = GenericUtility.getInstance();
	String userId = null;
	String chgUser = null;
	String chgTerm = null;
	NumberFormat nf = null;
	boolean isError=false;



	public DespatchWiz() 
	{
		System.out.println("^^^^^^^ inside DespatchWiz  Wizard ^^^^^^^");
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
		System.out.println("^^^^^^^ inside DespatchWiz  Wizard 111^^^^^^^");
		System.out.println("xmlString--------->>["+xmlString+"]");
		System.out.println("xmlString1--------->>["+xmlString1+"]");
		System.out.println("xmlString2--------->>["+xmlString2+"]");

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";

		try {
			if(xmlString !=null && xmlString.trim().length() > 0){
			dom = parseString(xmlString);
			}
			if(xmlString1 !=null && xmlString1.trim().length() > 0){
				dom1 = parseString(xmlString1);
			}			
			if (xmlString2 !=null && xmlString2.trim().length() > 0) 
			{
				dom2 = parseString("<Root>" + xmlString2 + "</Root>");
			}
			if (objContext != null && Integer.parseInt(objContext) == 1) 
			{
				parentNodeList = dom2.getElementsByTagName("Header0");
				parentNode = parentNodeList.item(1);
				childNodeList = parentNode.getChildNodes();
				for (int x = 0; x < childNodeList.getLength(); x++) 
				{
					childNode = childNodeList.item(x);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("Detail1")) 
					{
						errString = wfValData(dom, dom1, dom2, "1", editFlag, xtraParams);
						if (errString != null && errString.trim().length() > 0)
							break;
					} else if (childNodeName.equalsIgnoreCase("Detail2")) 
					{
						errString = wfValData(dom, dom1, dom2, "2", editFlag, xtraParams);
						break;
					}
				}
			} else 
			{
				errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			}
		} catch (Exception e) {
			System.out.println("Exception : Inside DocumentMaster wfValData Method ..> " + e.getMessage());
			throw new ITMException(e);
		}
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
		System.out.println("----------in wfvalData of DespatchWiz........");
		GenericUtility genericUtility;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0, currentFormNo = 0, childNodeListLength = 0, cnt = 0;
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		Connection conn = null;
		String userId = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		String sql = "",locCode ="",invstat="",aval="",avalyn="",status="";
        double qtyConf=0,qtyShip=0,totQty=0,detquantity=0,stkquantity=0,quantity=0,totquantity=0;
		String squantity="",distOrder = "",itemCode="",confirmed="",tranId="",siteCode="",lotSl="",addUser="",tranCode="";
		String itemCodeL="",SiteCodeL="",CustCodeL="",ChanPart="",sorderNo="";
		
		try {
			genericUtility = GenericUtility.getInstance();
			System.out.println("editFlag------>>["+editFlag+"]");
			System.out.println("xtraParam----->>["+xtraParams+"]");
			System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");
			System.out.println("DOM1----->>["+genericUtility.serializeDom(dom1).toString()+"]");
			System.out.println("DOM2----->>["+genericUtility.serializeDom(dom2).toString()+"]");	

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) {
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLength; ctr++) {

					System.out.println("childNodeName------->>["+childNodeName+"]");
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("sale_order_no"))
					{
						int despCount=0;
						sorderNo = checkNull(genericUtility.getColumnValue("sale_order_no",dom));
						System.out.println("sorderNo---->>["+sorderNo+"]");
						if (sorderNo.length() == 0){
						errCode = "VTSORDNNN";
						errString = getErrorString("sale_order_no",errCode,userId);
						break;
						}else{
							cnt=getDBRowCount(conn,"sorder","sale_order",sorderNo);
							System.out.println("cnt1------>>["+cnt+"]");
							if(cnt==0){
								errCode = "VTSORDNND";
								errString = getErrorString("sale_order_no",errCode,userId);
								break;
							}else{
								confirmed=checkNull(getColumnDescr(conn,"confirmed","sorder","sale_order",sorderNo));
								
								System.out.println("Sale order Confirmed---->>["+confirmed+"]");
								sql="select status,confirmed from sorder where sale_order = ? ";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1, sorderNo);
								rs=pstmt.executeQuery();
								if(rs.next()){
									status=rs.getString(1);
									confirmed=rs.getString(2);
																		
								}
								if(rs!=null){
								rs.close();
								rs=null;
								}
								if(pstmt!=null){
								pstmt.close();
								pstmt=null;
								}
								confirmed=confirmed == null ? "N" :confirmed.trim();
								status=status == null ? "P" :status.trim();
								despCount=getDBRowCount(conn,"despatch","sord_no",sorderNo);
								double sordItemQty=getQtyFromSordItem(sorderNo,conn);
								
								avalyn=getColumnDescr(conn, "available_yn", "sorder", "sale_order", sorderNo);
								avalyn=avalyn==null ? "N" : avalyn.trim();
								System.out.println("avalyn--->>["+avalyn+"]");
								System.out.println("Sale order Confirmed---->>["+confirmed+"]");
								System.out.println("Sale order status---->>["+status+"]");
								System.out.println("despCount---->>["+despCount+"]");
								System.out.println("sordItemQty---->>["+sordItemQty+"]");							
								
								if("N".equalsIgnoreCase(confirmed)){
									errCode = "VTSORDNNC";
									errString = getErrorString("sale_order_no",errCode,userId);
									break;
								}else if(! "P".equalsIgnoreCase(status)){
									errCode = "VTSORDSNP";
									errString = getErrorString("sale_order_no",errCode,userId);
									break;
								}else if(sordItemQty == 0){
									errCode = "VTSORDDEF";  
									errString = getErrorString("sale_order_no",errCode,userId);
									break;
								}else if("N".equalsIgnoreCase(avalyn)){									
									
									sql="select site_code,cust_code from sorder where sale_order = ?";
									pstmt=conn.prepareStatement(sql);
									pstmt.setString(1,sorderNo);
									rs=pstmt.executeQuery();
									if(rs.next()){
										SiteCodeL=checkNull(rs.getString(1));
										CustCodeL=checkNull(rs.getString(2));
									}
									rs.close();
									pstmt.close();	
									rs = null;
									pstmt = null;								
									sql="select channel_partner from site_customer where site_code= ? and "
											+ "cust_code = ? and available_yn = ?";
									pstmt=conn.prepareStatement(sql);
									pstmt.setString(1,SiteCodeL);
									pstmt.setString(2,CustCodeL);
									pstmt.setString(3,"N");
									rs=pstmt.executeQuery();
									if(rs.next()){										
										ChanPart=rs.getString(1);
									}
									ChanPart=ChanPart ==null ? ""  : ChanPart.trim();
									System.out.println("ChanPart---->>["+ChanPart+"]");
									if("N".equalsIgnoreCase(ChanPart)){
										errCode = "VTCUSTCD4";
										errString = getErrorString("sale_order_no",errCode,userId);
										break;
									}
									rs.close();
									pstmt.close();	
									rs = null;
									pstmt = null;
									if(ChanPart.length() == 0){
										sql="select channel_partner from customer where cust_code = ? and available_yn = ? ";
										pstmt=conn.prepareStatement(sql);
										pstmt.setString(1,CustCodeL);
										pstmt.setString(2,"N");
										rs=pstmt.executeQuery();
										if(rs.next()){
											ChanPart=rs.getString(1);
										}
										ChanPart=ChanPart ==null ? "N"  : ChanPart.trim();
										System.out.println("ChanPart cust----->>["+ChanPart+"]");
										if("N".equalsIgnoreCase(ChanPart) ||  ChanPart.length() ==0 ){
											errCode = "VTCUSTCD4";
											errString = getErrorString("sale_order_no",errCode,userId);
											break;
										}
									}
									
								}
								
							}
							
							
						} //end main else

					}

				}
				break;
			case 2:

				parentNodeList = dom2.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				System.out.println("parentNode >>>{"+parentNode+"}");
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();


				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{

					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("value of child node : "+childNode);



					if("E".equalsIgnoreCase(editFlag))
					{
						addUser = genericUtility.getColumnValue("add_user",dom2);
						chgUser = genericUtility.getColumnValue("chg_user",dom2);
						System.out.println("addUser><><"+addUser+"chgUserDD"+chgUser);
						if ((addUser != null && addUser.trim().length() > 0) && (chgUser != null && chgUser.trim().length() > 0))
						{
							if(!addUser.equalsIgnoreCase(chgUser))
							{
								errCode = "DIDOADDUM";
								errString = getErrorString("add_user",errCode,userId);
								break;
							}
						}
					}

					if(childNodeName.equalsIgnoreCase("tran_code"))
					{
						tranCode = checkNull(genericUtility.getColumnValue("tran_code",dom2));

						System.out.println("tranCode>>"+tranCode);

						if (tranCode.trim().length() == 0)
						{
							errCode = "DIDOTRCONU";
							errString = getErrorString("tran_code",errCode,userId);
							break;
						}
						else
						{
							cnt=getDBRowCount(conn, "transporter", "tran_code", tranCode);
							if(cnt == 0)
							{
								errCode = "DIDOTRCONE";
								errString = getErrorString("tran_code",errCode,userId);
								break;
							}
						}
					}


				}
				break;
			case 3:

				parentNodeList = dom2.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				System.out.println("DOM Elements-->["+genericUtility.serializeDom(dom).toString()+"]");
				System.out.println("wfvaldata case 3 DOM1 Elements-->["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2 Elements-->["+genericUtility.serializeDom(dom2).toString()+"]");

				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("value of child node : "+childNode);

					if(childNodeName.equalsIgnoreCase("lot_sl"))
					{
						sorderNo = checkNull(genericUtility.getColumnValue("sale_order_no",dom));
						siteCode = genericUtility.getColumnValue("site_code",dom2,"2");
						lotSl=checkNull(genericUtility.getColumnValue("lot_sl", dom2,"3"));
						//distOrder = genericUtility.getColumnValue("dist_order",dom2);

						if (lotSl == null || lotSl.trim().length() == 0)
						{
							errCode = "DIDOLSNULL";
							errString = getErrorString("lot_sl",errCode,userId);
							break;
						}
						else
						{
							sql = "select count(1) from stock where site_code = ? AND LOT_SL = ? AND QUANTITY > 0";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,siteCode);
							pstmt.setString(2,lotSl);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;

							if(cnt == 0)
							{
								errCode = "DIDOLSSTK";
								errString = getErrorString("lot_sl",errCode,userId);
								break;
							}
						}

						
					}
					else if(childNodeName.equalsIgnoreCase("item_code"))
					{
						System.out.println("----------in wfvaldata of item_code............");
						ArrayList <String> itemCodeList=new ArrayList<String>();					
						String qcLockValue="";
						int count=0;
						sorderNo = checkNull(genericUtility.getColumnValue("sale_order_no", dom1));
						itemCode = checkNull(genericUtility.getColumnValue("item_code", dom2,"3"));
						//lotSlL=checkNull(genericUtility.getColumnValue("lot_sl", dom2,"3"));
						
						avalyn=getColumnDescr(conn, "available_yn", "sorder", "sale_order", sorderNo);
						avalyn=avalyn==null ? "N" : avalyn.trim();
						System.out.println("Dertail3 avalyn--->>["+avalyn+"]");
						System.out.println("sorderNo------>>["+sorderNo+"]");
						System.out.println("itemCode------>>["+itemCode+"]");						
						if (itemCode.trim().length() == 0)
						{
							errCode = "DIDIICNULL";
							errString = getErrorString("item_code",errCode,userId);
							break;
						}
						else  
						{
							sql = "select item_code from sorddet where sale_order = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1,sorderNo);
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								itemCodeList.add(checkNull(rs.getString(1)));
							}
							System.out.println("itemCodeList------>>["+itemCodeList+"]");
							pstmt.close();
							rs.close();
							pstmt = null;
							rs = null;
							
							if(!(itemCodeList.contains(itemCode)))
							{
								errCode = "DIDIICNOMA";
								errString = getErrorString("item_code",errCode,userId);
								break;
							}							
							
						}
					}

					else if(childNodeName.equalsIgnoreCase("quantity")) 
					{	
						System.out.println("-------------wfvalData..quantity.............");
						String lotNo="",locCodeL="",despId="";
						double sdetQty=0,despatchQty=0,actQty=0;
						HashMap<String,String>invHoldMap=new HashMap<String,String>();
						sorderNo = checkNull(genericUtility.getColumnValue("sale_order_no", dom1));
						squantity = genericUtility.getColumnValue("quantity",dom2);
						siteCode = genericUtility.getColumnValue("site_code",dom2,"2");
						//lotSl = genericUtility.getColumnValue("lot_sl",dom2);
						lotSl=checkNull(genericUtility.getColumnValue("lot_sl", dom2,"3"));
						itemCode = checkNull(genericUtility.getColumnValue("item_code", dom2,"3"));
						locCodeL = checkNull(genericUtility.getColumnValue("loc_code", dom2,"3"));
						lotNo = checkNull(genericUtility.getColumnValue("lot_no", dom2,"3"));						
						despId = checkNull(genericUtility.getColumnValue("desp_id", dom2,"3"));
						
						avalyn=getColumnDescr(conn, "available_yn", "sorder", "sale_order", sorderNo);
						avalyn=avalyn==null ? "N" : avalyn.trim();
                        System.out.println("sorderNo--->>["+sorderNo+"]");
                        System.out.println("DespId--->>["+despId+"]");
                        System.out.println("lotSl--->>["+lotSl+"]");
                        System.out.println("siteCode--->>["+siteCode+"]");
                        System.out.println("locCodeL--->>["+locCodeL+"]");
                        System.out.println("lotNo--->>["+lotNo+"]");
                        System.out.println("itemCode--->>["+itemCode+"]");
                        System.out.println("squantity--->>["+squantity+"]");                       
            			
                        invHoldMap.put("item_code", itemCode);
                        invHoldMap.put("site_code", siteCode);
                        invHoldMap.put("loc_code", locCodeL);
                        invHoldMap.put("lot_no", lotNo);
                        invHoldMap.put("lot_sl", lotSl);
						if (squantity == null || squantity.trim().length() == 0)
						{
							quantity = 0;
						}
						else
						{
							quantity = Double.parseDouble(squantity);
						}
						
						cnt=getInvHoldCount(invHoldMap, conn);	
						
						
						if("N".equalsIgnoreCase(avalyn)){
						if(cnt == 0){
							//Error
							errCode = "DIDOLKCINC";//Despatch can not be created as qunaity is on hold.
							errString = getErrorString("quantity",errCode,userId);
							break;
							
						}
						}
						
						sql = "select sum(quantity) from despatchdet where sord_no = ?  and item_code = ?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1,sorderNo);
						pstmt.setString(2,itemCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							despatchQty = rs.getDouble(1);
						}
						pstmt.close();
						rs.close();
						pstmt = null;
						rs = null;
						System.out.println("despatchQty--->>["+despatchQty+"]");//280
						
						
							totquantity = despatchQty + quantity;//0+20=20
						
						
						sql = "select sum(quantity) from sorddet where sale_order = ? and item_code = ?";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1,sorderNo);
						pstmt.setString(2,itemCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							sdetQty = rs.getDouble(1);//10
						}
						pstmt.close();
						rs.close();
						pstmt = null;
						rs = null;
						
						actQty=getQtyFromSordItem(sorderNo, conn);
						System.out.println("actQty--->["+actQty+"]");//280
						System.out.println("totquantity--->>["+totquantity+"]");
						System.out.println("sdetQty--->>["+sdetQty+"]");
						if(totquantity > sdetQty)
						{
							errCode = "VTDPCCSQ";
							errString = getErrorString("quantity",errCode,userId);
							break;
						}else if(quantity > actQty){
							errCode = "VTDPCCMPQ";
							errString = getErrorString("quantity",errCode,userId);
							break;
						}
				}
					

					else if(childNodeName.equalsIgnoreCase("loc_code"))
					{
						sorderNo = checkNull(genericUtility.getColumnValue("sale_order_no", dom1));
						locCode = genericUtility.getColumnValue("loc_code",dom2,"3");
						//tranId = genericUtility.getColumnValue("tran_id",dom2);
						System.out.println("sorderNo---loc_code---->>["+sorderNo+"]");
						if (locCode == null || locCode.trim().length() == 0)
						{
							errCode = "DIDOLCNULL";
							errString = getErrorString("loc_code",errCode,userId);
							break;
						}else
						{
							invstat=getColumnDescr(conn, "inv_stat", "location", "loc_code", locCode);
							System.out.println("invstat---loc_code---->>["+invstat+"]");
													
							aval=getColumnDescr(conn, "available", "invstat", "inv_stat", invstat);		
							
							if( ("N".equalsIgnoreCase(aval))){
								errCode = "VTAVAIL";
								errString = getErrorString("loc_code",errCode,userId);
								break;
							}						
						}

					}
				}
				break;
			}
		} catch (Exception e) {
			e.printStackTrace();			
			errString = e.getMessage();
			try {
				conn.rollback();				
			} catch (Exception d) {
				d.printStackTrace();
			}
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null) {
					conn.close();
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
			}
		}
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try {
			System.out.println("currentColumn"+currentColumn);
			System.out.println("editFlag"+editFlag);
			System.out.println("xtraParams"+xtraParams);


			System.out.println("xmlString111>>"+xmlString);
			System.out.println("xmlString222>>"+xmlString1);
			System.out.println("xmlString333>>"+xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0) {
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		} catch (Exception e) {
			System.out.println("Exception : [itemChanged(String,String)] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return valueXmlString;
	}


	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {

		StringBuffer valueXmlString = null;
		int currentFormNo = 0, lineNo = 0;
		Connection conn = null;
		double squantity = 0.0;
		PreparedStatement pstmt = null,pstmt1=null;
		ResultSet rs = null ,rs1 = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		SimpleDateFormat simpleDateFormat = null;
		GenericUtility genutility = new GenericUtility();
		String locCode="",lotNo="",itmdesc="",siteCode="",locdesc="";
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		DistCommon disCommon = new DistCommon();
		System.out.println("DOM Elements---->>["+genericUtility.serializeDom(dom).toString()+"]");
		System.out.println("DOM111 Elements---->>["+genericUtility.serializeDom(dom1).toString()+"]");
		System.out.println("DOM222 Elements---->>["+genericUtility.serializeDom(dom2).toString()+"]");
		String distOrder = "",itemCode = "",unit="",packCode="",tranType ="";
		java.sql.Timestamp currDate = null;
		double grossWeight = 0,netWeight=0,tareWeight=0,noOfArt=0;
		SimpleDateFormat sdf = null;
		String currAppdate = "";
		String tranid ="";
		String rate = "";
		double amount = 0;
		int cnt = 0;

		String tranCode = "",tranName="",transMode="";
		StringBuffer detail2xml = new StringBuffer();
		String tranDate = null;

		PreparedStatement pstmt2 =null;
		ResultSet rs2 = null,rs3 = null;


		String unitAlt = null;
		int count = 0;
		double minputQty = 0d, remQuantity = 0d, stockQty = 0d, integralQty = 0d;
		double grossPer = 0d,netPer = 0d,grossWt = 0d,tarePer = 0d,netWt = 0d,tareWt =0d, rateClgVal = 0d, rate2 = 0d;
		double disAmount = 0d, shipperQty = 0d,discount =0,holdQtyL=0;
		int  minShelfLife = 0, noArt1 = 0;
		int mLineNoDist =0;
		double qtyConfirm =0,qtyShipped =0,lcQtyOrderAlt =0,lcFact =0;
		
		
		//Dadaso
		String sql="",currencyCode="",exchRate1="",currCodeFrt="",currCodeIns="",currCodedlv="",stanCode="",custCode="",custCodeDlv="",siteCodeDesc="";
		String stanCodeDlv="",dlvCity="",dlvPin="",countCodeDlv="",stanCodeInit="",status="",statusRemarks="",despIdNew="",
				custCodeBil="",dlvAdd1="",dlvAdd2="",dlvAdd3="",despId="",remarksDes="",noArtDes="",sorderNo="",
				siteCodeShip="",availableYn="",addUser="",chgUserL="",chgTermL="",lotslL="",lotStatus="HOLD";
		ArrayList<String> addUsersList=new ArrayList<String>();
		Date orderDt = null,statusDate=null,mfgDate=null,expiryDate=null,sOrdDate=null;
		try
		{   
			sdf=new SimpleDateFormat(genutility.getApplDateFormat());
			currDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
			currAppdate = sdf.format(currDate);
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			chgUser = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));			
			chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));			

			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("FORM NO IS---->>"+currentFormNo);
			System.out.println("currentColumn--------->>["+currentColumn+"]");
			System.out.println("editFlag111--------->>["+editFlag+"]");
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			switch (currentFormNo) {

			case 1 :
				break;

			case 2 : 
				System.out.println("DOM1 Elements-->["+genericUtility.serializeDom(dom1).toString()+"]");
				System.out.println("DOM2 Elements-->["+genericUtility.serializeDom(dom2).toString()+"]");
							
				sorderNo = checkNull(genericUtility.getColumnValue("sale_order_no", dom1));
				System.out.println("sorderNo in case211---->>["+sorderNo+"]");	
				sql = "select add_user,sord_no from despatch where CASE WHEN confirmed IS NULL THEN "
						+ "'N' ELSE CONFIRMED  END = 'N' and sord_no = ?";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1,sorderNo);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					addUser = checkNull(rs.getString("add_user"));
					addUsersList.add(addUser);					
				}
				System.out.println("addUsersList--case2---->>["+addUsersList+"]");
				pstmt.close();
				rs.close();
				pstmt = null;
				rs = null;
				
				sql="select count(1) from despatch where CASE WHEN confirmed IS NULL "
						+ "THEN 'N' ELSE confirmed END = 'N' and sord_no = ?";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1,sorderNo);
				rs = pstmt.executeQuery();
				if(rs.next()){
				cnt = rs.getInt(1);
				}
				if(rs!=null){
				rs.close();
				rs=null;
				}
				if(pstmt!=null){
				pstmt.close();
				pstmt=null;
				}
				System.out.println("sorderNo cnt123/@-@/>>----->>["+cnt+"]");//GROSS_WEIGHT, TARE_WEIGHT, NETT_WEIGHT		
				
				if(cnt > 0)
				{
					if(currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
						System.out.println("addUsersList22------>>["+addUsersList+"]");
						System.out.println("chgUser11------>>["+chgUser+"]");
						if(addUsersList.contains(chgUser))
						{
							for(int i = 0;i < addUsersList.size(); i++)
							{
								addUser = addUsersList.get(i);
								System.out.println("addUser------------>>["+addUser+"]");
								if(chgUser.equalsIgnoreCase(addUser))
								{

									sql="select d.desp_id,d.site_code,d.desp_date,d.curr_code,d.exch_rate,d.trans_mode,d.curr_code__frt,d.curr_code__ins,d.stan_code,"
											+ "d.state_code__dlv,d.dlv_city,d.dlv_pin,d.count_code__dlv,d.dlv_add1,d.dlv_add2,d.dlv_add3,"
											+ "d.tran_code,d.stan_code__init,d.status,d.status_remarks,d.remarks,d.no_art,d.status_date,d.cust_code,d.cust_code__dlv,"
											+ "s.site_code__ship,s.CHG_USER,s.CHG_TERM, s.order_date,d.gross_weight,d.nett_weight,d.tare_weight,d.no_art"
											+ " from despatch d,sorder s where d.sord_no = ? and d.sord_no = s.sale_order  and d.add_user = ?";

									pstmt=conn.prepareStatement(sql);
									pstmt.setString(1,sorderNo);
									pstmt.setString(2,addUser);
									rs = pstmt.executeQuery();
									if(rs.next()){
										System.out.println("Data found3334455...................");
										despId=checkNull(rs.getString("desp_id"));
										siteCode = checkNull(rs.getString("site_code"));
										currencyCode = checkNull(rs.getString("curr_code"));
										exchRate1 = checkNull(rs.getString("exch_rate"));
										transMode = rs.getString("trans_mode") == null ? "R " : rs.getString("trans_mode");
										currCodeFrt = checkNull(rs.getString("curr_code__frt"));
										currCodeIns = checkNull(rs.getString("curr_code__ins"));						

										orderDt = rs.getDate("desp_date");						

										stanCode = checkNull(rs.getString("stan_code"));							
										stanCodeDlv = checkNull(rs.getString("state_code__dlv"));
										dlvCity = checkNull(rs.getString("dlv_city"));
										dlvPin = checkNull(rs.getString("dlv_pin"));
										countCodeDlv = checkNull(rs.getString("count_code__dlv"));
										tranCode = checkNull(rs.getString("tran_code"));
										stanCodeInit = checkNull(rs.getString("stan_code__init"));
										status = checkNull(rs.getString("status"));
										statusRemarks = checkNull(rs.getString("status_remarks"));
										statusDate = rs.getDate("status_date");
										custCode=checkNull(rs.getString("cust_code"));
										custCodeDlv=checkNull(rs.getString("cust_code__dlv"));
										siteCodeShip=checkNull(rs.getString("site_code__ship"));

										dlvAdd1=checkNull(rs.getString("dlv_add1"));
										dlvAdd2=checkNull(rs.getString("dlv_add2"));
										dlvAdd3=checkNull(rs.getString("dlv_add3"));

										remarksDes=checkNull(rs.getString("remarks"));
										noArtDes=checkNull(rs.getString("no_art"));
										sOrdDate=rs.getDate("order_date");	
										grossWeight=rs.getDouble("gross_weight");
										netWeight=rs.getDouble("nett_weight");
										tareWeight=rs.getDouble("tare_weight");
									}
									if(rs!=null){
									rs.close();
									rs=null;
									}
									if(pstmt!=null){
									pstmt.close();
									pstmt=null;
									}
									System.out.println("tranCode----->>["+tranCode+"]");
									System.out.println("orderDt----->>["+orderDt+"]");
									System.out.println("sOrdDate----->>["+sOrdDate+"]");
									System.out.println("custCodeDlv----->>["+custCodeDlv+"]");
									valueXmlString.append("<Detail2 domID='" + count + "'  objContext = '"+currentFormNo+"' selected=\"Y\">\r\n");
									valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
									valueXmlString.append("<desp_id><![CDATA["+ despId +"]]></desp_id>");
									if(orderDt != null){
										valueXmlString.append("<desp_date><![CDATA["+ sdf.format(orderDt).toString() +"]]></desp_date>");										
									}
									if(sOrdDate != null){
									valueXmlString.append("<sord_date><![CDATA["+ sdf.format(sOrdDate).toString() +"]]></sord_date>");
									}
									valueXmlString.append("<sord_no><![CDATA["+ sorderNo +"]]></sord_no>");
									valueXmlString.append("<cust_code><![CDATA["+ custCode +"]]></cust_code>");
									valueXmlString.append("<cust_code__dlv><![CDATA["+ custCodeDlv +"]]></cust_code__dlv>");
									valueXmlString.append("<cust_code__bil><![CDATA["+ custCodeBil +"]]></cust_code__bil>");
									valueXmlString.append("<stan_code><![CDATA["+ stanCode.trim() +"]]></stan_code>");
									valueXmlString.append("<trans_mode><![CDATA["+ transMode.trim() +"]]></trans_mode>");

									//valueXmlString.append("<lr_date><![CDATA["+ lrDateVal.toString() +"]]></lr_date>");
									//valueXmlString.append("<shipment_id><![CDATA["+ shipmentId.trim() +"]]></shipment_id>");
									valueXmlString.append("<curr_code__frt><![CDATA["+ currCodeFrt.trim() +"]]></curr_code__frt>");
									valueXmlString.append("<curr_code__ins><![CDATA["+ currCodeIns.trim() +"]]></curr_code__ins>");
									valueXmlString.append("<curr_code><![CDATA["+ currencyCode.trim() +"]]></curr_code>");
									valueXmlString.append("<exch_rate><![CDATA["+  exchRate1 +"]]></exch_rate>");// CAN NOT BE NULL
									valueXmlString.append("<exch_rate__frt><![CDATA["+  exchRate1 +"]]></exch_rate__frt>");	
									valueXmlString.append("<exch_rate__ins><![CDATA["+ exchRate1 +"]]></exch_rate__ins>");


									valueXmlString.append("<site_code__ship><![CDATA["+ siteCodeShip +"]]></site_code__ship>");
									if(siteCodeShip.length() > 0){
										siteCodeDesc=checkNull(getColumnDescr(conn, "descr", "site", "site_code", siteCodeShip));
									}
									valueXmlString.append("<site_descr><![CDATA["+ siteCodeDesc+"]]></site_descr>");
									valueXmlString.append("<site_code><![CDATA["+ siteCode +"]]></site_code>");
									if(siteCode.length() > 0){
										siteCodeDesc=checkNull(getColumnDescr(conn, "descr", "site", "site_code", siteCode));	
									}

									valueXmlString.append("<descr><![CDATA["+ siteCodeDesc+"]]></descr>");
									valueXmlString.append("<state_code__dlv><![CDATA["+ stanCodeDlv.trim()+"]]></state_code__dlv>");

									valueXmlString.append("<dlv_add1><![CDATA["+ dlvAdd1 +"]]></dlv_add1>");
									valueXmlString.append("<dlv_add2><![CDATA["+ dlvAdd2 +"]]></dlv_add2>");
									valueXmlString.append("<dlv_add3><![CDATA["+ dlvAdd3 +"]]></dlv_add3>");

									valueXmlString.append("<dlv_city><![CDATA["+ dlvCity +"]]></dlv_city>");				
									valueXmlString.append("<dlv_pin><![CDATA["+ dlvPin +"]]></dlv_pin>");
									valueXmlString.append("<count_code__dlv><![CDATA["+ countCodeDlv +"]]></count_code__dlv>");
									valueXmlString.append("<tran_code><![CDATA["+ tranCode +"]]></tran_code>");
									valueXmlString.append("<stan_code__init><![CDATA["+ stanCodeInit +"]]></stan_code__init>");
									valueXmlString.append("<status_remarks><![CDATA["+ statusRemarks +"]]></status_remarks>");
									valueXmlString.append("<status><![CDATA["+ status +"]]></status>");
									tranName=getColumnDescr(conn,"tran_name" , "transporter", "tran_code", tranCode);
									valueXmlString.append("<tran_name><![CDATA["+ tranName +"]]></tran_name>");

									valueXmlString.append("<remarks><![CDATA["+ remarksDes +"]]></remarks>");
									valueXmlString.append("<no_art><![CDATA["+ noArtDes+"]]></no_art>");	
									valueXmlString.append("<gross_weight>").append("<![CDATA[" + grossWeight + "]]>").append("</gross_weight>");
									valueXmlString.append("<nett_weight>").append("<![CDATA[" + netWeight + "]]>").append("</nett_weight>");
									valueXmlString.append("<tare_weight>").append("<![CDATA[" + tareWeight + "]]>").append("</tare_weight>");
									
									valueXmlString.append("<add_user>").append("<![CDATA[" + chgUser + "]]>").append("</add_user>"); 
									valueXmlString.append("<add_term>").append("<![CDATA[" + chgTerm + "]]>").append("</add_term>");
									valueXmlString.append("<add_date>").append("<![CDATA[" + currAppdate + "]]>").append("</add_date>");
									
									
									
									
									valueXmlString.append("</Detail2>");
									
								}
							}
						
					}else{												
						valueXmlString.append(insertNewRecord(sorderNo,currentFormNo,conn));
						
					}
						
					}//end itemDefault condition			
					
				} //end cnt > 0 condition
				else { 
					System.out.println("--------no data found in Despatch-------------");					
					valueXmlString.append(insertNewRecord(sorderNo,currentFormNo,conn));
					
				}
				if(currentColumn.trim().equalsIgnoreCase("tran_code_123"))//comment
				{
					System.out.println(">>>>START tran_code38>>>>");
					tranCode = genericUtility.getColumnValue("tran_code",dom);
					System.out.println("tranCode----->>["+tranCode+"]");
					String currDomStr = genericUtility.serializeDom(dom);

					if(tranCode != null && tranCode.trim().length() > 0)
					{
						tranName=getColumnDescr(conn,"tran_name" , "transporter", "tran_code", tranCode);						
						System.out.println("tranName----->>["+tranName+"]");
						valueXmlString.append("<tran_name protect=\"0\">").append("<![CDATA[" + tranName + "]]>").append("</tran_name>");
						setNodeValue( dom, "tran_name", getAbsString(""+tranName));					
						transMode=getColumnDescr(conn,"trans_mode" , "transporter_mode", "tran_code", tranCode);
						
						valueXmlString.append("<trans_mode protect=\"0\">").append("<![CDATA[" + transMode + "]]>").append("</trans_mode>");
						setNodeValue( dom, "trans_mode", getAbsString(""+transMode)); 						
						currDomStr = currDomStr.replace("</Detail2>", valueXmlString.toString() + "</Detail2>");
						System.out.println("after currDomStr[" + currDomStr + "]");
						valueXmlString.append(currDomStr);
					}
					else
					{
						System.out.println("-------in else of tran mode --------------------");
						valueXmlString.append("<tran_name protect=\"0\">").append("<![CDATA[]]>").append("</tran_name>");
						setNodeValue( dom, "sh_name", getAbsString("")); 

						valueXmlString.append("<trans_mode protect=\"0\">").append("<![CDATA[]]>").append("</trans_mode>");
						setNodeValue( dom, "trans_mode", getAbsString("")); 

						currDomStr = currDomStr.replace("</Detail2>", valueXmlString.toString() + "</Detail2>");
						System.out.println("after currDomStr[" + currDomStr + "]");
						valueXmlString.append(currDomStr);
					}


					System.out.println(">>>>END>>>>>>>>>trancode");

				}


				break;
			case 3 : 
				System.out.println("------Case 3 called or form 3 called------@@-----------");
				System.out.println("dom in form3---->>["+genericUtility.serializeDom(dom)+"]");
				System.out.println("dom111 in form3---->>["+genericUtility.serializeDom(dom1)+"]");
				System.out.println("dom222 in form3---->>["+genericUtility.serializeDom(dom2)+"]");
				tranDate = getCurrdateAppFormat() ;			
				
				sorderNo = checkNull(genericUtility.getColumnValue("sale_order_no", dom2));
				despId = checkNull(genericUtility.getColumnValue("desp_id", dom2,"2"));
				String domID = checkNull(getColumnValueMy("Detail3", dom2, "3"));
				System.out.println("sorderNo---->>["+sorderNo+"]");
				System.out.println("despID---->>["+despId+"]");
				System.out.println("domID---->>["+domID+"]");
				System.out.println("addUsersList2@---->>["+addUsersList+"]");
				if(addUsersList !=null){
					addUsersList.clear();
				}
				
				sql = "select add_user from despatch where CASE WHEN confirmed IS NULL THEN 'N' ELSE CONFIRMED  END = 'N' and sord_no= ?";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1,sorderNo);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					addUser = rs.getString("add_user")==null?"":rs.getString("add_user").trim();
					addUsersList.add(addUser);					
				}
				if(rs!=null){
				rs.close();
				rs=null;
				}
				if(pstmt!=null){
				pstmt.close();
				pstmt = null;
				}
				if(addUsersList.contains(chgUser))
				{
					for(int i = 0;i < addUsersList.size(); i++)
					{
						
						addUser = addUsersList.get(i);
						System.out.println("addUser>>>>>"+addUser);
						
						if(chgUser.equalsIgnoreCase(addUser))
						{
							sql = "select desp_id from despatch where CASE WHEN confirmed IS NULL THEN 'N' ELSE CONFIRMED  END = 'N' and sord_no = ? and add_user = ?";
							pstmt1=conn.prepareStatement(sql);
							pstmt1.setString(1,sorderNo);
							pstmt1.setString(2,addUser);
							rs1 = pstmt1.executeQuery();
							if(rs1.next())
							{
								despIdNew = rs1.getString(1) == null ? "":rs1.getString(1);
							}
							pstmt1.close();
							rs1.close();
							pstmt1 = null;
							rs1 = null;
						}
					}					
					
				}
				else
				{					
					sql = "select desp_id from despatch where CASE WHEN confirmed IS NULL THEN 'N' ELSE CONFIRMED  END = 'N' and sord_no = ?";
					pstmt1=conn.prepareStatement(sql);
					pstmt1.setString(1,sorderNo);
					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						despIdNew = rs1.getString(1) == null ? "":rs1.getString(1);
					}
					pstmt1.close();
					rs1.close();
					pstmt1 = null;
					rs1 = null;						
				}

				
				System.out.println("tranid FROM QUERY----->["+despIdNew+"]");
				
				
				
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					System.out.println("Form 3 itm_default called234.................");
					sql="select despatchdet.desp_id,despatchdet.line_no,despatchdet.sord_no,despatchdet.line_no__sord,"
							+ "despatchdet.exp_lev,despatchdet.item_code__ord,despatchdet.item_code,despatchdet.lot_no, "   
				         +"despatchdet.lot_sl,despatchdet.quantity__ord,despatchdet.quantity,item.descr, "
				         +"despatchdet.loc_code,despatchdet.status,despatchdet.conv__qty_stduom, "   
				         +"despatchdet.unit__std,despatchdet.unit, " 
				         +"despatchdet.quantity__stduom,despatchdet.quantity_real, "   
				         +"despatchdet.rate__stduom,sorddet.tax_class, "   
				         +"sorddet.tax_chap,sorddet.tax_env, "
				         +"sorddet.discount,despatchdet.pack_instr, "
				         +"despatchdet.no_art,sorditem.quantity - sorditem.qty_desp as pending_qty, "   
				         +"sorddet.rate,despatchdet.pack_qty, "   
				         +"despatchdet.exp_date,despatchdet.site_code, "   
				         +"despatchdet.mfg_date,despatchdet.chg_date, "   
				         +"despatchdet.chg_user,despatchdet.chg_term, "   
				         +"despatchdet.site_code__mfg,despatchdet.rate__clg, "   
				         +"despatchdet.gross_weight,despatchdet.tare_weight, "   
				         +"despatchdet.nett_weight,despatchdet.dimension, "   
				         +"despatchdet.tax_amt,despatchdet.disc_amt, "
				         +"despatchdet.conf_diff_amt,despatchdet.rate__std, "   
				         +"despatchdet.cost_rate,'' as qty_details, "  
				         +"despatchdet.line_type,0 as tot_net_amt, "
				         +"despatchdet.conv__rtuom_stduom,despatchdet.pallet_wt, "
				         +"despatchdet.tran_id__invpack,despatchdet.cust_item__ref, "
				         +"fn_custitem_dscr((despatch.cust_code),despatchdet.item_code,despatchdet.cust_item__ref)  as custitem_desc, "   
				         +"despatchdet.retest_date,despatchdet.part_no, "
				         +"despatchdet.disc_schem_billback_amt,despatchdet.disc_schem_offinv_amt, "   
				         +"despatchdet.pallet_no " 
				         +"from despatchdet, "   
				         +"item, "
				         +"sorddet, "   
				         +"sorditem, "   
				         +"despatch "  
				         +"where ( despatchdet.item_code = item.item_code (+)) and "  
				         +"( despatchdet.sord_no = sorddet.sale_order (+)) and "  
				         +"( despatchdet.line_no__sord = sorddet.line_no (+)) and "  
				         +"( despatchdet.sord_no = sorditem.sale_order (+)) and "
				         +"( despatchdet.line_no__sord = sorditem.line_no (+)) and "  
				         +"( despatchdet.exp_lev = sorditem.exp_lev (+)) and "  
				         +"( despatch.desp_id = despatchdet.desp_id ) and "
				         + " ( case when despatch.confirmed is null then 'N' else despatch.confirmed end <>'Y' ) and  "  
				         +"( ( despatchdet.desp_id = ? ))";
					
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, despId);
					rs=pstmt.executeQuery();
					while(rs.next()){				
					
						siteCode=checkNull(rs.getString("site_code"));
						lotslL=checkNull(rs.getString("lot_sl"));
					valueXmlString.append("<Detail3 domID='" +rs.getInt("line_no")+ "'  objContext = '"+currentFormNo+"' selected=\"Y\">\r\n");
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
					
					
					valueXmlString.append("<desp_id><![CDATA["+ despId +"]]></desp_id>");
					valueXmlString.append("<sord_no><![CDATA["+ checkNull(rs.getString("sord_no")) +"]]></sord_no>");
					valueXmlString.append("<line_no><![CDATA["+ rs.getInt("line_no") +"]]></line_no>");					
					valueXmlString.append("<line_no__sord><![CDATA["+ checkNull(rs.getString("line_no__sord")) +"]]></line_no__sord>");					
					valueXmlString.append("<lot_no><![CDATA["+ checkNull(rs.getString("lot_no")) +"]]></lot_no>");					
					valueXmlString.append("<lot_sl><![CDATA["+ checkNull(rs.getString("lot_sl")) +"]]></lot_sl>");					
					valueXmlString.append("<loc_code><![CDATA["+ checkNull(rs.getString("loc_code")) +"]]></loc_code>");					
					valueXmlString.append("<exp_lev><![CDATA["+ checkNull(rs.getString("exp_lev")) +"]]></exp_lev>");
					
					
					//valueXmlString.append("<remarks><![CDATA["+ "generated from sorder "+"]]></remarks>");					
					valueXmlString.append("<rate><![CDATA["+rate +"]]></rate>");					
					valueXmlString.append("<item_code__ord><![CDATA["+ checkNull(rs.getString("item_code__ord")) +"]]></item_code__ord>");					
					itemCode=checkNull(rs.getString("item_code"));
					valueXmlString.append("<item_code><![CDATA["+itemCode+"]]></item_code>");
					if(itemCode.length() > 0){
						//String itemDescr=;
						 //valueXmlString.append("<item_descr protect=\"0\">").append("<![CDATA[" + itemDescr + "]]>").append("</item_descr>");
						 valueXmlString.append("<item_descr><![CDATA["+ checkNull(getColumnDescr(conn, "descr", "item", "item_code", itemCode)) +"]]></item_descr>");	
					}
					
					valueXmlString.append("<quantity><![CDATA["+ (rs.getDouble("quantity")) +"]]></quantity>");					
					valueXmlString.append("<unit><![CDATA["+ checkNull(rs.getString("unit"))+"]]></unit>");					
					valueXmlString.append("<conv__qty_stduom><![CDATA["+ (rs.getDouble("conv__qty_stduom")) +"]]></conv__qty_stduom>");
					
					
					//valueXmlString.append("<unit__rate><![CDATA["+ (rs.getDouble("unit__rate")) +"]]></unit__rate>");				
					valueXmlString.append("<tax_class><![CDATA["+checkNull(rs.getString("tax_class")) +"]]></tax_class>");				
					valueXmlString.append("<tax_chap><![CDATA["+checkNull(rs.getString("tax_chap")) +"]]></tax_chap>");				
					valueXmlString.append("<tax_env><![CDATA["+ checkNull(rs.getString("tax_env"))+"]]></tax_env>");					
					valueXmlString.append("<rate__clg><![CDATA["+ (rs.getDouble("rate__clg")) +"]]></rate__clg>");					
					//valueXmlString.append("<tot_net_amt><![CDATA["+ netTotAmt.trim()+"]]></tot_net_amt>");					
					valueXmlString.append("<site_code><![CDATA["+ checkNull(rs.getString("site_code"))+"]]></site_code>");	
					valueXmlString.append("<site_code__mfg><![CDATA["+ checkNull(rs.getString("site_code__mfg")) +"]]></site_code__mfg>");
					valueXmlString.append("<quantity__stduom><![CDATA["+ (rs.getDouble("quantity__stduom"))+"]]></quantity__stduom>");					
					//valueXmlString.append("<pack_code><![CDATA["+  checkNull(rs.getString("pack_code"))+"]]></pack_code>");
					valueXmlString.append("<unit__std><![CDATA["+ checkNull(rs.getString("unit__std"))+"]]></unit__std>");
				
					valueXmlString.append("<no_art><![CDATA["+ (rs.getDouble("no_art")) +"]]></no_art>");
					valueXmlString.append("<rate__stduom><![CDATA["+ (rs.getDouble("rate__stduom")) +"]]></rate__stduom>");
					valueXmlString.append("<conv__rtuom_stduom><![CDATA["+ (rs.getDouble("conv__rtuom_stduom")) +"]]></conv__rtuom_stduom>");
					//valueXmlString.append("<tot_net_amt><![CDATA["+ netAmt +"]]></tot_net_amt>");
					//valueXmlString.append("<quantity_inv><![CDATA["+ quantity +"]]></quantity_inv>");
					valueXmlString.append("<quantity_real><![CDATA["+ (rs.getDouble("quantity_real")) +"]]></quantity_real>");
					
					mfgDate=rs.getDate("mfg_date");
					expiryDate=rs.getDate("exp_date");
					if(mfgDate!=null){
					valueXmlString.append("<mfg_date>").append("<![CDATA[").append(sdf.format(mfgDate).toString()).append("]]>").append("</mfg_date>");
					}
					if(expiryDate !=null){
					valueXmlString.append("<exp_date>").append("<![CDATA[").append(sdf.format(expiryDate).toString()).append("]]>").append("</exp_date>");
					}
					valueXmlString.append("<pending_qty>").append("<![CDATA[").append((rs.getDouble("pending_qty"))).append("]]>").append("</pending_qty>");
					valueXmlString.append("<quantity__ord>").append("<![CDATA[").append((rs.getDouble("quantity__ord"))).append("]]>").append("</quantity__ord>");
					
					valueXmlString.append("<gross_weight>").append("<![CDATA[").append((rs.getDouble("gross_weight"))).append("]]>").append("</gross_weight>");
					valueXmlString.append("<nett_weight>").append("<![CDATA[").append((rs.getDouble("nett_weight"))).append("]]>").append("</nett_weight>");
					valueXmlString.append("<tare_weight>").append("<![CDATA[").append((rs.getDouble("tare_weight"))).append("]]>").append("</tare_weight>");
					valueXmlString.append("<dimension><![CDATA["+ checkNull(rs.getString("dimension")) +"]]></dimension>");
					valueXmlString.append("<pallet_wt><![CDATA["+ (rs.getDouble("pallet_wt")) +"]]></pallet_wt>");
					
					
					//for hold status Start
					
					sql = "select hold_qty from stock where site_code = ? and lot_sl = ? and quantity > 0";
					pstmt1=conn.prepareStatement(sql);
					pstmt1.setString(1,siteCode);
					pstmt1.setString(2,lotslL);

					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						holdQtyL=rs1.getDouble(1);
					}
					System.out.println("Edit mode holdQtyL---->>["+holdQtyL+"]");
					
					if(holdQtyL > 0){
						valueXmlString.append("<lot_status><![CDATA["+ lotStatus +"]]></lot_status>");
					}else{
						valueXmlString.append("<lot_status><![CDATA[]]></lot_status>");
					}
					//for hold status End
					
					valueXmlString.append("</Detail3>");
					}//end while
					if(rs!=null){
					rs.close();
					rs=null;
					}
					if(pstmt!=null){
					pstmt.close();
					pstmt=null;
					}
				}
				else if(currentColumn.trim().equalsIgnoreCase("itm_default_add"))
				{
					String lineNoAdd="",lnNoSord="",quantity="",rate1="",conQtyStd="",itemDescr="",itemCodeOrd="";
					String unitRate="",taxClass="",taxChap="",taxEnv="",netTotAmt="",quntyStduom="",
							siteCodeDet="",unitStd="", noArt="", convRtuomStduom="",netAmt="",rateStduom="";
					System.out.println("Form 3 itm_default_add called.................");
					int lineNo1=0;
					double rateClg=0;
					
					//String str=new DespatchAct().actionDefault(dom2, dom1, objContext, xtraParams);
					//System.out.println("str------------->>["+str+"]");
				/*	String xmlString=new DespatchAct().actionDefault(dom1,dom2,objContext,xtraParams);
					System.out.println("return string from actionDefault---->>["+xmlString+"]");
					valueXmlString.append(xmlString);*/
					sql = "select max(line_no)  "
							+ "from despatchdet where sord_no = ?";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1,sorderNo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lineNoAdd = checkNull(rs.getString(1));						
					}
					
					
					pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
					 if(lineNoAdd.length() > 0){
					 lineNo1=Integer.parseInt(lineNoAdd);
					 lineNo1++;
					 }else{
					  lineNo1=1;
					 }
					//item_descr
					sql = "select line_no,item_code,item_code__ord,quantity,rate,unit,conv__qty_stduom,unit__rate,tax_class,tax_chap,tax_env,pack_code,rate__clg,quantity__stduom," +
							"net_tot_amt,net_amt,site_code,unit__std,no_art,rate__stduom,conv__rtuom_stduom from sorddet where sale_order = ? order by line_no";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,sorderNo);
					rs = pstmt.executeQuery();
				   if( rs.next() )
				   {
					   lnNoSord = checkNull(rs.getString("line_no"));	
						itemCode = rs.getString("item_code") == null ? " " : rs.getString("item_code");
						itemCodeOrd = rs.getString("item_code__ord") == null ? " " : rs.getString("item_code__ord");
						quantity = rs.getString("quantity") == null ? "0" : rs.getString("quantity")  ;
						rate1 = rs.getString("rate")== null ? " " : rs.getString("rate");
						unit = rs.getString("unit") == null ? " " : rs.getString("unit");
						conQtyStd = rs.getString("conv__qty_stduom") == null ? " " : rs.getString("conv__qty_stduom");
						unitRate = rs.getString("unit__rate") == null ? " " : rs.getString("unit__rate");
						taxClass = rs.getString("tax_class") == null ? " " : rs.getString("tax_class");
						taxChap = rs.getString("tax_chap") == null ? " " : rs.getString("tax_chap");
						taxEnv = rs.getString("tax_env") == null ? " " : rs.getString("tax_env");
						packCode = rs.getString("pack_code") == null ? " " : rs.getString("pack_code");
						rateClg = rs.getDouble("rate__clg");
						quntyStduom = rs.getString("quantity__stduom") == null ? "0" : rs.getString("quantity__stduom");
						netTotAmt = rs.getString("net_tot_amt") == null ? " " : rs.getString("net_tot_amt");
						siteCodeDet = rs.getString("site_code") == null ? " " : rs.getString("site_code");	
						unitStd = rs.getString("unit__std") == null ? " " : rs.getString("unit__std");	
						noArt = checkNull(rs.getString("no_art"));	
						rateStduom = rs.getString("rate__stduom");	
						convRtuomStduom = rs.getString("conv__rtuom_stduom");	
						netAmt = rs.getString("net_amt");	
				   } 
				   pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
				   itemDescr=checkNull(getColumnDescr(conn, "descr", "item", "item_code", itemCode));
				   
					
				   System.out.println("lnNoSord-------->>["+lnNoSord+"]");
				   System.out.println("lineNo1-------->>["+lineNo1+"]");
				   System.out.println("despIdNew-------->>["+despIdNew+"]");
				  
				   valueXmlString.append("<Detail3 domID='" +lineNo1+ "'  objContext = '"+currentFormNo+"' selected=\"Y\">\r\n");
					valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
					
					
					//valueXmlString.append("<desp_id><![CDATA["+ despIdNew +"]]></desp_id>");
					valueXmlString.append("<sord_no><![CDATA["+ sorderNo +"]]></sord_no>");
					valueXmlString.append("<line_no><![CDATA["+ lineNo1 +"]]></line_no>");					
					valueXmlString.append("<line_no__sord><![CDATA["+ lnNoSord +"]]></line_no__sord>");					
					
					valueXmlString.append("<lot_no><![CDATA[]]></lot_no>");					
					valueXmlString.append("<lot_sl><![CDATA[]]></lot_sl>");					
					valueXmlString.append("<loc_code><![CDATA[]]></loc_code>");					
					valueXmlString.append("<exp_lev><![CDATA[]]></exp_lev>");					
					//valueXmlString.append("<remarks><![CDATA["+ "generated from sorder "+"]]></remarks>");					
					valueXmlString.append("<rate><![CDATA["+rate1 +"]]></rate>");					
					valueXmlString.append("<item_code__ord><![CDATA["+ itemCodeOrd +"]]></item_code__ord>");					
					//valueXmlString.append("<item_code><![CDATA["+ itemCode +"]]></item_code>");					
					//valueXmlString.append("<quantity><![CDATA["+ quantity.trim() +"]]></quantity>");					
					valueXmlString.append("<unit><![CDATA["+ unit+"]]></unit>");					
					valueXmlString.append("<conv__qty_stduom><![CDATA["+ conQtyStd +"]]></conv__qty_stduom>");					
					valueXmlString.append("<unit__rate><![CDATA["+ unitRate +"]]></unit__rate>");				
					valueXmlString.append("<tax_class><![CDATA["+taxClass.trim() +"]]></tax_class>");				
					valueXmlString.append("<tax_chap><![CDATA["+taxChap +"]]></tax_chap>");				
					valueXmlString.append("<tax_env><![CDATA["+ taxEnv+"]]></tax_env>");					
					valueXmlString.append("<rate__clg><![CDATA["+ rateClg +"]]></rate__clg>");					
					valueXmlString.append("<tot_net_amt><![CDATA["+ netTotAmt.trim()+"]]></tot_net_amt>");					
					valueXmlString.append("<site_code><![CDATA["+ siteCodeDet.trim()+"]]></site_code>");					
					
					
					valueXmlString.append("<quantity__stduom><![CDATA["+ quntyStduom.trim()+"]]></quantity__stduom>");					
					valueXmlString.append("<pack_code><![CDATA["+ packCode.trim()+"]]></pack_code>");
					valueXmlString.append("<unit__std><![CDATA["+ unitStd+"]]></unit__std>");
					//valueXmlString.append("<CHG_USER><![CDATA["+ userId +"]]></CHG_USER>");
					//valueXmlString.append("<CHG_TERM><![CDATA["+ termId +"]]></CHG_TERM>");
					//valueXmlString.append("<CHG_DATE><![CDATA["+ today +"]]></CHG_DATE>");
					valueXmlString.append("<no_art><![CDATA["+ noArt+"]]></no_art>");
					valueXmlString.append("<rate__stduom><![CDATA["+ rateStduom +"]]></rate__stduom>");
					valueXmlString.append("<conv__rtuom_stduom><![CDATA["+ convRtuomStduom +"]]></conv__rtuom_stduom>");
					valueXmlString.append("<tot_net_amt><![CDATA["+ netAmt +"]]></tot_net_amt>");
					
					
					/*valueXmlString.append("<gross_weight>").append("<![CDATA[").append(grossWeight1).append("]]>").append("</gross_weight>");
					valueXmlString.append("<nett_weight>").append("<![CDATA[").append(netWeight1).append("]]>").append("</nett_weight>");
					valueXmlString.append("<tare_weight>").append("<![CDATA[").append(tareWeight1).append("]]>").append("</tare_weight>");
					valueXmlString.append("<dimension><![CDATA["+ dimension +"]]></dimension>");
					valueXmlString.append("<pallet_wt><![CDATA["+ palletWt +"]]></pallet_wt>");
					valueXmlString.append("<pack_code><![CDATA["+ packCode +"]]></pack_code>");*/
					/*valueXmlString.append("<rate><![CDATA[ ]]></rate>");
					valueXmlString.append("<item_code__ord><![CDATA[ ]]></item_code__ord>");
					valueXmlString.append("<item_code><![CDATA[ ]]></item_code>");
					valueXmlString.append("<quantity><![CDATA[ ]]></quantity>");
					valueXmlString.append("<unit><![CDATA[ ]]></unit>");
					valueXmlString.append("<conv__qty_stduom><![CDATA[ ]]></conv__qty_stduom>");
					
					valueXmlString.append("<tax_class><![CDATA[ ]]></tax_class>");
					valueXmlString.append("<tax_chap><![CDATA[ ]]></tax_chap>");
					valueXmlString.append("<tax_env><![CDATA[ ]]></tax_env>");
					valueXmlString.append("<rate__clg><![CDATA[ ]]></rate__clg>");
					valueXmlString.append("<site_code><![CDATA[ ]]></site_code>");
					valueXmlString.append("<quantity__stduom><![CDATA[ ]]></quantity__stduom>");
					valueXmlString.append("<unit__std><![CDATA[ ]]></unit__std>");
					
					valueXmlString.append("<pallet_wt><![CDATA[ ]]></pallet_wt>");
					valueXmlString.append("<no_art><![CDATA[ ]]></no_art>");
					valueXmlString.append("<rate__stduom><![CDATA[ ]]></rate__stduom>");
					valueXmlString.append("<conv__rtuom_stduom><![CDATA[ ]]></conv__rtuom_stduom>");
					valueXmlString.append("<quantity_real><![CDATA[ ]]></quantity_real>");
					
					valueXmlString.append("<pending_qty><![CDATA[ ]]></pending_qty>");
					valueXmlString.append("<quantity__ord><![CDATA[ ]]></quantity__ord>");
					valueXmlString.append("<gross_weight><![CDATA[ ]]></gross_weight>");
					valueXmlString.append("<tare_weight><![CDATA[ ]]></tare_weight>");
					valueXmlString.append("<dimension><![CDATA[ ]]></dimension>");
					valueXmlString.append("<pallet_wt><![CDATA[ ]]></pallet_wt>");		*/				
					
					
					valueXmlString.append("</Detail3>");
					
					
				}

				else if(currentColumn.trim().equalsIgnoreCase("lot_sl"))
				{
					String lineNoAdd="",lnNoSord="",quantity="",rate1="",conQtyStd="",itemDescr="",itemCodeOrd="";
					String unitRate="",taxClass="",taxChap="",taxEnv="",netTotAmt="",quntyStduom="",avalyn="",siteCodeMfg="",
							siteCodeDet="",unitStd="", noArt="", convRtuomStduom="",netAmt="",rateStduom="";
					String expLev="1.";
					System.out.println("Form 3 itm_default_add called.................");
					int lineNo1=0;
					double rateClg=0;
					System.out.println("Form 3 lot_sl item change1111111222..............");
					System.out.println("EDIT fLAG----->>["+editFlag+"]");
					String lotSlL="",siteCodeL="",dimension="",holdQtyS="HOLD";
					double qtyStk=0,palletWt=0,cAllocQty=0,holdQty=0,allocQty=0,actualQty=0;					
					lotSlL=checkNull(genericUtility.getColumnValue("lot_sl", dom2,"3"));
					System.out.println("lotSlL--->2222["+lotSlL+"]");
					siteCodeL=getColumnDescr(conn, "site_code", "sorder", "sale_order", sorderNo);
					avalyn=getColumnDescr(conn, "available_yn", "sorder", "sale_order", sorderNo);
					avalyn=avalyn==null ? "N" : avalyn.trim();
					//ADDED nEW
					
					String currDomStr = genericUtility.serializeDom(dom);
					System.out.println("currDomStr--------->>["+currDomStr+"]");
					sql = "select line_no,item_code,item_code__ord,quantity,rate,unit,conv__qty_stduom,unit__rate,tax_class,tax_chap,tax_env,pack_code,rate__clg,quantity__stduom," +
							"net_tot_amt,net_amt,site_code,unit__std,no_art,rate__stduom,conv__rtuom_stduom from sorddet where sale_order = ? order by line_no";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,sorderNo);
					rs = pstmt.executeQuery();
				   if( rs.next() )
				   {
					   lnNoSord = rs.getString("line_no");	
						itemCode = rs.getString("item_code") == null ? " " : rs.getString("item_code");
						itemCodeOrd = rs.getString("item_code__ord") == null ? " " : rs.getString("item_code__ord");
						quantity = rs.getString("quantity") == null ? "0" : rs.getString("quantity")  ;
						rate1 = rs.getString("rate")== null ? " " : rs.getString("rate");
						unit = rs.getString("unit") == null ? " " : rs.getString("unit");
						conQtyStd = rs.getString("conv__qty_stduom") == null ? " " : rs.getString("conv__qty_stduom");
						unitRate = rs.getString("unit__rate") == null ? " " : rs.getString("unit__rate");
						taxClass = rs.getString("tax_class") == null ? " " : rs.getString("tax_class");
						taxChap = rs.getString("tax_chap") == null ? " " : rs.getString("tax_chap");
						taxEnv = rs.getString("tax_env") == null ? " " : rs.getString("tax_env");
						packCode = rs.getString("pack_code") == null ? " " : rs.getString("pack_code");
						rateClg = rs.getDouble("rate__clg");
						quntyStduom = rs.getString("quantity__stduom") == null ? "0" : rs.getString("quantity__stduom");
						netTotAmt = rs.getString("net_tot_amt") == null ? " " : rs.getString("net_tot_amt");
						siteCodeDet = rs.getString("site_code") == null ? " " : rs.getString("site_code");	
						unitStd = rs.getString("unit__std") == null ? " " : rs.getString("unit__std");	
						noArt = checkNull(rs.getString("no_art"));
						rateStduom = rs.getString("rate__stduom");	
						convRtuomStduom = rs.getString("conv__rtuom_stduom");	
						netAmt = rs.getString("net_amt");
						
				   } 
				   pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
				  
				   
					
				   System.out.println("lnNoSord lotSl item change@#-------->>["+lnNoSord+"]"); 
				  
				 
				   valueXmlString.append("<Detail3 domID='" +lineNo1+ "'  objContext = '"+currentFormNo+"' selected=\"Y\">\r\n");
					 valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
				  
					
					valueXmlString.append("<desp_id><![CDATA["+ despIdNew +"]]></desp_id>");
								
					
					valueXmlString.append("<lot_no><![CDATA[]]></lot_no>");	                  				
					valueXmlString.append("<lot_sl><![CDATA[]]></lot_sl>");					
					valueXmlString.append("<loc_code><![CDATA[]]></loc_code>");					
						
					valueXmlString.append("<exp_lev><![CDATA["+expLev +"]]></exp_lev>");	
					//valueXmlString.append("<remarks><![CDATA["+ "generated from sorder "+"]]></remarks>");					
					valueXmlString.append("<rate><![CDATA["+rate1 +"]]></rate>");					
					valueXmlString.append("<item_code__ord><![CDATA["+ itemCodeOrd +"]]></item_code__ord>");					
					//valueXmlString.append("<item_code><![CDATA["+ itemCode +"]]></item_code>");					
					//valueXmlString.append("<quantity><![CDATA["+ quantity.trim() +"]]></quantity>");					
					valueXmlString.append("<unit><![CDATA["+ unit+"]]></unit>");					
					valueXmlString.append("<conv__qty_stduom><![CDATA["+ conQtyStd +"]]></conv__qty_stduom>");					
					valueXmlString.append("<unit__rate><![CDATA["+ unitRate +"]]></unit__rate>");				
					valueXmlString.append("<tax_class><![CDATA["+taxClass.trim() +"]]></tax_class>");				
					valueXmlString.append("<tax_chap><![CDATA["+taxChap +"]]></tax_chap>");				
					valueXmlString.append("<tax_env><![CDATA["+ taxEnv+"]]></tax_env>");					
					valueXmlString.append("<rate__clg><![CDATA["+ rateClg +"]]></rate__clg>");					
					valueXmlString.append("<tot_net_amt><![CDATA["+ netTotAmt.trim()+"]]></tot_net_amt>");					
					valueXmlString.append("<site_code><![CDATA["+ siteCodeDet.trim()+"]]></site_code>");
					
					valueXmlString.append("<quantity__stduom><![CDATA["+ quntyStduom.trim()+"]]></quantity__stduom>");					
					valueXmlString.append("<pack_code><![CDATA["+ packCode.trim()+"]]></pack_code>");
					valueXmlString.append("<unit__std><![CDATA["+ unitStd+"]]></unit__std>");
					valueXmlString.append("<CHG_USER><![CDATA["+ chgUser +"]]></CHG_USER>");
					valueXmlString.append("<CHG_TERM><![CDATA["+ chgTerm +"]]></CHG_TERM>");
					valueXmlString.append("<CHG_DATE><![CDATA["+ currAppdate +"]]></CHG_DATE>");
					valueXmlString.append("<no_art><![CDATA["+ noArt +"]]></no_art>");
					valueXmlString.append("<rate__stduom><![CDATA["+ rateStduom +"]]></rate__stduom>");
					valueXmlString.append("<conv__rtuom_stduom><![CDATA["+ convRtuomStduom +"]]></conv__rtuom_stduom>");
					valueXmlString.append("<tot_net_amt><![CDATA["+ netAmt +"]]></tot_net_amt>");
											
					
					
					
					//Addd New End
					
					
					sql = "select loc_code,lot_no,item_code,quantity,gross_weight,net_weight,tare_weight,no_art,"
							+ "hold_qty,alloc_qty,site_code__mfg,mfg_date,exp_date from stock where site_code = ? and lot_sl = ? and quantity > 0";
					pstmt1=conn.prepareStatement(sql);
					pstmt1.setString(1,siteCodeL);
					pstmt1.setString(2,lotSlL);

					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						locCode =  checkNull(rs1.getString("loc_code"));
						lotNo = checkNull(rs1.getString("lot_no"));
						itemCode = checkNull(rs1.getString("item_code"));
						squantity = rs1.getDouble("quantity");
						grossWeight = rs1.getDouble("gross_weight");
						netWeight = rs1.getDouble("net_weight");
						tareWeight = rs1.getDouble("tare_weight");
						noOfArt = rs1.getDouble("no_art");
						holdQty = rs1.getDouble("hold_qty");
						allocQty = rs1.getDouble("alloc_qty");
						
						siteCodeMfg = rs1.getString("site_code__mfg")==null?"":rs1.getString("site_code__mfg").trim();
						
						siteCodeMfg= checkNull(rs1.getString("site_code__mfg"));
						mfgDate=rs1.getDate("mfg_date");
						expiryDate=rs1.getDate("exp_date");
						
                    }
					pstmt1.close();
					rs1.close();
					pstmt1 = null;
					rs1 = null;
					System.out.println("holdQty123-------->>["+holdQty+"]");
					
					itemDescr=getColumnDescr(conn, "descr", "item", "item_code", itemCode);
					String domID1="1";
					//valueXmlString.append("<sord_no><![CDATA["+ sorderNo +"]]></sord_no>");
					//valueXmlString.append("<line_no__sord><![CDATA["+ lnNoSord +"]]></line_no__sord>");
					//valueXmlString.append("<Detail3 domID='" +domID1+ "'  objContext = '"+currentFormNo+"' selected=\"Y\">\r\n");
					
					valueXmlString.append("<site_code__mfg><![CDATA["+ siteCodeMfg +"]]></site_code__mfg>");
					
					valueXmlString.append("<sord_no><![CDATA["+ sorderNo+"]]></sord_no>");
					valueXmlString.append("<line_no><![CDATA["+ lineNo1+"]]></line_no>");
					valueXmlString.append("<line_no__sord><![CDATA["+ lnNoSord+"]]></line_no__sord>");
					valueXmlString.append("<item_code><![CDATA["+ itemCode+"]]></item_code>");
					valueXmlString.append("<item_descr><![CDATA["+ itemDescr+"]]></item_descr>");
					
					valueXmlString.append("<item_code__ord><![CDATA["+ itemCode+"]]></item_code__ord>");
					valueXmlString.append("<lot_no><![CDATA["+ lotNo+"]]></lot_no>");
					valueXmlString.append("<no_art><![CDATA["+ noOfArt+"]]></no_art>");
					valueXmlString.append("<loc_code><![CDATA["+ locCode+"]]></loc_code>");
					if("Y".equalsIgnoreCase(avalyn)){
					actualQty=squantity - (holdQty + allocQty);
					}else{
						actualQty=squantity - allocQty;
					}
					valueXmlString.append("<quantity><![CDATA["+ actualQty+"]]></quantity>");
					
					valueXmlString.append("<quantity_inv><![CDATA["+actualQty +"]]></quantity_inv>");
					valueXmlString.append("<quantity_real><![CDATA["+ actualQty +"]]></quantity_real>");
					valueXmlString.append("<quantity__ord><![CDATA["+ actualQty +"]]></quantity__ord>");
					
					valueXmlString.append("<gross_weight><![CDATA["+ grossWeight+"]]></gross_weight>");
					valueXmlString.append("<nett_weight><![CDATA["+ netWeight+"]]></nett_weight>");
					valueXmlString.append("<tare_weight><![CDATA["+ tareWeight+"]]></tare_weight>");				
					
					
					if(mfgDate!=null){
					valueXmlString.append("<mfg_date>").append("<![CDATA[").append(sdf.format(mfgDate).toString()).append("]]>").append("</mfg_date>");
					}
					if(expiryDate !=null){
					valueXmlString.append("<exp_date>").append("<![CDATA[").append(sdf.format(expiryDate).toString()).append("]]>").append("</exp_date>");
					}
					
					
					valueXmlString.append("<lot_sl><![CDATA["+ lotSlL +"]]></lot_sl>");
					if(holdQty > 0){
						valueXmlString.append("<lot_status><![CDATA["+ holdQtyS +"]]></lot_status>");
					}else{
						valueXmlString.append("<lot_status><![CDATA[]]></lot_status>");
					}
					/*valueXmlString.append("<lot_sl protect=\"0\">").append("<![CDATA[" + lotSlL + "]]>").append("</item_code>");
					setNodeValue( dom2, "lot_sl", getAbsString(""+lotSlL));*/
					
					
					
					
					valueXmlString.append("</Detail3>");
					
					
				}


				break;

			} //end switch

			/*if(("lot_sl".equalsIgnoreCase(currentColumn)) || ("tran_code".equalsIgnoreCase(currentColumn)))
			{
				System.out.println("CHK VAL");
				String currDomStr = genericUtility.serializeDom(dom);
				System.out.println("currDomStr[" + currDomStr + "]");
				StringBuffer valueXmlStr = new StringBuffer(currDomStr);
				System.out.println("@@@@@@@@@@@ after serialize : valueXmlStr ["+valueXmlStr+"]");
				StringBuffer valueXmlString1 = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
				valueXmlString1.append(editFlag).append("</editFlag></header>");
				valueXmlString1.append(valueXmlStr);
				valueXmlString = valueXmlString1;
			}*/

			valueXmlString.append("</Root>"); 
		}
		catch(Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage()); 
			try {
				conn.rollback();				
			} catch (Exception d) {
				d.printStackTrace();
			}
			throw new ITMException(e); 
		}
		finally 
		{
			try
			{
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close(); 
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace(); 
			}
		}
		System.out.println("Return item_change xml---->>["+valueXmlString.toString()+"]");
		return valueXmlString.toString();
	}


	private static String getAbsString( String str )
	{
		return ( str == null || str.trim().length() == 0 || "null".equalsIgnoreCase( str.trim() ) ? "" : str.trim() );
	}

	private static void setNodeValue( Document dom, String nodeName, String nodeVal ) throws Exception
	{
		Node tempNode = dom.getElementsByTagName( nodeName ).item(0);

		if( tempNode != null )
		{
			if( tempNode.getFirstChild() == null )
			{
				CDATASection cDataSection = dom.createCDATASection( nodeVal );
				tempNode.appendChild( cDataSection );
			}
			else
			{
				tempNode.getFirstChild().setNodeValue(nodeVal);
			}
		}
		tempNode = null;
	}
	private String getDetails(String mSiteCode,int mLineNoDist,String mDistOrder,String lsTranType,Connection conn)throws RemoteException,ITMException
	{//this method will return xml data
		String mItemCode = null,mTaxClass=null,mTaxChap=null,mTaxEnv = null;
		String lsUnitAlt = null,lsUnit = null,lsPackInstr =null;
		double mQty= 0,lcQty= 0,mRate = 0,mDiscount =0;

		String sql = null,lsTranTypeParent ="";
		ResultSet rs = null,rs1 =null;
		PreparedStatement pstmt = null,pstmt1 =null;
		StringBuffer detail2hdr = new StringBuffer("");
		try
		{
			sql="select item_code,((case when qty_confirm is null then 0 else qty_confirm end) - "
					+" (case when qty_shipped is null then 0 else qty_shipped end))	as qty,"
					+" ((case when qty_shipped is null then 0 else qty_shipped end) - "
					+" (case when qty_return is null then 0 else qty_return end)) as lcqty,"
					+" tax_class,tax_chap,tax_env,case when rate is null then 0 else rate end as rate,"
					+" case when discount is null then 0 else discount end as discount,	"
					+" rate__clg  ,UNIT__ALT ,UNIT,CONV__QTY__ALT,pack_instr "
					+" from 	distorder_det "
					+" where dist_order = '"+mDistOrder+"'  "
					+" and 	line_no    = "+mLineNoDist+"" 
					+ " AND   CASE WHEN STATUS IS NULL THEN 'O' ELSE STATUS END<>'C' ";//Added by manoj dtd 24/12/2013 to exclude closed line"

			//System.out.println("[DistIssueItemChangeEJB] sql=>"+sql);

			pstmt   = conn.prepareStatement(sql);
			//	pstmt.setString(1,mDistOrder);
			//pstmt.setInt(2,mLineNoDist);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				mItemCode = rs.getString("item_code")==null?"":rs.getString("item_code");
				mQty = rs.getDouble("qty");
				lcQty = rs.getDouble("lcqty");
				mTaxClass = rs.getString("tax_class")==null?"":rs.getString("tax_class");
				mTaxChap = rs.getString("tax_chap")==null?"":rs.getString("tax_chap");
				mTaxEnv = rs.getString("tax_env")==null?"":rs.getString("tax_env");
				mRate = rs.getDouble("rate");
				mDiscount = rs.getDouble("discount");
				lsUnitAlt = rs.getString("UNIT__ALT")==null?"":rs.getString("UNIT__ALT");
				lsPackInstr = rs.getString("pack_instr")==null?"":rs.getString("pack_instr");

				if(lsUnitAlt.trim().length() == 0)
				{
					lsUnitAlt = lsUnit;
				}

			//	detail2hdr.append("<item_code><![CDATA["+mItemCode+"]]></item_code>");
				detail2hdr.append("<unit><![CDATA["+lsUnit+"]]></unit>");
				detail2hdr.append("<unit__alt><![CDATA["+lsUnitAlt+"]]></unit__alt>");
				detail2hdr.append("<pack_instr><![CDATA["+lsPackInstr+"]]></pack_instr>");


				sql=" select tran_type__parent "
						+" from	distorder_type where  tran_type = '"+lsTranType+"' ";
				//System.out.println("[DistIssueItemChangeEJB] sql=>"+sql);
				pstmt1= conn.prepareStatement(sql);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					lsTranTypeParent = rs1.getString("tran_type__parent") == null ? "": rs1.getString("tran_type__parent").trim();
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;

				if(! lsTranTypeParent.equalsIgnoreCase(lsTranType.trim()))
				{
					detail2hdr.append("<quantity>"+lcQty+"</quantity>");
					detail2hdr.append("<qty_order__alt>"+lcQty+"</qty_order__alt>");
					lcQty = lcQty;
				}
				else
				{
					detail2hdr.append("<quantity>"+mQty+"</quantity>");
					detail2hdr.append("<qty_order__alt>"+mQty+"</qty_order__alt>");
					lcQty = mQty;
				}
				detail2hdr.append("<tax_class><![CDATA["+mTaxClass+"]]></tax_class>");
				detail2hdr.append("<tax_chap><![CDATA["+mTaxChap+"]]></tax_chap>");
				detail2hdr.append("<tax_env><![CDATA["+mTaxEnv+"]]></tax_env>");
				detail2hdr.append("<rate>"+mRate+"</rate>");
				detail2hdr.append("<discount>"+mDiscount+"</discount>");
				//System.out.println("[CreateDistIssue] xml return ==>"+detail2hdr.toString());
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("chandni inside detail::"+detail2hdr.toString());
		return detail2hdr.toString();
	}

	private String getCurrdateAppFormat()
	{
		String s = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());
			//System.out.println(genericUtility.getDBDateFormat());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = (new SimpleDateFormat(genericUtility.getApplDateFormat())).format(timestamp).toString();
		}
		catch(Exception exception)
		{
			//System.out.println("Exception in [MPSOrder] getCurrdateAppFormat " + exception.getMessage());
		}
		return s;
	}
	protected int getDBRowCount(Connection conn, String table_name, String whrCondCol, String whrCondVal)
	{
		int count=0;				
		ResultSet rs=null;
		PreparedStatement pstmt = null;
		
		String sql="select count(1) from "+table_name+" where "+whrCondCol+" = ?";
		System.out.println("SQL in getDBRowCount method : "+sql);
		try{
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,whrCondVal);
			rs = pstmt.executeQuery();
			if(rs.next()){
			count = rs.getInt(1);
			}
			if(pstmt!=null){
			pstmt.close();
			pstmt = null;
			}
			if(rs!=null){
			rs.close();
			rs = null;
			}
		}
		
		catch(Exception ex){
			System.out.println("Exception In getDBRowCount method of DespatchWiz Class : "+ex.getMessage());
			ex.printStackTrace();
		}
		System.out.println("Return count from getDBRowCount ----->>["+count+"]");					
		return count;
	}
	private String insertNewRecord(String sorderId,int currentFormNo,Connection conn)
	{
		System.out.println("------in insertNewRecord method----------");
		 StringBuffer valueXmlString = new StringBuffer();
		 ResultSet rs=null;
		 PreparedStatement pstmt=null;
		 SimpleDateFormat sdf = null;
		 java.sql.Timestamp currDate = null;
		 int count=0;		
		 String sql="",siteCode="",currencyCode="",exchRate1="",transMode="",currCodeFrt="",currCodeIns="",stanCode="",stanCodeDlv="";
		 String dlvCity="",dlvPin="",countCodeDlv="",tranCode="",stanCodeInit="",status="",statusRemarks="",custCode="",custCodeDlv="";
		 String custCodeBil="",siteCodeShip="",dlvAdd1="",dlvAdd2="",dlvAdd3="",siteCodeDesc="",tranName="",currAppdate="",availableYn="";
		 Date orderDt=null,statusDate=null;
		System.out.println("--------no data found in Despatch-------------");
		System.out.println("chgUser567-------->>["+chgUser+"]");
		try{
			sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
			currDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
			currAppdate = sdf.format(currDate);
		sql = "select item_ser,site_code,curr_code,exch_rate,tran_code, trans_mode,curr_code__frt,curr_code__ins,cust_code__dlv," +
			    "stan_code,order_date,exch_rate__frt,exch_rate__ins,fob_value,conf_date,chg_date,state_code__dlv,udf__str1,udf__str2," +
				"dlv_city,dlv_pin,count_code__dlv,tran_code,stan_code,stan_code__init,parent__tran_id,rev__tran,status_remarks,"
				+ "spec_reason,dist_route,status,status_date,cust_code,cust_code__dlv,available_yn,"
				+ "cust_code__bil,site_code__ship,dlv_add1,dlv_add2,dlv_add3"+
				" from sorder where sale_order = ? " ;//available_yn
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1,sorderId);
		rs = pstmt.executeQuery();
		if( rs.next() )
		{
			count = 1;
			siteCode = checkNull(rs.getString("site_code"));
			 currencyCode = checkNull(rs.getString("curr_code"));
			exchRate1 = checkNull(rs.getString("exch_rate"));
			transMode = rs.getString("trans_mode") == null ? "R " : rs.getString("trans_mode");
			currCodeFrt = checkNull(rs.getString("curr_code__frt"));
			currCodeIns = checkNull(rs.getString("curr_code__ins"));
			
			stanCode = checkNull(rs.getString("stan_code"));
			orderDt = rs.getDate("order_date");
			stanCodeDlv = checkNull(rs.getString("state_code__dlv"));
			dlvCity = checkNull(rs.getString("dlv_city"));
			dlvPin = checkNull(rs.getString("dlv_pin"));
			countCodeDlv = checkNull(rs.getString("count_code__dlv"));
			tranCode = checkNull(rs.getString("tran_code"));
			stanCodeInit = checkNull(rs.getString("stan_code__init"));
			status = checkNull(rs.getString("status"));
			statusRemarks = checkNull(rs.getString("status_remarks"));
			statusDate = rs.getDate("status_date");
			custCode=checkNull(rs.getString("cust_code"));
			custCodeDlv=checkNull(rs.getString("cust_code__dlv"));
			custCodeBil=checkNull(rs.getString("cust_code__bil"));
			siteCodeShip=checkNull(rs.getString("site_code__ship"));
			availableYn=checkNull(rs.getString("available_yn"));
			
			dlvAdd1=checkNull(rs.getString("dlv_add1"));
			dlvAdd2=checkNull(rs.getString("dlv_add2"));
			dlvAdd3=checkNull(rs.getString("dlv_add3"));
			
		}
		if(rs!=null){
		rs.close();
		rs=null;
		}
		if(pstmt!=null){
		pstmt.close();
		pstmt=null;
		}
		valueXmlString.append("<Detail2 domID='" + count + "'  objContext = '"+currentFormNo+"' selected=\"N\">\r\n");
		valueXmlString.append("<attribute  selected=\"N\" updateFlag=\"A\"  status=\"N\" pkNames=\"\"/>\r\n");
		if(orderDt != null){
		valueXmlString.append("<desp_date><![CDATA["+ currAppdate +"]]></desp_date>");
		valueXmlString.append("<sord_date><![CDATA["+ sdf.format(orderDt).toString() +"]]></sord_date>");
		}
		valueXmlString.append("<sord_no><![CDATA["+ sorderId +"]]></sord_no>");
		valueXmlString.append("<cust_code><![CDATA["+ custCode +"]]></cust_code>");
		valueXmlString.append("<cust_code__dlv><![CDATA["+ custCodeDlv +"]]></cust_code__dlv>");
		valueXmlString.append("<cust_code__bil><![CDATA["+ custCodeBil +"]]></cust_code__bil>");
		valueXmlString.append("<stan_code><![CDATA["+ stanCode.trim() +"]]></stan_code>");
		valueXmlString.append("<trans_mode><![CDATA["+ transMode.trim() +"]]></trans_mode>");
		
		//valueXmlString.append("<lr_date><![CDATA["+ lrDateVal.toString() +"]]></lr_date>");
		//valueXmlString.append("<shipment_id><![CDATA["+ shipmentId.trim() +"]]></shipment_id>");
		valueXmlString.append("<curr_code__frt><![CDATA["+ currCodeFrt.trim() +"]]></curr_code__frt>");
		valueXmlString.append("<curr_code__ins><![CDATA["+ currCodeIns.trim() +"]]></curr_code__ins>");
		valueXmlString.append("<curr_code><![CDATA["+ currencyCode.trim() +"]]></curr_code>");
		valueXmlString.append("<exch_rate><![CDATA["+  exchRate1 +"]]></exch_rate>");
		valueXmlString.append("<exch_rate__frt><![CDATA["+  exchRate1 +"]]></exch_rate__frt>");	
		valueXmlString.append("<exch_rate__ins><![CDATA["+ exchRate1 +"]]></exch_rate__ins>");
		
		valueXmlString.append("<available_yn><![CDATA["+ availableYn +"]]></available_yn>");
		
		
		valueXmlString.append("<site_code__ship><![CDATA["+ siteCodeShip +"]]></site_code__ship>");
		siteCodeDesc=checkNull(getColumnDescr(conn, "descr", "site", "site_code", siteCodeShip));
		valueXmlString.append("<site_descr><![CDATA["+ siteCodeDesc+"]]></site_descr>");
		valueXmlString.append("<site_code><![CDATA["+ siteCode +"]]></site_code>");
		siteCodeDesc=checkNull(getColumnDescr(conn, "descr", "site", "site_code", siteCode));				
		valueXmlString.append("<descr><![CDATA["+ siteCodeDesc+"]]></descr>");
		valueXmlString.append("<state_code__dlv><![CDATA["+ stanCodeDlv.trim()+"]]></state_code__dlv>");
		
		valueXmlString.append("<dlv_add1><![CDATA["+ dlvAdd1 +"]]></dlv_add1>");
		valueXmlString.append("<dlv_add2><![CDATA["+ dlvAdd2 +"]]></dlv_add2>");
		valueXmlString.append("<dlv_add3><![CDATA["+ dlvAdd3 +"]]></dlv_add3>");
		
		valueXmlString.append("<dlv_city><![CDATA["+ dlvCity +"]]></dlv_city>");				
		valueXmlString.append("<dlv_pin><![CDATA["+ dlvPin +"]]></dlv_pin>");
		valueXmlString.append("<count_code__dlv><![CDATA["+ countCodeDlv +"]]></count_code__dlv>");
		//valueXmlString.append("<tran_code><![CDATA["+ tranCode +"]]></tran_code>");
		valueXmlString.append("<stan_code__init><![CDATA["+ stanCodeInit +"]]></stan_code__init>");
		valueXmlString.append("<status_remarks><![CDATA["+ statusRemarks +"]]></status_remarks>");
		valueXmlString.append("<status><![CDATA["+ status +"]]></status>");
		//tranName=getColumnDescr(conn,"tran_name" , "transporter", "tran_code", tranCode);
		//valueXmlString.append("<tran_name><![CDATA["+ tranName +"]]></tran_name>");
		
		
		
		valueXmlString.append("<chg_user>").append("<![CDATA[" + chgUser + "]]>").append("</chg_user>"); 
		valueXmlString.append("<chg_term>").append("<![CDATA[" + chgTerm + "]]>").append("</chg_term>");
		valueXmlString.append("<chg_date>").append("<![CDATA[" + currAppdate + "]]>").append("</chg_date>");
		
		valueXmlString.append("<add_user>").append("<![CDATA[" + chgUser + "]]>").append("</add_user>"); 
		valueXmlString.append("<add_term>").append("<![CDATA[" + chgTerm + "]]>").append("</add_term>");
		valueXmlString.append("<add_date>").append("<![CDATA[" + currAppdate + "]]>").append("</add_date>");
		
		valueXmlString.append("</Detail2>");
		}
		catch(Exception e){
			e.printStackTrace();
		}
		return valueXmlString.toString();
	
	}
	private String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) 
	{

			PreparedStatement pstmt = null ;
			ResultSet rs = null ; 
			String sql = "";
			String findValue = "";
			try
			{			
				sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,value);
				rs = pstmt.executeQuery();
				if(rs.next())
				{					
					findValue = rs.getString(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;	        
			}
			catch(Exception e)
			{
				System.out.println("Exception in getColumnDescr ");
				e.printStackTrace();
			}
			System.out.println("returning String from getColumnDescr " + findValue);
			return findValue;
		 
	}
	public String getColumnValueMy(String colName, Document dom, String formNo) 
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String columnName = "";
		String columnValue = null;
		boolean continueLoop = true;
		boolean isFormNo = false;
		int ctr;
		try
		{
			elementList = dom.getElementsByTagName(colName);
			
			if (Integer.parseInt(formNo) < 1)//parseInt takes the String type as input and treats the value as a particulas integer value.
			{
				isFormNo = true;
			}
			System.out.println("elementList length--->>"+ elementList.getLength());
			for(ctr = 0; ctr < elementList.getLength(); ctr++)
			{
				elementName = elementList.item(ctr);//item returns the indexed item in the collection
				parentNode = elementName.getParentNode();//get the parent node name
				elementAttr = (Element)parentNode;
				String domId=elementAttr.getAttribute("domID");
				return domId;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : [GenericUtility][getColumnValue(2)] :==>\n"+e.getMessage());
			//throw new BaseException(e);
		}
		return columnValue;
	}
	
	private double getQtyFromSordItem(String sorderNo,Connection conn)
	{
		ResultSet rs=null;
		PreparedStatement pstmt=null;
		String sql="";
		double actualQty=0;
		try{
			sql="select quantity - qty_desp as actual from sorditem where sale_order = ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, sorderNo);
			rs=pstmt.executeQuery();
			if(rs.next()){
				actualQty=rs.getDouble(1);
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch(Exception e){
			e.printStackTrace();
		}
		System.out.println("actualQty---->>["+actualQty+"]");
		return actualQty;
	}
	
	private int getInvHoldCount(Map<String,String> invHoldMap,Connection conn)
	{
		System.out.println("----in getInvHoldQuantity method------");
		ResultSet rs=null;
		PreparedStatement pstmt=null;
		String sql="",holdQty="",countS="",qcLockValue="";
		int count=0;
		try{
			qcLockValue=checkNull(getColumnDescr(conn, "var_value", "disparm", "var_name", "QUARNTINE_LOCKCODE"));
			System.out.println("qcLockValue------->>["+qcLockValue+"]");
			
			sql="select count(*) from inv_hold h,inv_hold_det d where h.tran_id = d.tran_id " 
					+"and d.item_code = ? and d.site_code = ? "
					+"and d.loc_code = ? and d.lot_no= ? AND h.confirmed= ? "
					+"and d.lot_sl= ? and d.hold_status = ? and h.lock_code  =  ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, invHoldMap.get("item_code"));
			pstmt.setString(2, invHoldMap.get("site_code"));
			pstmt.setString(3, invHoldMap.get("loc_code"));
			pstmt.setString(4, invHoldMap.get("lot_no"));
			pstmt.setString(5, "Y");
			pstmt.setString(6, invHoldMap.get("lot_sl"));
			pstmt.setString(7, "H");
			pstmt.setString(8, qcLockValue);
			rs=pstmt.executeQuery();
			if(rs.next()){
				count=rs.getInt(1);
			}
			if(rs!=null){
			rs.close();
			rs=null;
			}
			if(pstmt!=null){
			pstmt.close();
			pstmt=null;
			}
			
			/*sql="select hold_qty FROM stock where "
					+ "item_code = ? and site_code = ? and  loc_code = ? and lot_no = ? and lot_sl= ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, invHoldMap.get("item_code"));
			pstmt.setString(2, invHoldMap.get("site_code"));
			pstmt.setString(3, invHoldMap.get("loc_code"));
			pstmt.setString(4, invHoldMap.get("lot_no"));			
			pstmt.setString(5, invHoldMap.get("lot_sl"));			
			rs=pstmt.executeQuery();
			
			if(rs.next()){
				holdQty=rs.getString("hold_qty");
			}
			if(rs!=null){
			rs.close();
			rs=null;
			}
			if(pstmt!=null){
			pstmt.close();
			pstmt=null;
			}*/
		}
		catch(Exception e){
			e.printStackTrace();
		}
		holdQty=holdQty==null ? "0" : holdQty.trim();
		countS=Integer.toString(count);
		System.out.println("count---->>["+count+"]");
		
		return count;
		
	}
	public String checkNull(String str)
	{
		if(str == null){
			str="";
		}
		return str.trim();
	}
}
