/*	
		Developed by	: Hatim Laxmidhar
		Started On		: 06/01/2006
		Purpose  		: Confirm Button
		Window			: w_trainexec

*/

package ibase.webitm.ejb.adm.adv;

import java.rmi.RemoteException;
import java.sql.*;
import javax.ejb.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import ibase.webitm.utility.GenericUtility;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

public class TrainexecCnf extends ActionHandlerEJB implements TrainexecCnfLocal,TrainexecCnfRemote //SessionBean
{
	/*public void ejbCreate() throws RemoteException, CreateException 
	{
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate() 
	{
	}

	public void ejbPassivate() 
	{
	}*/

    public String confirm() throws RemoteException,ITMException
	{
		return "";
	}
	public String confirm(String trainNo, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{

		String  retString = "";
		try
		{
			System.out.println("=========================================================");
			System.out.println("Train No :"+ trainNo);
			retString = actionConfirm(trainNo, xtraParams, forcedFlag);
		}
	  catch(Exception e)
		{
			System.out.println("Exception :TrainexecCnfEJB :actionHandler :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}

	private String actionConfirm(String trainNo, String xtraParams, String forcedFlag) throws RemoteException,ITMException, SQLException
	{
		String errCode = "", errString = "";
		String confirmed = "", sql="";
		String batchNo = "", startPrd= "";
		String trainCode = "", loginCode = "";
		java.sql.Date startDate = null;
		Connection conn=  null;
		Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		GenericUtility genericUtility =  GenericUtility.getInstance();
		int cnt = 0;

		try
		{

			batchNo = trainNo.substring(trainNo.indexOf(":")+1);
			trainNo = trainNo.substring(0,trainNo.indexOf(":"));
			System.out.println("Batch No :"+ batchNo);
			System.out.println("Train No :"+ trainNo);

			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			//INTO :LS_CONFIRMED, :LS_TRAIN_CODE, :LD_START
			sql  = "SELECT CONFIRM, TRAIN_CODE , START_DATE " +
					"FROM TRAINEXEC " +
					"WHERE TRAIN_NO = '"+ trainNo +"'" +
					"AND BATCH_NO = '"+ batchNo +"'"; 

			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery(sql);

			if (rs.next())
			{
				confirmed = rs.getString(1);
				trainCode = rs.getString(2);
				startDate = rs.getDate(3);
			}

			if (confirmed.trim().equalsIgnoreCase("N"))
			{
				loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
				sql = "UPDATE TRAINEXEC SET CONFIRM = 'Y'," + 
						" EMP_CODE__CONF = '"+ loginCode + "', CONFIRM_DATE = ?" + 
						" WHERE TRAIN_NO = '"+ trainNo	 + "'" +
						" AND BATCH_NO   = '"+ batchNo	 + "'" ;		

				pstmt = conn.prepareStatement(sql);
				pstmt.setDate(1, new java.sql.Date(System.currentTimeMillis()));
				cnt = pstmt.executeUpdate();

				if (cnt <= 0)
				{
					errCode = "";
					errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
					return errString;
				}

				sql = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
				pstmt.clearParameters();
				pstmt = conn.prepareStatement(sql);
				pstmt.setDate(1,startDate);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					startPrd = rs.getString(1);
				}
				
				sql = "SELECT COMM_CATG, EMP_CODE " +
						"FROM TRAINEMP " +
						"WHERE TRAIN_NO = '" + trainNo + "'" +
						"AND BATCH_NO = '" + batchNo + "'" ;
				stmt = conn.createStatement();
				rs = stmt.executeQuery(sql);
				sql = "UPDATE TRAINNEED " +
						"SET STATUS		=  'U'," +
						"STATUS_DATE	= ?," +
						"TRAIN_NO		= ?," +
						"BATCH_NO		= ?," +
						"COMM_CATG		= ? " +
						"WHERE EMP_CODE = ? " +
						"AND TRAIN_CODE = ? " +
						"AND NVL(STATUS,'P') = 'P' " +
						"AND PRD_CODE__FR <= ?";
				pstmt = conn.prepareStatement(sql);
				while (rs.next())
				{
					pstmt.clearParameters();
					pstmt.setDate(1,new java.sql.Date(System.currentTimeMillis()));
					pstmt.setString(2, trainNo);
					pstmt.setString(3, batchNo);
					pstmt.setString(4, rs.getString(1));
					pstmt.setString(5, rs.getString(2));
					pstmt.setString(6, trainCode);
					pstmt.setString(7, startPrd);
					cnt += pstmt.executeUpdate();
				}
				if (cnt > 0)
				{
					errCode = "VTMCONF2";
					conn.commit();

				}
				else 
				{
					errCode = "VTRCONF1";
					conn.rollback();
				}
			} 
			else 
			{
				errCode = "VTRCONF1";
			}
		}
		catch (SQLException sqx)
		{
			conn.rollback();
			System.out.println("The sqlException occure in TrainexecCnfEJB :"+sqx);
			throw new ITMException(sqx);
		}
		catch (Exception e)
		{
			conn.rollback();
			System.out.println("The Exception occure in TrainExecCnfEJB :"+e);
			throw new ITMException(e);
		}
		finally
		{
			errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
			try
			{	
				if (conn!=null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				System.out.println(e);
			}
		}
		System.out.println("returning String from TrainexecCnfEJB :actionConfirm :" + errString);
		return errString; 
	}
}