//Author : Suraj Chirkhare
//Application : MPR-Request

package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
//import ibase.webitm.applAdmin.*;

@Stateless
public class MPReqmtnIC extends ValidatorEJB implements MPReqmtnICLocal,MPReqmtnICRemote
{
	
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}
	
	
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("MprRequirement:wfValData value of xmlString ["+xmlString+"]");
			System.out.println("MprRequirement:wfValData value of xmlString ["+xmlString1+"]");
			System.out.println("MprRequirement:wfValData value of xmlString ["+xmlString2+"]");
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println ("ErrString: " + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception: MprRequirement: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ("Returning from MprRequirement wfValData");
		return (errString);  
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
	
		Integer cc=0,xx=0,fldcase=0,cnt=0,currentFormNo =0,childNodeListLength =0,ctr=0;
		Integer initialField=1,lastField = 1 ;
		String fldname = "", Errcode="", mVal="", mVal1="", fldnm="",mdescr="",status="",emp_site="",FieldNo="",tranSerRef="";
		String errString = "",emp_Code="",errCode="",msgType="",errFldName= "",vacDatestr="",newVac="",empCodePrev="",tranIdRef="";
		String siteCode="",noPost="",budgetId="",gradeCode="",reportTo="",relDate="",reldateSql="",reportToadm="",empcodeHod="";
		String repToSql="",qlfCode="",qlfCodealt5="",qlfCodealt4="",qlfCodealt3="",qlfCodealt2="",qlfCodealt1="",qlfCodeSql="";
		String frmAge="",toAge="",passPerc="",experience="",logCode="",empSite="",vacCreated="",tranTypeRef="",confirm="";
		float percnt = 0;
		int userLevl = 0;
		int post = 0;
		int minExp = 0;
		int minAge = 0;
		
		Date mdate3=null, mdate1=null,mdate2=null,relieve_date = null,vacDate=null,reqDate=null;
		String childNodeName = null,childNodeValue = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		Connection conn = null;
		String designation="",deptCode="",designCode="",reqDatestr="",cadreCode="";
		java.util.Date currDate = new java.util.Date();		
			
		GenericUtility genericUtility = GenericUtility.getInstance();
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		System.out.println("WFValdata::::::::::::::::::");
		
		try
		{
			System.out.println("INside try::::::::::::::::::");
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			String loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			logCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "logincode");
			userLevl = userLev(logCode, conn);
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());	
			System.out.println("objContext::::::::::"+objContext);
			if (objContext != null && objContext.trim().length() > 0 )
			{
				try
				{
					currentFormNo = Integer.parseInt(objContext);
				}
				catch(Exception e)
				{
					throw new ITMException(e);
				}
			}
			System.out.println(" ***********Validation for MprRequirement Detail  "+currentFormNo);
			switch(currentFormNo)
			{
			
				case 1:
				{
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
				    childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					System.out.println("child Node List Length::::::"+childNodeListLength);
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{	
						
						childNode = childNodeList.item(ctr);
						System.out.println("childNode"+childNode);
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}

						childNodeName = childNode.getNodeName();
						if(childNode.getFirstChild()!= null)
						{
							childNodeValue = childNode.getFirstChild().getNodeValue();
						}
						if(childNodeName.equalsIgnoreCase("vac_no"))
						{
							String tranId="";
							cnt=0;
							String empTran="SELECT COUNT(*) AS CNT FROM TRANSETUP WHERE KEY_FLAG='M' AND TRAN_WINDOW='w_mpreqmnt'";
							pstmt=conn.prepareStatement(empTran);						
							rs=pstmt.executeQuery();
							while(rs.next())
							{
								cnt=rs.getInt("CNT");
							}
							close(pstmt, rs);
							if(cnt > 0)
							{
								tranId = genericUtility.getColumnValue("vac_no", dom);
								if(tranId == null || tranId.trim().length() == 0)
								{
									errList.add("VTMPREQT01");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQT01"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									String empTran2="SELECT COUNT(*) AS CNT FROM MPREQ WHERE VAC_NO=?";
									pstmt=conn.prepareStatement(empTran2);	
									pstmt.setString(1,tranId);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										cnt=rs.getInt("CNT");
									}
									close(pstmt, rs);
									if(editFlag != null && editFlag.trim().equalsIgnoreCase("A"))
									{
										if(cnt > 0)
										{
											errList.add("VTMPREQT02");
											errFields.add(childNodeName.toLowerCase());
											msgType = errorType(conn, "VTMPREQT02"); 					
											if (msgType.equalsIgnoreCase("E"))
											{
												break;
											}
										}
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("vac_date"))
						{
							vacDatestr=genericUtility.getColumnValue("vac_date", dom);
							if(vacDatestr == null || vacDatestr.trim().length() == 0)
							{
								errList.add("VTMPREQ001");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTMPREQ001"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							else
							{
								try
								{
									vacDate = sdf.parse(vacDatestr);
								}
								catch(Exception e)
								{
									errList.add("VTMPREQ001");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ001"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								if(vacDate.after(currDate))
								{
									errList.add("VTMPREQD01");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQD01"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							
						}
						
						if(childNodeName.equalsIgnoreCase("new_vacancy"))
						{
							newVac=genericUtility.getColumnValue("new_vacancy", dom);
							empCodePrev=genericUtility.getColumnValue("emp_code__prev", dom);
							cnt=0;
							if(newVac != null && newVac.trim().equalsIgnoreCase("N"))
							{
								if(empCodePrev == null || empCodePrev.trim().length() == 0)
								{
									errList.add("VTMPREQ002");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ002"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									String empPrevSql="SELECT COUNT(*) AS CNT FROM EMPLOYEE WHERE EMP_CODE=?";
									pstmt=conn.prepareStatement(empPrevSql);
									pstmt.setString(1, empCodePrev);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										cnt=rs.getInt("CNT");
									}
									close(pstmt, rs);
									if(cnt == 0)
									{
										errList.add("VMEMP1");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VMEMP1"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
							}
							else if(newVac != null && newVac.trim().equalsIgnoreCase("Y"))
							{
								if(empCodePrev != null && empCodePrev.trim().length() > 0)
								{
									errList.add("VTMPREQ003");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ003"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else
							{
								errList.add("VMNEWVAC");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMNEWVAC"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("emp_code__prev"))
						{
							empCodePrev=checkNull(genericUtility.getColumnValue("emp_code__prev", dom));						
							tranSerRef=checkNull(genericUtility.getColumnValue("tran_ser__ref", dom));
							tranIdRef=checkNull(genericUtility.getColumnValue("tran_id__ref", dom));
							tranTypeRef=checkNull(genericUtility.getColumnValue("tran_type__ref", dom));
							System.out.println("tranSerRef:::::::::"+tranSerRef);
							System.out.println("empCodePrev:::::::::"+empCodePrev);
							System.out.println("tranIdRef:::::::::"+tranIdRef);
							System.out.println("tranTypeRef:::::::::"+tranTypeRef);
							if(empCodePrev != null && empCodePrev.trim().length() > 0)
							{
								String empPrevSql2="SELECT COUNT(*) AS CNT FROM EMPLOYEE WHERE EMP_CODE=?";
								pstmt=conn.prepareStatement(empPrevSql2);
								pstmt.setString(1, empCodePrev);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMEMP1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMP1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else if(userLevl > 1)
								{
									String empPrevSite="SELECT EMP_SITE FROM EMPLOYEE WHERE EMP_CODE=?";
									pstmt=conn.prepareStatement(empPrevSite);
									pstmt.setString(1, empCodePrev);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										empSite=checkNull(rs.getString("EMP_SITE"));
									}
									close(pstmt, rs);
									if(!empSite.equals(loginSite))
									{
										cnt = 0;
										String empPrevSql3="SELECT COUNT(*) AS CNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE=? AND SITE_CODE__EMP_FR=?";
										pstmt=conn.prepareStatement(empPrevSql3);
										pstmt.setString(1, empCodePrev);
										pstmt.setString(2, loginSite);
										rs=pstmt.executeQuery();
										while(rs.next())
										{
											cnt=rs.getInt("CNT");
										}
										close(pstmt, rs);
										if(cnt == 0)
										{
											errList.add("VMSITEUSR");
											errFields.add(childNodeName.toLowerCase());
											msgType = errorType(conn, "VMSITEUSR"); 					
											if (msgType.equalsIgnoreCase("E"))
											{
												break;
											}
										}
										
									}
								}
								//Added by Suraj [07-MAR-2016][A15BSUN007][To make validation in case vacancy is created for separation or Affecting][Start]
								tranSerRef=checkNull(genericUtility.getColumnValue("tran_ser__ref", dom));
								System.out.println("tranSerRef:::::::::"+tranSerRef);
								if(tranSerRef.trim().equalsIgnoreCase("T-ESEP"))
								{
									cnt=0;
									String sepCount="SELECT COUNT(1) AS CNT FROM SEPARATION WHERE EMP_CODE=? AND STATUS='C'";
									pstmt=conn.prepareStatement(sepCount);
									pstmt.setString(1,empCodePrev );
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										cnt=rs.getInt("CNT");
									}
									close(pstmt, rs);
									if(cnt > 0)
									{
										
									}
									else
									{										
										errList.add("MPREQSEP01");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "MPREQSEP01"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									
									String sepVacSql="SELECT VAC_NO__CREATED FROM SEPARATION WHERE EMP_CODE=?";
									pstmt=conn.prepareStatement(sepVacSql);
									pstmt.setString(1,empCodePrev);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										vacCreated = checkNull(rs.getString("VAC_NO__CREATED"));
									}
									close(pstmt, rs);
									if(vacCreated.trim().length() > 0)
									{
										errList.add("MPREQVNC01");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "MPREQVNC01"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
								if(tranSerRef.trim().equalsIgnoreCase("F-XFR"))
								{
									tranTypeRef=checkNull(genericUtility.getColumnValue("tran_type__ref", dom));
									if(tranTypeRef.trim().equalsIgnoreCase("I"))
									{
										errList.add("MPREQAFF02");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "MPREQAFF02"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									if(tranTypeRef.trim().equalsIgnoreCase("R"))
									{
										errList.add("MPREQAFF01");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "MPREQAFF01"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									String confirmSql="SELECT CONFIRMED FROM EMP_EMPLOY_EVENTS WHERE TRAN_ID=?";
									pstmt=conn.prepareStatement(confirmSql);
									pstmt.setString(1,tranIdRef);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										confirm = checkNull(rs.getString("CONFIRMED"));
									}
									close(pstmt, rs);
									
									if(confirm.trim().equalsIgnoreCase("X"))
									{
										errList.add("MPREQAFF03");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "MPREQAFF03"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									if(confirm.trim().equalsIgnoreCase("N"))
									{
										errList.add("MPREQAFF04");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "MPREQAFF04"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									
									String sepVacSql="SELECT VAC_NO__CREATED FROM EMP_EMPLOY_EVENTS WHERE TRAN_ID=?";
									pstmt=conn.prepareStatement(sepVacSql);
									pstmt.setString(1,tranIdRef);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										vacCreated = checkNull(rs.getString("VAC_NO__CREATED"));
									}
									close(pstmt, rs);
									if(vacCreated.trim().length() > 0)
									{
										errList.add("MPREQVNC01");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "MPREQVNC01"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
								//Added by Suraj [07-MAR-2016][A15BSUN007][To make validation in case vacancy is created for separation or Affecting][End]
							}
						}
						if(childNodeName.equalsIgnoreCase("dept_code"))
						{
							deptCode=checkNull(genericUtility.getColumnValue("dept_code", dom));
							if(deptCode != null && deptCode.trim().length() > 0)
							{
								cnt=0;
								String deptCodeSql="SELECT COUNT(*) AS CNT FROM DEPARTMENT WHERE DEPT_CODE=?";
								pstmt=conn.prepareStatement(deptCodeSql);
								pstmt.setString(1, deptCode);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMDEP1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMDEP1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else
							{
								errList.add("VTDEPT1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTDEPT1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
							
						if(childNodeName.equalsIgnoreCase("site_code"))
						{
							siteCode=checkNull(genericUtility.getColumnValue("site_code", dom));
							if(siteCode != null && siteCode.trim().length() > 0)
							{
								cnt=0;
								String siteCodeSql="SELECT COUNT(*) AS CNT FROM SITE WHERE SITE_CODE=?";
								pstmt=conn.prepareStatement(siteCodeSql);
								pstmt.setString(1, siteCode);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMSITE1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMSITE1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else if(userLevl > 1)
								{
									if (!siteCode.trim().equalsIgnoreCase(loginSite))
									{
										errList.add("VMSITEUSR");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VMSITEUSR"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
							}
							else
							{
								errList.add("VMSITE1");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMSITE1"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						
						if(childNodeName.equalsIgnoreCase("design_code"))
						{
							designCode=checkNull(genericUtility.getColumnValue("design_code", dom));
							if(designCode != null && designCode.trim().length() > 0)
							{
								cnt=0;
								String desCodeSql="SELECT COUNT(*) AS CNT FROM DESIGNATION WHERE DESIGN_CODE=?";
								pstmt=conn.prepareStatement(desCodeSql);
								pstmt.setString(1, designCode);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMDESIGN");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMDESIGN"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									String designStat="";
									String desStatusSql="SELECT STATUS FROM DESIGNATION WHERE DESIGN_CODE=?";
									pstmt=conn.prepareStatement(desStatusSql);
									pstmt.setString(1, designCode);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										designStat=checkNull(rs.getString("STATUS"));
									}
									close(pstmt, rs);
									if(designStat != null && designStat.trim().equalsIgnoreCase("I"))
									{
										errList.add("VTDGINAC");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VTDGINAC"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
										
									}
								}
							}
							else
							{
								errList.add("VMDESIGN2");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMDESIGN2"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						
						if(childNodeName.equalsIgnoreCase("designation"))
						{
							designation=genericUtility.getColumnValue("designation", dom);
							if(designation == null || designation.trim().length() == 0)
							{
								errList.add("VMDESIGN2");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMDESIGN2"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("no_post"))
						{
							noPost=genericUtility.getColumnValue("no_post", dom);
							if(noPost != null && noPost.trim().length() > 0)
							{
								try
								{
									 post = Integer.parseInt(noPost);
								}
								catch(Exception e)
								{
									errList.add("VTMPREQ006");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ006"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								if(post <= 0)
								{
									errList.add("VTMPREQ006");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ006"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else
							{
								errList.add("VTMPREQ006");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTMPREQ006"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("budget_id"))
						{
							budgetId=genericUtility.getColumnValue("budget_id", dom);
							if(budgetId != null && budgetId.trim().length() > 0)
							{
								cnt=0;
								String budIdSql="SELECT COUNT(*) AS CNT FROM BUDGETS WHERE BUDGET_ID=?";
								pstmt=conn.prepareStatement(budIdSql);
								pstmt.setString(1, budgetId);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if (cnt == 0)
								{
									errList.add("VTBUD1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTBUD1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("req_date"))
						{
							reqDatestr=genericUtility.getColumnValue("req_date", dom);
							if(reqDatestr != null && reqDatestr.trim().length() > 0)
							{
								try
								{
									reqDate = sdf.parse(reqDatestr);
								}
								catch(Exception e)
								{
									errList.add("VTMPREQ007");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ007"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								vacDatestr=genericUtility.getColumnValue("vac_date", dom);
								if(vacDatestr != null && vacDatestr.trim().length() > 0)
								{
									try
									{
										vacDate = sdf.parse(vacDatestr);
									}
								
									catch(Exception e)
									{
										throw new ITMException(e);
									}
									if(reqDate.before(vacDate))
									{
										errList.add("VTREQDT2");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VTREQDT2"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
								}
								
							}
							else
							{
								errList.add("VTMPREQ007");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTMPREQ007"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("grade_code"))
						{
							gradeCode=genericUtility.getColumnValue("grade_code", dom);
							if(gradeCode != null && gradeCode.trim().length() > 0)
							{
								cnt=0;
								String greadeSql = "SELECT COUNT(*) AS CNT FROM GRADE WHERE GRADE_CODE=?";
								pstmt=conn.prepareStatement(greadeSql);
								pstmt.setString(1, gradeCode);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if (cnt == 0)
								{
									errList.add("VMGRA1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMGRA1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else
							{
								errList.add("VTMPREQ008");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTMPREQ008"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("cadre_code"))
						{
							cadreCode=genericUtility.getColumnValue("cadre_code", dom);
							if(cadreCode != null && cadreCode.trim().length() > 0)
							{
								cnt=0;
								String cadreSql = "SELECT COUNT(*) AS CNT FROM CADRE WHERE CADRE_CODE=?";
								pstmt=conn.prepareStatement(cadreSql);
								pstmt.setString(1, cadreCode);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if (cnt == 0)
								{
									errList.add("VTCADR1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTCADR1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else
							{
								errList.add("VTMPREQ009");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTMPREQ009"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("emp_code__rep"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							reportTo = genericUtility.getColumnValue("emp_code__rep", dom);							
							if(reportTo != null && reportTo.trim().length() > 0)
							{
								repToSql = "SELECT COUNT(*) AS CNT FROM EMPLOYEE WHERE EMP_CODE=?";
								pstmt=conn.prepareStatement(repToSql);
								pstmt.setString(1, reportTo);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMEMP1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMP1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									reldateSql = "SELECT RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE=?";
									pstmt=conn.prepareStatement(reldateSql);
									pstmt.setString(1, reportTo);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										relDate=rs.getString("RELIEVE_DATE");
									}
									close(pstmt, rs);
									if(relDate != null && relDate.trim().length() > 0)
									{
										errList.add("VMEMPREL");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VMEMPREL"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("report_to__admin"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							reportToadm = genericUtility.getColumnValue("report_to__admin", dom);							
							if(reportToadm != null && reportToadm.trim().length() > 0)
							{
								repToSql = "SELECT COUNT(*) AS CNT FROM EMPLOYEE WHERE EMP_CODE=?";
								pstmt=conn.prepareStatement(repToSql);
								pstmt.setString(1, reportToadm);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMEMP1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMP1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									reldateSql = "SELECT RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE=?";
									pstmt=conn.prepareStatement(reldateSql);
									pstmt.setString(1, reportTo);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										relDate=rs.getString("RELIEVE_DATE");
									}
									close(pstmt, rs);
									if(relDate != null && relDate.trim().length() > 0)
									{
										errList.add("VMEMPREL");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VMEMPREL"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("emp_code__hod"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							empcodeHod = genericUtility.getColumnValue("emp_code__hod", dom);	
							System.out.println("empcodeHod::::::::::::::"+empcodeHod);
							if(empcodeHod != null && empcodeHod.trim().length() > 0)
							{
								repToSql = "SELECT COUNT(*) AS CNT FROM EMPLOYEE WHERE EMP_CODE=?";
								pstmt=conn.prepareStatement(repToSql);
								pstmt.setString(1, empcodeHod);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMEMP1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMEMP1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								else
								{
									reldateSql = "SELECT RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE=?";
									pstmt=conn.prepareStatement(reldateSql);
									pstmt.setString(1, empcodeHod);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										relDate=rs.getString("RELIEVE_DATE");
									}
									close(pstmt, rs);
									if(relDate != null && relDate.trim().length() > 0)
									{
										errList.add("VMEMPREL");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VMEMPREL"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("qlf_code__min"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							System.out.println(" Validaion   for field qual_code__min");
							qlfCode = genericUtility.getColumnValue("qlf_code__min", dom);	
							if(qlfCode != null && qlfCode.trim().length() > 0)
							{
								cnt=0;
								qlfCodeSql = "SELECT COUNT(*) AS CNT FROM QUALIFICATION WHERE QLF_CODE=?";
								pstmt=conn.prepareStatement(qlfCodeSql);
								pstmt.setString(1, qlfCode);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMQLF1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMQLF1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else
							{
								errList.add("VTMPREQ010");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTMPREQ010"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("qlf_code__alt1"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							qlfCodealt1 = genericUtility.getColumnValue("qlf_code__alt1", dom);	
							if(qlfCodealt1 != null && qlfCodealt1.trim().length() > 0)
							{
								cnt=0;
								qlfCodeSql = "SELECT COUNT(*) AS CNT FROM QUALIFICATION WHERE QLF_CODE=?";
								pstmt=conn.prepareStatement(qlfCodeSql);
								pstmt.setString(1, qlfCodealt1);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMQLF1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMQLF1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("qlf_code__alt2"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							qlfCodealt2 = genericUtility.getColumnValue("qlf_code__alt2", dom);	
							if(qlfCodealt2 != null && qlfCodealt2.trim().length() > 0)
							{
								cnt=0;
								qlfCodeSql = "SELECT COUNT(*) AS CNT FROM QUALIFICATION WHERE QLF_CODE=?";
								pstmt=conn.prepareStatement(qlfCodeSql);
								pstmt.setString(1, qlfCodealt2);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMQLF1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMQLF1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("qlf_code__alt3"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							qlfCodealt3 = genericUtility.getColumnValue("qlf_code__alt3", dom);	
							if(qlfCodealt3 != null && qlfCodealt3.trim().length() > 0)
							{
								cnt=0;
								qlfCodeSql = "SELECT COUNT(*) AS CNT FROM QUALIFICATION WHERE QLF_CODE=?";
								pstmt=conn.prepareStatement(qlfCodeSql);
								pstmt.setString(1, qlfCodealt3);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMQLF1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMQLF1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("qlf_code__alt4"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							qlfCodealt4 = genericUtility.getColumnValue("qlf_code__alt4", dom);	
							if(qlfCodealt4 != null && qlfCodealt4.trim().length() > 0)
							{
								cnt=0;
								qlfCodeSql = "SELECT COUNT(*) AS CNT FROM QUALIFICATION WHERE QLF_CODE=?";
								pstmt=conn.prepareStatement(qlfCodeSql);
								pstmt.setString(1, qlfCodealt4);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMQLF1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMQLF1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("qlf_code__alt5"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							qlfCodealt5 = genericUtility.getColumnValue("qlf_code__alt5", dom);	
							if(qlfCodealt5 != null && qlfCodealt5.trim().length() > 0)
							{
								cnt=0;
								qlfCodeSql = "SELECT COUNT(*) AS CNT FROM QUALIFICATION WHERE QLF_CODE=?";
								pstmt=conn.prepareStatement(qlfCodeSql);
								pstmt.setString(1, qlfCodealt5);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									cnt=rs.getInt("CNT");
								}
								close(pstmt, rs);
								if(cnt == 0)
								{
									errList.add("VMQLF1");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VMQLF1"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						
						if(childNodeName.equalsIgnoreCase("age_min"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							frmAge = genericUtility.getColumnValue("age_min", dom);	
							if(frmAge != null && frmAge.trim().length() > 0)
							{
								try
								{
									minAge = Integer.parseInt(frmAge);
								}							
								catch(Exception e)
								{
									errList.add("VTMPREQ011");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ011"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								if(minAge <= 0)
								{
									errList.add("VTMPREQ011");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ011"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else
							{
								errList.add("VTMPREQ011");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTMPREQ011"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("age_max"))
						{
							System.out.println(" Validaion   for field "+childNodeName);
							frmAge = genericUtility.getColumnValue("age_min", dom);
							System.out.println("age min:::::::::::"+frmAge);
							toAge = genericUtility.getColumnValue("age_max", dom);	
							System.out.println("age max:::::::::::"+toAge);
							int maxAge=0;
							if(toAge != null && toAge.trim().length() > 0)
							{
								try
								{
									maxAge = Integer.parseInt(toAge);
								}
								catch(Exception e)
								{
									errList.add("VTMPREQ012");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ012"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								if(maxAge <= 0)
								{
									errList.add("VTMPREQ012");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ012"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								if(frmAge != null && frmAge.trim().length() > 0)
								{
									try
									{
										minAge = Integer.parseInt(frmAge);									
									}
									catch(Exception e)
									{
										throw new ITMException(e);
									}
									if (maxAge <= minAge)
									{
										errList.add("VTMPREQ013");
										errFields.add(childNodeName.toLowerCase());
										msgType = errorType(conn, "VTMPREQ013"); 					
										if (msgType.equalsIgnoreCase("E"))
										{
											break;
										}
									}
									
								}
								else
								{
									errList.add("VTMPREQ012");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ012"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
							else
							{
								errList.add("VTMPREQ012");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VTMPREQ012"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("pass_perc"))
						{
							passPerc = genericUtility.getColumnValue("pass_perc", dom);	
							if(passPerc != null && passPerc.trim().length() > 0)
							{
								try
								{
									percnt = Float.parseFloat(passPerc);
								}
								catch(Exception e)
								{
									errList.add("VTMPREQ014");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ014"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								if(percnt <= 0)
								{
									errList.add("VTMPREQ014");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ014"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("min_exp"))
						{
							experience = genericUtility.getColumnValue("min_exp", dom);	
							if(experience != null && experience.trim().length() > 0)
							{
								try
								{
									minExp = Integer.parseInt(experience);
								}
								catch(Exception e)
								{
									errList.add("VTMPREQ015");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ015"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								if(minExp <= 0)
								{
									errList.add("VTMPREQ015");
									errFields.add(childNodeName.toLowerCase());
									msgType = errorType(conn, "VTMPREQ015"); 					
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}
						}
					}
					break;
				}
				case 2:
				{
					parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
				    childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{	
						
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNode.getFirstChild()!= null)
						{
							childNodeValue = childNode.getFirstChild().getNodeValue();
						}
						if(childNodeName.equalsIgnoreCase("candidate_name"))
						{
							String canName = genericUtility.getColumnValue("candidate_name", dom);	
							if(canName == null || canName.trim().length() == 0)
							{
								errList.add("VMCNDNAME");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMCNDNAME"); 					
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
						}
					}
					break;
				}
			}
			int errListSize = errList.size();
			System.out.println("errListSize:::::::["+errListSize+"]");
			if ( errList != null && errListSize > 0 )
			{
				System.out.println("in error::::::::::");
				for (int i = 0; i < errListSize; i++ )
				{
					System.out.println("in error For:::::::::::::::"); 
					errCode = (String)errList.get(i);
					errFldName = (String)errFields.get(i);
					System.out.println("errCode .........."+errCode);					
					errString = getErrorString( errFldName, errCode, "" );
					System.out.println("errString is : ::::>>>> " + errString);
					msgType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( msgType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex); 
		}
		finally 
		{
			try {
				
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
					if (conn != null)
					{
						conn.close();
						conn = null;
					}

			} 
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("ErrString ::"+errString);
		return errString;
}
	
	
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}
	
	
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("MPrequirement:itemChanged value of xmlString ["+xmlString+"]");
			System.out.println("MPrequirement:itemChanged value of xmlString ["+xmlString1+"]");
			System.out.println("MPrequirement:itemChanged value of xmlString ["+xmlString2+"]");
			System.out.println("objContext ..:: ["+objContext+"]");
			System.out.println("currentColumn ..:: ["+currentColumn+"]");
			System.out.println("editFlag ..:: ["+editFlag+"]");

			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception : MPrequirement:itemChanged :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from MPrequirement:itemChanged");
		return errString;
	 }

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = null;
		String childNodeName = null,childNodeValue = null,columnValue="";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int currentFormNo =0;
		StringBuffer valueXmlString =null;
		String newVac = "",deptCode="",deptDescr="",siteCode="",siteDescr="",cadreCode="",gradeCode="",cadreDescr="",gradeDescr="",locCity="";
		String hodFname="",lname="",fname="",qlfCode="",qualDescr="",empCodeRep="",designCode="",reportTo="",designDescr="";
		String repFname="",repLname="",empCodeHOD="",hodLname="",hodMname="" ,lineNo="",vacNo="",passPerc="",empSite="",chgDateStr="",noPost="";
		String logCode="",empCodePrev="",reasCodeVac="",tranSerRef="",vacCreated="",tranTypeRef="",confirm="";
		String perc="",tranIdRef="";
		int userLevl = 0;
		float percnum =0;
		java.util.Date resiDate = new java.util.Date();	
		GenericUtility genericUtility = GenericUtility.getInstance();
		int ctr=0,childNodeListLength =0,cnt =0;
		try
		{
			System.out.println("CURRENT COLUMN:::::"+currentColumn);	
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());			
			java.util.Date currDate = new java.util.Date();		
			chgDateStr = sdf.format(currDate);	
			String objNameDefault = checkNull(getObjName(dom ,objContext));
			logCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "logincode");
			if (objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");		
							
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch (currentFormNo)
			{
				case 1:	
				{
					valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='"+objNameDefault+"' selected='Y'>\r\n");
					if(currentColumn.equalsIgnoreCase("itm_defaultedit"))
					{
						newVac = genericUtility.getColumnValue("new_vacancy", dom);	
						noPost = genericUtility.getColumnValue("no_post", dom);	
						empCodePrev = genericUtility.getColumnValue("emp_code__prev", dom);	
						reasCodeVac = genericUtility.getColumnValue("reas_code_vac", dom);	
						if((newVac != null && newVac.trim().length() > 0) && newVac.equalsIgnoreCase("Y"))
						{
							valueXmlString.append("<no_post protect=\"0\"><![CDATA["+noPost+"]]></no_post>\r\n");
							valueXmlString.append("<emp_code__prev protect=\"1\"><![CDATA[]]></emp_code__prev>\r\n");
							valueXmlString.append("<reas_code_vac protect=\"1\"><![CDATA[]]></reas_code_vac>\r\n");
						}
						else
						{
							System.out.println("ITMDEFAULT EDIT DETAIL1::::::::::");
							valueXmlString.append("<no_post protect=\"1\"><![CDATA["+noPost+"]]></no_post>\r\n");
							valueXmlString.append("<emp_code__prev protect=\"0\"><![CDATA["+empCodePrev+"]]></emp_code__prev>\r\n");
							valueXmlString.append("<reas_code_vac protect=\"0\"><![CDATA["+reasCodeVac+"]]></reas_code_vac>\r\n");
						}
					}
					if(currentColumn.equalsIgnoreCase("itm_default"))
					{
						//String empCodePrev = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "emp_code");
						//Added by Suraj [08-MAR-2016][A15BSUN007][START]
						empCodePrev = genericUtility.getColumnValue("emp_code__prev", dom);
						tranSerRef=checkNull(genericUtility.getColumnValue("tran_ser__ref", dom));
						tranIdRef=checkNull(genericUtility.getColumnValue("tran_id__ref", dom));
						tranTypeRef=checkNull(genericUtility.getColumnValue("tran_type__ref", dom));						
						//Added by Suraj [08-MAR-2016][A15BSUN007][END]
						if(empCodePrev != null && empCodePrev.trim().length() > 0)
						{
							
							valueXmlString.append("<new_vacancy>").append("<![CDATA[N]]>").append("</new_vacancy>\r\n");
							valueXmlString.append("<emp_code__prev protect=\"1\"><![CDATA["+empCodePrev+"]]></emp_code__prev>\r\n");
							valueXmlString.append("<reas_code_vac protect=\"0\"><![CDATA[]]></reas_code_vac>\r\n");
							valueXmlString.append("<no_post protect=\"1\"><![CDATA[1]]></no_post>\r\n");
							//Added by Suraj [08-MAR-2016][To Make entire window non-editable][A15BSUN007][START]
							if(tranSerRef != null && tranSerRef.trim().length() > 0)
							{
								if(tranSerRef.trim().equalsIgnoreCase("T-ESEP"))
								{
									cnt=0;
									String sepCount="SELECT COUNT(1) AS CNT FROM SEPARATION WHERE EMP_CODE=? AND STATUS='C'";
									pstmt=conn.prepareStatement(sepCount);
									pstmt.setString(1,empCodePrev );
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										cnt=rs.getInt("CNT");
									}
									close(pstmt, rs);
									if(cnt == 0)
									{
										valueXmlString.append(previousEmp(dom, xtraParams, empCodePrev, conn,"Y"));
									}								
									
									String sepVacSql="SELECT VAC_NO__CREATED FROM SEPARATION WHERE EMP_CODE=?";
									pstmt=conn.prepareStatement(sepVacSql);
									pstmt.setString(1,empCodePrev);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										vacCreated = checkNull(rs.getString("VAC_NO__CREATED"));
									}
									close(pstmt, rs);
									if(vacCreated.trim().length() > 0)
									{
										valueXmlString.append(previousEmp(dom, xtraParams, empCodePrev, conn,"Y"));								
									}
								}
								if(tranSerRef.trim().equalsIgnoreCase("F-XFR"))
								{
									tranTypeRef=checkNull(genericUtility.getColumnValue("tran_type__ref", dom));
									if(tranTypeRef.trim().equalsIgnoreCase("I"))
									{
										valueXmlString.append(previousEmp(dom, xtraParams, empCodePrev, conn,"Y"));
									}
									if(tranTypeRef.trim().equalsIgnoreCase("R"))
									{
										valueXmlString.append(previousEmp(dom, xtraParams, empCodePrev, conn,"Y"));
									}
									String confirmSql="SELECT CONFIRMED FROM EMP_EMPLOY_EVENTS WHERE TRAN_ID=?";
									pstmt=conn.prepareStatement(confirmSql);
									pstmt.setString(1,tranIdRef);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										
										confirm = rs.getString("CONFIRMED");
									}
									close(pstmt, rs);
									
									if(confirm.trim().equalsIgnoreCase("X"))										
									{
										valueXmlString.append(previousEmp(dom, xtraParams, empCodePrev, conn,"Y"));
									}
									if(confirm.trim().equalsIgnoreCase("N"))
									{
										valueXmlString.append(previousEmp(dom, xtraParams, empCodePrev, conn,"Y"));
									}
									
									String sepVacSql="SELECT VAC_NO__CREATED FROM EMP_EMPLOY_EVENTS WHERE TRAN_ID=?";
									pstmt=conn.prepareStatement(sepVacSql);
									pstmt.setString(1,tranIdRef);
									rs=pstmt.executeQuery();
									while(rs.next())
									{
										vacCreated = checkNull(rs.getString("VAC_NO__CREATED"));
									}
									close(pstmt, rs);
									if(vacCreated.trim().length() > 0)
									{
										valueXmlString.append(previousEmp(dom, xtraParams, empCodePrev, conn,"Y"));
									}
								}
							}
							else
							{
								valueXmlString.append(previousEmp(dom, xtraParams, empCodePrev, conn,""));
							}
								
							//Added by Suraj [08-MAR-2016][To Make entire window non-editable][A15BSUN007][End]
						}
						else
						{
							valueXmlString.append("<new_vacancy>").append("<![CDATA[Y]]>").append("</new_vacancy>\r\n");
							valueXmlString.append("<emp_code__prev protect=\"1\"><![CDATA[]]></emp_code__prev>\r\n");
							valueXmlString.append("<reas_code_vac protect=\"0\"><![CDATA[]]></reas_code_vac>\r\n");
							valueXmlString.append("<no_post protect=\"0\"><![CDATA[1]]></no_post>\r\n");
							empSite = genericUtility.getColumnValue("site_code",dom);
							String locSql = "SELECT CITY FROM SITE WHERE SITE_CODE=?";
							pstmt=conn.prepareStatement(locSql);
							pstmt.setString(1,empSite);
							rs=pstmt.executeQuery();
							while(rs.next())
							{
								locCity=rs.getString("CITY");
							}
							close(pstmt, rs);
							valueXmlString.append("<location>").append("<![CDATA["+locCity+"]]>").append("</location>\r\n");
						}
						
						//passPerc = getEnv("999999" , "MPREQ_PASS_PERC",conn);		
						AdmCommon admCommon  =  new AdmCommon();
						passPerc = admCommon.getEnv("999999","MPREQ_PASS_PERC", conn);
								
						if((passPerc != null && passPerc.trim().length() > 0) && !passPerc.trim().equals("NULLFOUND"))
						{
							try
							{
								percnum = Float.parseFloat(passPerc);
							}
							catch(Exception e)
							{
								throw new ITMException(e);
							}
							try
							{
								DecimalFormat decf = new DecimalFormat("##.00");// to convert number in '00.00' format
								perc=decf.format(percnum);
							}
							catch(Exception e)
							{
								throw new ITMException(e);
							}
							System.out.println("percentage:::::::::::::::" +perc );
							valueXmlString.append("<pass_perc>").append("<![CDATA["+ perc +"]]>").append("</pass_perc>\r\n");
						}
						else
						{
							valueXmlString.append("<pass_perc>").append("<![CDATA[]]>").append("</pass_perc>\r\n");
						}
						
						valueXmlString.append("<vac_date>").append("<![CDATA["+chgDateStr+"]]>").append("</vac_date>\r\n");
						valueXmlString.append("<req_date>").append("<![CDATA["+chgDateStr+"]]>").append("</req_date>\r\n");
					}
					if(currentColumn.equalsIgnoreCase("emp_code__prev"))
					{
						empCodePrev = genericUtility.getColumnValue("emp_code__prev",dom);
						tranSerRef = genericUtility.getColumnValue("tran_ser__ref",dom);						
						if(empCodePrev != null && empCodePrev.trim().length() > 0)
							{
								System.out.println("empcode in if statement::::");
								valueXmlString.append(previousEmp(dom, xtraParams, empCodePrev, conn,""));
								System.out.println("AFTER empcode in if statement::::");
							}
							else
							{
								System.out.println("empcode in else statement::::");
								valueXmlString.append(previousEmp(dom, xtraParams,"*", conn,""));
							}
						
						
											
					}
					if(currentColumn.equalsIgnoreCase("dept_code"))
					{
						deptCode = genericUtility.getColumnValue("dept_code", dom);
						String deptCodeSql = "SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE=?";
						pstmt=conn.prepareStatement(deptCodeSql);
						pstmt.setString(1, deptCode);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							deptDescr=rs.getString("DESCR");
						}
						close(pstmt, rs);
						valueXmlString.append("<department_descr>").append("<![CDATA["+deptDescr+"]]>").append("</department_descr>\r\n");
					}
					if(currentColumn.equalsIgnoreCase("site_code"))
					{
						siteCode = genericUtility.getColumnValue("site_code", dom);
						newVac = genericUtility.getColumnValue("new_vacancy", dom);
						String siteCodeSql = "SELECT DESCR FROM SITE WHERE SITE_CODE=?";
						pstmt=conn.prepareStatement(siteCodeSql);
						pstmt.setString(1,  siteCode);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							siteDescr=rs.getString("DESCR");
						}
						close(pstmt, rs);
						valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr>\r\n");
						if((newVac != null && newVac.trim().length() > 0) && newVac.trim().equalsIgnoreCase("Y"))
						{
							String locCitySql = "SELECT CITY FROM SITE WHERE SITE_CODE=?";
							pstmt=conn.prepareStatement(locCitySql);
							pstmt.setString(1,siteCode);
							rs=pstmt.executeQuery();
							while(rs.next())
							{
								locCity=rs.getString("CITY");
							}
							close(pstmt, rs);
							
							valueXmlString.append("<location>").append("<![CDATA["+locCity+"]]>").append("</location>\r\n");
						}
					}
					if(currentColumn.equalsIgnoreCase("grade_code"))
					{
						gradeCode = genericUtility.getColumnValue("grade_code", dom);
						String gradeCodeSql = "SELECT DESCR,CADRE_CODE FROM GRADE WHERE GRADE_CODE=?";
						pstmt=conn.prepareStatement(gradeCodeSql);
						pstmt.setString(1,  gradeCode);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							gradeDescr=rs.getString("DESCR");
							cadreCode=rs.getString("CADRE_CODE");
						}
						close(pstmt, rs);
						String cadreCodeSql = "SELECT DESCR FROM CADRE WHERE CADRE_CODE=?";
						pstmt=conn.prepareStatement(cadreCodeSql);
						pstmt.setString(1,  cadreCode);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							cadreDescr=rs.getString("DESCR");
							
						}
						close(pstmt, rs);
						valueXmlString.append("<cadre_code>").append("<![CDATA["+cadreCode+"]]>").append("</cadre_code>\r\n");
						valueXmlString.append("<grade_descr>").append("<![CDATA["+gradeDescr+"]]>").append("</grade_descr>\r\n");
						valueXmlString.append("<cadre_descr>").append("<![CDATA["+cadreDescr+"]]>").append("</cadre_descr>\r\n");
					}
					if(currentColumn.equalsIgnoreCase("cadre_code"))
					{
						cadreCode = genericUtility.getColumnValue("cadre_code", dom);
						String cadreCodeSql = "SELECT DESCR FROM CADRE WHERE CADRE_CODE=?";
						pstmt=conn.prepareStatement(cadreCodeSql);
						pstmt.setString(1,  cadreCode);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							cadreDescr=rs.getString("DESCR");							
						}
						close(pstmt, rs);
						valueXmlString.append("<cadre_descr>").append("<![CDATA["+cadreDescr+"]]>").append("</cadre_descr>\r\n");
					}
					if(currentColumn.equalsIgnoreCase("qlf_code__min"))
					{
						qlfCode = genericUtility.getColumnValue("qlf_code__min", dom);
						String qualCodeSql = "SELECT DESCR FROM QUALIFICATION WHERE QLF_CODE=?";
						pstmt=conn.prepareStatement(qualCodeSql);
						pstmt.setString(1,  qlfCode);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							qualDescr=rs.getString("DESCR");
							
						}
						close(pstmt, rs);
						valueXmlString.append("<qualification_descr>").append("<![CDATA["+qualDescr+"]]>").append("</qualification_descr>\r\n");
					}
					if(currentColumn.equalsIgnoreCase("emp_code__rep"))
					{
						empCodeRep = genericUtility.getColumnValue("emp_code__rep", dom);
						String empCodeSql = "SELECT EMP_FNAME,EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE=?";
						pstmt=conn.prepareStatement(empCodeSql);
						pstmt.setString(1,  empCodeRep);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							fname=rs.getString("EMP_FNAME");							
							lname=rs.getString("EMP_LNAME");
						}
						valueXmlString.append("<emp_fname__rep>").append("<![CDATA["+fname+"]]>").append("</emp_fname__rep>\r\n");
						valueXmlString.append("<emp_lname__rep>").append("<![CDATA["+lname+"]]>").append("</emp_lname__rep>\r\n");
					}
					if(currentColumn.equalsIgnoreCase("design_code"))
					{
						designCode = genericUtility.getColumnValue("design_code", dom);
						String designCodeSql = "SELECT DESIGNATION FROM DESIGNATION WHERE DESIGN_CODE=?";
						pstmt=conn.prepareStatement(designCodeSql);
						pstmt.setString(1, designCode);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							designDescr=rs.getString("DESIGNATION");
						}
						close(pstmt, rs);
						valueXmlString.append("<designation>").append("<![CDATA["+designDescr+"]]>").append("</designation>\r\n");
					}
					if(currentColumn.equalsIgnoreCase("report_to__admin"))
					{
						reportTo = genericUtility.getColumnValue("report_to__admin", dom);
						String reportToSql = "SELECT EMP_FNAME,EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE=?";
						pstmt=conn.prepareStatement(reportToSql);
						pstmt.setString(1,  reportTo);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							repFname=rs.getString("EMP_FNAME");							
							repLname=rs.getString("EMP_LNAME");
						}
						valueXmlString.append("<emp_fname__reportadmin>").append("<![CDATA["+repFname+"]]>").append("</emp_fname__reportadmin>\r\n");
						valueXmlString.append("<emp_lname__reportadmin>").append("<![CDATA["+repLname+"]]>").append("</emp_lname__reportadmin>\r\n");
					}
					if(currentColumn.equalsIgnoreCase("emp_code__hod"))
					{
						empCodeHOD = genericUtility.getColumnValue("emp_code__hod", dom);
						String empCodeHODSql = "SELECT EMP_FNAME,EMP_MNAME,EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE=?";
						pstmt=conn.prepareStatement(empCodeHODSql);
						pstmt.setString(1,  empCodeHOD);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							hodFname=rs.getString("EMP_FNAME");	
							hodMname=rs.getString("EMP_MNAME");
							hodLname=rs.getString("EMP_LNAME");
						}
						valueXmlString.append("<employee_emp_fname>").append("<![CDATA["+hodFname+"]]>").append("</employee_emp_fname>\r\n");
						valueXmlString.append("<employee_emp_mname>").append("<![CDATA["+hodMname+"]]>").append("</employee_emp_mname>\r\n");
						valueXmlString.append("<employee_emp_lname>").append("<![CDATA["+hodLname+"]]>").append("</employee_emp_lname>\r\n");
					}
					if(currentColumn.equalsIgnoreCase("new_vacancy"))
					{
						newVac = genericUtility.getColumnValue("new_vacancy", dom);
						if((newVac != null && newVac.trim().length() > 0) && newVac.trim().equalsIgnoreCase("N"))
						{
							valueXmlString.append("<emp_code__prev protect=\"0\"><![CDATA[]]></emp_code__prev>\r\n");
							valueXmlString.append("<reas_code_vac protect=\"0\"><![CDATA[]]></reas_code_vac>\r\n");
							valueXmlString.append("<no_post protect=\"1\"><![CDATA[1]]></no_post>\r\n");
							
						}
						else
						{
							
							userLevl = userLev(logCode, conn);
							if(userLevl > 1)
							{
								previousEmp(dom2, xtraParams, "*", conn,"");
								empSite = genericUtility.getColumnValue("site_code", dom);
								String locCitySql = "SELECT CITY FROM SITE WHERE SITE_CODE=?";
								pstmt=conn.prepareStatement(locCitySql);
								pstmt.setString(1,siteCode);
								rs=pstmt.executeQuery();
								while(rs.next())
								{
									locCity=rs.getString("CITY");
								}
								close(pstmt, rs);
								valueXmlString.append("<location>").append("<![CDATA["+locCity+"]]>").append("</location>\r\n");
							}
							
							valueXmlString.append("<emp_code__prev protect=\"1\"><![CDATA[]]></emp_code__prev>\r\n");
							valueXmlString.append("<reas_code_vac protect=\"1\"><![CDATA[]]></reas_code_vac>\r\n");
							valueXmlString.append("<no_post protect=\"0\"><![CDATA[1]]></no_post>\r\n");
							valueXmlString.append("<emp_fname__prev>").append("<![CDATA[]]>").append("</emp_fname__prev>\r\n");
							valueXmlString.append("<emp_lname__prev>").append("<![CDATA[]]>").append("</emp_lname__prev>\r\n");
							
						}
					}
					valueXmlString.append ("</Detail1>\r\n");	
				}				
				break;
				
			case 2:	
			{
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				childNodeListLength = childNodeList.getLength();
				
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
				valueXmlString.append("<Detail2>\r\n");		
				if(childNodeName.equalsIgnoreCase("itm_default"))
				{
					lineNo = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "line_no");
					if(lineNo.trim().length() > 0)
					{
						valueXmlString.append("<line_no>").append("<![CDATA["+lineNo+"]]>").append("</line_no>\r\n");
					}
					vacNo = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "vac_no");
					valueXmlString.append("<vac_no>").append("<![CDATA["+vacNo+"]]>").append("</vac_no>\r\n");
				}
				
				valueXmlString.append ("</Detail2>\r\n");	
			}
			break;
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{     
			try
			{
				close(pstmt, rs);
				if(conn != null)
				{
					conn.close();
					conn = null;
				}	
	        }
			catch(Exception e)
			{
				System.out.println(e.getMessage());
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("MPR :itemChanged(Document,String):return valueXmlString"+valueXmlString);
		return valueXmlString.toString();
	}
	
	// Added by Suraj [07-MAR-2016][A15BSUN007][To add post save method][Start]
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String tranId,String editFlag, String xtraParams, Connection conn,  String domString,String ObjContext) throws RemoteException,ITMException
	{
		String errString = "",tranSerRef="",tranIdRef="",empCode="";
		GenericUtility genericUtility = new GenericUtility();
		Document dom = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int cnt=0;
		try
		{
			dom = genericUtility.parseString(domString);		
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		try
		{
			tranId = checkNull(genericUtility.getColumnValue("vac_no",dom));
			System.out.println("POST SAVE TRAN ID::::::"+tranId);
			tranSerRef = checkNull(genericUtility.getColumnValue("tran_ser__ref",dom));
			tranIdRef = checkNull(genericUtility.getColumnValue("tran_id__ref",dom));
			empCode = checkNull(genericUtility.getColumnValue("emp_code__prev",dom));
			if(tranSerRef.trim().equals("F-XFR"))
			{
				cnt = 0;
				String updateSql = "UPDATE EMP_EMPLOY_EVENTS SET VAC_NO__CREATED = ? WHERE TRAN_ID=?";
				pstmt=conn.prepareStatement(updateSql);
				pstmt.setString(1,tranId);
				pstmt.setString(2,tranIdRef);
				cnt = pstmt.executeUpdate();
				close(pstmt, rs);
				System.out.println("UPDATE COUNT FOR EMPLOYEE AFFECTING IS:::"+cnt);
			}
			if(tranSerRef.trim().equals("T-ESEP"))
			{
				cnt = 0;
				String updateSql = "UPDATE SEPARATION SET VAC_NO__CREATED = ? WHERE EMP_CODE=?";
				pstmt=conn.prepareStatement(updateSql);
				pstmt.setString(1,empCode);
				cnt = pstmt.executeUpdate();
				close(pstmt, rs);
				System.out.println("UPDATE COUNT FOR EMPLOYEE SEPARATION IS:::"+cnt);
			}
		}
		catch(Exception e)
		{
			try
			{
				System.out.println("Inside Catch-try of post save");
				conn.rollback();
				e.printStackTrace();
				throw new ITMException(e);
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
				throw new ITMException(ex);
			}
		}
		finally
		{
			try
			{
				close(pstmt, rs);
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);				
			}
		}
		return errString;	
	}
	// Added by Suraj [07-MAR-2016][A15BSUN007][To add post save method][End]
	private StringBuffer previousEmp(Document dom,String xtraParams,String empCodePrev,Connection conn,String flag)
	{
		String refWin="",refWinId="",fname="",lname="",deptCode="",empSite="",designCode="",grade="",cadre="",loginSiteCode="";
		String report="",reportAdm="",stanCode="",empHod="",tranType="",transerRef="",tranIdRef="",loginSite="",logCode="";
		String designation = "",deptDescr= "" ,locDescr= "",siteDescr="",gradeDescr="",cadreDescr="",fNameAdm="",lNameAdm="";
		String fNameRep="",fNameHOD="",mNameHOD = "",lNameRep = "",lNameHOD = "";
		int userLevl=0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		GenericUtility genericUtility = new GenericUtility();
		StringBuffer valueXmlString = new StringBuffer();
		
		try
		{
			//empCodePrev = genericUtility.getColumnValue("emp_code__prev", dom);
			logCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "logincode");
			loginSiteCode = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			empSite = checkNull(genericUtility.getColumnValue("site_code", dom));
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			java.util.Date currDate = new java.util.Date();	
			String chgDateStr = sdf.format(currDate);
			userLevl = userLev(logCode, conn);
			if(userLevl > 1)
			{
				loginSite = "loginSite"+"%";
			}
			else
			{
				loginSite = "%";
			}
			String empCodePrvSql = "SELECT EMP_FNAME,EMP_LNAME,DEPT_CODE,EMP_SITE,DESIGN_CODE,GRADE,"
					+ "CADRE,REPORT_TO,REPORT_TO__ADMIN,STAN_CODE__HQ,EMP_CODE__HOD FROM EMPLOYEE WHERE EMP_CODE=? AND EMP_SITE = ?";
			pstmt=conn.prepareStatement(empCodePrvSql);
			pstmt.setString(1,  empCodePrev);
			pstmt.setString(2,  loginSiteCode);
			rs=pstmt.executeQuery();
			while(rs.next())
			{
				fname=checkNull(rs.getString("EMP_FNAME"));				
				lname=checkNull(rs.getString("EMP_LNAME"));
				deptCode=checkNull(rs.getString("DEPT_CODE"));
				empSite=checkNull(rs.getString("EMP_SITE"));
				designCode=checkNull(rs.getString("DESIGN_CODE"));
				grade=checkNull(rs.getString("GRADE"));
				cadre=checkNull(rs.getString("CADRE"));
				report=checkNull(rs.getString("REPORT_TO"));
				reportAdm=checkNull(rs.getString("REPORT_TO__ADMIN"));
				stanCode=checkNull(rs.getString("STAN_CODE__HQ"));
				empHod=checkNull(rs.getString("EMP_CODE__HOD"));
			}
			close(pstmt, rs);
			transerRef = genericUtility.getColumnValue("tran_ser__ref",dom);
			System.out.println("transerRef:::::"+transerRef);
			refWinId = genericUtility.getColumnValue("tran_id__ref",dom);
			System.out.println("refWinId:::::"+refWinId);
			tranType = genericUtility.getColumnValue("tran_type__ref",dom);
			System.out.println("tranType:::::"+tranType);
			if ((transerRef != null && transerRef.trim().length() > 0 ) && transerRef.trim().equalsIgnoreCase("F-XFR"))
			{
				if(tranType.trim().equals("T") || tranType.trim().equals("D") || tranType.trim().equals("S"))
				{
					refWin="w_transfer";
				}
				else if(tranType.trim().equals("P") || tranType.trim().equals("E"))
				{
					refWin="w_promotion";
				}
				else if(tranType.trim().equals("O") )
				{
					refWin="w_dummy";
				}
			}
			if ((transerRef != null && transerRef.trim().length() > 0 ) && transerRef.trim().equalsIgnoreCase("T-ESEP"))
			{
				refWin="w_emp_separation";
			}
			if(refWin != null && refWin.trim().length() > 0)
			{
				if(refWin.trim().equals("w_transfer") || refWin.trim().equals("w_promotion") || refWin.trim().equals("w_dummy"))
				{
					if(refWinId != null && refWinId.trim().length() > 0)
					{
						String empCodePrvSql2 = "SELECT b.EMP_FNAME,b.EMP_LNAME,a.DEPT_CODE__FR,a.SITE_CODE__EMP_FR,"
								+ "a.DESIGN_CODE__FR,a.GRADE_CODE_FR,a.CADRE_CODE_FR,a.STAN_CODE__HQ_FR,"
								+ "a.EMP_CODE__REPTO_FR,a.EMP_CODE__REPADMFR,b.EMP_CODE__HOD FROM EMP_EMPLOY_EVENTS a,"
								+ "EMPLOYEE b WHERE a.TRAN_ID=? AND a.EMP_CODE=? AND a.EMP_CODE = b.EMP_CODE "
								+ "AND a.SITE_CODE__EMP_FR LIKE (?) AND a.CONFIRMED='Y'";
						pstmt=conn.prepareStatement(empCodePrvSql2);						
						pstmt.setString(1,  refWinId);
						pstmt.setString(2,  empCodePrev);
						pstmt.setString(3,  empSite);
						
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							fname=checkNull(rs.getString("EMP_FNAME"));				
							lname=checkNull(rs.getString("EMP_LNAME"));
							deptCode=checkNull(rs.getString("DEPT_CODE__FR"));
							empSite=checkNull(rs.getString("SITE_CODE__EMP_FR"));
							designCode=checkNull(rs.getString("DESIGN_CODE__FR"));
							grade=checkNull(rs.getString("GRADE_CODE__FR"));
							cadre=checkNull(rs.getString("CADRE_CODE__FR"));
							report=checkNull(rs.getString("EMP_CODE__REPORT_FR"));
							reportAdm=checkNull(rs.getString("REPORT_TO__ADMIN"));
							stanCode=checkNull(rs.getString("EMP_CODE__REPADMFR"));
							empHod=checkNull(rs.getString("EMP_CODE__HOD"));
						}
						close(pstmt, rs);
					}
				}
			}
			valueXmlString.append("<no_post><![CDATA[1]]></no_post>\r\n");	
			valueXmlString.append("<dept_code><![CDATA["+deptCode+"]]></dept_code>\r\n");	
			valueXmlString.append("<design_code><![CDATA["+designCode+"]]></design_code>\r\n");	
			valueXmlString.append("<grade_code><![CDATA["+grade+"]]></grade_code>\r\n");	
			valueXmlString.append("<cadre_code><![CDATA["+cadre+"]]></cadre_code>\r\n");
			valueXmlString.append("<emp_code__rep><![CDATA["+report+"]]></emp_code__rep>\r\n");
			valueXmlString.append("<report_to__admin><![CDATA["+reportAdm+"]]></report_to__admin>\r\n");
			valueXmlString.append("<emp_code__hod><![CDATA["+empHod+"]]></emp_code__hod>\r\n");
			if(stanCode != null && stanCode.trim().length() > 0)
			{
				String empCodeStanSql = "SELECT DESCR FROM STATION WHERE STAN_CODE=?";
				pstmt=conn.prepareStatement(empCodeStanSql);
				pstmt.setString(1,  stanCode);				
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					locDescr= checkNull(rs.getString("DESCR"));					
				}
				close(pstmt, rs);
				valueXmlString.append("<location><![CDATA[").append(locDescr).append("]]></location>\r\n");
				
			}
			else
			{
				String empCodeCitySql = "SELECT CITY FROM SITE WHERE SITE_CODE=?";
				pstmt=conn.prepareStatement(empCodeCitySql);
				pstmt.setString(1,  empSite);				
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					locDescr= checkNull(rs.getString("CITY"));						
				}
				close(pstmt, rs);				
				valueXmlString.append("<location><![CDATA[").append(locDescr).append("]]></location>\r\n");
				
			}
			
			if(empSite != null && empSite.trim().length() > 0)
			{
				String empCodeSiteSql = "SELECT DESCR FROM SITE WHERE SITE_CODE=?";
				pstmt=conn.prepareStatement(empCodeSiteSql);
				pstmt.setString(1,  empSite);				
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					siteDescr = checkNull(rs.getString("DESCR"));
				}
				close(pstmt, rs);
			}
			valueXmlString.append("<site_code><![CDATA["+empSite+"]]></site_code>\r\n");
			valueXmlString.append("<site_descr><![CDATA["+siteDescr+"]]></site_descr>\r\n");			
			
			if(reportAdm != null && reportAdm.trim().length() > 0)
			{
				String empCodeNameSql = "SELECT EMP_FNAME,EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE=?";
				pstmt=conn.prepareStatement(empCodeNameSql);
				pstmt.setString(1,  reportAdm);				
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					fNameAdm= checkNull(rs.getString("EMP_FNAME"));				
					lNameAdm= checkNull(rs.getString("EMP_LNAME"));
				}
				close(pstmt, rs);
			}
				valueXmlString.append("<emp_fname__reportadmin><![CDATA["+fNameAdm+"]]></emp_fname__reportadmin>\r\n");
				valueXmlString.append("<emp_lname__reportadmin><![CDATA["+lNameAdm+"]]></emp_lname__reportadmin>\r\n");
			
			if(report != null && report.trim().length() > 0)
			{
				String empCodeNameSql2 = "SELECT EMP_FNAME,EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE=?";
				pstmt=conn.prepareStatement(empCodeNameSql2);
				pstmt.setString(1,  report);				
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					fNameRep= checkNull(rs.getString("EMP_FNAME"));				
					lNameRep= checkNull(rs.getString("EMP_LNAME"));
				}
				close(pstmt, rs);
			}
							
				valueXmlString.append("<emp_fname__rep><![CDATA["+fNameRep+"]]></emp_fname__rep>\r\n");
				valueXmlString.append("<emp_lname__rep><![CDATA["+lNameRep+"]]></emp_lname__rep>\r\n");
			
			if(empHod != null && empHod.trim().length() > 0)
			{
				String empCodeHODNameSql = "SELECT EMP_FNAME,EMP_MNAME,EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE=?";
				pstmt=conn.prepareStatement(empCodeHODNameSql);
				pstmt.setString(1,  empHod);				
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					fNameHOD= checkNull(rs.getString("EMP_FNAME"));
					mNameHOD= checkNull(rs.getString("EMP_MNAME"));
					lNameHOD= checkNull(rs.getString("EMP_LNAME"));
				}
				close(pstmt, rs);
			}			
				valueXmlString.append("<employee_emp_fname><![CDATA["+fNameHOD+"]]></employee_emp_fname>\r\n");
				valueXmlString.append("<employee_emp_mname><![CDATA["+mNameHOD+"]]></employee_emp_mname>\r\n");
				valueXmlString.append("<employee_emp_lname><![CDATA["+lNameHOD+"]]></employee_emp_lname>\r\n");
			
			
			
			if(deptCode != null && deptCode.trim().length() > 0)
			{
				String empCodedeptSql = "SELECT DESCR FROM DEPARTMENT WHERE DEPT_CODE=?";
				pstmt=conn.prepareStatement(empCodedeptSql);
				pstmt.setString(1,deptCode);				
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					deptDescr=checkNull(rs.getString("DESCR"));
									
				}
				close(pstmt, rs);
			}
				valueXmlString.append("<department_descr><![CDATA["+deptDescr+"]]></department_descr>\r\n");
			
			if(designCode != null && designCode.trim().length() > 0)
			{
				String empCodeDesignSql = "SELECT DESIGNATION FROM DESIGNATION WHERE DESIGN_CODE=?";
				pstmt=conn.prepareStatement(empCodeDesignSql);
				pstmt.setString(1,designCode);				
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					designation=checkNull(rs.getString("DESIGNATION"));
									
				}
				close(pstmt, rs);
			}
			valueXmlString.append("<designation><![CDATA["+designation+"]]></designation>\r\n");
				
			if(grade != null && grade.trim().length() > 0)
			{
				String empCodeGradeSql = "SELECT DESCR FROM GRADE WHERE GRADE_CODE=?";
				pstmt=conn.prepareStatement(empCodeGradeSql);
				pstmt.setString(1,grade);				
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					gradeDescr=checkNull(rs.getString("DESCR"));								
				}
				close(pstmt, rs);
			}
				valueXmlString.append("<grade_descr><![CDATA["+gradeDescr+"]]></grade_descr>\r\n");
			
			
			if(cadre != null && cadre.trim().length() > 0)
			{
				String empCodecadreSql = "SELECT DESCR FROM CADRE WHERE CADRE_CODE=?";
				pstmt=conn.prepareStatement(empCodecadreSql);
				pstmt.setString(1,cadre);				
				rs=pstmt.executeQuery();
				while(rs.next())
				{
					cadreDescr=checkNull(rs.getString("DESCR"));
				}			
				close(pstmt, rs);
			}	
			valueXmlString.append("<cadre_descr><![CDATA["+cadreDescr+"]]></cadre_descr>\r\n");
			
		
			valueXmlString.append("<emp_fname__prev><![CDATA[").append(checkNull(fname)).append("]]></emp_fname__prev>\r\n");
		
			valueXmlString.append("<emp_lname__prev><![CDATA[").append(checkNull(lname)).append("]]></emp_lname__prev>\r\n");
			
			//Added by Suraj [08-MAR-2016][To Make entire window non-editable][A15BSUN007][START]
			if(flag != null && flag.trim().length() > 0)
			{
				valueXmlString.append("<vac_date protect=\"1\"><![CDATA["+chgDateStr+"]]></vac_date>\r\n");
				valueXmlString.append("<new_vacancy protect=\"1\"><![CDATA[N]]></new_vacancy>\r\n");
				valueXmlString.append("<reas_code_vac protect=\"1\"><![CDATA[]]></reas_code_vac>\r\n");
				valueXmlString.append("<emp_code__prev protect=\"1\"><![CDATA["+empCodePrev+"]]></emp_code__prev>\r\n");
				valueXmlString.append("<dept_code protect=\"1\"><![CDATA["+deptCode+"]]></dept_code>\r\n");
				valueXmlString.append("<site_code protect=\"1\"><![CDATA["+empSite+"]]></site_code>\r\n");
				valueXmlString.append("<location protect=\"1\"><![CDATA["+locDescr+"]]></location>\r\n");
				valueXmlString.append("<req_date protect=\"1\"><![CDATA["+chgDateStr+"]]></req_date>\r\n");
				valueXmlString.append("<grade_code protect=\"1\"><![CDATA["+grade+"]]></grade_code>\r\n");
				valueXmlString.append("<cadre_code protect=\"1\"><![CDATA["+cadre+"]]></cadre_code>\r\n");
				valueXmlString.append("<emp_code__rep protect=\"1\"><![CDATA["+report+"]]></emp_code__rep>\r\n");
				valueXmlString.append("<report_to__admin protect=\"1\"><![CDATA["+reportAdm+"]]></report_to__admin>\r\n");
				valueXmlString.append("<emp_code__hod protect=\"1\"><![CDATA["+empHod+"]]></emp_code__hod>\r\n");
				valueXmlString.append("<age_min protect=\"1\"><![CDATA[]]></age_min>\r\n");
				valueXmlString.append("<age_max protect=\"1\"><![CDATA[]]></age_max>\r\n");
				valueXmlString.append("<sex protect=\"1\"><![CDATA[]]></sex>\r\n");
				valueXmlString.append("<qlf_code__min protect=\"1\"><![CDATA[]]></qlf_code__min>\r\n");
				valueXmlString.append("<pass_perc protect=\"1\"><![CDATA[40]]></pass_perc>\r\n");
				valueXmlString.append("<min_exp protect=\"1\"><![CDATA[]]></min_exp>\r\n");
				valueXmlString.append("<qlf_code__alt1 protect=\"1\"><![CDATA[]]></qlf_code__alt1>\r\n");
				valueXmlString.append("<qlf_code__alt2 protect=\"1\"><![CDATA[]]></qlf_code__alt2>\r\n");
				valueXmlString.append("<qlf_code__alt3 protect=\"1\"><![CDATA[]]></qlf_code__alt3>\r\n");
				valueXmlString.append("<qlf_code__alt4 protect=\"1\"><![CDATA[]]></qlf_code__alt4>\r\n");
				valueXmlString.append("<qlf_code__alt5 protect=\"1\"><![CDATA[]]></qlf_code__alt5>\r\n");
				valueXmlString.append("<responsibilty protect=\"1\"><![CDATA[]]></responsibilty>\r\n");
				valueXmlString.append("<exp_det protect=\"1\"><![CDATA[]]></exp_det>\r\n");
				valueXmlString.append("<expr_detail protect=\"1\"><![CDATA[]]></expr_detail>\r\n");
				valueXmlString.append("<justification protect=\"1\"><![CDATA[]]></justification>\r\n");
				valueXmlString.append("<alternative protect=\"1\"><![CDATA[]]></alternative>\r\n");
				valueXmlString.append("<critical_issues protect=\"1\"><![CDATA[]]></critical_issues>\r\n");
				valueXmlString.append("<per_det protect=\"1\"><![CDATA[]]></per_det>\r\n");
				valueXmlString.append("<proj_code protect=\"1\"><![CDATA[]]></proj_code>\r\n");
				valueXmlString.append("<basic protect=\"1\"><![CDATA[]]></basic>\r\n");
				valueXmlString.append("<gross protect=\"1\"><![CDATA[]]></gross>\r\n");
				valueXmlString.append("<design_code protect=\"1\"><![CDATA["+designCode+"]]></design_code>\r\n");
				valueXmlString.append("<no_post protect=\"1\"><![CDATA[1]]></no_post>\r\n");
				valueXmlString.append("<budget_id protect=\"1\"><![CDATA[]]></budget_id>\r\n");
			}
			//Added by Suraj [08-MAR-2016][To Make entire window non-editable][A15BSUN007][End]
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return valueXmlString;
	}
	private int userLev(String userId,Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int userLevl=0;
		try
		{
			String empCodePrvSql2 = "SELECT USR_LEV FROM USERS WHERE CODE=?";
			pstmt=conn.prepareStatement(empCodePrvSql2);
			pstmt.setString(1,  userId);				
			rs=pstmt.executeQuery();
			while(rs.next())
			{
				userLevl = rs.getInt("USR_LEV");
			}
			close(pstmt, rs);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return userLevl;
	}
	
	
	
	private String checkNull(String input)//Method to check null string
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input =input.trim();
		}
		return input;
	}
	
	
	private void close(PreparedStatement pstmt,ResultSet rs) //Method to close PreparedStatement & ResultSet
	{
		try
		{
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
	
	
	private String getObjName(Document dom2,String objContext)// Method to get object name
	{	
		Node elementName = null;
		NodeList elementList = null;
		String objName = "";
		elementList = dom2.getElementsByTagName("Detail"+objContext);
		elementName = elementList.item(0);
		if (elementName!=null && ("Detail"+objContext).equalsIgnoreCase(elementName.getNodeName()))
		{
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes!=null)
			{
				if (etlAttributes.getNamedItem("objName")!=null)
				{
					objName = etlAttributes.getNamedItem("objName").getNodeValue();
				}
			}
		}
		return objName;
	}
	
	private String errorType(Connection conn, String errorCode)	throws ITMException 
	{
		String msgType = "E";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
			} catch (Exception ex) 
			{
				ex.printStackTrace();
				throw new ITMException(ex);
			} 
			finally 
			{
				try 
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
				} 
				catch (Exception e) 
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			return msgType;
		}
	
	/*//Added by Suraj [07-MAR-2016][A15BSUN007][To make every field protected][Start]
		private StringBuffer makeProtected(Document dom)
		{
			GenericUtility genericUtility = new GenericUtility();
			StringBuffer valueXmlString = new StringBuffer();
			String newVac = "",deptCode="",siteCode="",cadreCode="",gradeCode="",locCity="";
			String qlfCode="",empCodeRep="",designCode="",reportTo="",budgetId="",reqDate="";
			String empCodeHOD="",passPerc="",noPost="";
			String empCodePrev="",reasCodeVac="",vacDate="",ageMin="",ageMax="",gender="",minExp="",qlfCodeAlt1="",qlfCodeAlt2="",qlfCodeAlt3="";
			String qlfCodeAlt4="",qlfCodeAlt5="",responsibilty="",expDet="",exprDetail="",justification="",alternative="",criticalIssues="",perDet="";
			String projCode="",basic="",gross="";
			System.out.println("INSIDE makeProtected:::::::::::");
			try
			{
				vacDate=checkNull(genericUtility.getColumnValue("vac_date",dom));
				newVac=checkNull(genericUtility.getColumnValue("new_vacancy",dom));
				System.out.println("newVac:::::::::::"+newVac);
				reasCodeVac=checkNull(genericUtility.getColumnValue("reas_code_vac",dom));
				empCodePrev=checkNull(genericUtility.getColumnValue("emp_code__prev",dom));
				deptCode=checkNull(genericUtility.getColumnValue("dept_code",dom));
				siteCode=checkNull(genericUtility.getColumnValue("site_code",dom));
				locCity=checkNull(genericUtility.getColumnValue("location",dom));
				designCode=checkNull(genericUtility.getColumnValue("design_code",dom));
				noPost=checkNull(genericUtility.getColumnValue("no_post",dom));
				budgetId=checkNull(genericUtility.getColumnValue("budget_id",dom));
				reqDate=checkNull(genericUtility.getColumnValue("req_date",dom));
				gradeCode=checkNull(genericUtility.getColumnValue("grade_code",dom));
				cadreCode=checkNull(genericUtility.getColumnValue("cadre_code",dom));
				empCodeRep=checkNull(genericUtility.getColumnValue("emp_code__rep",dom));
				reportTo=checkNull(genericUtility.getColumnValue("report_to__admin",dom));
				empCodeHOD=checkNull(genericUtility.getColumnValue("emp_code__hod",dom));
				ageMin=checkNull(genericUtility.getColumnValue("age_min",dom));
				ageMax=checkNull(genericUtility.getColumnValue("age_max",dom));
				gender=checkNull(genericUtility.getColumnValue("sex",dom));
				qlfCode=checkNull(genericUtility.getColumnValue("qlf_code__min",dom));
				passPerc=checkNull(genericUtility.getColumnValue("pass_perc",dom));
				minExp=checkNull(genericUtility.getColumnValue("min_exp",dom));
				qlfCodeAlt1=checkNull(genericUtility.getColumnValue("qlf_code__alt1",dom));
				qlfCodeAlt2=checkNull(genericUtility.getColumnValue("qlf_code__alt2",dom));
				qlfCodeAlt3=checkNull(genericUtility.getColumnValue("qlf_code__alt3",dom));
				qlfCodeAlt4=checkNull(genericUtility.getColumnValue("qlf_code__alt4",dom));
				qlfCodeAlt5=checkNull(genericUtility.getColumnValue("qlf_code__alt5",dom));
				responsibilty=checkNull(genericUtility.getColumnValue("responsibilty",dom));
				expDet=checkNull(genericUtility.getColumnValue("exp_det",dom));
				exprDetail=checkNull(genericUtility.getColumnValue("expr_detail",dom));
				justification=checkNull(genericUtility.getColumnValue("justification",dom));
				alternative=checkNull(genericUtility.getColumnValue("alternative",dom));
				criticalIssues=checkNull(genericUtility.getColumnValue("critical_issues",dom));
				perDet=checkNull(genericUtility.getColumnValue("per_det",dom));				
				projCode=checkNull(genericUtility.getColumnValue("proj_code",dom));
				basic=checkNull(genericUtility.getColumnValue("basic",dom));
				gross=checkNull(genericUtility.getColumnValue("gross",dom));
			
				//valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
				//valueXmlString.append(editFlag).append("</editFlag></header>");
				//valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='mpreqmnt' selected='Y'>\r\n");
				valueXmlString.append("<vac_date protect=\"1\"><![CDATA["+vacDate+"]]></vac_date>\r\n");
				valueXmlString.append("<new_vacancy protect=\"1\"><![CDATA["+newVac+"]]></new_vacancy>\r\n");
				valueXmlString.append("<reas_code_vac protect=\"1\"><![CDATA["+reasCodeVac+"]]></reas_code_vac>\r\n");
				valueXmlString.append("<emp_code__prev protect=\"1\"><![CDATA["+empCodePrev+"]]></emp_code__prev>\r\n");
				valueXmlString.append("<dept_code protect=\"1\"><![CDATA["+deptCode+"]]></dept_code>\r\n");
				valueXmlString.append("<site_code protect=\"1\"><![CDATA["+siteCode+"]]></site_code>\r\n");
				valueXmlString.append("<location protect=\"1\"><![CDATA["+locCity+"]]></location>\r\n");
				valueXmlString.append("<req_date protect=\"1\"><![CDATA["+reqDate+"]]></req_date>\r\n");
				valueXmlString.append("<grade_code protect=\"1\"><![CDATA["+gradeCode+"]]></grade_code>\r\n");
				valueXmlString.append("<cadre_code protect=\"1\"><![CDATA["+cadreCode+"]]></cadre_code>\r\n");
				valueXmlString.append("<emp_code__rep protect=\"1\"><![CDATA["+empCodeRep+"]]></emp_code__rep>\r\n");
				valueXmlString.append("<report_to__admin protect=\"1\"><![CDATA["+reportTo+"]]></report_to__admin>\r\n");
				valueXmlString.append("<emp_code__hod protect=\"1\"><![CDATA["+empCodeHOD+"]]></emp_code__hod>\r\n");
				valueXmlString.append("<age_min protect=\"1\"><![CDATA["+ageMin+"]]></age_min>\r\n");
				valueXmlString.append("<age_max protect=\"1\"><![CDATA["+ageMax+"]]></age_max>\r\n");
				valueXmlString.append("<sex protect=\"1\"><![CDATA["+gender+"]]></sex>\r\n");
				valueXmlString.append("<qlf_code__min protect=\"1\"><![CDATA["+qlfCode+"]]></qlf_code__min>\r\n");
				valueXmlString.append("<pass_perc protect=\"1\"><![CDATA["+passPerc+"]]></pass_perc>\r\n");
				valueXmlString.append("<min_exp protect=\"1\"><![CDATA["+minExp+"]]></min_exp>\r\n");
				valueXmlString.append("<qlf_code__alt1 protect=\"1\"><![CDATA["+qlfCodeAlt1+"]]></qlf_code__alt1>\r\n");
				valueXmlString.append("<qlf_code__alt2 protect=\"1\"><![CDATA["+qlfCodeAlt2+"]]></qlf_code__alt2>\r\n");
				valueXmlString.append("<qlf_code__alt3 protect=\"1\"><![CDATA["+qlfCodeAlt3+"]]></qlf_code__alt3>\r\n");
				valueXmlString.append("<qlf_code__alt4 protect=\"1\"><![CDATA["+qlfCodeAlt4+"]]></qlf_code__alt4>\r\n");
				valueXmlString.append("<qlf_code__alt5 protect=\"1\"><![CDATA["+qlfCodeAlt5+"]]></qlf_code__alt5>\r\n");
				valueXmlString.append("<responsibilty protect=\"1\"><![CDATA["+responsibilty+"]]></responsibilty>\r\n");
				valueXmlString.append("<exp_det protect=\"1\"><![CDATA["+expDet+"]]></exp_det>\r\n");
				valueXmlString.append("<expr_detail protect=\"1\"><![CDATA["+exprDetail+"]]></expr_detail>\r\n");
				valueXmlString.append("<justification protect=\"1\"><![CDATA["+justification+"]]></justification>\r\n");
				valueXmlString.append("<alternative protect=\"1\"><![CDATA["+alternative+"]]></alternative>\r\n");
				valueXmlString.append("<critical_issues protect=\"1\"><![CDATA["+criticalIssues+"]]></critical_issues>\r\n");
				valueXmlString.append("<per_det protect=\"1\"><![CDATA["+perDet+"]]></per_det>\r\n");
				valueXmlString.append("<proj_code protect=\"1\"><![CDATA["+projCode+"]]></proj_code>\r\n");
				valueXmlString.append("<basic protect=\"1\"><![CDATA["+basic+"]]></basic>\r\n");
				valueXmlString.append("<gross protect=\"1\"><![CDATA["+gross+"]]></gross>\r\n");
				valueXmlString.append("<design_code protect=\"1\"><![CDATA["+designCode+"]]></design_code>\r\n");
				valueXmlString.append("<no_post protect=\"1\"><![CDATA["+noPost+"]]></no_post>\r\n");
				valueXmlString.append("<budget_id protect=\"1\"><![CDATA["+budgetId+"]]></budget_id>\r\n");
				//valueXmlString.append ("</Detail1>\r\n");	
				//valueXmlString.append ("</Root>\r\n");	
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
			System.out.println("valueXmlString RESULT::::::::::"+valueXmlString.toString());
			return valueXmlString;
		}
	//Added by Suraj [07-MAR-2016][A15BSUN007][To make every field protected][End]
*/	
}

