package ibase.e12ria.e12widgets.client;

import java.util.ArrayList;
import java.util.List;
import java.util.HashMap;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
//import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.NamedNodeMap;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;

/**
 * Represents the widget which takes input from scanner.
 * 
 * It contains a dynamically changing label and text box into which the
 * input will go. The behaviour of the text box will change specified by
 * scan metadata.
 * 
 * @author Gopalakrishna Bharat
 */

public class ScanInput extends Composite implements Focusable
{
    

    /** Flag to indicate that widget has been loaded. */
    private boolean isLoaded = false;

    /** Flag to indicate that Conditional Scan widget has been loaded. */
    private boolean isCSLoaded = false;    

    /** Flag to indicate whether scan has finished. */
    protected boolean isScanFinished = false;

    
    protected Panel parentPanel = new SimplePanel();
    
    /** Panel which contains the label and text box for this widget. */
    protected Panel panel = new HorizontalPanel();

    /** Panel to contain the display label. */
    protected Panel displayLabelContainer = new SimplePanel();
    
    /** Label to be displayed. */
    protected Label displayLabel = new Label();

    /** Panel to contain the input text box. */
    protected Panel inputTextBoxContainer = new SimplePanel();
    
    /** Text box for input. */
//    protected TextBox inputTextBox = new TextBox();
    protected E12TextBox inputTextBox = new E12TextBox();
   
    protected KeyUpHandler keyUpHandler;

    /** Dummy widget used to return focus to the scan input text box. */
//  protected FocusWidget tabDummyWidget = new TextBox();
    protected FocusWidget tabDummyWidget;
    
    /** List of <code>ScanVO</code>s which have been parsed for feeds. */
    protected List< ScanVO > mappingScanVOList = new ArrayList< ScanVO >();
    
    /** List of <code>ScanVO</code> which have been parsed for input. */
    protected List< ScanVO > inputScanVOList = new ArrayList< ScanVO >();
    
    /** Index of the current mapping data. */
    protected int currentIndex = -1;

    /** Mode of scanning currently. */
    protected ScanMode scanMode;

    /** List of handlers registered for scan event. */
    protected List< ScanHandler > scanHandlerList = new ArrayList< ScanHandler >();
    
    /** List of scanConditions. */
	protected Map<String, ScanCondition> scanConditions;

    /** Map to hold data for Conditional Scan-Input */
	protected Map<String, String> feedData;
	
    /** Map to hold data for Lookup Scan-Input */
	protected Map<String, String> lookupData;
	
    // Opera-specific
    protected Button operaTriggerButton = new Button();
    
    /** Flag to indicate that widget has to be reset when loaded. */
    private boolean isResetable = true;


    /** 
     * Defines enumerations for scanning mode: can be MAPPING,
     * in case of mapping with feeds, or can be INPUT, when in
     * detail window.
     */
    public enum ScanMode
    {
        MAPPING,
        INPUT;
    }
    
    
    /** Represents the <code>mapping_scan</code> element from the metadata. */
    protected class ScanVO
    {
        int order;
        String scanLabel;
        FieldsVO fieldsVO;
    	//Added by Prajyot on 3/JAN/2012 
    	/** For MAP_DATA_FILTER option */
        String mapDataFilter; //One of these [ BOTH / MAPPED / NOTMAPPED ]
    }
    
    
    /** Represents the <code>fields</code> element from the metadata. */
    protected class FieldsVO
    {
        String separator;
        String delimiter;
        List< FieldVO > fieldVOList = new ArrayList< FieldVO >();
        /** Set total Lookup fields */
        int noOfLookupFields = 0;
    }
    
    
    /** Represents the <code>field</code> element from the metadata. */
    protected class FieldVO
    {
        int order;
        int width;
        int start = -1;
        int end = -1;
        String data;
        //Added By Mahesh Patidar on 09/11/12 for Implement Lookup scanning
        String lookupTable;
        String lookupCol;
        String lookupReturnCol;
        //Ended By Mahesh Patidar
        
        //Added By Prajyot Rumde on 03/12/12 for Implement Mandatory option
        String mandatory = "Y";
        boolean isLookupField;
		//Added by Dnyaneshwar Chavan on 19-DEC-13 [ Substring start value to current string length minus given right variable value ] START
        int left = -1;
        int right = -1;
		//Added by Dnyaneshwar Chavan on 19-DEC-13 [ Substring start value to current string length minus given right variable value ] END
    }
    
    
    /** Represents an event when one code is scanned. */
    public static class ScanEvent
    {
    	//Added by Prajyot on 3/JAN/2012 
    	/** For MAP_DATA_FILTER option */
    	String mapDataFilter;
    	
        /** List of field names. */
        protected List< String > fieldNameList;
        
        /** List of scanned values. */
        protected List< String > scanValueList;

        /** Protected constructor, used only within the <code>ScanInput</code> class. */
        protected ScanEvent()
        {
            
        }

        /** Sets the scan value list. */
        protected void setScanValueList( List< String > scanValueList )
        {
            this.scanValueList = scanValueList;
        }
        
        /** Sets the field name list. */
        protected void setFieldNameList( List< String > fieldNameList )
        {
            this.fieldNameList = fieldNameList;
        }

        /** Returns list of field names. */
        public List< String > getFieldNameList()
        {
            return fieldNameList;
        }
        
        /** Returns list of scanned values. */
        public List< String > getScanValueList()
        {
            return scanValueList;
        }

		public String getMapDataFilter() 
		{
			return mapDataFilter;
		}

		public void setMapDataFilter(String mapDataFilter) 
		{
			this.mapDataFilter = mapDataFilter;
		}
        
    }
    
    
    /** Represents the event when all the codes have been scanned. */
    public class ScanFinishedEvent
    {
        
        /** Protected constructor, used only within in <code>ScanInput</code> class. */
        protected ScanFinishedEvent()
        {
            
        }
        
    }
    
	protected static class ScanCondition 
	{
		protected String field;
		protected String condition;
		
		public void setField(String field) 
		{
			this.field = field;
		}
		
		public void setCondition(String condition) 
		{
			this.condition = condition;
		}
		
		public String getField() 
		{
			return field;
		}
		
		public String getCondition() 
		{
			return condition;
		}
	}

    /** Handler for <code>ScanEvent</code> events. */
    public interface ScanHandler extends EventHandler
    {
        void onScan( ScanEvent scanEvent );
        void onAllScanned( ScanFinishedEvent scanFinishedEvent );
    }
    
    
    /**
     * Creates a new object of this class.
     * 
     * @param scanMetadata XML which is used to determine filtering
     *         behaviour for this.
     */
    public ScanInput( ScanMode scanMode )
    {
    	initWidget( parentPanel );
        setScanMode( scanMode );
        
        configureTabDummy();
    }


    /**
     * Sets parameter for the tab dummy widget.
     * 
     * <p>
     * Most importantly, it adds the focus handler which will return
     * focus to the input text box.
     */
    protected void configureTabDummy()
    {
        if( tabDummyWidget == null )
        {
            return;
        }
        tabDummyWidget.setSize( "1px", "1px" );
        tabDummyWidget.addFocusHandler( new FocusHandler()
        {
            @Override
            public void onFocus( FocusEvent event )
            {
                inputTextBox.setFocus( true );
            }
        } );
    }
    

    /**
     * Returns a reference to the panel which contains the display label so that
     * clients can independently manipulate style attributes and
     * other parameters if required.
     * 
     * @return the panel which contains the display label
     */
    public Panel getDisplayLabelContainer()
    {
        return displayLabelContainer;
    }
    

    /**
     * Returns a reference to the panel containing the input text box so that
     * clients can independently manipulate style attributes and
     * other parameters if required.
     * 
     * @return the panel which contains the input text box
     */
    public Panel getInputTextBoxContainer()
    {
        return inputTextBoxContainer;
    }
    

    /** 
     * Returns a reference to the display label widget so that clients
     * can independently manipulate style attributes and other parameters
     * if required.
     * 
     * @return the display label
     */
    public Label getDisplayLabel()
    {
        return displayLabel;
    }
    

    /** 
     * Returns a reference to the input text box widget so that clients
     * can independently manipulate style attributes and other parameters
     * if required.
     * 
     * @return the input text box
     */
    //public TextBox getInputTextBox()
    public E12TextBox getInputTextBox()
    {
        return inputTextBox;
    }
    

    /** 
     * Sets the scan mode.
     * 
     * @param scanMode the scan mode
     */
    private void setScanMode( ScanMode scanMode )
    {
        this.scanMode = scanMode;
    }
    
    
    @Override
    public int getTabIndex()
    {
        return inputTextBox.getTabIndex();
    }


    @Override
    public void setAccessKey( char key )
    {
        inputTextBox.setAccessKey( key );
    }


    @Override
    public void setFocus( boolean focus )
    {
        if( focus && Window.Navigator.getUserAgent().indexOf( "Opera" ) != -1 )
        {
            operaFocusImpl();
        }
        else
        {
            inputTextBox.setFocus( focus );
        }
    }
    
    
    /**
     * Sets the focus to the inputTextBox and schedules a timer.
     */
    protected void operaFocusImpl()
    {
        inputTextBox.setFocus( false );
        new Timer()
        {
            @Override
            public void run()
            {
                operaTriggerButton.click();
            }
        }.schedule( 1 );
    }


    @Override
    public void setTabIndex( int index )
    {
        inputTextBox.setTabIndex( index );
    }
    
    
    /**
     * Sets the scanMetadata based on which filtering will be done.
     * 
     * @param scanMetadata The XML based on which filtering will be done.
     */
    public void setScanMetadata( String scanMetadata )
    {
        try 
        {
			if( scanMetadata != null && scanMetadata.length() > 0 
			        && !"null".equals( scanMetadata ) )
			{
			    mappingScanVOList = parseMappingScan( scanMetadata );
			    inputScanVOList = parseInputScan( scanMetadata );
			    scanConditions = parseScanConditions(scanMetadata);
			}
			resetCurrentIndex();
			if( isLoaded )
			{
			    updateWidget();
			}
		}
        catch (Exception e) 
        {
			Window.alert("Exception : setScanMetadata()["+e.getMessage()+"]");
		}
    }


    /**
     * Parses the given metadata and sets the values into the appropriate
     * objects.
     * 
     * @param scanMetadata XML which is used to determine filtering
     *         behaviour.
     */
    protected List< ScanVO > parseMappingScan( String scanMetadata )
    {
        try
        {
            Document document = XMLParser.parse( scanMetadata );
            NodeList mappingScanNodeList = document.getElementsByTagName( "MAPPING_SCAN" );
            return parse( mappingScanNodeList );
        }
        catch( Exception e )
        {
            Window.alert( "ScanInput::parseMappingScan()"
                    + "\n"
                    + e.toString() );
        }
        return new ArrayList< ScanVO >();
    }


    /**
     * Parses the given metadata and sets the values into the appropriate
     * objects.
     * 
     * @param scanMetadata XML which is used to determine filtering
     *         behaviour.
     */
    protected List< ScanVO > parseInputScan( String scanMetadata )
    {
        try
        {
            Document document = XMLParser.parse( scanMetadata );
            NodeList inputScanNodeList = document.getElementsByTagName( "INPUT_SCAN" );
            return parse( inputScanNodeList );
        }
        catch( Exception e )
        {
            Window.alert( "ScanInput::parseInputScan()"
                    + "\n"
                    + e.toString() );
        }
        return new ArrayList< ScanVO >();
    }
    
	protected Map<String, ScanCondition> parseScanConditions(String scanMetadata) 
	{
		try 
		{
			Document document = XMLParser.parse(scanMetadata);
			NodeList scanConditionNodeList = document.getElementsByTagName("SCAN_CONDITION");
			return parseScanConditions(scanConditionNodeList);
		} 
		catch (RuntimeException e) 
		{
			Window.alert("Exception in " + getClass() + "::parseScanConditions(String)\n" + e);
			throw e;
		}
	}
	
	
	protected Map<String, ScanCondition> parseScanConditions(NodeList scanConditionNodeList) 
	{
		Map<String, ScanCondition> scanConditions = new HashMap<String, ScanCondition>();
		for (int i = 0; i < scanConditionNodeList.getLength(); i++) 
		{
			ScanCondition scanCondition = parseScanCondition(scanConditionNodeList.item(i));
			scanConditions.put(scanCondition.getField(), scanCondition);
		}
		return scanConditions;
	}
	
	
	protected ScanCondition parseScanCondition(Node scanConditionNode) 
	{
		try 
		{
			ScanCondition scanCondition = new ScanCondition();
			NamedNodeMap attributes = scanConditionNode.getAttributes();
			try 
			{
				String field = attributes.getNamedItem("field").getNodeValue();
				scanCondition.setField(field);
			} 
			catch (NullPointerException e) 
			{
				throw new RuntimeException("Missing attribute <field>", e);
			}
			try 
			{
				String condition = scanConditionNode.getFirstChild().getNodeValue();
				scanCondition.setCondition(condition);
			} 
			catch (RuntimeException e) 
			{
				throw new RuntimeException("Condition not inside CDATA or invalid condition", e);
			}
			return scanCondition;
		} 
		catch (RuntimeException e) 
		{
			Window.alert("Exception in " + getClass() + "::parseScanCondition(Node)\n" + e);
			throw e;
		}
	}


    /**
     * Parses from a given <code>NodeList</code> and returns parsed List of 
     * <code>ScanVO</code>s.
     * 
     * @param scanNodeList the NodeList used for obtaining values.
     */
    protected List< ScanVO > parse( NodeList scanNodeList )
    {
        if( scanNodeList == null )
        {
            return null;
        }
        
        List< ScanVO > scanVOList = new ArrayList< ScanVO >();
        for( int i = 0; i < scanNodeList.getLength(); i++ )
        {
            ScanVO scanVO = new ScanVO();
            Node scanNode = scanNodeList.item( i );
            
            scanVO.order = (int)Double.parseDouble( scanNode
                    .getAttributes().getNamedItem( "ORDER" ).getNodeValue() );
            
            //Added by Prajyot on 3/JAN/2012 [ For MAP_DATA_FILTER option ]
            Node mapDataFilterNode = scanNode.getAttributes().getNamedItem( "MAP_DATA_FILTER" );
			scanVO.mapDataFilter =  ( mapDataFilterNode != null ) ? mapDataFilterNode.getNodeValue() : "BOTH";
            
            Node fieldsNode = null;
            FieldsVO fieldsVO = new FieldsVO();
            
            NodeList scanChildNodeList = scanNode.getChildNodes();
            for( int j = 0; j < scanChildNodeList.getLength(); j++ )
            {
                Node scanLabelNode = scanChildNodeList.item( j );
                if( "SCAN_LABEL".equals( scanLabelNode.getNodeName() ) )
                {
                    scanVO.scanLabel = scanLabelNode.getFirstChild().getNodeValue();
                }
                if( "FIELDS".equals( scanLabelNode.getNodeName() ) )
                {
                    fieldsNode = scanLabelNode;
                }
            }
            
            fieldsVO.separator = fieldsNode.getAttributes()
                    .getNamedItem( "SEPARATOR" ).getNodeValue();
            fieldsVO.delimiter = fieldsNode.getAttributes()
                    .getNamedItem( "DELIMITER" ).getNodeValue();
            
            NodeList fieldNodeList = fieldsNode.getChildNodes();
            for( int j = 0; j < fieldNodeList.getLength(); j++ )
            {
                FieldVO fieldVO = new FieldVO();
                Node fieldNode = fieldNodeList.item( j );
                if( !"FIELD".equals( fieldNode.getNodeName() ) )
                {
                    continue;
                }
                NamedNodeMap fieldNodeAttributes = fieldNode.getAttributes();
                fieldVO.order = 0;
                fieldVO.width = 0;
                for( int k = 0; k < fieldNodeAttributes.getLength(); k++ )
                {
                    Node fieldNodeAttribute = fieldNodeAttributes.item( k );
                    String attributeName = fieldNodeAttribute.getNodeName();
                    if( "ORDER".equals( attributeName ) )
                    {
                        fieldVO.order = (int)Double.parseDouble( 
                                fieldNodeAttribute.getNodeValue() );
                        
                     }
                    else if( "width".equals( attributeName ) )
                    {
                        fieldVO.width = (int)Double.parseDouble( 
                                fieldNodeAttribute.getNodeValue() );
                        
                     }
                    else if( "start".equals( attributeName ) )
                    {
                        fieldVO.start = (int)Double.parseDouble( 
                                fieldNodeAttribute.getNodeValue() ) - 1;
                    }
                    else if( "end".equals( attributeName ) )
                    {
                        fieldVO.end = (int)Double.parseDouble( 
                                fieldNodeAttribute.getNodeValue() );
                    }
                    //Added By Mahesh Patidar on 09/11/12 for Implement Lookup scanning
                    else if( "LOOKUP_TABLE".equals( attributeName ))
                    {
                    	fieldVO.lookupTable = fieldNodeAttribute.getNodeValue();
                    }
                    else if( "LOOKUP_COL".equals( attributeName ))
                    {
                    	fieldVO.lookupCol = fieldNodeAttribute.getNodeValue();
                    }
                    else if( "LOOKUP_RETCOL".equals( attributeName ))
                    {
                    	fieldVO.lookupReturnCol = fieldNodeAttribute.getNodeValue();
                    }
                    //Ended By Mahesh Patidar
                    //Added By Prajyot P. Rumde on 03/12/12 for Mandatory option 
                    else if( "mandatory".equals( attributeName ))
                    {
                    	fieldVO.mandatory = fieldNodeAttribute.getNodeValue();
                    }
                    //Ended By Prajyot P. Rumde
                    //Added by Dnyaneshwar Chavan on 19-DEC-13 [ Substring start value to current string length minus given right variable value ] START
                    else if( "left".equals( attributeName ) )
                    {
                        fieldVO.left = (int)Double.parseDouble( 
                                fieldNodeAttribute.getNodeValue() ) - 1;
                    }
                    else if( "right".equals( attributeName ) )
                    {
                    	fieldVO.right = (int)Double.parseDouble( fieldNodeAttribute.getNodeValue() );
                    }
                    //Added by Dnyaneshwar Chavan on 19-DEC-13 [ Substring start value to current string length minus given right variable value ] END
                }
                
                fieldVO.isLookupField = ( fieldVO.lookupTable != null && !fieldVO.lookupTable.isEmpty() && 
							 			  fieldVO.lookupCol != null && !fieldVO.lookupCol.isEmpty() && 
							 			  fieldVO.lookupReturnCol != null &&  !fieldVO.lookupReturnCol.isEmpty() ) ;
                
                if( fieldVO.isLookupField ) 
                {
                	fieldsVO.noOfLookupFields++;
                }
                fieldVO.data = fieldNode.getFirstChild().getNodeValue();
                
                if( fieldVO.order > 0 )
                {
                    fieldsVO.fieldVOList.add( fieldVO.order - 1, fieldVO );
                }
                else
                {
                    fieldsVO.fieldVOList.add( fieldVO );
                }
            }
            
            scanVO.fieldsVO = fieldsVO;

            if( scanVO.order > 0 )
            {
                scanVOList.add( scanVO.order - 1, scanVO );
            }
            else
            {
                scanVOList.add( scanVO );
            }
        }
        
        return scanVOList;
    }
    
	public void setFeedData(Map<String, String> feedData) 
	{
		this.feedData = feedData;
	}
    
    @Override
    protected void onLoad()
    {
       	//Added by Prajyot On 15-FEB-2013 [To skip scan if enter value is "X" or "x" ]Starts
    	if( !isResetable )
    	{
    		this.isResetable = !isResetable; 
    		return;
    	}
       	//Added by Prajyot On 15-FEB-2013 [To skip scan if enter value is "X" or "x" ]Ends
    	
        isLoaded = false;

        reset();
        resetWidget();
        
        displayLabelContainer.add( displayLabel );
        panel.add( displayLabelContainer );
        
        inputTextBoxContainer.add( inputTextBox );
        panel.add( inputTextBoxContainer );
        
        // Tab dummy was required when we wanted to do a tab-out
        // and still retain focus
//        panel.add( tabDummyWidget );
        
        configureEvents();
        
        operaTriggerButton.setVisible( false );
        panel.add( operaTriggerButton );
        
        parentPanel.add( panel );
        
        updateWidget();
        
        isLoaded = true;
        
        //For Conditional ScanInput
		if (!isCSLoaded && scanConditions != null && scanConditions.size() > 0 ) {
			addScanHandler(new ScanHandler() {
				@Override
				public void onScan(ScanEvent scanEvent) {
					if (feedData == null) {
						return;
					}
					List<String> fieldNameList = scanEvent.getFieldNameList();
					List<String> scanValueList = scanEvent.getScanValueList();
					for (int i = 0; i < fieldNameList.size(); i++) {
						feedData.put(fieldNameList.get(i), scanValueList.get(i));
					}
				}
				@Override
				public void onAllScanned(ScanFinishedEvent scanFinishedEvent) {
					// Not required.
				}
			});
			
			isCSLoaded = true;
		}
		//For Conditional ScanInput
    }


    /**
     * Resets the state of the widget.
     */
    protected void resetWidget()
    {
    	parentPanel.clear();
        panel.clear();
        displayLabelContainer.clear();
        inputTextBoxContainer.clear();
    }
    
    
    /**
     * Resets the scan state, so you have to start the scan all
     * over again.
     */
    public void reset()
    {
        resetCurrentIndex();
        isScanFinished = false;
        if( isLoaded )
        {
            updateWidget();
        }
        
        //For Conditional ScanInput 
        if( scanConditions != null && scanConditions.size() > 0 )
        {
        	currentIndex = -1;
        	if (inputScanVOList.size() > 0) {
        		next();
        	}
        }
		//For Conditional ScanInput
    }

    
    /**
     * Sets event handlers for child widgets.
     */
    protected void configureEvents()
    {
        // The following code fragment will be used when we want to fire
        // a tab-out event on the text box after scan.
//        inputTextBox.addBlurHandler( new BlurHandler()
//        {
//            @Override
//            public void onBlur( BlurEvent blurEvent )
//            {
//                doScan();
//                tabDummyWidget.setFocus( true );
//            }
//        } );
        
        // The following code fragment will be used when we want to fire
        // an event on the text box after scan, by hitting the ENTER key.
    	if( keyUpHandler == null )
    	{
            keyUpHandler = new KeyUpHandler()
            {
                
                @Override
                public void onKeyUp(KeyUpEvent event)
                {
                	ScanVO currentMappingScanVO = getCurrentScanVO();
                	//Added by Dnyaneshwar Chavan On 08-Aug-13 [ The current scan input field name is an 'isempty' then only accept values are 'Y' or 'N'  ] Start
                	if( scanMode == ScanMode.INPUT )
                	{
                		if( isemptyField( currentMappingScanVO.fieldsVO.fieldVOList ) )
                		{
                			if( !( "Y".equals( inputTextBox.getText().trim() ) || "N".equals( inputTextBox.getText().trim() ) ) ) 
                			{
                				inputTextBox.setText( "" );
                				inputTextBox.setFocus( true );
                				return;
                			}
                		}
                	}
                    //Added by Dnyaneshwar Chavan On 08-Aug-13 [ The current scan input field name is an 'isempty' then only accept values are 'Y' or 'N'  ] Start
                	
                	//Added By Prajyot Rumde on 03/12/12 for Implement Mandatory option
                	if( "".equals( inputTextBox.getText().trim() ) && isMandatory() )
                	{
                		return;
                	}

                    if( currentMappingScanVO == null )
                    {
                        return;
                    }

                    if( Window.Navigator.getUserAgent().indexOf( "Opera" ) != -1 )
                    {
                        if( currentMappingScanVO.fieldsVO.noOfLookupFields > 0 )
                        {
                        	doLookup( currentMappingScanVO );
                        }
                        else
                        {
                        	doScan();
                        }
                    }
                    else if( event.getNativeKeyCode() == 13 || event.getNativeKeyCode() == 0 )
                    {
                        if( currentMappingScanVO.fieldsVO.noOfLookupFields > 0 )
                        {
                        	doLookup( currentMappingScanVO );
                        }
                        else
                        {
                        	doScan();
                        }
                   }
                }
            };
    		inputTextBox.addKeyUpHandler( keyUpHandler );
    	}
    
//        inputTextBox.addKeyDownHandler( new KeyDownHandler()
//        {
//            @Override
//            public void onKeyDown( KeyDownEvent event )
//            {
//                //if( event.getNativeKeyCode() == 13 || event.getNativeKeyCode() == 0 )
//                //{
//                    doScan();
//                //}
//            }
//        } );
        
        operaTriggerButton.addClickHandler( new ClickHandler()
        {
            @Override
            public void onClick(ClickEvent event)
            {
                inputTextBox.setFocus( false );
                inputTextBox.setFocus( true );
            }
        } );
    }
    

    /**
     * Contains the algorithm to be performed when the event occurs
     * for taking scan. The event can be anything, this method is
     * independent of the event which is fired.
     */
    protected void doScan()
    {
        ScanEvent scanEvent = createNewScanEvent();
        try
        {
            fireScanEvent( scanEvent );
            next();
        }
        catch( Exception e )
        {
            if( isVisible() )
            {
                setFocus( true );
            }
        }
    }
    
    
    /**
     * Increments to the next field, and refreshes the widget.
     */
    protected void next()
    {
        currentIndex++;
        if( scanMode == ScanMode.MAPPING )
        {
            if( currentIndex >= mappingScanVOList.size() )
            {
                currentIndex = -1;
                fireScanFinishedEvent( createNewScanFinishedEvent() );
                isScanFinished = true;
            }
        }
        else if( scanMode == ScanMode.INPUT )
        {
            if( currentIndex >= inputScanVOList.size() )
            {
                currentIndex = -1;
                fireScanFinishedEvent( createNewScanFinishedEvent() );
                isScanFinished = true;
            }
        }
        
        updateWidget();
        
        //For Conditional ScanInput
        if( scanConditions != null && scanConditions.size() > 0 )
        {
        	if (isScanFinished) {
        		return;
        	}
        	ScanEvent scanEvent = createNewScanEvent();
        	List<String> fieldNameList = scanEvent.getFieldNameList();
        	for (String fieldName : fieldNameList) {
        		boolean scanConditionSatisfied = isScanConditionSatisfied(fieldName);
        		if (!scanConditionSatisfied) {
        			next();
        			break;
        		}
        	}        	
        }
		//For Conditional ScanInput
    }
    
    
    /**
     * Resets the value of current index on which scan is placed.
     * If no scan metadata is present, it will be reset to -1, otherwise
     * it will be reset to 0.
     */
    private void resetCurrentIndex()
    {
        currentIndex = -1;
        if( scanMode == ScanMode.MAPPING )
        {
            if( mappingScanVOList.size() > 0 )
            {
                currentIndex = 0;
            }
        }
        else if( scanMode == ScanMode.INPUT )
        {
            if( inputScanVOList.size() > 0 )
            {
                currentIndex = 0;
            }
        }
    }

    
    /**
     * Updates the UI parameters for this widget based on the current state. 
     */
    protected void updateWidget()
    {
        ScanVO currentScanVO = getCurrentScanVO();
        
        if( currentScanVO == null )
        {
            setVisible( false );
            return;
        }

        setVisible( true );
        
        String scanLabel = currentScanVO.scanLabel;
        displayLabel.setStyleName("scanLabel");
        displayLabel.setText( scanLabel );
        inputTextBox.setText( "" );

        setFocus( true );
    }
    
    
    /**
     * @return The current <code>MappingScanVO</code> which is currently set.
     */
    protected ScanVO getCurrentScanVO()
    {
        if( scanMode == ScanMode.MAPPING )
        {
        	if( mappingScanVOList.size() == 1 )
        	{
        		return mappingScanVOList.get(0);
        	}
            if( currentIndex < 0 || currentIndex > mappingScanVOList.size() )
            {
                return null;
            }
            return mappingScanVOList.get( currentIndex );
        }
        else if( scanMode == ScanMode.INPUT )
        {
            if( currentIndex < 0 || currentIndex > inputScanVOList.size() )
            {
                return null;
            }
            return inputScanVOList.get( currentIndex );
        }
        return null;
    }
    

    /**
     * Extracts the field names from the current <code>MAPPING_SCAN</code> element,
     * and returns them as a <code>List</code>.
     * 
     * @return A <code>List</code> containing field names for current scan; <b>null</b>
     *             if metadata for current scan is not available.
     */
    protected List< String > extractFieldNames()
    {
        List< String > fieldNameList = new ArrayList< String >();
        ScanVO currentMappingScanVO = getCurrentScanVO();
        if( currentMappingScanVO == null )
        {
            return null;
        }
        for( FieldVO fieldVO : currentMappingScanVO.fieldsVO.fieldVOList )
        {
            String fieldName = fieldVO.data;
            fieldNameList.add( fieldName );
        }
        return fieldNameList;
    }


    /**
     * Extracts the relevant values from the given scan input.
     * 
     * @param input The given scan input.
     * 
     * @return A <code>List</code> containing all the separated values;
     *             <b>null</b> if metadata for current scan is not available.
     */
    protected List< String > extractScanValues()
    {
        List< String > fieldValueList = new ArrayList< String >();
        ScanVO currentMappingScanVO = getCurrentScanVO();
        if( currentMappingScanVO == null )
        {
            return null;
        }
        
        if( currentMappingScanVO.fieldsVO.noOfLookupFields > 0 && ( lookupData != null && lookupData.size() > 0 ) )
        {
    		for( FieldVO fieldVO : currentMappingScanVO.fieldsVO.fieldVOList )
    		{
    			fieldValueList.add( lookupData.get( fieldVO.data ) );
    		}        	
        }
        else
        {
        	String scanInput = inputTextBox.getText();
        	
        	//Added by Prajyot On 15-FEB-2013 [To skip scan if enter value is "X" or "x" ]Starts
    		if( "X".equalsIgnoreCase( scanInput.trim() ) )
    		{
    			//Window.alert("Escaping current scan...");
    			fieldValueList.add( "" );
    			return fieldValueList;
    		}
    		//Added by Prajyot On 15-FEB-2013 [To skip scan if enter value is "X" or "x" ]Ends 
    		
        	String separator = currentMappingScanVO.fieldsVO.separator;
        	if( "".equals( separator ) )
        	{
        		fieldValueList.add( scanInput );
        	}
        	else if( "D".equals( separator ) )
        	{
        		String delimiter = currentMappingScanVO.fieldsVO.delimiter;
        		String[] scanInputs = scanInput.split( delimiter );
        		for( String s : scanInputs )
        		{
        			fieldValueList.add( s );
        		}
        	}
        	else if( "W".equals( separator ) )
        	{
        		int index = 0;
        		for( FieldVO fieldVO : currentMappingScanVO.fieldsVO.fieldVOList )
        		{
        			int width = fieldVO.width;
        			String substring = scanInput.substring( index, index + width );
        			fieldValueList.add( substring );
        			index += width;
        		}
        	}
        	else if( "S".equalsIgnoreCase( separator ) )
        	{
        		if( "".equals( scanInput.trim() ) )
        		{
        			return fieldValueList;
        		}
        		for( FieldVO fieldVO : currentMappingScanVO.fieldsVO.fieldVOList )
        		{
        			//Added by Dnyaneshwar Chavan on 19-DEC-13 [ Substring start value to current string length minus given right variable value ] START
        			if( fieldVO.left != -1 && fieldVO.right != -1  )
        			{
        				String substring = scanInput.substring( fieldVO.left, ( scanInput.length() - fieldVO.right ) );
        				if( "".equals( substring.trim() ) )
        				{
        					String msg =  "Please provide valid data \nData provided it's length is less than configuration. \nMin.data length should be " + ( fieldVO.left + 1 );
        					Window.alert( msg );
        					throw new StringIndexOutOfBoundsException( fieldVO.left );
        				}
        				fieldValueList.add( substring );
        			}
        			//Added by Dnyaneshwar Chavan on 19-DEC-13 [ Substring start value to current string length minus given right variable value ] END
        			else if( fieldVO.start == -1 && fieldVO.end == -1 )
        			{
        				fieldValueList.add( scanInput );
        			}
        			else if( fieldVO.end == -1 )
        			{
        				fieldValueList.add( scanInput.substring( fieldVO.start ) );
        			}
        			else if( fieldVO.start == -1 )
        			{
        				fieldValueList.add( scanInput.substring( 0, fieldVO.end ) );
        			}
        			else
        			{
        				String substring = scanInput.substring( fieldVO.start, fieldVO.end );
        				if( "".equals( substring.trim() ) )
        				{
        					String msg =  "Please provide valid data \nData provided it's length is less than configuration. \nMin.data length should be " + ( fieldVO.start + 1 );
        					Window.alert( msg );
        					throw new StringIndexOutOfBoundsException( fieldVO.start );
        				}
        				fieldValueList.add( substring );
        			}
        		}
        	}
        }
        return fieldValueList;
    }
    

    /** 
     * Register new <code>ScanHandler</code> to listen to this widget's scan events.
     *
     * @param scanHandler the handler
     */
    public HandlerRegistration addScanHandler( ScanHandler scanHandler )
    {
        if( scanHandler == null )
        {
            throw new NullPointerException( "<scanHandler> is null" );
        }
        scanHandlerList.add( scanHandler );
        return null;
    }
    
    
    /**
     * Fires the given event to all the handlers listening to the event.
     * 
     * @param scanEvent the event
     */
    protected void fireScanEvent( ScanEvent scanEvent )
    {
        for( ScanHandler scanHandler : scanHandlerList )
        {
            scanHandler.onScan( scanEvent );
        }
    }
    
    
    /**
     * Fires the given event to all the handlers listening to the event.
     * 
     * @param scanFinishedEvent the event
     */
    protected void fireScanFinishedEvent( ScanFinishedEvent scanFinishedEvent )
    {
        for( ScanHandler scanHandler : scanHandlerList )
        {
            scanHandler.onAllScanned( scanFinishedEvent );
        }
    }
    

    /** Creates and populates a new <code>ScanEvent</code> object. */
    protected ScanEvent createNewScanEvent()
    {
        ScanEvent scanEvent = new ScanEvent();
        List< String > fieldNameList = extractFieldNames();
        List< String > scanValuesList = extractScanValues();
        scanEvent.setFieldNameList( fieldNameList );
        scanEvent.setScanValueList( scanValuesList );
        scanEvent.setMapDataFilter( getCurrentScanVO().mapDataFilter );
        return scanEvent;
    }
    
    
    /** Creates and populates a new <code>ScanFinishedEvent</code> object. */
    protected ScanFinishedEvent createNewScanFinishedEvent()
    {
        ScanFinishedEvent scanFinishedEvent = new ScanFinishedEvent();
        return scanFinishedEvent;
    }
    
    /**
     * Creates a new <code>ScanInput</code> widget and populates the styles.
     * 
     * @param formNo formNo for which the scan metadata will be fetched
     * @param scanMode the scan mode
     * 
     * @return instance of <code>ScanInput</code>
     */
    public static ScanInput createScanInput( int formNo, ScanMode scanMode, String scanMetadata )
    {
		ScanInput scanInput = null;
    	try 
    	{
			if( scanMetadata != null && scanMetadata.startsWith( "<SCAN" ) )
			{
				scanInput = new ScanInput( scanMode );
				scanInput.setScanMetadata( scanMetadata );
			}
			else if( scanMetadata != null && scanMetadata.startsWith( "<SEARCH" ) )
			{
				scanInput = new SearchField();
				scanInput.setScanMetadata( scanMetadata );
			}
			else
			{
				String message = "Scan metadata does not start with either \"<SCAN\" or \"<SEARCH\".\nThe scan metadata was:\n" + scanMetadata;
				//Window.alert( message );
				//throw new NullPointerException( message );
			}
		} 
    	catch (Exception e) 
		{
    		Window.alert("Exception : createScanInput() ["+e.getMessage()+"]");
		}
		return scanInput;
    }

    private void doLookup( ScanVO currentMappingScanVO )    //Added By Mahesh Patidar on 09/11/12 for Lookup scanning
    {
    	createLookupData();
    	int count = 1;
    	for( FieldVO fieldVO : currentMappingScanVO.fieldsVO.fieldVOList )
    	{
    		if( fieldVO.isLookupField )
    		{
    			if( currentMappingScanVO.fieldsVO.noOfLookupFields == count )
    			{
    				executeLookupScanInput( fieldVO, true );
    			}
    			else
    			{
    				executeLookupScanInput( fieldVO, false );
    			}
    			count++;
    		}
    	}
    }
    
    //Added By Prajyot Rumde on 03/12/12 for Implement Mandatory option
    private boolean isMandatory()
    {
        ScanVO currentMappingScanVO = getCurrentScanVO();
        if( currentMappingScanVO == null )
        {
            return true;
        }
        
       	for( FieldVO fieldVO : currentMappingScanVO.fieldsVO.fieldVOList )
       	{
       		return "Y".equalsIgnoreCase( fieldVO.mandatory );
       	}
    	return true;
    }
    
    //Added by Prajyot On 12-DEC-2012 [ Conditional Scan-Input and Lookup Scan-Input ]
    protected boolean isScanConditionSatisfied(String fieldName) {
		ScanCondition scanCondition = null;
		scanCondition = scanConditions.get(fieldName);
		if (scanCondition == null) {
			return true;
		}
		return eval(scanCondition.getCondition(), feedData);
	}

	protected boolean eval(String s, Map<String, String> parameters) {
		if (parameters != null) {
			for (Map.Entry<String, String> entry : parameters.entrySet()) {
				String key = entry.getKey();
				if (key.indexOf("~") != -1) {
					continue;
				}
				String value = entry.getValue();
				value = value.replaceAll("\\\"", "\\\\\"");
				s = key + " = \"" + value + "\"" + ";" + s;
			}
		}
		return eval(s);
	}
	
	protected native boolean eval(String s) /*-{
		try {
			var result = $wnd.eval(s);
			if (typeof result != "boolean") {
				$wnd.alert("Exception in eval(): Return type is " + (typeof result) + "\n\n" + s);
				return true; // continue with scan as usual
			}
			return result;
		} catch (e) {
			$wnd.alert("Exception in eval(): " + e + "\n\n" + s);
			return true; // continue with scan as usual
		}
	}-*/;

	  
    private void executeLookupScanInput( FieldVO fieldVO, final boolean isLastLookupField )
    {
    	final String scanField = fieldVO.data;
    	String scanValue = lookupData.get( scanField );
    	RequestBuilder requestBuilder = new RequestBuilder( RequestBuilder.POST, "/ibase/ScanLookupServlet?TABLE=" + fieldVO.lookupTable + "&FIELD=" + fieldVO.lookupCol + "&RETFIELD="+ fieldVO.lookupReturnCol +"&RET_COL=" + scanField + "&VALUE=" + scanValue );
    	try 
    	{
    		RequestCallback lookupRequestCallback = new RequestCallback() {
    			@Override
    			public void onResponseReceived(Request request, Response response) 
    			{
    				final String lookupResp = response.getText();
    				GWT.runAsync( new RunAsyncCallback() 
    				{

						@Override
    					public void onSuccess() 
    					{
    						String returnValue = "";
    						Document doc = XMLParser.parse( lookupResp );
    						if( doc == null )
    						{
    							return;
    						}
    						NodeList lookupDataNodeList = doc.getElementsByTagName("LOOKUP_DATA");
    						if( lookupDataNodeList != null && lookupDataNodeList.item(0) != null )
    						{
    							NodeList lookupNodeList = lookupDataNodeList.item(0).getChildNodes();
								if( lookupNodeList != null && lookupNodeList.getLength() > 0) 
    							{
    								Node lookupNode = lookupNodeList.item(0);
    								if( lookupNode != null && lookupNode.getFirstChild() != null )
    								{
    									returnValue = lookupNode.getFirstChild().getNodeValue();
    									lookupData.put(scanField, returnValue);
    								}
    							}
    						}
    						if( isLastLookupField )
    						{
    							doScan();
    						}
    					}
    					
    					@Override
    					public void onFailure( Throwable reason ) 
    					{
    						Window.alert( "executeLookupScanInput onFailure : Asynchronous Failure" );
    					}	
    				});
    			}
    			
    			@Override
    			public void onError(Request request, Throwable exception) 
    			{
    				Window.alert( "executeLookupScanInput onError : Invalid Scanning Parameter");
    			}
    		};
    		requestBuilder.sendRequest("", lookupRequestCallback);
    	}
    	catch (RequestException e) 
    	{
    		Window.alert( "executeLookupScanInput RequestException : [" + e.getMessage() + "]" );
    		e.printStackTrace();
    	}
	}

    private void createLookupData()
    {
    	lookupData = new HashMap<String, String>();
        List< String > fieldNameList = extractFieldNames();
        List< String > scanValuesList = extractScanValues();
        for( int i = 0; i < fieldNameList.size(); i++ )
        {
            String fieldName = fieldNameList.get( i );
            String fieldValue = scanValuesList.get( i );
            lookupData.put(fieldName, fieldValue);
        }
    }
    //Added by Prajyot On 12-DEC-2012 [ Conditional Scan-Input and Lookup Scan-Input ]
    
   	//Added by Prajyot On 15-FEB-2013 [To skip scan if enter value is "X" or "x" ]Starts
    public void setResetScanOption( boolean isResetable )
    {
    	this.isResetable = isResetable;
    }
   	//Added by Prajyot On 15-FEB-2013 [To skip scan if enter value is "X" or "x" ]
    
     //Added by Dnyaneshwar Chavan On 08-Aug-13 [ The current scan input field name is an 'isempty' then only accept values are 'Y' or 'N'  ] Start
    /**
     *  This method check the current scan input field name is an 'isempty' with given fieldVOList.
     *  
     *  @param fieldVOList the current fieldVOList.
     *  @return true if current scan input field is an 'isempty' otherwise false.
     *  
     * */
    public boolean isemptyField ( List< FieldVO > fieldVOList )
    {
    	boolean returnValue = false;
    	for( FieldVO fieldVO : fieldVOList )
    	{
    		String data = fieldVO.data ;
    		if ( data != null && !"".equalsIgnoreCase( data ) )
    		{
    			returnValue = "isempty".equalsIgnoreCase( data );
    			break;
    		}
    	}
    	return returnValue;
    }
    //Added by Dnyaneshwar Chavan On 08-Aug-13 [ The current scan input field name is an 'isempty' then only accept values are 'Y' or 'N'] End
}
    
