package ibase.webitm.ejb.mfg;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.w3c.dom.Document;

@javax.ejb.Stateless
public class WorkOrdRcpDetPostSave extends ValidatorEJB implements WorkOrdRcpDetPostSaveLocal,WorkOrdRcpDetPostSaveRemote
{
	public String postSave(String winName,String editFlag,String tranId,  String xtraParams,Connection conn) throws RemoteException,ITMException
	{

		System.out.println(">>>>>>>>>>>>>>CONNECTION"+conn);
		System.out.println("------------ WorkOrdRcpPostSave postSave method called-----------------tranId : "+ tranId);		
		Document dom = null;
		String errString="";
		
		
		try
		{
			
			    conn = null;
			    ConnDriver connDriver = new ConnDriver();
			    conn = connDriver.getConnectDB("DriverITM");
			    connDriver= null;
				errString = postSave(dom,tranId,editFlag,xtraParams,conn);
			
			
		}
		catch(Exception e)
		{
			System.out.println("Exception : WorkOrdRcpPostSave : postSave : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}		
		return errString;
	}
	
	public String postSave(Document dom,String tranId,String editflag,String xtraParams,Connection conn)
	{
		System.out.println("post save dom data1 ---------------:"+dom);
		String sql = "", error = "", quantity = "", grossWeight = "", tareWeight = "", netWeight = "", noArt = "";
		int cnt1 = 0;
		
		 
		PreparedStatement pstmt = null;
		ResultSet rs=null;
		try
		{
			
			sql = "select sum(coalesce(quantity,0)), sum(coalesce(gross_weight,0)), sum(coalesce(tare_weight,0)), " +
				  " sum(coalesce(net_weight,0)), sum(coalesce(no_art,0)) from workorder_rcp_det where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			
			if(rs.next()){
				quantity = rs.getString(1);
				grossWeight = rs.getString(2);
				tareWeight = rs.getString(3);
				netWeight = rs.getString(4);
				noArt = rs.getString(5);
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			
			sql = "update workorder_receipt set quantity = ?, gross_weight = ?, tare_weight = ?, net_weight = ?, no_art = ? where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, quantity);
			pstmt.setString(2, grossWeight);
			pstmt.setString(3, tareWeight);
			pstmt.setString(4, netWeight);
			pstmt.setString(5, noArt);
			pstmt.setString(6, tranId);
			cnt1 = pstmt.executeUpdate();
			System.out.println(">>>>>>>successfully updated record bom post save cnt1:" + cnt1);
			conn.commit();
			pstmt.close();
			pstmt = null;
			
		}catch(Exception e)
		{
			try {
				System.out.println(">>>>>>>>>>>>In catch Before rollback>>>");
				conn.rollback();
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
				error=e1.getMessage();
			}
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			error=e.getMessage();
            
		}	
		finally
		{
			try {
				System.out.println(">>>>>>>>>>>>In finally Before Commit>>>");
				if(pstmt != null)
					pstmt.close();
				if(conn != null)
				{
					conn.close();	
				}
				
				if(rs != null)
					rs.close();
				
				pstmt = null;
				rs = null;
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				error=e.getMessage();
			}		
		}
		
		return error;
		
	}
	
}
