package ibase.webitm.ejb.sys;

import java.io.*;
import java.sql.*;
import java.util.*;
import java.lang.*;
import javax.ejb.*;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import javax.naming.InitialContext;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.utility.CommonConstants;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.TransIDGenerator;

import org.xml.sax.InputSource;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

public class UserRightsPrc extends ProcessEJB implements  UserRightsPrcLocal , UserRightsPrcRemote // SessionBean
{
	GenericUtility genericUtility = GenericUtility.getInstance();
	CommonConstants commonConstants = new CommonConstants();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	Connection conn = null;

	HashMap userRightsMap = null;
	HashMap winNameMap = null;
	HashMap menuNameMap = null;

	String profileId = null;
	String processStr = null;

	/*public void ejbCreate() throws RemoteException, CreateException
	{

	}
	public void ejbRemove()
	{
	}
	public void ejbActivate()
	{
	}
	public void ejbPassivate()
	{
	}*/
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;
		try
		{
			System.out.println("xmlString   ["+xmlString+"]");
			System.out.println("xmlString2   ["+xmlString2+"]");
			System.out.println("windowName   ["+windowName+"]");
			System.out.println("xtraParams   ["+xtraParams+"]");

			if(xmlString != null && xmlString.trim().length()!=0 )
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :UserRightsEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		return rtrStr;
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{

		Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//StringBuffer retTabSepStrBuff = new StringBuffer();
		StringBuffer retTabSepStrBuff = new StringBuffer("<?xml version = \"1.0\"?>");
		retTabSepStrBuff.append("<DocumentRoot>");
		retTabSepStrBuff.append("<description>").append("Datawindow Root").append("</description>");
		retTabSepStrBuff.append("<group0>");
		retTabSepStrBuff.append("<description>").append("Group0 description").append("</description>");
		retTabSepStrBuff.append("<Header0>");
		String userId = null;
		Object date = null;
		String sql = "";
		String errCode = "";
		String errString = "";
		String resultString = "";
		String curUserId = "", curProfileId = "";

		//String profileId =null;

		double quantity = 0.0,pendingQty = 0.0;
		int count = 0, usrLev = 0;
		String tApplication = null;
		String key = null;
		String tWinName = null;
		String tMenuName = null;
		String sqlStr = "";
		try
		{
			if(conn == null)
			{
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				connDriver = null;
			}

			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			profileId = genericUtility.getColumnValue("profile_id", headerDom);
			//System.out.println("profileId ::- "+ profileId);
			// 24/03/12 manoharan get the current logged in user and show only the menus for which the current user has rights
			curUserId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");  
			System.out.println("Current userid curUserId ["+ curUserId + "] profileId [" + profileId + "]");
			if (curUserId == null || curUserId.trim().length() == 0)
			{
				retTabSepStrBuff.append(" \t");

			/*	//LEVEL_1
				retTabSepStrBuff.append(" \t");

				//LEVEL_2
				retTabSepStrBuff.append(" \t");

				//LEVEL_3
				retTabSepStrBuff.append(" \t");

				//LEVEL_4
				retTabSepStrBuff.append(" \t");

				//LEVEL_5
				retTabSepStrBuff.append(" \t");

				//DESCR

				retTabSepStrBuff.append(" \t");

				//RIGHTS
				retTabSepStrBuff.append(" \t");

				//WIN_NAME
				retTabSepStrBuff.append(" \t");

				retTabSepStrBuff.append(" ").append("\t");
				retTabSepStrBuff.append("\n");		
				*/				
				retTabSepStrBuff.append("</Header0>");
				retTabSepStrBuff.append("</group0>");
				retTabSepStrBuff.append("</DocumentRoot>");
				
				resultString = retTabSepStrBuff.toString();
			}
			else
			{

				sql = " select profile_id,usr_lev from users where code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,curUserId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					curProfileId = rs.getString("profile_id");
					usrLev = rs.getInt("usr_lev");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				System.out.println("Current curProfileId ["+ curProfileId + "] usrLev [" + usrLev + "]");

				////////////////
				//If profile Id is blank or doesnt exist in the User_Rights table then prompt error
				//String profileSql = " select count(*) " +
				//		" from user_rights  " +
				//		" where profile_id = '" + profileId + "' " ;

				String profileSql = " select count(1) " +
						" from gencodes  " +
						" where fld_name = 'PROFILE_ID' and fld_value = '" + profileId + "' " ;

				int profileCount = 0;
				System.out.println("ProfileSql :: " + profileSql);

				PreparedStatement pProfileStmt = null;
				ResultSet profileRs = null;

				pProfileStmt = conn.prepareStatement(profileSql);

				profileRs = pProfileStmt.executeQuery();

				if(profileRs.next())
				{
					profileCount = profileRs.getInt(1);
					System.out.println("Profile Count = " + profileCount);
				}

				profileRs.close();
				profileRs = null;

				pProfileStmt.close();
				pProfileStmt = null;
				///////////////

				if(profileCount == 0)
				{
					errString = itmDBAccessEJB.getErrorString("","PNOTEXIST","","",conn);
					return errString;
				}

				userRightsMap = new HashMap();
				winNameMap = new HashMap();
				menuNameMap = new HashMap();

				sqlStr = " SELECT ITM2MENU.APPLICATION,   							" +
						"         ITM2MENU.LEVEL_1,									" +
						"         ITM2MENU.LEVEL_2,   								" +
						"         ITM2MENU.LEVEL_3,   								" +
						"         ITM2MENU.LEVEL_4,   								" +
						"         ITM2MENU.LEVEL_5,   								" +
						"         ITM2MENU.WIN_NAME,   								" +
						"         ITM2MENU.DESCR,   								" +
						"         (SELECT USER_RIGHTS.RIGHTS FROM USER_RIGHTS 		" +  
						"			WHERE USER_RIGHTS.PROFILE_ID = ? " +
						"			AND USER_RIGHTS.APPLICATION = ITM2MENU.APPLICATION " +
						"			AND USER_RIGHTS.MENU_ROW = ITM2MENU.LEVEL_1			" +
						"			AND USER_RIGHTS.MENU_COL = ITM2MENU.LEVEL_2			" +
						"			AND USER_RIGHTS.MENU_SUBCOL = ITM2MENU.LEVEL_3		" +
						"			AND USER_RIGHTS.LEVEL_4 = ITM2MENU.LEVEL_4			" +
						"			AND USER_RIGHTS.LEVEL_5 = ITM2MENU.LEVEL_5			" +
						"			  ) AS RIGHTS										" +
						"         FROM ITM2MENU " ;
				if (usrLev > 0 )
				{
					sqlStr = sqlStr + " where exists (select 1 from user_rights u  "
							+ " where u.profile_id in ('" + curProfileId + "','" + profileId + "') "
							+ " and u.application = ITM2MENU.application  "
							+ " and u.menu_row = ITM2MENU.level_1 "
							+ " and u.menu_col = ITM2MENU.level_2 "
							+ " and u.menu_subcol = ITM2MENU.level_3 "
							+ " and u.level_4 = ITM2MENU.level_4 "
							+ " and u.level_5 = ITM2MENU.level_5) " ;
				}			
				sqlStr = sqlStr + " 	ORDER BY ITM2MENU.APPLICATION, ITM2MENU.LEVEL_1, ITM2MENU.LEVEL_2, ITM2MENU.LEVEL_3, ITM2MENU.LEVEL_4, ITM2MENU.LEVEL_5 ";


				pstmt = conn.prepareStatement(sqlStr);
				pstmt.setString(1,profileId);
				//System.out.println("The getData sql is:-"+ sqlStr);
				rs = pstmt.executeQuery();
				while (rs.next())
				{

					tApplication = rs.getString(1);

					if(tApplication != null)
						key = tApplication + ":" + rs.getInt(2) + ":" + rs.getInt(3) + ":" + rs.getInt(4)
						+ ":" + rs.getInt(5) + ":" + rs.getInt(6);

					// 14/03/14 manoharan to avoid link names
					tWinName = rs.getString("WIN_NAME");
					tWinName = (tWinName==null?"":tWinName);
					if (tWinName.indexOf("/ibase/") > -1)
					{
						continue;
					}
						
					retTabSepStrBuff.append("<Detail2>");
					//APPLICATION
					//retTabSepStrBuff.append(tApplication==null?"":rs.getString(1)).append("\t");
					retTabSepStrBuff.append("<application>").append("<![CDATA[" + (rs.getString("APPLICATION")==null?"":rs.getString("APPLICATION")) +"]]>").append("</application>");

					//LEVEL_1
					//retTabSepStrBuff.append(rs.getInt(2)).append("\t");
					retTabSepStrBuff.append("<level_1>").append("<![CDATA[" + rs.getInt("LEVEL_1") +"]]>").append("</level_1>");

					//LEVEL_2
					//retTabSepStrBuff.append(rs.getInt(3)).append("\t");
					retTabSepStrBuff.append("<level_2>").append("<![CDATA[" + rs.getInt("LEVEL_2") +"]]>").append("</level_2>");

					//LEVEL_3
					//retTabSepStrBuff.append(rs.getInt(4)).append("\t");
					retTabSepStrBuff.append("<level_3>").append("<![CDATA[" + rs.getInt("LEVEL_3") +"]]>").append("</level_3>");

					//LEVEL_4
					//retTabSepStrBuff.append(rs.getInt(5)).append("\t");
					retTabSepStrBuff.append("<level_4>").append("<![CDATA[" + rs.getInt("LEVEL_4") +"]]>").append("</level_4>");

					//LEVEL_5
					//retTabSepStrBuff.append(rs.getInt(6)).append("\t");
					retTabSepStrBuff.append("<level_5>").append("<![CDATA[" + rs.getInt("LEVEL_5") +"]]>").append("</level_5>");

					//DESCR
					tMenuName = rs.getString("DESCR");
					//retTabSepStrBuff.append(rs.getString(8)==null?"":rs.getString(8)).append("\t");
					retTabSepStrBuff.append("<descr>").append("<![CDATA[" + (rs.getString("DESCR")==null?"":rs.getString("DESCR")) +"]]>").append("</descr>");
					//RIGHTS
					//retTabSepStrBuff.append(rs.getString(9)==null?"":rs.getString(9)).append("\t");
					retTabSepStrBuff.append("<rights>").append("<![CDATA[" + (rs.getString("RIGHTS")==null?"":rs.getString("RIGHTS")) +"]]>").append("</rights>");

					//WIN_NAME
					tWinName = rs.getString("WIN_NAME");
					//retTabSepStrBuff.append(rs.getString(7)==null?"":rs.getString(7)).append("\t");
					retTabSepStrBuff.append("<win_name>").append("<![CDATA[" + (rs.getString("WIN_NAME")==null?"":rs.getString("WIN_NAME")) +"]]>").append("</win_name>");
					//retTabSepStrBuff.append(" ").append("\t");
					//retTabSepStrBuff.append("\n");

					retTabSepStrBuff.append("</Detail2>");

					System.out.println("Key  getdata function ["+key+"]");
					System.out.println("rights in function ["+ rs.getString("RIGHTS") +"]");
					userRightsMap.put(key, rs.getString("RIGHTS"));
					if(tWinName != null && tWinName.trim().length() > 2)
						winNameMap.put(key, tWinName.trim().substring(2, tWinName.trim().length()));

					menuNameMap.put(key, tMenuName);
				}//while
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				retTabSepStrBuff.append("</Header0>");
				retTabSepStrBuff.append("</group0>");
				retTabSepStrBuff.append("</DocumentRoot>");
			} 
			// end 24/03/12 manoharan
		}//try
		catch (SQLException e)
		{
			System.out.println("SQLException ::" + sqlStr + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);// added by akhilesh on 31/oct/12
		}
		catch(Exception ex)
		{
			System.out.println("Exception []::" + ex.getMessage());
			ex.printStackTrace();
			throw new ITMException(ex);// added by akhilesh on 31/oct/12
		}
		finally
		{
			try
			{
				if(rs != null){rs.close();// added by akhilesh on 08/nov/12
				rs = null;}

				if(pstmt != null){pstmt.close();// added by akhilesh on 08/nov/12
				pstmt = null;}

				if(conn != null){conn.close();// added by akhilesh on 08/nov/12
				conn = null;}

			}
			catch(Exception e){
				throw new ITMException(e);// added by akhilesh on 31/oct/12
			}
		}

		resultString = retTabSepStrBuff.toString();

		return resultString;
	}//getData()

	//process()
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;
		System.out.println("xmlString2-->"+ xmlString2);
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("xmlString   ["+xmlString+"]");
			System.out.println("xmlString2   ["+xmlString2+"]");
			System.out.println("windowName   ["+windowName+"]");
			System.out.println("xtraParams   ["+xtraParams+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
			}
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :UserRightsEJB :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		processStr = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pInsertStmt = null;
		PreparedStatement pUpdateStmt = null;
		PreparedStatement pDeleteStmt = null;
		PreparedStatement pSelectStmt = null;// added by akhilesh on 31/oct/12
		Statement stmt = null;
		ResultSet rs = null;
		java.sql.Timestamp orderDate = new java.sql.Timestamp(System.currentTimeMillis());
		java.sql.Timestamp udfDate = null;
		String returnString = "";

		//Declaring fields of the table User_Rights
		String profileId = null;
		String application = null;
		String level1 = null, level2 = null, level3 = null, level4 = null, level5 = null;
		String menuName = null;
		String rights = null;
		String accFilt = null;
		String defFilt = null;
		String objName = null;
		String winName = null;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
		String rightChar = "";

		boolean bDetailFound = false;
		int parentNodeListLength = 0;
		int childNodeListLength = 0, insertCount =0, updateCount =0, deleteCount = 0;
		String delSql = "";

		profileId = genericUtility.getColumnValue("profile_id", headerDom);
		System.out.println("profileId..............."+profileId);

		String batchInesertSql = "INSERT INTO USER_RIGHTS ( PROFILE_ID, APPLICATION, MENU_ROW, MENU_COL, MENU_SUBCOL, LEVEL_4, LEVEL_5, MENU_NAME, RIGHTS, OBJ_NAME)"
				+ " VALUES ( '" + profileId + "' , ?, ?, ?, ?, ?, ?, ?, ?,? )";

		System.out.println("Insert Sql :: " + batchInesertSql);

		String batchUpdateSql = "UPDATE USER_RIGHTS SET " +
				"	RIGHTS = ?, 		" +
				"	OBJ_NAME = ?		" +
				" WHERE PROFILE_ID = '" + profileId + "' " +
				"   AND APPLICATION = ? " +
				"   AND MENU_ROW = ? 	" +
				"   AND MENU_COL = ? 	" +
				"   AND MENU_SUBCOL = ? " +
				"   AND LEVEL_4 = ? 	" +
				"   AND LEVEL_5 = ?	 	";

		String batchDeleteSql = " DELETE FROM USER_RIGHTS " +
				"  WHERE PROFILE_ID = '" + profileId + "' " +
				"   AND APPLICATION = ?   " +
				"   AND MENU_ROW = ?	  " +
				"   AND MENU_COL = ?	  " +
				"   AND MENU_SUBCOL = ?   " +
				"   AND LEVEL_4 = ? 	  " +
				"   AND LEVEL_5 = ?	 	  ";

		String searchKey = null;
		int operation = 0;

		try
		{
		

			if(conn == null)
			{
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				connDriver = null;
				pInsertStmt = conn.prepareStatement(batchInesertSql);
				pUpdateStmt = conn.prepareStatement(batchUpdateSql);
				pDeleteStmt = conn.prepareStatement(batchDeleteSql);
			}
			//////////////////////////////////////////////////////////////////////
			// 08/10/13 manoharan re initialise if necessary
			//System.out.print("winNameMap before ["+ winNameMap + "]");
			//System.out.print("menuNameMap before [" + menuNameMap + "]");
			menuNameMap = null;
			winNameMap = null;
			userRightsMap = null;
			
			if (userRightsMap == null)
			{
				userRightsMap = new HashMap();
			}
			if (winNameMap == null)
			{
				winNameMap = new HashMap();
			}
			if (menuNameMap == null)
			{
				menuNameMap = new HashMap();
				populateMap(headerDom, detailDom, xtraParams);
			}
			populateMap(headerDom, detailDom, xtraParams);
			System.out.print("winNameMap after ["+ winNameMap + "]");
			System.out.print("menuNameMap after [" + menuNameMap + "]");
			// end 08/10/13 manoharan ////////////////////////////////////////////////////////////////////


			parentNodeList = detailDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println("ParentNodeListLength....::-  "+parentNodeListLength);
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{
				operation = 0;
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("ChildNodeListLength.........:-"+ childNodeListLength);
				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{

					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();

					if (childNodeName.equals("application"))
					{
						if (childNode.getFirstChild() != null) // ****************
						{
							application = (childNode.getFirstChild().getNodeValue()).trim();
							System.out.println("APPLICATION:::::["+ application+"]");
						}

					}

					if (childNodeName.equals("level_1"))
					{
						if (childNode.getFirstChild() != null) // ****************
						{
							level1 = (childNode.getFirstChild().getNodeValue()).trim();
							System.out.println("level1:::::"+ level1);
						}

					}
					if (childNodeName.equals("level_2"))
					{
						if (childNode.getFirstChild() != null) // ****************
						{
							level2 = (childNode.getFirstChild().getNodeValue()).trim();
						}
						System.out.println("level2:::::"+ level2);
					}

					if (childNodeName.equals("level_3"))
					{
						if (childNode.getFirstChild() != null) // ****************
						{
							level3 = (childNode.getFirstChild().getNodeValue()).trim();
						}
						System.out.println("level3:::::"+ level3);
					}
					if (childNodeName.equals("level_4"))
					{
						if (childNode.getFirstChild() != null) // ****************
						{
							level4 = (childNode.getFirstChild().getNodeValue()).trim();
						}
						System.out.println("level_4:::::"+ level4);
					}
					if (childNodeName.equals("level_5"))
					{

						if (childNode.getFirstChild() != null) // ****************
						{
							if (childNode.getFirstChild() != null) // ****************
							{
								level5 = (childNode.getFirstChild().getNodeValue()).trim();
							}
						}
						System.out.println("level_5:::::" + level5);
					}

					if (childNodeName.equals("descr"))
					{
						if (childNode.getFirstChild() != null) // ****************
						{
							menuName = (childNode.getFirstChild().getNodeValue()).trim();
							System.out.println("menu_name:::"+ menuName);
						}

					}

					if (childNodeName.equals("rights"))
					{
						/*if (childNode.getFirstChild() != null) // ****************
						{*/// commented  by akhilesh on 31/oct/12

						// added by akhilesh on 31/oct/12 for validation rights
						if (childNode.getFirstChild() != null )
						{
							rights = (childNode.getFirstChild().getNodeValue());
						}
						else
						{
							rights ="";
						}
					}
				}
				//winName=this.genericUtility.getColumnValue("win_name", detailDom);
				winName = genericUtility.getColumnValueFromNode("win_name",detailDom.getElementsByTagName("Detail2").item(selectedRow));// added by akhilesh on 22/nov/12
						
				System.out.println("windowName ::::"+ windowName);
				System.out.println("rights and winName ::::"+ rights+""+winName);

				if(winName.trim().length() > 2)
				{
					objName =winName.substring(2);
				}
				System.out.println("objName ::::"+ objName);
				// commented by manoharan 26/02/13 comma delimiter should not be there in the rights
				//added by akhilesh on 08/oct/12
				//String rightStr[] = rights.split(",");
				//for(int i= 0 ; i<rightStr.length; i++)
				//{
					ArrayList relArray = new ArrayList(); // added by akhilesh on 31/oct/12
					ArrayList relArray1 = new ArrayList(); // added by akhilesh on 07/nov/12
					
					String selectSql = "SELECT DISTINCT (RIGHTS_CHAR) FROM OBJ_LINKS WHERE OBJ_NAME = ?";
					pSelectStmt =conn.prepareStatement(selectSql);
					pSelectStmt.setString(1,objName);
					rs = pSelectStmt.executeQuery();
					while(rs.next())
					{
						relArray.add(rs.getString(1));
					}
					System.out.println("relArray and rights value 1 ["+relArray + "]");		

					rs.close();
					rs = null;
					pSelectStmt.close();
					pSelectStmt = null;

					// added by akhilesh on 07/nov/12
					String selectSql1 = "SELECT DISTINCT (RIGHTS_CHAR) FROM OBJ_ACTIONS WHERE OBJ_NAME = ?";
					pSelectStmt =conn.prepareStatement(selectSql1);
					pSelectStmt.setString(1,objName);
					rs = pSelectStmt.executeQuery();
					while(rs.next())
					{
						relArray.add(rs.getString(1));
					}
					relArray.add("V");
					relArray.add("#");
					relArray.add("$");
					relArray.add("*");
					relArray.add("A"); // 11/10/13 manoharan y default add add/edit rights
					relArray.add("E");// 11/10/13 manoharan y default add add/edit rights
					
					relArray.add("C"); //added by akhilesh on 26/JULY/2013 for Copy Transaction option 
					relArray.add("M"); //added by akhilesh on 24/JULY/2013 for Comments option
					
					relArray.add("T"); //added by akhilesh on 24/JULY/2013 for attachment option
					
					relArray.add("B"); //added by Sanjaya on 27/Nov/2013[WS3GSUN010] for delete attachment on right basis
					relArray.add("J"); //added by Sanjaya on 24/JULY/2013[WS3GSUN010] for delete attachment on right basis
					relArray.add("U"); //added by Sanjaya on 24/JULY/2013[WS3GSUN010] for delete attachment on right basis
					
					System.out.println("relArray and rights value 2 ["+relArray + "]");		

					rs.close();
					rs = null;
					pSelectStmt.close();
					pSelectStmt = null;
					//ended by akhilesh	
					rightChar = "";
					for (int iCtr = 0; iCtr < rights.trim().length(); iCtr++)
					{
						rightChar = rights.substring(iCtr,iCtr+1);
						System.out.println("iCtr [" + iCtr + "] relArray ["+relArray+" ] rightChar ["+ rightChar + "] rights [" + rights + "]");		
						//if(!(relArray1.contains(rightStr[i]) || relArray.contains(rightStr[i]) || "*".equals(rightStr[i]) || "".equals(rightStr[i])))
						//if(!(relArray.contains(rightChar) || "*".equals(rightChar) || "".equals(rightChar) || "$".equals(rightChar) || "#".equals(rightChar) ))
						if(!relArray.contains(rightChar))
						{
							System.out.println("r************"+relArray+""+rights);		
							returnString="VTRIGHT";
							returnString = itmDBAccessEJB.getErrorString("",returnString,"","",conn);
							return returnString;
						}
					}
				//}
				//ended by akhilesh	
				
				
				/*}commented  by akhilesh on 31/oct/12
				else
					rights = null;*/
				

				// 01/06/10 manoharan
				if (level1 == null || level1.trim().length() == 0)
				{
					level1 = "0";
				}
				if (level2 == null || level2.trim().length() == 0)
				{
					level2 = "0";
				}
				if (level3 == null || level3.trim().length() == 0)
				{
					level3 = "0";
				}
				if (level4 == null || level4.trim().length() == 0)
				{
					level4 = "0";
				}
				if (level5 == null || level5.trim().length() == 0)
				{
					level5 = "0";
				}
				// end 01/06/10 manoharan
				searchKey = application + ":" + level1 + ":" + level2 + ":" + level3 + ":" + level4 + ":" + level5;
				//
				//get all submenu if found
				ArrayList subMenuList = null;

				subMenuList = getAllSubMenu(application, Integer.parseInt(level1), Integer.parseInt(level2), Integer.parseInt(level3), Integer.parseInt(level4), Integer.parseInt(level5), conn);

				System.out.println("SubMenu List :: " + subMenuList.toString());
				//

				//operation = searchUserRight(searchKey, rights);
				//if(subMenuList != null) // 08/10/13 manoharan commented 
				if(subMenuList != null && subMenuList.size() > 0)
				{
					for(int index = 0; index < subMenuList.size(); index++)
					{
						String searchStr = null;
						searchStr = (String)subMenuList.get(index);
						objName = "";
						System.out.print("searchStr [" + searchStr +"]["+index+"]["+subMenuList.size() + "]");
						//System.out.print("winNameMap ["+ winNameMap + "]");
						//System.out.print("menuNameMap [" + menuNameMap + "]");
						objName = (String)winNameMap.get(searchStr);
						System.out.print("obj name @@@@@@@@@@@@"+objName+""+searchStr+""+index+""+subMenuList.size());
						//Get parameters from searchStr
						StringTokenizer subMenuToken = new StringTokenizer(searchStr, ":");

						if(subMenuToken.hasMoreTokens())
							application = subMenuToken.nextToken();
						if(subMenuToken.hasMoreTokens())
							level1 = subMenuToken.nextToken();
						if(subMenuToken.hasMoreTokens())
							level2 = subMenuToken.nextToken();
						if(subMenuToken.hasMoreTokens())
							level3 = subMenuToken.nextToken();
						if(subMenuToken.hasMoreTokens())
							level4 = subMenuToken.nextToken();
						if(subMenuToken.hasMoreTokens())
							level5 = subMenuToken.nextToken();

						menuName = (String)menuNameMap.get(searchStr);

						System.out.println("SerarchStr = " + searchStr + " :: " + application + " : " + level1 + " : " + level2 + " : " + level3 + " : " + level4 + " : " + level5);
						// 01/06/10 manoharan
						//operation = searchUserRight(searchStr, rights);
						operation = searchUserRight(profileId, application,Integer.parseInt(level1),Integer.parseInt(level2),Integer.parseInt(level3),Integer.parseInt(level4),Integer.parseInt(level5),rights,conn);
						// end 01/06/10 manoharan
						System.out.println("Operation ["+ operation +"]");
						/*
								1 - insert
								2 - update
								3 - delete
						 */

						if(operation == 1 && rights.trim().length() > 0)
						{
							//pInsertStmt.setString(1, profileId);
							pInsertStmt.setString(1, application);
							pInsertStmt.setInt(2, Integer.parseInt(level1));
							pInsertStmt.setInt(3, Integer.parseInt(level2));
							pInsertStmt.setInt(4, Integer.parseInt(level3));
							pInsertStmt.setInt(5, Integer.parseInt(level4));
							pInsertStmt.setInt(6, Integer.parseInt(level5));
							pInsertStmt.setString(7, menuName);
							pInsertStmt.setString(8, rights.trim());
							pInsertStmt.setString(9, objName);
							insertCount++;
							pInsertStmt.addBatch();
						}
						else if(operation == 2)
						{
							pUpdateStmt.setString(1, rights.trim());
							//pUpdateStmt.setString(2, profileId);
							pUpdateStmt.setString(2, objName);
							pUpdateStmt.setString(3, application);
							pUpdateStmt.setInt(4, Integer.parseInt(level1));
							pUpdateStmt.setInt(5, Integer.parseInt(level2));
							pUpdateStmt.setInt(6, Integer.parseInt(level3));
							pUpdateStmt.setInt(7, Integer.parseInt(level4));
							pUpdateStmt.setInt(8, Integer.parseInt(level5));
							updateCount++;
							pUpdateStmt.addBatch();
						}
						else if(operation == 3)
						{
							//pDeleteStmt.setString(1, profileId);
							pDeleteStmt.setString(1, application);
							pDeleteStmt.setInt(2, Integer.parseInt(level1));
							pDeleteStmt.setInt(3, Integer.parseInt(level2));
							pDeleteStmt.setInt(4, Integer.parseInt(level3));
							pDeleteStmt.setInt(5, Integer.parseInt(level4));
							pDeleteStmt.setInt(6, Integer.parseInt(level5));
							deleteCount++;
							pDeleteStmt.addBatch();
						}
					}//End of subMenuList iteration for loop
				}//End of if subMenuList is not null
				//}
			}//outer for

			if (insertCount > 0)
			{
				System.out.println("Before Delete Batch");
				pInsertStmt.executeBatch();
				System.out.println("After Insert Batch" );
			}

			if (updateCount > 0)
			{
				System.out.println("Before Update Batch");
				pUpdateStmt.executeBatch();
				System.out.println("After Update Batch = ");
			}

			if (deleteCount > 0)
			{
				System.out.println("Before Delete Batch");
				pDeleteStmt.executeBatch();
				System.out.println("After Delete Batch = ");
			}

			conn.commit();
			System.out.println("After Commit");
		}
		catch(BatchUpdateException be)
		{
			be.printStackTrace();
			returnString = be.getMessage();
			System.out.println("BatchUpdateException :RunMRPPrcEJB: CreatePlanDemand(ADPElement)" + returnString);
			System.out.println("Detail Exception : " + be.getNextException());
			throw new ITMException(be);// added by akhilesh on 31/oct/12
		}
		catch (SQLException ex)
		{
			returnString = ex.getMessage();
			try{conn.rollback();
			}catch(Exception e){
				throw new ITMException(e);// added by akhilesh on 31/oct/12
			}
			ex.printStackTrace();

			throw new ITMException(ex);// added by akhilesh on 31/oct/12
		}
		catch (Exception e)
		{
			returnString = e.getMessage();
			try{
				conn.rollback();
			}catch(Exception ec){
				throw new ITMException(ec);// added by akhilesh on 31/oct/12
			}

			e.printStackTrace();
			throw new ITMException(e);// added by akhilesh on 31/oct/12
		}
		finally
		{
			try
			{
				userRightsMap = null;
				winNameMap = null;
				menuNameMap = null;

				profileId = null;

				pInsertStmt.close();
				pInsertStmt = null;
				pUpdateStmt.close();
				pUpdateStmt = null;
				pDeleteStmt.close();
				pDeleteStmt = null;

				conn.close();
				conn = null;

			}catch(Exception e){
				throw new ITMException(e);// added by akhilesh on 31/oct/12
			}
			//return returnString;
		}

		if (returnString == null || returnString.trim().length() == 0)
		{
			System.out.println("errString is null************** ");
			returnString="VTCOMPL";
			returnString = itmDBAccessEJB.getErrorString("",returnString,"","",conn);
			return returnString;
		}
		else
		{
			System.out.println("errString is not  null ***************");
			returnString="VTPRCERR";
			returnString = itmDBAccessEJB.getErrorString("",returnString,"","",conn);
			return returnString;
		}

	}//process()

	/*	1 - insert
		2- update
		3-delete
		Searches HashMap for availability of rights for searchKey
		if Not Found and rights is not null then
			return 1
		else if Found and rights is not null then
			return 2
		else if Found and rights = null
			return 3
	 */
	// 01/06/10 manoharan
	int searchUserRight(String profileId, String application,int level1,int level2,int level3,int level4,int level5, String rights,Connection conn) throws Exception
	{

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String alreadyExists =  "N";
		String foundRights = null;
		int operation = -1;
		String sql = " SELECT  RIGHTS FROM USER_RIGHTS "
			+ "	WHERE PROFILE_ID = ? "
			+ "	AND APPLICATION = ? "
			+ "	AND MENU_ROW = ? "
			+ "	AND MENU_COL = ? "
			+ "	AND MENU_SUBCOL = ? "
			+ "	AND LEVEL_4 = ? "
			+ "	AND LEVEL_5 = ? ";
		try {
			pstmt = conn.prepareStatement(sql);


			pstmt.setString(1,profileId);
			pstmt.setString(2,application);
			pstmt.setInt(3,level1);
			pstmt.setInt(4,level2);
			pstmt.setInt(5,level3);
			pstmt.setInt(6,level4);
			pstmt.setInt(7,level5);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				foundRights = rs.getString(1);
				alreadyExists =  "Y";
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//foundRights = (String) userRightsMap.get(searchKey);
			System.out.println("Found rights in function before ["+foundRights+"] rights [" + rights +"] alreadyExists [" + alreadyExists + "]");
			if (foundRights != null && foundRights.trim().length() == 0)
			{
				foundRights = null;
			}
			if (rights != null && rights.trim().length() == 0)
			{
				rights = null;
			}
			System.out.println("Found rights in function after ["+foundRights+"] rights [" + rights +"] alreadyExists [" + alreadyExists + "]");
			
			if( (foundRights == null || foundRights.trim().length() == 0) && (rights != null && rights.trim().length() > 0 )  && "N".equals(alreadyExists))
				operation = 1;
			else if(( (foundRights != null && foundRights.trim().length() > 0 ) && (rights != null && rights.trim().length() > 0 ) ) || ("Y".equals(alreadyExists) && (foundRights == null || foundRights.trim().length() == 0 ) && (rights != null && rights.trim().length() > 0 ) ) )
				operation = 2;
			else if((foundRights != null && foundRights.trim().length() > 0 ) && (rights == null || rights.trim().length() == 0) && "Y".equals(alreadyExists))
				operation = 3;
				
			System.out.println("Found rights in function operation [" + operation + "] foundRights ["+foundRights+"] rights [" + rights +"] alreadyExists [" + alreadyExists + "]");
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);// added by akhilesh on 31/oct/12
		}
		finally
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}

		return operation;
	}
	// end 01/06/10 manoharan
	int searchUserRight(String searchKey, String rights) throws Exception
	{
		String foundRights = null;
		int operation = -1;
		try {
		


			System.out.println("searchKey  in function ["+searchKey+"]");
			System.out.println("rights in function ["+rights+"]");
			foundRights = (String) userRightsMap.get(searchKey);

			System.out.println("Found rights in function ["+foundRights+"]");

			if(foundRights == null && rights != null)
				operation = 1;
			else if(foundRights != null && rights != null)
				operation = 2;
			else if(foundRights != null && rights == null)
				operation = 3;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);// added by akhilesh on 31/oct/12
		}
		return operation;
	}

	private ArrayList getAllSubMenu(String application, int level1, int level2, int level3, int level4, int level5, Connection conn) throws Exception
	{
		String tApplication = null;
		String tKey = null;
		String tWinName = null;
		ArrayList subMenuList = new ArrayList();
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String parentKey = "";
		int tLevel1 = 0;
		int tLevel2 = 0;
		int tLevel3 = 0;
		int tLevel4 = 0;
		int tLevel5 = 0;
		String tMenuName = null;

		String gotUserRights = null;

		String getSubMenuSql = " SELECT APPLICATION, LEVEL_1, LEVEL_2, LEVEL_3, LEVEL_4, LEVEL_5, WIN_NAME, DESCR FROM ITM2MENU " +
				"	where APPLICATION = '" + application + "' " +
				"		and ( level_1 = 0 or (level_1 <> 0 and (LEVEL_1 = " + level1 + " AND LEVEL_2 > 0))) " +
				"		and ( level_2 = 0 or (level_2 <> 0 and (LEVEL_2 = " + level2 + " AND LEVEL_3 > 0))) " +
				"		and ( level_3 = 0 or ( level_3 <> 0 and (LEVEL_3 = " + level3 + " AND LEVEL_4 > 0))) " +
				"		and ( level_4 = 0 or ( level_4 <> 0 and (LEVEL_4 = " + level4 + " AND LEVEL_5 > 0))) " +
				"		and WIN_NAME <> '-' " ;

		System.out.println("Get All Sub Menu SQL :: " + getSubMenuSql);

		parentKey = application + ":" + level1 + ":" + level2 + ":" + level3 + ":" + level4 + ":" + level5;

		try
		{
		
		
			//////////////////////////////////////////////////////////////////////
			// 08/10/13 manoharan re initialise if necessary
			if (userRightsMap == null)
			{
				userRightsMap = new HashMap();
			}
			if (winNameMap == null)
			{
				winNameMap = new HashMap();
			}
			if (menuNameMap == null)
			{
				menuNameMap = new HashMap();
			}
			// end 08/10/13 manoharan ////////////////////////////////////////////////////////////////////
			pstmt = conn.prepareStatement(getSubMenuSql);

			rs = pstmt.executeQuery();

			while(rs.next())
			{
				tApplication = rs.getString(1);
				tLevel1 = rs.getInt(2);
				tLevel2 = rs.getInt(3);
				tLevel3 = rs.getInt(4);
				tLevel4 = rs.getInt(5);
				tLevel5 = rs.getInt(6);
				tWinName = rs.getString(7);
				tKey = tApplication + ":" + tLevel1 + ":" + tLevel2 + ":" + tLevel3 + ":" + tLevel4 + ":" + tLevel5;
				System.out.println("tKey [" + tKey + "] tWinName [" + tWinName + "]");
				subMenuList.add(tKey);

				tMenuName = rs.getString(8);
				if(!menuNameMap.containsKey(tKey))
					menuNameMap.put(tKey, tMenuName);

				winNameMap.put(tKey, tWinName.trim().substring(2, tWinName.trim().length()));
				gotUserRights = (String) userRightsMap.get(tKey);
				if(gotUserRights == null || gotUserRights.trim().length() == 0){
					gotUserRights = getUserRights(profileId, tApplication, tLevel1, tLevel2, tLevel3, tLevel4, tLevel5, conn);
					if(gotUserRights != null && gotUserRights.trim().length() > 0)
						userRightsMap.put(tKey, gotUserRights);
				}
			}

			rs.close();
			rs = null;

			pstmt.close();
			pstmt = null;

			if(subMenuList.size() == 0)
			{
				
				
				// 08/10/13 manoharan in order to avoid nullpointer exception - get the win_name, menu_name and rights also and add to the corresponding map
				//////////////////////////////////////////////////////////////////////////////////////////////
				//subMenuList.add(parentKey);  // commented and following code added
				System.out.println("parentKey [" + parentKey + "] no submenu found so adding parent key");
				getSubMenuSql = " SELECT APPLICATION, LEVEL_1, LEVEL_2, LEVEL_3, LEVEL_4, LEVEL_5, WIN_NAME, DESCR FROM ITM2MENU " +
					"	where APPLICATION = '" + application + "' " +
					"		and LEVEL_1 = " + level1 + " " +
					"		and LEVEL_2 = " + level2 + "  " +
					"		and LEVEL_3 = " + level3 + "  " +
					"		and LEVEL_4 = " + level4 + "  " +
					"		and WIN_NAME <> '-' " ;

				System.out.println("Get  Menu SQL :: " + getSubMenuSql);

				pstmt = conn.prepareStatement(getSubMenuSql);

				rs = pstmt.executeQuery();

				if(rs.next())
				{
					tApplication = rs.getString(1);
					tLevel1 = rs.getInt(2);
					tLevel2 = rs.getInt(3);
					tLevel3 = rs.getInt(4);
					tLevel4 = rs.getInt(5);
					tLevel5 = rs.getInt(6);
					tWinName = rs.getString(7);
					tKey = tApplication + ":" + tLevel1 + ":" + tLevel2 + ":" + tLevel3 + ":" + tLevel4 + ":" + tLevel5;
					System.out.println("tKey [" + tKey + "] tWinName [" + tWinName + "]");
					subMenuList.add(tKey);

					tMenuName = rs.getString(8);
					if(!menuNameMap.containsKey(tKey))
						menuNameMap.put(tKey, tMenuName);

					winNameMap.put(tKey, tWinName.trim().substring(2, tWinName.trim().length()));
					gotUserRights = (String) userRightsMap.get(tKey);
					if(gotUserRights == null || gotUserRights.trim().length() == 0){
						gotUserRights = getUserRights(profileId, tApplication, tLevel1, tLevel2, tLevel3, tLevel4, tLevel5, conn);
						if(gotUserRights != null && gotUserRights.trim().length() > 0)
							userRightsMap.put(tKey, gotUserRights);
					}
				}

				rs.close();
				rs = null;

				pstmt.close();
				pstmt = null;
			}
			//////////////////////////////////////////////////////////////////////////////////////////////
				
				
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);// added by akhilesh on 31/oct/12
		}
		finally
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		return subMenuList;
	}

	private String getUserRights(String profileId, String application, int level1, int level2, int level3, int level4, int level5, Connection conn) throws Exception
	{
		String userRightsSql = " select RIGHTS " +
			" from user_rights  " +
			" where profile_id = '" + profileId + "' " +
			"	and APPLICATION = '" + application + "' " +
			"	and MENU_ROW = " + level1 +
			"	and MENU_COL = " + level2 +
			"	and MENU_SUBCOL = " +level3 +
			"   and LEVEL_4 = " + level4 +
			"	and LEVEL_5 = " + level5;

		String rights = null;
		System.out.println("userRightsSql :: " + userRightsSql);

		String key = application + ":" + level1 + ":" + level2 + ":" + level3 + ":" + level4 + ":" + level5;

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
		
			pstmt = conn.prepareStatement(userRightsSql);

			rs = pstmt.executeQuery();

			if(rs.next())
			{
				rights = rs.getString(1);
				System.out.println("Key = " + key + " : Rights = " + rights);
			}

			rs.close();
			rs = null;

			pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);// added by akhilesh on 31/oct/12
		}
		finally
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}

		return rights;
	}
	public void populateMap(Document headerDom, Document detailDom, String xtraParams) throws RemoteException,ITMException
	{

		Statement stmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//StringBuffer retTabSepStrBuff = new StringBuffer();
		String userId = null;
		Object date = null;
		String sql = "";
		String errCode = "";
		String errString = "";
		String resultString = "";
		String curUserId = "", curProfileId = "";

		//String profileId =null;

		double quantity = 0.0,pendingQty = 0.0;
		int count = 0, usrLev = 0;
		String tApplication = null;
		String key = null;
		String tWinName = null;
		String tMenuName = null;
		String sqlStr = "";
		try
		{
			if(conn == null)
			{
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				connDriver = null;
			}

			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			profileId = genericUtility.getColumnValue("profile_id", headerDom);
			//System.out.println("profileId ::- "+ profileId);
			// 24/03/12 manoharan get the current logged in user and show only the menus for which the current user has rights
			curUserId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");  
			System.out.println("Current userid curUserId ["+ curUserId + "] profileId [" + profileId + "]");
			if (curUserId != null || curUserId.trim().length() > 0)
			{

				sql = " select profile_id,usr_lev from users where code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,curUserId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					curProfileId = rs.getString("profile_id");
					usrLev = rs.getInt("usr_lev");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				System.out.println("Current curProfileId ["+ curProfileId + "] usrLev [" + usrLev + "]");

				////////////////
				//If profile Id is blank or doesnt exist in the User_Rights table then prompt error
				//String profileSql = " select count(*) " +
				//		" from user_rights  " +
				//		" where profile_id = '" + profileId + "' " ;

				String profileSql = " select count(1) " +
						" from gencodes  " +
						" where fld_name = 'PROFILE_ID' and fld_value = '" + profileId + "' " ;

				int profileCount = 0;
				System.out.println("ProfileSql :: " + profileSql);

				PreparedStatement pProfileStmt = null;
				ResultSet profileRs = null;

				pProfileStmt = conn.prepareStatement(profileSql);

				profileRs = pProfileStmt.executeQuery();

				if(profileRs.next())
				{
					profileCount = profileRs.getInt(1);
					System.out.println("Profile Count = " + profileCount);
				}

				profileRs.close();
				profileRs = null;

				pProfileStmt.close();
				pProfileStmt = null;
				///////////////

				if(profileCount == 0)
				{
					errString = itmDBAccessEJB.getErrorString("","PNOTEXIST","","",conn);
					
				}

				userRightsMap = new HashMap();
				winNameMap = new HashMap();
				menuNameMap = new HashMap();

				sqlStr = " SELECT ITM2MENU.APPLICATION,   							" +
						"         ITM2MENU.LEVEL_1,									" +
						"         ITM2MENU.LEVEL_2,   								" +
						"         ITM2MENU.LEVEL_3,   								" +
						"         ITM2MENU.LEVEL_4,   								" +
						"         ITM2MENU.LEVEL_5,   								" +
						"         ITM2MENU.WIN_NAME,   								" +
						"         ITM2MENU.DESCR,   								" +
						"         (SELECT USER_RIGHTS.RIGHTS FROM USER_RIGHTS 		" +  
						"			WHERE USER_RIGHTS.PROFILE_ID = ? " +
						"			AND USER_RIGHTS.APPLICATION = ITM2MENU.APPLICATION " +
						"			AND USER_RIGHTS.MENU_ROW = ITM2MENU.LEVEL_1			" +
						"			AND USER_RIGHTS.MENU_COL = ITM2MENU.LEVEL_2			" +
						"			AND USER_RIGHTS.MENU_SUBCOL = ITM2MENU.LEVEL_3		" +
						"			AND USER_RIGHTS.LEVEL_4 = ITM2MENU.LEVEL_4			" +
						"			AND USER_RIGHTS.LEVEL_5 = ITM2MENU.LEVEL_5			" +
						"			  ) AS RIGHTS										" +
						"         FROM ITM2MENU " ;
				if (usrLev > 0 )
				{
					sqlStr = sqlStr + " where exists (select 1 from user_rights u  "
							+ " where u.profile_id in ('" + curProfileId + "','" + profileId + "') "
							+ " and u.application = ITM2MENU.application  "
							+ " and u.menu_row = ITM2MENU.level_1 "
							+ " and u.menu_col = ITM2MENU.level_2 "
							+ " and u.menu_subcol = ITM2MENU.level_3 "
							+ " and u.level_4 = ITM2MENU.level_4 "
							+ " and u.level_5 = ITM2MENU.level_5) " ;
				}			
				sqlStr = sqlStr + " 	ORDER BY ITM2MENU.APPLICATION, ITM2MENU.LEVEL_1, ITM2MENU.LEVEL_2, ITM2MENU.LEVEL_3, ITM2MENU.LEVEL_4, ITM2MENU.LEVEL_5 ";


				pstmt = conn.prepareStatement(sqlStr);
				pstmt.setString(1,profileId);
				//System.out.println("The getData sql is:-"+ sqlStr);
				rs = pstmt.executeQuery();
				while (rs.next())
				{

					tApplication = rs.getString(1);

					if(tApplication != null)
						key = tApplication + ":" + rs.getInt(2) + ":" + rs.getInt(3) + ":" + rs.getInt(4)
						+ ":" + rs.getInt(5) + ":" + rs.getInt(6);


					//DESCR
					tMenuName = rs.getString(8);

					//WIN_NAME
					tWinName = rs.getString(7);

					userRightsMap.put(key, rs.getString(9));
					if(tWinName != null && tWinName.trim().length() > 2)
						winNameMap.put(key, tWinName.trim().substring(2, tWinName.trim().length()));

					menuNameMap.put(key, tMenuName);
				}//while
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			} 
			// end 24/03/12 manoharan
		}//try
		catch (SQLException e)
		{
			System.out.println("SQLException ::" + sqlStr + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);// added by akhilesh on 31/oct/12
		}
		catch(Exception ex)
		{
			System.out.println("Exception []::" + ex.getMessage());
			ex.printStackTrace();
			throw new ITMException(ex);// added by akhilesh on 31/oct/12
		}
		finally
		{
			try
			{
				if(rs != null){rs.close();// added by akhilesh on 08/nov/12
				rs = null;}

				if(pstmt != null){pstmt.close();// added by akhilesh on 08/nov/12
				pstmt = null;}

				if(conn != null){conn.close();// added by akhilesh on 08/nov/12
				conn = null;}

			}
			catch(Exception e){
				throw new ITMException(e);// added by akhilesh on 31/oct/12
			}
		}

	}//populateMap

	
	
}//class




