package ibase.webitm.ejb.adm.adv;

import ibase.system.config.AppConnectParm;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.sys.ProteusDataSource;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.adm.AttdProcess;
import ibase.webitm.ejb.adm.LeaveEncase;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.print.attribute.standard.PresentationDirection;

@Stateless
public class EmpLeaveCancel extends ActionHandlerEJB  implements EmpLeaveCancelLocal,EmpLeaveCancelRemote
{


	private UtilMethods utilMethod = null ;
	private AdmCommon admCommon = null;
	private E12GenericUtility genericUtility = null;
	private String errXml ="";
	private String termId = "",loginEmpCode = "",userId = "";
	private HashMap lveRuleList = null;
	private ArrayList errList = null;
	private ArrayList fldList = null;
	private String leaveXmlData = "";
	private ProteusDataSource proteusDataSource = null;

	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		genericUtility = new E12GenericUtility();
		String retString = "";
		Connection conn = null;

		try
		{
			conn = getConnection();
			retString = confirm( tranId, xtraParams, forcedFlag, conn);	
		}
		catch(Exception e)
		{
			System.out.println("Exception :EmpLeaveCancel :confirm():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
		}
		return retString;
	}
	public String confirm( String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException
	{
		System.out.println("--------------Confirm method for cancel Empleave -------------");
		ResultSet rs=null;
		PreparedStatement pstmt = null;	
		String retString = "";
		String errString = "",errCode = "";	
		HashMap hMap = new HashMap();

		AppConnectParm appConnect = null;
		InitialContext initialCtx = null;
		ITMDBAccessLocal itmDBAccess = null;

		if (genericUtility == null)
		{
			genericUtility = new E12GenericUtility();
		}
		if (admCommon == null)
		{
			admCommon = new AdmCommon();
		}
		if (utilMethod == null)
		{
			utilMethod = new UtilMethods();
		}

		try
		{

			this.errXml ="";
			this.errList = new ArrayList();
			this.fldList = new ArrayList();
			this.lveRuleList = admCommon.createLveRuleList();
			this.userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			this.termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			this.loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");

			appConnect = new AppConnectParm();
			initialCtx = new InitialContext(appConnect.getProperty());
			itmDBAccess = (ITMDBAccessLocal)initialCtx.lookup("ibase/ITMDBAccessEJB/local");			
			if (this.leaveXmlData != null && this.leaveXmlData.trim().length() > 0)
			{
				this.proteusDataSource = new ProteusDataSource("empLeave", this.leaveXmlData, 1);
			}

			System.out.println("Calling Post Logic......");
			retString = postLogic(tranId, tranId, 2, xtraParams, conn);

			System.out.println("return Error List of Post Logic :: "+this.errList);

			int cnt =0;
			String errorCode = "";
			String errFldName = null, errorType = "";
			StringBuffer errStringXml = new StringBuffer();
			if ( this.errList != null && this.errList.size() > 0 )
			{
				for (cnt = 0; cnt < this.errList.size(); cnt++ )
				{
					errCode = (String)this.errList.get(cnt);
					errFldName = (String)this.fldList.get(cnt);
					System.out.println("errCode .........."+errCode);
					errString = itmDBAccess.getErrorString( errFldName, errCode, this.userId );

					errorType =  getErrorType( errCode , conn  );
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
					errString = "";
				}
				this.errList.clear();
				this.errList = null;
				this.fldList.clear();
				this.fldList = null;

			}
			if (errString == null || errString.trim().length() == 0)
			{
				conn.commit();
				errString = itmDBAccess.getErrorString( "", "VTLVECAR01" , this.userId );
			}
			else
			{
				conn.rollback();
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :EmpLeaveCancel :confirm():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			this.errXml ="";
			this.leaveXmlData = "";
			this.errList = null;
			this.fldList = null;
			this.lveRuleList = null;
			this.proteusDataSource = null;
			this.admCommon = null;
			this.utilMethod = null;
		}
		System.out.println("Error String Returned from Cancellation of leave :: [" + errString + "]");
		return errString;
	}
	private String postLogic (String tranidFr,String tranidTo,int commit,String xtraParms,Connection conn)
	{
		HashMap errCode = new HashMap<>();
		String tranId = "" ,useFlag = "",tranidTrimmed = "",status = "",errCode1 = "";
		int	cnt = 0 , count = 0;
		java.sql.Timestamp	currDate = null; 
		LeaveEncase leaveEnc ;
		String isError = "";

		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			System.out.println("tranidFr :: ["+tranidFr+"]");
			System.out.println("tranidTo :: ["+tranidTo+"]");
			if(tranidFr == tranidTo)
			{
				tranId = tranidFr;
				tranidTrimmed = tranId.trim();
				errCode = cancelLeave(tranId,commit,conn);
				sql = "select status,use_flag from empleave where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					status = checkNull(rs.getString("status"));
					useFlag = checkNull(rs.getString("use_flag"));
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(status.equals("C") && utilMethod.pos("CVE" ,useFlag.trim()) > 0)
				{
					currDate = utilMethod.dateTime(utilMethod.today() , utilMethod.stringToTime("00:00"));
					sql = "select count(1) as cnt  from wf_prc_status where ref_ser in ('E-LVE','E-LVF','E-LVN') and ref_id = ?";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranidTrimmed);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						cnt = rs.getInt("cnt");
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if (cnt > 0)
					{
						sql = "";
						sql = "update obj_sign_trans set SIGN_DATE = ? , SIGN_STATUS = 'S' , SIGN_REMARKS = 'Application Canceled'"+ 
								"where ref_ser in ('E-LVE','E-LVF','E-LVN') and ref_id = ? and sign_status = 'U'";

						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, currDate);
						pstmt.setString(2,tranidTrimmed);
						rs = pstmt.executeQuery();
						count = pstmt.executeUpdate();
						if(count == 0)
						{
							count = 0;
							sql = "";
							sql = "update wf_prc_status set process_status = 9 , status_remarks = 'Leave application is canceled from ERP'" +
									"where ref_ser in ('E-LVE','E-LVF','E-LVN') and ref_id = ? and process_status < 3";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,tranidTrimmed);
							rs = pstmt.executeQuery();
							count = pstmt.executeUpdate();
							if(count == 0)
							{
								sql = "";
								sql = "update empleave set WRKFLW_STATUS = 'Z' where tran_id = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,tranId);
								rs = pstmt.executeQuery();
								count = pstmt.executeUpdate();
							}
							else
							{
								errCode1 = "DS000";
							}
						}
						else
						{
							errCode1 = "DS000";
						}

						if(errCode1.trim().length() > 0)
						{
							conn.rollback();
						}
						else
						{
							conn.commit();
						}
					}
				}			
			}			
			if(errCode.size() > 0)
			{
				conn.rollback();
			}
			else
			{
				errCode1 = "VTLVCANC01";
				errList.add(errCode1);
				fldList.add("");
				conn.commit();
			}			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return errCode1;
	}
	private HashMap cancelLve(String tranId,int commit, Connection connectionObject) throws RemoteException,ITMException 
	{
		HashMap hmap = new HashMap();

		/*ArrayList this.errList = new ArrayList();
		ArrayList this.fldList = new ArrayList();*/

		String	useFlag = "" , val1 = "", val2 = "", status = "" , errCode = ""; 
		double	val5 = 0 , lveDays = 0;
		java.sql.Timestamp	val3 = null , val4 = null , date3 = null;
		String    empCode = "" , lveCode = "", extraArg = "",empCodeAprv = "";
		java.sql.Timestamp  lveDateFr = null, lveDateTo = null;
		java.sql.Timestamp cfDate = null, cfDateList[] = null, effDate = null;
		long row = 0;
		int noRows = 0;

		String sql = "",sql1 = "",sql2 = "";
		PreparedStatement pstmt = null,pstmt1 = null,pstmt2 = null;
		ResultSet resultSet = null ,resultSet1 = null,resultSet2 = null;

		AttdProcess attdProc;
		try
		{
			do
			{
				sql = "SELECT EMP_CODE, LVE_CODE, LVE_DATE_FR , LVE_DATE_TO ,STATUS , NO_DAYS , USE_FLAG FROM EMPLEAVE_CANCEL WHERE TRAN_ID = ? ";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, tranId);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					noRows++;
					empCode = checkNull(resultSet.getString("EMP_CODE"));
					lveCode = checkNull(resultSet.getString("LVE_CODE"));
					lveDateFr = resultSet.getTimestamp("LVE_DATE_FR");
					lveDateTo  = resultSet.getTimestamp("LVE_DATE_TO");
					status = checkNull(resultSet.getString("STATUS"));
					lveDays = resultSet.getDouble("NO_DAYS");
					useFlag = checkNull(resultSet.getString("USE_FLAG"));
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(status.equals("C"))
				{
					errCode = "VTEMPLVE13";
					break;
				}
				noRows = 0;
				sql1 = "SELECT EFF_DATE , UPTO_DATE , LVES_ALLOC FROM EMPLVE_TRACE WHERE TRAN_ID = ? ORDER BY EFF_DATE ";
				pstmt1 = connectionObject.prepareStatement(sql1);
				pstmt1.setString(1, tranId);
				resultSet1 = pstmt1.executeQuery();
				while(resultSet1.next())
				{
					noRows++;
					val3 = resultSet1.getTimestamp("EFF_DATE");
					val4 = resultSet1.getTimestamp("UPTO_DATE");
					val5 = resultSet1.getDouble("LVES_ALLOC");
				}
				if(cfDate == null)
				{
					cfDate = lveDateFr; 
				}
				
				if(noRows > 0)
				{					
					if(val3.before(cfDate))
					{
						cfDate = val3; 
					}
					sql2 = "";
					sql2 = "UPDATE LEAVEBAL SET BAL_DAYS = BAL_DAYS + ?,CONS_DAYS = CONS_DAYS -? WHERE EMP_CODE = ? AND LVE_CODE  = ? AND EFF_DATE = ? AND UPTO_DATE <= ?";
					pstmt2 = connectionObject.prepareStatement(sql2);
					pstmt2.setDouble(1, val5);
					pstmt2.setDouble(2, val5);
					pstmt2.setString(3, empCode);
					pstmt2.setString(4, lveCode);
					pstmt2.setTimestamp(5, val3);
					pstmt2.setTimestamp(6, val4);
					noRows = pstmt2.executeUpdate();
					System.out.println("noRows updated in leavebal::["+noRows+"]");
					if(pstmt2 != null)
					{
						pstmt2.close();
						pstmt2 = null;
					}

					sql1 = "";
					sql1 = "DELETE FROM EMPLVE_TRACE WHERE TRAN_ID =  ? AND EFF_DATE = ? AND UPTO_DATE = ?";
					pstmt2 =  connectionObject.prepareStatement(sql1);
					pstmt2.setString(1, tranId);
					pstmt2.setTimestamp(2, val3);
					pstmt2.setTimestamp(3, val4);
					noRows = pstmt2.executeUpdate();
					System.out.println("noRows deleted from emplve_trace::["+noRows+"]");
					if(pstmt2 != null)
					{
						pstmt2.close();
						pstmt2 = null;
					}

				}
				if(errCode.trim().length() != 0)
				{
					break;
				}
				date3 = utilMethod.dateTime(utilMethod.todaySqlDate(),utilMethod.now());
				sql = "";
				noRows = 0;
				sql = "update empleave_cancel set chg_term	 = ?, chg_user = ?,chg_date = ? where tran_id = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, this.termId);
				pstmt.setString(2, this.userId);
				pstmt.setTimestamp(3, date3);
				pstmt.setString(4, tranId);
				noRows = pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				noRows = 0;
				sql = "";
				sql = "DELETE FROM EMPLEAVE_SUMMARY WHERE TRAN_ID = ? AND  USE_FLAG = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, useFlag);
				noRows = pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				noRows = 0;
				sql = "";
				sql = "update empleave set status = 'C' , status_date = ? where tran_id = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setTimestamp(1, date3);
				pstmt.setString(2, tranId);
				noRows = pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				break;
			}
			while(true);

			if(errCode != null && errCode.trim().length() != 0)
			{
				this.errList.add(errCode);
				this.fldList.add("");
				if(commit == 2)
				{
					connectionObject.rollback();
				}
			}
			else
			{
				this.errXml = "";
				if(status.equals("A") && useFlag.equals("C"))
				{
					attdProc = new AttdProcess();
					//errCode = attdProc.attdProcess(empCode, lveDateFr,lveDateTo ,1 , connectionObject);

				}
				/*addGlobArgs(extraArg);
				attdProc.setGlobals(extraArg);*/
				//errCode = attdProc.autoAttdProc(empCode , lveDateFr , lveDateTo , 1);
				//$$$$$$$$$$$$$$$$$$$$$$$$$$$//errCode = attdProc.attdProcess( lveDateFr , lveDateTo ,empCode , "1",connectionObject);
			}

			if(commit == 2)
			{
				if(utilMethod.pos(errCode , "<error") > 0 )
				{
					this.errXml = errCode;
					this.errList.add(errCode);
					this.fldList.add("");
					connectionObject.rollback();
				}
				else
				{
					this.errXml = "";
					connectionObject.commit();

					/*if(status.equals("A"))
					{
						int count1 = 0;
						noRows = 0;
						sql = "";
						sql = "SELECT EFF_DATE FROM LEAVEBAL WHERE EMP_CODE = ? AND EFF_DATE > ? AND LVE_CODE = ? ORDER BY EFF_DATE";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, empCode);
						pstmt.setTimestamp(2, cfDate);
						pstmt.setString(3, lveCode);
						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							noRows++;
							effDate = resultSet.getTimestamp("EFF_DATE");
						}
						if(noRows > 0)
						{
							count1 = utilMethod.upperBound(cfDateList);
							count1 = count1 + 1;
							cfDateList[count1] = effDate;
							System.out.println("effDate ::::"+effDate);
							
							if(cfDateList.length > 0)
							{
								//	BoLeaveOpenBalance leaveBal = new  BoLeaveOpenBalance();           
								StringBuffer leaveOpenBal = new StringBuffer();
								leaveOpenBal.dataobject = "d_lve_open_bal";
							leaveOpenBal.SetTransObject(sqlca);
							leaveOpenBal.reset();
							leaveOpenBal.insertrow(0);
								for(row = 1;row <= cfDateList.length;row++)
								{
									leaveOpenBal.append("<emp_code__fr>").append(empCode).append("</emp_code__fr>");
									leaveOpenBal.append("<emp_code__to>").append(empCode).append("</emp_code__to>");
									leaveOpenBal.append("<leave_type__fr>").append(lveCode).append("</leave_type__fr>");
									leaveOpenBal.append("<leave_type__to>").append(lveCode).append("</leave_type__to>");
									leaveOpenBal.append("<resign_emp>").append("N").append("</resign_emp>");
									leaveOpenBal.append("<proc_date>").append(cfDateList[(int) row]).append("</proc_date>");
									//errCode = leaveBal.process(leaveOpenBal.describe("datawindow.data"), "",extraArg);
									errCode = "";
								}
							}
						}
					}*/
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		//buildErrxml();
		return hmap;
	}
	private HashMap cancelLeave (String tranId, int commit, Connection connectionObject) throws RemoteException,ITMException
	{

		String	useFlag = "" , val1 = "", val2 = "", status = "" , errCode = ""; 
		double val5 = 0 , lveDays = 0 ;
		int ediOption = 0;
		java.sql.Timestamp	val3 = null , val4 = null , date3 = null;

		String    empCode = "" , lveCode = "" ,  sql1 = "";
		String	empStatus  = "",empCodeApprv = "";
		java.sql.Timestamp  lveDateFr = null , lveDateTo = null, statusDate = null;

		StringBuffer empLveCancel ;//DataStore empLveCancel;
		//AEDFunctionsAdv functionsAdv = new  AEDFunctionsAdv();

		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet resultSet = null;
		int noRows = 0;
		int count = 0;
		HashMap hmap = new HashMap();

		E12GenericUtility genericUtility;

		/*ArrayList this.errList = new ArrayList();
		ArrayList this.fldList = new ArrayList();*/
		try
		{
			genericUtility = new E12GenericUtility();

			do
			{
				sql = "SELECT EMP_CODE, LVE_CODE, LVE_DATE_FR , LVE_DATE_TO ,STATUS , NO_DAYS , USE_FLAG FROM EMPLEAVE WHERE TRAN_ID = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,tranId);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					empCode = checkNull(resultSet.getString("EMP_CODE"));
					lveCode = checkNull(resultSet.getString("LVE_CODE"));
					lveDateFr = resultSet.getTimestamp("LVE_DATE_FR");
					lveDateTo = resultSet.getTimestamp("LVE_DATE_TO");
					status = checkNull(resultSet.getString("STATUS"));
					lveDays = resultSet.getDouble("NO_DAYS");
					useFlag = checkNull(resultSet.getString("USE_FLAG"));
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				} 
				if(status.equals("C"))
				{
					errCode = "VTEMPLVE13";
					this.errList.add(errCode);
					this.fldList.add("");
					break;
				}
				else if(useFlag.equals("E")) 
				{
					if(status.equals("A"))
					{
						errCode = "VTEMPLVE21";
						this.errList.add(errCode);
						this.fldList.add("");
						break;
					}
				}
				else if(useFlag.equals("L")) 
				{
					errCode = "VTLVE16";
					this.errList.add(errCode);
					this.fldList.add("");
					break;
				}
				else if(useFlag.equals("V") && status.equals("A"))
				{
					errCode ="VTLVE16";   
					this.errList.add(errCode);
					this.fldList.add("");
					break;
				}
				sql = "select case when status is null then '' else status end  as status from employee where emp_code =  ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,empCode);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					empStatus = checkNull(resultSet.getString("status"));
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				} 
				if(empStatus.equals("S"))
				{
					errCode = "VTEMPSEP1";
					this.errList.add(errCode);
					this.fldList.add("");
					break;
				}
				String empCodeAprv = "",lveType = "",prdCode = "",remarks = "",tranIdPayr="",
						authEmp = "",applDate = "",authEmpAlternate = "",chgdate = "",chguser = "",chgterm = "",
						leaveStarts = "",leaveEnds = "",lvefrdate1 = "",lvetodate1 = "",statusDate1 = "",aprvDate1= ""; 
				String startTime = "",endTime = "",aprvDate = "";
				double enchAmt = 0,noDays = 0,noDaysAdv = 0;
				PreparedStatement ps = null;String txt = "";ResultSet rs1 = null;int cnt1 = 0;
				txt = " Select TRAN_ID ,EMP_CODE, LVE_DATE_FR, LVE_DATE_TO,LVE_CODE,EMP_CODE__APRV,APRV_DATE,LVE_TYPE,"+
						" USE_FLAG,ENCH_AMT,NO_DAYS,STATUS,STATUS_DATE,PRD_CODE,REMARKS,TRAN_ID__PAYR,NO_DAYS_ADV,APPL_DATE,"+
						" AUTH_EMP,AUTH_EMP_ALTERNATE,DBSYSDATE(),?,?,LEAVE_STARTS, LEAVE_ENDS, START_TIME, END_TIME "+
						" FROM EMPLEAVE WHERE TRAN_ID = ?";
				ps = connectionObject.prepareStatement(txt);
				ps.setString(1, userId);
				ps.setString(2, termId);
				ps.setString(3, tranId);
				rs1 = ps.executeQuery();
				while(rs1.next())
				{
					cnt1++;
					tranId = checkNull(rs1.getString("TRAN_ID"));
					empCode = checkNull(rs1.getString("EMP_CODE"));
					lvefrdate1 = checkNull(rs1.getString("LVE_DATE_FR"));
					lvetodate1 = checkNull(rs1.getString("LVE_DATE_TO"));
					lveCode = checkNull(rs1.getString("LVE_CODE"));
					empCodeAprv = checkNull(rs1.getString("EMP_CODE__APRV"));
					aprvDate1 = checkNull(rs1.getString("APRV_DATE"));
					lveType = checkNull(rs1.getString("LVE_TYPE"));
					useFlag = checkNull(rs1.getString("USE_FLAG"));
					enchAmt = rs1.getDouble("ENCH_AMT");
					noDays = rs1.getDouble("NO_DAYS");
					status = checkNull(rs1.getString("STATUS"));
					statusDate1 = checkNull(rs1.getString("STATUS_DATE"));
					prdCode = checkNull(rs1.getString("PRD_CODE"));
					remarks = checkNull(rs1.getString("REMARKS"));
					tranIdPayr = checkNull(rs1.getString("TRAN_ID__PAYR"));
					noDaysAdv = rs1.getDouble("NO_DAYS_ADV");
					applDate = checkNull(rs1.getString("APPL_DATE"));
					authEmp = checkNull(rs1.getString("AUTH_EMP"));
					authEmpAlternate = checkNull(rs1.getString("AUTH_EMP_ALTERNATE"));
					leaveStarts = checkNull(rs1.getString("LEAVE_STARTS"));
					leaveEnds = checkNull(rs1.getString("LEAVE_ENDS"));
					startTime = checkNull(rs1.getString("START_TIME"));
					endTime = checkNull(rs1.getString("END_TIME"));
				}
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(ps != null)
				{
					ps.close();
					ps = null;
				}
				count = 0;
				int rowsUpdate = 0;String newSql = "";
				PreparedStatement ps2 = null;
				newSql = "INSERT INTO EMPLEAVE_CANCEL(TRAN_ID ,EMP_CODE, LVE_DATE_FR, LVE_DATE_TO,LVE_CODE,EMP_CODE__APRV,APRV_DATE,LVE_TYPE,"+
						" USE_FLAG,ENCH_AMT,NO_DAYS,STATUS,STATUS_DATE,PRD_CODE,REMARKS,TRAN_ID__PAYR,NO_DAYS_ADV,APPL_DATE,"+
						" AUTH_EMP,AUTH_EMP_ALTERNATE,CHG_DATE,CHG_USER,CHG_TERM,LEAVE_STARTS,LEAVE_ENDS,START_TIME,END_TIME) "+
						" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,DBSYSDATE(),?,?,?,?,?,? )";
				ps2 = connectionObject.prepareStatement(newSql);
				ps2.setString(1, tranId);
				ps2.setString(2, empCode);
				ps2.setString(3, lvefrdate1.length() > 0?genericUtility.getValidDateString(lvefrdate1, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat()):null);
				ps2.setString(4, lvetodate1.length() > 0?genericUtility.getValidDateString(lvetodate1, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat()):null);
				ps2.setString(5, lveCode);
				ps2.setString(6, empCodeAprv);
				ps2.setString(7,aprvDate1.length() > 0?genericUtility.getValidDateString(aprvDate1, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat()):null);
				ps2.setString(8, lveType);
				ps2.setString(9, useFlag);
				ps2.setDouble(10, enchAmt);
				ps2.setDouble(11, noDays);
				ps2.setString(12, status);
				ps2.setString(13, statusDate1.length() > 0?genericUtility.getValidDateString(statusDate1,genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()):null);
				ps2.setString(14, prdCode);
				ps2.setString(15, remarks);
				ps2.setString(16, tranIdPayr);
				ps2.setDouble(17, noDaysAdv);
				ps2.setString(18, applDate.length() > 0?genericUtility.getValidDateString(applDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()):null);
				ps2.setString(19, authEmp);
				ps2.setString(20, authEmpAlternate);
				ps2.setString(21, userId);
				ps2.setString(22, termId);
				ps2.setString(23, leaveStarts);
				ps2.setString(24, leaveEnds);
				ps2.setString(25,startTime.length() > 0?genericUtility.getValidDateString(startTime, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat()):null);
				ps2.setString(26,endTime.length() > 0?genericUtility.getValidDateString(endTime,genericUtility.getDBDateFormat(),  genericUtility.getApplDateFormat()):null);
				rowsUpdate = ps2.executeUpdate();

				if(ps2 != null)
				{
					ps2.close();
					ps2 = null;
				}
				if(rowsUpdate > 0)
				{

					if(status.equals("A"))
					{
						hmap = cancelLve(tranId , 2 , connectionObject);
						if(errCode != null && errCode.trim().length() > 0 &&utilMethod.pos(errCode , "<Errors>") > 0)
						{
							break;
						}
						else
						{
							noRows = 0;
							sql = "select edi_option  from transetup where tran_window = 'w_empleave_cancel'";
							pstmt = connectionObject.prepareStatement(sql);
							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								noRows++;
								ediOption = resultSet.getInt("edi_option");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 
							/*if(noRows == 0)
							{

								errCode = "DS000";
								this.errList.add(errCode);
								this.fldList.add("");
								break;
							}*/
							if(ediOption > 0 )
							{
								empLveCancel = new StringBuffer();
								/*empLveCancel.dataobject = "d_empleave_cancel_edit";
								empLveCancel.settransobject(sqlca);
								empLveCancel.retrieve(tranId);
								 */
								if(ediOption == 2)
								{
									//To be done later on
									//functionsAdv.post nf_create_edi_multi("w_empleave_cancel",empLveCancel.describe("datawindow.syntax")  +"\r"+empLveCancel.describe("datawindow.syntax.data"),'E',ediOption, 1, "","","","","","");
								}
								else
								{
									//To be done later on
									//functionsAdv.nf_create_edi_multi("w_empleave_cancel",empLveCancel.describe("datawindow.syntax")  +"\r"+empLveCancel.describe("datawindow.syntax.data"),'E',ediOption, 1, "","","","","","");
								}
							}
						}
					}
					else if(status.equals("R"))
					{
						statusDate = utilMethod.dateTime(utilMethod.todaySqlDate(),utilMethod.now());
						sql = "";
						noRows = 0;
						sql = "update empleave set status = 'C' , status_date = ? where tran_id = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setTimestamp(1,statusDate);
						pstmt.setString(2, tranId);
						noRows = pstmt.executeUpdate();
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
				}
				break;						
			}while(true);
			if(errCode != null && errCode.trim().length() > 0 )
			{
				if(utilMethod.pos(errCode , "<Errors>") == 0)
				{
					this.errList.add(errCode);
					this.fldList.add("");

				}
				else
				{
					this.errXml = errCode;
				}
				if(commit == 2)
				{
					connectionObject.rollback();
				}
			}
			else if(commit == 2)
			{
				connectionObject.commit();
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		hmap.put("ERRORCODE",this.errList);
		hmap.put("FLDLIST", this.fldList);
		return hmap;
	}
	private String getErrorType(String errorCode , Connection conn) throws RemoteException, ITMException
	{
		String errorType = "";
		String sqlStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sqlStr = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sqlStr);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				errorType = checkNull(rs.getString("MSG_TYPE"));
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(errorType == null || errorType.trim().length() == 0)
			{
				errorType = "E";
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
			}
		}
		return errorType;
	}
	private String checkNull(String input) 
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}
}
