package ibase.webitm.ejb.mfg;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;


import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.E12GenericUtility;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Node;

import javax.ejb.Stateless;


@Stateless
public class ProdFeedbackPostSave extends ValidatorEJB implements ProdFeedbackPostSaveLocal,ProdFeedbackPostSaveRemote 
{
	public String postSave(String xmlString,String tranId,String editFlag, String xtraParams,Connection conn) throws RemoteException,ITMException
	{

		System.out.println("------------ postSave method called-----------------DistRcpExShPostSave : ");
		System.out.println("tranId111--->>["+tranId+"]");
		System.out.println("xml String--->>["+xmlString+"]");
		Document dom = null;
		String errString="",lineNoRcp="";
		
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);				
				errString = postSave(dom,tranId,xtraParams,conn);
			}
			
		}
		catch(Exception e)
		{
			System.out.println("Exception : ProdFeedbackPostSave : postSave : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}		
		return errString;
	}
		public String postSave(Document dom,String tranId,String xtraParams,Connection conn) throws ITMException
		{
			ResultSet rs=null;
			PreparedStatement pstmt=null;
			String sql="",errorString="";
			int count=0;
			int totalTime = 0;
			int hour = 0, minute = 0;
			String[] timeInStr = null;
			String timeDisplay = null;
			NodeList parentList = null;
			NodeList childList = null;
			Node parentNode = null;
			Node childNode = null;
			String tottime="";
			try
			{
				
				parentList = dom.getElementsByTagName("Detail3");
				int parentNodeListLength = parentList.getLength();
				for (int prntCtr = parentNodeListLength; prntCtr > 0; prntCtr-- )
				  {	
					parentNode = parentList.item(prntCtr-1);
					childList = parentNode.getChildNodes();
					for (int ctr = 0; ctr < childList.getLength(); ctr++)
					{
					    childNode = childList.item(ctr);
					    if (childNode.getNodeName().equalsIgnoreCase("tot_time") )
					    {
					    	tottime = childNode.getFirstChild().getNodeValue().trim();
							System.out.println("Total Time is-->["+tottime+"]");
								if(tottime.indexOf(".") == -1)
								{
									timeInStr = new String[2];
									timeInStr[0] = tottime;
									timeInStr[1] = "00";
								} else 
								{
									timeInStr = tottime.split("\\.");
								}
								if(timeInStr.length > 1)
								{
									hour = hour + Integer.parseInt(timeInStr[0]);
									System.out.println("hour:["+hour+"]");
									minute = minute + Integer.parseInt(timeInStr[1].length() > 1 ? timeInStr[1] : timeInStr[1]+"0");
									System.out.println("minute:["+minute+"]");
								}		
					   }
				     }
			      }//for loop
				
				totalTime = hour + (minute / 60);
				
				timeDisplay = totalTime + "." + (minute % 60);
				System.out.println("timeDisplay["+timeDisplay+"]");
				if (pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}
				if (rs !=null)
				{
					rs.close();
					rs=null;
				}
					sql="update workorder_feedback set man_hours = ? where tran_id = ? ";
					pstmt=conn.prepareStatement(sql);
			
					pstmt.setString(1, timeDisplay);
//					pstmt.setDate(2, new java.sql.Date(new java.util.Date().getTime()));
					pstmt.setString(2, tranId);
					System.out.println("Man Hours is: "+timeDisplay);			
					count=pstmt.executeUpdate();
					System.out.println("post count---->String>["+count+"]");
					if(count >0 )
					{
						errorString="";
					}
				
			}
			catch(Exception e)
			{
				System.out.println("Exception : ProdFeedbackPostSave -->["+e.getMessage()+"]");
				e.printStackTrace();
				throw new ITMException(e);
				
			}finally
			{
				try
				{	
					if( errorString != null && errorString.trim().length() >  0 )
					{
						conn.rollback();
						System.out.println("Transaction rollback... ");
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					
				}
				catch(Exception e)
				{
					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			return errorString;
		}
}



