<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>
<xsl:template match="/">

<html>

<body onload="getTitlenImg('gstsalesdata_submit');setSummaryTotal();">
<script type="text/javascript" src="/ibase/webitm/js/GSTDataSubmitWiz.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/FixedTableHeader.js"></script>
<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<script language="Javascript" src="/ibase/webitm/js/date.js"></script>

<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.core.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.widget.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.position.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.menu.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.autocomplete.js"></script>

<link href="/ibase/webitm/css/Galaxy/galaxy-theme.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/GSTDataSubmitWiz.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>

<script>
<![CDATA[
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion1");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		  	}
		}
	});
	
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion2");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		    	this.classList.toggle("activeAccor");
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		        if(this.nextElementSibling.classList == "panel2")
		        {
		        	this.classList.remove("activeAccor");
		        }
		  	}
		}
	});
	
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion3");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		  	}
		}
	});

	$(function() 
	{
		var panel = document.getElementsByClassName("panel2");

		for (var j = 0; j < panel.length; j++)
		{
			panel[j].onclick = function()
		    {
			    var acc = document.getElementsByClassName("accordion2");
	       		for(var i=0; i<acc.length; i++)
	       		{
	       			acc[i].classList.remove("activeAccor");
	       		}
	       		this.previousElementSibling.classList.add("activeAccor");
		  	}
		}
	});

	$(document).on("keydown", function (e) {
    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
        e.preventDefault();
    }
    else if(e.which ===13){
    	 e.preventDefault();
    }
});
]]>
</script>

<form name="gstdataSubmitForm2" id="gstdataSubmitForm2" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
	<div class="contentHeaderLbl" style="position:fixed;overflow:hidden;width:100%;padding:12px; background-color:white;top:0px;">
		&#160;&#160;<img onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px; height: 20px; width: 20px;" id="titleImg" />
		&#160;<div id="titleText"></div>
		
	</div><br></br><br></br>
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:98%;position:absolute;">
	    <table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 12px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
            <xsl:for-each select="//error">
                <xsl:if test="position() = 1">
                    <tr>    
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" valign="bottom">
                            Message :
                        </td> 
                        <td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);" valign="bottom">
                            Description :
                        </td>
                        <td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
                            <a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
                <xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
                <xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
                <tr style="background: rgba(255, 204, 0, 0.66);">
                     <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" >
                        <xsl:value-of select="message"/>
                    </td> 
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" >
                        <xsl:value-of select="description"/>
                    </td>
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" >
                    </td>
                </tr>
                <script><![CDATA[]]>formatDetailWithErr();</script>
            </xsl:for-each>
            
            <xsl:for-each select="//error">
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:if test="position() = 1">
                    <xsl:if test="$type = 'W'">
                        <tr style="background: rgba(255, 204, 0, 0.66);">
                            <td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
                                <input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
                            </td>
                            <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
                        </tr>
                    </xsl:if>
                </xsl:if>    
            </xsl:for-each>
	    </table>
	</div>
	
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<div id="mainPageHeaderContatiner">
		<div class="detailPage-input-Container">
			<xsl:for-each select="//Detail2">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:if test="$dbID = '1'">
					<xsl:variable name="auth_token"><xsl:value-of select="auth_token"/></xsl:variable>
					<xsl:variable name="auth_sek"><xsl:value-of select="auth_sek"/></xsl:variable>
					
					<div class="inputFormDiv" style="display:none;">
						<div class="eachLineFields">
							<div class="eachField">
								<div class="inputDiv"><input type="checkbox" value="true" checked="checked" name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" tabIndex="-1"/></div>
							</div>
							<div class="eachField">
								<div class="labelDiv">Auth token : </div>
								<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$auth_token}" name="Detail2.{normalize-space($dbID)}.auth_token" id="Detail2.{normalize-space($dbID)}.auth_token" tabIndex="-1"/></div>
							</div>
							<div class="eachField">
								<div class="labelDiv">Auth sek : </div>
								<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$auth_sek}" name="Detail2.{normalize-space($dbID)}.auth_sek" id="Detail2.{normalize-space($dbID)}.auth_sek" tabIndex="-1" readOnly="true" style="width:224px;"/></div>
							</div>
						</div>
					</div>
				</xsl:if>
				<xsl:if test ="$dbID != '1'">
					<xsl:for-each select="pending_data">
						<button class="accordion1" type="button">
							<div class="iconDiv">P</div>
							Pending data to save on GSTN server till date
						</button>
						<div class="panel1" id="pendingDataPanel">
							<table class="tableClass" id="pendingDataTable">
								<thead class="table-head">
									<tr>
										<th nowrap="true" style="border-left:0px solid black !important;" align="left">Document number</th>
										<th nowrap="true" align="right">Date</th>
										<th nowrap="true" style="border-right:0px solid black !important;" align="right">Amount</th>
									</tr>
								</thead>
								<tbody class="table-body">
								<xsl:for-each select="data">
									<tr>
										<td style="border-left:0px solid black !important;"><xsl:value-of select="doc_no"/></td>
										<td align="right"><xsl:value-of select="doc_date"/></td>
										<td style="border-right:0px solid black !important;" align="right"><xsl:value-of select="amount"/></td>
									</tr>
								</xsl:for-each>
								</tbody>
							</table>
						</div>
					</xsl:for-each>
					<xsl:for-each select="summary_data">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">S</div>
							<div style="margin-left:40px;">
								<xsl:variable name="summaryRetPeriod"><xsl:value-of select="ret_period"/></xsl:variable>
								<input type="hidden" id="summaryRetPeriod" value="{$summaryRetPeriod}"/>
								<div class="invTypDiv">Summary of documents till date saved on GSTN server for <span id="returnMonthLbl"></span></div>
							</div>
						</button>
						<div class="panel1" style="overflow-x:auto;">
							<table class="tableClass" id="dataSummaryTable">
								<thead class="table-head">
									<tr class="titleRow">
										<th nowrap="true" style="border-left:0px solid black !important;" align="left">Section</th>
										<th nowrap="true" align="right">No. of Invoices</th>
										<th nowrap="true" align="right">Amount</th>
										<th nowrap="true" align="right">Taxable amount</th>
										<th nowrap="true" align="right">IGST</th>
										<th nowrap="true" align="right">CGST</th>
										<th nowrap="true" align="right">SGST</th>
										<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
									</tr>
								</thead>
								<tbody class="table-body">
									<xsl:for-each select="sec_sum">
									<xsl:variable name="sectionName"><xsl:value-of select="sec_nm"/></xsl:variable>
									<xsl:if test="not($sectionName='HSN') and not($sectionName='DOC_ISSUE') and not($sectionName='NIL')">
										<tr>
											<td style="border-left:0px solid black !important;" class="titleColumn">
												<xsl:if test="$sectionName='B2B'">
													Invoices for outward supply (B2B)
												</xsl:if>
												<xsl:if test="$sectionName='B2BA'">
													Revised invoices (B2B)
												</xsl:if>
												<xsl:if test="$sectionName='B2CL'">
													Invoices for outward supply (B2CL)
												</xsl:if>
												<xsl:if test="$sectionName='B2CLA'">
													Revised invoices (B2CL)
												</xsl:if>
												<xsl:if test="$sectionName='B2CS'">
													Invoices for outward supply (B2CS)
												</xsl:if>
												<xsl:if test="$sectionName='B2CSA'">
													Revised invoices (B2CS)
												</xsl:if>
												<xsl:if test="$sectionName='CDNR'">
													Credit/Debit note
												</xsl:if>
												<xsl:if test="$sectionName='CDNRA'">
													Revised Credit/Debit note
												</xsl:if>
												<xsl:if test="$sectionName='CDNUR'">
													Credit/Debit note unregistered
												</xsl:if>
												<xsl:if test="$sectionName='CDNURA'">
													Revised Credit/Debit note
												</xsl:if>
												<xsl:if test="$sectionName='AT'">
													Advance received
												</xsl:if>
												<xsl:if test="$sectionName='ATA'">
													Advance received amendment
												</xsl:if>
												<xsl:if test="$sectionName='TXPD'">
													Tax paid on advance received
												</xsl:if>
												<xsl:if test="$sectionName='NIL'">
													Nil supplies
												</xsl:if>
												<xsl:if test="$sectionName='EXP'">
													Export supplies
												</xsl:if>
												<xsl:if test="$sectionName='EXPA'">
													Revised Export supplies
												</xsl:if>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_rec">
														<xsl:value-of select="ttl_rec"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_val">
														<xsl:value-of select="ttl_val"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_tax">
														<xsl:value-of select="ttl_tax"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_igst">
														<xsl:value-of select="ttl_igst"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_cgst">
														<xsl:value-of select="ttl_cgst"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="ttl_sgst">
														<xsl:value-of select="ttl_sgst"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td style="border-right:0px solid black !important;" align="right">
												<xsl:choose>
													<xsl:when test="ttl_cess">
														<xsl:value-of select="ttl_cess"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
										</tr>
									</xsl:if>
									</xsl:for-each>
										<tr class="totalRow">
											<td style="border-left:0px solid black !important;"><b>Total</b></td>
											<td align="right" class="totalCol"></td>
											<td align="right" class="totalCol"></td>
											<td align="right" class="totalCol"></td>
											<td align="right" class="totalCol"></td>
											<td align="right" class="totalCol"></td>
											<td align="right" class="totalCol"></td>
											<td style="border-right:0px solid black !important;" align="right" class="totalCol"></td>
										</tr>
								</tbody>
							</table>
						</div>
					</xsl:for-each>
					<xsl:for-each select="b2b_invoices">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">I</div>
							<div class="invTypDiv">Invoices for outward supply (B2B)</div>
						</button>
						<div class="panel1">
							<xsl:for-each select="b2b">
								<button class="accordion2" type="button" expanded="false">
									Counter party GSTIN - <xsl:value-of select="ctin"/>
								</button>
								<div class="panel2">
									<xsl:for-each select="inv"> 
										<button class="accordion3" type="button" expanded="false">
											Invoice number - <xsl:value-of select="inum"/>, Date - <xsl:value-of select="idt"/>, Amount - <xsl:value-of select="val"/>
										</button>
										<div class="panel3">
											<table class="tableClass">
												<thead class="table-head">
													<tr>
														<th nowrap="true" style="border-left:0px solid black !important;" align="right">Serial #</th>
														<th nowrap="true" align="right">Taxable amount</th>
														<th nowrap="true" align="right">Rate</th>
														<th nowrap="true" align="right">IGST</th>
														<th nowrap="true" align="right">CGST</th>
														<th nowrap="true" align="right">SGST</th>
														<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
													</tr>
												</thead>
												<tbody class="table-body">
												<xsl:for-each select="itms">
													<tr class='trClass'>
														<td class="td_rightAlign" style="border-left:0px solid black !important;"><xsl:value-of select="num"/></td>
														<td class="td_rightAlign"><xsl:value-of select="itm_det/txval"/></td>
														<td class="td_rightAlign">
															<xsl:choose>
																<xsl:when test="itm_det/rt">
																	<xsl:value-of select="itm_det/rt"/>
																</xsl:when>
																<xsl:otherwise>
																	0
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td class="td_rightAlign">
															<xsl:choose>
																<xsl:when test="itm_det/iamt">
																	<xsl:value-of select="itm_det/iamt"/>
																</xsl:when>
																<xsl:otherwise>
																	0
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td class="td_rightAlign">
															<xsl:choose>
																<xsl:when test="itm_det/camt">
																	<xsl:value-of select="itm_det/camt"/>
																</xsl:when>
																<xsl:otherwise>
																	0
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td class="td_rightAlign">
															<xsl:choose>
																<xsl:when test="itm_det/samt">
																	<xsl:value-of select="itm_det/samt"/>
																</xsl:when>
																<xsl:otherwise>
																	0
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td class="td_rightAlign" style="border-right:0px solid black !important;">
															<xsl:choose>
																<xsl:when test="itm_det/csamt">
																	<xsl:value-of select="itm_det/csamt"/>
																</xsl:when>
																<xsl:otherwise>
																	0
																</xsl:otherwise>
															</xsl:choose>
														</td>
													</tr>
												</xsl:for-each>
												</tbody>
											</table>
										</div>
									</xsl:for-each>
								</div>
							</xsl:for-each>
						</div>
					</xsl:for-each>
					<xsl:for-each select="b2cl_invoices">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">I</div>
							<div class="invTypDiv">Invoices for outward supply (B2CL)</div>
						</button>
						<div class="panel1">
							<xsl:for-each select="b2cl/inv">
								<button class="accordion2" type="button" expanded="false">
									Invoice number - <xsl:value-of select="inum"/>, Date - <xsl:value-of select="idt"/>, Amount - <xsl:value-of select="val"/>
								</button>
								<div class="panel2">
									<table class="tableClass">
										<thead class="table-head">
											<tr>
												<th nowrap="true" style="border-left:0px solid black !important;" align="right">Serial #</th>
												<th nowrap="true" align="right">Taxable amount</th>
												<th nowrap="true" align="right">Rate</th>
												<th nowrap="true" align="right">IGST</th>
												<th nowrap="true" align="right">CGST</th>
												<th nowrap="true" align="right">SGST</th>
												<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
											</tr>
										</thead>
										<tbody class="table-body">
										<xsl:for-each select="itms">
											<tr class='trClass'>
												<td class="td_rightAlign" style="border-left:0px solid black !important;"><xsl:value-of select="num"/></td>
												<td class="td_rightAlign"><xsl:value-of select="itm_det/txval"/></td>
												<td class="td_rightAlign">
													<xsl:value-of select="itm_det/rt"/>
												</td>
												<td class="td_rightAlign">
													<xsl:choose>
														<xsl:when test="itm_det/iamt">
															<xsl:value-of select="itm_det/iamt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td class="td_rightAlign">
													<xsl:choose>
														<xsl:when test="itm_det/camt">
															<xsl:value-of select="itm_det/camt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td class="td_rightAlign">
													<xsl:choose>
														<xsl:when test="itm_det/samt">
															<xsl:value-of select="itm_det/samt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td class="td_rightAlign" style="border-right:0px solid black !important;">
													<xsl:choose>
														<xsl:when test="itm_det/csamt">
															<xsl:value-of select="itm_det/csamt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
											</tr>
										</xsl:for-each>
										</tbody>
									</table>
								</div>
							</xsl:for-each>
						</div>
					</xsl:for-each>
					<xsl:for-each select="b2cs_invoices">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">I</div>
							<div class="invTypDiv">Invoices for outward supply (B2CS)</div>
						</button>
						<div class="panel1">
							<table class="tableClass">
								<thead class="table-head">
									<tr>
										<th nowrap="true" style="border-left:0px solid black !important;" align="left">Supply type</th>
										<th nowrap="true" align="right">Taxable amount</th>
										<th nowrap="true" align="right">Rate</th>
										<th nowrap="true" align="right">IGST</th>
										<th nowrap="true" align="right">CGST</th>
										<th nowrap="true" align="right">SGST</th>
										<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
									</tr>
								</thead>
								<tbody class="table-body">
								<xsl:for-each select="b2cs">
									<xsl:variable name="supply_type"><xsl:value-of select="sply_ty"/></xsl:variable>
									<tr class='trClass'>
										<td class="td_lefttAlign" style="border-left:0px solid black !important;">
										<xsl:if test="$supply_type='INTER'">
											Inter state
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											Intra state
										</xsl:if>
										</td>
										<td class="td_rightAlign"><xsl:value-of select="txval"/></td>
										<td class="td_rightAlign"><xsl:value-of select="rt"/></td>
										<td class="td_rightAlign">
										<xsl:if test="$supply_type='INTER'">
											<xsl:value-of select="iamt"/>
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											0
										</xsl:if>
										</td>
										<td class="td_rightAlign">
										<xsl:if test="$supply_type='INTER'">
											0
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											<xsl:value-of select="camt"/>
										</xsl:if>
										</td>
										<td class="td_rightAlign">
										<xsl:if test="$supply_type='INTER'">
											0
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											<xsl:value-of select="samt"/>
										</xsl:if>
										</td>
										<td class="td_rightAlign" style="border-right:0px solid black !important;">
										  <xsl:choose>
										    <xsl:when test="csamt">
										      <xsl:value-of select="csamt"/>
										    </xsl:when>
										    <xsl:otherwise>
										      0
										    </xsl:otherwise>
										  </xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
								</tbody>
							</table>
						</div>
					</xsl:for-each>
					<xsl:for-each select="cdnr_data">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">C</div>
							<div class="invTypDiv">Credit/Debit note</div>
						</button>
						<div class="panel1">
							<xsl:for-each select="cdnr">
								<button class="accordion2" type="button" expanded="false">
									Counter party GSTIN - <xsl:value-of select="ctin"/>
								</button>
								<div class="panel2">
									<xsl:for-each select="nt"> 
										<button class="accordion3" type="button" expanded="false">
											<p style="font-size:15px;margin:0px;">Credit/Debit note number - <xsl:value-of select="nt_num"/>, Date - <xsl:value-of select="nt_dt"/>, Amount - <xsl:value-of select="val"/></p>
											<p style="margin:0px;">Reference invoice number - <xsl:value-of select="inum"/>, Date - <xsl:value-of select="idt"/></p>
										</button>
										<div class="panel3">
											<table class="tableClass">
												<thead class="table-head">
													<tr>
														<th nowrap="true" style="border-left:0px solid black !important;" align="right">Serial #</th>
														<th nowrap="true" align="right">Taxable amount</th>
														<th nowrap="true" align="right">Rate</th>
														<th nowrap="true" align="right">IGST</th>
														<th nowrap="true" align="right">CGST</th>
														<th nowrap="true" align="right">SGST</th>
														<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
													</tr>
												</thead>
												<tbody class="table-body">
												<xsl:for-each select="itms">
													<tr class='trClass'>
														<td class="td_rightAlign" style="border-left:0px solid black !important;"><xsl:value-of select="num"/></td>
														<td class="td_rightAlign"><xsl:value-of select="itm_det/txval"/></td>
														<td class="td_rightAlign"><xsl:value-of select="itm_det/rt"/></td>
														<td class="td_rightAlign">
															<xsl:choose>
																<xsl:when test="itm_det/iamt">
																	<xsl:value-of select="itm_det/iamt"/>
																</xsl:when>
																<xsl:otherwise>
																	0
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td class="td_rightAlign">
															<xsl:choose>
																<xsl:when test="itm_det/camt">
																	<xsl:value-of select="itm_det/camt"/>
																</xsl:when>
																<xsl:otherwise>
																	0
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td class="td_rightAlign">
															<xsl:choose>
																<xsl:when test="itm_det/samt">
																	<xsl:value-of select="itm_det/samt"/>
																</xsl:when>
																<xsl:otherwise>
																	0
																</xsl:otherwise>
															</xsl:choose>
														</td>
														<td class="td_rightAlign" style="border-right:0px solid black !important;">
															<xsl:choose>
																<xsl:when test="itm_det/csamt">
																	<xsl:value-of select="itm_det/csamt"/>
																</xsl:when>
																<xsl:otherwise>
																	0
																</xsl:otherwise>
															</xsl:choose>
														</td>
													</tr>
												</xsl:for-each>
												</tbody>
											</table>
										</div>
									</xsl:for-each>
								</div>
							</xsl:for-each>
						</div>
					</xsl:for-each>
					<xsl:for-each select="cdnur_data">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">C</div>
							<div class="invTypDiv">Credit/Debit note unregistered</div>
						</button>
						<div class="panel1">
							<xsl:for-each select="cdnur"> 
								<button class="accordion2" type="button" expanded="false">
									<p style="font-size:15px;margin:0px;">Credit/Debit note number - <xsl:value-of select="nt_num"/>, Date - <xsl:value-of select="nt_dt"/>, Amount - <xsl:value-of select="val"/></p>
									<p style="margin:0px;">Reference invoice number - <xsl:value-of select="inum"/>, Date - <xsl:value-of select="idt"/></p>
								</button>
								<div class="panel2">
									<table class="tableClass">
										<thead class="table-head">
											<tr>
												<th nowrap="true" style="border-left:0px solid black !important;" align="right">Serial #</th>
												<th nowrap="true" align="right">Taxable amount</th>
												<th nowrap="true" align="right">Rate</th>
												<th nowrap="true" align="right">IGST</th>
												<th nowrap="true" align="right">CGST</th>
												<th nowrap="true" align="right">SGST</th>
												<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
											</tr>
										</thead>
										<tbody class="table-body">
										<xsl:for-each select="itms">
											<tr class='trClass'>
												<td class="td_rightAlign" style="border-left:0px solid black !important;"><xsl:value-of select="num"/></td>
												<td class="td_rightAlign"><xsl:value-of select="itm_det/txval"/></td>
												<td class="td_rightAlign"><xsl:value-of select="itm_det/rt"/></td>
												<td class="td_rightAlign">
													<xsl:choose>
														<xsl:when test="itm_det/iamt">
															<xsl:value-of select="itm_det/iamt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td class="td_rightAlign">
													<xsl:choose>
														<xsl:when test="itm_det/camt">
															<xsl:value-of select="itm_det/camt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td class="td_rightAlign">
													<xsl:choose>
														<xsl:when test="itm_det/samt">
															<xsl:value-of select="itm_det/samt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td class="td_rightAlign" style="border-right:0px solid black !important;">
													<xsl:choose>
														<xsl:when test="itm_det/csamt">
															<xsl:value-of select="itm_det/csamt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
											</tr>
										</xsl:for-each>
										</tbody>
									</table>
								</div>
							</xsl:for-each>
						</div>
					</xsl:for-each>
					<xsl:for-each select="at_data">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">A</div>
							<div class="invTypDiv">Advance received</div>
						</button>
						<div class="panel1">
							<table class="tableClass">
								<thead class="table-head">
									<tr>
										<th nowrap="true" style="border-left:0px solid black !important;" align="left">Supply type</th>
										<th nowrap="true" align="right">Advance amount</th>
										<th nowrap="true" align="right">Rate</th>
										<th nowrap="true" align="right">IGST</th>
										<th nowrap="true" align="right">CGST</th>
										<th nowrap="true" align="right">SGST</th>
										<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
									</tr>
								</thead>
								<tbody class="table-body">
								<xsl:for-each select="at">
									<xsl:variable name="supply_type"><xsl:value-of select="sply_ty"/></xsl:variable>
									<tr class='trClass'>
										<td class="td_lefttAlign" style="border-left:0px solid black !important;">
										<xsl:if test="$supply_type='INTER'">
											Inter state
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											Intra state
										</xsl:if>
										</td>
										<td class="td_rightAlign"><xsl:value-of select="itms/ad_amt"/></td>
										<td class="td_rightAlign"><xsl:value-of select="itms/rt"/></td>
										<td class="td_rightAlign">
										<xsl:if test="$supply_type='INTER'">
											<xsl:value-of select="itms/iamt"/>
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											0
										</xsl:if>
										</td>
										<td class="td_rightAlign">
										<xsl:if test="$supply_type='INTER'">
											0
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											<xsl:value-of select="itms/camt"/>
										</xsl:if>
										</td>
										<td class="td_rightAlign">
										<xsl:if test="$supply_type='INTER'">
											0
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											<xsl:value-of select="itms/samt"/>
										</xsl:if>
										</td>
										<td class="td_rightAlign" style="border-right:0px solid black !important;">
											<xsl:choose>
											    <xsl:when test="itms/csamt">
											      <xsl:value-of select="itms/csamt"/>
											    </xsl:when>
											    <xsl:otherwise>
											      0
											    </xsl:otherwise>
										  	</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
								</tbody>
							</table>
						</div>
					</xsl:for-each>
					<xsl:for-each select="txp_data">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">T</div>
							<div class="invTypDiv">Tax paid on advance received</div>
						</button>
						<div class="panel1">
							<table class="tableClass">
								<thead class="table-head">
									<tr>
										<th nowrap="true" style="border-left:0px solid black !important;" align="left">Supply type</th>
										<th nowrap="true" align="right">Adjusted amount</th>
										<th nowrap="true" align="right">Rate</th>
										<th nowrap="true" align="right">IGST</th>
										<th nowrap="true" align="right">CGST</th>
										<th nowrap="true" align="right">SGST</th>
										<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
									</tr>
								</thead>
								<tbody class="table-body">
								<xsl:for-each select="txpd">
									<xsl:variable name="supply_type"><xsl:value-of select="sply_ty"/></xsl:variable>
									<tr class='trClass'>
										<td class="td_lefttAlign" style="border-left:0px solid black !important;">
										<xsl:if test="$supply_type='INTER'">
											Inter state
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											Intra state
										</xsl:if>
										</td>
										<td class="td_rightAlign"><xsl:value-of select="itms/ad_amt"/></td>
										<td class="td_rightAlign"><xsl:value-of select="itms/rt"/></td>
										<td class="td_rightAlign">
										<xsl:if test="$supply_type='INTER'">
											<xsl:value-of select="itms/iamt"/>
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											0
										</xsl:if>
										</td>
										<td class="td_rightAlign">
										<xsl:if test="$supply_type='INTER'">
											0
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											<xsl:value-of select="itms/camt"/>
										</xsl:if>
										</td>
										<td class="td_rightAlign">
										<xsl:if test="$supply_type='INTER'">
											0
										</xsl:if>
										<xsl:if test="$supply_type='INTRA'">
											<xsl:value-of select="itms/samt"/>
										</xsl:if>
										</td>
										<td class="td_rightAlign" style="border-right:0px solid black !important;">
											<xsl:choose>
											    <xsl:when test="itms/csamt">
											      <xsl:value-of select="itms/csamt"/>
											    </xsl:when>
											    <xsl:otherwise>
											      0
											    </xsl:otherwise>
										  	</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
								</tbody>
							</table>
						</div>
					</xsl:for-each>
					<xsl:for-each select="nil_data">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">N</div>
							<div class="invTypDiv">Nil rated supplies</div>
						</button>
						<div class="panel1">
							<table class="tableClass">
								<thead class="table-head">
									<tr>
										<th nowrap="true" style="border-left:0px solid black !important;" align="left">Supply type</th>
										<th nowrap="true" align="right">Nil supplies</th>
										<th nowrap="true" align="right">Exempted supplies</th>
										<th nowrap="true" style="border-right:0px solid black !important;" align="right">Non GST supplies</th>
									</tr>
								</thead>
								<tbody class="table-body">
								<xsl:for-each select="nil/inv">
									<xsl:variable name="supply_type"><xsl:value-of select="sply_ty"/></xsl:variable>
									<tr class='trClass'>
										<td class="td_lefttAlign" style="border-left:0px solid black !important;">
										<xsl:if test="$supply_type='INTRB2B'">
											Inter-State supplies to registered persons
										</xsl:if>
										<xsl:if test="$supply_type='INTRAB2B'">
											Intra-State supplies to registered persons
										</xsl:if>
										<xsl:if test="$supply_type='INTRB2C'">
											Inter-State supplies to unregistered persons
										</xsl:if>
										<xsl:if test="$supply_type='INTRAB2C'">
											Intra-State supplies to unregistered persons
										</xsl:if>
										</td>
										<td class="td_rightAlign"><xsl:value-of select="nil_amt"/></td>
										<td class="td_rightAlign"><xsl:value-of select="expt_amt"/></td>
										<td class="td_rightAlign" style="border-right:0px solid black !important;"><xsl:value-of select="ngsup_amt"/></td>
									</tr>
								</xsl:for-each>
								</tbody>
							</table>
						</div>
					</xsl:for-each>
					<xsl:for-each select="exp_data">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">E</div>
							<div class="invTypDiv">Export supplies</div>
						</button>
						<div class="panel1">
							<xsl:for-each select="exp/inv">
								<button class="accordion2" type="button" expanded="false">
									<p style="font-size:15px;margin:0px;">Invoice number - <xsl:value-of select="inum"/>, Date - <xsl:value-of select="idt"/>, Amount - <xsl:value-of select="val"/></p>
									<p style="font-size:13px;margin:0px;">Port code - <xsl:value-of select="sbpcode"/>, Shipping bill number - <xsl:value-of select="sbnum"/>, Date - <xsl:value-of select="sbdt"/></p>
								</button>
								<div class="panel2">
									<table class="tableClass">
										<thead class="table-head">
											<tr>
												<th nowrap="true" style="border-left:0px solid black !important;" align="left">Taxable value</th>
												<th nowrap="true" align="right">Rate</th>
												<th nowrap="true" align="right">IGST</th>
												<th nowrap="true" align="right">CGST</th>
												<th nowrap="true" align="right">SGST</th>
												<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
											</tr>
										</thead>
										<tbody class="table-body">
										<xsl:for-each select="itms">
											<tr class='trClass'>
												<td class="td_lefttAlign" style="border-left:0px solid black !important;"><xsl:value-of select="txval"/></td>
												<td class="td_rightAlign"><xsl:value-of select="rt"/></td>
												<td class="td_rightAlign">
													<xsl:choose>
														<xsl:when test="iamt">
															<xsl:value-of select="iamt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td class="td_rightAlign">
													<xsl:choose>
														<xsl:when test="camt">
															<xsl:value-of select="camt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td class="td_rightAlign">
													<xsl:choose>
														<xsl:when test="samt">
															<xsl:value-of select="samt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
												<td class="td_rightAlign" style="border-right:0px solid black !important;">
													<xsl:choose>
														<xsl:when test="csamt">
															<xsl:value-of select="csamt"/>
														</xsl:when>
														<xsl:otherwise>
															0
														</xsl:otherwise>
													</xsl:choose>
												</td>
											</tr>
										</xsl:for-each>
										</tbody>
									</table>
								</div>
							</xsl:for-each>
						</div>
					</xsl:for-each>
					<xsl:for-each select="hsnsum_data">
						<button class="accordion1" type="button" expanded="false">
							<div class="iconDiv">H</div>
							<div class="invTypDiv">HSN summary data</div>
						</button>
						<div class="panel1">
							<table class="tableClass">
								<thead class="table-head">
									<tr>
										<th nowrap="true" style="border-left:0px solid black !important;" align="right">Serial #</th>
										<th nowrap="true" align="left">Goods/Service code</th>
										<th nowrap="true" align="left">Description</th>
										<th nowrap="true" align="right">Quantity</th>
										<th nowrap="true" align="left">Unit</th>
										<th nowrap="true" align="right">Value</th>
										<th nowrap="true" align="right">Taxable value</th>
										<th nowrap="true" align="right">IGST</th>
										<th nowrap="true" align="right">CGST</th>
										<th nowrap="true" align="right">SGST</th>
										<th nowrap="true" style="border-right:0px solid black !important;" align="right">Cess</th>
									</tr>
								</thead>
								<tbody class="table-body">
								<xsl:for-each select="hsn/data">
									<tr class='trClass'>
										<td class="td_rightAlign" style="border-left:0px solid black !important;"><xsl:value-of select="num"/></td>
										<td class="td_lefttAlign"><xsl:value-of select="hsn_sc"/></td>
										<td class="td_lefttAlign"><xsl:value-of select="desc"/></td>
										<td class="td_rightAlign"><xsl:value-of select="qty"/></td>
										<td class="td_lefttAlign"><xsl:value-of select="uqc"/></td>
										<td class="td_rightAlign"><xsl:value-of select="val"/></td>
										<td class="td_rightAlign"><xsl:value-of select="txval"/></td>
										<td class="td_rightAlign">
											<xsl:choose>
												<xsl:when test="iamt">
													<xsl:value-of select="iamt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="td_rightAlign">
											<xsl:choose>
												<xsl:when test="camt">
													<xsl:value-of select="camt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="td_rightAlign">
											<xsl:choose>
												<xsl:when test="samt">
													<xsl:value-of select="samt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="td_rightAlign" style="border-right:0px solid black !important;">
											<xsl:choose>
												<xsl:when test="csamt">
													<xsl:value-of select="csamt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
								</tbody>
							</table>
						</div>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		</div>
		<div id="btnDiv">
			<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden" value="gstsalesdata_submit" name="OBJ_NAME" />
			<input type="hidden" value="" name="action" id="action" />
			<input type="submit" style="cursor:hand;margin-left:20px;" value="Finish" onclick="setActionVal('finish');return validateDetailForm();" class="button" title='Finish' id="finish"/>
		</div>
	</div>
	<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait" ></img>
		<span>Please wait......</span>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
