  package ibase.dashboard.sfa.servlet;
  
  import ibase.dashboard.sfa.ejb.TargetVsAchievementRemote;
import ibase.system.config.AppConnectParm;
  import ibase.webitm.utility.ITMException;
  import java.io.IOException;
  import java.io.OutputStream;
  import javax.naming.InitialContext;
  import javax.servlet.ServletException;
  import javax.servlet.http.HttpServlet;
  import javax.servlet.http.HttpServletRequest;
  import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;
  
  public class TargetVsAchievementServlet extends HttpServlet
  {
    private static final long serialVersionUID = 1L;
  
    public void doGet(HttpServletRequest request, HttpServletResponse response)
      throws IOException, ServletException
    {
    	doPost(request, response);
    }
  
    public void doPost(HttpServletRequest request, HttpServletResponse response)
      throws IOException, ServletException
    {
    	TargetVsAchievementRemote targetVsAchievement = null;
        InitialContext context = null;
        AppConnectParm appConnectParm = new AppConnectParm();
        String dataSourceName = "";
        String defaultPreCode = "";
        String empCode = "";
     
      try
      {
       response.setContentType("application/xml");
       dataSourceName = request.getParameter("dataSourceName");
       defaultPreCode = request.getParameter("PRD_SALESDASH");
       
       //Create seesion for getting Login Employee Code  from session 
        HttpSession session = request.getSession(true);
		ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
		empCode = userInfo.getEmpCode();
       context = new InitialContext(appConnectParm.getProperty());
       targetVsAchievement = (TargetVsAchievementRemote)context.lookup("ibase/TargetVsAchievement/remote");
       JSONObject jsonObjData = targetVsAchievement.getTargetVsAchievement(dataSourceName,defaultPreCode,empCode);
       OutputStream outputStream = response.getOutputStream();
       outputStream.write(jsonObjData.toString().getBytes());
       outputStream.flush();
       outputStream.close();
      }
      catch (Exception e)
      {
       System.out.println("Exception : TargetVsAchievementServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
        try
        {
        throw new ITMException(e);
        }
        catch (ITMException e1) {
         e1.printStackTrace();
        }
      }
    }
  }

