package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.B2CSA;

public class B2CSASerializer extends BaseSerializer<B2CSA>
{
	@Override
	public void serialize(B2CSA b2csa, JsonGenerator json, SerializerProvider serializerProvider)throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		
		json.writeStringField("omon", b2csa.orgPeriodCode);
		json.writeStringField("oty", b2csa.orgType);
		json.writeStringField("ohsn_sc", b2csa.orgItemOrServiceCode);
		json.writeStringField("osupst_cd", b2csa.orgStateCode);
		json.writeStringField("pos", b2csa.pos);
		json.writeNumberField("txval", b2csa.txval);
		json.writeNumberField("iamt", b2csa.iamt);
		json.writeNumberField("camt", b2csa.camt);
		json.writeNumberField("samt", b2csa.samt);
		json.writeNumberField("csamt", b2csa.csamt);
		
		if(b2csa.etin!=null)
        {
        	json.writeStringField("etin", b2csa.etin);
        }
		json.writeStringField("typ", b2csa.typ);
		
		json.writeEndObject();
	}
}
