/**
 *  Purpose: Dashboard for Inventory Occupancy, Reuest ID: D15DKAT008  
 *  Author: Sneha Mestry
 *  Date: 15-07-2015
 */

package ibase.webitm.servlet.wms;

import ibase.system.config.AppConnectParm;
import ibase.webitm.ejb.wms.InventoryOccupancyRemote;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class InventoryOccupancyServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		InventoryOccupancyRemote  inventoryOccupancyRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String siteCode = "TA821";
		try
		{
			response.setContentType("application/xml");
			dataSourceName = request.getParameter("dataSourceName"); 
			
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			siteCode = userInfo.getSiteCode();
			System.out.println(" siteCode :::::::::: " + siteCode);

			context = new InitialContext(appConnectParm.getProperty());
			inventoryOccupancyRemote = (InventoryOccupancyRemote) context.lookup("ibase/InventoryOccupancy/remote");

			//Here invoke EJB define method 
			JSONObject jsonObjData = (JSONObject)inventoryOccupancyRemote.getInventoryOccupancyDetails(dataSourceName, siteCode);	
			OutputStream outputStream = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for InventoryOccupancyServlet build to Graph and Grid===" + jsonObjData);	

			
		} 
		catch (Exception e)
		{
			System.out.println("Exception in: InventoryOccupancyServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}


}
