package ibase.dashboard.sfa.ejb;

import javax.ejb.Stateless;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import ibase.system.config.ConnDriver;

/**
 * Session Bean implementation class DashboardPortal
 */
@Stateless
public class DoctorsMeetingByClass extends ValidatorEJB implements DoctorsMeetingByClassRemote, DoctorsMeetingByClassLocal
{

	/**
	 * Default constructor.
	 */
	String salePersn = "";

	public String getSalePersn()
	{
		return salePersn;
	}

	public void setSalePersn(String salePersn)
	{
		this.salePersn = salePersn;
	}

	public DoctorsMeetingByClass()
	{

		// TODO Auto-generated constructor stub
	}

	public String getData() throws RemoteException, ITMException
	{
		return "";
	}
	/*
	 * private Connection getConn() throws ITMException { Connection conn =
	 * null; ConnDriver connDriver = new ConnDriver(); try { conn =
	 * connDriver.getConnectDB("DriverITM"); connDriver = null;
	 * 
	 * } catch (Exception e) { e.printStackTrace(); throw new ITMException(e); }
	 * connDriver = null; return conn; }
	 */

	public String getData(String loginCode) throws RemoteException, ITMException
	{
		String sql = "";
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer xmlData = null;
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			/*Calendar c= Calendar.getInstance();
			 java.util.Date date = new java.util.Date(c.getTimeInMillis());
			
			 cyear = new SimpleDateFormat("yy").format(date);
			 cmonth = new SimpleDateFormat("MMMM").format(date);	*/
			
			sql = "Select Sales_Pers.Sales_Pers as Sales_Pers, Sales_Pers.SP_Name as SP_Name, (Case When Strg_Meet.Strg_Type = 'D' then 'Doctor' End) as Cust_Type, (Case When Strg_Meet.Strg_Code Like 'UL%'  then 'Unlisted' Else Strg_Cust_Class.Class_Code_Descr End) as Category, Count(Strg_Meet.Strg_Code ) as Visits from Sales_Pers Inner Join Strg_Meet on Strg_Meet.Sales_Pers = Sales_Pers.Sales_Pers And Strg_Meet.Strg_Type = 'D' Inner Join Strg_Cust_Class on Strg_Meet.Strg_Type = Strg_Cust_Class.Cust_type and Strg_Meet.Strg_Class_Code = Strg_Cust_Class.Class_Code where Sales_Pers.Sales_Pers = ? and To_Char(Strg_Meet.Event_date,'MMYYYY') = To_Char(sysdate,'MMYYYY') Group By Sales_Pers.Sales_Pers, Sales_Pers.SP_Name, Strg_Meet.Strg_Type, (Case When Strg_Meet.Strg_Code Like 'UL%'  then 'Unlisted' Else Strg_Cust_Class.Class_Code_Descr End) Order By Category";
			pstmt = conn.prepareStatement(sql); 
			pstmt.setString(1, loginCode);
			
			rs = pstmt.executeQuery();
		//xmlData = new StringBuffer("<?xml version='1.0'?><chart caption='Doctors Meeting by Class for "+cmonth+"-"+cyear+"' baseFont='Arial' xAxisName='Category' yAxisName='Visits' showLabels='0' showLegend='1'>");
			
			xmlData = new StringBuffer("<?xml version=\"1.0\"?><Root>");
			while (rs.next())
			{
				xmlData.append("<Detail>");
				xmlData.append("<category>").append("<![CDATA[" + checkNull(rs.getString("Category"))+"]]>").append("</category>");
				xmlData.append("<visits>").append("<![CDATA[" + checkNull(rs.getString("Visits"))+"]]>").append("</visits>");
				xmlData.append("</Detail>");
			}
			xmlData.append("</Root>");
			System.out.println("XML DATA is= >"+xmlData);
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return xmlData.toString();
	}

	private String checkNull(String input)
	{
		System.out.print("in check null method =" + input);

		if (input == null)
		{
			input = "";
		} else
		{
			input = input.trim();
		}
		return input;
	}
}






















