package ibase.dashboard.sfa.servlet;
import ibase.dashboard.sfa.ejb.AdminPlanRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class AdminPlanDetailServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		AdminPlanRemote adminPlanRemote       = null;
		InitialContext context                = null;
		AppConnectParm appConnectParm         = null;
		String dataSourceName                 = "";
		String loginId = "",loginEmpCode = "",salePersons = "",period = "";
		String fromDate = "",toDate = "",spCode = "",prvSpCode = "";
		HttpSession session                   = null;
		JSONObject jsonObjData                = null;
		OutputStream outputStream             = null;
		UserInfoBean userInfo                 = null;
		try
		{
			response.setContentType("application/xml");
			session         = request.getSession(true);
			appConnectParm  = new AppConnectParm();
			userInfo        = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId         = userInfo.getLoginCode();
			loginEmpCode    = userInfo.getEmpCode();
			salePersons     = request.getParameter("salePersons");
			period          = request.getParameter("period");
			fromDate        = request.getParameter("fromDate");
			toDate          = request.getParameter("toDate");
			spCode          = request.getParameter("spCode");
			prvSpCode          = request.getParameter("prvSpCode");
			dataSourceName  = request.getParameter("dataSourceName");
			context         = new InitialContext(appConnectParm.getProperty());
			adminPlanRemote = (AdminPlanRemote) context.lookup("ibase/AdminPlan/remote");
			jsonObjData     = (JSONObject) adminPlanRemote.getAdminPlanDetail(dataSourceName,loginId,salePersons,loginEmpCode,period,fromDate,toDate,spCode,prvSpCode);
			outputStream    = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for AdminPlanDetailServlet build the Graph is===" + jsonObjData);
			
		}
		catch (Exception e)
		{
			System.out.println("Exception : AdminPlanDetailServlet :doPost() :"+ e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}
}