/**
 *  Purpose: to reset password for all the users, Reuest ID: S16EBAS030  
 *  Author: Sneha Mestry
 *  Date: 31-08-2016
 */

package ibase.webitm.servlet.wms;


import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;

import ibase.webitm.ejb.wms.ResetPasswordEJBLocal;

import ibase.webitm.utility.ITMException;

import java.io.IOException;

import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ResetPasswordServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	private String user_lang ="en"; 
	private String user_country = "US";
	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		System.out.println("******* in ResetPasswordServlet Servlet ******");

		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		
		ResetPasswordEJBLocal resetPasswordEJBLocal = null;
		String actionName = "", newPwdSHA256 = "", userCode = "", message = "", password = "", firstLogin = "";
		//HttpSession session = request.getSession();
		
		HttpSession session = request.getSession(true);
		try
		{
			response.setContentType("text/html");
			
			actionName = request.getParameter("actionName");
			newPwdSHA256 = request.getParameter("newPwdSHA256");
			userCode = request.getParameter("userCode");
			password = request.getParameter("password");
			firstLogin = (request.getParameter("firstLogin") != null && request.getParameter("firstLogin").equals("Y")) ? "1" : "0";
			
			/*System.out.println("request.getParameter=====>>"+request.getParameter("firstLogin"));
			System.out.println("actionName=========>>" + actionName);
			System.out.println("newPwdSHA256=========>>" + newPwdSHA256);
			System.out.println("userCode=========>>" + userCode);
			System.out.println("password=========>>" + password);
			System.out.println("firstLogin=========>>" + firstLogin);*/


			context = new InitialContext(appConnectParm.getProperty());
			resetPasswordEJBLocal = (ResetPasswordEJBLocal) context.lookup("ibase/ResetPasswordEJB/local");
			
			if(actionName.equalsIgnoreCase("RESET_PASSWORD")) 
			{
				boolean retStr = resetPasswordEJBLocal.validateUser(userCode, newPwdSHA256, password, firstLogin);
				
				System.out.println("retStr from EJB ===>>"+retStr);
				if (retStr) 
				{
					response.sendRedirect("/ibase/webitm/jsp/ResetPasswordSuccess.jsp");
				}
				else
				{
					message = "User not found. Enter Valid User Code and try again. ";
					response.sendRedirect("/ibase/webitm/jsp/ResetPassword.jsp?message="+message);  
				}
			}

		} 
		catch (Exception e) 
		{
			System.out.println("Exception : ResetPasswordServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} 
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
		finally
		{
			System.out.println("in Finally block for ResetPasswordServlet ");
		}
	}
}
