package ibase.e12ria.e12widgets.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasBlurHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasFocusHandlers;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
/**
 * <h3>This class are create a two type of check boxes </h3> <br>
 * <b>1st </b> is a slider check box. This only display in iPhone and iPad<br>
 * <b>2nd</b> is a GWT check box. This display in all devices but cannot display in iPhone and iPad    
 * 
 * @author
 * Dnyaneshwar Chavan
 * */
public class E12CheckBox extends Composite implements HasClickHandlers, HasFocusHandlers, HasBlurHandlers
{
	
	private String title;
	private String domID;
	private String osType;
	private boolean checkedSliderCheckBox;
	private boolean disableSliderCheckBox;
	private boolean focused;
	
	public static enum DeviceOS {
		iOS,
		Android,
	    Other
	};
	
	CheckBox checkBox;

	public E12CheckBox( DeviceOS deviceOS  )
	{
		Widget widget = null;
		widget = getSliderCheckBox( deviceOS );
		initWidget( widget );
	}
	
	private Widget getCheckBox() 
	{
		checkBox = new CheckBox();
		return checkBox;
	}
	
	private Widget getSliderCheckBox( DeviceOS deviceOS )
	{
		domID = "myonoffswitch" + DOM.createUniqueId();
		
		HTMLPanel htmlPanel = new HTMLPanel("");
		htmlPanel.setStyleName("onoffswitch");
		htmlPanel.addStyleName("switch-green");
		
		htmlPanel.addAttachHandler(new AttachEvent.Handler() {

			  @Override
			  public void onAttachOrDetach(AttachEvent event) {
			    setCheckBoxValue( domID, checkedSliderCheckBox );
			    setDisabled( domID, disableSliderCheckBox );
			    setTitle( domID, title );
			    if ( focused )
			    {
					focus( domID );
				} else 
				{
					blur( domID );
				}
			  }
		});
		
		// create CheckBox using a DOM 
		Element elementCheckBox = DOM.createInputCheck();
		elementCheckBox.setAttribute( "name", "onoffswitch" );
		elementCheckBox.setId( domID );
		elementCheckBox.setClassName( "onoffswitch-checkbox" );
		//elementCheckBox.setAttribute( "checked", "true" );
		elementCheckBox.setAttribute( "title", title );
		
		// create Label using a DOM
		Element elementLabel = DOM.createLabel();
		elementLabel.setAttribute( "class", "onoffswitch-label" );
		elementLabel.setAttribute( "for", domID );
		elementLabel.setAttribute( "id", "label"+domID );
		String dataOn = "ON";
		String dataOff = "OFF";
		if( deviceOS == DeviceOS.Android )
		{
			dataOn = "ON";
			dataOff = "0FF";
		}
		else if( deviceOS == DeviceOS.iOS )
		{
			dataOn = "I";
			dataOff = "O";
		}
		elementLabel.setAttribute( "data-on", dataOn );
		elementLabel.setAttribute( "data-off", dataOff );
		
		// create Div using a DOM
		Element elementOffSwitch = DOM.createDiv();
		Element elementOnSwitch = DOM.createDiv();
		elementOffSwitch.setClassName("onoffswitch-inner");
		elementOnSwitch.setClassName("onoffswitch-switch");
		
		elementLabel.appendChild( elementOffSwitch );
		elementLabel.appendChild( elementOnSwitch );
		
		htmlPanel.getElement().appendChild( elementCheckBox );
		htmlPanel.getElement().appendChild( elementLabel );
		
		return htmlPanel;
		
	}
	
	public boolean getValue()
	{
		if( !isAttached() )
		{
			return checkedSliderCheckBox;
		}
		else
		{
			return getCheckBoxValue( domID );
		}
	}
	public void setValue( boolean value )
	{
		printOnConsole( "E12CheckBox :: setValue() ["+value+"] isAttached["+isAttached()+"]" );
		printOnConsole( "E12CheckBox :: setValue() ["+value+"] isAttached["+isAttached()+"]" );
		if( !isAttached() )
		{
			checkedSliderCheckBox = value;
		}
		else
		{
			setCheckBoxValue( domID, value );
		}
	}
	
	public void setEnabled( boolean enabled)
	{
		if( !isAttached() )
		{
			disableSliderCheckBox = enabled;
		}
		else
		{
			setDisabled( domID, enabled );
		}
	}
	public String getTitle()
	{
		if( !isAttached() )
		{
			return title;
		}
		else
		{
			return getTitle( domID );
		}
	}
	public void setTitle( String title )
	{
		if( !isAttached() )
		{
			this.title = title;
		}
		else
		{
			setTitle( domID, title );
		}
	}
	

	public void setFocus(boolean focused) 
	{
		if( !isAttached() )
		{
			this.focused = focused;
		}
		else
		{
			if (focused) {
				focus( domID );
			} else {
				blur( domID );
			}
		}
	}
	public boolean isEnabled() {
		if( !isAttached() )
		{
			return !disableSliderCheckBox;
		}
		else
		{
			return !isDisabled( domID );
		}
	  }

	private native String getTitle( String domID ) 
	/*-{
			return $doc.getElementById( ""+domID ).title;
	}-*/;
	
	private native void setTitle(String domID, String title) 
	/*-{
			$doc.getElementById( ""+domID ).title = title;
			$doc.getElementById( "label"+domID ).title = title;
	}-*/;
	
	private native void setDisabled( String domID ,boolean disabled)
	/*-{
		$doc.getElementById( ""+domID ).disabled = disabled;
	}-*/;
	
	private native void setCheckBoxValue( String domID ,boolean value)
	/*-{
		$doc.getElementById( ""+domID ).checked = value;
	}-*/;
	
	private native boolean getCheckBoxValue(String domID )
	/*-{
		return $doc.getElementById( ""+domID ).checked;
	}-*/;
	
	/**
	 * Gives keyboard focus to this element.
	 */
	public final native void focus(String domID) /*-{
		$doc.getElementById("" + domID).focus();
	}-*/;

	/**
	 * Removes keyboard focus from this element.
	 */
	public final native void blur(String domID) /*-{
		$doc.getElementById("" + domID).blur();
	}-*/;  
	
	/**
	   * The control is unavailable in this context.
	   * 
	   * @see <a href="http://www.w3.org/TR/1999/REC-html401-19991224/interact/forms.html#adef-disabled">W3C HTML Specification</a>
	   */
	  public final native boolean isDisabled( String domID ) /*-{
	    return !!$doc.getElementById("" + domID).disabled;
	  }-*/;
	
	@Override
	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addDomHandler(handler, ClickEvent.getType());
	}
	
	public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) 
	{
	    // Is this the first value change handler? If so, time to add handlers
	    return addHandler(handler, ValueChangeEvent.getType());
	}

	@Override
	public HandlerRegistration addFocusHandler(FocusHandler handler) {
		return addDomHandler(handler, FocusEvent.getType());
	}

	@Override
	public HandlerRegistration addBlurHandler(BlurHandler handler) {
		return addDomHandler(handler, BlurEvent.getType());
	}
	
	public native static void printOnConsole( String value )
	/*-{
		if( typeof window.console !== "undefined" )
		{
			console.log( value );
		}	
	}-*/;
}