package ibase.client;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestBox.DefaultSuggestionDisplay;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.datepicker.client.DateBox;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;

public class InputListWidget extends Composite
{
	List<String> itemsSelected = new ArrayList<String>();
	StringBuffer defaultColVal = new StringBuffer();

	public String getDefltColVal()
	{
		return defltColVal;
	}

	public void setDefltColVal(String defltColVal)
	{
		this.defltColVal = defltColVal;
	}

	String defltColVal = "";

	public InputListWidget(String suggetions, HorizontalPanel popUpHPnl, FilterInfo filterInfo, String[] splitedArray)
	{
		final BulletList list = new BulletList();
		list.setTitle(filterInfo.getColDescr());
		list.getElement().setId(filterInfo.getFieldName());
		list.setStyleName("token-input-list");
		final ListItem item = new ListItem();
		item.setStyleName("token-input-input-token");
		final TextBox itemBox = new TextBox();
		itemBox.getElement().setAttribute("style", "outline-color: -moz-use-text-color; outline-style: none; outline-width: medium;");
		final SuggestBox box = new SuggestBox(getSuggestions(suggetions), itemBox);
		box.getElement().setId("suggestion_box");
		item.add(box);
		Paragraph paragraph = null;
		Span span = null;

		if (splitedArray != null)
		{
			for (int arrayCnt = 0; arrayCnt < splitedArray.length; arrayCnt++)
			{
				final ListItem onLodListItm = new ListItem();
				// onLodListItm.setStyleName("token-input-input-token");
				paragraph = new Paragraph();
				paragraph.setText(splitedArray[arrayCnt]);
				onLodListItm.setStyleName("token-input-token");
				onLodListItm.addClickHandler(new ClickHandler()
				{
					public void onClick(ClickEvent clickEvent)
					{
						onLodListItm.addStyleName("token-input-selected-token");
					}
				});
				span = new Span("x");
				span.addClickHandler(new ClickHandler()
				{
					public void onClick(ClickEvent clickEvent)
					{
						removeListItem(onLodListItm, list);
					}
				});
				onLodListItm.add(paragraph);
				onLodListItm.add(span);
				itemBox.setFocus(true);
				list.add(onLodListItm);
			}
		}
		list.add(item);
		itemBox.addKeyDownHandler(new KeyDownHandler()
		{
			public void onKeyDown(KeyDownEvent event)
			{
				if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER)
				{
					// only allow manual entries with @ signs (assumed email
					// addresses)
					if (itemBox.getValue().contains("@"))
						deselectItem(itemBox, list);
				}
				// handle backspace
				if (event.getNativeKeyCode() == KeyCodes.KEY_BACKSPACE)
				{
					if ("".equals(itemBox.getValue().trim()))
					{
						ListItem li = (ListItem) list.getWidget(list.getWidgetCount() - 2);
						Paragraph p = (Paragraph) li.getWidget(0);
						if (itemsSelected.contains(p.getText()))
						{
							itemsSelected.remove(p.getText());
							GWT.log("Removing selected item '" + p.getText() + "'", null);
							GWT.log("Remaining: " + itemsSelected, null);
						}
						list.remove(li);
						itemBox.setFocus(true);
					}
				}
			}
		});

		box.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>()
		{
			public void onSelection(SelectionEvent selectionEvent)
			{
				deselectItem(itemBox, list);
			}
		});

		popUpHPnl.add(list);
		//popUpHPnl.getElement().setAttribute("onclick", "document.getElementById('suggestion_box').focus()");
		box.setFocus(true);
	}

	public InputListWidget(HorizontalPanel popUpHPnl, final FilterInfo filterInfo, String[] splitedArray, final VerticalPanel popUpVPnl, final ArrayList<FilterInfo> filterList)
	{
		final BulletList bulletList = new BulletList();
		bulletList.setTitle(filterInfo.getColDescr());
		bulletList.getElement().setId(filterInfo.getFieldName());
		bulletList.setStyleName("token-input-list");
		final ListItem listItem = new ListItem();
		listItem.setStyleName("token-input-input-token");
		final TextBox itemBox = new TextBox();
		itemBox.getElement().setAttribute("style", "outline-color: -moz-use-text-color; outline-style: none; outline-width: medium;");
		final SuggestBox suggestBox = new SuggestBox(getSuggestions(""), itemBox);
		suggestBox.getElement().setId("suggestion_box");
		//added to set number of suggestions in suggestion box by sachin 29 sep 2015
		suggestBox.setLimit(50);
		//ended to set number of suggestions in suggestion box by sachin 29 sep 2015
		listItem.add(suggestBox);
		Paragraph paragraph = null;
		Span span = null;
  
		if (splitedArray != null)
		{
			for (int arrayCnt = 0; arrayCnt < splitedArray.length; arrayCnt++)
			{
				final ListItem onLodListItm = new ListItem();
				// onLodListItm.setStyleName("token-input-input-token");
				paragraph = new Paragraph();
				paragraph.setText(splitedArray[arrayCnt]);

				onLodListItm.setStyleName("token-input-token");

				onLodListItm.addClickHandler(new ClickHandler()
				{
					public void onClick(ClickEvent clickEvent)
					{
						onLodListItm.addStyleName("token-input-selected-token");
					}
				});

				span = new Span("x");
				span.addClickHandler(new ClickHandler()
				{
					public void onClick(ClickEvent clickEvent)
					{
						removeListItem(onLodListItm, bulletList);
					}
				});
				onLodListItm.add(paragraph);
				onLodListItm.add(span);
				itemBox.setFocus(true);
				//bulletList.add(onLodListItm);
			}
		}
		bulletList.add(listItem);

		itemBox.addKeyDownHandler(new KeyDownHandler()
		{
			public void onKeyDown(KeyDownEvent event)
			{
				if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER)
				{
					if (itemBox.getValue().contains("@"))
						deselectItem(itemBox, bulletList);
				}
				if (event.getNativeKeyCode() == KeyCodes.KEY_BACKSPACE)
				{
					if ("".equals(itemBox.getValue().trim()))
					{
						ListItem li = (ListItem) bulletList.getWidget(bulletList.getWidgetCount() - 2);
						Paragraph p = (Paragraph) li.getWidget(0);
						if (itemsSelected.contains(p.getText()))
						{
							itemsSelected.remove(p.getText());
							GWT.log("Removing selected item '" + p.getText() + "'", null);
							GWT.log("Remaining: " + itemsSelected, null);
						}
						bulletList.remove(li);
						itemBox.setFocus(true);
					}
				}
			}
		});

		suggestBox.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>()
		{
			public void onSelection(SelectionEvent selectionEvent)
			{
				deselectItem(itemBox, bulletList);
			}
		});

		SuggestBox suggestBox1 =(SuggestBox)listItem.getWidget(listItem.getWidgetCount()-1);
		final StringBuffer buffer = new StringBuffer();
		suggestBox.getTextBox().addKeyUpHandler(new KeyUpHandler()
		{
			@Override
			public void onKeyUp(KeyUpEvent event)
			{
				String inputTxt = suggestBox.getText();
				//if (inputTxt.trim().length() == 2)
				{
					if (!buffer.toString().equalsIgnoreCase(inputTxt.trim()))
					{
						if (event.getNativeKeyCode() != KeyEvent.VK_ENTER)
						{
							buffer.setLength(0);
							MultiWordSuggestOracle oracle = (MultiWordSuggestOracle) suggestBox.getSuggestOracle();
							oracle.clear();
							buffer.append(inputTxt);
							String url = getUrlForFltr(filterList, popUpVPnl, filterInfo);
							getDataForAutoComp(url, oracle,suggestBox);
						}
					}
				}
				/*suggestBox.setVisible(true);
				suggestBox.setAutoSelectEnabled(true);*/
			}
		});
		popUpHPnl.add(bulletList);
	}

	public InputListWidget(ArrayList<String> suggetions, HorizontalPanel popUpHPnl, SmrtFilterInfo smrtFilterInfo)
	{
		
		final BulletList list = new BulletList();
		list.setTitle(smrtFilterInfo.getFltrColName());
		list.getElement().setId(smrtFilterInfo.getFltrColName());
		list.setStyleName("token-input-list");
		ListItem item = new ListItem();
		item.setStyleName("token-input-input-token");
		final TextBox itemBox = new TextBox();
		itemBox.getElement().setAttribute("style", "outline-color: -moz-use-text-color; outline-style: none; outline-width: medium;");
		MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();
		SuggestBox box = null;

		for (String fltrData : suggetions)
		{
			oracle.add(fltrData);
		}
		box = new SuggestBox(oracle, itemBox);

		box.getElement().setId("suggestion_box");
		item.add(box);

		list.add(item);
		itemBox.addKeyDownHandler(new KeyDownHandler()
		{
			public void onKeyDown(KeyDownEvent event)
			{
				if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER)
				{
					if (itemBox.getValue().contains("@"))
						deselectItemWithoutDesc(itemBox, list);
				}
				// handle backspace
				if (event.getNativeKeyCode() == KeyCodes.KEY_BACKSPACE)
				{
					if ("".equals(itemBox.getValue().trim()))
					{
						ListItem li = (ListItem) list.getWidget(list.getWidgetCount() - 2);
						Paragraph p = (Paragraph) li.getWidget(0);
						if (itemsSelected.contains(p.getText()))
						{
							itemsSelected.remove(p.getText());
							GWT.log("Removing selected item '" + p.getText() + "'", null);
							GWT.log("Remaining: " + itemsSelected, null);
						}
						list.remove(li);
						itemBox.setFocus(true);
					}
				}
			}
		});

		box.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>()
		{
			public void onSelection(SelectionEvent selectionEvent)
			{
				deselectItemWithoutDesc(itemBox, list);
			}
		});

		popUpHPnl.add(list);
		//popUpHPnl.getElement().setAttribute("onclick", "document.getElementById('suggestion_box').focus()");
		box.setFocus(true);
	}

	private void deselectItemWithoutDesc(final TextBox itemBox, final BulletList list)
	{
		Paragraph paragraph = null;
		if (itemBox.getValue() != null && !"".equals(itemBox.getValue().trim()))
		{

			final ListItem displayItem = new ListItem();
			displayItem.setStyleName("token-input-token");

			paragraph = new Paragraph(itemBox.getValue());

			displayItem.addClickHandler(new ClickHandler()
			{
				public void onClick(ClickEvent clickEvent)
				{
					displayItem.addStyleName("token-input-selected-token");
				}
			});
			Span span = new Span("x");
			span.addClickHandler(new ClickHandler()
			{
				public void onClick(ClickEvent clickEvent)
				{
					removeListItem(displayItem, list);
				}
			});

			displayItem.add(paragraph);
			displayItem.add(span);
			GWT.log("Adding selected item '" + itemBox.getValue() + "'", null);
			itemsSelected.add(itemBox.getValue());
			GWT.log("Total: " + itemsSelected, null);
			list.insert(displayItem, list.getWidgetCount() - 1);
			itemBox.setValue("");
			itemBox.setFocus(true);
		}
	}

	private void deselectItem(final TextBox itemBox, final BulletList list)
	{
		String[] itmBoxArr = null;
		String itmBoxValue = "";
		if (itemBox.getValue() != null && !"".equals(itemBox.getValue().trim()))
		{

			final ListItem displayItem = new ListItem();
			displayItem.setStyleName("token-input-token");
			//Paragraph p = new Paragraph(itemBox.getValue());

			//*Added new code by sachin on 20/11/14//

			itmBoxValue = itemBox.getValue();

			itmBoxArr = itmBoxValue.split("-");
			System.out.println(" spltedVlaue=" + itmBoxArr[0]);

			/** End Added new code by sachin on 20/11/14 */
			Paragraph p = new Paragraph(itmBoxArr[itmBoxArr.length - 1].trim());
			displayItem.addClickHandler(new ClickHandler()
			{
				public void onClick(ClickEvent clickEvent)
				{
					displayItem.addStyleName("token-input-selected-token");
				}
			});
			Span span = new Span("x");
			span.addClickHandler(new ClickHandler()
			{
				public void onClick(ClickEvent clickEvent)
				{
					removeListItem(displayItem, list);
				}
			});

			displayItem.add(p);
			displayItem.add(span);
			// hold the original value of the item selected
			GWT.log("Adding selected item '" + itemBox.getValue() + "'", null);
			itemsSelected.add(itemBox.getValue());
			GWT.log("Total: " + itemsSelected, null);
			list.insert(displayItem, list.getWidgetCount() - 1);
			itemBox.setValue("");
			itemBox.setFocus(true);
		}

	}

	private void removeListItem(ListItem displayItem, BulletList list)
	{
		GWT.log("Removing: " + displayItem.getWidget(0).getElement().getInnerHTML(), null);
		itemsSelected.remove(displayItem.getWidget(0).getElement().getInnerHTML());
		list.remove(displayItem);
	}

	public MultiWordSuggestOracle getSuggestions(String xmlMetadata)
	{
		MultiWordSuggestOracle oracle = new MultiWordSuggestOracle();
		NodeList rootNodeList = null;
		Document document = null;
		Node groupNode = null;
		NodeList headerList = null;
		Node headerNode = null;
		NodeList detalList = null;
		Node detailNode = null;
		NodeList columnList = null;
		Node columnNode = null;
		String code = "";
		String descr = "";
		try
		{
			document = XMLParser.parse(xmlMetadata);
			if (document != null)
			{
				rootNodeList = document.getElementsByTagName("DOCUMENTROOT").item(0).getChildNodes();
				for (int rootCtr = 0; rootCtr < rootNodeList.getLength(); rootCtr++)
				{
					groupNode = rootNodeList.item(rootCtr);
					if ("GROUP0".equals(groupNode.getNodeName()))
					{
						headerList = groupNode.getChildNodes();
						for (int nodeCtr = 0; nodeCtr < headerList.getLength(); nodeCtr++)
						{
							headerNode = headerList.item(nodeCtr);
							if ("HEADER0".equals(headerNode.getNodeName()))
							{
								detalList = headerNode.getChildNodes();
								for (int headCtr = 0; headCtr < detalList.getLength(); headCtr++)
								{
									detailNode = detalList.item(headCtr);
									if ("DETAIL".equals(detailNode.getNodeName()))
									{
										columnList = detailNode.getChildNodes();
										for (int colNodCtr = 0; colNodCtr < 2; colNodCtr++)
										{
											columnNode = columnList.item(colNodCtr);
											if (colNodCtr == 0)
											{
												code = columnNode.getChildNodes().item(0).getNodeValue();
											} else if (colNodCtr == 1)
											{
												descr = columnNode.getChildNodes().item(0).getNodeValue();
											}
											//oracle.add(columnNode.getChildNodes().item(0).getNodeValue());
										}
										oracle.add(descr + " - " + code);
									}
								}
							}
						}
					}
				}
			}
		} catch (Exception e)
		{
			System.out.println(" Exception in  getparsing(String xmlMetadata)" + e.getMessage());
			e.printStackTrace();
		}

		return oracle;
	}

	private void getDataForAutoComp(String url, final MultiWordSuggestOracle oracle,final SuggestBox suggestBox)
	{
		try
		{
			RequestBuilder reqBuilder = new RequestBuilder(RequestBuilder.POST, url);
			reqBuilder.sendRequest(null, new RequestCallback()
			{
				@Override
				public void onResponseReceived(Request request, Response response)
				{
					NodeList rootNodeList = null;
					Document document = null;
					Node groupNode = null;
					NodeList headerList = null;
					Node headerNode = null;
					NodeList detalList = null;
					Node detailNode = null;
					NodeList columnList = null;
					Node columnNode = null;
					String code = "";
					String descr = "";
					String xmlMetadata = "";
					xmlMetadata = response.getText();
					document = XMLParser.parse(xmlMetadata);
					if (document != null)
					{
						rootNodeList = document.getElementsByTagName("DOCUMENTROOT").item(0).getChildNodes();
						for (int rootCtr = 0; rootCtr < rootNodeList.getLength(); rootCtr++)
						{
							groupNode = rootNodeList.item(rootCtr);
							if ("METADATA".equals(groupNode.getNodeName()))
							{
								headerList = groupNode.getChildNodes();
								for (int nodeCtr = 0; nodeCtr < headerList.getLength(); nodeCtr++)
								{
									headerNode = headerList.item(nodeCtr);

									if ("DEFAULT_COL".equals(headerNode.getNodeName()))
									{
										setDefltColVal(headerNode.getChildNodes().item(0).getNodeValue());
									}
								}

							} else if ("GROUP0".equals(groupNode.getNodeName()))
							{
								headerList = groupNode.getChildNodes();
								for (int nodeCtr = 0; nodeCtr < headerList.getLength(); nodeCtr++)
								{
									headerNode = headerList.item(nodeCtr);
									if ("HEADER0".equals(headerNode.getNodeName()))
									{
										detalList = headerNode.getChildNodes();
										for (int headCtr = 0; headCtr < detalList.getLength(); headCtr++)
										{
											detailNode = detalList.item(headCtr);
											if ("DETAIL".equals(detailNode.getNodeName()))
											{
												columnList = detailNode.getChildNodes();
												for (int colNodCtr = 0; colNodCtr < 2; colNodCtr++)
												{
													columnNode = columnList.item(colNodCtr);
													if (colNodCtr == 0)
													{
														code = columnNode.getChildNodes().item(0).getNodeValue();
													} else if (colNodCtr == 1)
													{
														descr = columnNode.getChildNodes().item(0).getNodeValue();
													}
												}
												oracle.add(descr + " - " + code);
											}
										}
									}
								}
							}
						}
					}
				
				
					final DefaultSuggestionDisplay suggestionDisplay = (DefaultSuggestionDisplay) suggestBox.getSuggestionDisplay();
					if (!suggestionDisplay.isSuggestionListShowing())
					{
						suggestBox.showSuggestionList();
					}
				
				}

				@Override
				public void onError(com.google.gwt.http.client.Request request, Throwable exception)
				{
					Window.alert("Error occured " + exception.getMessage());
				}
			});

		} catch (RequestException e)
		{
			Window.alert("Error occured " + e.getMessage());
		}

		//suggestBox.showSuggestionList();
		//setDefltColVal("");
	}

	private HashMap<String, String> getFltrSelectedData(ArrayList<FilterInfo> filterList, VerticalPanel popUpVPnl)
	{
		DateBox fltrDateBox = null;
		int row = 0;
		FlexTable grid = null;
		CheckBox checkBox = null;
		TextBox fltrTxtBox = null;
		ListBox fltrListBox=null;
		BulletList bulletList = null;
		ScrollPanel scrollPnl = null;
		FilterInfo fltrInfo = null;
		String colName = "";
		ListItem listItem = null;
		Paragraph paragraph = null;
		HorizontalPanel horizontalPanel = null;
		VerticalPanel verticalPanel = null;
		StringBuffer selectedChkBoxBuffer = null;
		/*  Added new  code by sachin  on 23 Sep 15*/
        SuggestBox suggestBox = null;
        String inputTxt ="";
        /* End  Added new  code by sachin on 23 Sep 15*/

		HashMap<String, String> fltrDataMap = new HashMap<String, String>();
		for (int i = 0; i < filterList.size(); i++)
		{
			fltrInfo = filterList.get(i);
			colName = fltrInfo.getFieldName();
			for (int scrlPnlCnt = 0; scrlPnlCnt < popUpVPnl.getWidgetCount(); scrlPnlCnt++)
			{
				if (popUpVPnl.getWidget(scrlPnlCnt) instanceof VerticalPanel)
				{
					verticalPanel = (VerticalPanel) popUpVPnl.getWidget(scrlPnlCnt);
					if (verticalPanel.getWidget(1) instanceof HorizontalPanel)
					{
						horizontalPanel = (HorizontalPanel) verticalPanel.getWidget(1);
						if (horizontalPanel.getWidget(0) instanceof ScrollPanel)
						{
							scrollPnl = (ScrollPanel) horizontalPanel.getWidget(0);
							selectedChkBoxBuffer = new StringBuffer();
							grid = (FlexTable) scrollPnl.getWidget();
							row = grid.getRowCount();
							for (int rowCnt = 1; rowCnt < row; rowCnt++)
							{
								checkBox = (CheckBox) grid.getWidget(rowCnt, 0);
								if (checkBox.getValue())
								{
									if (selectedChkBoxBuffer.length() != 0)
									{
										selectedChkBoxBuffer.append("," + grid.getText(rowCnt, 1).trim());
									} else
									{
										selectedChkBoxBuffer.append(grid.getText(rowCnt, 1).trim());
									}
								}
							}
							if (scrollPnl.getElement().getId().equals(colName))
							{
								if (selectedChkBoxBuffer.toString().trim().length() != 0)
								{
									fltrDataMap.put(fltrInfo.getFieldName(), selectedChkBoxBuffer.toString());
								}
							}
						} else if (horizontalPanel.getWidget(0) instanceof TextBox)
						{
							fltrTxtBox = (TextBox) horizontalPanel.getWidget(0);
							if (fltrTxtBox.getElement().getId().equals(colName))
							{
								if (!fltrTxtBox.getText().isEmpty())
								{
									fltrDataMap.put(fltrInfo.getFieldName(), fltrTxtBox.getText());
								}
							}
						} else if (horizontalPanel.getWidget(0) instanceof DateBox)
						{

							fltrDateBox = (DateBox) horizontalPanel.getWidget(0);

							if (fltrDateBox.getElement().getId().equals(colName))
							{
								{
									fltrDataMap.put(fltrInfo.getFieldName(), DateTimeFormat.getFormat("dd/MM/yyyy").format(fltrDateBox.getValue()));
									fltrDateBox.hideDatePicker();
								}
							}
						} else if (horizontalPanel.getWidget(0) instanceof BulletList)
						{
							bulletList = (BulletList) horizontalPanel.getWidget(0);
							selectedChkBoxBuffer = new StringBuffer();
							if (bulletList.getElement().getId().equals(colName))
							{
								/*  Added new  code by sachin for sending only newly enterd value for filter  on 23 Sep 15*/
                                listItem = (ListItem) bulletList.getWidget(bulletList.getWidgetCount() - 1);
                                suggestBox = (SuggestBox) listItem.getWidget(listItem.getWidgetCount() - 1);
                                inputTxt = suggestBox.getText();
                                /*
                                 * for (int j = 0; j <
                                 * bulletList.getWidgetCount(); j++) { if
                                 * (bulletList.getWidget(j) instanceof ListItem)
                                 * { listItem = (ListItem)
                                 * bulletList.getWidget(j); if
                                 * (listItem.getWidget(0) instanceof Paragraph)
                                 * { paragraph = (Paragraph)
                                 * listItem.getWidget(0);
                                 * 
                                 * if (selectedChkBoxBuffer.length() != 0) {
                                 * selectedChkBoxBuffer.append("," +
                                 * paragraph.getText().trim()); } else {
                                 * selectedChkBoxBuffer
                                 * .append(paragraph.getText().trim()); }
                                 * 
                                 * } else { SuggestBox box = (SuggestBox)
                                 * listItem.getWidget(0);
                                 * 
                                 * selectedChkBoxBuffer.append(box.getText()); }
                                 * } }
                                 */
                                
                                selectedChkBoxBuffer.append(inputTxt);
                                
                                /* End Added new  code by sachin on 23 Sep 15*/
                                if (selectedChkBoxBuffer.toString().trim().length() != 0)
                                {
                                        fltrDataMap.put(fltrInfo.getFieldName(), selectedChkBoxBuffer.toString());
                                }

							}
						}
						/**/
						else if (horizontalPanel.getWidget(0) instanceof ListBox)
						{
							fltrListBox = (ListBox) horizontalPanel.getWidget(0);
							if (fltrListBox.getElement().getId().equals(colName))
							{
								if (!fltrListBox.getItemText(fltrListBox.getSelectedIndex()).isEmpty())
								{
									fltrDataMap.put(fltrInfo.getFieldName(), ""+fltrListBox.getValue(fltrListBox.getSelectedIndex()));
									//fltrDataMap.put(fltrInfo.getFieldName(), ""+fltrListBox.getSelectedIndex());
								}
							}
						} 
						/**/
					}
				}
			}
		}
		return fltrDataMap;
	}

	private String getUrlForFltr(final ArrayList<FilterInfo> filterList, final VerticalPanel popUpVPnl, FilterInfo filterInfo)
	{
		String objName = filterInfo.getModName();
		String fieldName = filterInfo.getFieldName();
		final StringBuffer urlBuffer = new StringBuffer();
		String value = "";
		urlBuffer.append("/ibase/DashboardFilterServlet");
		urlBuffer.append("?FIELDNAME=" + fieldName);
		urlBuffer.append("&OBJ_NAME=" + objName);
		HashMap<String, String> fltrDataMap = getFltrSelectedData(filterList, popUpVPnl);
		Set<String> fltrDataSet = fltrDataMap.keySet();
		for (String key : fltrDataSet)
		{
			value = fltrDataMap.get(key);
			urlBuffer.append("&" + key + "=" + value);
		}
		return urlBuffer.toString();
	}

}
