package ibase.dashboard.crm.ejb;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class ContactCommDashboard implements ContactCommDashboardLocal, ContactCommDashboardRemote
{
	E12GenericUtility e12GenericUtility = new E12GenericUtility();

	public ContactCommDashboard()
	{

	}

	@SuppressWarnings({ "unchecked"})
	/*Modified by Anjali Rawankar on[10/05/2017][Start]
	 * [Purpose : Modify method declaration]
	 */
	//public JSONObject getCommunicationSchedule(String dataSourceName) throws RemoteException, ITMException
	public JSONObject getCommunicationSchedule(String dataSourceName,String loginCode) throws RemoteException, ITMException
	/*[Purpose : Modify method declaration]
	 * Modified by Anjali Rawankar on[10/05/2017][End]
	 */
	{
		StringBuffer xmlString = null;
		JSONObject rowDataBasicJsn = new JSONObject();
		JSONObject rowData = null;
		String sql = "" ,sql1 = "" , sql2 = "";
		ResultSet rs = null,rs1 = null,rs2 = null;
		PreparedStatement pstmt = null,pstmt1 = null,pstmt2 = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		int count = 0;
		String commPlanId ="",plandate = "",salesPers ="",sconCode = "",commDate = "",contactType = "",
				activityCode = "",planDetail = "",commId = "",resultFlag = "",spName = "";
		Date planDate1= null,commDate1 = null;
		String newPlanDate = "",newCommDate = "";
		String firstName ="",lastName = "",emailAddr = "" ,mobileNo = "",sorgCode = "",sorgName = "",contactPerson = "";
		String dbDateFormat = "",applDateFormat = "";
		
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();	
			conn = connDriver.getConnectDB(dataSourceName);
			
			dbDateFormat = genericUtility.getDBDateFormat();
			applDateFormat = genericUtility.getApplDateFormat();
			
			/*Modified by Anjali Rawankar on [10/05/2017][start]
			 *[Purpose : xmlString initialize inside while loop] 
			 */
			/*xmlString = new StringBuffer("<table class='mtBackgroundWhite' border=''><tbody><tr>"
						+ "<th class='mtBackgroundWhite' style='width: 4%;'>Sales Person</th>" 
						+"<th class='mtBackgroundWhite' colspan='2' style='width: 4%;'> Date </th>"
						+"<th class='mtBackgroundWhite' colspan='' style='width: 4%;'> Contact Person</th>"
						+"<th class='mtBackgroundWhite' style='width: 4%;'>Orgnization</th>"
						+"<th class='mtBackgroundWhite' style='width: 4%;'>Plan Detail</th>"
						+"</tr>");
			/*[Purpose : xmlString initialize inside while loop]
			 *Modified by Anjali Rawankar on [10/05/2017][End] 
			 */


			/*Modified by Anjali Rawankar on[10/05/2017][Start]
			 * [Purpose : Added where clause for sales_pers]
			 */
			/*sql = "SELECT (STR.FIRST_NAME||' '||STR.LAST_NAME) AS CONTACT_PERSON,"+
						" STR.SORG_CODE, "+
						" STR.EMAIL_ADDR, "+
						" STR.MOBILE_NO, "+
						" SP.SP_NAME, "+
						" COM.COMM_PLAN_ID, "+
						" COM.PLAN_DATE, "+
						" COM.ACTIVITY_CODE, "+
						" COM.COMM_ID, "+
						" COM.RESULT_FLAG, "+
						" COM.SALES_PERS, "+
						" COM.SCON_CODE, "+
						" TO_CHAR(COM.COMM_DATE,'DD-MM-YYYY')AS NEW_COMM_DATE, "+
						" CASE COM.CONTACT_TYPE WHEN '1' THEN 'CALL' WHEN '2' THEN 'MAIL' WHEN '3' THEN 'MEETING' WHEN '4' "+ 
						" THEN 'VIDEOCONFERENCING'WHEN '5' THEN 'OTHERS'END AS DESCR," +
						" COM.PLAN_DETAIL," +
						" COM.START_TIME," +
						" COM.END_TIME "+ 
						" FROM CONTACT_COMM_PLAN COM " +
						" INNER JOIN STRG_CONTACT STR ON COM.SCON_CODE=STR.SCON_CODE  " +
						" INNER JOIN SALES_PERS SP ON  COM.SALES_PERS=SP.SALES_PERS "+
						" WHERE COMM_DATE >= SYSDATE ORDER:03-04-2017 BY SP.SP_NAME,NEW_COMM_DATE";*/
			/*Modified by Anjali Rawankar on[12/05/2017][Start]
			 * [Purpose : Chnage sql statement]
			 */
			/*sql = "SELECT (STR.FIRST_NAME||' '||STR.LAST_NAME) AS CONTACT_PERSON,"+
					" STR.SORG_CODE, "+
					" STR.EMAIL_ADDR, "+
					" STR.MOBILE_NO, "+
					" SP.SP_NAME, "+
					" COM.COMM_PLAN_ID, "+
					" COM.PLAN_DATE, "+
					" COM.ACTIVITY_CODE, "+
					" COM.COMM_ID, "+
					" COM.RESULT_FLAG, "+
					" COM.SALES_PERS, "+
					" COM.SCON_CODE, "+
					" TO_CHAR(COM.COMM_DATE,'DD-MM-YYYY')AS NEW_COMM_DATE, "+
					" CASE COM.CONTACT_TYPE WHEN '1' THEN 'CALL' WHEN '2' THEN 'MAIL' WHEN '3' THEN 'MEETING' WHEN '4' "+ 
					" THEN 'VIDEOCONFERENCING'WHEN '5' THEN 'OTHERS'END AS DESCR," +
					" COM.PLAN_DETAIL," +
					" COM.START_TIME," +
					" COM.END_TIME "+ 
					" FROM CONTACT_COMM_PLAN COM " +
					" INNER JOIN STRG_CONTACT STR ON COM.SCON_CODE=STR.SCON_CODE  " +
					" INNER JOIN SALES_PERS SP ON  COM.SALES_PERS=SP.SALES_PERS "+
					" WHERE COMM_DATE >= SYSDATE AND  COM.SALES_PERS = ? "+
					" ORDER BY SP.SP_NAME,NEW_COMM_DATE";*/
			sql  = "select sales_pers from sales_pers where emp_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				salesPers = rs.getString("sales_pers");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "SELECT (STR.FIRST_NAME||' '||STR.LAST_NAME) AS CONTACT_PERSON,"+
					" STR.SORG_CODE, "+
					" STR.EMAIL_ADDR, "+
					" STR.MOBILE_NO, "+
					" SP.SP_NAME, "+
					" COM.COMM_PLAN_ID, "+
					" COM.PLAN_DATE, "+
					" COM.ACTIVITY_CODE, "+
					" COM.COMM_ID, "+
					" COM.RESULT_FLAG, "+
					" COM.SALES_PERS, "+
					" COM.SCON_CODE, "+
					" COM.COMM_DATE AS NEW_COMM_DATE, "+
					" CASE COM.CONTACT_TYPE WHEN '1' THEN 'CALL' WHEN '2' THEN 'MAIL' WHEN '3' THEN 'MEETING' WHEN '4' "+ 
					" THEN 'VIDEOCONFERENCING'WHEN '5' THEN 'OTHERS'END AS DESCR," +
					" COM.PLAN_DETAIL," +
					" COM.START_TIME," +
					" COM.END_TIME ," +
					" COM.START_DATE," +
					" COM.END_DATE , " +
					" COM.REMARKS "+ 
					" FROM CONTACT_COMM_PLAN COM " +
					" INNER JOIN STRG_CONTACT STR ON COM.SCON_CODE=STR.SCON_CODE  " +
					" INNER JOIN SALES_PERS SP ON  COM.SALES_PERS=SP.SALES_PERS "+
					" WHERE COMM_DATE >= TRUNC(SYSDATE) AND  COM.SALES_PERS = ? "+
					" ORDER BY SP.SP_NAME,NEW_COMM_DATE";
			/*[Purpose : Chnage sql statement]
			 * Modified by Anjali Rawankar on[12/05/2017][End]
			 */

			/*[Purpose : Added where clause for sales_pers]
			 * Modified by Anjali Rawankar on[10/05/2017][End]
			 */
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);// Modified by Anjali Rawankar on[10/05/2017]
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				/*Modified by Anjali Rawankar on[10/05/2017][Start]
				 * [Purpose : added table definition]
				 */
				count++;
				if(count == 1)
				{
					xmlString = new StringBuffer("<table class='mtBackgroundWhite' border=''><tbody><tr>"
							+ "<th class='mtBackgroundWhite' style='width: 4%;'>Sales Person</th>" 
							+"<th class='mtBackgroundWhite' colspan='' style='width: 4%;'> Date </th>"
							+"<th class='mtBackgroundWhite' colspan='' style='width: 4%;'> Contact Person</th>"
							+"<th class='mtBackgroundWhite' style='width: 4%;'>Plan Detail</th>"
							+"</tr>");
				}
				/*[Purpose : added table definition]
				 * Modified by Anjali Rawankar on[10/05/2017][End]
				 */
				spName = checkNull(rs.getString("sp_name"));
				contactPerson = checkNull(rs.getString("contact_person"));
				sorgCode = checkNull(rs.getString("sorg_code"));
				emailAddr = checkNull(rs.getString("email_addr"));
				mobileNo = checkNull(rs.getString("mobile_no"));
				commDate1 = rs.getDate("NEW_COMM_DATE");
				String newdate = (commDate1 != null )? genericUtility.getValidDateString(commDate1.toString(), dbDateFormat, applDateFormat ):null;
				
				sql1="";
				sql1 = "select sorg_name from strg_org where sorg_code = ?";
				pstmt1 =  conn.prepareStatement(sql1);
				pstmt1.setString(1,sorgCode);
				rs1 = pstmt1.executeQuery();
				while (rs1.next())
				{
					sorgName = rs1.getString("sorg_name");
					System.out.println("Organization name :::: ["+sorgName+"]");
				}
				/*Modified by Anjali Rawankar on[10/05/2017][Start]
				 * [Purpose : close resultset and preparedstatment]
				 */
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;	
				}
				/*[Purpose : close resultset and preparedstatment]
				 * Modified by Anjali Rawankar on[10/05/2017][End]
				 */
				xmlString.append("<tr><td class= 'cardHtmlTableBodyAlignLft' rowspan='4' style='width: 4%;'>"+spName+"</td>");
				xmlString.append("<td  rowspan = '2' class= 'cardHtmlTableBodyAlignLft'  style='width: 4%;'>"+newdate+"</td> ");
				xmlString.append("<td class= 'cardHtmlTableBodyAlignLft' style='width: 4%;'>"+contactPerson+"</td>");
				xmlString.append("<td class= 'cardHtmlTableBodyAlignLft' rowspan='4'style='width: 4%;'>"+checkNull(rs.getString("plan_detail"))+"</td></tr>");
				xmlString.append("<tr><td class= 'cardHtmlTableBodyAlignLft' style='width: 4%;border-top: 1px solid transparent;vertical-align:top;'>"+sorgName+"</td></tr>");
				xmlString.append("<tr><td  rowspan = '2' class= 'cardHtmlTableBodyAlignLft' style='width: 4%;border-top: 1px solid transparent;vertical-align:top;'>From:"+checkNull(rs.getString("start_time"))+" To:"+checkNull(rs.getString("end_time"))+"</td>");
				xmlString.append("<td class= 'cardHtmlTableBodyAlignLft' style='width: 4%;border-top: 1px solid transparent;'>"+emailAddr+"</td></tr>");
				xmlString.append("<tr><td class= 'cardHtmlTableBodyAlignLft' style='width: 4%;border-top: 1px solid transparent;'><img src='../webitm/images/Standard/tele-1-1.ico' style='width:10px;height:10px;'>"+mobileNo+"</td></tr>");
				
			}

			/*Modified by Anjali Rawankar on[10/05/2017][Start]
			 *[Purpose : else condition for table definition in case of data not available]
			 */
			if(count == 0)
			{
				/*Modified by Anjali Rawankar on[12/05/2017][Start]
				 *[Purpose : Changed table definition]
				 */
				/*xmlString = new StringBuffer("<table  id='htmlTable' cellpadding='2'"+
						"align='center'><tr><td align = 'center' class='gwt-ScrollTable'>No "+
						"Data Found</td></tr></table>");*/
				xmlString = new StringBuffer("<table  id='htmlTable' cellpadding='2'"+
						"align='center'><tbody><tr><td align = 'center' class='gwt-ScrollTable'>No "+
						"Data Found</td></tr>");
				/*[Purpose : Changed table definition]
				 * Modified by Anjali Rawankar on[12/05/2017][End]
				 *
				 */
			}
			/*[Purpose : else condition for table definition in case of data not available]
			 *Modified by Anjali Rawankar on[10/05/2017][End]
			 */
			System.out.println("xmlString ::::[ "+xmlString+" ]");
			xmlString.append("</tbody></table>");
			rowData =new JSONObject();
			rowData.put("xmlString", xmlString.toString());
			rowDataBasicJsn.put(0,rowData);
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;	
			}
		} 
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (conn != null)
				{
					conn.close();
					conn = null;
				}	
				conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in : ContactCommDashboard : ContactCommDashboard :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataBasicJsn;
	}
	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str.trim();
		}
	}

}