package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import ibase.utility.GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;

import org.w3c.dom.Document;

/**
 * Session Bean implementation class StdPayStruPrs
 */
@Stateless
public class StdPayStruPrs extends ValidatorEJB implements StdPayStruPrsRemote, StdPayStruPrsLocal 
{
	public String preSave() throws RemoteException, ITMException
	{
		return "";
	}

	public String preSave(String domString, String editFlag, String xtraParams,
			Connection con) throws RemoteException, ITMException 
	{
		String retString = "";
		String effDate = "";
		Date effDateDB = null;
		String payTable = "", grade = "", adCode = "";
		String newDate = "";
		String userId = "";
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		Document dom = null;
		Calendar calendar = null;
		GenericUtility genericUtility = null;
		Date newDateDB = null;

		try
		{
			con.setAutoCommit( false );

			genericUtility = GenericUtility.getInstance();
			dom = genericUtility.parseString(domString);
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			calendar = Calendar.getInstance();
			
			System.out.println("domString StdPayStruPrs ["+domString+"]");
			
			if(editFlag.equalsIgnoreCase("A"))
			{
				effDate =  checkNull(genericUtility.getColumnValue("eff_date", dom));			
			
				if(effDate != null && effDate.length() > 0)
				{
					userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
					effDateDB = Date.valueOf(genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
					System.out.println("effDateDB :: " + effDateDB);
				
					java.util.Date myDate = sdf.parse(effDate);
					calendar.setTime(myDate);
					calendar.add(Calendar.DAY_OF_YEAR, -1);
						
					newDate = sdf.format(calendar.getTime());
					newDateDB = Date.valueOf(genericUtility.getValidDateString(newDate, genericUtility.getApplDateFormat(), getDBDateFormat()));
				
					payTable = checkNull(genericUtility.getColumnValue("pay_table", dom));
					grade = checkNull(genericUtility.getColumnValue("grade", dom));
					adCode = checkNull(genericUtility.getColumnValue("ad_code", dom));
			
					System.out.println(" newDate :: " + newDate);		
					System.out.println(" newDateDB :: " + newDateDB);
			
					int cnt=0;
					sql = "SELECT COUNT(1) AS ROWCOUNT FROM STD_PAYSTRU WHERE PAY_TABLE = ? AND GRADE = ? AND AD_CODE =? AND EFF_DATE <= ? AND VALID_UPTO >= ?";
					pstmt = con.prepareStatement(sql);
					pstmt.setString(1, payTable);
					pstmt.setString(2, grade);
					pstmt.setString(3, adCode);
					pstmt.setDate(4, effDateDB);
					pstmt.setDate(5, effDateDB);
					rs = pstmt.executeQuery();
			
					System.out.println(" SQL :: " + sql);
			
					if(rs.next())
					{
						cnt = rs.getInt("ROWCOUNT");
					}
					if( rs != null)
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
			
					System.out.println("Existing RowCount :: " + cnt);
			
					if (cnt > 0)
					{
						int updCount = 0;
						sql = "UPDATE STD_PAYSTRU SET VALID_UPTO = ? WHERE PAY_TABLE = ? AND GRADE = ? AND AD_CODE = ? AND EFF_DATE <= ? AND VALID_UPTO >= ?";
						pstmt = con.prepareStatement(sql);
						pstmt.setDate(1, newDateDB);
						pstmt.setString(2, payTable);
						pstmt.setString(3, grade);
						pstmt.setString(4, adCode);
						pstmt.setDate(5, effDateDB);
						pstmt.setDate(6, effDateDB);
						updCount = pstmt.executeUpdate();
						if( pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(cnt != updCount)
						{
							retString = getErrorString("eff_date", "VMSTDPAY11", userId);
							con.rollback();
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :StdPaystruPrs : :==>\n"+e.getMessage());
			e.printStackTrace();
			try
			{
				System.out.println("Before rollback");
				con.rollback();
			}
		
			catch(SQLException sqle)
			{
                System.out.println(sqle);
			}
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :StdPayStruPrs : :==>\n"+e.getMessage());
				try
				{
					System.out.println("Before rollback");
					con.rollback();
				}
			
				catch(SQLException sqle)
				{
                    System.out.println(sqle);
				}
				throw new ITMException(e);
			
			}
		}
		System.out.println("Return string :"+retString);
		return retString;
	}
		
	private String checkNull(String input) 
	{
		if (input == null) 
		{
			input = "";
		} 
		else 
		{
			input = input.trim();
		}
		return input;
	}
}