package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.InterStateSupplies;
import ibase.webitm.bean.gst.InterStateSuppliesData;

public class InterStateSuppliesSerailizer extends JsonSerializer<InterStateSupplies> 
{
	@Override
	public void serialize(InterStateSupplies interStateSupplies, JsonGenerator json, SerializerProvider serializerProvider)	throws IOException, JsonProcessingException 
	{
		if(interStateSupplies != null)
		{
			json.writeStartObject();
			
			if(interStateSupplies.interUnregisterSuppliesData!=null)
			{
				json.writeFieldName("unreg_details");
				json.writeStartArray();
				for(InterStateSuppliesData eachData : interStateSupplies.interUnregisterSuppliesData)
				{
					json.writeStartObject();
					json.writeStringField("pos", eachData.placeOfSupply);
					json.writeNumberField("txval", eachData.taxableAmount);
					json.writeNumberField("iamt", eachData.igstAmount);
					json.writeNumberField("csamt", eachData.cessAmount);
					json.writeEndObject();
				}
				json.writeEndArray();
			}
			if(interStateSupplies.compositionSuppliesData!=null)
			{
				json.writeFieldName("comp_details");
				json.writeStartArray();
				for(InterStateSuppliesData eachData : interStateSupplies.compositionSuppliesData)
				{
					json.writeStartObject();
					json.writeStringField("pos", eachData.placeOfSupply);
					json.writeNumberField("txval", eachData.taxableAmount);
					json.writeNumberField("iamt", eachData.igstAmount);
					json.writeNumberField("csamt", eachData.cessAmount);
					json.writeEndObject();
				}
				json.writeEndArray();
			}
			if(interStateSupplies.uinSuppliesData!=null)
			{
				json.writeFieldName("uin_details");
				json.writeStartArray();
				for(InterStateSuppliesData eachData : interStateSupplies.uinSuppliesData)
				{
					json.writeStartObject();
					json.writeStringField("pos", eachData.placeOfSupply);
					json.writeNumberField("txval", eachData.taxableAmount);
					json.writeNumberField("iamt", eachData.igstAmount);
					json.writeNumberField("csamt", eachData.cessAmount);
					json.writeEndObject();
				}
				json.writeEndArray();
			}
			
			json.writeEndObject();
		}
	}
}
