package ibase.e12ria.e12widgets.shared;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


public class FileViewer
{
	final static HashMap<String,String> contentTypeMap = new HashMap<String, String>();
	protected String fileType;
	protected String contentType;
	
	static
	{
		contentTypeMap.put( "pdf", "application/pdf" );
		contentTypeMap.put("xls", "application/vnd.ms-excel");
		contentTypeMap.put("avi","video/x-msvideo" );
		contentTypeMap.put("doc","application/msword" );
		contentTypeMap.put("bmp","image/bmp" );
		contentTypeMap.put("ppt","application/powerpoint" );
		contentTypeMap.put( "html","text/html" );
		contentTypeMap.put("htm" ,"text/html" );
		contentTypeMap.put( "txt", "text/plain");
		contentTypeMap.put( "dtd", "text/plain");
		contentTypeMap.put("odt" , "application/msword");
		contentTypeMap.put( "gif","image/gif" );
		contentTypeMap.put("jpe" ,"image/jpeg" );
		contentTypeMap.put( "jpg", "image/jpeg");
		contentTypeMap.put( "jpeg", "image/jpeg");
		contentTypeMap.put("mpg" , "video/mpeg");
		contentTypeMap.put( "mpeg","video/mpeg" );
		contentTypeMap.put( "pic","image/pict" );
		contentTypeMap.put( "pict", "image/pict");
		contentTypeMap.put("oda" ,"application/oda" );
		contentTypeMap.put("zip" , "application/zip");
		contentTypeMap.put("jsp" , "text/html" );
		contentTypeMap.put( "base", "application/x-shockwave-flash" );
		//contentTypeMap.put( "base", "video/avi" );
		contentTypeMap.put( "png", "image/jpeg" );
		contentTypeMap.put( "avi", "video/avi" );
	}

	public static class FileParams
	{
		protected String fileUrl ;
		protected String fileContentType ;
		
		public void setFileContentType( String fileContentType )
		{
			this.fileContentType = fileContentType;
		}
		
		public void setFileUrl( String fileUrl )
		{
			this.fileUrl = fileUrl;
		}
		
		public String getFileContentType()
		{
			return fileContentType;
		}
		
		public String getFileUrl()
		{
			return fileUrl;
		}
		
		protected List<String> toJsonList()
		{
			List<String> jsonList = new ArrayList<String>();
			if(fileUrl != null )
			{
				jsonList.add( "\"fileUrl\":\""+fileUrl+"\""  );
			}
			if ( fileContentType != null )
			{
				jsonList.add( "\"fileContentType\":\""+fileContentType+"\"" );
			}
			return jsonList;
		}
		
		protected String toJsonString()
		{
			StringBuilder JsonString = new StringBuilder();
			JsonString.append( "{" );
			for( String str : toJsonList() )
			{
				JsonString.append( str +"," );
			}
			if( JsonString.charAt( JsonString.length()-1 ) ==',')
			{
				JsonString.deleteCharAt( JsonString.length()-1 );
			}
			JsonString.append( "}" );
			
			return JsonString.toString();
		}
	}
	
	public String  getFileType(String fileName )
	{
		String fileType ="";
		if( fileName.contains( "." ) )
		{
			fileType = fileName.substring( fileName.lastIndexOf( "." ) + 1 );
		}
		return fileType;
	}
	
	public String getContentType( String fileType)
	{
		String contentType = "";
		if( contentTypeMap.containsKey( fileType ))
		{
			contentType = contentTypeMap.get( fileType );
		}
		return contentType ;
	}
	
	public native  void showFile(String fileUrl, String fileContentType)
	/*-{
			$wnd.plugins.pdfViewer.showPdf( fileUrl, fileContentType );
	  }-*/;
	
}
