package ibase.dashboard.scm.ejb;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;
/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class SalesPerformanceTwo extends ValidatorEJB implements SalesPerformanceTwoRemote, SalesPerformanceTwoLocal
{
	/**
	 * Default constructor.
	 */
	private JSONObject jsonMetaData = null;

	public SalesPerformanceTwo()
	{

	}

	/*** 1 - This method will contains final data for rendering Top Brands graph ***/
	@SuppressWarnings("unchecked")
	public JSONObject getAllIndiaTopBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
	{

		JSONObject rawDataMthlySalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			if (month != null && month.trim().length() > 0  && topNos != null && topNos.trim().length() > 0)
			{
			//sql = " SELECT sr_no, brand_name, divmst.div_descr, ROUND(sale_YTD_cy/100000,2) AS sale_YTD_cy, " + " ROUND(sale_YTD_ly/100000,2) AS sale_YTD_ly,(case when nvl(sale_YTD_ly,0) = 0 then 900 " + " else ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) end) AS gr_prcnt, ROUND(hotrgt_ytd_cy/100000,2) AS hotrgt_ytd, " + " ROUND(trgt_ytd_cy/100000,2) AS Fldtrgt_ytd,(case when nvl(hotrgt_ytd_cy,0) = 0 then 0 " + " else ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) end ) AS ho_ach_prcnt,(case when nvl(trgt_ytd_cy,0) = 0 then 0 " + " else ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) end ) AS fld_ach_prcnt,totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, item_ser, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT fin_year, item_ser, sub_grp,SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy, SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code,SUM(sale_YTD_cy) AS sale_YTD_cy, " + " SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE when SUM(trgt_YTD_cy) =0 then 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group AS sub_grp, " + " sales_item.item_sub_group_descr AS grp_nm,SM_SALES_SUMM_WIDE.terr_code AS terr_code, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 THEN SUBSTR(" + month + " -100 ,1,4)||'-'||" + " SUBSTR(" + month + " ,3,2) ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " and dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code " + " )GROUP BY fin_year, item_ser, sub_grp) ) dwh, " + " SM_SALES_DIV_MST divmst " + " WHERE dwh.item_ser= divmst.div_code " + " AND dwh.fin_year= divmst.fin_year " + " AND dwh.sr_no <= " + topNos + "" + " order by sr_no";
			 sql = " SELECT sr_no, brand_name, divmst.div_descr, ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy, " + " ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly,(case when nvl(sale_YTD_ly,0) = 0 then 900 " + " else ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) end) AS gr_prcnt, ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd, " + " ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(case when nvl(hotrgt_ytd_cy,0) = 0 then 0 " + " else ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) end ) AS ho_ach_prcnt,(case when nvl(trgt_ytd_cy,0) = 0 then 0 " + " else ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) end ) AS fld_ach_prcnt,totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, item_ser, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT fin_year, item_ser, sub_grp,SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy, SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code,SUM(sale_YTD_cy) AS sale_YTD_cy, " + " SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE when SUM(trgt_YTD_cy) =0 then 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group AS sub_grp, " + " sales_item.item_sub_group_descr AS grp_nm,SM_SALES_SUMM_WIDE.terr_code AS terr_code, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 THEN SUBSTR(" + month + " -100 ,1,4)||'-'||" + " SUBSTR(" + month + " ,3,2) ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " and dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code " + " )GROUP BY fin_year, item_ser, sub_grp) ) dwh, " + " SM_SALES_DIV_MST divmst " + " WHERE dwh.item_ser= divmst.div_code " + " AND dwh.fin_year= divmst.fin_year " + " AND dwh.sr_no <= " + topNos + "" + " order by sr_no";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				int count = 0;

				while (rs.next())
				{
					if (count < Integer.parseInt(topNos))
					{
						rowData = new JSONObject();
						rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
						rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
						rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
						rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
						rawDataMthlySalesJson.put(count, rowData);
						count++;
					}

				}
			}
			System.out.println("fetch Data for All India Top Brand Graph Data rawjson in servlet====" + rawDataMthlySalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPerformanceTwo:getAllIndiaTopBrandData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMthlySalesJson;
	}

	/***
	 * 2 - This method will contains final data for rendering division wise
	 * graph CNS
	 ***/
	@SuppressWarnings("unchecked")
	public JSONObject getCNSDivisionBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
	{

		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		topNos = "10";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
		  //sql(old) = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/100000,2) AS sale_YTD_cy,ROUND(sale_YTD_ly/100000,2) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/100000,2) AS hotrgt_ytd,ROUND(trgt_ytd_cy/100000,2) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code  AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='CNS' " + " order by DIV_GROUP, SR_NO ";
          sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy,ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd,ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code  AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='CNS' " + " order by DIV_GROUP, SR_NO ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;

			while (rs.next())
			{
				if (count < Integer.parseInt(topNos))
				{
					rowData = new JSONObject();
					rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
					rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
					rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
					rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
					rawDataMnthDivWiseSalesJson.put(count, rowData);
					count++;
				}
			}
			System.out.println("fetch Data for getCNSDivisionBrandData rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPerfomanceTwo:getCNSDivisionBrandData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}

	/***
	 * 3 - This method will contains final data for rendering division wise
	 * graph CVD
	 ***/
	@SuppressWarnings("unchecked")
	public JSONObject getCVDDivisionBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
	{

		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		topNos = "10";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			//sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/100000,2) AS sale_YTD_cy,ROUND(sale_YTD_ly/100000,2) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/100000,2) AS hotrgt_ytd,ROUND(trgt_ytd_cy/100000,2) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='CVD' " + " order by DIV_GROUP, SR_NO ";
			sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy,ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, "+ " ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd,ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='CVD' " + " order by DIV_GROUP, SR_NO ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			while (rs.next())
			{
				if (count < Integer.parseInt(topNos))
				{
					rowData = new JSONObject();
					rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
					rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
					rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
					rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
					rawDataMnthDivWiseSalesJson.put(count, rowData);
					count++;
				}
			}
			System.out.println("fetch Data for CVD Division Wise Brand Graph Data rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPerfomanceTwo:getCVDDivisionBrandData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}

	/***
	 *4- This method will contains final data for rendering division wise
	 * graph GI/PAIN
	 ***/
	@SuppressWarnings("unchecked")
	public JSONObject getGIPAINDivisionBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
	{

		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		topNos = "10";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			//sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/100000,2) AS sale_YTD_cy,ROUND(sale_YTD_ly/100000,2) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/100000,2) AS hotrgt_ytd,ROUND(trgt_ytd_cy/100000,2) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code  AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='GI/PAIN' " + " order by DIV_GROUP, SR_NO ";
			sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy,ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd,ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code  AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='GI/PAIN' " + " order by DIV_GROUP, SR_NO ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			while (rs.next())
			{
				if (count < Integer.parseInt(topNos))
				{
					rowData = new JSONObject();
					rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
					rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
					rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
					rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
					rawDataMnthDivWiseSalesJson.put(count, rowData);
					count++;
				}
			}
			System.out.println("fetch Data for GI/PAIN Division Wise Brand Graph Data rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPerfomanceTwo:getGIPAINDivisionBrandData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}

	/***
	 * 5- This method will contains final data for rendering division wise
	 * graph GYNAEC
	 ***/
	@SuppressWarnings("unchecked")
	public JSONObject getGYNAECDivisionBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
	{

		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		topNos = "10";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			//sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/100000,2) AS sale_YTD_cy,ROUND(sale_YTD_ly/100000,2) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/100000,2) AS hotrgt_ytd,ROUND(trgt_ytd_cy/100000,2) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='GYNAEC' " + " order by DIV_GROUP, SR_NO ";
			sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy,ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd,ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='GYNAEC' " + " order by DIV_GROUP, SR_NO ";

			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			while (rs.next())
			{
				if (count < Integer.parseInt(topNos))
				{
					rowData = new JSONObject();
					rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
					rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
					rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
					rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
					rawDataMnthDivWiseSalesJson.put(count, rowData);
					count++;
				}
			}
			System.out.println("fetch Data for GYNAE Division Wise Brand Graph Data rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPerfomanceTwo:getGYNAECDivisionBrandData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}

	/***
	 * 6 - This method will contains final data for rendering division wise
	 * graph OPTHAL
	 ***/
	@SuppressWarnings("unchecked")
	public JSONObject getOPTHALDivisionBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
	{

		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		topNos = "10";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			//sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/100000,2) AS sale_YTD_cy,ROUND(sale_YTD_ly/100000,2) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/100000,2) AS hotrgt_ytd,ROUND(trgt_ytd_cy/100000,2) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code  AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='OPTHAL' " + " order by DIV_GROUP, SR_NO ";
			sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy,ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd,ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code  AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='OPTHAL' " + " order by DIV_GROUP, SR_NO ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			while (rs.next())
			{
				if (count < Integer.parseInt(topNos))
				{
					rowData = new JSONObject();
					rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
					rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
					rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
					rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
					rawDataMnthDivWiseSalesJson.put(count, rowData);
					count++;
				}
			}
			System.out.println("fetch Data for OPTHAL Division Brand Data rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPerfomanceTwo:getOPTHALDivisionBrandData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}

	//add new method  on dated 5-aug-20014
	//method 7
	@SuppressWarnings("unchecked")
	public JSONObject getURODivisionBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
	{

		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		topNos = "10";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;			
			sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy,ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd,ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='URO' " + " order by DIV_GROUP, SR_NO ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			while (rs.next())
			{
				if (count < Integer.parseInt(topNos))
				{
					rowData = new JSONObject();
					rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
					rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
					rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
					rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
					rawDataMnthDivWiseSalesJson.put(count, rowData);
					count++;
				}
			}
			System.out.println("fetch Data for  URO Division Brand Data rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPerfomanceTwo:getURODivisionBrandData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}
	
	@SuppressWarnings("unchecked")
	//method 8
	public JSONObject getONCODivisionBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
	{

		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		topNos = "10";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;			
			sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy,ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd,ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='ONCO' " + " order by DIV_GROUP, SR_NO ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			while (rs.next())
			{
				if (count < Integer.parseInt(topNos))
				{
					rowData = new JSONObject();
					rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
					rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
					rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
					rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
					rawDataMnthDivWiseSalesJson.put(count, rowData);
					count++;
				}
			}
			System.out.println("fetch Data for getONCODivisionBrandData rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPerfomanceTwo:getONCODivisionBrandData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}
	
	
@SuppressWarnings("unchecked")
//method 9	
	public JSONObject getDERMADivisionBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
	{

		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		topNos = "10";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;			
			sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy,ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd,ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='DERMA' " + " order by DIV_GROUP, SR_NO ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			while (rs.next())
			{
				if (count < Integer.parseInt(topNos))
				{
					rowData = new JSONObject();
					rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
					rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
					rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
					rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
					rawDataMnthDivWiseSalesJson.put(count, rowData);
					count++;
				}
			}
			System.out.println("fetch Data for getDERMADivisionBrandData rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPerfomanceTwo:getDERMADivisionBrandData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}
	
	
@SuppressWarnings("unchecked")
//method 10
public JSONObject getRESPDivisionBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
{

	JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
	JSONObject rowData = null;
	String sql = "";
	ResultSet rs = null;
	PreparedStatement pstmt = null;
	Connection conn = null;
	ConnDriver connDriver = new ConnDriver();
	topNos = "10";
	try
	{
		conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;			
		sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy,ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd,ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='RESP' " + " order by DIV_GROUP, SR_NO ";
		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		int count = 0;
		while (rs.next())
		{
			if (count < Integer.parseInt(topNos))
			{
				rowData = new JSONObject();
				rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
				rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
				rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
				rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
				rawDataMnthDivWiseSalesJson.put(count, rowData);
				count++;
			}
		}
		System.out.println("fetch Data for getRESPDivisionBrandData rawjson====" + rawDataMnthDivWiseSalesJson.toString());

	} catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	} finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
					rs.close();
				rs = null;
				if (pstmt != null)
					pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :SalesPerfomanceTwo:getRESPDivisionBrandData:" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawDataMnthDivWiseSalesJson;
}

	/***
	 * 11 - This method will contains final data for rendering division wise
	 * graph SPL CARE
	 ***/
	@SuppressWarnings("unchecked")
	public JSONObject getOtherDivisionBrandData(String dataSourceName, String month, String topNos) throws RemoteException, ITMException
	{

		JSONObject rawDataMnthDivWiseSalesJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		topNos = "10";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			//sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/100000,2) AS sale_YTD_cy,ROUND(sale_YTD_ly/100000,2) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/100000,2) AS hotrgt_ytd,ROUND(trgt_ytd_cy/100000,2) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='SPL CARE' " + " order by DIV_GROUP, SR_NO ";
			sql = "SELECT sr_no, brand_name, div_group,ROUND(sale_YTD_cy/10000000,1) AS sale_YTD_cy,ROUND(sale_YTD_ly/10000000,1) AS sale_YTD_ly, " + " (CASE WHEN NVL(sale_YTD_ly,0) = 0 THEN 900 ELSE ROUND((sale_YTD_cy -sale_YTD_ly)/ sale_YTD_ly* 100,1) END) AS gr_prcnt, " + " ROUND(hotrgt_ytd_cy/10000000,1) AS hotrgt_ytd,ROUND(trgt_ytd_cy/10000000,1) AS Fldtrgt_ytd,(CASE WHEN NVL(hotrgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/hotrgt_ytd_cy * 100,1) END ) AS ho_ach_prcnt,(CASE WHEN NVL(trgt_ytd_cy,0) = 0 THEN 0 " + " ELSE ROUND(sale_YTD_cy/trgt_ytd_cy * 100,1) END ) AS fld_ach_prcnt, " + " totterr, terr100, ROUND(terr100/totterr*100,1) AS terr100prcnt " + " FROM (SELECT row_number() OVER( PARTITION BY div_group ORDER BY sale_YTD_cy DESC ) AS sr_no, " + " fin_year, div_group, sub_grp AS brand_name, sale_YTD_cy, sale_YTD_ly, trgt_YTD_cy, hotrgt_ytd_cy, " + " totterr, terr100 FROM (SELECT a.fin_year, divmst.div_group, sub_grp, " + " SUM(sale_YTD_cy) AS sale_YTD_cy, SUM(sale_YTD_ly) AS sale_YTD_ly,SUM(trgt_YTD_cy) AS trgt_YTD_cy, " + " SUM(hotrgt_ytd_cy) AS hotrgt_ytd_cy,SUM(terrcnt) AS totterr, SUM(terr100cnt) AS terr100 " + " FROM(SELECT dwh.fin_year , dwh.item_ser,dwh.grp_nm AS sub_grp,dwh.terr_code, " + " SUM(sale_YTD_cy) AS sale_YTD_cy,SUM(sale_YTD_ly) AS sale_YTD_ly, " + " SUM(trgt_YTD_cy) AS trgt_YTD_cy,ROUND(SUM(trgt_YTD_cy * (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0)) /100),2) AS hotrgt_ytd_cy, " + " 1 AS terrcnt,(CASE WHEN SUM(trgt_YTD_cy) =0 THEN 1 WHEN ROUND(SUM( sale_YTD_cy) / SUM(trgt_YTD_cy * " + " (100+ NVL(brnd.HO_TRGT_INCR_PRCNT,0))/100) *100,1)>= 100 THEN 1 ELSE 0 END ) AS terr100cnt " + " FROM (SELECT fin_year , SM_SALES_SUMM_WIDE.item_ser,sales_item.item_sub_group AS sub_grp, sales_item.item_sub_group_descr AS grp_nm, " + " SM_SALES_SUMM_WIDE.terr_code AS terr_code," + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(CY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(CY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(CY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(CY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(CY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(CY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(CY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(CY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(CY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(CY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(CY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(CY_SALE_YTD_MAR) END ) AS sale_YTD_cy, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(lY_SALE_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(lY_SALE_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(lY_SALE_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(lY_SALE_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(lY_SALE_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(lY_SALE_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(lY_SALE_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(lY_SALE_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(lY_SALE_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(lY_SALE_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(lY_SALE_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(lY_SALE_YTD_MAR) END ) AS sale_YTD_ly, " + " (CASE WHEN SUBSTR(" + month + " ,5,2) ='04' THEN SUM(FLD_TRGT_YTD_APR) " + " WHEN SUBSTR(" + month + " ,5,2) ='05' THEN SUM(FLD_TRGT_YTD_MAY) " + " WHEN SUBSTR(" + month + " ,5,2) ='06' THEN SUM(FLD_TRGT_YTD_JUN) " + " WHEN SUBSTR(" + month + " ,5,2) ='07' THEN SUM(FLD_TRGT_YTD_JUL) " + " WHEN SUBSTR(" + month + " ,5,2) ='08' THEN SUM(FLD_TRGT_YTD_AUG) " + " WHEN SUBSTR(" + month + " ,5,2) ='09' THEN SUM(FLD_TRGT_YTD_SEP) " + " WHEN SUBSTR(" + month + " ,5,2) ='10' THEN SUM(FLD_TRGT_YTD_OCT) " + " WHEN SUBSTR(" + month + " ,5,2) ='11' THEN SUM(FLD_TRGT_YTD_NOV) " + " WHEN SUBSTR(" + month + " ,5,2) ='12' THEN SUM(FLD_TRGT_YTD_DEC) " + " WHEN SUBSTR(" + month + " ,5,2) ='01' THEN SUM(FLD_TRGT_YTD_JAN) " + " WHEN SUBSTR(" + month + " ,5,2) ='02' THEN SUM(FLD_TRGT_YTD_FEB) " + " WHEN SUBSTR(" + month + " ,5,2) ='03' THEN SUM(FLD_TRGT_YTD_MAR) END ) AS trgt_YTD_cy " + " FROM SM_SALES_SUMM_WIDE, sales_item " + " WHERE trim(fin_year)= (CASE WHEN SUBSTR(" + month + " ,5,2)<4 " + " THEN SUBSTR(" + month + " -100 ,1,4)||'-'||SUBSTR(" + month + " ,3,2) " + " ELSE SUBSTR(" + month + " ,1,4)||'-' || SUBSTR(" + month + " +100,3,2) END) " + " AND " + month + " =	" + month + " AND SM_SALES_SUMM_WIDE.item_code= sales_item.item_code " + " AND sales_item.item_sub_group NOT IN ('CU','BJ') " + " GROUP BY fin_year ,SM_SALES_SUMM_WIDE.item_ser, sales_item.item_sub_group, " + " sales_item.item_sub_group_descr, SM_SALES_SUMM_WIDE.terr_code ) dwh, " + " SM_SALES_BRAND_MST brnd " + " WHERE brnd.brand_code(+) = dwh.sub_grp " + " AND brnd.div_code(+) = dwh.item_ser " + " AND brnd.fin_year(+) = dwh.fin_year " + " AND dwh.sale_ytd_cy+ dwh.trgt_YTD_cy <>0 " + " GROUP BY dwh.fin_year, dwh.item_ser, dwh.grp_nm,dwh.terr_code ) a, " + " SM_SALES_DIV_MST divmst " + " WHERE a.item_ser= divmst.div_code AND a.fin_year = divmst.fin_year " + " GROUP BY a.fin_year, divmst.div_group, a.sub_grp )) dwh " + " where DIV_GROUP='OTHERS' " + " order by DIV_GROUP, SR_NO ";
	     	pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			while (rs.next())
			{
				if (count < Integer.parseInt(topNos))
				{
					rowData = new JSONObject();
					rowData.put("brand_name", getBrandName(checkNull(rs.getString("brand_name"))));
					rowData.put("sales_ytd_cy", checkNull(rs.getString("sale_YTD_cy")));
					rowData.put("gr_prcnt", checkNull(rs.getString("gr_prcnt")));
					rowData.put("ho_ach_prcnt", checkNull(rs.getString("ho_ach_prcnt")));
					rawDataMnthDivWiseSalesJson.put(count, rowData);
					count++;
				}
			}
			System.out.println("fetch Data for getOtherDivisionBrandData rawjson====" + rawDataMnthDivWiseSalesJson.toString());

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :SalesPerfomanceTwo:getOtherDivisionBrandData:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataMnthDivWiseSalesJson;
	}

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}

	}

	private String getBrandName(String brandName)
	{

		if (brandName.trim().length() > 14)
		{
			brandName = brandName.substring(0, 14);
		}
		return brandName;
	}
}
