package ibase.webitm.ejb.adm.adv;

import ibase.system.config.AppConnectParm;//Added by Anjali Rawankar on[21/08/2017][For ITMDBACCESS]
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;//Added by Anjali Rawankar on[21/08/2017][For ITMDBACCESS]
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.adm.AttdProcess;
import ibase.webitm.ejb.adm.LeaveEncase;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.hrp.leave.EmpLeaveIC;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.bean.sys.ProteusDataSource;
import ibase.webitm.utility.DB2XMLGenerator;
import ibase.webitm.utility.ITMException;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.ejb.Stateless;
import javax.naming.InitialContext;//Added by Anjali Rawankar on[21/08/2017][For ITMDBACCESS]

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
//import org.drools.lang.DRLParser.normal_lhs_block_return;


@Stateless
public class EmpLeaveConf extends ActionHandlerEJB implements EmpLeaveConfLocal,EmpLeaveConfRemote
{
	private UtilMethods utilMethod = null ;
	private AdmCommon admCommon = null;
	private E12GenericUtility genericUtility = null;
	private String errXml ="";
	private String termId = "",loginEmpCode = "",userId = "";
	private HashMap lveRuleList = null;
	private ArrayList errList = null;
	private ArrayList fldList = null;
	private String xtraParamsArg = "";
	private String leaveXmlData = "";
	private ProteusDataSource proteusDataSource = null;

	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		genericUtility = new E12GenericUtility();
		String retString = "";
		Connection conn = null;

		try
		{
			conn = getConnection();
			retString = confirm( tranId, xtraParams, forcedFlag, conn);	
		}
		catch(Exception e)
		{
			System.out.println("Exception :EmpLeaveConf :confirm():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
		}
		return retString;
	}

	public String confirm( String tranId, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException
	{
		System.out.println("--------------confirm method of Empleave -------------");
		ResultSet rs=null;
		PreparedStatement pstmt = null;	
		String retString = "";
		String errString = "",errCode = "";	
		HashMap hMap = new HashMap();

		/*Modified by Anjali Rawankar on[22/08/2017][Start]
		 *[Added for itmDbAccess]
		 */
		AppConnectParm appConnect = null;
		InitialContext initialCtx = null;
		ITMDBAccessLocal itmDBAccess = null;
		/*[Added for itmDbAccess]
		 * Modified by Anjali Rawankar on[22/08/2017][End]
		 */
		if (genericUtility == null)
		{
			genericUtility = new E12GenericUtility();
		}
		if (admCommon == null)
		{
			admCommon = new AdmCommon();
		}
		if (utilMethod == null)
		{
			utilMethod = new UtilMethods();
		}
		try
		{

			this.errXml ="";
			this.leaveXmlData = "";
			this.xtraParamsArg = xtraParams;
			this.errList = new ArrayList();
			this.fldList = new ArrayList();
			this.lveRuleList = admCommon.createLveRuleList();
			this.userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			this.termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			this.loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			this.leaveXmlData = getXMLFromDBForEdit("empleave","2",1,tranId, "String","E-LVE",getUserInfo(this.userId));

			/*Modified by Anjali Rawankar on[22/08/2017][Start]
			 *[Added for itmDbAccess]
			 */
			appConnect = new AppConnectParm();
			initialCtx = new InitialContext(appConnect.getProperty());
			itmDBAccess = (ITMDBAccessLocal)initialCtx.lookup("ibase/ITMDBAccessEJB/local");			
			/*[Added for itmDbAccess]
			 * Modified by Anjali Rawankar on[22/08/2017][End]
			 */
			if (this.leaveXmlData != null && this.leaveXmlData.trim().length() > 0)
			{
				this.proteusDataSource = new ProteusDataSource("empLeave", this.leaveXmlData, 1);
			}

			System.out.println("Calling Post Logic ");
			retString = postLogic(tranId, tranId, 2, xtraParams, conn);

			System.out.println("return Error List of Post Logic :: "+this.errList);

			int cnt =0;
			String errorCode = "";
			String errFldName = null, errorType = "";
			StringBuffer errStringXml = new StringBuffer();
			if ( this.errList != null && this.errList.size() > 0 )
			{
				for (cnt = 0; cnt < this.errList.size(); cnt++ )
				{
					errCode = (String)this.errList.get(cnt);
					errFldName = (String)this.fldList.get(cnt);
					System.out.println("errCode .........."+errCode);

					/*Modified by Anjali Rawankar on[22/08/2017][Start]
					 *[Added for itmDbAccess]*/					 
					//errString = getErrorString( errFldName, errCode, this.userId );
					errString = itmDBAccess.getErrorString( errFldName, errCode, this.userId );
					/*[Added for itmDbAccess]
					 *Modified by Anjali Rawankar on[22/08/2017][End]*/

					errorType =  getErrorType( errCode , conn  );
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
					errString = "";
				}
				this.errList.clear();
				this.errList = null;
				this.fldList.clear();
				this.fldList = null;

			}
			if (errString == null || errString.trim().length() == 0)
			{
				conn.commit();
				/*Modified by Anjali Rawankar on[22/08/2017][Start]
				 *[Added for itmDbAccess]*/	
				//errString = getErrorString( "", "VTSUCC1" , this.userId );
				errString = itmDBAccess.getErrorString( "", "VTSUCC1" , this.userId );
				/*[Added for itmDbAccess]
				 *Modified by Anjali Rawankar on[22/08/2017][End]*/
			}
			else
			{
				conn.rollback();
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :EmpLeaveConf :confirm():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			this.errXml ="";
			this.leaveXmlData = "";
			this.xtraParamsArg = "";
			this.errList = null;
			this.fldList = null;
			this.lveRuleList = null;
			this.proteusDataSource = null;
			this.admCommon = null;
			this.utilMethod = null;
		}
		System.out.println("Error String Returned from Confirmation :: [" + errString + "]");
		return errString;
	}

	private String postLogic (String tranIdFr, String tranIdTo, int commit, String xtraParams, Connection connectionObject) throws RemoteException,ITMException 
	{

		String useFlag = "",leaveApplStatus = "",leaveStarts = "",leaveEnds = "",errCode = "",empCode = "",lveCode = "",prdCode = "",extraArg1 = "";
		String encPrd = "",tranId = "";
		java.sql.Timestamp lveDateFr = null,lveDateTo = null,currentTimeStamp = null,sysDate = null;
		double noDays = 0;
		String ruleValidation = "N";
		String site = "",cadre = "",grade = "",lveEnchMode = "",payrollOrVoucher = "",payrollPeriod = "";
		int returnValue = 0;
		String	allowAdvLeave = "N" , lveTblno = "", balOpt = "";

		//String tranidTrimmed = "",status = "",errCode1 = "";
		int	cnt = 0 ;
		//java.sql.Timestamp	currDate = null; 

		ResultSet rs = null;

		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet resultSet = null;
		int noRows = 0;
		boolean isError = false;

		try
		{

			System.out.println("Inside Post Logic ");
			currentTimeStamp = utilMethod.dateTime(utilMethod.todaySqlDate());
			LeaveEncase leaveEnc;

			if (utilMethod.pos(xtraParams , "ignoreWarnings") > 0)
			{
				ruleValidation = genericUtility.getValueFromXTRA_PARAMS(xtraParams , "ignoreWarnings");
			}
			else if(utilMethod.pos(extraArg1 ,  "ignoreWornings") > 0)
			{
				ruleValidation = genericUtility.getValueFromXTRA_PARAMS(xtraParams ,  "ignoreWornings");
			}

			if(ruleValidation == null)
			{
				ruleValidation = "Y";
			}
			else if(ruleValidation != "Y")
			{
				ruleValidation = "Y";
			}
			else
			{
				ruleValidation = "N";
			}
			this.lveRuleList.put("check_min_bal" , true);
			this.lveRuleList.put("check_min_allow" , true);
			this.lveRuleList.put("check_max_allow" , true);
			this.lveRuleList.put("check_max_time_allow" , true);
			this.lveRuleList.put("allow_update_negative_leave" , false);

			System.out.println("TranIDFr inside Postlogic ::: [" + tranIdFr + "]");
			System.out.println("TranIDTo inside Postlogic ::: ["+tranIdTo + "]");

			if(tranIdFr.equals(tranIdTo));
			{
				tranId = tranIdFr;
			}

			System.out.println("tranId inside Postlogic ::: [" + tranId + "]");
			System.out.println("Connection :: " +connectionObject==null?"Null Connection":"Connection got");
			do 
			{
				noRows = 0;
				sql = "SELECT EMP_CODE,LVE_CODE,PRD_CODE,NO_DAYS,LVE_DATE_FR,LVE_DATE_TO,USE_FLAG,STATUS,ENCASH_MODE,PRD_CODE__PAYROLL FROM EMPLEAVE WHERE TRAN_ID = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,tranId);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					noRows++;
					empCode = resultSet.getString("EMP_CODE");
					lveCode = resultSet.getString("LVE_CODE");
					prdCode = resultSet.getString("PRD_CODE");
					noDays  = resultSet.getDouble("NO_DAYS");
					lveDateFr = resultSet.getTimestamp("LVE_DATE_FR");
					lveDateTo = resultSet.getTimestamp("LVE_DATE_TO");
					useFlag = resultSet.getString("USE_FLAG");
					leaveApplStatus = resultSet.getString("STATUS");
					payrollOrVoucher = resultSet.getString("ENCASH_MODE");
					payrollPeriod = resultSet.getString("PRD_CODE__PAYROLL");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(noRows == 0)
				{
					errCode = "VTEMPLEVTR";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				else if(leaveApplStatus.equals("C"))
				{
					errCode = "VTLVEX1";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				else if(leaveApplStatus.equals("A"))
				{
					errCode = "VTEMPLVE3";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				noRows = 0;
				sql = "SELECT WORK_SITE, CADRE, GRADE FROM EMPLOYEE WHERE EMP_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, empCode);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					noRows++;
					site = resultSet.getString("WORK_SITE");
					cadre = resultSet.getString("CADRE");
					grade= resultSet.getString("GRADE");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(noRows == 0)
				{
					errCode = "VMEMPCD1";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				noRows = 0;
				if(ruleValidation.equalsIgnoreCase("Y"))
				{
					errCode = leaveChkGeneral(empCode,lveCode,prdCode,noDays,lveDateFr,lveDateTo,useFlag,tranId,connectionObject);
					isError = false;
					if (this.errList != null && this.errList.size() > 0)
					{
						for (int i = 0;i < this.errList.size();i++)
						{
							if (getErrorType((String)this.errList.get(i), connectionObject) == "E")
							{
								isError = true;
								break;
							}
						}
						if (isError)
						{
							break;
						}
					}
				}
				else
				{
					noRows = 0;
					sql ="SELECT NVL(BAL_OPT,'N') AS BAL_OPT FROM LEAVES WHERE LVE_CODE =  ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, lveCode);
					resultSet = pstmt.executeQuery();
					while(resultSet.next())
					{
						noRows++;
						balOpt = resultSet.getString("BAL_OPT");
					}
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if (noRows == 0) 
					{
						errCode = "VTLVE15";
						this.errList.add(errCode);
						this.fldList.add("");
						isError = true;
						break;
					}
					if (balOpt.equalsIgnoreCase("Y"))
					{
						returnValue = 0; 
						allowAdvLeave = "N";
						noRows = 0;
						sql = "";
						sql = "SELECT LVE_TBLNO  FROM GRADE_SITE_LVETBL	WHERE SITE_CODE = ? AND GRADE_CODE = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, site);
						pstmt.setString(2, grade);
						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							noRows++;
							lveTblno = resultSet.getString("LVE_TBLNO");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if (lveTblno == null || lveTblno.trim().length() == 0)
						{
							noRows = 0;
							sql = "SELECT LVE_TBLNO FROM CADRE_SITE_LVETBL WHERE SITE_CODE = ? AND CADRE_CODE = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, site);
							pstmt.setString(2, cadre);
							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								noRows++;
								lveTblno = resultSet.getString("LVE_TBLNO");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
						if(lveTblno == null || lveTblno.trim().length() == 0) 
						{
							errCode = "VTLVETBL";
							this.errList.add(errCode);
							this.fldList.add("");
							isError = true;
							break;
						}
						noRows = 0;
						sql = "SELECT ALLOW_ADV_LEAVE  FROM LVETABLE WHERE LVE_TBLNO = ? AND LVE_CODE = ? ";		
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, lveTblno);
						pstmt.setString(2, lveCode);
						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							noRows++;
							allowAdvLeave = resultSet.getString("ALLOW_ADV_LEAVE");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(noRows == 0)
						{
							errCode= "VTLVE15";
							this.errList.add(errCode);
							this.fldList.add("");
							isError = true;
							break;
						}
						//returnedValue = checkNegAdvLveRules(tranId,allowAdvLeave,site,cadre,grade,lveTblno,this.lveRuleList,connectionObject);
						returnValue = checkNegAdvLveRules(tranId,allowAdvLeave,site,cadre,grade,lveTblno,connectionObject);
						if(returnValue == -9)
						{
							if (this.errList != null && this.errList.size() > 0)
							{
								String errType = getErrorType((String)this.errList.get(this.errList.size() - 1) , connectionObject);
								if ("E".equalsIgnoreCase(errType))
								{
									isError = true;
									break;
								}
							}
						}
					}
					returnValue = 0; 		
				}
				if ("E".equals(useFlag))
				{
					if(payrollOrVoucher == null || payrollOrVoucher.trim().length() == 0 || (!("P".equals(payrollOrVoucher)) && !("V".equals(payrollOrVoucher))))
					{
						errCode = "VTLVEENC01";
						this.errList.add(errCode);
						this.fldList.add("");
						isError = true;
						break;
					}
					else if("P".equals(payrollOrVoucher))
					{
						if(payrollPeriod == null || payrollPeriod.trim().length() == 0)
						{
							errCode = "VTLVEENC02";
							this.errList.add(errCode);
							this.fldList.add("");
							isError = true;
							break;
						}
						else
						{
							cnt = 0;
							sql = "SELECT COUNT(1) AS COUNT  FROM PERIOD WHERE CODE = ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, payrollPeriod);
							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								noRows++;
								cnt = resultSet.getInt("COUNT");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(cnt == 0)
							{
								errCode = "VTLVEENC03";
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}
						}
					}
					else
					{
						payrollPeriod = "";
					}
					//errCode = encLeavesApprove(tranId,2,payrollOrVoucher,payrollPeriod ,2,connectionObject);
					if (errCode != null && errCode.trim().length() > 0)
					{
						isError = true;
					}
				}
				else
				{
					errCode = leavesApprove(tranId,2,payrollOrVoucher,payrollPeriod,2,connectionObject);
					if (errCode != null && errCode.trim().length() > 0)
					{
						isError = true;
					}
				}

				break;
			}while (true);
			if (!isError)
			{
				errCode = "";
			}
			else
			{
				errCode = "ERROR";
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch (Exception e1)
			{
				e1.printStackTrace();
			}
		}
		return errCode;
	}

	private int  checkNegAdvLveRules (String tranId, String allowAdvleave, String workSite, String cadre, String grade, String lveTable,Connection conn) throws RemoteException,ITMException
	{
		int returnValue = 0;
		EmpLeaveIC boEmpleave ;
		int returnedValue = 0;
		Document leaveDom = null;
		String errCode = "";
		try
		{
			boEmpleave = new EmpLeaveIC();
			boEmpleave.setClassVariables(this.errList, this.proteusDataSource, this.lveRuleList);
			/*
			boEmpleave.this.errList = this.errList;
			boEmpleave.this.proteusDataSource = this.proteusDataSource;
			boEmpleave.this.lveRuleList.put("check_min_bal",(boolean)this.lveRuleList.get("check_min_bal")) ;
			boEmpleave.this.lveRuleList.put("check_min_allow",(boolean)this.lveRuleList.get("check_min_allow")) ;
			boEmpleave.this.lveRuleList.put("check_max_allow",(boolean)this.lveRuleList.get("check_max_allow")) ;
			boEmpleave.this.lveRuleList.put("check_max_time_allow",(boolean)this.lveRuleList.get("check_max_time_allow")) ;
			boEmpleave.this.lveRuleList.put("allow_update_negative_leave",(boolean)this.lveRuleList.get("allow_update_negative_leave")) ;
			 */
			returnValue =  boEmpleave.checkNegAdvLveRules(leaveDom, allowAdvleave, workSite,cadre,grade,lveTable, "C",this.lveRuleList, conn);
			HashMap retHMap = boEmpleave.getClassVariables();
			if( returnValue == -9 ) 
			{
				ArrayList errListNew = new ArrayList();
				errListNew = (ArrayList)retHMap.get("ERRORLIST");
				if (errListNew != null && errListNew.size() > 0)
				{
					this.errList = errListNew;
				}
				else
				{
					errCode = "VTLVENAD01";
					this.errList.add(errCode);
					this.fldList.add("lve_code");
				}
			}
			else
			{
				this.lveRuleList = (HashMap)retHMap.get("LEAVERULELIST");
				/*
				this.lveRuleList.put("check_min_bal",(boolean)boEmpleave.this.lveRuleList.get("check_min_bal")) ;
				this.lveRuleList.put("check_min_allow",(boolean)boEmpleave.this.lveRuleList.get("check_min_allow")) ;
				this.lveRuleList.put("check_max_allow",(boolean)boEmpleave.this.lveRuleList.get("check_max_allow")) ;
				this.lveRuleList.put("check_max_time_allow",(boolean)boEmpleave.this.lveRuleList.get("check_max_time_allow")) ;
				this.lveRuleList.put("allow_update_negative_leave",(boolean)boEmpleave.this.lveRuleList.get("allow_update_negative_leave")) ;
				 */
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
		}

		return returnValue;
	}


	private  String leaveChkGeneral (String memp, String mLeave, String mPrd, double mNoDays, java.sql.Timestamp mlveDt, java.sql.Timestamp mlvedtTo, String museFlag, String tranId, Connection connectionObject) throws RemoteException,ITMException
	{
		String prob = "",conf = "",errCode = "",lveFrMth = "",lveToMth = "",grade = "",
				cadre = "",lveTblNo = "",payable = "",holTblno = "",workSite = "",encashable = "",
				fldName = "";
		String allowAdvLeave = "" , leaveStart = "", leaveEnd = "" ,balOpt = "N";
		String sql = "",sql1 = "";

		int lveYrFr = 0, lveYrTo = 0,cnt = 0,noofTimes = 0, maxTimes = 0,nvoNo = 0, lveMon = 0,noRows = 0, returnValue = 0,lveYearFrMth=0,lveYearToMth=0;

		double minAllowed = 0,maxAllowed = 0,minBalance = 0,balDays = 0,noDays = 0;

		long count = 0;

		java.sql.Timestamp lveFrDt = null,lveToDt = null ,tempDate = null,relDate = null;

		HashMap returnedValue = new HashMap();
		PreparedStatement pstmt = null , pstmt1 = null;
		ResultSet resultSet = null ,resulSet1 = null;
		boolean isError = false;

		try
		{
			lveYrFr = utilMethod.year(mlveDt);
			lveYrTo = utilMethod.year(mlveDt);
			do
			{

				sql = "SELECT HOL_TBLNO,WORK_SITE, GRADE, CADRE, RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);

				pstmt.setString(1, memp);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					noRows++;
					holTblno = resultSet.getString("HOL_TBLNO");
					workSite = resultSet.getString("WORK_SITE");
					grade = resultSet.getString("GRADE");
					cadre = resultSet.getString("CADRE");
					relDate = resultSet.getTimestamp("RELIEVE_dATE");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(noRows == 0)
				{
					errCode = "VMEMPCD1";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				sql = "SELECT FN_GET_HOLTBLNO(?,?) AS HOL_TBLNO FROM DUAL";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,memp);
				pstmt.setTimestamp(2,mlveDt);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					holTblno = resultSet.getString(1);
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (holTblno != null && "DS000".equalsIgnoreCase(utilMethod.mid(holTblno,1,5)))
				{
					errCode = holTblno;
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				noRows = 0;
				sql = "SELECT LVE_TBLNO FROM GRADE_SITE_LVETBL WHERE SITE_CODE = ? AND GRADE_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,workSite);
				pstmt.setString(2,grade);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					lveTblNo = resultSet.getString("LVE_TBLNO");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(lveTblNo == null || lveTblNo.trim().length() == 0 )
				{
					sql = "SELECT LVE_TBLNO FROM CADRE_SITE_LVETBL WHERE SITE_CODE = ? AND CADRE_CODE = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,workSite);
					pstmt.setString(2,cadre);
					resultSet = pstmt.executeQuery();
					while(resultSet.next())
					{
						lveTblNo = resultSet.getString("LVE_TBLNO");
					}
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				if(lveTblNo == null || lveTblNo.trim().length() == 0 ) 
				{
					errCode = "VTLVETBL";
					fldName = "emp_code";
					this.errList.add(errCode);
					this.fldList.add(fldName);
					isError = true;
					break;	
				}
				noRows = 0;
				sql = "SELECT MIN_ALLOWED, MAX_ALLOWED, MAX_TIMES, NVL(MIN_BALANCE,0) AS MIN_BALANCE, NVO_NO, NVL(ENCASHABLE,'N') AS ENCASHABLE, ALLOW_ADV_LEAVE FROM LVETABLE  WHERE LVE_TBLNO = ? AND LVE_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,lveTblNo);
				pstmt.setString(2,mLeave);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					noRows++;
					minAllowed = resultSet.getDouble("MIN_ALLOWED");
					maxAllowed= resultSet.getDouble("MAX_ALLOWED");
					maxTimes = resultSet.getInt("MAX_TIMES");
					minBalance = resultSet.getDouble("MIN_BALANCE");
					nvoNo = resultSet.getInt("NVO_NO");
					encashable = resultSet.getString("ENCASHABLE") ;
					allowAdvLeave = resultSet.getString("ALLOW_ADV_LEAVE") ; ;

				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}				
				if(noRows == 0)
				{
					errCode = "VTLVE15";
					fldName = "emp_code";
					this.errList.add(errCode);
					this.fldList.add(fldName);
					isError = true;
					break;	
				}

				noRows = 0;
				sql = "SELECT NVL(BAL_OPT,'N') AS BAL_OPT FROM LEAVES WHERE LVE_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,mLeave);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{	
					noRows++;
					balOpt = resultSet.getString("BAL_OPT");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}				
				if(noRows == 0)
				{
					errCode = "VTLVE15";
					fldName = "emp_code";
					this.errList.add(errCode);
					this.fldList.add(fldName);
					isError = true;
					break;	
				}
				if ("Y".equalsIgnoreCase(balOpt))
				{
					if ("C".equalsIgnoreCase(museFlag))
					{
						noRows = 0;
						sql = "SELECT LEAVE_STARTS , LEAVE_ENDS FROM EMPLEAVE WHERE TRAN_ID = ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1,tranId);
						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{	
							noRows++;
							leaveStart = resultSet.getString("LEAVE_STARTS");
							leaveEnd = resultSet.getString("LEAVE_ENDS");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}

						returnValue = 0; 
						returnValue = checkNegAdvLveRules(tranId, allowAdvLeave, workSite, cadre, grade, lveTblNo,connectionObject);
						if (returnValue == -9)
						{
							isError = true;
							break;
						}
						returnValue = 0; 	
					}
				}
				if (museFlag.equals("E"))
				{
					if (encashable == null || encashable.trim().length() == 0 || !("Y".equals(encashable)))
					{
						errCode = "VELVE3";
						fldName = "use_flag";
						this.errList.add(errCode);
						this.fldList.add(fldName);
						isError = true;
						break;
					}
					else
					{
						if (relDate == null)
						{
							noRows = 0;
							balDays = 0d;
							sql = "SELECT SUM(BAL_DAYS) AS BAL_DAYS FROM LEAVEBAL WHERE EMP_CODE =? AND LVE_CODE = ? AND EXP_DATE >= ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1,memp);
							pstmt.setString(2,mLeave);
							pstmt.setTimestamp(3,mlveDt);
							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{	
								noRows++;
								balDays = resultSet.getDouble(1);
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if (noRows == 0 || balDays <= 0)
							{
								errCode = "VTEMPLVE1";
								fldName = "emp_code";
								this.errList.add(errCode);
								this.fldList.add(fldName);
								isError = true;
								break;
							}
							if ((balDays - mNoDays) < minBalance)
							{
								errCode = "VTEMPLVE1";
								fldName = "emp_code";
								this.errList.add(errCode);
								this.fldList.add(fldName);
								String errType = getErrorType(errCode , connectionObject);
								if ("E".equalsIgnoreCase(errType))
								{
									isError = true;
									break;
								}
							}

						}
					}
					break;
				}
				else if ("L".equals(museFlag) || "V".equals(museFlag))
				{
					break;
				}
				else if (museFlag.equals("A"))
				{
					noRows = 0;
					sql = "SELECT SUM(BAL_DAYS) AS BAL_DAYS FROM LEAVEBAL WHERE EMP_CODE =? AND LVE_CODE = ? AND EXP_DATE >= ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,memp);
					pstmt.setString(2,mLeave);
					pstmt.setTimestamp(3,mlveDt);
					resultSet = pstmt.executeQuery();
					while(resultSet.next())
					{	
						noRows++;
						balDays = resultSet.getDouble(1);
					}
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if (noRows == 0 || balDays <= 0)
					{
						errCode = "VTEMPLVE1";
						fldName = "emp_code";
						this.errList.add(errCode);
						this.fldList.add(fldName);
						isError = true;
						break;
					}
					if ((balDays - mNoDays) < minBalance)
					{
						errCode = "VTEMPLVE1";
						fldName = "emp_code";
						this.errList.add(errCode);
						this.fldList.add(fldName);
						String errType = getErrorType( errCode , connectionObject);
						if ("E".equalsIgnoreCase(errType))
						{
							isError = true;
							break;
						}
					}
					break;
				}
				else if ("C".equals(museFlag))
				{
					tempDate = mlveDt;
					do
					{
						noRows = 0;
						sql = "SELECT FN_GET_HOLTBLNO(?,?) AS HOL_TBLNO FROM DUAL";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1,memp);
						pstmt.setTimestamp(2,mlveDt);
						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{	
							noRows++;
							holTblno = resultSet.getString(1);
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if (holTblno != null && "DS000".equalsIgnoreCase(utilMethod.mid(holTblno,1,5)))
						{
							errCode = holTblno;
							this.errList.add(errCode);
							this.fldList.add("");
							isError = true;
							break;
						}
						noDays = 0;
						String holType = "";
						holType = admCommon.scanHWTypeFordate(memp ,holTblno ,tempDate ,workSite ,cadre , grade , "Y",connectionObject);
						System.out.println("Returned holType from scanHWTypeFordate is [" + holType + "]" );
						if(holType != null && holType.trim().length() > 0)
						{
							if(utilMethod.pos("HW" , holType) == 0)
							{
								errCode = holType;
								holType  = "";
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}
							else
							{
								noDays  = 1;
							}
						}
						if(noDays > 0)
						{
							errCode = "VTEMPLVE14";
							this.errList.add(errCode);
							this.fldList.add("");
							String errType = getErrorType( errCode , connectionObject);
							if ("E".equalsIgnoreCase(errType))
							{
								isError = true;
								break;
							}
							else
							{
								errCode = "";
							}
						}
						if(tempDate.equals(mlvedtTo))
						{
							break;
						}
						else if(!(mlveDt.equals(mlvedtTo)))
						{
							tempDate = mlvedtTo;
						}
					} 
					while(true);
					if(errCode != null && errCode.trim().length() > 0 )
					{
						break;
					}
				}


				lveFrMth = admCommon.getAdmEnv(workSite , cadre , grade ,"LVE_FRMTH" , mlveDt,connectionObject);
				if(lveFrMth == null || lveFrMth.trim().length() == 0 || lveFrMth.indexOf("NULLFOUND") > 0)
				{
					lveFrMth = admCommon.getEnv("999999", "LVE_FRMTH",connectionObject);
					if(lveFrMth.equals("NULLFOUND")) 
					{
						errCode = "VSENVAR1";
						this.errList.add(errCode);
						this.fldList.add("");
						isError = true;
						break;
					}
					else if(utilMethod.left(lveFrMth , 4).equals("ERR~t"))
					{
						errCode = utilMethod.mid(lveFrMth , 5);
						this.errList.add(errCode);
						this.fldList.add("");
						isError = true;
						break;
					}
				}
				lveToMth = admCommon.getAdmEnv(workSite ,cadre ,grade ,"LVE_TOMTH" , mlveDt,connectionObject);
				if(lveToMth == null || lveToMth.trim().length() == 0 || lveToMth.indexOf("NULLFOUND") > 0)
				{
					lveToMth = admCommon.getEnv("999999", "LVE_TOMTH",connectionObject);
					if(lveToMth.equals("NULLFOUND"))
					{
						errCode = "VSENVAR1";
						this.errList.add(errCode);
						this.fldList.add("");
						isError = true;
						break;
					}
				}
				else if(utilMethod.left(lveToMth , 4).equals("ERR~t"))
				{
					errCode = utilMethod.mid(lveToMth , 5);
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				try
				{
					lveYearFrMth = Integer.parseInt(lveFrMth);
					lveYearToMth = Integer.parseInt(lveFrMth);
				}
				catch (Exception pe)
				{
					lveYearFrMth = 1;
					lveYearToMth = 12;
				}
				if(lveYearFrMth !=  1)
				{
					lveMon = utilMethod.month(mlveDt);
					if (lveMon < lveYearFrMth)
					{
						lveYrFr = lveYrFr - 1;
					}
					else
					{
						lveYrTo = lveYrTo + 1;
					}

					lveFrDt = utilMethod.dateTime(utilMethod.date(lveYrFr, lveYearFrMth , 1));
					lveToDt = utilMethod.dateTime(utilMethod.date(lveYrTo, lveYearToMth , 31));
				}
				else
				{
					lveFrDt = utilMethod.dateTime(utilMethod.date(lveYrFr, 1, 1));
					lveToDt = utilMethod.dateTime(utilMethod.date(lveYrTo, 12, 31));
				}
				if( minAllowed != 0 && mNoDays > 0 && mNoDays < minAllowed)
				{
					errCode = "VTEMPLVE7";
					this.errList.add(errCode);
					this.fldList.add("");
					String errType = getErrorType(errCode ,  connectionObject);
					if ("E".equalsIgnoreCase(errType))
					{
						isError = true;
						break;
					}
					else
					{
						errCode = "";
					}
				}
				if ( maxAllowed != 0 && mNoDays > maxAllowed)
				{
					errCode = "VTEMPLVE8";
					this.errList.add(errCode);
					this.fldList.add("");
					String errType = getErrorType(errCode ,  connectionObject);
					if ("E".equalsIgnoreCase(errType))
					{
						isError = true;
						break;
					}
					else
					{
						errCode = "";
					}
				}
				if(tranId == null)
				{
					tranId = "";
				}
				noRows = 0;
				sql ="sELECT COUNT(*) AS COUNT FROM EMPLEAVE 	WHERE EMP_CODE  = ? AND LVE_DATE_FR >= ? "+
						" AND LVE_DATE_TO <= ? AND LVE_CODE    = ? AND STATUS      = 'A' "+
						" AND USE_FLAG    = 'C' AND TRAN_ID <> NVL(?,' ')";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,memp);
				pstmt.setTimestamp(2,lveFrDt);
				pstmt.setTimestamp(3,lveToDt);
				pstmt.setString(4, mLeave);
				pstmt.setString(5, tranId);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{	
					noRows++;
					noofTimes = resultSet.getInt(1);
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (noofTimes + 1 > maxTimes  && maxTimes  > 0)
				{
					errCode = "VTEMPLVE9" ;
					this.errList.add(errCode);
					this.fldList.add("");
					String errType = getErrorType(errCode ,  connectionObject);
					if ("E".equalsIgnoreCase(errType))
					{
						isError = true;
						break;
					}
					else
					{
						errCode = "";
					}
				}

				noRows = 0;
				sql = "SELECT PAYABLE  FROM LEAVES	WHERE LVE_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,mLeave);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{	
					noRows++;
					payable = resultSet.getString("PAYABLE");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(noRows == 0)
				{
					errCode = "VMLVECD1" ;
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				if(payable.equals("Y"))
				{
					errCode = "";
					if(nvoNo == 1)
					{
						errCode = leaveRules1(memp, mLeave, mPrd, mlveDt,mlvedtTo, mNoDays , tranId,connectionObject);
					}
					else if(nvoNo == 2)
					{
						errCode = leaveRules2(memp, mLeave, mlveDt, mlvedtTo,connectionObject );
					}
					if(errCode != null && errCode.trim().length() > 0)
					{
						this.errList.add(errCode);
						this.fldList.add("");
						String errType = getErrorType(errCode ,  connectionObject);
						if ("E".equalsIgnoreCase(errType))
						{
							isError = true;
							break;
						}
						else
						{
							errCode = "";
						}
					}
				}
				break;
			}
			while(true);

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		if (!isError)
		{
			errCode = "";
		}
		return errCode;
	}

	private String leaveRules1(String empCode,String lveCode,String prdCode,java.sql.Timestamp leaveFromDate ,java.sql.Timestamp leaveToDate,double noDays,String tranId, Connection connectionObject) throws RemoteException,ITMException
	{

		String prob = "",conf = "",period ="",errCode = "";
		String sql = "";
		double noDays1 = 0,nodays2 = 0,days = 0;
		int cnt = 0,year = 0,month = 0;
		boolean isError = false;
		java.sql.Timestamp frDate =null,toDate = null,tempDate =null;
		java.sql.Timestamp lveUpTo = null,lveFrDt1 = null,lveFrDt = null;

		PreparedStatement pstmt = null;
		ResultSet resultSet = null;

		try
		{
			do
			{
				if(!"CL".equalsIgnoreCase(lveCode))
				{
					break;
				}

				period = admCommon.getEnv("999999", "LVE_FRMTH",connectionObject);
				if(period.equals("NULLFOUND"))
				{
					errCode = "VSENVAR1";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}

				year = utilMethod.year(leaveFromDate);
				month = utilMethod.month(leaveFromDate);
				lveFrDt = utilMethod.dateTime(utilMethod.date(year,month,1));

				sql = "SELECT PROBATION, CONFIRMED FROM EMPLOYEE WHERE EMP_CODE = ? ";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, empCode);
				resultSet = pstmt.executeQuery();
				while (resultSet.next())
				{
					prob = resultSet.getString("PROBATION");
					conf = resultSet.getString("CONFIRMED");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}	
				if(conf.equalsIgnoreCase("Y"))
				{
					errCode = "";
					errCode = leavesRule11("C", empCode, lveCode, noDays,3,leaveFromDate,leaveToDate, connectionObject);
					if (errCode != null && errCode.trim().length() > 0)
					{
						this.errList.add(errCode);
						this.fldList.add("");
						isError = true;
						break;
					}
					lveFrDt1 = lveFrDt;
					days = noDays;
					frDate = leaveFromDate;

					for(cnt = 1;cnt <= 2;cnt++)
					{
						lveUpTo = utilMethod.AddMonths(lveFrDt1, 6);
						lveUpTo = utilMethod.dateTime(utilMethod.RelativeDate(lveUpTo,-1 ));
						if(lveUpTo.before(leaveToDate))
						{
							days = utilMethod.DaysAfter(frDate, lveUpTo ) + 1;
						}

						sql = "SELECT SUM(NO_DAYS) AS  NO_DAYS FROM EMPLEAVE_SUMMARY WHERE EMP_CODE = ? AND LVE_CODE = ? AND LVE_DATE_FR >= ? AND LVE_DATE_TO <= ? AND USE_FLAG = 'C'";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, empCode);
						pstmt.setString(2, lveCode);
						pstmt.setTimestamp(3, lveFrDt1);
						pstmt.setTimestamp(4, lveUpTo);
						resultSet= pstmt.executeQuery();
						while(resultSet.next())
						{
							nodays2 = resultSet.getDouble("NO_DAYS");
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}

						if(Double.parseDouble(utilMethod.getReqDecString(nodays2 + days,1)) > 5)
						{
							errCode = "";
							this.errList.add("VTEMPLVE11");
							this.fldList.add("");
							String errType = getErrorType("VTEMPLVE11" , connectionObject);
							if ("E".equalsIgnoreCase(errType))
							{
								isError = true;
								break;
							}
						}
						lveFrDt1 = utilMethod.dateTime(utilMethod.RelativeDate(lveUpTo,1));
						days = noDays - days;
						frDate = utilMethod.dateTime(utilMethod.RelativeDate(lveUpTo, 1));
					}
				}
				else if(prob.equalsIgnoreCase("Y"))
				{
					errCode = "";
					errCode = leavesRule11("P",empCode,lveCode,nodays2,1,leaveFromDate,leaveToDate, connectionObject);
					if (errCode != null && errCode.trim().length() > 0)
					{
						this.errList.add(errCode);
						this.fldList.add("");
						isError = true;
						break;
					}
					lveFrDt1 = lveFrDt;
					days = noDays;
					frDate = leaveFromDate;
					for(cnt = 1;cnt <= 4 ;cnt++)
					{
						lveUpTo = utilMethod.AddMonths(lveFrDt1,3);
						lveUpTo = utilMethod.dateTime(utilMethod.RelativeDate(lveUpTo, -1));
						if(lveUpTo.before(leaveToDate))
						{
							days = utilMethod.DaysAfter(frDate,lveUpTo);
						}
						sql = "SELECT SUM(NO_DAYS) AS NO_DAYS  FROM EMPLEAVE_SUMMARY WHERE EMP_CODE = ? AND LVE_CODE = ? AND LVE_DATE_FR >= ? AND LVE_DATE_TO <= ?";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString(1, empCode);
						pstmt.setString(2, lveCode);
						pstmt.setTimestamp(3, lveFrDt1);
						pstmt.setTimestamp(4, lveUpTo);
						resultSet = pstmt.executeQuery();
						nodays2 = 0;
						while(resultSet.next())
						{
							nodays2 = resultSet.getDouble("NO_DAYS");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}

						if(Double.parseDouble(utilMethod.getReqDecString(nodays2 + days,1)) > 2.5)
						{
							errCode = "";
							this.errList.add("VTEMPLVE11");
							this.fldList.add("");
							String errType = getErrorType("VTEMPLVE11" , connectionObject);
							if ("E".equalsIgnoreCase(errType))
							{
								isError = true;
								break;
							}
							lveFrDt1 = utilMethod.dateTime(utilMethod.RelativeDate(lveUpTo,1 ));
							days = noDays - days;
							frDate = utilMethod.dateTime(utilMethod.RelativeDate(lveUpTo,1 ));
						}
					}
				}
				else
				{
					errCode = "VTEMP1";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				break;
			}
			while(true);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception fe)
			{
				fe.printStackTrace();
			}
		}
		if (!isError)
		{
			errCode = "";
		}
		return errCode;
	}

	private String leaveRules2 (String empCode, String lveCode, java.sql.Timestamp lvedt, java.sql.Timestamp lvedtTo, Connection conn) throws RemoteException,ITMException
	{

		long cnt = 0,totLvedays = 0; 
		double balDays = 0;
		int noofRows = 0;
		boolean isError = false;
		String status = "", useFlag = "", errCode = "", holTblno = "",workSite = "", prevLveCode = "", payable = "", lveTblno = "", canCombine = "", 
				canCombine1 = "", holType = "",lveStart = "" , lveEnd = "" , prevLveEnd = "" , nextLveStart = "", tranId = "", sql = "";
		java.sql.Timestamp lveTo = null, lvePrevToDate = null, frDate = null, toDate = null, frDate1 = null;
		PreparedStatement pstmt = null;
		ResultSet resultSet = null;
		//Connection conn = null;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		SimpleDateFormat dateFormat = null;
		AdmCommon admCommon = new AdmCommon();
		FinCommon finCommon = new FinCommon();
		UtilMethods sysUtilMethods = new UtilMethods();
		HashMap hmap = new HashMap();

		try 
		{

			do
			{
				hmap = getLvetbl(empCode,lveTblno, conn);
				errCode = (String)hmap.get("ERRORCODE");
				if (errCode != null && errCode.trim().length() > 0)
				{
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				lveTblno = (String)hmap.get("LEAVETABLE");
				sql = "SELECT LEAVE_STARTS , LEAVE_ENDS "+ 
						"FROM EMPLEAVE WHERE EMP_CODE = ? AND LVE_DATE_FR = ?"+ 
						"AND LVE_DATE_TO = ? AND LVE_CODE = ?"+ 
						"AND USE_FLAG = 'C' AND STATUS <> 'C'";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, empCode);
				pstmt.setTimestamp(2, lvedt);
				pstmt.setTimestamp(3, lvedtTo);
				pstmt.setString(4, lveCode);
				resultSet = pstmt.executeQuery();
				noofRows = 0;
				while(resultSet.next())
				{
					noofRows = noofRows + 1;
					lveStart = resultSet.getString("LEAVE_STARTS");
					lveEnd = resultSet.getString("LEAVE_ENDS");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				} 
				if (noofRows == 0)
				{
					errCode = "DS0001";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				sql = "SELECT MAX(LVE_DATE_FR) AS NEW_LVE_DATE_FR FROM EMPLEAVE " +
						" WHERE EMP_CODE   = ? AND LVE_DATE_TO <= ? AND STATUS = 'A' AND USE_FLAG = 'C'";
				pstmt = conn.prepareStatement(sql);

				pstmt.setString(1, empCode);
				pstmt.setTimestamp(2, lvedt);

				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					frDate = resultSet.getTimestamp("NEW_LVE_DATE_FR");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				} 
				if(frDate != null)
				{
					cnt = 0;
					sql = "SELECT COUNT(*) AS CNT FROM EMPLEAVE " +
							"WHERE EMP_CODE = ? AND LVE_DATE_FR =  ? AND STATUS = 'A' AND  USE_FLAG = 'C' ";
					pstmt = conn.prepareStatement(sql);

					pstmt.setString(1, empCode);
					pstmt.setTimestamp(2, frDate);

					resultSet = pstmt.executeQuery();
					while(resultSet.next())
					{
						totLvedays = resultSet.getLong("CNT");
					}
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					} 

					if(totLvedays > 1)
					{ 
						if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME.trim().toUpperCase()))
						{
							sql = "SELECT LVE_DATE_TO,LVE_CODE,LEAVE_ENDS FROM EMPLEAVE WHERE EMP_CODE = ? AND LVE_DATE_FR =  ? AND" +
									" STATUS = 'A' AND USE_FLAG = 'C' AND LVE_DATE_TO = ( SELECT MAX(LVE_DATE_TO) FROM EMPLEAVE WHERE " +
									"EMP_CODE = ? AND LVE_DATE_FR =  ? AND STATUS = 'A'  AND USE_FLAG = 'C' ) FETCH FIRST ROW ONLY";
							pstmt = conn.prepareStatement(sql);

							pstmt.setString(1, empCode);
							pstmt.setTimestamp(2, frDate);
							pstmt.setString(3, empCode);
							pstmt.setTimestamp(4, frDate);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								toDate = resultSet.getTimestamp("LVE_DATE_TO");
								prevLveCode = resultSet.getString("LVE_CODE");
								prevLveEnd = resultSet.getString("LEAVE_ENDS");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 
						}
						else
						{
							sql = "SELECT LVE_DATE_TO,LVE_CODE,LEAVE_ENDS FROM EMPLEAVE WHERE EMP_CODE = ? AND LVE_DATE_FR =  ? AND STATUS = 'A'  " +
									"AND USE_FLAG = 'C' AND LVE_DATE_TO = ( SELECT MAX(LVE_DATE_TO) FROM EMPLEAVE WHERE EMP_CODE = ? AND LVE_DATE_FR =  ? AND" +
									" STATUS = 'A' AND  USE_FLAG = 'C' ) AND ROWNUM < 2";
							pstmt = conn.prepareStatement(sql);

							pstmt.setString(1, empCode);
							pstmt.setTimestamp(2, frDate);
							pstmt.setString(3, empCode);
							pstmt.setTimestamp(4, frDate);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								toDate = resultSet.getTimestamp("LVE_DATE_TO");
								prevLveCode = resultSet.getString("LVE_CODE");
								prevLveEnd = resultSet.getString("LEAVE_ENDS");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 
						}
					}
					else
					{
						sql = "SELECT LVE_DATE_TO,LVE_CODE,LEAVE_ENDS  FROM EMPLEAVE WHERE EMP_CODE = ? AND LVE_DATE_FR =  ? " +
								"AND STATUS = 'A'  AND USE_FLAG = 'C'";
						pstmt = conn.prepareStatement(sql);

						pstmt.setString(1, empCode);
						pstmt.setTimestamp(2, frDate);

						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							toDate = resultSet.getTimestamp("LVE_DATE_TO");
							prevLveCode = resultSet.getString("LVE_CODE");
							prevLveEnd = resultSet.getString("LEAVE_ENDS");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						} 
					}
				}
				else
				{
					sql = "SELECT MIN(LVE_DATE_FR) AS LVE_DATE_FR FROM EMPLEAVE WHERE EMP_CODE = ? AND LVE_DATE_TO >= ? " +
							" AND STATUS = 'A' AND  USE_FLAG = 'C'";
					pstmt = conn.prepareStatement(sql);

					pstmt.setString(1, empCode);
					pstmt.setTimestamp(2, lvedtTo);
					//	pstmt.setString(3, tranId);  // Commented by Vishal Thakur  

					resultSet = pstmt.executeQuery();
					while(resultSet.next())
					{
						frDate1 = resultSet.getTimestamp("LVE_DATE_FR");
					}
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					} 
					if(frDate1 != null)
					{
						sql = "SELECT LVE_CODE, LEAVE_STARTS FROM EMPLEAVE WHERE EMP_CODE  = ? AND LVE_DATE_FR = ? AND " +
								"STATUS = 'A'  AND USE_FLAG = 'C'";
						pstmt = conn.prepareStatement(sql);

						pstmt.setString(1, empCode);
						pstmt.setTimestamp(2, frDate1);

						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							prevLveCode = resultSet.getString("LVE_CODE");
							nextLveStart = resultSet.getString("LEAVE_STARTS");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						} 
					}
					else
					{
						break;
					}
					if(sysUtilMethods.DaysAfter(lvedtTo, frDate1) > 1)
					{
						lvePrevToDate = sysUtilMethods.dateTime(sysUtilMethods.RelativeDate(lvedtTo, 1));
						do
						{

							sql = "SELECT FN_GET_HOLTBLNO(?,?) AS HOL_TBLNO FROM DUAL";
							pstmt = conn.prepareStatement(sql);

							pstmt.setString(1, empCode);
							pstmt.setTimestamp(2, lvePrevToDate);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								holTblno = resultSet.getString("HOL_TBLNO");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 
							if (holTblno != null && holTblno.trim().length() > 0 && "DS000".equalsIgnoreCase(sysUtilMethods.mid(holTblno,1,5)))
							{
								errCode = holTblno;
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}

							holType = admCommon.scanHolWoffFordate(empCode , holTblno, lvePrevToDate ,conn);
							if(holType != null && holType.trim().length() > 0)
							{
								if(sysUtilMethods.pos("HW", holType) == 0)
								{
									errCode = holType;
									this.errList.add(errCode);
									this.fldList.add("");
									isError = true;
									break;
								}
							}
							else
							{
								break;
							}
							lvePrevToDate = sysUtilMethods.dateTime(sysUtilMethods.RelativeDate(lvePrevToDate, 1));

						}while(lvePrevToDate.before(frDate1));
						if(lvePrevToDate.equals(frDate1))
						{
							sql = "SELECT PAYABLE FROM LEAVES WHERE LVE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, prevLveCode);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								payable = resultSet.getString("PAYABLE");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 
							if(payable.equals("Y"))
							{
								canCombine = "N";
								canCombine1 = "N";

								sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
								pstmt = conn.prepareStatement(sql);

								pstmt.setString(1, lveCode);
								pstmt.setString(2, lveTblno);

								resultSet = pstmt.executeQuery();
								while(resultSet.next())
								{
									canCombine = resultSet.getString("CAN_COMBINE");
								}
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								} 

								sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
								pstmt = conn.prepareStatement(sql);

								pstmt.setString(1, prevLveCode);
								pstmt.setString(2, lveTblno);

								resultSet = pstmt.executeQuery();
								while(resultSet.next())
								{
									canCombine1 = resultSet.getString("CAN_COMBINE");
								}
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								} 

								if (canCombine == null || canCombine.trim().length() == 0)
								{
									canCombine = "N";
								}
								if (canCombine1 == null || canCombine1.trim().length() == 0)
								{
									canCombine1 = "N";
								}
								if(canCombine.equalsIgnoreCase("N") && canCombine1.equalsIgnoreCase("N") && lveEnd.equalsIgnoreCase("E") && nextLveStart.equalsIgnoreCase("B"))
								{
									errCode = "VTLVECHK1";
									this.errList.add(errCode);
									this.fldList.add("");
									String errType = getErrorType(errCode , conn);
									if ("E".equalsIgnoreCase(errType))
									{
										isError = true;
										break;
									}
									errCode = "";
								}
							}
						}
					}
					else
					{
						sql = "SELECT PAYABLE FROM LEAVES WHERE LVE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, prevLveCode);

						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							payable = resultSet.getString("PAYABLE");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						} 
						if(payable.equals("Y"))
						{
							canCombine = "N";
							canCombine1 = "N";

							sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
							pstmt = conn.prepareStatement(sql);

							pstmt.setString(1, lveCode);
							pstmt.setString(2, lveTblno);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								canCombine = resultSet.getString("CAN_COMBINE");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 

							sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINEFROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
							pstmt = conn.prepareStatement(sql);

							pstmt.setString(1, prevLveCode);
							pstmt.setString(2, lveTblno);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								canCombine1 = resultSet.getString("CAN_COMBINE");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 

							if (canCombine == null || canCombine.trim().length() == 0)
							{
								canCombine = "N";
							}
							if (canCombine1 == null || canCombine1.trim().length() == 0)
							{
								canCombine1 = "N";
							}
							if(canCombine.equalsIgnoreCase("N") && canCombine1.equalsIgnoreCase("N") && 
									((sysUtilMethods.DaysAfter(lvedtTo, frDate1) > 0 && lveEnd.equalsIgnoreCase("E") && nextLveStart.equalsIgnoreCase("B")) || 
											(sysUtilMethods.DaysAfter(lvedtTo, frDate1) == 0)))
							{
								errCode = "";
								this.errList.add("VTLVE20");
								this.fldList.add("");
								String errType = getErrorType("VTLVE20" , conn);
								if ("E".equalsIgnoreCase(errType))
								{
									isError = true;
									break;
								}
							}
						}
					}
				}
				if(sysUtilMethods.DaysAfter(toDate, lvedt) > 1)
				{
					lvePrevToDate = sysUtilMethods.dateTime(sysUtilMethods.RelativeDate(toDate, 1));

					do
					{

						sql = "SELECT FN_GET_HOLTBLNO(?,?) AS GET_HOLTBLNO FROM DUAL";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, empCode);
						pstmt.setTimestamp(2, lvePrevToDate);

						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							holTblno = resultSet.getString("GET_HOLTBLNO");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						} 
						if (holTblno != null && holTblno.trim().length() > 0 && "DS000".equalsIgnoreCase(sysUtilMethods.mid(holTblno,1,5)))
						{
							errCode = holTblno;
							this.errList.add(errCode);
							this.fldList.add("");
							isError = true;
							break;
						}

						holType = admCommon.scanHolWoffFordate(empCode , holTblno,lvePrevToDate,conn);
						if(holType != null && holType.trim().length() > 0)
						{
							if(sysUtilMethods.pos("HW", holType) == 0)
							{
								errCode = holType;
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}
						}
						else
						{
							break;
						}
						lvePrevToDate = sysUtilMethods.dateTime(sysUtilMethods.RelativeDate(lvePrevToDate, 1));
					}while(lvePrevToDate.before(lvedt));
					if(lvePrevToDate.equals(lvedt))
					{

						sql = "SELECT PAYABLE FROM LEAVES WHERE LVE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, prevLveCode);

						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							payable = resultSet.getString("PAYABLE");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						} 
						if(payable.equals("Y"))
						{
							canCombine = "N";
							canCombine1 = "N";

							sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
							pstmt = conn.prepareStatement(sql);

							pstmt.setString(1, lveCode);
							pstmt.setString(2, lveTblno);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								canCombine = resultSet.getString("CAN_COMBINE");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 

							sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
							pstmt = conn.prepareStatement(sql);

							pstmt.setString(1, prevLveCode);
							pstmt.setString(2, lveTblno);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								canCombine1 = resultSet.getString("CAN_COMBINE");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 
							if (canCombine == null || canCombine.trim().length() == 0)
							{
								canCombine = "N";
							}
							if (canCombine1 == null || canCombine1.trim().length() == 0)
							{
								canCombine1 = "N";
							}

							if(canCombine.equalsIgnoreCase("N") && canCombine1.equalsIgnoreCase("N") && lveStart.equalsIgnoreCase("B") && nextLveStart.equalsIgnoreCase("E"))
							{
								errCode = "VTLVECHK1";
								this.errList.add(errCode);
								this.fldList.add("");
								String errType = getErrorType(errCode , conn);
								if ("E".equalsIgnoreCase(errType))
								{
									isError = true;
									break;
								}
								errCode = "";
							}
						}
					}

					sql = "SELECT MIN(LVE_DATE_FR) FROM EMPLEAVE WHERE EMP_CODE = ? AND LVE_DATE_TO >= ? AND STATUS = 'A' AND USE_FLAG = 'C'";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					pstmt.setTimestamp(2, lvedtTo);
					resultSet = pstmt.executeQuery();
					while(resultSet.next())
					{
						frDate1 = resultSet.getTimestamp(1);
					}
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					if (frDate1 != null)
					{
						sql = "SELECT LVE_CODE, LEAVE_STARTS FROM EMPLEAVE WHERE EMP_CODE  = ? AND LVE_DATE_FR = ? AND STATUS = 'A' AND USE_FLAG = 'C'";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, empCode);
						pstmt.setTimestamp(2, frDate1);
						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							prevLveCode = resultSet.getString("LVE_CODE");
							nextLveStart = resultSet.getString("LEAVE_STARTS");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					else
					{
						break;
					}
					if(utilMethod.DaysAfter(utilMethod.date(lvedtTo),utilMethod.date(frDate1)) > 1)
					{
						lvePrevToDate = utilMethod.dateTime(utilMethod.RelativeDate(utilMethod.date(lvedtTo),1));
						do
						{
							sql = "SELECT FN_GET_HOLTBLNO(?,?) AS HOL_TBLNO FROM DUAL";
							pstmt.setString(1, empCode);
							pstmt.setTimestamp(2, lvePrevToDate);
							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								holTblno = resultSet.getString(1);
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if (holTblno != null && holTblno.trim().length() > 0 && "DS000".equalsIgnoreCase(sysUtilMethods.mid(holTblno,1,5)))
							{
								errCode = holTblno;
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}

							holType = admCommon.scanHolWoffFordate(empCode , holTblno,lvePrevToDate,conn);
							if(holType != null && holType.trim().length() > 0)
							{
								if(sysUtilMethods.pos("HW", holType) == 0)
								{
									errCode = holType;
									this.errList.add(errCode);
									this.fldList.add("");
									isError = true;
									break;
								}
							}
							else
							{
								break;
							}
							lvePrevToDate = utilMethod.dateTime(utilMethod.RelativeDate(utilMethod.date(lvePrevToDate),1));
						}
						while (lvePrevToDate.before(frDate1));
						if(lvePrevToDate.equals(frDate1))
						{
							sql = "SELECT PAYABLE FROM LEAVES WHERE LVE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, prevLveCode);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								payable = resultSet.getString("PAYABLE");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 
							if(payable.equals("Y"))
							{
								canCombine = "N";
								canCombine1 = "N";

								sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
								pstmt = conn.prepareStatement(sql);

								pstmt.setString(1, lveCode);
								pstmt.setString(2, lveTblno);

								resultSet = pstmt.executeQuery();
								while(resultSet.next())
								{
									canCombine = resultSet.getString("CAN_COMBINE");
								}
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								} 

								sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
								pstmt = conn.prepareStatement(sql);

								pstmt.setString(1, prevLveCode);
								pstmt.setString(2, lveTblno);

								resultSet = pstmt.executeQuery();
								while(resultSet.next())
								{
									canCombine1 = resultSet.getString("CAN_COMBINE");
								}
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								} 
								if (canCombine == null || canCombine.trim().length() == 0)
								{
									canCombine = "N";
								}
								if (canCombine1 == null || canCombine1.trim().length() == 0)
								{
									canCombine1 = "N";
								}

								if(canCombine.equalsIgnoreCase("N") && canCombine1.equalsIgnoreCase("N") && lveEnd.equalsIgnoreCase("E") && nextLveStart.equalsIgnoreCase("B"))
								{
									errCode = "VTLVECHK1";
									this.errList.add(errCode);
									this.fldList.add("");
									String errType = getErrorType(errCode , conn);
									if ("E".equalsIgnoreCase(errType))
									{
										isError = true;
										break;
									}
									errCode = "";
								}
							}
						}
					}
					else
					{
						sql = "SELECT PAYABLE FROM LEAVES WHERE LVE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, prevLveCode);

						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							payable = resultSet.getString("PAYABLE");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						} 
						if(payable.equals("Y"))
						{
							canCombine = "N";
							canCombine1 = "N";

							sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
							pstmt = conn.prepareStatement(sql);

							pstmt.setString(1, lveCode);
							pstmt.setString(2, lveTblno);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								canCombine = resultSet.getString("CAN_COMBINE");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 

							sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
							pstmt = conn.prepareStatement(sql);

							pstmt.setString(1, prevLveCode);
							pstmt.setString(2, lveTblno);

							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								canCombine1 = resultSet.getString("CAN_COMBINE");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							} 
							if (canCombine == null || canCombine.trim().length() == 0)
							{
								canCombine = "N";
							}
							if (canCombine1 == null || canCombine1.trim().length() == 0)
							{
								canCombine1 = "N";
							}

							if(canCombine.equalsIgnoreCase("N") && canCombine1.equalsIgnoreCase("N") && 
									((sysUtilMethods.DaysAfter(lvedtTo, frDate1) > 0 && lveEnd.equalsIgnoreCase("E") && nextLveStart.equalsIgnoreCase("B")) || 
											(sysUtilMethods.DaysAfter(lvedtTo, frDate1) == 0)))
							{
								errCode = "";
								this.errList.add("VTLVE20");
								this.fldList.add("");
								String errType = getErrorType("VTLVE20" , conn);
								if ("E".equalsIgnoreCase(errType))
								{
									isError = true;
									break;
								}
							}
						}
					}
				}
				else
				{
					sql = "SELECT PAYABLE FROM LEAVES WHERE LVE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, prevLveCode);

					resultSet = pstmt.executeQuery();
					while(resultSet.next())
					{
						payable = resultSet.getString("PAYABLE");
					}
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					} 
					if(payable.equals("Y"))
					{
						canCombine = "N";
						canCombine1 = "N";

						sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
						pstmt = conn.prepareStatement(sql);

						pstmt.setString(1, lveCode);
						pstmt.setString(2, lveTblno);

						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							canCombine = resultSet.getString("CAN_COMBINE");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						} 

						sql = "SELECT (CASE WHEN CAN_COMBINE IS NULL THEN 'N' ELSE CAN_COMBINE END ) AS CAN_COMBINE FROM LVETABLE WHERE LVE_CODE = ? AND LVE_TBLNO = ?";
						pstmt = conn.prepareStatement(sql);

						pstmt.setString(1, prevLveCode);
						pstmt.setString(2, lveTblno);

						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							canCombine1 = resultSet.getString("CAN_COMBINE");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						} 
						if (canCombine == null || canCombine.trim().length() == 0)
						{
							canCombine = "N";
						}
						if (canCombine1 == null || canCombine1.trim().length() == 0)
						{
							canCombine1 = "N";
						}

						if(canCombine.equalsIgnoreCase("N") && canCombine1.equalsIgnoreCase("N") && 
								((sysUtilMethods.DaysAfter(toDate, lvedt) > 0 && lveStart.equalsIgnoreCase("B") && prevLveEnd.equalsIgnoreCase("E")) || 
										(sysUtilMethods.DaysAfter(toDate, lvedt) == 0)))
						{
							errCode = "";
							this.errList.add("VTLVE20");
							this.fldList.add("");
							String errType = getErrorType("VTLVE20" , conn);
							if ("E".equalsIgnoreCase(errType))
							{
								isError = true;
								break;
							}
						}
					}
				}
				break;
			}while(true);
		}
		catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try 
			{

				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				} 
			} 
			catch (SQLException fe) {
				fe.printStackTrace();
			}
		}
		if (!isError)
		{
			errCode = "";
		}
		return errCode;
	}

	private HashMap getLvetbl(String empCode,String lveTblno, Connection connectionObject) throws RemoteException,ITMException
	{
		String  grade = "", cadre = "", workSite = "", errCode = "", fldName = "",sql = "";
		int noRows = 0;
		boolean isError = false;

		HashMap hmap = new HashMap();

		PreparedStatement pstmt = null;
		ResultSet resultSet = null;

		lveTblno = "";
		hmap.put("LEAVETABLE" , lveTblno);
		hmap.put("ERRORCODE" , errCode);

		try
		{

			sql= "SELECT WORK_SITE, GRADE, CADRE FROM EMPLOYEE WHERE EMP_CODE =  ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empCode);
			resultSet = pstmt.executeQuery();
			while(resultSet.next())
			{
				noRows++;
				workSite = resultSet.getString("WORK_SITE");
				grade = resultSet.getString("GRADE");
				cadre = resultSet.getString("CADRE");
			}
			if(resultSet != null)
			{
				resultSet.close();
				resultSet = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(noRows == 0)
			{
				errCode = "VMEMPCD1";
				this.errList.add(errCode);
				this.fldList.add("");
				isError = true;
				hmap.put("ERRORCODE" , errCode);
			}
			else
			{
				hmap = getLvetbl(workSite,grade,cadre,lveTblno, connectionObject);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception fe)
			{
				fe.printStackTrace();
			}
		}

		return hmap;
	}

	private HashMap getLvetbl(String workSite,String grade,String cadre ,String lveTblno,Connection connectionObject) throws RemoteException,ITMException
	{
		HashMap hmap = new HashMap();

		String errCode = "",fldName = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet resultSet = null;

		lveTblno = "";
		hmap.put("LEAVETABLE" , lveTblno);
		hmap.put("ERRORCODE" , errCode);

		try
		{
			System.out.println("=============Inside getLvetbl==========");
			sql = "SELECT LVE_TBLNO FROM GRADE_SITE_LVETBL WHERE SITE_CODE = ? AND GRADE_CODE = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, workSite);
			pstmt.setString(2, grade);
			resultSet = pstmt.executeQuery();
			while(resultSet.next())
			{
				lveTblno = resultSet.getString("LVE_TBLNO");
			}
			if(resultSet != null)
			{
				resultSet.close();
				resultSet = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if( lveTblno == null || lveTblno.trim().length() == 0)
			{
				sql = "SELECT LVE_TBLNO FROM CADRE_SITE_LVETBL WHERE SITE_CODE = ? AND CADRE_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, workSite);
				pstmt.setString(2, cadre);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					lveTblno = resultSet.getString("LVE_TBLNO");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( lveTblno == null || lveTblno.trim().length() == 0)
				{
					lveTblno = "";
					errCode = "VTLVETBL";
					fldName = "emp_code";
					this.errList.add(errCode);
					this.fldList.add(fldName);
					hmap.put("LEAVETABLE" , lveTblno);
					hmap.put("ERRORCODE" , errCode);
				}
				else
				{
					errCode = "";
					hmap.put("LEAVETABLE" , lveTblno);
					hmap.put("ERRORCODE" , errCode);
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception fe)
			{
				fe.printStackTrace();
			}
		}
		return hmap;
	}


	private String leavesRule11(String confOrProbe,String empCode,String lveCode,double noDays,double noDaysInMonth,java.sql.Timestamp lvedtFr,java.sql.Timestamp lvedtTo, Connection connectionObject) throws RemoteException,ITMException
	{

		String errCode = "",period = "";
		double noDays1 = 0,days = 0;
		boolean isError = false;
		java.sql.Timestamp toDate = null,tempDate = null;


		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet resultSet = null;
		try
		{
			tempDate = lvedtFr;
			days = noDays;
			do
			{

				sql = "SELECT CODE,FR_DATE,TO_DATE FROM PERIOD WHERE FR_DATE <= ? AND TO_DATE >= ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setTimestamp(1 ,tempDate);
				pstmt.setTimestamp(2 ,tempDate);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					period = resultSet.getString("");

					toDate = resultSet.getTimestamp("TO_DATE");

				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt =  null;
				}	


				if(toDate.after(lvedtTo))
				{
					toDate = lvedtTo;
				}
				else
				{
					days = days - utilMethod.DaysAfter(lvedtTo, toDate);
				}
				do
				{
					sql = "SELECT SUM(NO_DAYS) AS NO_DAYS FROM EMPLEAVE_SUMMARY WHERE EMP_CODE = ? AND LVE_CODE = ? AND PRD_CODE = ? AND USE_FLAG = 'C'";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1 ,empCode);
					pstmt.setString(2 ,lveCode);
					pstmt.setString(3 ,period);
					resultSet = pstmt.executeQuery();
					while(resultSet.next())
					{
						noDays1 = resultSet.getDouble("NO_DAYS");
					}
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt =  null;
					}
					if (Double.parseDouble(utilMethod.getReqDecString(noDays1 + days ,1)) > noDaysInMonth)
					{
						errCode = "";
						this.errList.add("VTEMPLVE10");
						this.fldList.add("");
						String errType = getErrorType("VTEMPLVE10" , connectionObject);
						if ("E".equalsIgnoreCase(errType))
						{
							isError = true;
							break;
						}
					}
					break;
				}
				while(true);

				if(errCode != null && errCode.trim().length() != 0)
				{ 
					break;
				}
				tempDate = utilMethod.dateTime(utilMethod.RelativeDate(toDate, 1));
			}
			while((tempDate.before(lvedtTo)) || (tempDate.equals(lvedtTo)));
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt =  null;
				}

			}
			catch (Exception fe)
			{
				fe.printStackTrace();
			}
		}
		if (!isError)
		{
			errCode = "";
		}
		return errCode;
	}

	private String leavesApprove(String tranId , int saveFlag,String payrollOrVoucher,String payrollPeriod,int commit, Connection connectionObject) throws RemoteException,ITMException
	{

		String museFlag = "",fVal1 = "",fVal2 = "",mStatus = "",mPrd = "",balOpt = "",site = "",period = "";
		String refNo = "",adCode = "",errCode = "",mEmp = "",mLveCode = "";
		String payable = "",dept = "",ledgPostConf = "",ediOption = "";
		String var3 = "",var13 = "", var5 = "",var11 = "",var12 = "",sVar6 = "",var7 = "";
		String 	var14 = "",var9 = "",var10 = "",isnull="",newLve = "";
		double 	mBasic = 0, mGross = 0;
		java.sql.Timestamp fVal3 = null, fVal4 = null, fVal5= null,  mDate3 = null, frDate = null,toDate = null;
		java.sql.Timestamp var2 = null,dVar6 = null , mDate1 = null , mDate2 = null ;
		java.sql.Timestamp chgTime = null,tempToDt = null,tempFrDt = null,mDate = null, date = null, aprvDate = null, effDate = null;
		double	nVar1 = 0 , mDays = 0, mAmt = 0;
		double 	mConDays = 0, mEnchDays = 0, fVal6 = 0, updBal = 0, nextBal = 0d;
		int 	mCnt = 0 ,times = 0;
		boolean advFlag = false;
		double 	noDays = 0, days = 0 ,noDays1 = 0;
		java.sql.Timestamp lveTempDate1 = null,pmDate1 = null, pmDate2 = null ,effDt1 = null  ,effDt2 = null;
		String	plStart = "", plEnd = "", errCd = "" ,leaveStart = "" , leaveEnd = "", lveStart = "" , lveEnd = "";
		String 	workSite = "", grade = "", cadre = "",lveTblno = "", accum = "", extraArg = "";
		java.sql.Timestamp cfDate = null, cfDatelist[] = null; 
		long row = 0;
		boolean isError = false;

		String sql = "", sql1 = "", sql2 = "", sql3 = "" , sql4 = "", sql5 = "", sql6 = "", sql7 = "";
		PreparedStatement pstmt = null, pstmt1 = null, pstmt2 = null, pstmt3 = null, pstmt4 = null, pstmt5 = null, pstmt6 = null, pstmt7 = null;
		ResultSet resultSet = null,  resultSet1 = null, resultSet2 = null, resultSet3 = null, resultSet4 = null, resultSet5 = null, resultSet6 = null, resultSet7 = null ;
		int noRows = 0;
		//$$$$$$$$$$$$$$$$$$$$$ START $$$$$$$$$$$$$$$$$$$$$$$$$$
		/*PayVoucherData voucData;
		FuncReturn funcReturn;
		s_vouchdata	ls_vouchdata;*/

		//AEDFunctionsAdv functionsAdv = new AEDFunctionsAdv();
		AttdProcess attdProc;
		//$$$$$$$$$$$$$$$$$$$$$ END $$$$$$$$$$$$$$$$$$$$$$$$$$
		try
		{
			System.out.println("================Inside Leaves approve==============");
			//connectionObject = getConnection();
			chgTime = utilMethod.dateTime(utilMethod.todaySqlDate(),utilMethod.now());
			mDate3 = utilMethod.dateTime(utilMethod.todaySqlDate());

			mAmt = 0;
			this.errXml = "";
			cfDate = null;
			do
			{
				noRows = 0;
				sql = "SELECT EMP_CODE,LVE_CODE,LVE_DATE_FR,LVE_DATE_TO,STATUS, NO_DAYS, USE_FLAG, ENCH_AMT, PRD_CODE, APRV_DATE, LEAVE_STARTS,LEAVE_ENDS FROM EMPLEAVE WHERE TRAN_ID = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,tranId );
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					noRows++;
					mEmp = resultSet.getString("EMP_CODE");
					mLveCode = resultSet.getString("LVE_CODE");
					mDate1 = resultSet.getTimestamp("LVE_DATE_FR");
					mDate2 = resultSet.getTimestamp("LVE_DATE_TO");
					mStatus = resultSet.getString("STATUS");
					mDays = resultSet.getDouble("NO_DAYS");
					museFlag = resultSet.getString("USE_FLAG");
					mAmt = resultSet.getDouble("ENCH_AMT");
					mPrd = resultSet.getString("PRD_CODE");
					aprvDate = resultSet.getTimestamp("APRV_DATE");
					lveStart = resultSet.getString("LEAVE_STARTS");
					lveEnd = resultSet.getString("LEAVE_ENDS");
				}	
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (mStatus.equals("A"))
				{
					errCode = "VTEMPLVE3";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				else if(mStatus.equals("C"))
				{
					errCode ="VTSTATUS";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				noRows = 0;
				sql = "SELECT PAYABLE, BAL_OPT FROM LEAVES WHERE LVE_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, mLveCode);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					noRows++;
					payable = resultSet.getString("PAYABLE");
					balOpt = resultSet.getString("BAL_OPT");
				}

				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(noRows == 0)
				{
					errCode = "VMLVECD1";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				if(museFlag.equalsIgnoreCase("C"))
				{
					lveTempDate1 = mDate1;
					leaveStart = lveStart;
					leaveEnd = lveEnd;
					do
					{
						noRows = 0;
						sql1 = "SELECT LVE_DATE_FR,LVE_DATE_TO,NO_DAYS,LEAVE_STARTS,LEAVE_ENDS "+    
								" FROM EMPLEAVE WHERE  EMP_CODE = ? AND ? BETWEEN LVE_DATE_FR AND LVE_DATE_TO AND TRAN_ID	<>  ? "+
								" AND USE_FLAG  = 'C'	AND STATUS <> 'C'";
						pstmt1 = connectionObject.prepareStatement(sql1);
						pstmt1.setString(1, mEmp);
						pstmt1.setTimestamp(2,lveTempDate1);
						pstmt1.setString(3, tranId);
						resultSet1 = pstmt1.executeQuery();
						while(resultSet1.next())
						{
							noRows++;
							pmDate1 = resultSet1.getTimestamp("LVE_DATE_FR");
							pmDate2 = resultSet1.getTimestamp("LVE_DATE_TO");
							noDays = resultSet1.getDouble("NO_DAYS");
							plStart = resultSet1.getString("LEAVE_STARTS");
							plEnd = resultSet1.getString("LEAVE_ENDS");
						}
						if(resultSet1 != null)
						{
							resultSet1.close();
							resultSet1 = null;
						}
						if(pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null;
						}
						if(noRows > 0)
						{
							if((lveTempDate1.after(pmDate1) && lveTempDate1.before(pmDate2)) || (plStart.equals("B") && plEnd.equals("E")))
							{
								errCd = "VTLVEDATE2";
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}
							else if(pmDate1.equals(lveTempDate1) && (plStart.equalsIgnoreCase(leaveStart)) || (!(pmDate1.equals(pmDate2)) && leaveEnd.equalsIgnoreCase("E")) || (pmDate1.equals(pmDate2) && plEnd.equalsIgnoreCase(leaveEnd)))
							{
								errCd="VTLVEDATE2";
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}	
							else if (pmDate2.equals(lveTempDate1) && (plEnd.equalsIgnoreCase(leaveEnd) || (!(pmDate1.equals(pmDate2))) && leaveStart.equalsIgnoreCase("B")) || (pmDate1.equals(pmDate2) && plStart.equals(leaveStart)))
							{
								errCd="VTLVEDATE2";
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}
						}
						noRows = 0;
						if(errCd.trim().length() > 0)
						{
							errCode = "VTDATE5";
							this.errList.add(errCode);
							this.fldList.add("");
							isError = true;
							break;
						}
						else if(lveTempDate1.equals(mDate2))
						{
							break;
						}
						else 
						{
							lveTempDate1 = utilMethod.dateTime(utilMethod.RelativeDate(lveTempDate1, 1));
							leaveStart = "B";
							if(lveTempDate1.equals(mDate2))
							{
								leaveEnd = lveEnd;
							}
							else
							{
								leaveEnd = "E";
							}
						}
					}while(((lveTempDate1.before(mDate2)) || (lveTempDate1.equals(mDate2))));
				}
				if(errCode != null && errCode.trim().length() > 0)
				{
					isError = true;
					break;
				}
				if(balOpt.equals("Y"))
				{
					boolean allowUpdateNegLeave =  (Boolean)this.lveRuleList.get("allow_update_negative_leave");
					if(allowUpdateNegLeave == true && museFlag.equals("C"));
					{
						errCode = "";
						errCode = checkEffectiveBalRecord(tranId,mEmp,mLveCode,mDate1,mDate2 , connectionObject);
						if((errCode != null) && errCode.trim().length() > 0)
						{
							isError = true;
							break;
						}
					}
					nextBal = mDays;
					noRows = 0;
					sql = "SELECT EMP_CODE, LVE_CODE,EFF_DATE, UPTO_DATE,EXP_DATE, BAL_DAYS FROM LEAVEBAL WHERE EMP_CODE = ? AND LVE_CODE = ? AND EXP_DATE >= ? ORDER BY EXP_DATE";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, mEmp);
					pstmt.setString(2, mLveCode);
					pstmt.setTimestamp(3, mDate1);
					resultSet = pstmt.executeQuery();
					while(resultSet.next())
					{
						noRows++;
						fVal1 = resultSet.getString("EMP_CODE");
						fVal2 = resultSet.getString("LVE_CODE");
						fVal3 = resultSet.getTimestamp("EFF_DATE");
						fVal4 = resultSet.getTimestamp("UPTO_DATE");
						fVal5 = resultSet.getTimestamp("EXP_DATE");
						fVal6 = resultSet.getDouble("BAL_DAYS");
					}
					if(noRows > 0)
					{
						if( ((fVal6 < 0) || (fVal6 == 0 && (fVal3.before(mDate1) || fVal3.equals(mDate1)))))
						{
							continue;
						}
						if(fVal6 < nextBal)
						{
							updBal = fVal6;
						}
						else
						{
							updBal = nextBal;
						}
						mConDays =  updBal;
						mEnchDays = 0;
						if(museFlag.equals("E"))
						{
							mConDays = 0;
							mEnchDays = updBal;
						}
						sql2 = "UPDATE LEAVEBAL SET BAL_DAYS= BAL_DAYS - ?,CONS_DAYS  = CONS_DAYS + ?,ENCH_DAYS  = ENCH_DAYS + ? WHERE EMP_CODE = ? AND LVE_CODE = ? AND EFF_DATE = ? AND UPTO_DATE = ?";
						pstmt2 = connectionObject.prepareStatement(sql2);

						pstmt2.setDouble(1,updBal );
						pstmt2.setDouble(2, mConDays);
						pstmt2.setDouble(3,mEnchDays);
						pstmt2.setString(4, fVal1);
						pstmt2.setString(5, fVal2);
						pstmt2.setTimestamp(6, fVal3);
						pstmt2.setTimestamp(7, fVal4);
						noRows = pstmt2.executeUpdate();

						noRows = 0;
						sql3 = "SELECT COUNT(*) AS COUNT FROM EMPLVE_TRACE WHERE TRAN_ID = ? AND EFF_DATE = ? AND UPTO_DATE = ?";
						pstmt3 = connectionObject.prepareStatement(sql3);
						pstmt3.setString(1, tranId);
						pstmt3.setTimestamp(2, fVal3);
						pstmt3.setTimestamp(3, fVal4);
						resultSet3 = pstmt3.executeQuery();
						while(resultSet3.next())
						{
							mCnt = resultSet3.getInt("COUNT");
						}
						if(resultSet3 != null)
						{
							resultSet3.close();
							resultSet3 = null;
						}
						if(pstmt3 != null)
						{
							pstmt3.close();
							pstmt3 = null;
						}
						if(cfDate == null)
						{
							cfDate = mDate1;
						}
						if(fVal3.before(cfDate))
						{
							cfDate = fVal3;
						}
						if(mCnt == 0)
						{

							sql4 = "INSERT INTO EMPLVE_TRACE (TRAN_ID , EMP_CODE, LVE_DATE_FR, LVE_DATE_TO, LVE_CODE,EFF_DATE, UPTO_DATE, LVES_ALLOC) VALUES (?,?,?,?,?,?, ?, ?)";
							pstmt4 = connectionObject.prepareStatement(sql4);	
							pstmt4.setString(1, tranId);
							pstmt4.setString(2, mEmp);
							pstmt4.setTimestamp(3, mDate1);
							pstmt4.setTimestamp(4, mDate2);
							pstmt4.setString(5, mLveCode);
							pstmt4.setTimestamp(6, fVal3);
							pstmt4.setTimestamp(7, fVal4);
							pstmt4.setDouble(8, updBal);
							noRows = pstmt4.executeUpdate();
							pstmt4.clearParameters();
							if(noRows != 1)
							{
								errCode = "DS000NR";
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}
						}
						else
						{
							noRows = 0;
							sql5 = "UPDATE EMPLVE_TRACE SET LVES_ALLOC = (CASE WHEN LVES_ALLOC IS NULL THEN 0 ELSE LVES_ALLOC END) + ? " 
									+" WHERE TRAN_ID = ?  AND EFF_DATE    =  ?   AND UPTO_DATE   = ?";
							pstmt5 = connectionObject.prepareStatement(sql5);
							pstmt5.setDouble(1, updBal);
							pstmt5.setString(2, tranId);
							pstmt5.setTimestamp(3, fVal3);
							pstmt5.setTimestamp(4, fVal4);
							noRows = pstmt5.executeUpdate();
							if(noRows != 1)
							{
								errCode = "DS000NR";
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}
						}
						nextBal = nextBal - updBal;
						if(nextBal == 0)
						{
							//break;
						}				
					}
					if((errCode != null) && errCode.trim().length() > 0)
					{
						isError = true;
						break;
					}
					else if(nextBal > 0)
					{
						//allowUpdateNegLeave =  (boolean) this.lveRuleList.get("allow_update_negative_leave");
						allowUpdateNegLeave =  (Boolean)this.lveRuleList.get("allow_update_negative_leave");
						//if istr_lve_rule_list.allow_update_negative_leave = true and museFlag = "C" then
						if(allowUpdateNegLeave == true && museFlag.equalsIgnoreCase("C"))
						{
							fVal3 = null;
							fVal4 = null;
							noRows = 0;
							sql = "SELECT MAX(EFF_DATE) AS EFF_DATE FROM LEAVEBAL WHERE EMP_CODE = ? AND LVE_CODE = ? AND EXP_DATE >= ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, mEmp);
							pstmt.setString(2,mLveCode);
							pstmt.setTimestamp(3, mDate1);
							resultSet = pstmt.executeQuery();
							while(resultSet.next())
							{
								fVal3 = resultSet.getTimestamp("EFF_DATE");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(fVal3 != null)
							{
								noRows = 0;
								sql = "SELECT EFF_DATE, UPTO_DATE FROM LEAVEBAL WHERE EMP_CODE = ? AND LVE_CODE = ? AND EFF_DATE = ? AND EXP_DATE >= ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, mEmp);
								pstmt.setString(2,mLveCode);
								pstmt.setTimestamp(3, fVal3);
								pstmt.setTimestamp(4, mDate1);									
								resultSet = pstmt.executeQuery();
								while(resultSet.next())
								{
									noRows++;
									fVal3 = resultSet.getTimestamp("EFF_DATE");
									fVal4 = resultSet.getTimestamp("UPTO_DATE");
								}
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								noRows = 0;
								sql = "UPDATE LEAVEBAL SET BAL_DAYS = BAL_DAYS - ?,CONS_DAYS  = CONS_DAYS + ? "+
										" WHERE EMP_CODE = ? AND LVE_CODE = ? AND EFF_DATE = ? AND UPTO_DATE = ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setDouble(1, nextBal);
								pstmt.setDouble(2,nextBal);
								pstmt.setString(3,mEmp);
								pstmt.setString(4,mLveCode);
								pstmt.setTimestamp(5,fVal3);
								pstmt.setTimestamp(6,fVal4);
								noRows = pstmt.executeUpdate();
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(noRows != 1)
								{
									errCode = "DS000NR";
									this.errList.add(errCode);
									this.fldList.add("");
									isError = true;
									break;
								}
								noRows = 0;
								mCnt = 0;
								sql = "SELECT COUNT(*) AS COUNT FROM EMPLVE_TRACE WHERE TRAN_ID = ? AND EFF_DATE = ? AND UPTO_DATE = ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, tranId);
								pstmt.setTimestamp(2, fVal3);
								pstmt.setTimestamp(3, fVal4);
								resultSet = pstmt.executeQuery();
								while(resultSet.next())
								{
									mCnt = resultSet.getInt("COUNT");
								}
								if(resultSet != null)
								{
									resultSet.close();
									resultSet = null;
								}
								if(pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}
								if(mCnt == 0)
								{
									noRows = 0;
									sql = "INSERT INTO EMPLVE_TRACE (TRAN_ID , EMP_CODE, LVE_DATE_FR, LVE_DATE_TO, LVE_CODE," 
											+" EFF_DATE, UPTO_DATE, LVES_ALLOC)VALUES (?,?,?,?,?,?,?,?) ";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, tranId);
									pstmt.setString(2, mEmp);
									pstmt.setTimestamp(3, mDate1);
									pstmt.setTimestamp(4, mDate2);
									pstmt.setString(5, mLveCode);
									pstmt.setTimestamp(6, fVal3);
									pstmt.setTimestamp(7, fVal4);
									pstmt.setDouble(8, nextBal);
									noRows = pstmt.executeUpdate();
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(noRows != 1)
									{
										errCode = "DS000NR";
										this.errList.add(errCode);
										this.fldList.add("");
										isError = true;
										break;
									}
								}
								else
								{
									noRows = 0;
									sql = "UPDATE EMPLVE_TRACE SET LVES_ALLOC = (CASE WHEN LVES_ALLOC IS NULL THEN 0 ELSE LVES_ALLOC END) + ?"
											+"WHERE TRAN_ID = ? AND EFF_DATE  = ?  AND UPTO_DATE = ?";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setDouble(1, nextBal);
									pstmt.setString(2, tranId);
									pstmt.setTimestamp(3, fVal3);
									pstmt.setTimestamp(4, fVal4);
									noRows = pstmt.executeUpdate();
									if(pstmt != null)
									{
										pstmt.close();
										pstmt = null;
									}
									if(noRows != 1)
									{
										errCode = "DS000NR";
										this.errList.add(errCode);
										this.fldList.add("");
										isError = true;
										break;
									}
								}
								if((cfDate == null) || (fVal3.before(cfDate)))
								{
									cfDate = fVal3; 
								}								
							}
							else
							{
								errCode = "VTEMPLVE4";
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}
						}
						else
						{
							errCode = "VTEMPLVE4";
							this.errList.add(errCode);
							this.fldList.add("");
							isError = true;
							break;
						}

					}
				}	
				mDate = mDate1;
				days = 0;
				do
				{
					noRows = 0;
					sql6 = "SELECT CODE, FR_DATE, TO_DATE FROM PERIOD WHERE FR_DATE <= ? AND TO_DATE >= ?";
					pstmt6 = connectionObject.prepareStatement(sql6);
					pstmt6.setTimestamp(1, mDate);
					pstmt6.setTimestamp(2, mDate);
					resultSet6 = pstmt6.executeQuery();
					while(resultSet6.next())
					{
						noRows++;
						period = resultSet6.getString("CODE");
						tempFrDt = resultSet6.getTimestamp("FR_DATE");
						tempToDt = resultSet6.getTimestamp("TO_DATE");
					}
					if(resultSet6 != null)
					{
						resultSet6.close();
						resultSet6 = null;
					}
					if(pstmt6 != null)
					{
						pstmt6.close();
						pstmt6 = null;
					}
					if(noRows == 0)
					{
						errCode = "VTPRD1";
						this.errList.add(errCode);
						this.fldList.add("");
						isError = true;
						break;
					}
					if(utilMethod.pos("ELVA",museFlag ) == 0)
					{
						if(tempToDt.after(mDate2))
						{
							tempToDt = mDate2;
						}
						noDays = utilMethod.DaysAfter(mDate,tempToDt )+ 1;
						if((mDate.equals(mDate1) ) && (lveStart.equals("M")))
						{
							noDays = noDays - 0.5;
						}
						days = days + noDays;
						if(days > mDays)
						{
							noDays = noDays - (days - mDays);
							if (noDays < 0)
							{
								noDays = 0;
							}
						}
					}
					else
					{
						mDate2 = mDate1;
						noDays = mDays;
					}
					noRows = 0;
					sql7 = "INSERT INTO EMPLEAVE_SUMMARY (TRAN_ID , EMP_CODE, LVE_DATE_FR, LVE_DATE_TO, LVE_CODE, NO_DAYS,PRD_CODE,USE_FLAG ) VALUES(?,?,?,?,?,?,?,?)";
					pstmt7 = connectionObject.prepareStatement(sql7);
					pstmt7.setString(1, tranId);
					pstmt7.setString(2, mEmp);
					pstmt7.setTimestamp(3, mDate1);
					pstmt7.setTimestamp(4, mDate2);
					pstmt7.setString(5,mLveCode);
					pstmt7.setDouble(6, noDays);
					pstmt7.setString(7, period);
					pstmt7.setString(8, museFlag);
					noRows = pstmt7.executeUpdate();
					if(noRows != 1)
					{
						errCode = "DS000NR";
						this.errList.add(errCode);
						this.fldList.add("");
						isError = true;
						break;
					}

					if (utilMethod.pos("ELVA" , museFlag) > 0)
					{
						break;
					}
					mDate = utilMethod.dateTime(utilMethod.RelativeDate(tempToDt,1));
				}
				while((mDate.before(mDate2)) ||(mDate.equals(mDate2)));
				if(errCode != null && errCode.trim().length() > 0)
				{
					break;
				}
				if(museFlag.equals("V"))
				{
					sql = "";
					sql = "SELECT LVE_CODE__CONVERT FROM LEAVES WHERE LVE_CODE = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1,mLveCode);
					resultSet = pstmt.executeQuery();
					while(resultSet.next())
					{
						newLve =  resultSet.getString("LVE_CODE__CONVERT");
					}
					if(resultSet != null)
					{
						resultSet.close();
						resultSet = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(balOpt.equals("Y"))
					{
						effDt1 = utilMethod.dateTime(utilMethod.RelativeDate(mDate1,1));
						effDt2 = utilMethod.dateTime(utilMethod.RelativeDate(effDt1,365));
					}
					else
					{
						long cnt = 0;
						java.sql.Timestamp today = null;
						today = utilMethod.dateTime(utilMethod.todaySqlDate(),utilMethod.stringToTime("00:00"));

						sql = "SELECT COUNT(1) AS COUNT FROM LEAVEBAL WHERE EMP_CODE = ?,AND LVE_CODE = ?,AND EFF_DATE <=  ?,AND UPTO_DATE >= ? ";
						pstmt = connectionObject.prepareStatement(sql);
						pstmt.setString( 1, mEmp);
						pstmt.setString(2, newLve);
						pstmt.setTimestamp(3, today);
						pstmt.setTimestamp(4, today);
						while (resultSet.next())
						{
							cnt = resultSet.getLong("COUNT");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if (cnt <= 0)
						{
							errCode = "VTLVCNV001";
							this.errList.add(errCode);
							this.fldList.add("");
							isError = true;
							break;
						}
						else
						{
							sql = "SELECT EFF_DATE,UPTO_DATE FROM LEAVEBAL WHERE EMP_CODE = ? AND LVE_CODE = ? AND EFF_DATE <= ? AND UPTO_DATE >= ?";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString( 1, mEmp);
							pstmt.setString(2, newLve);
							pstmt.setTimestamp(3, toDate);
							pstmt.setTimestamp(4, toDate);
							while (resultSet.next())
							{
								effDt1 = resultSet.getTimestamp("EFF_DATE");
								effDt2 = resultSet.getTimestamp("UPTO_DATE");
							}
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
					}
					noRows = 0;
					sql = "UPDATE LEAVEBAL SET BAL_DAYS   = BAL_DAYS + ? ,CONV_DAYS  = NVL(CONV_DAYS, 0 ) + ? WHERE EMP_CODE = ? AND LVE_CODE = ? AND EFF_DATE >= ?	AND EFF_DATE < ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setDouble( 1, mDays);
					pstmt.setDouble( 2, mDays);
					pstmt.setString(3, mEmp);
					pstmt.setString(4, newLve);
					pstmt.setTimestamp(3, effDt1);
					pstmt.setTimestamp(4, effDt2);
					noRows = pstmt.executeUpdate();
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(noRows != 1)
					{
						errCode = "DS000NR";
						this.errList.add(errCode);
						this.fldList.add("");;
						isError = true;
						break;
					}
				}
				if(saveFlag == 2)
				{

					noRows = 0;
					sql = "UPDATE EMPLEAVE SET STATUS = 'A', ENCH_AMT = ?,STATUS_DATE = ?,EMP_CODE__APRV = ?,TRAN_ID__PAYR = ?,APRV_DATE = ? WHERE TRAN_ID = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setDouble(1, mAmt);
					pstmt.setTimestamp(2, mDate3);
					pstmt.setString(3,this.loginEmpCode);
					pstmt.setString(4,null);
					pstmt.setTimestamp(5,chgTime);
					pstmt.setString(6, tranId);
					noRows = pstmt.executeUpdate();
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				else
				{
					noRows = 0;
					sql = "UPDATE EMPLEAVE SET STATUS = 'A' WHERE TRAN_ID = ?";
					pstmt = connectionObject.prepareStatement(sql);
					pstmt.setString(1, tranId);
					noRows = pstmt.executeUpdate();
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				if(noRows != 1)
				{
					errCode = "DS000NR";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				break;
			}while(true);//Main Do

			/******************To be done after migrating all component*****************/
			/*if(errCode == null || errCode.trim().length() == 0)
			{
				if(museFlag.equals("C"))
				{
					attdProc  = new AttdProcess();
					//gf_add_glob_args(ls_extra_arg);
					//nvo_attd_proc.gbf_set_globals(ls_extra_arg);
					//ls_errcode = nvo_attd_proc.gbf_auto_attdproc(memp , mdate1 , mdate2 , 1);
					if(errCode == null ||  utilMethod.pos(errCode, "<error") == 0)
					{
						errCode = "";
					}
				}
			}*/
			/*System.out.println("ERRCode:::-----["+errCode+"]");
			if(errCode == null || errCode.trim().length() == 0)
			{
				sql = "";
				noRows = 0;
				sql = "select edi_option from transetup where tran_window = 'w_empleave'";
				pstmt = connectionObject.prepareStatement(sql);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					ediOption = resultSet.getString("edi_option");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				System.out.println("edi option::["+ediOption+"]");
				if((Integer.parseInt(ediOption)) > 0)
				{
					StringBuffer xmlString = new StringBuffer();
					xmlString.dataobject = 'd_empleave_edit';
					xmlString.settransobject(sqlca);
					xmlString.retrieve(as_tranid)
					xmlString.append("<status>").append("A").append("<status>");
					xmlString.append("<aprv_date>").append(mDate3).append("<aprv_date>");
					xmlString.append("<emp_code__aprv>").append(loginEmpCode).append("<emp_code__aprv>");
					xmlString.append("<status>").append("A").append("<status>");
					if((Integer.parseInt(ediOption)) == 2)
					{
						System.out.println("Migration done on later...");
						nvo_functions_adv.post nf_create_edi_multi('w_empleave', &
								lds_leaveapprv.describe("datawindow.syntax") &
								+ '~r' + lds_leaveapprv.describe("datawindow.syntax.data"), &
								'E', ls_edi_option, 1, '', '', '', '', '', '')
					}
					else
					{
						System.out.println("Migration done on later...");
						s_errcode = nvo_functions_adv.nf_create_edi_multi('w_empleave', &
								 lds_leaveapprv.describe("datawindow.syntax") &
							 	 + '~r' + lds_leaveapprv.describe("datawindow.syntax.data"), &
							 	 'E', ls_edi_option, 1, '', '', '', '', '', '')
					}
				}
			}

			errList.add(errCode);
			fldList.add("");*/

			/******************To be done after migrating all component*****************/
			System.out.println("Is error:::::::["+isError+"]");

			if (isError)
			{
				System.out.println("If err is true");
				errCode = "ERROR";
				if (commit == 2)
				{
					connectionObject.rollback();
				}
			}
			else if (commit == 2)
			{
				connectionObject.commit();
				errCode = "";
			}
			/******************To be done after migrating all component*****************/
			/*noRows = 0;
			sql = "";
			sql = "select eff_date from leavebal where emp_code = ? and eff_date >  ? " +
					"and lve_code = ? order by eff_date";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, mEmp);
			pstmt.setTimestamp(2, cfDate);
			pstmt.setString(3, mLveCode);
			resultSet = pstmt.executeQuery();
			while(resultSet.next())
			{
				noRows++;
				effDate = resultSet.getTimestamp("eff_date");
			}
			if(resultSet != null)
			{
				resultSet.close();
				resultSet = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			System.out.println("No rows in edi option::::::::");
			if(noRows > 0)
				{
					count1 = utilMethod.upperBound(cfDateList);
					count1 = count1 + 1;
					cfDateList[count1] = effDate;
					System.out.println("effDate ::::"+effDate);

					if(cfDateList.length > 0)
					{
						//	BoLeaveOpenBalance leaveBal = new  BoLeaveOpenBalance();           
						StringBuffer leaveOpenBal = new StringBuffer();
						leaveOpenBal.dataobject = "d_lve_open_bal";
					leaveOpenBal.SetTransObject(sqlca);
					leaveOpenBal.reset();
					leaveOpenBal.insertrow(0);
						for(row = 1;row <= cfDateList.length;row++)
						{
							leaveOpenBal.append("<emp_code__fr>").append(empCode).append("</emp_code__fr>");
							leaveOpenBal.append("<emp_code__to>").append(empCode).append("</emp_code__to>");
							leaveOpenBal.append("<leave_type__fr>").append(lveCode).append("</leave_type__fr>");
							leaveOpenBal.append("<leave_type__to>").append(lveCode).append("</leave_type__to>");
							leaveOpenBal.append("<resign_emp>").append("N").append("</resign_emp>");
							leaveOpenBal.append("<proc_date>").append(cfDateList[(int) row]).append("</proc_date>");
							//errCode = leaveBal.process(leaveOpenBal.describe("datawindow.data"), "",extraArg);
							errCode = "";
						}
					}
				}*/

			/******************To be done after migrating all component*****************/
			/* to be done after migrating all components 

			// for attendance processing
			If isnull(ls_errcode) or len(trim(ls_errcode)) = 0 then 
				If museflag = 'C' then                // only for consume option
					nvo_attd_proc  = create nvo_business_object_attdproc

					//Commented n Added by Jasmina SY78SUN052-24.03.2008
					//nvo_attd_proc.is_extra_arg = is_extra_arg // Added by Subu 28.02.08
					gf_add_glob_args(ls_extra_arg)
					nvo_attd_proc.gbf_set_globals(ls_extra_arg)
					///End, Commented n Added by Jasmina SY78SUN052-24.03.2008

					ls_errcode = nvo_attd_proc.gbf_auto_attdproc(memp , mdate1 , mdate2 , 1)
					If isnull(ls_errcode) or pos(ls_errcode , "<error") = 0 then
						ls_errcode = ''
					End if
					destroy nvo_attd_proc
				End if
			End if
			// end for attendance processing
			// for EDI option 
			If isnull(ls_errcode) or len(trim(ls_errcode)) = 0 then 
			   select edi_option into :ls_edi_option 
					from transetup
					where tran_window = 'w_empleave';
				if get_sqlcode() <> 0 then
					ls_errcode = 'DS000' + string(sqlca.sqldbcode) + ' ~t ' + sqlca.sqlerrtext
					ls_errcode = gbf_err_location(ls_errcode)
				end if
				if ls_edi_option >'0' then
				nvo_datastore lds_leaveapprv
				lds_leaveapprv = CREATE nvo_datastore
					lds_leaveapprv.dataobject = 'd_empleave_edit'
					lds_leaveapprv.settransobject(sqlca)
					lds_leaveapprv.retrieve(as_tranid)
					lds_leaveapprv.setitem(lds_leaveapprv.getrow(),"status",'A')
					lds_leaveapprv.setitem(lds_leaveapprv.getrow(),"aprv_date",mdate3)
					lds_leaveapprv.setitem(lds_leaveapprv.getrow(),"emp_code__aprv",login_emp_code)
					if ls_edi_option='2' then
						nvo_functions_adv.post nf_create_edi_multi('w_empleave', &
						lds_leaveapprv.describe("datawindow.syntax") &
						+ '~r' + lds_leaveapprv.describe("datawindow.syntax.data"), &
						'E', ls_edi_option, 1, '', '', '', '', '', '')
					Else
						ls_errcode = nvo_functions_adv.nf_create_edi_multi('w_empleave', &
									 lds_leaveapprv.describe("datawindow.syntax") &
									 + '~r' + lds_leaveapprv.describe("datawindow.syntax.data"), &
									 'E', ls_edi_option, 1, '', '', '', '', '', '')
					End if
				End if						  
			End If
			// end edi 

			ls_errcode = gbf_insert_err( ls_errcode , '' )

			destroy nvo_aed_functions_adv
			 */
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(resultSet1 != null)
				{
					resultSet1.close();
					resultSet1 = null;
				}
				if(resultSet2 != null)
				{
					resultSet2.close();
					resultSet2 = null;
				}
				if(resultSet3 != null)
				{
					resultSet3.close();
					resultSet3 = null;
				}
				if(resultSet4 != null)
				{
					resultSet4.close();
					resultSet4 = null;
				}
				if(resultSet5 != null)
				{
					resultSet5.close();
					resultSet5 = null;
				}
				if(resultSet6 != null)
				{
					resultSet6.close();
					resultSet6 = null;
				}
				if(resultSet7 != null)
				{
					resultSet7.close();
					resultSet7 = null;
				}

				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if(pstmt2 != null)
				{
					pstmt2.close();
					pstmt2 = null;
				}
				if(pstmt3 != null)
				{
					pstmt3.close();
					pstmt3 = null;
				}
				if(pstmt4 != null)
				{
					pstmt4.close();
					pstmt4 = null;
				}
				if(pstmt5 != null)
				{
					pstmt5.close();
					pstmt5 = null;
				}
				if(pstmt6 != null)
				{
					pstmt6.close();
					pstmt6 = null;
				}
				if(pstmt7 != null)
				{
					pstmt7.close();
					pstmt7 = null;
				}

			}
			catch (Exception fe)
			{
				fe.printStackTrace();
			}

		}

		return errCode;
	}

	private String checkEffectiveBalRecord(String tranId,String empCode,String lveCode,java.sql.Timestamp lveFromDate,java.sql.Timestamp lveToDate, Connection connectionObject) throws RemoteException,ITMException
	{

		String errCode = "",workSite = "",cadre = "",grade = "",autogenFlag = "N";
		String parName1 = "",parName2 = "",parName3 = "",parName4 = "",parName5 = "",parName6 = "",parName7 = "";
		String lveFrMth = "",lveToMth = "",lveTblNo = "";
		String availOn = "",earnNew = "",accumulate = "",confirmed = "",probation = "";
		String process = "N",encashable = "N",acctPrd = "";

		int accumulateMonths = 0;
		int cnt = 0,lveMon = 0,frYr = 0,toYr = 0;

		double availAterMonths = 0.00;
		java.sql.Timestamp dateJoin = null,dateRelieve = null,lveFrDt1 = null,lveToDt1 = null,expDate = null,availFrom = null;
		java.sql.Timestamp dateConf = null,probationDate = null,newEffDate = null,effDate = null;
		java.sql.Date lveFrDate1 = null,lveToDate1 = null ;

		parName2 = lveCode.trim() + "_LVE_YEAR_FRMTH";
		parName3 = lveCode.trim()  + "_LVE_YEAR_TOMTH";
		parName4 = "LVE_YEAR_FRMTH";
		parName5 = "LVE_YEAR_TOMTH";
		parName6 = "AUTO_GEN_LVBAL_" + lveCode.trim();
		parName7 = "AUTO_GEN_LVBAL";

		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet resultSet = null;
		int noRows = 0;

		boolean isError = false;
		try
		{
			do
			{
				cnt = 0;
				sql = "SELECT COUNT(1) AS COUNT FROM LEAVEBAL WHERE EMP_CODE = ? AND LVE_CODE = ? AND EXP_DATE >= ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,empCode );
				pstmt.setString(2, lveCode);
				pstmt.setTimestamp(3, lveToDate);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					cnt = resultSet.getInt("COUNT");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(cnt > 0)
				{
					break;
				}

				cnt = 0;
				sql = " SELECT DATE_JOIN, DATE_CONF, CONFIRMED, PROBATION_DATE, PROBATION, RELIEVE_DATE, WORK_SITE, CADRE, GRADE FROM EMPLOYEE WHERE EMP_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,empCode );
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					dateJoin = resultSet.getTimestamp("DATE_JOIN");
					dateConf = resultSet.getTimestamp("DATE_CONF");
					confirmed = resultSet.getString("CONFIRMED");
					probationDate = resultSet.getTimestamp("PROBATION_DATE");
					probation = resultSet.getString("PROBATION");
					dateRelieve = resultSet.getTimestamp("RELIEVE_DATE");
					workSite = resultSet.getString("WORK_SITE");
					cadre = resultSet.getString("CADRE");
					grade = resultSet.getString("GRADE");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (utilMethod.date(dateJoin).after(utilMethod.date(lveFromDate)))
				{
					errCode = "VTLVBALNRC";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				if (dateRelieve != null && utilMethod.date(dateRelieve).before(utilMethod.date(lveToDate)))
				{
					errCode = "VTLVBALNRC";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}

				autogenFlag = admCommon.getAdmEnv(workSite,cadre, grade,parName6, lveFromDate,connectionObject);
				if(autogenFlag == null || autogenFlag.trim().length() == 0 || autogenFlag.equals("ERR~t<NULLFOUND>") || autogenFlag.indexOf("NULLFOUND") > 0 )
				{
					autogenFlag = admCommon.getEnv("999999", parName6,connectionObject);
					if(autogenFlag.equals("NULLFOUND"))
					{
						autogenFlag = admCommon.getAdmEnv(workSite,cadre,grade,parName7, lveFromDate,connectionObject);
						if(autogenFlag == null || autogenFlag.trim().length() == 0 || autogenFlag.equals("ERR~t<NULLFOUND>") || autogenFlag.indexOf("NULLFOUND") > 0 )
						{
							autogenFlag = admCommon.getEnv("999999", parName7,connectionObject);
							if(autogenFlag.equals("NULLFOUND"))
							{
								autogenFlag = "N";
							}
						}
					}
				}
				if(autogenFlag == null || !(autogenFlag.trim().toUpperCase().equals("Y")))
				{
					errCode = "VTLVBALNRC";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}

				HashMap hmap = getLvetbl(workSite,grade,cadre,lveTblNo, connectionObject);
				System.out.println("from get lve tble:::["+hmap+"]");
				errCode = (String)hmap.get("ERRORCODE");
				if (errCode != null && errCode.trim().length() > 0)
				{
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				lveTblNo = (String)hmap.get("LEAVETABLE");

				sql = "SELECT AVAIL, AVAIL_LT, EARN_NEW, ACCUMULATE, ACCUMULATE_MONTHS FROM LVETABLE WHERE LVE_TBLNO = ? AND LVE_CODE = ? ";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,lveTblNo);
				pstmt.setString(2,lveCode);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					availOn = resultSet.getString("AVAIL");
					availAterMonths = resultSet.getDouble("AVAIL_LT");
					earnNew = resultSet.getString("EARN_NEW");
					accumulate = resultSet.getString("ACCUMULATE");
					accumulateMonths = resultSet.getInt("ACCUMULATE_MONTHS");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				lveFrMth = admCommon.getAdmEnv(workSite,cadre,grade,parName2, lveFromDate,connectionObject);
				if(lveFrMth == null || lveFrMth.trim().length() == 0 || lveFrMth.equals("ERR~t<NULLFOUND>") || lveFrMth.indexOf("NULLFOUND") > 0 )
				{
					lveFrMth = admCommon.getEnv("999999", parName2,connectionObject);
					if(lveFrMth.equals("NULLFOUND"))
					{
						lveFrMth = admCommon.getAdmEnv(workSite,cadre,grade,parName4,lveFromDate,connectionObject);
						if(lveFrMth == null || lveFrMth.trim().length() == 0 || lveFrMth.equals("ERR~t<NULLFOUND>") || lveFrMth.indexOf("NULLFOUND") > 0 )
						{
							lveFrMth =admCommon.getEnv("999999", parName4, connectionObject);
							if(lveFrMth.equals("NULLFOUND"))
							{
								errCode = "VSENVAR1~tVariable Name = "+ parName2 + parName4;
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}
						}
					}
				}

				lveToMth = admCommon.getAdmEnv(workSite,cadre,grade,parName3, lveFromDate,connectionObject);
				if(lveToMth == null || lveToMth.trim().length() == 0 || lveToMth.equals("ERR~t<NULLFOUND>") || lveToMth.indexOf("NULLFOUND") > 0 )
				{
					lveToMth = admCommon.getEnv("999999", parName3,connectionObject);
					if(lveToMth.equals("NULLFOUND"))
					{
						lveToMth = admCommon.getAdmEnv(workSite,cadre,grade,parName5,lveFromDate,connectionObject);
						if(lveToMth == null || lveToMth.trim().length() == 0 || lveToMth.equals("ERR~t<NULLFOUND>") || lveToMth.indexOf("NULLFOUND") > 0 )
						{
							lveToMth =admCommon.getEnv("999999", parName5, connectionObject);
							if(lveToMth.equals("NULLFOUND"))
							{
								errCode = "VSENVAR1~tVariable Name = "+ parName3 + parName5;
								this.errList.add(errCode);
								this.fldList.add("");
								isError = true;
								break;
							}
						}
					}
				}

				frYr = utilMethod.year(lveFromDate);//year(date(adt_lve_from_date))
				toYr = utilMethod.year(lveFromDate);//year(date(adt_lve_from_date))

				int tempInt = 0;
				try
				{
					tempInt = Integer.parseInt(lveFrMth);
				}
				catch (Exception pi1)
				{
					pi1.printStackTrace();
					errCode = "VSENVAR1~tVariable Name = "+ parName2 + parName4;
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				if(tempInt != 1)//if integer(ls_lvefrmth) <> 1 then
				{
					if(lveMon < tempInt)//if li_lvemon < integer(ls_lvefrmth)
					{
						toYr = frYr;
						frYr = frYr - 1;
					}
					else
					{
						toYr = frYr + 1;
					}
					lveFrDate1 = utilMethod.date(frYr, tempInt, 1);

					tempInt = 0;
					try
					{
						tempInt = Integer.parseInt(lveToMth);
					}
					catch (Exception pi1)
					{
						pi1.printStackTrace();
						errCode = "VSENVAR1~tVariable Name = "+ parName2 + parName4;
						this.errList.add(errCode);
						this.fldList.add("");
						isError = true;
						break;
					}

					if (tempInt < 12)
					{
						lveToDate1 = utilMethod.date(toYr ,tempInt + 1 , 1);
					}
					else
					{
						lveToDate1 = utilMethod.date(toYr + 1 , 1 , 1);
					}

					lveToDate1 = (java.sql.Date) utilMethod.RelativeDate(lveToDate1 , -1);
				}
				else
				{
					lveFrDate1 = utilMethod.date(frYr, 1, 1);
					lveToDate1 = utilMethod.date(toYr, 12, 31);
				}


				if(availOn.equals("C"))
				{
					availFrom = dateConf;
					process = confirmed;
				}
				if(availOn.equals("P"))
				{
					availFrom = probationDate;
					process = probation;
				}

				if(availOn.equals("J"))
				{
					availFrom = dateJoin;
					process = "Y";
				}

				else
				{
					availFrom = dateJoin;
					process = "Y";
				}
				if (availAterMonths == 0)
				{
					availAterMonths = 0;
				}
				newEffDate = utilMethod.AddMonths(availFrom, (int) availAterMonths);
				if(utilMethod.date(newEffDate).after(lveToDate1))
				{
					sql = "SELECT ADD_MONTHS(? , 12) - 1 AS NEW_DATE FROM DUAL ";
					pstmt = connectionObject.prepareStatement(sql);
					do
					{
						lveFrDate1 = (java.sql.Date) utilMethod.RelativeDate(lveToDate1 , 1);
						pstmt.clearParameters();
						pstmt.setTimestamp(1, utilMethod.dateTime(lveFrDate1));
						resultSet = pstmt.executeQuery();
						while(resultSet.next())
						{
							lveToDate1 = resultSet.getDate("NEW_DATE");
						}
						if(resultSet != null)
						{
							resultSet.close();
							resultSet = null;
						}
						pstmt.clearParameters();
					}
					while (newEffDate.after(lveToDate1));
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

				}

				lveFrDt1 = utilMethod.dateTime(lveFrDate1);
				lveToDt1 = utilMethod.dateTime(lveToDate1);

				if(accumulate.equals("Y"))
				{
					if (accumulateMonths > 0)
					{
						expDate = utilMethod.AddMonths(lveToDt1,accumulateMonths);
					}
					else
					{
						expDate = lveToDt1;
					}
				}


				if(lveFrDate1.before(newEffDate))
				{
					effDate = newEffDate;
				}
				else
				{
					effDate = lveFrDt1;
				}

				if((utilMethod.year(lveFrDate1)) == (utilMethod.year(lveToDate1)))
				{
					acctPrd = String.valueOf(utilMethod.year(lveFrDate1));
				}
				else
				{
					acctPrd = String.valueOf(utilMethod.year(lveFrDate1)).trim() + utilMethod.mid(String.valueOf(utilMethod.year(lveToDate1)).trim(),3);
				}
				noRows = 0 ; 
				sql = "SELECT ENCASHABLE FROM LEAVES WHERE LVE_CODE = ?";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1, lveCode);
				resultSet = pstmt.executeQuery();
				while(resultSet.next())
				{
					noRows++;
					encashable = resultSet.getString("ENCASHABLE");
				}
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}	
				if(noRows == 0)
				{
					errCode = "DS0001";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				noRows = 0;
				sql = "INSERT INTO LEAVEBAL"+
						"(EMP_CODE,LVE_CODE,EFF_DATE,UPTO_DATE,EXP_DATE,EDIT_FLAG,AVAIL_DAYS,	CONS_DAYS,"+
						"ENCH_DAYS,BAL_DAYS,PREV_BAL,ENCASHABLE,ACCT_PRD,CHG_DATE,CHG_USER,CHG_TERM,CONV_DAYS)"+
						"VALUES(?,?,?,?,?,'A',0,0,0,0,0,?,?,SYSDATE,?,?,0)";
				pstmt = connectionObject.prepareStatement(sql);
				pstmt.setString(1,empCode);
				pstmt.setString(2,lveCode);
				pstmt.setTimestamp(3,effDate);
				pstmt.setTimestamp(4,lveToDt1);
				pstmt.setTimestamp(5,expDate);
				pstmt.setString(6,encashable);
				pstmt.setString(7,acctPrd);
				pstmt.setString(8,this.userId);
				pstmt.setString(9, this.termId);
				noRows = pstmt.executeUpdate();
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(noRows == 0)
				{
					errCode = "DS0001";
					this.errList.add(errCode);
					this.fldList.add("");
					isError = true;
					break;
				}
				break;
			}
			while(true);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(resultSet != null)
				{
					resultSet.close();
					resultSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception fe)
			{
				fe.printStackTrace();
			}
		}
		if (!isError)
		{
			errCode = "";
		}
		else
		{
			errCode = "ERROR";
		}
		return errCode;
	}

	private String getErrorType(String errorCode , Connection conn) throws RemoteException, ITMException
	{
		String errorType = "";
		String sqlStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sqlStr = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sqlStr);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				errorType = rs.getString("MSG_TYPE");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(errorType == null || errorType.trim().length() == 0)
			{
				errorType = "E";
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
			}
		}
		return errorType;
	}

	private String getXMLFromDBForEdit(String objName, String pageContext, int noOfForms, String qryParam, String qryParamType, String refSer, String userInfoStr )throws ITMException
	{
		Document mainDom = null;
		DB2XMLGenerator db2xmlgen = null;
		E12GenericUtility genericUtility =new E12GenericUtility();
		try
		{
			String objContext = "1";
			db2xmlgen = new DB2XMLGenerator(objName);
			StringBuffer xmlStringBuff = new StringBuffer();
			String mainDomFileName = db2xmlgen.createXML(objName, objContext, pageContext, qryParam, qryParamType, "", userInfoStr );
			String fileContent = readFile(mainDomFileName);

			mainDom = genericUtility.parseString(fileContent);
			System.out.println("@@@@@@@@@@@@@MainDom cretaed ......");
			NodeList detailList1 = mainDom.getElementsByTagName("Detail1");
			int noOfHeaderRecords = detailList1.getLength();
			detailList1 = null;
			if(noOfHeaderRecords == 1)
			{
				System.out.println("@@@@@@@@@@@@@noOfForms :["+noOfForms+"]");
				for(int ctr = 2; ctr <= noOfForms; ctr++)
				{
					objContext = String.valueOf(ctr);
					String level2DetailFileName = db2xmlgen.createXML(objName, objContext, "2", qryParam, qryParamType, null, userInfoStr );
					String level2DetailStr = readFile( level2DetailFileName );
					Document level2DetailDom = genericUtility.parseString(level2DetailStr);
					System.out.println("@@@@@@@DetailDom Created for context :"+ctr);

					NodeList level2DetailDomList = level2DetailDom.getElementsByTagName("Detail"+objContext);
					int noOfLevel2Details = level2DetailDomList.getLength();
					System.out.println("@@@@@@@NoOfRecords for context ["+ctr+"] :"+noOfLevel2Details);
					for (int j = 0; j < noOfLevel2Details; j++)
					{
						Node level2DetailNode = level2DetailDomList.item(j);
						appendToDomForEdit(mainDom.getElementsByTagName("Header0").item(0), level2DetailNode, objContext);
						System.out.println("@@@@@@@Appended : to MainDom ");
					}
				}
			}
			else
			{
				throw new Exception( "Invalid Number of Records Fetched for Header ["+noOfHeaderRecords+"]" );
			}
			db2xmlgen = null;
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException : TrvExpenseConf: getXMLFromDBForEdit : Generic Exception==>\n");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("TrvExpenseConf: getXMLFromDBForEdit: Generic Exception==>\n"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				db2xmlgen = null;
			} 
			catch (Exception e)
			{
				System.out.println("TrvExpenseConf: getXMLFromDBForEdit: Generic Exception==>\n"+e);
				e.printStackTrace();
				throw new ITMException(e);
			}						
		}
		return genericUtility.serializeDom(mainDom);
	}

	private String getUserInfo( String xtraParams )throws ITMException
	{
		StringBuffer userInfoStr = new StringBuffer();
		String userId = "";
		String loginEmpCode = "";
		String loginSiteCode = "";
		String entityCode = "";
		String profileId = "";
		String userType = "";
		String charEnc = "";
		String chgTerm = "";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			this.userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			this.loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			profileId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"profileId");
			userType = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userType");
			charEnc = CommonConstants.ENCODING;
			System.out.println("charEnc......"+charEnc);
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");

			userInfoStr.append("<UserInfo>");
			userInfoStr.append("<loginCode>").append("<![CDATA["+this.userId+"]]>").append("</loginCode>\r\n");
			userInfoStr.append("<empCode>").append("<![CDATA["+this.loginEmpCode+"]]>").append("</empCode>\r\n");
			userInfoStr.append("<siteCode>").append("<![CDATA["+loginSiteCode+"]]>").append("</siteCode>\r\n");
			userInfoStr.append("<entityCode>").append("<![CDATA["+entityCode+"]]>").append("</entityCode>\r\n");
			userInfoStr.append("<profileId>").append("<![CDATA["+profileId+"]]>").append("</profileId>\r\n");
			userInfoStr.append("<userType>").append("<![CDATA["+userType+"]]>").append("</userType>\r\n");
			userInfoStr.append("<charEnc>").append("<![CDATA["+charEnc+"]]>").append("</charEnc>\r\n");
			userInfoStr.append("<remoteHost>").append("<![CDATA["+chgTerm+"]]>").append("</remoteHost>\r\n");
			userInfoStr.append("</UserInfo>");
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return userInfoStr.toString();
	}

	private void appendToDomForEdit(Node parentNode, Node childNode, String childObjContext)throws ITMException,Exception
	{
		parentNode.appendChild( parentNode.getOwnerDocument().importNode( childNode, true ) );
	}

	private String readFile(String fileName) throws Exception
	{

		StringBuffer fileContent = new StringBuffer();
		BufferedReader bfr = null;
		try
		{
			System.out.println(" ------------------------------------- fileName :["+fileName+"]");
			FileInputStream fMainIn = new FileInputStream(CommonConstants.JBOSSHOME + File.separator + "xmldatafiles" + File.separator + fileName);
			bfr = new BufferedReader(new InputStreamReader(fMainIn));
			String outTempStr = null;
			while((outTempStr = bfr.readLine()) != null)
			{
				fileContent.append(outTempStr);
			}

		}
		catch( Exception e )
		{
			throw e;
		}
		finally
		{
			try
			{
				if( bfr != null )
				{
					bfr.close();
					bfr = null;
				}
			}
			catch ( Exception e )
			{
				System.out.println( "Exception in releasing file resource :[" + fileName + "]" );
				e.printStackTrace();
			}
		}
		return fileContent.toString();
	}


}
