

/********************************************************
	Title     : TrackReqMaster.java
	Date      : 18-Feb-2014
	Developer : Santosh Divekar
	Purpose   : Define the the tracking req with multiple activities.
********************************************************/

package ibase.webitm.ejb.sys;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
@Stateless  
public class TrackReqMaster extends ValidatorEJB implements TrackReqMasterLocal,TrackReqMasterRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	Hashtable<String, String> trackBasisValueMap = new Hashtable<String, String>();
	ArrayList<String> duplicateRecordAdd = new ArrayList<String>();
	
	
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		
		try
		{
			
			if (xmlString != null && xmlString.trim().length() > 0 )
			{
				dom = parseString(xmlString);
				System.out.println("In wfValData Current xmlString="+xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0 )
			{
				dom1 = parseString(xmlString1);
				System.out.println("In wfValData Header xmlString1="+xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
				System.out.println("In wfValData All xmlString2="+xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}
	public String wfValData(Document curDom, Document hdrDom, Document allDom, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
	 	String userId = "";
		String errorType = "";
		String childNodeName = null;
		String errCode = "";
		String errString = "";
		String refSer = "";
		String trackReq = "";
		String trackSet = "";
		String trackBasisValue = "";
		
		int currentFormNo = 0;
		int childNodeListLength;
		int childNodeListLengthLocal;
		int childNodeLength;
		int ctr=0;
		int count = 0;
		
		NodeList parentNodeList = null;
		NodeList parentNodeListLocal = null;
		NodeList parentNodeListCheck = null;
		NodeList childNodeList = null;	
		NodeList childNodeListLocal = null;	
		Node parentNode = null;
		Node parentNodeLocal = null;
		Node childNode = null;
		Node childNodeLocal = null;
		String updateFlag="";
		boolean flag = false;
		
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		
		ArrayList<String> refSerMap=new ArrayList<String>();
		
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
	
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		
		try
		{
			
			SimpleDateFormat sdf =  new SimpleDateFormat(genericUtility.getApplDateFormat());
			conn = connDriver.getConnectDB("DriverITM");
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			//duplicateRecordAdd.clear();
			System.out.println("Current Form No. :- "+currentFormNo);
				
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = curDom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
			
			
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("ref_ser") && editFlag.equalsIgnoreCase("A") )     // Validation for ref ser code
					{
						refSer = checkNull(genericUtility.getColumnValue("ref_ser", curDom));
						refSer = refSer.trim();
						if(refSer == null || refSer.trim().length() == 0)
						{
							errCode = "VTBLKREFSR";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							flag = isRecordExist(conn," REFSER "," WHERE REF_SER='"+refSer+"' ");
							if(flag == false)
							{
								errCode = "VTINVREFSR";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							
							flag = isRecordExist(conn," obj_track_req "," WHERE REF_SER='"+refSer+"' ");
							if(flag == true)
							{
								errCode = "VTEXTREFSR";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							
							// CHECK VALIDATION FOR REF_SER FROM BOTH HEADER AND DETAIL SCREEN ARE SAME
							
							if (allDom != null )
							{
								parentNodeListCheck = allDom.getElementsByTagName("Detail2");
								childNodeLength = parentNodeListCheck.getLength();
							    String tempRefSer = "";
							    refSerMap.clear();
								for (int selectedRow = 0; selectedRow < childNodeLength; selectedRow++)
								{
									parentNode = parentNodeListCheck.item(selectedRow);
									childNodeList = parentNode.getChildNodes();
									childNodeListLength = childNodeList.getLength();
									updateFlag = getAttribValue(parentNode,"attribute", "updateFlag"); 
									if(!updateFlag.equalsIgnoreCase("D"))
									{
										for (int childRow = 0; childRow < childNodeListLength; childRow++)
										{
											childNode = childNodeList.item(childRow);
											String childNodeNameLocal = childNode.getNodeName();
											if(childNode.getFirstChild()!=null)
											{
												if (childNodeNameLocal.equals("ref_ser")) 
												{
													tempRefSer = childNode.getFirstChild().getNodeValue();
												}
											}
										}
										System.out.println("BEFORE MAP RefSer : "+refSerMap);
										if (refSerMap.contains(tempRefSer.trim()))
										{
										}
										else
										{
											refSerMap.add(tempRefSer.trim());	
											System.out.println("AFTER ADD : "+refSerMap);
										}
									}
								}
							}
							
							if(editFlag!=null && editFlag.equalsIgnoreCase("A"))
							{
								for (int i = 0; i < refSerMap.size(); i++) 
								{
									if(refSerMap.get(i).equalsIgnoreCase(refSer))
									{
									}
									else
									{
										// Reference Series on header and detail screen are not same,
										errCode = "VTINVREFD2";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
										break;
									}
								}
							}
						}
					}   
					else if(childNodeName.equalsIgnoreCase("track_req")  && editFlag.equalsIgnoreCase("A")) // Validation for Track Req Short Description 
					{
						trackReq = checkNull(genericUtility.getColumnValue("track_req", curDom)) ;
						trackReq = trackReq.trim();
						if(trackReq == null || trackReq.trim().length() == 0)
						{
							errCode = "VTBLKTRREQ";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							refSer = checkNull(genericUtility.getColumnValue("ref_ser", curDom));
							
							flag = isRecordExist(conn," obj_track_req "," where ref_ser='"+refSer+"' and track_req='"+trackReq+"'");
							if(flag == true)
							{
								errCode = "VTEXTREFTR";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					} 
					else if(childNodeName.equalsIgnoreCase("track_basis_col_1")) // Validation for Tracking Criteria 
					{
						String trackBasis1 =  checkNull(genericUtility.getColumnValue("track_basis_col_1", curDom));
						trackBasis1 = trackBasis1.trim();
						
						if(trackBasis1 == null || trackBasis1.trim().length() == 0)
						{
							errCode = "VTBLKTRBC1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						
					}
					else if(childNodeName.equalsIgnoreCase("track_basis_col_2")) // Validation for Tracking Criteria 
					{
						
					} 
					else if(childNodeName.equalsIgnoreCase("track_basis_col_3")) // Validation for Tracking Criteria 
					{
						
					} 
					else if(childNodeName.equalsIgnoreCase("track_basis_col_4")) // Validation for Tracking Criteria 
					{
						
					} 
					else if(childNodeName.equalsIgnoreCase("track_basis_col_5")) // Validation for Tracking Criteria 
					{
						
					} 
					else if(childNodeName.equalsIgnoreCase("track_basis_col_6")) // Validation for Tracking Criteria  
					{
						
					} 
					else if(childNodeName.equalsIgnoreCase("context_col_1")) // Validation for Tracking Criteria  
					{
						String contextCol1 =  checkNull(genericUtility.getColumnValue("context_col_1", curDom));
						contextCol1 = contextCol1.trim();
						
						if(contextCol1 == null || contextCol1.trim().length() == 0)
						{
							errCode = "VTBLKCONC1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					} 
					
				}
				 break;
			
			case 2 :
				parentNodeList = curDom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("editFlag : "+editFlag);
					if(childNodeName.equalsIgnoreCase("track_basis_value")  )     // Validation for track_basis_value
					{
						trackBasisValue = checkNull(genericUtility.getColumnValue("track_basis_value", curDom)) ;
						trackBasisValue = trackBasisValue.trim();
						
						if(trackBasisValue == null || trackBasisValue.trim().length() == 0)
						{
							errCode = "VTBLKTBVAL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							trackReq = checkNull(genericUtility.getColumnValue("track_req", curDom)) ;
							trackReq = trackReq.trim();
							refSer = checkNull(genericUtility.getColumnValue("ref_ser", curDom)) ;
							refSer = refSer.trim();
							
							parentNodeListLocal = allDom.getElementsByTagName("Detail2");
							int parentNodeListLengthLocal = parentNodeListLocal.getLength();
							System.out.println("parentNodeListLength +++++++++++++++++++"+ parentNodeListLengthLocal);
							System.out.println("Edit flag +++++++++++++++++++"+editFlag);
							duplicateRecordAdd.clear();
							
							for (int selectedRow = 0; selectedRow < parentNodeListLengthLocal; selectedRow++)
							{				
								String refSerLocal="",trackReqLocal="",trackBasisValueLocal="";
								parentNodeLocal = parentNodeListLocal.item(selectedRow);
								childNodeListLocal = parentNodeLocal.getChildNodes();
								childNodeListLengthLocal = childNodeListLocal.getLength();
								updateFlag = getAttribValue(parentNodeLocal,"attribute", "updateFlag");
								System.out.println("childNodeListLength -- "+ childNodeListLengthLocal+" updateFlag-"+updateFlag);	
									if(!updateFlag.equalsIgnoreCase("D"))
									{
										for (int childRow = 0; childRow < childNodeListLengthLocal; childRow++)
										{
											childNodeLocal = childNodeListLocal.item(childRow);
											String childNodeNameLocal = childNodeLocal.getNodeName();
											System.out.println("childNodeNameLocal-+++++++++++++++++++"+ childNodeNameLocal+"--"+selectedRow);
											if(childNodeLocal.getFirstChild()!=null)
											{
												if(childNodeNameLocal.equalsIgnoreCase("ref_ser"))
												{
													 refSerLocal = childNodeLocal.getFirstChild().getNodeValue();
												}
												else if(childNodeNameLocal.equalsIgnoreCase("track_req"))
												{
													 trackReqLocal = childNodeLocal.getFirstChild().getNodeValue();
												}
												else if(childNodeNameLocal.equalsIgnoreCase("track_basis_value"))
												{
													 trackBasisValueLocal = childNodeLocal.getFirstChild().getNodeValue();
												}
											}
										}
									
										System.out.println("duplicateRecordAdd : "+duplicateRecordAdd);
										if(duplicateRecordAdd.contains(refSerLocal+":"+trackReqLocal+":"+trackBasisValueLocal))
										{
											errCode = "VTEXTRTRBC";
											errList.add(errCode);
											errFields.add(childNodeName.toLowerCase());
										}
										else
										{
											duplicateRecordAdd.add(refSerLocal+":"+trackReqLocal+":"+trackBasisValueLocal);
											System.out.println("After Add duplicateRecordAdd : "+duplicateRecordAdd);
										}
									}
							}
							//duplicateRecordAdd.clear();
							if(editFlag!=null && !editFlag.equalsIgnoreCase("E"))
							{
								flag = isRecordExist(conn," obj_track_req_det "," where ref_ser='"+refSer+"' and track_req='"+trackReq+"' and track_basis_value = '"+trackBasisValue+"'");
								if(flag == true)
								{
									errCode = "VTEXTRTRBC";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
					} 
					else if(childNodeName.equalsIgnoreCase("track_set") )     // Validation for seq_no
					{
						trackSet = checkNull(genericUtility.getColumnValue("track_set", curDom));
						trackSet = trackSet.trim();
						if(trackSet == null || trackSet.trim().length() == 0)
						{
							errCode = "VTBLKTRSET";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							flag = isRecordExist(conn," TRAN_TRACK_SET "," WHERE TRACK_SET='"+trackSet.trim()+"' ");
							if(flag == false)
							{
								errCode = "VTINVTRSET";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}   
				}
			break;
			}
			int errListSize = errList.size();
			count = 0;
			String errFldName = null;
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
			if(errList != null && errListSize > 0)
			{
				for(count = 0; count < errListSize; count++)
				{
					errCode = errList.get(count);
					errFldName = errFields.get(count);
					System.out.println("errCode .........." + errCode);
				//	errString = getErrorString(errFldName, errCode, userId);
					errString = itmDBAccessEJB.getErrorString(errFldName, errCode, userId);
					System.out.println("errString........"+errString);
					
					errString = itmDBAccessEJB.getErrorString("", errCode, userId);
					System.out.println("errString........"+errString);
					
					errorType = errorType(conn , errCode);
					return errString;
					
				}
				errList.clear();
				errList = null;
				errFields.clear();
				
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}//end try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2,String xmlString3, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		Document dom3=null;
		
	    	
		String valueXmlString = "";
		try
		{   
			if(xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom1 = parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length() > 0)
			{
				dom2 = parseString(xmlString2);
			}
			if(xmlString3 != null && xmlString3.trim().length() > 0)
			{
				dom3 = parseString(xmlString3);
			}
			System.out.println("xmlString1="+xmlString);
			System.out.println("xmlString2="+xmlString1);
			System.out.println("xmlString3="+xmlString2);
			System.out.println("xmlString4="+xmlString3);
			valueXmlString = itemChanged(dom, dom1, dom2,dom3, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [TrackSetMaster][itemChanged( String, String,... )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, Document dom3, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String childNodeName = null;
		String sql = "";
		String trackSet = "";
		String trackSetDescr = "";
		String refSer="";
		String refSerDescr="";
		
		StringBuffer valueXmlString = new StringBuffer();
		int ctr = 0;
		int currentFormNo = 0;
		int childNodeListLength = 0;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		try
		{   
			SimpleDateFormat sdf =  new SimpleDateFormat(genericUtility.getApplDateFormat());
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
	
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch(currentFormNo)
			{
			case 1 : 
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
			//	System.out.println("currentColumn = "+currentColumn);
			
				if(currentColumn.trim().equalsIgnoreCase("ref_ser"))  //Item change for ref_ser and show description
				{
					refSer = checkNull(genericUtility.getColumnValue("ref_ser", dom));
					 if(refSer != null && refSer.trim().length() > 0)
					 {
						 sql="SELECT DESCR  FROM   REFSER WHERE REF_SER= ?";
						 pstmt =  conn.prepareStatement(sql);
						 pstmt.setString(1,refSer.trim());
						 rs = pstmt.executeQuery();
						 	if(rs.next())
							{
						 		refSerDescr = rs.getString(1);
							}
						 	valueXmlString.append("<refser_descr>").append("<![CDATA[" + refSerDescr +"]]>").append("</refser_descr>\r\n");
					 }	  
					 else
					 {
						 valueXmlString.append("<refser_descr>").append("<![CDATA[" + "" +"]]>").append("</refser_descr>\r\n");
					 }
					 
				}
			
				valueXmlString.append("</Detail1>");
				break;    
				
			case 2 :
				
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail2>");
				childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));

				System.out.println("currentColumn="+currentColumn);
					
				if ((currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))) 
					{
					
					}
				else if(currentColumn.trim().equalsIgnoreCase("track_set"))  //Item change for track_set  
					{	
					
					 trackSet = checkNull(genericUtility.getColumnValue("track_set", dom));
					 if(trackSet != null && trackSet.trim().length() > 0)
					 {
						 sql="SELECT DESCR  FROM   TRAN_TRACK_SET WHERE TRACK_SET= ?";
						 pstmt =  conn.prepareStatement(sql);
						 pstmt.setString(1,trackSet.trim());
						 rs = pstmt.executeQuery();
						 	if(rs.next())
							{
						 		trackSetDescr = rs.getString(1);
							}
						 	valueXmlString.append("<tran_track_set_descr>").append("<![CDATA[" + trackSetDescr +"]]>").append("</tran_track_set_descr>\r\n");
						 }
						 else
						 {
							 valueXmlString.append("<tran_track_set_descr>").append("<![CDATA[" + "" +"]]>").append("</tran_track_set_descr>\r\n");
						 }
					 }
				 valueXmlString.append("</Detail2>");
				 break ;
					
			}
			valueXmlString.append("</Root>");
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
  
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;	
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}
	private String checkNull(String input) 
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}

	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	
	
	public boolean isRecordExist(Connection conn , String tableName, String condition)
	{
	
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		String sql="";
		boolean isExist=false;
		int recCount=0;
		
		
		try
		{	
			
			sql = " SELECT  COUNT(*)  FROM  "+tableName +"  "+condition;
			pstmt =  conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				recCount=rs.getInt(1);
			
			}
			if(recCount>0)
			{
				isExist=true;
				
			}
			else
			{
				isExist=false;
			
			}
				
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		
		System.out.print("---------Final--isExist-------"+isExist);
		return isExist;
	}
	
	

	private String getAttribValue(Node detailNode, String nodeName, String attribStr)
	{
		String attribValue = "";
		try
		{
			String domStr = GenericUtility.getInstance().serializeDom(detailNode);
			Document dom = GenericUtility.getInstance().parseString(domStr);
			if( dom != null /*&& dom.getAttributes() != null*/)
			{
				Node attributeNode = dom.getElementsByTagName( nodeName ).item(0);
				attribValue = getAttribValue(attributeNode, attribStr);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	private String getAttribValue(Node detailNode, String attribStr)
	{
		String attribValue = "";
		try
		{
			if( detailNode != null && detailNode.getAttributes() != null)
			{
				Node attribNode = detailNode.getAttributes().getNamedItem( attribStr );
				if( attribNode != null )
				{
					attribValue = checkNull( attribNode.getNodeValue() );
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	
 
}	