package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ActionHandlerEJB;
import java.sql.*;
import java.util.StringTokenizer;

import javax.ejb.Stateless;
import java.rmi.RemoteException;

@Stateless
public class CustBankConf extends ActionHandlerEJB implements CustBankConfLocal,CustBankConfRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------confirm method of CustBankConf ------------- : "+tranId);
		String retString = "";		
		try
		{
						
				retString = confirmCBank(tranId,xtraParams,forcedFlag);
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :CustBankConf :confirm():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		
		return retString;
	}
	
	private String confirmCBank(String tranId,String xtraParams,String forcedFlag) 
	{
		System.out.println("---------Class : CustBankConf-->> confirm method called-----------");   
		String CustCode = null;
		String bankcode = null;
		ResultSet rs=null;
		Connection conn=null;
		ConnDriver ConnDriver = new ConnDriver();
		PreparedStatement pstmt=null;
		String errString="",sql="",ActiveYN="";
		int updCnt=0;
		ITMDBAccessLocal itmdbAccess=new ITMDBAccessEJB();
		try
		{		
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 13-06-2016 :START
			//conn = connDriver.getConnectDB("DriverValidator");	
			conn = getConnection();
			//Changes and Commented By Bhushan on 13-06-2016 :END 
			conn.setAutoCommit(false);
			String confirmed="";
			String split[]=tranId.split(":");
			CustCode=split[0].trim();
			bankcode=split[1];
			
			sql = "select confirmed,active_yn from customer_bank WHERE cust_code = ? and bank_code__ben = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, CustCode);
			pstmt.setString(2, bankcode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmed =rs.getString(1)==null ? "N":rs.getString(1);
				ActiveYN=rs.getString(2)==null ? "Y" : rs.getString(2);
			}	
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			
			if( confirmed != null && confirmed.equalsIgnoreCase("Y") )
			{
				
				System.out.println("transaction is already confirmmmm");
				errString = itmdbAccess.getErrorString("", "VTALLCONF ", "", "", conn);
				return errString;
			}	
			if( ActiveYN != null && ActiveYN.equalsIgnoreCase("N") )
			{
				System.out.println("deactivated transaction can not be confirmmm");
				errString = itmdbAccess.getErrorString("", "VMDECTRA", "", "", conn);
				return errString;
			}	
			
			
			
//			GenericUtility genericUtility=new GenericUtility();
			String loginCode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			System.out.println("Login Code ------->> "+loginCode);
			sql="update customer_bank set confirmed = ?,conf_date = ?, emp_code__aprv = ? where cust_code = ? and bank_code__ben = ? ";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, "Y");
			pstmt.setDate(2, new java.sql.Date(System.currentTimeMillis()));
			pstmt.setString(3,loginCode);		
			pstmt.setString(4, CustCode);
			pstmt.setString(5, bankcode);
			updCnt=pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			System.out.println("Update count is"+ updCnt);
			if (updCnt > 0)
			{	
				System.out.println("successfully confirmed");
				errString = itmdbAccess.getErrorString("", "VTCONFIRM ", "", "", conn);
				conn.commit();
			}
			
		}
		catch(SQLException se)
		{
			System.out.println("SQLException : class CustBankConf : ");
			se.printStackTrace();
			try
			{
			  conn.rollback();
			}
			catch(Exception e){
				System.out.println("Exception : Occure during rollback........");e.printStackTrace();
				}
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception Class [StrgCustBankConf]::"+e.getMessage());
			
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}	
				if (conn!=null)
				{
					conn.close();
					conn=null;
				}
							
			}
			catch(Exception e)
			{
				System.out.println(e.getMessage());
				e.printStackTrace();
				
			}
		}
		System.out.println("[CustBankConf]errstring :"+errString);
		return errString;
	
}
}
