package ibase.webitm.ejb.fin;
import ibase.system.config.ConnDriver;
//import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import ibase.webitm.utility.GenericUtility;
import javax.ejb.Stateless;

import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class BankIC extends ValidatorEJB implements BankICRemote, BankICLocal 
{
	//changes and commented by sarita on 01/06/2017
	//E12GenericUtility genericUtility = new E12GenericUtility();
	GenericUtility genericUtility = GenericUtility.getInstance(); 
	FinCommon finCommon = new FinCommon();
	
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		 Document dom = null;
		 Document dom1 = null;
		 Document dom2 = null;
		 String retString = "";
		 try
		 {
			 if(xmlString != null && xmlString.trim().length() > 0)
			 {
				 dom =  genericUtility.parseString(xmlString);
			 }
			 if(xmlString1 != null && xmlString1.trim().length() > 0)
			 {
				 dom1 = genericUtility.parseString(xmlString1);
			 }
			 if(xmlString2 != null && xmlString2.trim().length() > 0)
			 {
				 dom2 = genericUtility.parseString(xmlString2);
			 }
			 retString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
			 System.out.println("retString:::"+retString);
		 }
		 catch(Exception e)
		 {
			 System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			 e.getMessage();
		 }
		 return retString;
	}
	
	private String checkNull(String input) 
	{	
		return input == null ? "" : input;
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		//changes and commented by sarita on 01/06/2017
		//E12GenericUtility genericUtility = new E12GenericUtility();
		GenericUtility genericUtility = GenericUtility.getInstance();
		int childNodeLength = 0;
		int currentFormNo=0;
		int ctr=0,cnt=0;
		double cr_bal_amt=0,od_amt_dbl=0,min_bal_amt=0,safe_bal_amt=0;
		String cr_bal = "", od_amt = "", min_bal = "", safe_bal = "";
		Connection conn = null;
		//Added by sarita on 01/06/2017
		ConnDriver connDriver = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		Node childNode = null;
		String childNodeName = "";
		String userId="",errCode = "",modName = "",sql = "";
		String bank_name = "",state_code = "",count_code = "",curr_code = "";
		String acct_code__bal = "", site_code = "",acct_code__bc = "",acct_code__cf = "",acct_code__od = "";
		String od_allow = "", cctr_code__bal = "", cctr_code__bc = "",cctr_code__cf = "";
		String cctr_code__od = "", bank_code = "",currency = "", sundry_type = "";
		String acct_prd = "",prd_code = "",site_code1 = "",fin_entity;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		String errorType = "",errString="";
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			//changes and commented by sarita for DBConnection on 01/06/2017 :START
			//conn = getConnection();
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			//changes and commented by sarita for DBConnection on 01/06/2017 :END
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"); 
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
				System.out.println("currentFormNo:::"+currentFormNo);
				
				switch(currentFormNo)
				{
					case 1:
					{
						parentNodeList = dom.getElementsByTagName("Detail1");
			    	  	parentNode = parentNodeList.item(0);
			    		childNodeList = parentNode.getChildNodes();
			    		childNodeLength = childNodeList.getLength();
			    		System.out.println("childNodeLength>>"+childNodeLength);
			    		
			    		for(ctr = 0; ctr < childNodeLength; ctr++)
			    		{
			    			System.out.println("childNode>>"+childNode);
				    		childNode =  childNodeList.item(ctr);
				    		System.out.println("childNode>>"+childNode);
							childNodeName = childNode.getNodeName();
							System.out.println("childNodeName>>"+childNodeName);
							
							if("bank_name".equalsIgnoreCase(childNodeName))
							{
								bank_name = genericUtility.getColumnValue("bank_name",dom).trim();
								System.out.println("bank_name>>>>>"+bank_name);
								if(bank_name == null || bank_name.trim().length() == 0)
								{
									errCode = "VMBANKNAME";
							    	errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}// end of if block for bank_name		
							else if("state_code".equalsIgnoreCase(childNodeName))
							{
								state_code = checkNull(genericUtility.getColumnValue("state_code",dom)).trim();
								System.out.println("state_code>>>>>"+state_code);
								
								if(state_code != null && state_code.trim().length() > 0)
								{
									sql = "select count(*) as cnt from state where state_code =?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, state_code);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt = rs.getInt("cnt");
									}
									if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
									
									if(cnt == 0)
									{
										errCode = "VMSTATCD2";
								    	errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}  
							}// end of if block for state_code		
							else if("count_code".equalsIgnoreCase(childNodeName))
							{
								count_code = checkNull(genericUtility.getColumnValue("count_code",dom)).trim();
								System.out.println("count_code>>>>>"+count_code);
								
								if(count_code != null && count_code.trim().length() > 0)
								{
									sql = "select count(*) as cnt from country where count_code =?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, count_code);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt = rs.getInt("cnt");
									}
									if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
									
									if(cnt == 0)
									{
										errCode = "VTCONTCD1";
								    	errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}// end of if block for count_code	
							else if("acct_code__bal".equalsIgnoreCase(childNodeName))
							{
								acct_code__bal = checkNull(genericUtility.getColumnValue("acct_code__bal",dom)).trim();
								site_code = checkNull(genericUtility.getColumnValue("site_code",dom)).trim();
								errCode = finCommon.isAcctCode(site_code, acct_code__bal, modName, conn);
								if(!("".equals(errCode)))
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}// end of if block for acct_code__bal
							else if("acct_code__bc".equalsIgnoreCase(childNodeName))
							{
								acct_code__bc = checkNull(genericUtility.getColumnValue("acct_code__bc",dom)).trim();
								site_code = checkNull(genericUtility.getColumnValue("site_code",dom)).trim();
								errCode = finCommon.isAcctCode(site_code, acct_code__bc, modName, conn);
								if(!("".equals(errCode)))
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}// end of if block for acct_code__bc	
							else if("acct_code__cf".equalsIgnoreCase(childNodeName))
							{
								acct_code__cf = checkNull(genericUtility.getColumnValue("acct_code__cf",dom)).trim();
								site_code = checkNull(genericUtility.getColumnValue("site_code",dom)).trim();
								errCode = finCommon.isAcctCode(site_code, acct_code__cf, modName, conn);
								if(!("".equals(errCode)))
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}	
							}// end of if block for acct_code__cf		
							else if("acct_code__od".equalsIgnoreCase(childNodeName))
							{
								acct_code__od = checkNull(genericUtility.getColumnValue("acct_code__od",dom)).trim();
								od_allow = checkNull(genericUtility.getColumnValue("od_allow",dom)).trim();
								if("Y".equals(od_allow))
								{
									site_code = checkNull(genericUtility.getColumnValue("site_code",dom)).trim();
									errCode = finCommon.isAcctCode(site_code, acct_code__od, modName, conn);
									if(!("".equals(errCode)))
									{
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}// end of if block for acct_code__od
							else if("cctr_code__bal".equalsIgnoreCase(childNodeName))
							{
								cctr_code__bal = checkNull(genericUtility.getColumnValue("cctr_code__bal",dom)).trim();
								acct_code__bal = checkNull(genericUtility.getColumnValue("acct_code__bal",dom)).trim();
								errCode = finCommon.isCctrCode(acct_code__bal, cctr_code__bal, modName, conn);
								if(!("".equals(errCode)))
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								
							}// end of if block for cctr_code__bal
							else if("cctr_code__bc".equalsIgnoreCase(childNodeName))
							{
								cctr_code__bc = checkNull(genericUtility.getColumnValue("cctr_code__bc",dom)).trim();
								acct_code__bc = checkNull(genericUtility.getColumnValue("acct_code__bc",dom)).trim();
								errCode = finCommon.isCctrCode(acct_code__bc, cctr_code__bc, modName, conn);
								if(!("".equals(errCode)))
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}// end of if block for cctr_code__bc
							else if("cctr_code__cf".equalsIgnoreCase(childNodeName))
							{
								cctr_code__cf = checkNull(genericUtility.getColumnValue("cctr_code__cf",dom)).trim();
								acct_code__cf = checkNull(genericUtility.getColumnValue("acct_code__cf",dom)).trim();
								errCode = finCommon.isCctrCode(acct_code__cf, cctr_code__cf, modName, conn);
								if(!("".equals(errCode)))
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}// end of if block for cctr_code__cf
							else if("cctr_code__od".equalsIgnoreCase(childNodeName))
							{
								cctr_code__od = checkNull(genericUtility.getColumnValue("cctr_code__od",dom)).trim();
								acct_code__od = checkNull(genericUtility.getColumnValue("acct_code__od",dom)).trim();
								if(acct_code__od != null && acct_code__od.trim().length() > 0)
								{
									errCode = finCommon.isCctrCode(acct_code__od, cctr_code__od, modName, conn);
								}
							}// end of if block for cctr_code__od
							else if("curr_code".equalsIgnoreCase(childNodeName))
							{
								curr_code = checkNull(genericUtility.getColumnValue("curr_code",dom)).trim();
								System.out.println("curr_code>>>>>"+curr_code);
								
								sql = "select count(*) as cnt from currency where curr_code=?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, curr_code);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								if(pstmt != null)
								{
								    pstmt.close(); 
								    pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
								    rs = null;
								}
								
								if(cnt == 0)
								{
									errCode = "VMCUR1";
								    errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								else
								{
									bank_code = checkNull(genericUtility.getColumnValue("bank_code",dom)).trim();
									System.out.println("bank_code>>>>>"+bank_code);
										
									sql = "select curr_code as currency from bank where bank_code =?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, bank_code);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										currency = rs.getString("currency");
									}
									if(pstmt != null)
									{
									pstmt.close(); 
									pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
									
									if(!(curr_code.equalsIgnoreCase(currency)) && currency != null)
									{
										sundry_type = "B";
									}
										
									sql = "select count(*) as cnt from sundrybal " +
										  "where acct_prd > ? " +
										  "AND prd_code > ? "   +
										  "AND site_code > ? "  +
										  "AND sundry_type =? " +
										  "AND acct_code =? "   +
										  "AND (dr_amt <> 0 or cr_amt <> 0)"; 
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,acct_prd);
									pstmt.setString(2,prd_code);
									pstmt.setString(3,site_code1);
									pstmt.setString(4,sundry_type);
									pstmt.setString(5,bank_code);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt = rs.getInt("cnt");
									}
									if(pstmt != null)
									{
										pstmt.close(); 
										pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
										rs = null;
									}
										
									if(cnt != 0)
									{
										errCode = "VXCURRCD1";
									    errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}// end of if block for curr_code
							else if("site_code".equalsIgnoreCase(childNodeName))
							{
								site_code = checkNull(genericUtility.getColumnValue("site_code",dom)).trim();
								System.out.println("site_code>>>>>"+site_code);
								errCode = finCommon.isSiteCode(site_code,modName,conn);
								if(!("".equals(errCode)))
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}// end of if block for site_code
							else if("fin_entity".equalsIgnoreCase(childNodeName))
							{
								fin_entity = checkNull(genericUtility.getColumnValue("fin_entity",dom)).trim();
								System.out.println("fin_entity>>>>>"+fin_entity);
								errCode = finCommon.isFinEntity(fin_entity, modName, conn);
								if(!("".equals(errCode)))
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}// end of if block for fin_entity
							else if("cr_bal".equalsIgnoreCase(childNodeName))
							{
								cr_bal = checkNull(genericUtility.getColumnValue("cr_bal",dom)).trim();
								System.out.println("cr_bal>>>>>"+cr_bal);
								
								if(cr_bal != null && cr_bal.trim().length() > 0)
								{
									cr_bal_amt = Double.valueOf(cr_bal);	
									if(cr_bal_amt < 0)
									{
										errCode = "VMAMT1";
								    	errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}// end of if block for cr_bal
							else if("od_amt".equalsIgnoreCase(childNodeName))
							{
								od_amt = checkNull(genericUtility.getColumnValue("od_amt",dom)).trim();
								System.out.println("od_amt>>>>>"+od_amt);
								
								if(od_amt != null && od_amt.trim().length() > 0)
								{
									od_amt_dbl = Double.valueOf(od_amt);
									if(od_amt_dbl < 0)
									{
										errCode = "VMAMT1";
								    	errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}// end of if block for od_amt
							else if("min_bal".equalsIgnoreCase(childNodeName))
							{
								min_bal = checkNull(genericUtility.getColumnValue("min_bal",dom)).trim();
								System.out.println("min_bal>>>>>"+min_bal);
								
								if(min_bal != null && min_bal.trim().length() > 0)
								{
									min_bal_amt = Double.valueOf(min_bal);
									if(min_bal_amt < 0)
									{
										errCode = "VMAMT1";
								    	errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}// end of if block for min_bal
							else if("safe_bal".equalsIgnoreCase(childNodeName))
							{
								safe_bal = checkNull(genericUtility.getColumnValue("safe_bal",dom)).trim();
								System.out.println("safe_bal>>>>>"+safe_bal);
								
								if(safe_bal != null && safe_bal.trim().length() > 0)
								{
									safe_bal_amt = Double.valueOf(safe_bal);
									if(safe_bal_amt < 0)
									{
										errCode = "VMAMT1";
								    	errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}// end of if block for safe_bal					
			    		}
					}// end of case 1
					break;
				}
				int errListSize = errList.size();
		        System.out.println("errListSize::::::::::"+errListSize);
				int count = 0;
				String errFldName = null;
				if (errList != null && errListSize > 0)
				{
					for (count = 0; count < errListSize; count++)
					{
						errCode = errList.get(count);
						errFldName = errFields.get(count);
						System.out.println(" testing :errCode .:" + errCode);
						errString = getErrorString(errFldName, errCode, userId);
						System.out.println("errString>>>>>>>>>"+errString);
						errorType = errorType(conn, errCode);
						if (errString.length() > 0)
						{
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							errString = "";
						}
						if (errorType.equalsIgnoreCase("E"))
						{
							break;
						}
					}
					errList.clear();
					errList = null;
					errFields.clear();
					errFields = null;
					errStringXml.append("</Errors> </Root> \r\n");
				} 
				else
				{
					errStringXml = new StringBuffer("");
				}
			}
		}// end of try block
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
						conn.close();
				}
					conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		System.out.println("testing : final errString : " + errString);
		return errString;
	}
	
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document domhr = null;
		Document domAll = null;
		String retString="";
		try
		{
			System.out.println("**************  Inside itemChanged method ****************");
			if(xmlString != null && xmlString.trim().length() > 0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length() > 0)
			{
				domhr = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length() > 0)
			{
				domAll = genericUtility.parseString(xmlString2);
			}
			retString = itemChanged(dom,domhr,domAll,objContext,currentColumn,editFlag,xtraParams);	
			System.out.println("retString::::::::::"+retString);
		}
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 
		}
		return retString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		//Added by sarita on 01/06/2017
		ConnDriver connDriver = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		SimpleDateFormat sdf;
		int currentFormNo=0,ctr=0;
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		int childNodeListLength = 0;
		String bank_code = "",group_code = "",ls_name = "",bank_name = "",ls_shname = "",addr1 = "",ls_add1 = "",ls_add2 = "",ls_city = "";
		String state_code = "",ls_descr = "",ls_count_code = "",site_code = "",ls_descr1 = "",mfin = "",finent_descr = "",ls_currcode = "",count_code = "";
		String sql = "";
		String reStr="";
		int pos =0;
		try
		{
			//changes and commented by sarita for DBConnection on 01/06/2017 :START
			//conn = getConnection();
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			//changes and commented by sarita for DBConnection on 01/06/2017 :END
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[BankIC] [itemChanged] :currentFormNo ....." +currentFormNo);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			switch(currentFormNo)
			{
				case 1:
				{
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					valueXmlString.append("<Detail1>");
					childNodeListLength = childNodeList.getLength();
					do
					{   
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						ctr ++;
					}
					while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
					
					if("itm_defaultedit".equalsIgnoreCase(currentColumn.trim()))
					{
						bank_code  = checkNull(genericUtility.getColumnValue("bank_code", dom));
						group_code = checkNull(genericUtility.getColumnValue("group_code", dom));
						if(group_code == null || group_code.trim().length() == 0)
						{
							valueXmlString.append("<group_code>").append("<![CDATA["+bank_code+"]]>").append("</group_code>");
						}
						
						group_code = checkNull(genericUtility.getColumnValue("group_code", dom));
						bank_name = checkNull(genericUtility.getColumnValue("bank_name", dom));
						addr1 = checkNull(genericUtility.getColumnValue("addr1", dom));
						System.out.println("group_code>>>>"+group_code);
						
						sql = "select bank_name,sh_name,addr1,addr2,city from bank where group_code =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,group_code);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							ls_name = rs.getString("bank_name");
							ls_shname = rs.getString("sh_name");
							ls_add1 = rs.getString("addr1");
							ls_add2 = rs.getString("addr2");
							ls_city = rs.getString("city");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						
						if(bank_name == null || bank_name.trim().length() == 0)
						{
							valueXmlString.append("<bank_name>").append("<![CDATA["+ls_name+"]]>").append("</bank_name>");
							valueXmlString.append("<sh_name>").append("<![CDATA["+ls_shname+"]]>").append("</sh_name>");
						}
						if(addr1 == null || addr1.trim().length() == 0)
						{
							valueXmlString.append("<addr1>").append("<![CDATA["+ls_add1+"]]>").append("</addr1>");
							valueXmlString.append("<addr2>").append("<![CDATA["+ls_add2+"]]>").append("</addr2>");
							valueXmlString.append("<city>").append("<![CDATA["+ls_city+"]]>").append("</city>");
						}
						
						state_code = checkNull(genericUtility.getColumnValue("state_code", dom));
						System.out.println("state_code>>>>"+state_code);
						
						sql = "select descr,count_code from state where state_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,state_code);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							ls_descr = rs.getString("descr");
							ls_count_code = rs.getString("count_code");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<state_descr>").append("<![CDATA["+ls_descr+"]]>").append("</state_descr>");
						valueXmlString.append("<count_code>").append("<![CDATA["+ls_count_code+"]]>").append("</count_code>");
						
						site_code = checkNull(genericUtility.getColumnValue("site_code", dom));
						System.out.println("site_code>>>>"+site_code);
						
						sql = "select descr, fin_entity from site where site_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,site_code);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							ls_descr1 = rs.getString("descr");
							mfin = rs.getString("fin_entity");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<site_descr protect='1'>").append("<![CDATA["+ls_descr1+"]]>").append("</site_descr>");
						valueXmlString.append("<fin_entity>").append("<![CDATA["+mfin+"]]>").append("</fin_entity>");
						
						sql = "select descr from finent where fin_entity=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,mfin);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							finent_descr = rs.getString("descr");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<finent_descr>").append("<![CDATA["+finent_descr+"]]>").append("</finent_descr>");	
						
						count_code = checkNull(genericUtility.getColumnValue("count_code", dom));
						System.out.println("count_code>>>>"+count_code);
						
						sql = "select curr_code from country where count_code =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,count_code);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							ls_currcode = rs.getString("curr_code");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<curr_code>").append("<![CDATA["+ls_currcode+"]]>").append("</curr_code>");	
					}// end of itm_defaultedit				
					else if("bank_code".equalsIgnoreCase(currentColumn.trim()))
					{
						bank_code  = checkNull(genericUtility.getColumnValue("bank_code", dom));
						group_code = checkNull(genericUtility.getColumnValue("group_code", dom));
						if(group_code == null || group_code.trim().length() == 0)
						{
							valueXmlString.append("<group_code>").append("<![CDATA["+bank_code+"]]>").append("</group_code>");
							setNodeValue(dom, "group_code", bank_code);
							reStr = itemChanged(dom, dom1, dom2, objContext, "group_code", editFlag, xtraParams);
							pos = reStr.indexOf("<Detail1>");
							reStr = reStr.substring(pos + 9);
							pos = reStr.indexOf("</Detail1>");
							reStr = reStr.substring(0,pos);
							valueXmlString.append(reStr);
						}
					}// end of if block for bank_code		
					else if("group_code".equalsIgnoreCase(currentColumn.trim()))
					{
						group_code = checkNull(genericUtility.getColumnValue("group_code", dom));
						bank_name = checkNull(genericUtility.getColumnValue("bank_name", dom));
						addr1 = checkNull(genericUtility.getColumnValue("addr1", dom));
						System.out.println("group_code>>>>"+group_code);
						
						sql = "select bank_name,sh_name,addr1,addr2,city from bank where group_code =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,group_code);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							ls_name = rs.getString("bank_name");
							ls_shname = rs.getString("sh_name");
							ls_add1 = rs.getString("addr1");
							ls_add2 = rs.getString("addr2");
							ls_city = rs.getString("city");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						
						if(bank_name == null || bank_name.trim().length() == 0)
						{
							valueXmlString.append("<bank_name>").append("<![CDATA["+ls_name+"]]>").append("</bank_name>");
							valueXmlString.append("<sh_name>").append("<![CDATA["+ls_shname+"]]>").append("</sh_name>");
						}
						if(addr1 == null || addr1.trim().length() == 0)
						{
							valueXmlString.append("<addr1>").append("<![CDATA["+ls_add1+"]]>").append("</addr1>");
							valueXmlString.append("<addr2>").append("<![CDATA["+ls_add2+"]]>").append("</addr2>");
							valueXmlString.append("<city>").append("<![CDATA["+ls_city+"]]>").append("</city>");
						}
					}// end of if block for group_code					
					else if("state_code".equalsIgnoreCase(currentColumn.trim()))
					{
						state_code = checkNull(genericUtility.getColumnValue("state_code", dom));
						System.out.println("state_code>>>>"+state_code);
						
						sql = "select descr,count_code from state where state_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,state_code);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							ls_descr = rs.getString("descr");
							ls_count_code = rs.getString("count_code");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<state_descr>").append("<![CDATA["+ls_descr+"]]>").append("</state_descr>");
						valueXmlString.append("<count_code>").append("<![CDATA["+ls_count_code+"]]>").append("</count_code>");
					}// end of if block for state_code					
					else if("site_code".equalsIgnoreCase(currentColumn.trim()))
					{
						site_code = checkNull(genericUtility.getColumnValue("site_code", dom));
						System.out.println("site_code>>>>"+site_code);
						
						sql = "select descr, fin_entity from site where site_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,site_code);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							ls_descr1 = rs.getString("descr");
							mfin = rs.getString("fin_entity");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<site_descr protect='1'>").append("<![CDATA["+ls_descr1+"]]>").append("</site_descr>");
						valueXmlString.append("<fin_entity>").append("<![CDATA["+mfin+"]]>").append("</fin_entity>");
						
						sql = "select descr from finent where fin_entity=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,mfin);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							finent_descr = rs.getString("descr");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<finent_descr>").append("<![CDATA["+finent_descr+"]]>").append("</finent_descr>");	
					}// end of if block for site_code					
					else if("count_code".equalsIgnoreCase(currentColumn.trim()))
					{
						count_code = checkNull(genericUtility.getColumnValue("count_code", dom));
						System.out.println("count_code>>>>"+count_code);
						
						sql = "select curr_code from country where count_code =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,count_code);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							ls_currcode = rs.getString("curr_code");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<curr_code>").append("<![CDATA["+ls_currcode+"]]>").append("</curr_code>");	
					}// end of if block for count_code
					valueXmlString.append("</Detail1>");
					break;
				}// end of case1
			}// end of switch statement
			valueXmlString.append("</Root>");
		}// end of try block
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception in EJB["+ getClass().getSimpleName() + "]::itemChanged::["+ e.getMessage() + "]");	
			}	
		}
		return valueXmlString.toString();
	}
	
	private String errorType(Connection conn, String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		} 
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	
	private void setNodeValue( Document dom, String nodeName, String nodeVal ) throws Exception
	{
		Node tempNode = dom.getElementsByTagName( nodeName ).item(0);

		if( tempNode != null )
		{
			if( tempNode.getFirstChild() == null )
			{
				CDATASection cDataSection = dom.createCDATASection( nodeVal );
				tempNode.appendChild( cDataSection );
			}
			else
			{
				tempNode.getFirstChild().setNodeValue(nodeVal);
			}
		}
		tempNode = null;
	}
}
