/********************************************************
	Title : BankRecoWizIC [F15ISUN015]
	Date  : 29 - DEC - 2015
	Author: Mahendra Jadhav

 ********************************************************/
package ibase.webitm.ejb.fin;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class BankRecoWizIC extends ValidatorEJB implements BankRecoWizICLocal, BankRecoWizICRemote {

	//GenericUtility genericUtility = GenericUtility.getInstance();
	//E12GenericUtility genericUtility = E12GenericUtility.getInstance();
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmdbAccessEJB = new ITMDBAccessEJB();
	String userId = null;
	String chgUser = null;
	String chgTerm = null;
	UserInfoBean userInfoBean = null;

	NumberFormat nf = null;
	boolean isError=false;
	ITMDBAccessLocal itmDBAccessLocal = new ITMDBAccessEJB();

	public BankRecoWizIC() {
		System.out.println("Constructor Calling of BankRecoWizIC......");
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
		System.out.println("BankRecoWizIC wfValData..... ");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";

		try {
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0) {
				dom2 = parseString("<Root>" + xmlString2 + "</Root>");
			}
			if (objContext != null && Integer.parseInt(objContext) == 1) {
				parentNodeList = dom2.getElementsByTagName("Header0");
				parentNode = parentNodeList.item(1);
				childNodeList = parentNode.getChildNodes();
				for (int x = 0; x < childNodeList.getLength(); x++) {
					childNode = childNodeList.item(x);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("Detail1")) {
						errString = wfValData(dom, dom1, dom2, "1", editFlag, xtraParams);
						if (errString != null && errString.trim().length() > 0)
							break;
					} else if (childNodeName.equalsIgnoreCase("Detail2")) {
						errString = wfValData(dom, dom1, dom2, "2", editFlag, xtraParams);
						break;
					}
				}
			} else {
				errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			}
		} catch (Exception e) {
			System.out.println("Exception : Inside BankRecoWizIC wfValData Method ..> " + e.getMessage());
			throw new ITMException(e);
		}
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
		System.out.println("================= inside BankRecoWizIC wfvaldata=================================-");
//		GenericUtility genericUtility;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0, currentFormNo = 0, childNodeListLength = 0, cnt = 0;
		String childNodeName = null;
		SimpleDateFormat simpleDateFormat = null;
		String errString = "";
		String errCode = "";
		Connection conn = null;
		String userId = "",bankCode = "";
		Date tranDate1,tranDate2;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
//			genericUtility = GenericUtility.getInstance();
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			System.out.println("currentFormNo :"+currentFormNo);
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo)
			{
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength :"+childNodeListLength);
				/*
				NodeList parentNodeList1 = dom.getElementsByTagName("Detail2");
				Node parentNode1 = parentNodeList1.item(0);
				NodeList childNodeList1 = parentNode1.getChildNodes();
				int childNodeListLength1 = childNodeList1.getLength();
				System.out.println("childNodeListLength1 :"+childNodeListLength1);
				 */
				for (ctr = 0; ctr < childNodeListLength; ctr++) {
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if ("bank_code".equalsIgnoreCase(childNodeName)) {
						bankCode = genericUtility.getColumnValue("bank_code", dom);
						bankCode = bankCode == null ? "" : bankCode.trim();
						if (bankCode.length() == 0) {
							errCode = "EMTBANKCD";
							errString = getErrorString("bank_code", errCode, userId);
							break;
						} else {
							cnt = getDBRowCount(conn, "bank", "bank_code", bankCode);
							if (cnt == 0) {
								errCode = "VTBNKINV";
								errString = getErrorString("bank_code", errCode, userId);
								break;
							}
						}
						//firstValue = null;
					} 
				}

				break;
			}
		} catch (Exception e) {
			e.printStackTrace();			
			errString = e.getMessage();
			try {
				conn.rollback();				
			} catch (Exception d) {
				d.printStackTrace();
			}
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null) {
					conn.close();
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
			}
		}
		System.out.println("errString in wfValData : "+errString);
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try {

			System.out.println("xmlString :"+xmlString);
			System.out.println("xmlString1 :"+xmlString1);
			System.out.println("xmlString2 :"+xmlString2);

			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0) 
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		} catch (Exception e) {
			System.out.println("Exception : [itemChanged(String,String)] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {

		String  insertQuery = "", path = "", objName = "bank_reconciliation_wiz";
		String filterXml="",filterxml="",type="";
		String siteCode="",sql="",siteDescr="",bankName="",adpQuery="", bankCode= "";
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
//		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		SimpleDateFormat simpleDateFormat = null;
		try
		{   
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userId");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			System.out.println("userId :"+userId);
			System.out.println("chgUser :"+chgUser);
			System.out.println("chgTerm :"+chgTerm);

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			switch (currentFormNo) {
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				System.out.println("DOM2 Elements["+genericUtility.serializeDom(dom2).toString()+"]");
				//int childNodeListLength = childNodeList.getLength();
				System.out.println("currentColumn :"+currentColumn);

				if(currentColumn.trim().equals("itm_default"))
				{
					System.out.println("calling itm_default in case 1..............");
					/*Calendar cal = Calendar.getInstance();
					Date d = new Date();
					cal.setTime(d);
					cal.set(Calendar.DATE,1);
					d = cal.getTime();
					String fromDate = simpleDateFormat.format(d);
					cal.setTime(d);
					cal.add(Calendar.MONTH,1);
					cal.set(Calendar.DATE,0);
					d = cal.getTime();
					String toDate = simpleDateFormat.format(d);*/

					//siteCode = checkNull(genericUtility.getColumnValue("site_code",dom));
					bankCode = checkNull(genericUtility.getColumnValue("bank_code",dom));
					System.out.println("bankCode :"+bankCode);

					sql = "select site_code from bank where bank_code=?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, bankCode.trim());
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						siteCode = checkNull(rs.getString("site_code"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					System.out.println("siteCode :"+siteCode);


					valueXmlString.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>");
					valueXmlString.append("<site_descr><![CDATA[").append(siteDescr).append("]]></site_descr>");
					valueXmlString.append("<bank_code><![CDATA[").append(bankCode).append("]]></bank_code>");
					valueXmlString.append("<bank_descr><![CDATA[").append(bankName).append("]]></bank_descr>");

				}
				else if(currentColumn.trim().equals("site_code")) 
				{

					System.out.println("inside site code");
					siteCode = checkNull(genericUtility.getColumnValue("site_code",dom));
					System.out.println("siteCode is :"+siteCode);

					sql = "select descr from site where site_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode.trim());
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						siteDescr = checkNull(rs.getString("descr"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;


					valueXmlString.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>");
					valueXmlString.append("<site_descr><![CDATA[").append(siteDescr).append("]]></site_descr>");

				}
				else if(currentColumn.trim().equals("bank_code")) {

					System.out.println("inside bankCode");
					bankCode = checkNull(genericUtility.getColumnValue("bank_code",dom));
					System.out.println("bankCode is :"+bankCode);

					sql = "select BANK_NAME from bank where bank_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, bankCode.trim());
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						bankName = checkNull(rs.getString("BANK_NAME"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;


					valueXmlString.append("<bank_code><![CDATA[").append(bankCode).append("]]></bank_code>");
					valueXmlString.append("<bank_descr><![CDATA[").append(bankName).append("]]></bank_descr>");


				}
				valueXmlString.append("</Detail1>");
				System.out.println("valueXmlString :"+valueXmlString);

				break;
			case 2 : 
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				System.out.println("DOM2 Elements["+genericUtility.serializeDom(dom2).toString()+"]");
				//childNodeListLength = childNodeList.getLength();
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					System.out.println("calling itm_default in case 2..............");
					InitialContext ctx = null;
					AppConnectParm appConnect = new AppConnectParm();
					ctx = new InitialContext(appConnect.getProperty());
					bankCode = genericUtility.getColumnValue("bank_code",dom1);
					System.out.println("bankCode :"+bankCode);

					filterxml = genericUtility.getColumnValue("filter_xml", dom1);
					System.out.println("filterxml :"+filterxml);

					type = checkNull(genericUtility.getColumnValue("type", dom1));
					System.out.println("type :"+type);



					if("FILTER".equalsIgnoreCase(type))
					{
						System.out.println("Running in filter..........");
						filterXml = filterxml;
						valueXmlString.append(filterXml);
						System.out.println("valueXmlString in filter :"+valueXmlString);
					}
					else
					{
						sql = "select site_code from bank where bank_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, bankCode.trim());
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							siteCode = checkNull(rs.getString("site_code"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("siteCode:"+siteCode);


						sql = "select BANK_NAME from bank where bank_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, bankCode.trim());
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							bankName = checkNull(rs.getString("BANK_NAME"));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("bankName :"+bankName);



						valueXmlString.append("<Detail1>");
						valueXmlString.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>");
						valueXmlString.append("<bank_code><![CDATA[").append(bankCode).append("]]></bank_code>");
						valueXmlString.append("<bank_descr><![CDATA[").append(bankName).append("]]></bank_descr>");
						valueXmlString.append("<filter_list><![CDATA[").append("").append("]]></filter_list>");
						valueXmlString.append("<filter_data><![CDATA[").append("").append("]]></filter_data>");
						valueXmlString.append("<from_date><![CDATA[").append("").append("]]></from_date>");
						valueXmlString.append("<to_date><![CDATA[").append("").append("]]></to_date>");
						valueXmlString.append("</Detail1>");
						valueXmlString.append("<Detail2>");
						valueXmlString.append(getXMLTransData(conn,adpQuery,"",objName,new StringBuffer(""),"CallByItemChange","",siteCode,bankCode,""));
						valueXmlString.append("</Detail2>");
						System.out.println("valueXmlString (itemChanged)!!!!!!!!!:"+valueXmlString);
					}



				}
				break;
			case 3 : 
				parentNodeList = dom.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				System.out.println("DOM3 Elements["+genericUtility.serializeDom(dom).toString()+"]");
				//childNodeListLength = childNodeList.getLength();
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{

				}
				break;
			}
			valueXmlString.append("</Root>"); 
		}
		catch(Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage()); 
			try {
				conn.rollback();				
			} catch (Exception d) {
				d.printStackTrace();
			}
			throw new ITMException(e); 
		}
		finally 
		{
			try
			{
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close(); 
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace(); 
			}
		}
		System.out.println("Final valueXmlString in itemChanged :"+valueXmlString);
		return valueXmlString.toString();
	}




	private int getDBRowCount(Connection conn, String table_name, String whrCondCol, String whrCondVal)
	{
		int count=-1;

		if(conn!=null){

			ResultSet rs=null;
			PreparedStatement pstmt = null;

			String sql="select count(1) from "+table_name+" where "+whrCondCol+" = ?";
			//System.out.println("SQL in getDBRowCount method : "+sql);
			try
			{
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,whrCondVal);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count = rs.getInt(1);
				}
			}
			catch(SQLException e)
			{
				System.out.println("SQL Exception In getDBRowCount method of InterCompReconcile Class : "+e.getMessage());
				e.printStackTrace();
			}
			catch(Exception ex)
			{
				System.out.println("Exception In getDBRowCount method of InterCompReconcile Class : "+ex.getMessage());
				ex.printStackTrace();
			}finally{

				try{

					if(pstmt!=null){
						pstmt.close();
						pstmt = null;
					}
					if(rs!=null){
						rs.close();
						rs = null;
					}
				}catch (SQLException se) {
					se.printStackTrace();
				}
			}
		}else{
			try {
				throw new SQLException("Connection passed to InterCompReconcile.getDBRowCount() method is null");
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return count;
	}

	public String preSaveForm(String xmlString1,String reconcileType,String autoReconFilter)throws ITMException
	{
		Document dom = null;

		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String siteCode = "", bankCode = "",adpQuery="";
		String resultString ="";
		try
		{   
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			System.out.println("call preSaveForm...........");
			System.out.println("xmlString1 (preSaveForm) :"+xmlString1);
			System.out.println("reconcileType(preSaveForm) :"+reconcileType);
			System.out.println("autoReconFilter(preSaveForm)"+autoReconFilter);

			
			
			if (xmlString1 != null && xmlString1.trim().length() > 0)
			{
				System.out.println("=====================================");
				dom = genericUtility.parseString(xmlString1);
				siteCode = checkNull(genericUtility.getColumnValue("site_code",dom));
				System.out.println("siteCode :"+siteCode);
				bankCode = checkNull(genericUtility.getColumnValue("bank_code",dom));
				System.out.println("bankCode :"+bankCode);
				/*
				if(reconcileType.equalsIgnoreCase("filter")){
					System.out.println("recon type:: " + reconcileType);
					getFilterData(xmlString1,siteCode,bankCode);
				}else{*/

				/*String path = CommonConstants.JBOSSHOME + File.separator + "sql" + File.separator + "oracle/relatePartyConsoleSupply.sql";
				System.out.println("path :"+path);
				String adpQuery = genericUtility.readFile(path);*/
				String objName = "bank_reconciliation_wiz";
				//String insertQuery = "Insert Into Intercomp_Reco_Trace ( Tran_Id,Tran_Date,Ref_Ser,Ref_Id,Ref_Ser__To,Ref_Id__To,Site_Code,Site_Code__To,Amount,Chg_Date,Chg_User,Chg_Term,reconcile_type) values (?,?,?,?, ?,?,?,?, ?,?,?,?,? )";
				String insertQuery = "Insert Into bankreco_trace (TRAN_ID__LOG,TRAN_ID__STAT,AMOUNT) values (?,?,?)";


				//System.out.println("adpQuery :"+adpQuery);
				StringBuffer valueString = getXMLTransData(conn,adpQuery,insertQuery,objName,new StringBuffer(genericUtility.serializeDom(dom)),"CallByManually",reconcileType,siteCode,bankCode,autoReconFilter);
				resultString = valueString.toString();
				System.out.println("@@@@@@@resultString:1["+resultString+"]");

				//ITMDBAccessEJB itmdbAccess = new ITMDBAccessEJB();

				//resultString = getErrorString("bank_code", "KEYNTMATCH", userId);// cpatil
				//resultString = itmdbAccess.getErrorString("", "KEYNTMATCH", "", "",conn);
				//resultString = itmdbAccess.getErrorString("", resultString, "", "",conn);
				//System.out.println("@@@@@@@resultString:2["+resultString+"]");
				//path = null;
				adpQuery = null;
				objName = null;
				insertQuery = null;
			}		
		
		}
		catch(SQLException e) {
			System.out.println("SQL Exception In getXMLTransData method of BankRecoWizIC Class : "+e.getMessage());
			e.printStackTrace();
		}
		catch(Exception ex) {
			System.out.println("Exception In getXMLTransData method of BankRecoWizIC Class : "+ex.getMessage());
			ex.printStackTrace();
		} finally {
			try {
				if(conn != null) {
					conn.close(); 
				}
				conn = null;
				xmlString1 = null;
			} catch(Exception d) {
				d.printStackTrace(); 
			}
		}
		//return "";
		return resultString;
	}

	private StringBuffer getXMLTransData(Connection conn, String sql, String insertSql, String objName, StringBuffer stringBuffer, String callBy,String reconcileType,String siteCode,String bankCode,String autoReconFilter) throws Exception
	{

		ConnDriver connDriver1 = new ConnDriver();
		Connection conn1=null;
		String siteCodeFr="",siteCodeTo="";

		StringBuffer valueXmlString = new StringBuffer("");
		HashMap<String,Double> bankStmtMap=new HashMap<String,Double>();
		HashMap<String,Double> bankTntMap=new HashMap<String,Double>();
		HashMap<String,String> tranIdBSMap=new HashMap<String,String>();
		HashMap<String,String> tranIdBTMap=new HashMap<String,String>();
		HashMap<String,Double> RefBSHashMap = new HashMap<String,Double>();
		HashMap<String,Double> RefBTHashMap = new HashMap<String,Double>();
		HashMap<String,String> currBSMap = new HashMap<String,String>();
		HashMap<String,String> currBTMap = new HashMap<String,String>();
		List<String>tranIdBSList = new ArrayList<String>();
		List<String>tranIdBTList = new ArrayList<String>();
		List<Double>amtList = new ArrayList<Double>();
		Set<String>currSet = new HashSet<String>();
		ArrayList<ArrayList> arrayListData = null;
		arrayListData= new ArrayList<ArrayList> ();
		//ArrayList traceData = null;
		//traceData = new ArrayList();
		Document dom = null;
		String rType="";
		String refSer = "";
		double dramt = 0,cramt = 0,tempAmt = 0,lamt = 0,ramt = 0;
		String refNoBS="",slipNoBT="",refDateBS="",tranTypeBS="",currCodeBS="",tranIdBS="",tranName="";
		double amtBS=0.0,amtAdjBS=0.0;
		String refNoBT="",refDateBT="",currCodeBT="",tranIdBT="",tranTypeBT="";
		double amtBT =0.0,amtAdjBT=0.0;
		double calAmt=0.0,receiptAmt=0.0,paymentAmt=0.0,tempAmtBT=0.0,tempAmtBS=0.0;
		boolean isReconcile=false;

		//cpatil 09/03/16 start
		String autoReconFilterValue="",refNo="",refDate="",amtAdj="",amtBc="";
		double totalBSAmount=0,totalBTAmount=0;

		
		HashMap<String,ArrayList<String>> RefBSHashMapAuto = new HashMap<String,ArrayList<String>>();
		HashMap<String,ArrayList<String>> RefBTHashMapAuto = new HashMap<String,ArrayList<String>>();

		TransIDGenerator generator = null;
		if(conn!=null)
		{
			ResultSet rs = null;
			PreparedStatement pstmt = null;

			int columnCnt = 0;
			int columnItr = 0, detailListCnt = 1;
			ResultSetMetaData resultSetMetaData = null;
			try
			{
				System.out.println("Calling getXMLTransData()..... ");
				System.out.println("check the parameter in getXMLTransData....");
				System.out.println("objName :"+objName);
				System.out.println("callBy :"+callBy);
				System.out.println("reconcileType :"+reconcileType);
				System.out.println("siteCode :"+siteCode);
				System.out.println("bankCode :"+bankCode);
				System.out.println("sql:"+sql);
				System.out.println("insertSql:"+insertSql);
				System.out.println("In First If!!!!!!!!!!!");
				if ("CallByItemChange".equalsIgnoreCase(callBy) || "CallByFilter".equalsIgnoreCase(callBy))
				{
					
					System.out.println("In CallByItemChange (getXMLTransData).....");

					if(callBy.equalsIgnoreCase("CallByItemChange")){
						System.out.println("itemchange:::");
						
					sql = " select bs.TRAN_ID tran_id,bs.REF_NO ref_no," +
							" to_char(bs.REF_DATE,'DD-MON-YY') ref_date," +
							" bs.REF_MODE ref_mode,bs.AMOUNT amount,bs.TRAN_TYPE tran_type," +
							" bs.EDI_REF EDI_REF_BS,bs.REMARKS remarks,bs.STAT_NO stat_no," +
							" to_char(bs.STAT_DATE,'DD-MON-YY') stat_date," +
							" bs.STATUS status," +
							//" bs.AMT_ADJ amt_adj," +
							" 0 as amt_adj," +
							" to_char(bs.EFF_DATE,'DD-MON-YY') eff_date," +
							" bs.DATE__FROM DATE__FROM_BS,bs.DATE__TO DATE__TO_BS," +
							" bs.STATUS_DATE STATUS_DATE_BS,bs.EXCH_RATE exch_rate,bs.CURR_CODE curr_code" +
							" from bank_statement bs where  bs.site_code=? and bs.bank_code=? and status in ('E', 'P')" ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,siteCode);
					pstmt.setString(2,bankCode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						valueXmlString.append("<Detail>");
						valueXmlString.append("<tran_name><![CDATA[").append("bankStatement").append("]]></tran_name>");
						valueXmlString.append("<ref_no><![CDATA[").append(checkNull(rs.getString("ref_no"))).append("]]></ref_no>");
						valueXmlString.append("<ref_date><![CDATA[").append(checkNull(rs.getString("ref_date"))).append("]]></ref_date>");
						valueXmlString.append("<amt_bc><![CDATA[").append(checkNull(rs.getString("amount"))).append("]]></amt_bc>");
						valueXmlString.append("<curr_code><![CDATA[").append(checkNull(rs.getString("curr_code"))).append("]]></curr_code>");
						valueXmlString.append("<amt_bs><![CDATA[").append(checkNull(rs.getString("amount"))).append("]]></amt_bs>");
						valueXmlString.append("<tran_type><![CDATA[").append(checkNull(rs.getString("tran_type"))).append("]]></tran_type>");
						valueXmlString.append("<tran_id><![CDATA[").append(checkNull(rs.getString("tran_id"))).append("]]></tran_id>");
						valueXmlString.append("<ref_mode><![CDATA[").append(checkNull(rs.getString("ref_mode"))).append("]]></ref_mode>");
						valueXmlString.append("<eff_date><![CDATA[").append(checkNull(rs.getString("eff_date"))).append("]]></eff_date>");
						valueXmlString.append("<stat_no><![CDATA[").append(checkNull(rs.getString("stat_no"))).append("]]></stat_no>");
						valueXmlString.append("<stat_date><![CDATA[").append(checkNull(rs.getString("stat_date"))).append("]]></stat_date>");
						valueXmlString.append("<amt_adj><![CDATA[").append(checkNull(rs.getString("amt_adj"))).append("]]></amt_adj>");
						valueXmlString.append("<status><![CDATA[").append(checkNull(rs.getString("status"))).append("]]></status>");
						valueXmlString.append("<exch_rate><![CDATA[").append(checkNull(rs.getString("exch_rate"))).append("]]></exch_rate>");
						valueXmlString.append("</Detail>\r\n");
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;

					sql = 	" select bt.TRAN_ID tran_id," +
							" to_char(bt.TRAN_DATE,'DD-MON-YY') TRAN_DATE_BT," +
							" bt.TRAN_SER TRAN_SER_BT," +
							" bt.TRAN_NO TRAN_NO_BT,bt.REF_NO ref_no," +
							" to_char(bt.REF_DATE,'DD-MON-YY') ref_date," +
							" bt.REF_MODE ref_mode," +
							" bt.AMOUNT amount,bt.TRAN_TYPE tran_type,bt.ACCT_CODE acct_code," +
							" bt.CCTR_CODE cctr_code,bt.SUNDRY_CODE sundry_code,bt.STATUS status ," +
							" bt.REMARKS remarks," +
							" 0 as amt_adj," +
							//" bt.AMT_ADJ amt_adj," +
							"bt.SUNDRY_TYPE SUNDRY_TYPE_BT," +
							" bt.EXCH_RATE exch_rate,bt.CURR_CODE curr_code from " +
							" banktran_log bt where  " +
							" bt.site_code=? and bt.bank_code=? and status in ('E', 'P') ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,siteCode);
					pstmt.setString(2,bankCode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						System.out.println("curr code:::::"+rs.getString("curr_code"));
						valueXmlString.append("<Detail>");
						valueXmlString.append("<tran_name><![CDATA[").append("bankTransaction").append("]]></tran_name>");
						valueXmlString.append("<ref_no><![CDATA[").append(checkNull(rs.getString("ref_no"))).append("]]></ref_no>");
						valueXmlString.append("<ref_date><![CDATA[").append(checkNull(rs.getString("ref_date"))).append("]]></ref_date>");
						valueXmlString.append("<amt_bc><![CDATA[").append(checkNull(rs.getString("amount"))).append("]]></amt_bc>");
						valueXmlString.append("<remarks><![CDATA[").append(checkNull(rs.getString("remarks"))).append("]]></remarks>");
						valueXmlString.append("<curr_code><![CDATA[").append(checkNull(rs.getString("curr_code"))).append("]]></curr_code>");
						valueXmlString.append("<amt_bt><![CDATA[").append(checkNull(rs.getString("amount"))).append("]]></amt_bt>");
						valueXmlString.append("<ref_mode><![CDATA[").append(checkNull(rs.getString("ref_mode"))).append("]]></ref_mode>");
						valueXmlString.append("<tran_id><![CDATA[").append(checkNull(rs.getString("tran_id"))).append("]]></tran_id>");
						valueXmlString.append("<tran_type><![CDATA[").append(checkNull(rs.getString("tran_type"))).append("]]></tran_type>");
						valueXmlString.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>");
						valueXmlString.append("<acct_code><![CDATA[").append(checkNull(rs.getString("acct_code"))).append("]]></acct_code>");
						valueXmlString.append("<cctr_code><![CDATA[").append(checkNull(rs.getString("cctr_code"))).append("]]></cctr_code>");
						valueXmlString.append("<sundry_code><![CDATA[").append(checkNull(rs.getString("sundry_code"))).append("]]></sundry_code>");
						valueXmlString.append("<status><![CDATA[").append(checkNull(rs.getString("status"))).append("]]></status>");
						valueXmlString.append("<exch_rate><![CDATA[").append(checkNull(rs.getString("exch_rate"))).append("]]></exch_rate>");
						valueXmlString.append("<amt_adj><![CDATA[").append(checkNull(rs.getString("amt_adj"))).append("]]></amt_adj>");
						valueXmlString.append("</Detail>\r\n");

					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;



					System.out.println("valueXmlString of CallByItemChange(getXMLTransData) :"+valueXmlString);
				}else{
					System.out.println("filter::::");
					
					sql = " select bs.site_code,bs.bank_code,bs.TRAN_ID tran_id,bs.REF_NO ref_no," +
							" to_char(bs.REF_DATE,'DD-MON-YY') ref_date," +
							" bs.REF_MODE ref_mode,bs.AMOUNT amount,bs.TRAN_TYPE tran_type," +
							" bs.EDI_REF EDI_REF_BS,bs.REMARKS remarks,bs.STAT_NO stat_no," +
							" to_char(bs.STAT_DATE,'DD-MON-YY') stat_date," +
							" bs.STATUS status," +
							//" bs.AMT_ADJ amt_adj," +
							" 0 as amt_adj," +
							" to_char(bs.EFF_DATE,'DD-MON-YY') eff_date," +
							" bs.DATE__FROM DATE__FROM_BS,bs.DATE__TO DATE__TO_BS," +
							" bs.STATUS_DATE STATUS_DATE_BS,bs.EXCH_RATE exch_rate,bs.CURR_CODE curr_code" +
							" from bank_statement bs where  bs.site_code=? and bs.bank_code=? and status in ('E', 'P')" ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,siteCode);
					pstmt.setString(2,bankCode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						valueXmlString.append("<Detail>");
						valueXmlString.append("<tran_name><![CDATA[").append("bankStatement").append("]]></tran_name>");
						valueXmlString.append("<ref_no><![CDATA[").append(checkNull(rs.getString("ref_no"))).append("]]></ref_no>");
						valueXmlString.append("<ref_date><![CDATA[").append(checkNull(rs.getString("ref_date"))).append("]]></ref_date>");
						valueXmlString.append("<amt_bc><![CDATA[").append(checkNull(rs.getString("amount"))).append("]]></amt_bc>");
						valueXmlString.append("<curr_code><![CDATA[").append(checkNull(rs.getString("curr_code"))).append("]]></curr_code>");
						valueXmlString.append("<amt_bs><![CDATA[").append(checkNull(rs.getString("amount"))).append("]]></amt_bs>");
						valueXmlString.append("<tran_type><![CDATA[").append(checkNull(rs.getString("tran_type"))).append("]]></tran_type>");
						valueXmlString.append("<tran_id><![CDATA[").append(checkNull(rs.getString("tran_id"))).append("]]></tran_id>");
						valueXmlString.append("<ref_mode><![CDATA[").append(checkNull(rs.getString("ref_mode"))).append("]]></ref_mode>");
						valueXmlString.append("<eff_date><![CDATA[").append(checkNull(rs.getString("eff_date"))).append("]]></eff_date>");
						valueXmlString.append("<stat_no><![CDATA[").append(checkNull(rs.getString("stat_no"))).append("]]></stat_no>");
						valueXmlString.append("<stat_date><![CDATA[").append(checkNull(rs.getString("stat_date"))).append("]]></stat_date>");
						valueXmlString.append("<amt_adj><![CDATA[").append(checkNull(rs.getString("amt_adj"))).append("]]></amt_adj>");
						valueXmlString.append("<status><![CDATA[").append(checkNull(rs.getString("status"))).append("]]></status>");
						valueXmlString.append("<exch_rate><![CDATA[").append(checkNull(rs.getString("exch_rate"))).append("]]></exch_rate>");
						valueXmlString.append("<site_code><![CDATA[").append(checkNull(rs.getString("site_code"))).append("]]></site_code>");
						valueXmlString.append("<bank_code><![CDATA[").append(checkNull(rs.getString("bank_code"))).append("]]></bank_code>");
						valueXmlString.append("</Detail>\r\n");
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;

					sql = 	" select bt.site_code,bt.bank_code,bt.TRAN_ID tran_id," +
							" to_char(bt.TRAN_DATE,'DD-MON-YY') TRAN_DATE_BT," +
							" bt.TRAN_SER TRAN_SER_BT," +
							" bt.TRAN_NO TRAN_NO_BT,bt.REF_NO ref_no," +
							" to_char(bt.REF_DATE,'DD-MON-YY') ref_date," +
							" bt.REF_MODE ref_mode," +
							" bt.AMOUNT amount,bt.TRAN_TYPE tran_type,bt.ACCT_CODE acct_code," +
							" bt.CCTR_CODE cctr_code,bt.SUNDRY_CODE sundry_code,bt.STATUS status ," +
							" bt.REMARKS remarks," +
							" 0 as amt_adj," +
							//" bt.AMT_ADJ amt_adj," +
							"bt.SUNDRY_TYPE SUNDRY_TYPE_BT," +
							" bt.EXCH_RATE exch_rate,bt.CURR_CODE curr_code from " +
							" banktran_log bt where  " +
							" bt.site_code=? and bt.bank_code=? and status in ('E', 'P') ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,siteCode);
					pstmt.setString(2,bankCode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						System.out.println("curr code:::::"+rs.getString("curr_code"));
						valueXmlString.append("<Detail>");
						valueXmlString.append("<tran_name><![CDATA[").append("bankTransaction").append("]]></tran_name>");
						valueXmlString.append("<ref_no><![CDATA[").append(checkNull(rs.getString("ref_no"))).append("]]></ref_no>");
						valueXmlString.append("<ref_date><![CDATA[").append(checkNull(rs.getString("ref_date"))).append("]]></ref_date>");
						valueXmlString.append("<amt_bc><![CDATA[").append(checkNull(rs.getString("amount"))).append("]]></amt_bc>");
						valueXmlString.append("<remarks><![CDATA[").append(checkNull(rs.getString("remarks"))).append("]]></remarks>");
						valueXmlString.append("<curr_code><![CDATA[").append(checkNull(rs.getString("curr_code"))).append("]]></curr_code>");
						valueXmlString.append("<amt_bt><![CDATA[").append(checkNull(rs.getString("amount"))).append("]]></amt_bt>");
						valueXmlString.append("<ref_mode><![CDATA[").append(checkNull(rs.getString("ref_mode"))).append("]]></ref_mode>");
						valueXmlString.append("<tran_id><![CDATA[").append(checkNull(rs.getString("tran_id"))).append("]]></tran_id>");
						valueXmlString.append("<tran_type><![CDATA[").append(checkNull(rs.getString("tran_type"))).append("]]></tran_type>");
						valueXmlString.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>");
						valueXmlString.append("<acct_code><![CDATA[").append(checkNull(rs.getString("acct_code"))).append("]]></acct_code>");
						valueXmlString.append("<cctr_code><![CDATA[").append(checkNull(rs.getString("cctr_code"))).append("]]></cctr_code>");
						valueXmlString.append("<sundry_code><![CDATA[").append(checkNull(rs.getString("sundry_code"))).append("]]></sundry_code>");
						valueXmlString.append("<status><![CDATA[").append(checkNull(rs.getString("status"))).append("]]></status>");
						valueXmlString.append("<exch_rate><![CDATA[").append(checkNull(rs.getString("exch_rate"))).append("]]></exch_rate>");
						valueXmlString.append("<amt_adj><![CDATA[").append(checkNull(rs.getString("amt_adj"))).append("]]></amt_adj>");
						valueXmlString.append("<site_code><![CDATA[").append(checkNull(rs.getString("site_code"))).append("]]></site_code>");
						valueXmlString.append("<bank_code><![CDATA[").append(checkNull(rs.getString("bank_code"))).append("]]></bank_code>");
						valueXmlString.append("</Detail>\r\n");

					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;



					System.out.println("valueXmlString of CallByItemChange(getXMLTransData) :"+valueXmlString);

				}
					/*pstmt = null;
						rs = null;*/
				} else if ("CallByManually".equalsIgnoreCase(callBy))
				{
					System.out.println("In CallByManually(getXMLTransData).....");

					if("Automatically".equalsIgnoreCase(reconcileType))
					{

						System.out.println("In Automatically reconcileType .....");
						System.out.println("autoReconFilter:"+autoReconFilter);
						rType ="A";

						System.out.println("xmlString(Automatically)!!!!!!! :"+stringBuffer.toString());
						System.out.println("siteCode:["+siteCode+"]......bankCode:["+bankCode+"]");

						if(!"REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter) &&  !"REFNO_AMT".equalsIgnoreCase(autoReconFilter))
						{
							valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
							valueXmlString = valueXmlString.append("<message>RFNDTAMT</message>");
							valueXmlString = valueXmlString.append("</Root>");
							System.out.println("valueXmlString :"+valueXmlString);
							return valueXmlString;
						}

						
						
						sql = "select bs.TRAN_ID tran_id,bs.REF_NO ref_no," +
								" to_char(bs.REF_DATE,'DD-MON-YY') ref_date," +
								" bs.REF_MODE ref_mode,bs.AMOUNT amount,bs.TRAN_TYPE tran_type," +
								" bs.EDI_REF EDI_REF_BS,bs.REMARKS remarks,bs.STAT_NO stat_no," +
								" to_char(bs.STAT_DATE,'DD-MON-YY') stat_date," +
								" bs.STATUS status," +
								" 0 as amt_adj," +
								//" bs.AMT_ADJ amt_adj," +
								" to_char(bs.EFF_DATE,'DD-MON-YY') eff_date," +
								" bs.DATE__FROM DATE__FROM_BS,bs.DATE__TO DATE__TO_BS," +
								" bs.STATUS_DATE STATUS_DATE_BS,bs.EXCH_RATE exch_rate,bs.CURR_CODE curr_code" +
								" from bank_statement bs where  bs.site_code=? and bs.bank_code=? and status in ('E', 'P')" ;
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,siteCode);
						pstmt.setString(2,bankCode);
						rs = pstmt.executeQuery();
						while(rs.next())
						{

							System.out.println("Bank Statement................");
							refNoBS = checkNull(rs.getString("ref_no"));
							System.out.println("refNoBS:"+refNoBS);
							refDateBS = checkNull(rs.getString("ref_date"));
							System.out.println("refDateBS :"+refDateBS);
							tranTypeBS = checkNull(rs.getString("tran_type"));
							System.out.println("tranTypeBS :"+tranTypeBS);
							currCodeBS = checkNull(rs.getString("curr_code"));
							System.out.println("currCodeBS :"+currCodeBS);
							tranIdBS = checkNull(rs.getString("tran_id"));
							System.out.println("tranIdBS :"+tranIdBS);
							amtBS = rs.getDouble("amount");
							System.out.println("amtBS :"+amtBS);
							amtAdjBS = rs.getDouble("amt_adj");
							System.out.println("amtAdjBS :"+amtAdjBS);
							refNoBS = refNoBS.trim();
							refDateBS = refDateBS.trim();
							System.out.println(":"+refNoBS.length());

							tempAmt = amtBS - amtAdjBS;
							
							System.out.println("tranTypeBS :["+tranTypeBS+"]tempAmt["+tempAmt+"]");
							


							/*---------combination for ref_no and  amount -------------------------*/
							if("REFNO_AMT".equalsIgnoreCase(autoReconFilter))	
							{			
								if(RefBSHashMapAuto.containsKey(refNoBS+":" +tempAmt))
								{
									ArrayList<String> tempArrayList = new ArrayList<String>();
									tempArrayList = RefBSHashMapAuto.put(refNoBS+":" +tempAmt,tempArrayList );
									tempArrayList.add(tranIdBS);
									RefBSHashMapAuto.put(refNoBS+":" +tempAmt,tempArrayList );
									System.out.println("@@@@@@@@@@@1 modify--> RefBSHashMapAuto["+RefBSHashMapAuto+"]");
								}
								else
								{
									ArrayList<String> tempArrayList = new ArrayList<String>();
									tempArrayList.add(tranIdBS);
									RefBSHashMapAuto.put(refNoBS+":" +tempAmt,tempArrayList );
									System.out.println("@@@@@@@@@@@2 added--> RefBSHashMapAuto["+RefBSHashMapAuto+"]");	
								
								}

							}
							//commented by azhar[start][12/10/16]
							/*if("REFNO_AMT".equalsIgnoreCase(autoReconFilter))	
							{	
								if(RefBSHashMap.containsKey(refNoBS))
								{
									RefBSHashMap.put(refNoBS,RefBSHashMap.get(refNoBS) + tempAmt);
									System.out.println("value will be :"+RefBSHashMap.get(refNoBS));
								}
								else
								{
									RefBSHashMap.put(refNoBS, tempAmt);
									//System.out.println("refSer !!!!!!!!!!!!!"+refSer);
									//System.out.println(siteCode+":"+refNoBS+":"+tranTypeBS);
									tranIdBSMap.put(""+":"+refNoBS, refSer);
									tranIdBSMap.put(""+"@"+refNoBS, tranIdBS);
									System.out.println("get value!!!!!!!!!!!!"+tranIdBSMap.get(""+":"+refNoBS));
								}

							}*/
							//commented by azhar[end][12/10/16]
							/*---------combination for ref_date and  amount -------------------------*/

							if("REFDATE_AMT".equalsIgnoreCase(autoReconFilter))	
							{		

								if(RefBSHashMap.containsKey(refDateBS))
								{
									RefBSHashMap.put(refDateBS,RefBSHashMap.get(refDateBS) + tempAmt);
									System.out.println("value will be :"+RefBSHashMap.get(refDateBS));
								}
								else
								{
									RefBSHashMap.put(refDateBS, tempAmt);
									//System.out.println("refSer !!!!!!!!!!!!!"+refSer);
									//System.out.println(siteCode+":"+refNoBS+":"+tranTypeBS);
									tranIdBSMap.put(""+":"+refDateBS, refSer);
									tranIdBSMap.put(""+"@"+refDateBS, tranIdBS);
									System.out.println("get value!!!!!!!!!!!!"+tranIdBSMap.get(""+":"+refDateBS));
								}

							}
							/*----------ref_no and ref_date and amount---------------------*/

							if("REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter))	
							{			
								if(RefBSHashMapAuto.containsKey(refNoBS+":"+refDateBS+":"+tempAmt+":"+tranTypeBS))
								{
									ArrayList<String> tempArrayList = new ArrayList<String>();
									tempArrayList = RefBSHashMapAuto.get(refNoBS+":"+refDateBS+":"+tempAmt+":"+tranTypeBS);
									tempArrayList.add(tranIdBS);
									RefBSHashMapAuto.put(refNoBS+":"+refDateBS+":"+tempAmt+":"+tranTypeBS, tempArrayList );
									System.out.println("@@@@@@@@@@@1 modify--> RefBSHashMapAuto["+RefBSHashMapAuto+"]");
								}
								else
								{/*
									RefBSHashMap.put(refNoBS+":"+refDateBS, tempAmt);
									//System.out.println("refSer !!!!!!!!!!!!!"+refSer);
									//System.out.println(siteCode+":"+refNoBS+":"+tranTypeBS);
									tranIdBSMap.put(""+":"+refNoBS+":"+refDateBS, refSer);
									tranIdBSMap.put(""+"@"+refNoBS+":"+refDateBS, tranIdBS);
									System.out.println("get value!!!!!!!!!!!!"+tranIdBSMap.get(""+":"+refDateBS));
								*/
									ArrayList<String> tempArrayList = new ArrayList<String>();
									//tempArrayList = RefBSHashMapAuto.get(refNoBS+":"+refDateBS+":"+tempAmt);
									tempArrayList.add(tranIdBS);
									RefBSHashMapAuto.put(refNoBS+":"+refDateBS+":"+tempAmt+":"+tranTypeBS, tempArrayList );
									System.out.println("@@@@@@@@@@@2 added--> RefBSHashMapAuto["+RefBSHashMapAuto+"]");	
								
								}

							}
							
							/*----------------------------------------------------------*/

							/*		

									if(RefBSHashMap.containsKey(refNoBS+":"+tranTypeBS))
									{

										if("REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBSHashMap.put(refNoBS+":"+refDateBS,RefBSHashMap.get(refNoBS+":"+refDateBS) + tempAmt);
										}
										else if("REFNO_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBSHashMap.put(refNoBS,RefBSHashMap.get(refNoBS) + tempAmt);
										}
										else if("REFDATE_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBSHashMap.put(refDateBS,RefBSHashMap.get(refDateBS) + tempAmt);
										}


										//RefBSHashMap.put(refNoBS+":"+tranTypeBS,RefBSHashMap.get(refNoBS+":"+tranTypeBS) + tempAmt);
										System.out.println("value will be :"+RefBSHashMap.get(refNoBS+":"+tranTypeBS));

									}
									else
									{

										if("REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBSHashMap.put(refNoBS+":"+refDateBS, tempAmt);
										}
										else if("REFNO_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBSHashMap.put(refNoBS, tempAmt);
										}
										else if("REFDATE_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBSHashMap.put(refDateBS, tempAmt);
										}

										//RefBSHashMap.put(refNoBS+":"+tranTypeBS, tempAmt);
									//	currBSMap.put(refNoBS+":"+tranTypeBS, currCodeBS);
										System.out.println("refSer !!!!!!!!!!!!!"+refSer);
										System.out.println(siteCode+":"+refNoBS+":"+tranTypeBS);
										//tranIdBSMap.put(siteCode+":"+refNoBS+":"+tranTypeBS, refSer);
										//tranIdBSMap.put(siteCode+"@"+refNoBS+"@"+tranTypeBS, tranIdBS);
										tranIdBSMap.put(""+":"+refNoBS, refSer);
										tranIdBSMap.put(""+"@"+refNoBS, tranIdBS);
										System.out.println("get value!!!!!!!!!!!!"+tranIdBSMap.get(""+":"+refNoBS));

									}*/

						}//end of while loop	
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;

						System.out.println("@@@@@@@ RefBSHashMap["+RefBSHashMap+"]");
						System.out.println("@@@@@@@ tranIdBSMap["+tranIdBSMap+"]");

						sql = 	" select bt.TRAN_ID tran_id," +
								" to_char(bt.TRAN_DATE,'DD-MON-YY') TRAN_DATE_BT," +
								" bt.TRAN_SER TRAN_SER_BT," +
								" bt.TRAN_NO TRAN_NO_BT,bt.REF_NO ref_no," +
								" to_char(bt.REF_DATE,'DD-MON-YY') ref_date," +
								" bt.REF_MODE ref_mode," +
								" bt.AMOUNT amount,bt.TRAN_TYPE tran_type,bt.ACCT_CODE acct_code," +
								" bt.CCTR_CODE cctr_code,bt.SUNDRY_CODE sundry_code,bt.STATUS status ," +
								" bt.REMARKS remarks," +
								" 0 as amt_adj," +
								//" bt.AMT_ADJ amt_adj," +
								" bt.SUNDRY_TYPE SUNDRY_TYPE_BT," +
								" bt.EXCH_RATE exch_rate,bt.CURR_CODE curr_code from " +
								" banktran_log bt where  " +
								" bt.site_code=? and bt.bank_code=? and status in ('E', 'P') ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,siteCode);
						pstmt.setString(2,bankCode);
						rs = pstmt.executeQuery();
						while(rs.next())
						{

							System.out.println("Bank Transaction........ ");
							refNoBT = checkNull(rs.getString("ref_no"));
							System.out.println("refNoBT :"+refNoBT);
							refDateBT = checkNull(rs.getString("ref_date"));
							System.out.println("refDateBT :"+refDateBT);
							currCodeBT= checkNull(rs.getString("curr_code"));
							System.out.println("currCodeBT :"+currCodeBT);
							tranIdBT = checkNull(rs.getString("tran_id"));
							System.out.println("tranIdBT :"+tranIdBT);
							tranTypeBT = checkNull(rs.getString("tran_type"));
							System.out.println("tranTypeBT :"+tranTypeBT);
							amtBT = rs.getDouble("amount");
							System.out.println("amtBT :"+amtBT);
							amtAdjBT = rs.getDouble("amt_adj");
							System.out.println("amtAdjBT :"+amtAdjBT);

							//tempAmt = dramt + cramt;
							tempAmt = amtBT - amtAdjBT;
							System.out.println("tempAmt >>>>"+tempAmt);

							System.out.println(refNoBT.length());
							refNoBT = refNoBT.trim();
							refDateBT = refDateBT.trim();
							System.out.println("@"+refNoBT.length());
							System.out.println("tranTypeBT :"+tranTypeBT);




							/*---------combination for ref_no and  amount -------------------------*/
							
							if("REFNO_AMT".equalsIgnoreCase(autoReconFilter))	
							{		
								if(RefBTHashMapAuto.containsKey(refNoBT+":"+tempAmt))
								{
									ArrayList<String> tempArrayList = new ArrayList<String>();
									tempArrayList = RefBTHashMapAuto.get(refNoBT+":"+tempAmt);
									tempArrayList.add(tranIdBT);
									RefBTHashMapAuto.put(refNoBT+":"+tempAmt, tempArrayList);
									System.out.println("@@@@@@@@@@4 modify RefBTHashMapAuto["+RefBTHashMapAuto+"]");
								}
								else
								{
									
									ArrayList<String> tempArrayList = new ArrayList<String>();
									tempArrayList.add(tranIdBT);
									RefBTHashMapAuto.put(refNoBT+":"+tempAmt, tempArrayList);
									System.out.println("@@@@@@@@@@5 added RefBTHashMapAuto["+RefBTHashMapAuto+"]");
								}

							}	
							
							//commented by azhar[START][12/10/16]
							/*if("REFNO_AMT".equalsIgnoreCase(autoReconFilter))	
							{			
								if(RefBTHashMap.containsKey(refNoBT))
								{
									RefBTHashMap.put(refNoBT,RefBTHashMap.get(refNoBT) + tempAmt);
									System.out.println("value will be :"+RefBTHashMap.get(refNoBT));
								}
								else
								{
									RefBTHashMap.put(refNoBT, tempAmt);
									//System.out.println("refSer !!!!!!!!!!!!!"+refSer);
									//System.out.println(siteCode+":"+refNoBS+":"+tranTypeBS);
									tranIdBTMap.put(""+":"+refNoBT, refSer);
									tranIdBTMap.put(""+"@"+refNoBT, tranIdBT);
									System.out.println("get value!!!!!!!!!!!!"+tranIdBTMap.get(""+":"+refNoBT));
								}

							}*/
							//commented by azhar[END][12/10/16]
							/*---------combination for ref_date and  amount -------------------------*/


							if("REFDATE_AMT".equalsIgnoreCase(autoReconFilter))	
							{
								refDateBT=refDateBT.trim();
								System.out.println("refDateBT"+refDateBT);
								System.out.println("tempAmt:"+tempAmt);
								if(RefBTHashMap.containsKey(refDateBT))
								{
									RefBTHashMap.put(refDateBT,RefBTHashMap.get(refDateBT) + tempAmt);
									System.out.println("value will be :"+RefBTHashMap.get(refDateBT));
								}
								else
								{
									RefBTHashMap.put(refDateBT, tempAmt);
									//System.out.println("refSer !!!!!!!!!!!!!"+refSer);
									//System.out.println(siteCode+":"+refNoBS+":"+tranTypeBS);
									tranIdBTMap.put(""+":"+refDateBT, refSer);
									tranIdBTMap.put(""+"@"+refDateBT, tranIdBT);
									System.out.println("get value!!!!!!!!!!!!"+tranIdBTMap.get(""+":"+refDateBT));
								}
							}
							/*----------ref_no and ref_date and amount---------------------*/

							if("REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter))	
							{		
								if(RefBTHashMapAuto.containsKey(refNoBT+":"+refDateBT+":"+tempAmt+":"+tranTypeBT))
								{
									ArrayList<String> tempArrayList = new ArrayList<String>();
									tempArrayList = RefBTHashMapAuto.get(refNoBT+":"+refDateBT+":"+tempAmt+":"+tranTypeBT);
									tempArrayList.add(tranIdBT);
									RefBTHashMapAuto.put(refNoBT+":"+refDateBT+":"+tempAmt+":"+tranTypeBT, tempArrayList);
									System.out.println("@@@@@@@@@@4 modify RefBTHashMapAuto["+RefBTHashMapAuto+"]");
								}
								else
								{
									/*RefBTHashMap.put(refNoBT+":"+refDateBT, tempAmt);
									//System.out.println("refSer !!!!!!!!!!!!!"+refSer);
									//System.out.println(siteCode+":"+refNoBS+":"+tranTypeBS);
									tranIdBSMap.put(""+":"+refNoBT+":"+refDateBT, refSer);
									tranIdBSMap.put(""+"@"+refNoBT+":"+refDateBT, tranIdBT);
									System.out.println("get value!!!!!!!!!!!!"+tranIdBSMap.get(""+":"+refDateBT));*/

									ArrayList<String> tempArrayList = new ArrayList<String>();
									//tempArrayList = RefBTHashMapAuto.get(refNoBT+":"+refDateBT+":"+tempAmt);
									tempArrayList.add(tranIdBT);
									RefBTHashMapAuto.put(refNoBT+":"+refDateBT+":"+tempAmt+":"+tranTypeBT, tempArrayList);
									System.out.println("@@@@@@@@@@5 added RefBTHashMapAuto["+RefBTHashMapAuto+"]");
								}

							}	
							
							/*----------------------------------------------------------*/

							/*	
									if(RefBTHashMap.containsKey(refNoBT+":"+tranTypeBT))
									{

										if("REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBTHashMap.put(refNoBT+":"+refDateBT,RefBTHashMap.get(refNoBT+":"+refDateBT) + tempAmt);
										}
										else if("REFNO_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBTHashMap.put(refNoBT,RefBTHashMap.get(refNoBT) + tempAmt);
										}
										else if("REFDATE_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBTHashMap.put(refDateBT,RefBTHashMap.get(refDateBT) + tempAmt);
										}


										//RefBTHashMap.put(refNoBT+":"+tranTypeBT,RefBTHashMap.get(refNoBT+":"+tranTypeBT) + tempAmt);
										System.out.println("value in bill :"+RefBTHashMap.get(refNoBT+":"+tranTypeBT));
									}
									else
									{

										if("REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBTHashMap.put(refNoBT+":"+refDateBT, tempAmt);
										}
										else if("REFNO_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBTHashMap.put(refNoBT, tempAmt);
										}
										else if("REFDATE_AMT".equalsIgnoreCase(autoReconFilter))
										{
											RefBTHashMap.put(refDateBT, tempAmt);
										}

										//RefBTHashMap.put(refNoBT+":"+tranTypeBT, tempAmt);
										tranIdBTMap.put(""+":"+refNoBT, refSer);
										tranIdBTMap.put(""+"@"+refNoBT, tranIdBT);
									//	currBTMap.put(refNoBT+":"+tranTypeBT, currCodeBT);
									}
							 */	

						}//end while loop
						rs.close();
						rs=null;
						pstmt.close();
						pstmt=null;	

						System.out.println("@@@@@@@@@@@1 final--> RefBSHashMapAuto["+RefBSHashMapAuto+"]");
						System.out.println("@@@@@@@@@@@2 final--> RefBTHashMapAuto["+RefBTHashMapAuto+"]");
						
						//System.out.println("@@@@@@@ RefBTHashMap["+RefBTHashMap+"]");
						//System.out.println("@@@@@@@ tranIdBSMap["+tranIdBSMap+"]");

						//System.out.println("RefBSHashMap @@@@..... :"+RefBSHashMap);
						//System.out.println("RefBTHashMap.@@@@.... :"+RefBTHashMap);
						Iterator<Map.Entry<String,ArrayList<String>>> entries = RefBSHashMapAuto.entrySet().iterator();
						while (entries.hasNext()) 
						{
							Map.Entry<String,ArrayList<String>> entry = entries.next();
							System.out.println("key are :"+entry.getKey());
							if(RefBSHashMapAuto.containsKey(entry.getKey()))
							{
								System.out.println("@@@@@@@@@@@ RefBSHashMapAuto["+entry.getKey()+"]");
								ArrayList<String> tempBSArrayList = new ArrayList<String>();
								tempBSArrayList = RefBSHashMapAuto.get(entry.getKey());
								System.out.println("RefBTHashMapAuto tempBSArrayList:::["+tempBSArrayList+"]tempBSArrayList.size()["+tempBSArrayList.size()+"]");
								
								for(int BSctr=0 ; BSctr < tempBSArrayList.size() ; BSctr++  )
								{
									//Boolean breakFlag = false;
									if(RefBTHashMapAuto.containsKey(entry.getKey()) )
									{
									
										ArrayList<String> tempBTArrayList = new ArrayList<String>();
										tempBTArrayList = RefBTHashMapAuto.get(entry.getKey());
									
										if( tempBTArrayList.size() > 0  )
										{
											tranIdBSList.add(tempBSArrayList.get(BSctr));
											tranIdBTList.add(tempBTArrayList.get(0));
											
											System.out.println("@@@@@@@@@@@@@ match found==>[tempBSArrayList"+tempBSArrayList.get(0)+"]tempBTArrayList["+tempBTArrayList.get(0)+"]");
											
											tempBTArrayList.remove(0);
											RefBTHashMapAuto.put(entry.getKey(),tempBTArrayList);
											
										//	breakFlag = true;;
										}
									}
								}
									
							}		
						}			
						//		double rAmt = RefBTHashMap.get(entry.getKey());
						//		System.out.println("rAmt :::"+rAmt);
								/*String  currCdBS = currBSMap.get(entry.getKey());
									System.out.println("currCdBS :::"+currCdBS);
									String  currCdBT = currBTMap.get(entry.getKey());
									System.out.println("currCdBT :::"+currCdBT);*/
						/*		bankStmtMap.put("" +":"+entry.getKey(), lAmt);
								System.out.println("bankStmtMap is :"+bankStmtMap);
								bankTntMap.put("" +":"+entry.getKey(), rAmt);
								System.out.println("reseiverSiteMap is :"+bankTntMap);
								//if(lAmt == rAmt && currCdBS.equalsIgnoreCase(currCdBT))
								if(lAmt == rAmt)
								{
									System.out.println("amount is match (Automatic)!!!!!");
									//arrayListData =  buildTraceDataHM(bankStmtMap,bankTntMap,siteCode,siteCode,rType,tranIdBSMap,tranIdBTMap,autoReconFilter);
									//System.out.println("arrayListData!!!"+arrayListData);

									System.out.println("key are!!! :"+entry.getKey());
									tranIdBSList=listOfTranId(entry.getKey(),"bank_statement",autoReconFilter,siteCode,bankCode,conn);
									System.out.println("tranIdBSList :"+tranIdBSList);
									tranIdBTList=listOfTranId(entry.getKey(),"banktran_log",autoReconFilter,siteCode,bankCode,conn);
									System.out.println("tranIdBTList :"+tranIdBTList);
									///////////////////////////////////////////////////////////////////////////
									System.out.println("tranIdBSList.size()["+tranIdBSList.size()+"]tranIdBSList["+tranIdBSList+"]");
									System.out.println("tranIdBTList.size()["+tranIdBTList.size()+"]tranIdBTList["+tranIdBTList+"]");
									if(tranIdBSList.size() > 1 && tranIdBTList.size() == 1)
									{
										for(int i = 0 ; i < tranIdBSList.size() ; i++)
										{
											ArrayList traceData = null;
											traceData = new ArrayList();
											System.out.println("multiple bank statement");
											System.out.println(tranIdBSList.get(i));
											System.out.println(tranIdBTList.get(0));
											//							System.out.println(amtList.get(i));
											double amtTemp = getReconcileAmount("bank_statement",tranIdBSList.get(i),conn);

											traceData.add(tranIdBTList.get(0));
											traceData.add(tranIdBSList.get(i));
											traceData.add(amtTemp);
											//traceData.add(lAmt);
											arrayListData.add(traceData);
										}
									}
									if(tranIdBTList.size() > 1 && tranIdBSList.size() == 1)
									{
										for(int i = 0 ; i < tranIdBTList.size() ; i++)
										{
											System.out.println("before :"+arrayListData);
											System.out.println(i);

											ArrayList traceData = null;
											traceData = new ArrayList();
											System.out.println("multiple bank transcation!!!");
											System.out.println(tranIdBSList.get(0));
											System.out.println(tranIdBTList.get(i));
											//System.out.println(amtList.get(i));
											double amtTemp = getReconcileAmount("banktran_log",tranIdBTList.get(i),conn);

											traceData.add(tranIdBTList.get(i));
											traceData.add(tranIdBSList.get(0));
											traceData.add(amtTemp);
											//traceData.add(lAmt);
											arrayListData.add(traceData);
											System.out.println("after :"+arrayListData);
										}
										System.out.println("after for loop :"+arrayListData);
									}
									if(tranIdBTList.size() == 1 && tranIdBSList.size() == 1)
									{
										ArrayList traceData = null;
										traceData = new ArrayList();
										System.out.println("single transaction");
										System.out.println(tranIdBSList.get(0));
										System.out.println(tranIdBTList.get(0));
										//System.out.println(amtList.get(0));
										traceData.add(tranIdBTList.get(0));
										traceData.add(tranIdBSList.get(0));
										traceData.add(lAmt);
										arrayListData.add(traceData);
									}
								*/
						System.out.println("@@@@@@@@@@ final list tranIdBSList.size["+tranIdBSList.size()+"]tranIdBSList["+tranIdBSList+"]");
						System.out.println("@@@@@@@@@@ final list tranIdBTList.size["+tranIdBTList.size()+"]tranIdBTList["+tranIdBTList+"]");

						//cpatil for multiple BS and BT
									if(tranIdBSList.size() >= 1 && tranIdBTList.size() >= 1 )
									{
										for(int i = 0 ; i < tranIdBSList.size() ; i++)
										{
											ArrayList traceData = null;
											traceData = new ArrayList();
											System.out.println("multiple bank statement");
											System.out.println(tranIdBSList.get(i));
											System.out.println(tranIdBTList.get(i));
											//							System.out.println(amtList.get(i));
											double amtTemp = getReconcileAmount("banktran_log",tranIdBTList.get(i),conn);
											System.out.println("@@@@@@@@@@  etst amount amtTemp["+amtTemp+"]");
											traceData.add(tranIdBTList.get(i));
											traceData.add(tranIdBSList.get(i));
											traceData.add(amtTemp);
											//traceData.add(lAmt);
											arrayListData.add(traceData);
										}
									}

									////////////////////////////////////////////////////////////////////	
								//}
							//}
						//}

					}
					else if("Manually".equalsIgnoreCase(reconcileType))
					{
						String refNOBS="",statusBS="",statusBT="";
						System.out.println("In Manually...............autoReconFilter["+autoReconFilter+"]");
						isReconcile=false;
						rType ="M";
						System.out.println("xmlString(Manually) :"+stringBuffer.toString());
						dom = genericUtility.parseString(stringBuffer.toString());
						NodeList nList = dom.getElementsByTagName("Detail");
						System.out.println("nList :"+nList);
						System.out.println("nList.getLength() : "+nList.getLength());
						int bankStmtCnt = 0 , bankTrntCnt = 0;
						double paymentAmtBS=0, paymentAmtBT=0,receiptAmtBS=0,receiptAmtBT=0; // cpatil
						double calAmtBS=0, calAmtBT=0;

						for (int temp = 0; temp < nList.getLength(); temp++)
						{
							Node nNode = nList.item(temp);
							Element eElement = (Element) nNode;

							tranName = checkNull(eElement.getElementsByTagName("tran_name").item(0).getTextContent());
							System.out.println("tranName["+tranName+"]");

							if(tranName.equalsIgnoreCase("bankStatement")) 
							{
								bankStmtCnt++;
								//totalBSAmount = totalBSAmount + Double.parseDouble(amtBc); //amtAdj
							}
							if(tranName.equalsIgnoreCase("bankTransaction"))
							{
								bankTrntCnt++;
								//totalBTAmount = totalBTAmount + Double.parseDouble(amtBc);
							}
						}
						System.out.println("bankStmtCnt["+bankStmtCnt+"]bankTrntCnt["+bankTrntCnt+"]");

						for (int temp = 0; temp < nList.getLength(); temp++)
						{
							Node nNode = nList.item(temp);
							Element eElement = (Element) nNode;

							tranName = checkNull(eElement.getElementsByTagName("tran_name").item(0).getTextContent());
							System.out.println("tranName["+tranName+"]");



							//cpatil 09/03/16 start
							refNo = checkNull(eElement.getElementsByTagName("ref_no").item(0).getTextContent()).trim();
							refDate = checkNull(eElement.getElementsByTagName("ref_date").item(0).getTextContent()).trim();
							amtAdj = checkNull(eElement.getElementsByTagName("amt_adj").item(0).getTextContent()).trim();
							amtBc = checkNull(eElement.getElementsByTagName("amt_bc").item(0).getTextContent()).trim();
							System.out.println("temp["+temp+"]---refNo["+refNo+"]refDate["+refDate+"]amtAdj["+amtAdj+"]");
							System.out.println("autoReconFilterValue["+autoReconFilterValue+"]refNo+refDate+amtAdj["+""+refNo+refDate+amtAdj+"]");


							if( autoReconFilterValue != null && autoReconFilterValue.trim().length() > 0 )
							{
								if( "REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter) && ( bankStmtCnt==1 || bankTrntCnt == 1 ))
								{
									System.out.println("@@@@:REFNO_DATE_AMT:autoReconFilterValue["+autoReconFilterValue+"]refNo+refDate["+refNo+refDate+"]");
									if(!autoReconFilterValue.equalsIgnoreCase(refNo+refDate))
									{
										valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
										valueXmlString = valueXmlString.append("<message>KEYNTMATCH</message>");
										valueXmlString = valueXmlString.append("</Root>");
										System.out.println("valueXmlString:REFNO_DATE_AMT:"+valueXmlString);
										return valueXmlString;
									}
								}
								else if("REFNO_DATE".equalsIgnoreCase(autoReconFilter)  && (autoReconFilterValue != null && autoReconFilterValue.trim().length() > 0 ) && ( bankStmtCnt==1 || bankTrntCnt == 1 ))
								{  // not include
									System.out.println("@@@@:REFNO_DATE:autoReconFilterValue["+autoReconFilterValue+"]refNo+refDate["+refNo+refDate+"]");
									if(!autoReconFilterValue.equalsIgnoreCase(refNo+refDate))
									{
										valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
										valueXmlString = valueXmlString.append("<message>KEYNTMATCH</message>");
										valueXmlString = valueXmlString.append("</Root>");
										System.out.println("valueXmlString:REFNO_DATE:"+valueXmlString);
										return valueXmlString;
									}
								}
								else if("REFDATE_AMT".equalsIgnoreCase(autoReconFilter) && (autoReconFilterValue != null && autoReconFilterValue.trim().length() > 0 ) && ( bankStmtCnt==1 || bankTrntCnt == 1 ))
								{
									System.out.println("@@@@:REFDATE_AMT:autoReconFilterValue["+autoReconFilterValue+"]refDate["+refDate+"]");
									if(!autoReconFilterValue.equalsIgnoreCase(refDate))
									{
										valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
										valueXmlString = valueXmlString.append("<message>KEYNTMATCH</message>");
										valueXmlString = valueXmlString.append("</Root>");
										System.out.println("valueXmlString:DATE_AMT:"+valueXmlString);
										return valueXmlString;
									}
								}
								else if("REFNO_AMT".equalsIgnoreCase(autoReconFilter)  && (autoReconFilterValue != null && autoReconFilterValue.trim().length() > 0 ) && ( bankStmtCnt==1 || bankTrntCnt == 1 ))
								{
									System.out.println("@@@@:REFNO_AMT:autoReconFilterValue["+autoReconFilterValue+"]refNo["+refNo+"]");
									if(!autoReconFilterValue.equalsIgnoreCase(refNo))
									{
										valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
										valueXmlString = valueXmlString.append("<message>KEYNTMATCH</message>");
										valueXmlString = valueXmlString.append("</Root>");
										System.out.println("valueXmlString:REFNO_AMT:"+valueXmlString);
										return valueXmlString;
									}
								}
								
								/*else if("AMT".equalsIgnoreCase(autoReconFilter)  && (autoReconFilterValue != null && autoReconFilterValue.trim().length() > 0 ) && ( bankStmtCnt==1 || bankTrntCnt == 1 ))
								{
									System.out.println("@@@@:AMT:autoReconFilterValue["+autoReconFilterValue+"]amt["+amtBc+"]");
									if(!autoReconFilterValue.equalsIgnoreCase(amtBc))
									{
										valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
										valueXmlString = valueXmlString.append("<message>KEYNTMATCH</message>");
										valueXmlString = valueXmlString.append("</Root>");
										System.out.println("valueXmlString:AMT:"+valueXmlString);
										return valueXmlString;
									}
								}*/
							}

							if("REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter)  && (autoReconFilterValue == null || autoReconFilterValue.trim().length()==0 ))
							{
								//autoReconFilterValue = ""+refNo+refDate+amtAdj;
								autoReconFilterValue = refNo+refDate;
							}
							else if("REFNO_DATE".equalsIgnoreCase(autoReconFilter)  && (autoReconFilterValue == null || autoReconFilterValue.trim().length()==0 ))
							{
								autoReconFilterValue = refNo+refDate;
							}
							else if("REFDATE_AMT".equalsIgnoreCase(autoReconFilter) && (autoReconFilterValue == null || autoReconFilterValue.trim().length()==0 ) )
							{
								//autoReconFilterValue = ""+refDate+amtAdj;
								autoReconFilterValue = refDate;
							}
							else if("REFNO_AMT".equalsIgnoreCase(autoReconFilter)  && (autoReconFilterValue == null || autoReconFilterValue.trim().length()==0 ))
							{
								//autoReconFilterValue = ""+refNo+amtAdj;
								autoReconFilterValue = refNo;
							}
							else if("AMT".equalsIgnoreCase(autoReconFilter)  && (autoReconFilterValue == null || autoReconFilterValue.trim().length()==0 ))
							{
								//autoReconFilterValue = ""+refNo+amtAdj;
								autoReconFilterValue = amtBc;
							}

							// end
							if(tranName.equalsIgnoreCase("bankStatement")) 
							{
								//	bankStmtCnt++;
								totalBSAmount = totalBSAmount + Double.parseDouble(amtBc); //amtAdj
							}
							if(tranName.equalsIgnoreCase("bankTransaction"))
							{
								//	bankTrntCnt++;
								totalBTAmount = totalBTAmount + Double.parseDouble(amtBc);
							}

						}

						System.out.println("@@@@@@@@@ totalBSAmount["+totalBSAmount+"]:::::totalBTAmount["+totalBTAmount+"]");

						if(totalBSAmount != totalBTAmount)
						{
							valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
							valueXmlString = valueXmlString.append("<message>AMTNTMATCH</message>");
							valueXmlString = valueXmlString.append("</Root>");
							System.out.println("valueXmlString:amount not match:"+valueXmlString);
							return valueXmlString;
						}

						/* valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
							valueXmlString = valueXmlString.append("<message>Success</message>");
							valueXmlString = valueXmlString.append("</Root>");
							System.out.println("valueXmlString :"+valueXmlString);*/  

						System.out.println("bankStmtCnt:["+bankStmtCnt+"]:::::bankTrntCnt:["+bankTrntCnt+"]");

						if(bankStmtCnt == 0 && bankTrntCnt == 0)
						{
							valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
							valueXmlString = valueXmlString.append("<message>NOSELBOTH</message>");
							valueXmlString = valueXmlString.append("</Root>");
							System.out.println("valueXmlString :"+valueXmlString);
							return valueXmlString;

						}
						if(bankStmtCnt == 0 && bankTrntCnt > 0)
						{
							valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
							valueXmlString = valueXmlString.append("<message>NOSELBS</message>");
							valueXmlString = valueXmlString.append("</Root>");
							System.out.println("valueXmlString :"+valueXmlString);
							return valueXmlString;
						}
						if(bankStmtCnt > 0 && bankTrntCnt == 0)
						{
							valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
							valueXmlString = valueXmlString.append("<message>NOSELBT</message>");
							valueXmlString = valueXmlString.append("</Root>");
							System.out.println("valueXmlString :"+valueXmlString);
							return valueXmlString;
						}




						/*---------Single Bank Statement and Multiple Bank Transacion------------------------*/

						if(bankStmtCnt == 1 && bankTrntCnt > 1)
						{
							System.out.println("Single Bank Statement and Multiple Bank Transacion");
							for (int temp = 0; temp < nList.getLength(); temp++)
							{
								Node nNode = nList.item(temp);
								Element eElement = (Element) nNode;
								tranName = checkNull(eElement.getElementsByTagName("tran_name").item(0).getTextContent());


								if(tranName.equalsIgnoreCase("bankStatement")) 
								{
									refNOBS = checkNull(eElement.getElementsByTagName("ref_no").item(0).getTextContent());
									System.out.println("refNOBS :"+refNOBS);
									refDateBS = checkNull(eElement.getElementsByTagName("ref_date").item(0).getTextContent());
									System.out.println("refDateBS :"+refDateBS);
									tranTypeBS = checkNull(eElement.getElementsByTagName("tran_type").item(0).getTextContent());
									System.out.println("tranTypeBS :"+tranTypeBS);
									statusBS = checkNull(eElement.getElementsByTagName("status").item(0).getTextContent());
									System.out.println("statusBS :"+statusBS);
									tranIdBS = checkNull(eElement.getElementsByTagName("tran_id").item(0).getTextContent());
									System.out.println("tranIdBS :"+tranIdBS);
									currCodeBS = checkNull(eElement.getElementsByTagName("curr_code").item(0).getTextContent());
									System.out.println("currCodeBS :"+currCodeBS);
									amtAdjBS = Double.parseDouble(eElement.getElementsByTagName("amt_adj").item(0).getTextContent());
									System.out.println("amtAdjBS :"+amtAdjBS);
									amtBS = Double.parseDouble(eElement.getElementsByTagName("amt_bs").item(0).getTextContent());
									System.out.println("amtBS :"+amtBS);
									tempAmtBS = amtBS - amtAdjBS;

									System.out.println("tempAmtBS in bank statement :"+tempAmtBS);
									currSet.add(currCodeBS);

									tranIdBSList.add(tranIdBS.trim());
									//amtList.add(tempAmtBS);

								}//end of bankStatement
								if(tranName.equalsIgnoreCase("bankTransaction"))
								{
									System.out.println("bankTransaction(Manually)");
									refNoBT = checkNull(eElement.getElementsByTagName("ref_no").item(0).getTextContent());
									System.out.println("refNoBT :"+refNoBT);
									refDateBT = checkNull(eElement.getElementsByTagName("ref_date").item(0).getTextContent());
									System.out.println("refDateBT :"+refDateBT);
									tranTypeBT = checkNull(eElement.getElementsByTagName("tran_type").item(0).getTextContent());
									System.out.println("tranTypeBT :"+tranTypeBT);
									tranIdBT = checkNull(eElement.getElementsByTagName("tran_id").item(0).getTextContent());
									System.out.println("tranIdBT :"+tranIdBT);
									currCodeBT = checkNull(eElement.getElementsByTagName("curr_code").item(0).getTextContent());
									System.out.println("currCodeBT :"+currCodeBT);
									statusBT = checkNull(eElement.getElementsByTagName("status").item(0).getTextContent());
									System.out.println("statusBT :"+statusBT);
									amtAdjBT = Double.parseDouble(eElement.getElementsByTagName("amt_adj").item(0).getTextContent());
									System.out.println("amtAdjBT :"+amtAdjBT);
									amtBT = Double.parseDouble(eElement.getElementsByTagName("amt_bt").item(0).getTextContent());
									System.out.println("amtBT :"+amtBT);

									tempAmtBT = amtBT - amtAdjBT;
									System.out.println("tempAmt in nbankTransaction!!!!! :"+tempAmt);

									tranIdBTList.add(tranIdBT.trim());
									amtList.add(tempAmtBT);

									currSet.add(currCodeBT);
									if(tranTypeBT.equalsIgnoreCase("P"))
									{
										paymentAmt = paymentAmt + tempAmtBT;
									}
									else if(tranTypeBT.equalsIgnoreCase("R"))
									{
										receiptAmt  = receiptAmt + tempAmtBT;
									}


								}//end of bankTransaction



							}///end of for loop\

							System.out.println("paymentAmt :"+paymentAmt);
							System.out.println("receiptAmt :"+receiptAmt);
							System.out.println("tranTypeBS :"+tranTypeBS);
							if(tranTypeBS.equalsIgnoreCase("P"))
							{
								calAmt = paymentAmt - receiptAmt;
							}
							else if(tranTypeBS.equalsIgnoreCase("R"))
							{
								calAmt = receiptAmt - paymentAmt;
							}
							System.out.println("calAmt :"+calAmt);
							System.out.println("tempAmtBS :"+tempAmtBS);

							if(calAmt == tempAmtBS && currSet.size() == 1)
							{
								isReconcile = true;
								System.out.println(isReconcile);
							}
							System.out.println("isReconcile(end of for loop: multiple bank Transaction:"+isReconcile);	

						}//end of bankStmtCnt == 1 && bankTrntCnt > 1



						/*------------------Multiple Bank Statement and Single Bank Transacion-------------------------*/
						if(bankStmtCnt > 1 && bankTrntCnt == 1)
						{
							System.out.println("Multiple Bank Statement and Single Bank Transacion");
							for (int temp = 0; temp < nList.getLength(); temp++)
							{
								Node nNode = nList.item(temp);
								Element eElement = (Element) nNode;
								tranName = checkNull(eElement.getElementsByTagName("tran_name").item(0).getTextContent());


								if(tranName.equalsIgnoreCase("bankStatement")) 
								{
									refNOBS = checkNull(eElement.getElementsByTagName("ref_no").item(0).getTextContent());
									System.out.println("refNOBS :"+refNOBS);
									refDateBS = checkNull(eElement.getElementsByTagName("ref_date").item(0).getTextContent());
									System.out.println("refDateBS :"+refDateBS);
									tranTypeBS = checkNull(eElement.getElementsByTagName("tran_type").item(0).getTextContent());
									System.out.println("tranTypeBS :"+tranTypeBS);
									statusBS = checkNull(eElement.getElementsByTagName("status").item(0).getTextContent());
									System.out.println("statusBS :"+statusBS);
									tranIdBS = checkNull(eElement.getElementsByTagName("tran_id").item(0).getTextContent());
									System.out.println("tranIdBS :"+tranIdBS);
									currCodeBS = checkNull(eElement.getElementsByTagName("curr_code").item(0).getTextContent());
									System.out.println("currCodeBS :"+currCodeBS);
									amtAdjBS = Double.parseDouble(eElement.getElementsByTagName("amt_adj").item(0).getTextContent());
									System.out.println("amtAdjBS :"+amtAdjBS);
									amtBS = Double.parseDouble(eElement.getElementsByTagName("amt_bs").item(0).getTextContent());
									System.out.println("amtBS :"+amtBS);
									tempAmtBS = amtBS - amtAdjBS;
									tranIdBSList.add(tranIdBS.trim());
									amtList.add(tempAmtBS);
									System.out.println("tempAmtBS :"+tempAmtBS);

									currSet.add(currCodeBS);

									if(tranTypeBS.equalsIgnoreCase("P"))
									{
										paymentAmt = paymentAmt + tempAmtBS;
									}
									else if(tranTypeBS.equalsIgnoreCase("R"))
									{
										receiptAmt  = receiptAmt + tempAmtBS;
									}


									System.out.println("paymentAmt :"+paymentAmt);
									System.out.println("receiptAmt :"+receiptAmt);
									
								}//end of bankStatement
								if(tranName.equalsIgnoreCase("bankTransaction"))
								{
									System.out.println("bankTransaction(Manually)");
									refNoBT = checkNull(eElement.getElementsByTagName("ref_no").item(0).getTextContent());
									System.out.println("refNoBT :"+refNoBT);
									refDateBT = checkNull(eElement.getElementsByTagName("ref_date").item(0).getTextContent());
									System.out.println("refDateBT :"+refDateBT);
									tranTypeBT = checkNull(eElement.getElementsByTagName("tran_type").item(0).getTextContent());
									System.out.println("tranTypeBT :"+tranTypeBT);
									tranIdBT = checkNull(eElement.getElementsByTagName("tran_id").item(0).getTextContent());
									System.out.println("tranIdBT :"+tranIdBT);
									currCodeBT = checkNull(eElement.getElementsByTagName("curr_code").item(0).getTextContent());
									System.out.println("currCodeBT :"+currCodeBT);
									statusBT = checkNull(eElement.getElementsByTagName("status").item(0).getTextContent());
									System.out.println("statusBT :"+statusBT);
									amtAdjBT = Double.parseDouble(eElement.getElementsByTagName("amt_adj").item(0).getTextContent());
									System.out.println("amtAdjBT :"+amtAdjBT);
									amtBT = Double.parseDouble(eElement.getElementsByTagName("amt_bt").item(0).getTextContent());
									System.out.println("amtBT :"+amtBT);

									tempAmtBT = amtBT - amtAdjBT;
									System.out.println("tempAmt :"+tempAmt);
									tranIdBTList.add(tranIdBT.trim());
									//	amtList.add(tempAmtBT);
									currSet.add(currCodeBT);


								

								System.out.println("tranTypeBT!!!! :"+tranTypeBT);

								if(tranTypeBT.equalsIgnoreCase("P"))
								{
									calAmt = paymentAmt - receiptAmt;
									System.out.println("calAmt(P)"+calAmt);
								}
								else if(tranTypeBT.equalsIgnoreCase("R"))
								{
									calAmt = receiptAmt - paymentAmt;
									System.out.println("calAmt(R)"+calAmt);
								}
								System.out.println("calAmt :"+calAmt);
								System.out.println("tempAmtBT :"+tempAmtBT);
								System.out.println("currSet size :"+currSet.size());

								if(calAmt == tempAmtBT && calAmt != 0 && currSet.size() == 1)
								{
									isReconcile = true;
									System.out.println(isReconcile);
								}
								System.out.println("isReconcile^"+isReconcile);
								
								}//end of bankTransaction

							}//end of for loop
							System.out.println("isReconcile(end of for loop: multiple bank Statement:"+isReconcile);
						}

						if(bankStmtCnt == 1 && bankTrntCnt == 1)
						{
							System.out.println("Single Bank Statement and Single Bank Transacion");
							for (int temp = 0; temp < nList.getLength(); temp++)
							{
								Node nNode = nList.item(temp);
								Element eElement = (Element) nNode;
								tranName = checkNull(eElement.getElementsByTagName("tran_name").item(0).getTextContent());


								if(tranName.equalsIgnoreCase("bankStatement")) 
								{
									refNOBS = checkNull(eElement.getElementsByTagName("ref_no").item(0).getTextContent());
									System.out.println("refNOBS :"+refNOBS);
									refDateBS = checkNull(eElement.getElementsByTagName("ref_date").item(0).getTextContent());
									System.out.println("refDateBS :"+refDateBS);
									tranTypeBS = checkNull(eElement.getElementsByTagName("tran_type").item(0).getTextContent());
									System.out.println("tranTypeBS :"+tranTypeBS);
									statusBS = checkNull(eElement.getElementsByTagName("status").item(0).getTextContent());
									System.out.println("statusBS :"+statusBS);
									tranIdBS = checkNull(eElement.getElementsByTagName("tran_id").item(0).getTextContent());
									System.out.println("tranIdBS :"+tranIdBS);
									currCodeBS = checkNull(eElement.getElementsByTagName("curr_code").item(0).getTextContent());
									System.out.println("currCodeBS :"+currCodeBS);
									amtAdjBS = Double.parseDouble(eElement.getElementsByTagName("amt_adj").item(0).getTextContent());
									System.out.println("amtAdjBS :"+amtAdjBS);
									amtBS = Double.parseDouble(eElement.getElementsByTagName("amt_bs").item(0).getTextContent());

									tempAmtBS = amtBS - amtAdjBS;
									tranIdBSList.add(tranIdBS.trim());
									amtList.add(tempAmtBS);

									currSet.add(currCodeBS);

								}//end of bankStatement
								if(tranName.equalsIgnoreCase("bankTransaction"))
								{
									System.out.println("bankTransaction(Manually)");
									refNoBT = checkNull(eElement.getElementsByTagName("ref_no").item(0).getTextContent());
									System.out.println("refNoBT :"+refNoBT);
									refDateBT = checkNull(eElement.getElementsByTagName("ref_date").item(0).getTextContent());
									System.out.println("refDateBT :"+refDateBT);
									tranTypeBT = checkNull(eElement.getElementsByTagName("tran_type").item(0).getTextContent());
									System.out.println("tranTypeBT :"+tranTypeBT);
									tranIdBT = checkNull(eElement.getElementsByTagName("tran_id").item(0).getTextContent());
									System.out.println("tranIdBT :"+tranIdBT);
									currCodeBT = checkNull(eElement.getElementsByTagName("curr_code").item(0).getTextContent());
									System.out.println("currCodeBT :"+currCodeBT);
									statusBT = checkNull(eElement.getElementsByTagName("status").item(0).getTextContent());
									System.out.println("statusBT :"+statusBT);
									amtAdjBT = Double.parseDouble(eElement.getElementsByTagName("amt_adj").item(0).getTextContent());
									System.out.println("amtAdjBT :"+amtAdjBT);


									amtBT = Double.parseDouble(eElement.getElementsByTagName("amt_bt").item(0).getTextContent());
									System.out.println("amtBT :"+amtBT);

									tempAmtBT = amtBT - amtAdjBT;
									System.out.println("tempAmt :"+tempAmt);
									tranIdBTList.add(tranIdBT.trim());

									currSet.add(currCodeBT);

								}//end of bankTransaction


								if(tranTypeBT.equalsIgnoreCase(tranTypeBS))
								{
									System.out.println("tempAmtBT :"+tempAmtBT);
									System.out.println("tempAmtBS :"+tempAmtBS);

									if(tempAmtBT == tempAmtBS && currSet.size() == 1)
									{
										isReconcile = true;
									}

								}

							}//end of for loop

							System.out.println("isReconcile(end of for loop: single bank Transaction and statement!!:"+isReconcile);	



						}

						// added by cpatil on 10/03/16 for multiple BS & BT  //pending

						if( bankStmtCnt > 1 && bankTrntCnt > 1  )
						{
							if(!"REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter) )
							{
								valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
								valueXmlString = valueXmlString.append("<message>RFNDTAMT</message>");
								valueXmlString = valueXmlString.append("</Root>");
								System.out.println("valueXmlString :"+valueXmlString);
								return valueXmlString;
							}

							System.out.println("..............Multiple Bank Statement and Multiple Bank Transacion....autoReconFilter["+autoReconFilter+"]");
							for (int temp = 0; temp < nList.getLength(); temp++)
							{
								Node nNode = nList.item(temp);
								Element eElement = (Element) nNode;
								tranName = checkNull(eElement.getElementsByTagName("tran_name").item(0).getTextContent());

								if(tranName.equalsIgnoreCase("bankStatement")) 
								{
									System.out.println("bankStatement(Manually)");
									refNOBS = checkNull(eElement.getElementsByTagName("ref_no").item(0).getTextContent());
									System.out.println("refNOBS :"+refNOBS);
									refDateBS = checkNull(eElement.getElementsByTagName("ref_date").item(0).getTextContent());
									System.out.println("refDateBS :"+refDateBS);
									tranTypeBS = checkNull(eElement.getElementsByTagName("tran_type").item(0).getTextContent());
									System.out.println("tranTypeBS :"+tranTypeBS);
									statusBS = checkNull(eElement.getElementsByTagName("status").item(0).getTextContent());
									System.out.println("statusBS :"+statusBS);
									tranIdBS = checkNull(eElement.getElementsByTagName("tran_id").item(0).getTextContent());
									System.out.println("tranIdBS :"+tranIdBS);
									currCodeBS = checkNull(eElement.getElementsByTagName("curr_code").item(0).getTextContent());
									System.out.println("currCodeBS :"+currCodeBS);
									amtAdjBS = Double.parseDouble(eElement.getElementsByTagName("amt_adj").item(0).getTextContent());
									System.out.println("amtAdjBS :"+amtAdjBS);
									amtBS = Double.parseDouble(eElement.getElementsByTagName("amt_bs").item(0).getTextContent());
									System.out.println("amtBS :"+amtBS);
									tempAmtBS = amtBS - amtAdjBS;
									tranIdBSList.add(tranIdBS.trim());
									amtList.add(tempAmtBS);

									//amtList.add(amtBS);
									System.out.println("tempAmtBS :"+tempAmtBS);

									currSet.add(currCodeBS);

									/*if(tranTypeBS.equalsIgnoreCase("P"))
									{
										paymentAmt = paymentAmt + tempAmtBS;
									}
									else if(tranTypeBS.equalsIgnoreCase("R"))
									{
										receiptAmt  = receiptAmt + tempAmtBS;
									}*/
									if(tranTypeBS.equalsIgnoreCase("P"))
									{
										paymentAmtBS = paymentAmtBS + amtBS;
									}
									else if(tranTypeBS.equalsIgnoreCase("R"))
									{
										receiptAmtBS  = receiptAmtBS + amtBS;
									}
									//System.out.println("@@@@@ paymentAmt["+paymentAmt+"]receiptAmt["+receiptAmt+"]");
									System.out.println("@@@@@ paymentAmtBS["+paymentAmtBS+"]paymentAmtBT["+paymentAmtBT+"]receiptAmtBS["+receiptAmtBS+"]receiptAmtBT["+receiptAmtBT+"]");
								}//end of bankStatement
								if(tranName.equalsIgnoreCase("bankTransaction"))
								{
									System.out.println("bankTransaction(Manually)");
									refNoBT = checkNull(eElement.getElementsByTagName("ref_no").item(0).getTextContent());
									System.out.println("refNoBT :"+refNoBT);
									refDateBT = checkNull(eElement.getElementsByTagName("ref_date").item(0).getTextContent());
									System.out.println("refDateBT :"+refDateBT);
									tranTypeBT = checkNull(eElement.getElementsByTagName("tran_type").item(0).getTextContent());
									System.out.println("tranTypeBT :"+tranTypeBT);
									tranIdBT = checkNull(eElement.getElementsByTagName("tran_id").item(0).getTextContent());
									System.out.println("tranIdBT :"+tranIdBT);
									currCodeBT = checkNull(eElement.getElementsByTagName("curr_code").item(0).getTextContent());
									System.out.println("currCodeBT :"+currCodeBT);
									statusBT = checkNull(eElement.getElementsByTagName("status").item(0).getTextContent());
									System.out.println("statusBT :"+statusBT);
									amtAdjBT = Double.parseDouble(eElement.getElementsByTagName("amt_adj").item(0).getTextContent());
									System.out.println("amtAdjBT :"+amtAdjBT);
									amtBT = Double.parseDouble(eElement.getElementsByTagName("amt_bt").item(0).getTextContent());
									System.out.println("amtBT :"+amtBT);

									tempAmtBT = amtBT - amtAdjBT;
									System.out.println("tempAmt in nbankTransaction!!!!! :"+tempAmt);

									tranIdBTList.add(tranIdBT.trim());
									amtList.add(tempAmtBT);
									//amtList.add(amtBT);

									currSet.add(currCodeBT);
									/*if(tranTypeBT.equalsIgnoreCase("P"))
									{
										paymentAmt = paymentAmt + tempAmtBT;
									}
									else if(tranTypeBT.equalsIgnoreCase("R"))
									{
										receiptAmt  = receiptAmt + tempAmtBT;
									}*/

									if(tranTypeBT.equalsIgnoreCase("P"))
									{
										paymentAmtBT = paymentAmtBT + amtBT;
									}
									else if(tranTypeBT.equalsIgnoreCase("R"))
									{
										receiptAmtBT  = receiptAmtBT + amtBT;
									}
									//System.out.println("@@@@@ paymentAmt["+paymentAmt+"]receiptAmt["+receiptAmt+"]");
									System.out.println("@@@@@ paymentAmtBS["+paymentAmtBS+"]paymentAmtBT["+paymentAmtBT+"]receiptAmtBS["+receiptAmtBS+"]receiptAmtBT["+receiptAmtBT+"]");
								}//end of bankTransaction
							}///end of for loop\

							System.out.println("@@@@@1 paymentAmt["+paymentAmt+"]receiptAmt["+receiptAmt+"]");

							System.out.println("paymentAmt :"+paymentAmt);
							System.out.println("receiptAmt :"+receiptAmt);
							System.out.println("tranTypeBS :"+tranTypeBS);


							//if(tranTypeBS.equalsIgnoreCase("P"))
							//{
							calAmtBS = paymentAmtBS - receiptAmtBS;
							//}
							//else if(tranTypeBS.equalsIgnoreCase("R"))
							//{
							calAmtBT =  paymentAmtBT  - receiptAmtBT ;
							//}

							/*if(tranTypeBS.equalsIgnoreCase("P"))
								{
									calAmtBS = paymentAmtBS - receiptAmtBS;
								}
								else if(tranTypeBS.equalsIgnoreCase("R"))
								{
									calAmtBT = receiptAmtBT - paymentAmtBT;
								}
							 */
							System.out.println("calAmt :"+calAmt);
							System.out.println("tempAmtBS :"+tempAmtBS);

							System.out.println("calAmtBS["+calAmtBS+"]calAmtBT["+calAmtBT+"]");

							if( calAmtBS == calAmtBT )
							{
								isReconcile = true;
								System.out.println("isReconcile["+isReconcile+"]");
							}

							/*if((paymentAmtBS > 0 && paymentAmtBT > 0 && paymentAmtBS == paymentAmtBT ) || 
									receiptAmtBS > 0 && receiptAmtBT > 0 && receiptAmtBS == receiptAmtBT )
							{
								isReconcile = true;
								System.out.println("isReconcile["+isReconcile+"]");
							}*/
							System.out.println("isReconcile(end of for loop: multiple bank stmt & multiple bank Trans:"+isReconcile);	

						}//end of bankStmtCnt > 1 && bankTrntCnt > 1

						System.out.println("@@@@@@isReconcile["+isReconcile+"]tranIdBSList.size()["+tranIdBSList.size()+"]tranIdBTList.size()["+tranIdBTList.size()+"]");

						if(isReconcile)
						{
							if(tranIdBSList.size() > 1 && tranIdBTList.size() == 1)
							{
								for(int i = 0 ; i < tranIdBSList.size() ; i++)
								{
									ArrayList traceData = null;
									traceData = new ArrayList();
									System.out.println("multiple bank statement");
									System.out.println(tranIdBSList.get(i));
									System.out.println(tranIdBTList.get(0));
									System.out.println(amtList.get(i));
									traceData.add(tranIdBTList.get(0));
									traceData.add(tranIdBSList.get(i));
									traceData.add(amtList.get(i));
									arrayListData.add(traceData);
								}
							}
							if(tranIdBTList.size() > 1 && tranIdBSList.size() == 1)
							{
								for(int i = 0 ; i < tranIdBTList.size() ; i++)
								{
									System.out.println("before :"+arrayListData);
									System.out.println(i);

									ArrayList traceData = null;
									traceData = new ArrayList();
									System.out.println("multiple bank transcation!!!");
									System.out.println(tranIdBSList.get(0));
									System.out.println(tranIdBTList.get(i));
									//System.out.println(amtList.get(i));
									traceData.add(tranIdBTList.get(i));
									traceData.add(tranIdBSList.get(0));
									traceData.add(amtList.get(i));
									arrayListData.add(traceData);
									System.out.println("after :"+arrayListData);
								}
								System.out.println("after for loop :"+arrayListData);
							}
							if(tranIdBTList.size() == 1 && tranIdBSList.size() == 1)
							{
								ArrayList traceData = null;
								traceData = new ArrayList();
								System.out.println("single transaction");
								System.out.println(tranIdBSList.get(0));
								System.out.println(tranIdBTList.get(0));
								System.out.println(amtList.get(0));
								traceData.add(tranIdBTList.get(0));
								traceData.add(tranIdBSList.get(0));
								traceData.add(amtList.get(0));
								arrayListData.add(traceData);

							}

							if(tranIdBTList.size() > 1 && tranIdBSList.size() > 1 )
							{
								System.out.println("@@@@@@@@ tranIdBSList["+tranIdBSList+"]:::tranIdBTList["+tranIdBTList+"]");
								for(int i = 0 ; i < tranIdBTList.size() ; i++)
								{
									System.out.println("i["+i+"]before :"+arrayListData);

									ArrayList traceData = null;
									traceData = new ArrayList();
									System.out.println("multiple bank transcation!!!");
									System.out.println(tranIdBSList.get(i));
									System.out.println(tranIdBTList.get(i));
									//System.out.println(amtList.get(i));
									traceData.add(tranIdBTList.get(i));
									traceData.add(tranIdBSList.get(i));
									double amtTemp = getReconcileAmount("banktran_log",tranIdBTList.get(i),conn);
									traceData.add(amtTemp);
									//traceData.add(amtList.get(i));
									arrayListData.add(traceData);
									System.out.println("after :"+arrayListData);
								}
								System.out.println("after for loop :"+arrayListData);
							}

						}

					}

				}//else for CallByManually

				System.out.println("arrayListData :"+arrayListData);

				if(arrayListData != null && arrayListData.size() > 0)
				{

					System.out.println("@@@@@@@stringBuffer1["+stringBuffer+"]@@@@@@@,arrayListData.lenght["+arrayListData.size()+"]");
					System.out.println("@@@@@@@arrayListData.size():["+arrayListData.size()+"]arrayListData11---->["+arrayListData+"]");
					pstmt = conn.prepareStatement(insertSql);
					for (int itr = 0;itr < arrayListData.size();itr++) 
					{
						System.out.println(" :"+"itr :"+itr+"value :"+arrayListData.get(itr));
						ArrayList traceData = null;
						traceData = new ArrayList();
						traceData = arrayListData.get(itr);
						System.out.println("@@@@@@ traceData1--"+itr+"--->>["+traceData+"]");
						System.out.println("traceData.get(0) :["+traceData.get(0)+"]");
						System.out.println("traceData.get(1) :["+traceData.get(1)+"]");
						System.out.println("traceData.get(2) :["+traceData.get(2)+"]");
						pstmt.setString(1, (String)traceData.get(0));
						pstmt.setString(2, (String)traceData.get(1));
						pstmt.setDouble(3, Double.parseDouble(traceData.get(2).toString()));
						//pstmt.setString(3, (String)traceData.get(2));

						pstmt.addBatch();
					}

					int rowsInsertedWorkOrder[] = pstmt.executeBatch();
					System.out.println("rowsInsertedWorkOrder :"+rowsInsertedWorkOrder);
					System.out.println("rowsInsertedWorkOrder length is :"+rowsInsertedWorkOrder.length);
					if(rowsInsertedWorkOrder.length > 0)
					{

						System.out.println("rowsInsertedWorkOrder.......");
						conn.commit();
						System.out.println("arrayListData.size()!!!!! :"+arrayListData.size());
						for (int itr = 0;itr < arrayListData.size();itr++) 
						{
							System.out.println(">>>>execute update query!!!!!!!!!");
							ArrayList updateData = null;
							updateData = new ArrayList();
							updateData = arrayListData.get(itr);
							System.out.println("updateData--"+itr+"--->>["+updateData+"]");//[[2014-04-09 00:00:00.0, S-INV, 006IF00001, VOUCH, 548PUG0001, SP801, GF818, 1225.0]]
							System.out.println("updateData.get(0) :"+updateData.get(0));
							System.out.println("updateData.get(1) :"+updateData.get(1));
							String updatedStatus="R";
							sql=" update bank_statement set status = ? where tran_id=? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, updatedStatus);
							pstmt.setString(2, updateData.get(1).toString());
							pstmt.executeUpdate();
							conn.commit();
							pstmt.close();


							sql=" update banktran_log set status = ? where tran_id=? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, updatedStatus);
							pstmt.setString(2, updateData.get(0).toString());
							pstmt.executeUpdate();
							conn.commit();
							pstmt.close();

						}


						valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
						valueXmlString = valueXmlString.append("<message>Success</message>");
						valueXmlString = valueXmlString.append("</Root>");
						System.out.println("valueXmlString :"+valueXmlString);

					}

				}
			}
			catch(SQLException e) {
				System.out.println("SQL Exception In getXMLTransData method of BankRecoWizIC Class : "+e.getMessage());
				e.printStackTrace();
				try{
					conn.rollback();
					valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
					valueXmlString = valueXmlString.append("<message>Failed</message>");
					valueXmlString = valueXmlString.append("</Root>");

				}
				catch(Exception e1){
					e1.printStackTrace();
				}
			}
			catch(Exception ex) {
				System.out.println("Exception In getXMLTransData method of BankRecoWizIC Class : "+ex.getMessage());
				try{
					conn.rollback();
					valueXmlString = valueXmlString.append("<?xml version='1.0'?><Root>");
					valueXmlString = valueXmlString.append("<message>Failed</message>");
					valueXmlString = valueXmlString.append("</Root>");
				}
				catch(Exception e1){
					e1.printStackTrace();
				}
				ex.printStackTrace();
			} finally {
				try{
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs!=null){
						rs.close();
						rs = null;
					}
					if(conn1!=null){
						conn1.close();
						conn1=null;
					}
				}catch (SQLException se) {
					se.printStackTrace();
				}
				sql = null;
				insertSql = null;
				objName = null;
				stringBuffer = null;
			}
		}else{
			try {
				throw new SQLException("Connection passed to BankRecoWizIC.getXMLTransData() method is null");
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
		System.out.println("final valueXmlString in getXMLTransData() method :"+valueXmlString);
		return valueXmlString;
	}


	private double getReconcileAmount(String tableName,String tranId, Connection conn) 
	{
		double amount=0;

		String sql="";
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		try
		{
			sql = "SELECT amount from " + tableName + " where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{					
				amount=rs.getDouble("amount");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("@@@@@@@ amount["+amount+"]");

		return amount;
	}

	private ArrayList<ArrayList> buildTraceDataHM(HashMap<String,Double> bankStmtMap,HashMap<String,Double> bankTranMap,String siteCodeFr,String siteCodeTo,String rType,HashMap<String,String> bankStmtRefMap,HashMap<String,String> bankTranRefMap,String autoReconFilter) throws Exception
	{
		System.out.println("In buildTraceDataHM calling..........");

		System.out.println("bankStmtMap :"+bankStmtMap);//{SP801:006IF00001:09-APR-14=1225.0}
		System.out.println("bankTranMap :"+bankTranMap);//{GF818:548PUG0001:03-NOV-15=1225.0}
		System.out.println("siteCodeFr :"+siteCodeFr);//SP801
		System.out.println("siteCodeTo :"+siteCodeTo);//GF818
		System.out.println("rType :"+rType);//M
		System.out.println("bankStmtRefMap :"+bankStmtRefMap);//{SP801:006IF00001:09-APR-14=S-INV}
		System.out.println("bankTranRefMap :"+bankTranRefMap);//{GF818:548PUG0001:03-NOV-15=VOUCH}

		rType=rType==null ? ""  : rType.trim();
		System.out.println("rType--->>["+rType+"]");//[M]
		ArrayList<ArrayList> arrayListData = new ArrayList<ArrayList>();
		ArrayList<ArrayList> bankStmtList = null;
		ArrayList<ArrayList> bankTranList = null;
		String key = "",firstRefSer = "",secondRefSer = "",tranIdStmt="",tranIdLog="";
		double recAmt = 0,secondSite = 0;
		int leftcnt = 0, rightcnt = 0;
		SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
		boolean isBankTranData=false;
		try 
		{
			ArrayList traceData = null;
			if ( bankStmtMap != null && bankTranMap != null && bankStmtMap.size() > 0 && bankTranMap.size() > 0 )
			{
				if("A".equalsIgnoreCase(rType))
				{
					Set<String> issueSet = bankStmtMap.keySet();
					Iterator itr = issueSet.iterator();
					while(itr.hasNext())
					{
						key = (String)itr.next();
						System.out.println("key["+key+"]");
						String[] keyArray = key.split(":");
						System.out.println("1:["+keyArray[0]+"]");
						System.out.println("2:["+keyArray[1]+"]");

						//System.out.println("3:["+keyArray[2]+"]");
						//System.out.println("siteCodeFr :"+siteCodeFr);
						//System.out.println("siteCodeTo :"+siteCodeTo);

						System.out.println("autoReconFilter:"+autoReconFilter);
						if("REFNO_DATE_AMT".equalsIgnoreCase(autoReconFilter))
						{
							if(bankTranMap.containsKey(":"+keyArray[1].toString()+":"+keyArray[2].toString()))
							{

								tranIdStmt = bankStmtRefMap.get(""+"@"+keyArray[1].toString()+"@"+keyArray[2].toString());
								System.out.println("tranIdStmt :"+tranIdStmt);
								tranIdLog = bankTranRefMap.get(""+"@"+keyArray[1].toString()+"@"+keyArray[2].toString());
								System.out.println("tranIdLog :"+tranIdLog);
								isBankTranData=true;

							}
						}
						else if("REFNO_AMT".equalsIgnoreCase(autoReconFilter))
						{
							if(bankTranMap.containsKey(":"+keyArray[1].toString()))
							{

								tranIdStmt = bankStmtRefMap.get(""+"@"+keyArray[1].toString());
								System.out.println("tranIdStmt :"+tranIdStmt);
								tranIdLog = bankTranRefMap.get(""+"@"+keyArray[1].toString());
								System.out.println("tranIdLog :"+tranIdLog);
								isBankTranData=true;

							}
						}
						else if("REFDATE_AMT".equalsIgnoreCase(autoReconFilter))
						{
							if(bankTranMap.containsKey(":"+keyArray[1].toString()))
							{

								tranIdStmt = bankStmtRefMap.get(""+"@"+keyArray[1].toString());
								System.out.println("tranIdStmt :"+tranIdStmt);
								tranIdLog = bankTranRefMap.get(""+"@"+keyArray[1].toString());
								System.out.println("tranIdLog :"+tranIdLog);
								isBankTranData=true;

							}
						}

						System.out.println(bankStmtRefMap);
						System.out.println("bankStmtRefMap size ....."+bankStmtRefMap.size());
						System.out.println(""+":"+keyArray[1].toString());
						System.out.println(""+":"+keyArray[1].toString());


						System.out.println("ref id from :"+""+"@"+keyArray[1].toString());
						System.out.println("ref id to :"+""+"@"+keyArray[1].toString());
						System.out.println("isBankTranData:"+isBankTranData);

						//if(bankTranMap.containsKey(":"+keyArray[1].toString()))
						if(isBankTranData)
						{
							recAmt = bankStmtMap.get(key);
							System.out.println("key : "+key);
							System.out.println("recAmt : "+recAmt);
							System.out.println("reseiverSiteMap :"+bankTranMap);
							System.out.println(" get key!!!!!!!!!" +":"+keyArray[1].toString());
							System.out.println("issue get key :::"+":"+keyArray[1].toString());
							//secondSite = bankTranMap.get(":"+keyArray[1].toString());

							/*firstRefSer = bankStmtRefMap.get(":"+keyArray[1].toString()+":"+keyArray[2].toString());
							System.out.println("firstRefSer :"+firstRefSer);
							secondRefSer = bankTranRefMap.get(":"+keyArray[1].toString()+":"+keyArray[2].toString());
							System.out.println("secondRefSer :"+secondRefSer);*/

							System.out.println("bankStmtRefMap :"+bankStmtRefMap);
							System.out.println("!!!!"+""+"@"+keyArray[1].toString());


							System.out.println("bankTranRefMap :"+bankTranRefMap);
							System.out.println("@@@@@@"+""+"@"+keyArray[1].toString());
							//							tranIdStmt = bankStmtRefMap.get(""+"@"+keyArray[1].toString());
							//							System.out.println("tranIdStmt :"+tranIdStmt);
							//							tranIdLog = bankTranRefMap.get(""+"@"+keyArray[1].toString());
							//							System.out.println("tranIdLog :"+tranIdLog);
							//							


							traceData = null;
							traceData = new ArrayList<String>();

							System.out.println("tranIdStmt :"+tranIdStmt);
							System.out.println("tranIdLog :"+tranIdLog);
							System.out.println("recAmt :"+recAmt);

							//Timestamp time = new Timestamp(date.getTime());
							traceData.add(tranIdLog);
							traceData.add(tranIdStmt);
							traceData.add(recAmt);
							arrayListData.add(traceData);

							//}
						}
					}
				}
				else if("M".equalsIgnoreCase(rType))
				{
					bankStmtList = getArrayListHM(bankStmtMap,bankStmtRefMap);
					bankTranList = getArrayListHM(bankTranMap,bankTranRefMap);

					recAmt = (Double)bankStmtList.get(0).get(3);
					System.out.println("recAmt :"+recAmt);
					secondSite = (Double)bankTranList.get(0).get(3);
					System.out.println("secondSite :"+secondSite);
					while(true)
					{

						System.out.println("recAmt :"+recAmt);
						System.out.println("secondSite :"+secondSite);
						System.out.println("bankStmtList.size() :"+bankStmtList.size());
						System.out.println("leftcnt :"+leftcnt);
						System.out.println("bankTranList.size() :"+bankTranList.size());
						System.out.println("rightcnt :"+rightcnt);

						System.out.println("bankStmtList :"+bankStmtList);
						System.out.println("receiverList :"+bankTranList);					
						if(bankStmtList.size() == leftcnt && bankTranList.size() == rightcnt)
						{
							break;
						}
						else// if(firstSite == secondSite)
						{


							traceData = null;
							traceData = new ArrayList<String>();
							System.out.println("======= :"+bankStmtList.get(leftcnt).get(2).toString());
							java.util.Date formatDate =  new SimpleDateFormat("dd-MMM-yy").parse(bankStmtList.get(leftcnt).get(2).toString());
							System.out.println("formatDate :"+formatDate);//Wed Apr 09 00:00:00 IST 2014
							String dateStr = sdf.format(formatDate);
							System.out.println("dateStr :"+dateStr);//2014-04-09
							java.util.Date date=sdf.parse(dateStr);

							System.out.println("date :"+date);//Wed Apr 09 00:00:00 IST 2014


							System.out.println("=====checl value=======================");
							System.out.println("tran id log :"+bankTranList.get(rightcnt).get(1).toString());
							System.out.println("tran id Stat :"+bankStmtList.get(leftcnt).get(1).toString());
							System.out.println("Amount :"+bankStmtList.get(leftcnt).get(3).toString());

							//java.util.Date date =  sdf.parse(issuesList.get(leftcnt).get(2).toString());
							Timestamp time = new Timestamp(date.getTime());
							//traceData.add(time);
							traceData.add(bankTranList.get(rightcnt).get(1).toString());
							traceData.add(bankStmtList.get(leftcnt).get(1).toString());
							traceData.add(bankStmtList.get(leftcnt).get(3).toString());
							arrayListData.add(traceData);

							leftcnt++;
							rightcnt++;
							if(leftcnt < bankStmtList.size() && rightcnt < bankTranList.size())
							{
								recAmt = (Double)bankStmtList.get(leftcnt).get(3);
								secondSite = (Double)bankTranList.get(rightcnt).get(3);
							}
						}

					}
				}
				bankStmtMap = null;
				bankTranMap = null;
				siteCodeFr = null;
				siteCodeTo = null;
				traceData = null;
				bankStmtList = null;
				bankTranList = null;
				bankStmtRefMap = null;
				bankTranRefMap = null;
				key = null;
				firstRefSer = null;
				secondRefSer = null;
			}
		} catch(Exception e) {
			System.out.println("SQL Exception In getXMLTransData method of BankRecoWizIC Class : "+e.getMessage());
			e.printStackTrace();
		} finally {
			try{
			}catch (Exception se) {
				se.printStackTrace();
			}
		}
		System.out.println("size of arrayListData :"+arrayListData.size());
		System.out.println("arrayListData :"+arrayListData);
		return arrayListData;
	}


	private String[] getUniqueIntValue(String uniqueNo)
	{
		System.out.println("In getUniqueIntValue");
		String [] returnVal = new String[2];
		int strcnt = 0;
		StringBuffer sbInt = new StringBuffer("");
		StringBuffer sbStr = new StringBuffer("");
		for(strcnt = 0;strcnt < uniqueNo.length();strcnt++)
		{
			if((int)uniqueNo.charAt(strcnt) >= 48 && (int)uniqueNo.charAt(strcnt) <= 57)
			{
				sbInt.append(uniqueNo.charAt(strcnt));
			} else {
				sbStr.append(uniqueNo.charAt(strcnt));
			}
		}
		returnVal[0] = sbStr.toString();
		returnVal[1] = sbInt.toString();
		sbInt.delete(0, sbInt.length());
		for(strcnt = 0;strcnt < 10 - sbStr.length();strcnt++)
		{
			sbInt.append("0");
		}
		nf = new DecimalFormat(sbInt.toString());
		sbInt = null;
		sbStr = null;

		return returnVal;
	}

	private ArrayList<ArrayList> getArrayListHM(HashMap<String , Double> HMListAmount,HashMap<String , String> HMListRef)
	{
		ArrayList<ArrayList> resultList = new ArrayList<ArrayList>();
		ArrayList tempList = null;
		Set set = null;
		Iterator itr = null;
		String key = "",refSer = "";
		double amount = 0.0;
		try{
			set = HMListAmount.keySet();
			itr = set.iterator();
			while(itr.hasNext())
			{
				key = (String)itr.next();
				String[] keyArray = key.split(":");
				System.out.println("1:["+keyArray[0]+"]");
				System.out.println("2:["+keyArray[1]+"]");
				System.out.println("3:["+keyArray[2]+"]");
				amount = HMListAmount.get(key);
				refSer = HMListRef.get(key);

				tempList = null;
				tempList = new ArrayList();
				tempList.add(keyArray[0]);
				tempList.add(keyArray[1]);
				tempList.add(keyArray[2]);
				tempList.add(amount);
				tempList.add(refSer);

				resultList.add(tempList);
			}
			tempList = null;
			set = null;
			itr = null;
			key = null;
			refSer = null;
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		return resultList;
	}

	private StringBuffer getGPNOBillNo(String refId , String refSer , String sundryCode ,String tranId,StringBuffer valueXmlString,Connection conn)
	{

		String gpNo="",gpDate="",billNo="",billDate="",sql="";
		String billGpNoStr="";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		try
		{

			System.out.println("Call getGPNOBillNo !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
			System.out.println("refId :"+refId);
			System.out.println("refSer :"+refSer);
			System.out.println("sundryCode :"+sundryCode);
			System.out.println("tranId :"+tranId);

			//sql = "select DDF_GET_BILL_GP_NO(?,?,?,?) as bill_gp_no_str from dual";
			sql = "select DDF_GET_BILL_GP_NO_EXM(?,?,?,?) as bill_gp_no_str from dual";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,refId);
			pstmt.setString(2,refSer);
			pstmt.setString(3,sundryCode);
			pstmt.setString(4,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				billGpNoStr	= rs.getString("bill_gp_no_str");		
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			System.out.println("billGpNoStr :"+billGpNoStr);
			System.out.println("refSer is !!!@@@@@!!!!!!!!!!!!:"+refSer);
			if(refSer.trim().equalsIgnoreCase("M-VOUC") || refSer.trim().equalsIgnoreCase("VOUCH"))
			{
				System.out.println("refSer is :"+refSer);
				System.out.println("billGpNoStr :"+billGpNoStr);

				if(billGpNoStr != null)
				{
					String billGpNo [] = billGpNoStr.split("@");
					System.out.println("billGpNo length :"+billGpNo.length);

					for(int i = 0 ; i<billGpNo.length ;i++)
					{
						System.out.println(billGpNo[i]);
					}	
					billNo=billGpNo[0];
					billDate=billGpNo[1];
					gpNo=billGpNo[2];
					gpDate=billGpNo[3];


					billNo = billNo.equalsIgnoreCase("NODATA") ? "" : billNo;
					billDate = billDate.equalsIgnoreCase("NODATA") ? "" : billDate;
					gpNo = gpNo.equalsIgnoreCase("NODATA") ? "" : gpNo;
					gpDate = gpDate.equalsIgnoreCase("NODATA") ? "" : gpDate;


				}

			}

			/*if(refSer.trim().equalsIgnoreCase("VOUCH"))
			{
    			System.out.println("Vouch@@@@@@@@@@@@@@@@@");
			}


    		if(refSer.trim().equalsIgnoreCase("VOUCH") || refSer.trim().equalsIgnoreCase("M-VOUC"))
			{
    			System.out.println("$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
			}
			 */




			System.out.println("billNo :"+billNo);
			System.out.println("billDate :"+billDate);
			System.out.println("gpNo :"+gpNo);
			System.out.println("gpDate :"+gpDate);


			/*valueXmlString.append("<GP_NO><![CDATA[").append(gpNo).append("]]></GP_NO>");
    		valueXmlString.append("<GP_DATE><![CDATA[").append(gpDate).append("]]></GP_DATE>");
    		valueXmlString.append("<BILL_NO><![CDATA[").append(billNo).append("]]></BILL_NO>");
    		valueXmlString.append("<BILL_DATE><![CDATA[").append(billDate).append("]]></BILL_DATE>");*/

			valueXmlString.append("<GP_NO><![CDATA[").append(gpNo).append("]]></GP_NO>");
			valueXmlString.append("<GP_DATE><![CDATA[").append(gpDate).append("]]></GP_DATE>");
			valueXmlString.append("<BIL_NO><![CDATA[").append(billNo).append("]]></BIL_NO>");
			valueXmlString.append("<BIL_DATE><![CDATA[").append(billDate).append("]]></BIL_DATE>");

			/*valueXmlString.append("<GP_NO><![CDATA[").append(gpNo).append("]]></GP_NO>");
    		valueXmlString.append("<GP_DATE><![CDATA[").append(gpDate).append("]]></GP_DATE>");
    		valueXmlString.append("<BL_NO><![CDATA[").append(billNo).append("]]></BL_NO>");
    		valueXmlString.append("<BL_DATE><![CDATA[").append(billDate).append("]]></BL_DATE>");*/



		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

		return valueXmlString;

	}


	protected String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) 
	{

		PreparedStatement pstmt = null ;
		ResultSet rs = null ; 
		String sql = "";
		String findValue = "";
		try
		{			
			sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,value);
			rs = pstmt.executeQuery();
			if(rs.next())
			{					
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	        
		}
		catch(Exception e)
		{
			System.out.println("Exception in getColumnDescr ");
			e.printStackTrace();
		}
		System.out.println("returning String from getColumnDescr " + findValue);
		return findValue;

	}


	public String getFilterData(String xmlString)throws ITMException
	{
		Document dom = null, dom1 = null;
		System.out.println("getFilterData!!!!!!!!!.......");
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String siteCodeFr = "", siteCodeTo = "",filterData="";
		String drAmt="",crAmt="",gpNo="",gpDate="",billNo="",billDate="",tranDate="",filterList="";
		String frmTranDt="",toTranDt="",sundryTypeFr="",sundryTypeTo="",sundryCodeFr="",sundryCodeTo="",sundryCode="";
		String tranId="",acctCode="",cctrCode="",prdCode="",acctPrd="",projCode="",chgDate="";
		String compRef="",shName="",sundryName="",sundryDetails="",orgLocn="",billGpNoStr="",finEntity="",siteCodeFrDescr="",siteCodeToDescr="";
		String sundrytype = "",exchRate = "",currCode="",bankName= "";
		String resultString ="",sql = "", bankCode = "", bankCodeNew = "";
		String siteCode = "", siteCodeNew = "";
		NodeList parentNodeList = null;
		Node parentNode = null; 
		Node childNode = null;
		NodeList childNodeList = null;
		String childNodeName = null;
		PreparedStatement pstmt  = null;
		ResultSet rs = null;
		int childNodeListLength = 0,length=0, lengthOld = 0;
		Date frDt = null, toDt = null ,  filDt = null, rfDt = null;
		int ctr=0;
		StringBuffer valueXmlString = new StringBuffer("");
		StringBuffer originalXmlStringBuff = new StringBuffer();
		
		try
		{ 
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			SimpleDateFormat sdf1 = new SimpleDateFormat("dd-MMM-yy");
			System.out.println("called getFilterData.=================.");
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			String refId="",refSer="";
			System.out.println("xmlString :"+xmlString);
			dom = genericUtility.parseString(xmlString);
			StringBuffer filterXml = new StringBuffer();
			
			


			siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
			System.out.println("siteCode :"+siteCode);
			
			bankCode = checkNull(genericUtility.getColumnValue("bank_code", dom));
			System.out.println("bank code:::"+bankCode);
			
			sql = "select BANK_NAME from bank where bank_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, bankCode.trim());
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				bankName = checkNull(rs.getString("BANK_NAME"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("bankName :"+bankName);



			
			originalXmlStringBuff = originalXmlStringBuff.append("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			originalXmlStringBuff = originalXmlStringBuff.append("</editFlag> </header>");
			originalXmlStringBuff = originalXmlStringBuff.append(" <Detail1>");
			originalXmlStringBuff = originalXmlStringBuff.append(getXMLTransData(conn,"","","",new StringBuffer(""),"CallByFilter","",siteCode,bankCode,""));
			originalXmlStringBuff = originalXmlStringBuff.append("</Detail1>");
			originalXmlStringBuff = originalXmlStringBuff.append("</Root>");
			
			String originalXmlString = originalXmlStringBuff.toString();
			
			System.out.println("xml to be filtered::: " + originalXmlString);
			
			dom1 = genericUtility.parseString(originalXmlString);


			filterData= checkNull(genericUtility.getColumnValue("filter_data", dom));
			System.out.println("filRefId :"+filterData);
			filterList= checkNull(genericUtility.getColumnValue("filter_list", dom));
			System.out.println("filterList :"+filterList);
			
			String fromDate = checkNull(genericUtility.getColumnValue("fr_date", dom));
			System.out.println(":::from date:: " + fromDate);
			
			String toDate = checkNull(genericUtility.getColumnValue("to_dt", dom));
			System.out.println("to date:::: " + toDate);
			
			if((fromDate.length() > 0 && toDate.length() == 0) || (fromDate.length() == 0 && toDate.length() > 0)){
				return resultString;
			}//if either of the dates is entered

			if(filterList.equalsIgnoreCase("none") && filterData.trim().length() > 0){
				return resultString; 
			}
			if(fromDate.length() > 0){
			 frDt = sdf.parse(fromDate);
			System.out.println("formatted to date:: " + frDt);
			}
			
			if(toDate.length() > 0){
			toDt = sdf.parse(toDate);
			System.out.println("formatted from date:: " + toDt);
			}

			filterXml.append("<Detail1>");
			filterXml.append("<from_tran_date>" + siteCode+ "</from_tran_date>");
			filterXml.append("<filter_list>" + filterList + "</filter_list>");
			filterXml.append("<filter_data>" + filterData + "</filter_data>");
			filterXml.append("<from_date>" + fromDate + "</from_date>");
			filterXml.append("<to_date>" + toDate + "</to_date>");
			filterXml.append("<bank_descr>" + bankName + "</bank_descr>");
			filterXml.append("</Detail1>");
			filterXml.append("<Detail2>");
			
			parentNodeList = dom1.getElementsByTagName("Detail");
			parentNode = parentNodeList.item(0);
			
			length=dom1.getElementsByTagName("Detail").getLength(); 
			System.out.println("length ::::::"+length);
			
			lengthOld=dom.getElementsByTagName("Detail").getLength(); 
			System.out.println("length ::::::"+lengthOld);

			String tranName="",refDate="",tranType="",amtBs="",refMode="",effDate="",statNo="",statDate="",amtAdj="",status="",amtBc="" ;
			
			System.out.println("filterData :"+filterData);
			System.out.println("filterList :"+filterList);
			
			if("ref_date".equalsIgnoreCase(filterList) && fromDate.length() ==0){//TODO
				System.out.println("filter by cheque date");
				 filDt = sdf1.parse(filterData);
			}
			
			
			System.out.println("formatted filter date::" + filDt);
			
			if(fromDate.length() > 0 && filterData.trim().length() == 0 && !filterList.trim().equalsIgnoreCase("none")){
				for(int i=0 ; i<length ; i++)
					{
						tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("tranName : "+tranName);
						if(tranName.equalsIgnoreCase("bankStatement"))
						{
							System.out.println("in for:bankStatement when filter is from date to date...................");

							refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("refId : "+refId);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("refDate : "+refDate);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBs : "+amtBs);
							currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("currCode : "+currCode);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bs", dom1.getElementsByTagName("Detail").item(i)));
		   	   				System.out.println("amtBs : "+amtBs);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("tranId : "+tranId);
							refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("refMode : "+refMode);
							effDate=checkNull(genericUtility.getColumnValueFromNode("eff_date", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("effDate : "+effDate);
							statNo=checkNull(genericUtility.getColumnValueFromNode("stat_no", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("statNo : "+statNo);
							statDate=checkNull(genericUtility.getColumnValueFromNode("stat_date", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("statDate : "+statDate);
							amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("amtAdj : "+amtAdj);
							status=checkNull(genericUtility.getColumnValueFromNode("status", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("status : "+status);
							exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("exchRate : "+exchRate);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("siteCodeNew: "+siteCodeNew);
							bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("bankCodeNew: "+ bankCodeNew);
							
							
						}
						if(tranName.equalsIgnoreCase("bankTransaction"))
						{
							System.out.println("in for: bankTransaction when filter is from date to date................");
							refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("refId : "+refId);
							refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("refDate : "+refDate);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBs : "+amtBs);
							currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("currCode : "+currCode);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBs : "+amtBs);
							refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("refMode : "+refMode);
							tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("tranId : "+tranId);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							acctCode=checkNull(genericUtility.getColumnValueFromNode("acct_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("acctCode : "+acctCode);
							cctrCode=checkNull(genericUtility.getColumnValueFromNode("cctr_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("cctrCode : "+cctrCode);
							sundryCode=checkNull(genericUtility.getColumnValueFromNode("sundry_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("sundryCode : "+sundryCode);
							status=checkNull(genericUtility.getColumnValueFromNode("status", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("status : "+status);
							exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("exchRate : "+exchRate);
							amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("amtAdj : "+amtAdj);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("siteCodeNew: "+siteCodeNew);
							bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("bankCodeNew: "+ bankCodeNew);
							}
						rfDt = sdf1.parse(refDate);
						System.out.println("formatted ref date:: " + rfDt);
						if (((frDt.before(rfDt) || frDt.equals(rfDt)) && (toDt.after(rfDt) || toDt.equals(rfDt)))){
							
							System.out.println("Entering into filter data xml for from date to date.....");
							
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							if(tranName.equalsIgnoreCase("bankStatement"))
							{
								System.out.println("in if : bankStatement when filter is from date to date........");
								refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("refId : "+refId);
								tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("tranName : "+tranName);
								refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("refDate : "+refDate);
								tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("tranType : "+tranType);
								amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("amtBs : "+amtBs);
								currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("currCode : "+currCode);
								amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bs", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("amtBs : "+amtBs);
								tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("tranType : "+tranType);
								tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("tranId : "+tranId);
								refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("refMode : "+refMode);
								effDate=checkNull(genericUtility.getColumnValueFromNode("eff_date", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("effDate : "+effDate);
								statNo=checkNull(genericUtility.getColumnValueFromNode("stat_no", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("statNo : "+statNo);
								statDate=checkNull(genericUtility.getColumnValueFromNode("stat_date", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("statDate : "+statDate);
								amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("amtAdj : "+amtAdj);
								status=checkNull(genericUtility.getColumnValueFromNode("status", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("status : "+status);
								exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("exchRate : "+exchRate);
								tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("tranName : "+tranName);
								siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("siteCodeNew: "+siteCodeNew);
								bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
								System.out.println("bankCodeNew: "+ bankCodeNew);
							}
							filterXml.append("<Detail domID='1' selected='N'>");
							System.out.println("record found for from date to date::");
							if(tranName.equalsIgnoreCase("bankStatement"))
							{
								filterXml.append("<ref_no>" + refId+ "</ref_no>");
								filterXml.append("<tran_name>" + tranName+ "</tran_name>");
								filterXml.append("<ref_date>" + refDate+ "</ref_date>");
								filterXml.append("<tran_type>" + tranType+ "</tran_type>");
								filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
								filterXml.append("<curr_code>" + currCode+ "</curr_code>");
								filterXml.append("<amt_bs>" + amtBs+ "</amt_bs>");
								filterXml.append("<tran_id>" + tranId+ "</tran_id>");
								filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
								filterXml.append("<eff_date>" + effDate+ "</eff_date>");
								filterXml.append("<stat_no>" + statNo+ "</stat_no>");
								filterXml.append("<stat_date>" + statDate+ "</stat_date>");
								filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
								filterXml.append("<status>" + status+ "</status>");
								filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
								filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
								filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
							}
							filterXml.append("</Detail>");
							System.out.println("before bank transaction::" + filterXml.toString());
						}
						
						
							if(tranName.equalsIgnoreCase("bankTransaction"))
							{
								System.out.println("not filtering bank transaction:::");
								
								filterXml.append("<Detail domID='1' selected='N'>");
								filterXml.append("<ref_no>" + refId+ "</ref_no>");
								filterXml.append("<ref_date>" + refDate+ "</ref_date>");
								filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
								filterXml.append("<curr_code>" + currCode+ "</curr_code>");
								filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
								filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
								filterXml.append("<tran_id>" + tranId+ "</tran_id>");
								filterXml.append("<tran_type>" + tranType+ "</tran_type>");
								filterXml.append("<acct_code>" + acctCode+ "</acct_code>");
								filterXml.append("<cctr_code>" + cctrCode+ "</cctr_code>");
								filterXml.append("<sundry_code>" + sundryCode+ "</sundry_code>");
								filterXml.append("<status>" + status+ "</status>");
								filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
								filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
								filterXml.append("<tran_name>" + tranName+ "</tran_name>");
								filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
								filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
								filterXml.append("</Detail>");
							}
					}
			}else if("none".equalsIgnoreCase(filterList.trim()) && filterData.trim().length() == 0){
				//if(fromDate.length() == 0){
				for(int i=0 ; i<length ; i++)
				{
					tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
					System.out.println("tranName : "+tranName);


					if(tranName.equalsIgnoreCase("bankStatement"))
					{
						System.out.println("in for:bankStatement when filter is none...................");

						refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("refId : "+refId);
						tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("tranName : "+tranName);
						refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("refDate : "+refDate);
						tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("tranType : "+tranType);
						amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("amtBs : "+amtBs);
						currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("currCode : "+currCode);
						/*amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bs", dom.getElementsByTagName("Detail").item(i)));
	   	   				System.out.println("amtBs : "+amtBs);*/
						tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("tranType : "+tranType);
						tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("tranId : "+tranId);
						refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("refMode : "+refMode);
						effDate=checkNull(genericUtility.getColumnValueFromNode("eff_date", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("effDate : "+effDate);
						statNo=checkNull(genericUtility.getColumnValueFromNode("stat_no", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("statNo : "+statNo);
						statDate=checkNull(genericUtility.getColumnValueFromNode("stat_date", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("statDate : "+statDate);
						amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("amtAdj : "+amtAdj);
						status=checkNull(genericUtility.getColumnValueFromNode("status", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("status : "+status);
						exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("exchRate : "+exchRate);
						tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("tranName : "+tranName);
						siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("siteCodeNew: "+siteCodeNew);
						bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("bankCodeNew: "+ bankCodeNew);


					}
					if(tranName.equalsIgnoreCase("bankTransaction"))
					{
						System.out.println("in for: bankTransaction when filter is none................");
						refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("refId : "+refId);
						refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("refDate : "+refDate);
						amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("amtBs : "+amtBs);
						currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("currCode : "+currCode);
						amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("amtBs : "+amtBs);
						refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("refMode : "+refMode);
						tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("tranId : "+tranId);
						tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("tranType : "+tranType);
						acctCode=checkNull(genericUtility.getColumnValueFromNode("acct_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("acctCode : "+acctCode);
						cctrCode=checkNull(genericUtility.getColumnValueFromNode("cctr_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("cctrCode : "+cctrCode);
						sundryCode=checkNull(genericUtility.getColumnValueFromNode("sundry_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("sundryCode : "+sundryCode);
						status=checkNull(genericUtility.getColumnValueFromNode("status", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("status : "+status);
						exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("exchRate : "+exchRate);
						amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("amtAdj : "+amtAdj);
						tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("tranName : "+tranName);
						siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("siteCodeNew: "+siteCodeNew);
						bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("bankCodeNew: "+ bankCodeNew);


					}


					filterXml.append("<Detail domID='1' selected='N'>");
					
					
					System.out.println("record found::");
					if(tranName.equalsIgnoreCase("bankStatement"))
					{
						filterXml.append("<ref_no>" + refId+ "</ref_no>");
						filterXml.append("<tran_name>" + tranName+ "</tran_name>");
						filterXml.append("<ref_date>" + refDate+ "</ref_date>");
						filterXml.append("<tran_type>" + tranType+ "</tran_type>");
						filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
						filterXml.append("<curr_code>" + currCode+ "</curr_code>");
						filterXml.append("<amt_bs>" + amtBs+ "</amt_bs>");
						filterXml.append("<tran_id>" + tranId+ "</tran_id>");
						filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
						filterXml.append("<eff_date>" + effDate+ "</eff_date>");
						filterXml.append("<stat_no>" + statNo+ "</stat_no>");
						filterXml.append("<stat_date>" + statDate+ "</stat_date>");
						filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
						filterXml.append("<status>" + status+ "</status>");
						filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
						filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
						filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
						

					}
					if(tranName.equalsIgnoreCase("bankTransaction"))
					{
						filterXml.append("<ref_no>" + refId+ "</ref_no>");
						filterXml.append("<ref_date>" + refDate+ "</ref_date>");
						filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
						filterXml.append("<curr_code>" + currCode+ "</curr_code>");
						filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
						filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
						filterXml.append("<tran_id>" + tranId+ "</tran_id>");
						filterXml.append("<tran_type>" + tranType+ "</tran_type>");
						filterXml.append("<acct_code>" + acctCode+ "</acct_code>");
						filterXml.append("<cctr_code>" + cctrCode+ "</cctr_code>");
						filterXml.append("<sundry_code>" + sundryCode+ "</sundry_code>");
						filterXml.append("<status>" + status+ "</status>");
						filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
						filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
						filterXml.append("<tran_name>" + tranName+ "</tran_name>");
						filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
						filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
					}
					filterXml.append("</Detail>");	
				}
				filterXml.append("</Detail2>");
				resultString = filterXml.toString();
				System.out.println("resultString when filter is none :"+resultString);
				return resultString;
				//}
				/*else if(fromDate.length()>0){
					for(int i=0 ; i<length ; i++)
					{
						tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranName : "+tranName);
						if(tranName.equalsIgnoreCase("bankStatement"))
						{
							System.out.println("in for:bankStatement when filter is from date to date...................");

							refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refId : "+refId);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refDate : "+refDate);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBs : "+amtBs);
							currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("currCode : "+currCode);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bs", dom.getElementsByTagName("Detail").item(i)));
		   	   				System.out.println("amtBs : "+amtBs);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranId : "+tranId);
							refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refMode : "+refMode);
							effDate=checkNull(genericUtility.getColumnValueFromNode("eff_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("effDate : "+effDate);
							statNo=checkNull(genericUtility.getColumnValueFromNode("stat_no", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("statNo : "+statNo);
							statDate=checkNull(genericUtility.getColumnValueFromNode("stat_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("statDate : "+statDate);
							amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtAdj : "+amtAdj);
							status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("status : "+status);
							exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("exchRate : "+exchRate);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("siteCodeNew: "+siteCodeNew);
							bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("siteCodeNew: "+ bankCodeNew);
							
							
						}
						if(tranName.equalsIgnoreCase("bankTransaction"))
						{
							System.out.println("in for: bankTransaction when filter is none................");
							refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refId : "+refId);
							refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refDate : "+refDate);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBs : "+amtBs);
							currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("currCode : "+currCode);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBs : "+amtBs);
							refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refMode : "+refMode);
							tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranId : "+tranId);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							acctCode=checkNull(genericUtility.getColumnValueFromNode("acct_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("acctCode : "+acctCode);
							cctrCode=checkNull(genericUtility.getColumnValueFromNode("cctr_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("cctrCode : "+cctrCode);
							sundryCode=checkNull(genericUtility.getColumnValueFromNode("sundry_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("sundryCode : "+sundryCode);
							status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("status : "+status);
							exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("exchRate : "+exchRate);
							amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtAdj : "+amtAdj);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("siteCodeNew: "+siteCodeNew);
							bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("siteCodeNew: "+ bankCodeNew);
							}
						rfDt = sdf1.parse(refDate);
						System.out.println("formatted ref date:: " + rfDt);
						if (((frDt.before(rfDt) || frDt.equals(rfDt)) && (toDt.after(rfDt) || toDt.equals(rfDt)))){
							
							System.out.println("Entering into filter data xml for from date to date.....");
							
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							if(tranName.equalsIgnoreCase("bankStatement"))
							{
								System.out.println("in if : bankStatement when filter is not none........");
								refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("refId : "+refId);
								tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("tranName : "+tranName);
								refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("refDate : "+refDate);
								tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("tranType : "+tranType);
								amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("amtBs : "+amtBs);
								currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("currCode : "+currCode);
								amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bs", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("amtBs : "+amtBs);
								tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("tranType : "+tranType);
								tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("tranId : "+tranId);
								refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("refMode : "+refMode);
								effDate=checkNull(genericUtility.getColumnValueFromNode("eff_date", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("effDate : "+effDate);
								statNo=checkNull(genericUtility.getColumnValueFromNode("stat_no", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("statNo : "+statNo);
								statDate=checkNull(genericUtility.getColumnValueFromNode("stat_date", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("statDate : "+statDate);
								amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("amtAdj : "+amtAdj);
								status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("status : "+status);
								exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("exchRate : "+exchRate);
								tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("tranName : "+tranName);
								siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("siteCodeNew: "+siteCodeNew);
								bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom.getElementsByTagName("Detail").item(i)));
								System.out.println("siteCodeNew: "+ bankCodeNew);
							}
							filterXml.append("<Detail domID='1' selected='N'>");
							System.out.println("record found for from date to date::");
							if(tranName.equalsIgnoreCase("bankStatement"))
							{
								filterXml.append("<ref_no>" + refId+ "</ref_no>");
								filterXml.append("<tran_name>" + tranName+ "</tran_name>");
								filterXml.append("<ref_date>" + refDate+ "</ref_date>");
								filterXml.append("<tran_type>" + tranType+ "</tran_type>");
								filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
								filterXml.append("<curr_code>" + currCode+ "</curr_code>");
								filterXml.append("<amt_bs>" + amtBs+ "</amt_bs>");
								filterXml.append("<tran_id>" + tranId+ "</tran_id>");
								filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
								filterXml.append("<eff_date>" + effDate+ "</eff_date>");
								filterXml.append("<stat_no>" + statNo+ "</stat_no>");
								filterXml.append("<stat_date>" + statDate+ "</stat_date>");
								filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
								filterXml.append("<status>" + status+ "</status>");
								filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
								filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
								filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
							}
							filterXml.append("</Detail>");
							System.out.println("before bank transaction::" + filterXml.toString());
						}
						
						
							if(tranName.equalsIgnoreCase("bankTransaction"))
							{
								System.out.println("not filtering bank transaction:::");
								
								filterXml.append("<Detail domID='1' selected='N'>");
								filterXml.append("<ref_no>" + refId+ "</ref_no>");
								filterXml.append("<ref_date>" + refDate+ "</ref_date>");
								filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
								filterXml.append("<curr_code>" + currCode+ "</curr_code>");
								filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
								filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
								filterXml.append("<tran_id>" + tranId+ "</tran_id>");
								filterXml.append("<tran_type>" + tranType+ "</tran_type>");
								filterXml.append("<acct_code>" + acctCode+ "</acct_code>");
								filterXml.append("<cctr_code>" + cctrCode+ "</cctr_code>");
								filterXml.append("<sundry_code>" + sundryCode+ "</sundry_code>");
								filterXml.append("<status>" + status+ "</status>");
								filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
								filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
								filterXml.append("<tran_name>" + tranName+ "</tran_name>");
								filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
								filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
								filterXml.append("</Detail>");
							}
					}
			}*/
			}else if(fromDate.length() == 0 && filterData.trim().length() > 0){
				
			   for(int i=0 ; i<lengthOld ; i++)
			{
				tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom1.getElementsByTagName("Detail").item(i)));
				System.out.println("tranName : "+tranName);
				
				if(tranName.equalsIgnoreCase("bankStatement"))
				{
					System.out.println("in for : bankStatement when filter is not none...................");

					refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("refId : "+refId);
					tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("tranName : "+tranName);
					refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("refDate : "+refDate);
					tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("tranType : "+tranType);
					amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("amtBs : "+amtBs);
					currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("currCode : "+currCode);
					/*amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bs", dom.getElementsByTagName("Detail").item(i)));
   	   				System.out.println("amtBs : "+amtBs);*/
					tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("tranType : "+tranType);
					tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("tranId : "+tranId);
					refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("refMode : "+refMode);
					effDate=checkNull(genericUtility.getColumnValueFromNode("eff_date", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("effDate : "+effDate);
					statNo=checkNull(genericUtility.getColumnValueFromNode("stat_no", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("statNo : "+statNo);
					statDate=checkNull(genericUtility.getColumnValueFromNode("stat_date", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("statDate : "+statDate);
					amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("amtAdj : "+amtAdj);
					status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("status : "+status);
					exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("exchRate : "+exchRate);
					tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("tranName : "+tranName);
					siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("siteCodeNew: "+siteCodeNew);
					bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("bankCodeNew: "+ bankCodeNew);
				}
				if(tranName.equalsIgnoreCase("bankTransaction"))
				{
					System.out.println("in for: bankTransaction when filter is not none................");
					refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("refId : "+refId);
					refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("refDate : "+refDate);
					amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("amtBs : "+amtBs);
					currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("currCode : "+currCode);
					amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("amtBs : "+amtBs);
					refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("refMode : "+refMode);
					tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("tranId : "+tranId);
					tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("tranType : "+tranType);
					acctCode=checkNull(genericUtility.getColumnValueFromNode("acct_code", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("acctCode : "+acctCode);
					cctrCode=checkNull(genericUtility.getColumnValueFromNode("cctr_code", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("cctrCode : "+cctrCode);
					sundryCode=checkNull(genericUtility.getColumnValueFromNode("sundry_code", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("sundryCode : "+sundryCode);
					status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("status : "+status);
					exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("exchRate : "+exchRate);
					amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("amtAdj : "+amtAdj);
					tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("tranName : "+tranName);
					siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("siteCodeNew: "+siteCodeNew);
					bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("bankCodeNew: "+ bankCodeNew);
				}
				 rfDt = sdf1.parse(refDate);
				System.out.println("formatted ref date:: " + rfDt);
				
				//if(fromDate.length() > 0 && toDate.length() > 0){
					
				    //System.out.println("from date not null:: ");

				if (((amtBs.trim().equalsIgnoreCase(filterData.trim()) && "amt_bc".equalsIgnoreCase(filterList.trim())) 
						|| (refId.trim().equalsIgnoreCase(filterData.trim()) && "ref_no".equalsIgnoreCase(filterList.trim()))
						|| (refDate.trim().equalsIgnoreCase(filterData.trim()) && "ref_date".equalsIgnoreCase(filterList.trim()))))
						//&& ((frDt.before(rfDt) || frDt.equals(rfDt)) && (toDt.after(rfDt) || toDt.equals(rfDt))))
				  {
					System.out.println("Entering into filter data xml when filter is not none.....");
					
					tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
					System.out.println("tranName : "+tranName);
					if(tranName.equalsIgnoreCase("bankStatement"))
					{
						System.out.println("in if : bankStatement when filter is not none........");
						refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("refId : "+refId);
						tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranName : "+tranName);
						refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("refDate : "+refDate);
						tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranType : "+tranType);
						amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("amtBs : "+amtBs);
						currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("currCode : "+currCode);
						amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bs", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("amtBs : "+amtBs);
						tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranType : "+tranType);
						tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranId : "+tranId);
						refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("refMode : "+refMode);
						effDate=checkNull(genericUtility.getColumnValueFromNode("eff_date", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("effDate : "+effDate);
						statNo=checkNull(genericUtility.getColumnValueFromNode("stat_no", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("statNo : "+statNo);
						statDate=checkNull(genericUtility.getColumnValueFromNode("stat_date", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("statDate : "+statDate);
						amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("amtAdj : "+amtAdj);
						status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("status : "+status);
						exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("exchRate : "+exchRate);
						tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranName : "+tranName);
						siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("siteCodeNew: "+siteCodeNew);
						bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("bankCodeNew: "+ bankCodeNew);
					}
					if(tranName.equalsIgnoreCase("bankTransaction"))
					{
						System.out.println("in if bankTransaction when filter is not none........");
						refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("refId : "+refId);
						refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("refDate : "+refDate);
						amtBc=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("amtBc : "+amtBc);
						currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("currCode : "+currCode);
						amtBc=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("amtBc : "+amtBc);
						refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("refMode : "+refMode);
						tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranId : "+tranId);
						tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranType : "+tranType);
						acctCode=checkNull(genericUtility.getColumnValueFromNode("acct_code", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("acctCode : "+acctCode);
						cctrCode=checkNull(genericUtility.getColumnValueFromNode("cctr_code", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("cctrCode : "+cctrCode);
						sundryCode=checkNull(genericUtility.getColumnValueFromNode("sundry_code", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("sundryCode : "+sundryCode);
						status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("status : "+status);
						exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("exchRate : "+exchRate);
						amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("amtAdj : "+amtAdj);
						tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranName : "+tranName);
						siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("siteCodeNew: "+siteCodeNew);
						bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
						System.out.println("bankCodeNew: "+ bankCodeNew);
					}
					filterXml.append("<Detail domID='1' selected='N'>");
					System.out.println("record found::");
					if(tranName.equalsIgnoreCase("bankStatement"))
					{
						filterXml.append("<ref_no>" + refId+ "</ref_no>");
						filterXml.append("<tran_name>" + tranName+ "</tran_name>");
						filterXml.append("<ref_date>" + refDate+ "</ref_date>");
						filterXml.append("<tran_type>" + tranType+ "</tran_type>");
						filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
						filterXml.append("<curr_code>" + currCode+ "</curr_code>");
						filterXml.append("<amt_bs>" + amtBs+ "</amt_bs>");
						filterXml.append("<tran_type>" + tranType+ "</tran_type>");
						filterXml.append("<tran_id>" + tranId+ "</tran_id>");
						filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
						filterXml.append("<eff_date>" + effDate+ "</eff_date>");
						filterXml.append("<stat_no>" + statNo+ "</stat_no>");
						filterXml.append("<stat_date>" + statDate+ "</stat_date>");
						filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
						filterXml.append("<status>" + status+ "</status>");
						filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
						filterXml.append("<tran_name>" + tranName+ "</tran_name>");
						filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
						filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
					}
					if(tranName.equalsIgnoreCase("bankTransaction"))
					{
						filterXml.append("<ref_no>" + refId+ "</ref_no>");
						filterXml.append("<ref_date>" + refDate+ "</ref_date>");
						filterXml.append("<amt_bc>" + amtBc+ "</amt_bc>");
						filterXml.append("<curr_code>" + currCode+ "</curr_code>");
						filterXml.append("<amt_bc>" + amtBc+ "</amt_bc>");
						filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
						filterXml.append("<tran_id>" + tranId+ "</tran_id>");
						filterXml.append("<tran_type>" + tranType+ "</tran_type>");
						filterXml.append("<acct_code>" + acctCode+ "</acct_code>");
						filterXml.append("<cctr_code>" + cctrCode+ "</cctr_code>");
						filterXml.append("<sundry_code>" + sundryCode+ "</sundry_code>");
						filterXml.append("<status>" + status+ "</status>");
						filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
						filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
						filterXml.append("<tran_name>" + tranName+ "</tran_name>");
						filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
						filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
					}
					filterXml.append("</Detail>");	
					System.out.println("filterXm: :"+filterXml);
				}// end of if checking equality condition of ref id
				//}//from date and to date not null
				else if("ref_date".equalsIgnoreCase(filterList) && fromDate.length() == 0) {
					
				          if((amtBs.trim().equalsIgnoreCase(filterData.trim()) && "amt_bc".equalsIgnoreCase(filterList.trim())) 
							|| (refId.trim().equalsIgnoreCase(filterData.trim()) && "ref_no".equalsIgnoreCase(filterList.trim()))
						|| (filDt.equals(rfDt) && "ref_date".equalsIgnoreCase(filterList.trim()))) 		
					{
						System.out.println("Entering into filter data xml..when filter is ref date.");
						
						tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranName : "+tranName);
						if(tranName.equalsIgnoreCase("in else if bankStatement when filter is ref date..."))
						{
							System.out.println("bankStatement........");
							refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refId : "+refId);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refDate : "+refDate);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBs : "+amtBs);
							currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("currCode : "+currCode);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bs", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBs : "+amtBs);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranId : "+tranId);
							refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refMode : "+refMode);
							effDate=checkNull(genericUtility.getColumnValueFromNode("eff_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("effDate : "+effDate);
							statNo=checkNull(genericUtility.getColumnValueFromNode("stat_no", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("statNo : "+statNo);
							statDate=checkNull(genericUtility.getColumnValueFromNode("stat_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("statDate : "+statDate);
							amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtAdj : "+amtAdj);
							status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("status : "+status);
							exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("exchRate : "+exchRate);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("siteCodeNew: "+siteCodeNew);
							bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("bankCodeNew: "+ bankCodeNew);
						}
						if(tranName.equalsIgnoreCase("bankTransaction"))
						{
							System.out.println("in else if bankTransaction when filter is ref date........");
							refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refId : "+refId);
							refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refDate : "+refDate);
							amtBc=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBc : "+amtBc);
							currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("currCode : "+currCode);
							amtBc=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBc : "+amtBc);
							refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refMode : "+refMode);
							tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranId : "+tranId);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							acctCode=checkNull(genericUtility.getColumnValueFromNode("acct_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("acctCode : "+acctCode);
							cctrCode=checkNull(genericUtility.getColumnValueFromNode("cctr_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("cctrCode : "+cctrCode);
							sundryCode=checkNull(genericUtility.getColumnValueFromNode("sundry_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("sundryCode : "+sundryCode);
							status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("status : "+status);
							exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("exchRate : "+exchRate);
							amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtAdj : "+amtAdj);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("siteCodeNew: "+siteCodeNew);
							bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("bankCodeNew: "+ bankCodeNew);
						}
						filterXml.append("<Detail domID='1' selected='N'>");
						System.out.println("record found::");
						if(tranName.equalsIgnoreCase("bankStatement"))
						{
							filterXml.append("<ref_no>" + refId+ "</ref_no>");
							filterXml.append("<tran_name>" + tranName+ "</tran_name>");
							filterXml.append("<ref_date>" + refDate+ "</ref_date>");
							filterXml.append("<tran_type>" + tranType+ "</tran_type>");
							filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
							filterXml.append("<curr_code>" + currCode+ "</curr_code>");
							filterXml.append("<amt_bs>" + amtBs+ "</amt_bs>");
							filterXml.append("<tran_type>" + tranType+ "</tran_type>");
							filterXml.append("<tran_id>" + tranId+ "</tran_id>");
							filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
							filterXml.append("<eff_date>" + effDate+ "</eff_date>");
							filterXml.append("<stat_no>" + statNo+ "</stat_no>");
							filterXml.append("<stat_date>" + statDate+ "</stat_date>");
							filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
							filterXml.append("<status>" + status+ "</status>");
							filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
							filterXml.append("<tran_name>" + tranName+ "</tran_name>");
							filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
							filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
						}
						if(tranName.equalsIgnoreCase("bankTransaction"))
						{
							filterXml.append("<ref_no>" + refId+ "</ref_no>");
							filterXml.append("<ref_date>" + refDate+ "</ref_date>");
							filterXml.append("<amt_bc>" + amtBc+ "</amt_bc>");
							filterXml.append("<curr_code>" + currCode+ "</curr_code>");
							filterXml.append("<amt_bc>" + amtBc+ "</amt_bc>");
							filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
							filterXml.append("<tran_id>" + tranId+ "</tran_id>");
							filterXml.append("<tran_type>" + tranType+ "</tran_type>");
							filterXml.append("<acct_code>" + acctCode+ "</acct_code>");
							filterXml.append("<cctr_code>" + cctrCode+ "</cctr_code>");
							filterXml.append("<sundry_code>" + sundryCode+ "</sundry_code>");
							filterXml.append("<status>" + status+ "</status>");
							filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
							filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
							filterXml.append("<tran_name>" + tranName+ "</tran_name>");
							filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
							filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
						}
						filterXml.append("</Detail>");	
						System.out.println("filterXm: :"+filterXml);
					}
				}else{
					if((amtBs.trim().equalsIgnoreCase(filterData.trim()) && "amt_bc".equalsIgnoreCase(filterList.trim())) 
							|| (refId.trim().equalsIgnoreCase(filterData.trim()) && "ref_no".equalsIgnoreCase(filterList.trim()))
						|| (refDate.trim().equalsIgnoreCase(filterData.trim()) && "ref_date".equalsIgnoreCase(filterList.trim())))		
					{
						System.out.println("Entering into filter data xml... ");
						
						tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
						System.out.println("tranName : "+tranName);
						if(tranName.equalsIgnoreCase("in else if bankStatement when filter is not none..."))
						{
							System.out.println("bankStatement........");
							refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refId : "+refId);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refDate : "+refDate);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBs : "+amtBs);
							currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("currCode : "+currCode);
							amtBs=checkNull(genericUtility.getColumnValueFromNode("amt_bs", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBs : "+amtBs);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranId : "+tranId);
							refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refMode : "+refMode);
							effDate=checkNull(genericUtility.getColumnValueFromNode("eff_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("effDate : "+effDate);
							statNo=checkNull(genericUtility.getColumnValueFromNode("stat_no", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("statNo : "+statNo);
							statDate=checkNull(genericUtility.getColumnValueFromNode("stat_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("statDate : "+statDate);
							amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtAdj : "+amtAdj);
							status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("status : "+status);
							exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("exchRate : "+exchRate);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("siteCodeNew: "+siteCodeNew);
							bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("bankCodeNew: "+ bankCodeNew);
						}
						if(tranName.equalsIgnoreCase("bankTransaction"))
						{
							System.out.println("in else if bankTransaction when filter is not none........");
							refId=checkNull(genericUtility.getColumnValueFromNode("ref_no", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refId : "+refId);
							refDate=checkNull(genericUtility.getColumnValueFromNode("ref_date", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refDate : "+refDate);
							amtBc=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBc : "+amtBc);
							currCode=checkNull(genericUtility.getColumnValueFromNode("curr_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("currCode : "+currCode);
							amtBc=checkNull(genericUtility.getColumnValueFromNode("amt_bc", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtBc : "+amtBc);
							refMode=checkNull(genericUtility.getColumnValueFromNode("ref_mode", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("refMode : "+refMode);
							tranId=checkNull(genericUtility.getColumnValueFromNode("tran_id", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranId : "+tranId);
							tranType=checkNull(genericUtility.getColumnValueFromNode("tran_type", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranType : "+tranType);
							acctCode=checkNull(genericUtility.getColumnValueFromNode("acct_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("acctCode : "+acctCode);
							cctrCode=checkNull(genericUtility.getColumnValueFromNode("cctr_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("cctrCode : "+cctrCode);
							sundryCode=checkNull(genericUtility.getColumnValueFromNode("sundry_code", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("sundryCode : "+sundryCode);
							status=checkNull(genericUtility.getColumnValueFromNode("status", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("status : "+status);
							exchRate=checkNull(genericUtility.getColumnValueFromNode("exch_rate", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("exchRate : "+exchRate);
							amtAdj=checkNull(genericUtility.getColumnValueFromNode("amt_adj", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("amtAdj : "+amtAdj);
							tranName=checkNull(genericUtility.getColumnValueFromNode("tran_name", dom.getElementsByTagName("Detail").item(i)));
							System.out.println("tranName : "+tranName);
							siteCodeNew=checkNull(genericUtility.getColumnValueFromNode("site_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("siteCodeNew: "+siteCodeNew);
							bankCodeNew=checkNull(genericUtility.getColumnValueFromNode("bank_code", dom1.getElementsByTagName("Detail").item(i)));
							System.out.println("bankCodeNew: "+ bankCodeNew);
						}
						filterXml.append("<Detail domID='1' selected='N'>");
						
						
						System.out.println("record found::");
						if(tranName.equalsIgnoreCase("bankStatement"))
						{
							filterXml.append("<ref_no>" + refId+ "</ref_no>");
							filterXml.append("<tran_name>" + tranName+ "</tran_name>");
							filterXml.append("<ref_date>" + refDate+ "</ref_date>");
							filterXml.append("<tran_type>" + tranType+ "</tran_type>");
							filterXml.append("<amt_bc>" + amtBs+ "</amt_bc>");
							filterXml.append("<curr_code>" + currCode+ "</curr_code>");
							filterXml.append("<amt_bs>" + amtBs+ "</amt_bs>");
							filterXml.append("<tran_type>" + tranType+ "</tran_type>");
							filterXml.append("<tran_id>" + tranId+ "</tran_id>");
							filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
							filterXml.append("<eff_date>" + effDate+ "</eff_date>");
							filterXml.append("<stat_no>" + statNo+ "</stat_no>");
							filterXml.append("<stat_date>" + statDate+ "</stat_date>");
							filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
							filterXml.append("<status>" + status+ "</status>");
							filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
							filterXml.append("<tran_name>" + tranName+ "</tran_name>");
							filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
							filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
						}
						if(tranName.equalsIgnoreCase("bankTransaction"))
						{
							filterXml.append("<ref_no>" + refId+ "</ref_no>");
							filterXml.append("<ref_date>" + refDate+ "</ref_date>");
							filterXml.append("<amt_bc>" + amtBc+ "</amt_bc>");
							filterXml.append("<curr_code>" + currCode+ "</curr_code>");
							filterXml.append("<amt_bc>" + amtBc+ "</amt_bc>");
							filterXml.append("<ref_mode>" + refMode+ "</ref_mode>");
							filterXml.append("<tran_id>" + tranId+ "</tran_id>");
							filterXml.append("<tran_type>" + tranType+ "</tran_type>");
							filterXml.append("<acct_code>" + acctCode+ "</acct_code>");
							filterXml.append("<cctr_code>" + cctrCode+ "</cctr_code>");
							filterXml.append("<sundry_code>" + sundryCode+ "</sundry_code>");
							filterXml.append("<status>" + status+ "</status>");
							filterXml.append("<exch_rate>" + exchRate+ "</exch_rate>");
							filterXml.append("<amt_adj>" + amtAdj+ "</amt_adj>");
							filterXml.append("<tran_name>" + tranName+ "</tran_name>");
							filterXml.append("<site_code>" + siteCodeNew + "</site_code>");
							filterXml.append("<bank_code>" + bankCodeNew + "</bank_code>");
						}
						filterXml.append("</Detail>");	

						System.out.println("filterXm: :"+filterXml);
					}
				}
				}//end of for loop
					}
			filterXml.append("</Detail2>");
			resultString = filterXml.toString();
			System.out.println("resultString>>>>>>>>>>> :"+resultString);

		}
		catch(SQLException e) {
			System.out.println("SQL Exception In getXMLTransData method of BankRecoWizIC Class : "+e.getMessage());
			e.printStackTrace();
		}
		catch(Exception ex) {
			System.out.println("Exception In getXMLTransData method of BankRecoWizIC Class : "+ex.getMessage());
			ex.printStackTrace();
		} finally {
			try {
				if(conn != null) {
					conn.close(); 
				}
				conn = null;

			} catch(Exception d) {
				d.printStackTrace(); 
			}
		}
		//return "";

		System.out.println("Final resultString (getFilterData)!!!!!!!!:"+resultString);
		return resultString;
	}





	/*private void getNoneFilterValue(String siteCode, String bankCode,String bankName, Connection conn) {
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();
		String sql = "";
		
		try {
			
			sql = "select BANK_NAME from bank where bank_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, bankCode.trim());
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				bankName = checkNull(rs.getString("BANK_NAME"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("bankName :"+bankName);

			valueXmlString.append("<Detail1>");
			valueXmlString.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>");
			valueXmlString.append("<bank_code><![CDATA[").append(bankCode).append("]]></bank_code>");
			valueXmlString.append("<bank_descr><![CDATA[").append(bankName).append("]]></bank_descr>");
			valueXmlString.append("</Detail1>");
			valueXmlString.append("<Detail2>");
			valueXmlString.append(getXMLTransData(conn,"","","",new StringBuffer(""),"CallByFilter","",siteCode,bankCode,""));
			valueXmlString.append("</Detail2>");
			


			System.out.println("value xml String when filter is none:::"+valueXmlString);//TODO
			//valueXmlString.toString();
			
			
		} catch (Exception e) {
			
		}
		
	}*/

	public String getValuesForPopHelp(String bankCode,String keyString){
		System.out.println("in getValuesForPopHelp EJB called222---------------");
		System.out.println("------changes for encoding-----------------");
		System.out.println("bankCode-->>["+bankCode+"]");
		System.out.println("keyString->>["+keyString+"]");
		String sql="",sundry;
		Connection conn1 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
//		GenericUtility genericUtility = GenericUtility.getInstance();
		//StringBuffer valueXmlString = new StringBuffer();

		/*valueXmlString.append("<?xml version='1.0' encoding='ISO-8859-1'?>" + 
		  "<?xml-stylesheet type=\"text/xsl\" href=\"../xsl/popup.xsl\"?>" + 
		  "<?xml-stylesheet type=\"text/css\" href=\"../css/xtree.css\"?>"); */
		StringBuffer valueXmlString = new StringBuffer("<?xml version='1.0' encoding='UTF-8'?><Root>\r\n");

		try 
		{
			ConnDriver connDriver = new ConnDriver();
			conn1 = connDriver.getConnectDB("DriverITM");
			//if("customer".equalsIgnoreCase(sundryType))
			sql = "select bank_code,bank_name from bank where bank_code like '"+keyString+"%' ";
			/*else if("supplier".equalsIgnoreCase(sundryType))
				sql="select supp_code,sh_name from supplier where supp_code like '"+keyString+"%'";
			else if("employee".equalsIgnoreCase(sundryType))
				sql="select emp_code,emp_fname || ' ' || emp_lname from employee where emp_code like '"+keyString+"%' ";
			else if("loan_party".equalsIgnoreCase(sundryType))
				sql="select party_code,party_name from loanparty where party_code like '"+keyString+"%' ";
			else if("tax_authority".equalsIgnoreCase(sundryType))
				sql="select tauth_code,tauth_name from tax_authority where tauth_code like '"+keyString+"%' ";
			else if("transporter".equalsIgnoreCase(sundryType))
				sql="select tran_code,tran_name from transporter where tran_code like '"+keyString+"%' ";
			else if("sales_pers".equalsIgnoreCase(sundryType))
				sql="select sales_pers,sp_name from sales_pers where sales_pers like '"+keyString+"%' ";
			else if("strg_customer".equalsIgnoreCase(sundryType))
				sql="select sc_code,first_name || ' ' || last_name from strg_customer where sc_code like '"+keyString+"%' ";*/

			System.out.println("Sql getValuesForPopHelp-->>["+sql+"]");
			pstmt = conn1.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int num = 1;
			while (rs.next()) 
			{
				valueXmlString.append("<Detail domID='" + num	+ "'>\r\n");
				valueXmlString.append("<bank_code><![CDATA[").append(rs.getString(1)).append("]]></bank_code>\r\n");
				valueXmlString.append("<bank_name><![CDATA[").append(rs.getString(2)).append("]]></bank_name>\r\n");				

				valueXmlString.append("</Detail>\r\n");
				num++;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null ;

		}
		catch(Exception e){
			System.out.println("Exception in getValuesForPopHelp.............");
			e.printStackTrace();			
		}
		finally{
			try{
				if(conn1!=null){
					conn1.close();
				}
			}
			catch(Exception e){
				e.printStackTrace();
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString ::[[" + valueXmlString.toString()	+"]]:********");
		return valueXmlString.toString();

	}



	public List<String> listOfTranId(String key ,String tableName,String autoRecoFilter,String siteCode,String bankCode,Connection conn)
	{
		String sql="",refNo="",refDate="",tranId="";
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		List<String> tranIdList = new ArrayList<String>(); 

		String refDateTemp="";
		//Timestamp refDateTemp1= null;

		try
		{


			String[] keyArray = key.split(":");


			sql = "SELECT tran_id from " + tableName + " where ";

			if("REFNO_DATE_AMT".equalsIgnoreCase(autoRecoFilter))
			{
				refNo=keyArray[0].toString();
				refDate=keyArray[1].toString();
                
				String format= genericUtility.getApplDateFormat();
				System.out.println("@@@@@ format["+format+"]");
				
				SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");
			    java.util.Date varDate=dateFormat.parse(refDate);
			    dateFormat=new SimpleDateFormat(format);
			    refDateTemp = dateFormat.format(varDate);
				System.out.println("@@@@@@@@@ refDateTemp["+refDateTemp+"]");
				
				//refDateTemp1 = Timestamp.valueOf(genericUtility.getValidDateString(refDateTemp, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
				//refDateTemp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(refDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				System.out.println("@@@@@@@1refDate["+refDate+"]::::refDateTemp1["+refDateTemp+"]");
				sql = sql + " ref_no='"+refNo+"'  and  ref_date = '"+refDateTemp+"'   ";
				//sql = sql + " ref_no='"+refNo+"'  and  trim(ref_date)='"+refDate+"'   ";
			}
			else if("REFNO_AMT".equalsIgnoreCase(autoRecoFilter))
			{
				refNo=keyArray[0].toString();
				sql = sql + " ref_no='"+refNo+"' ";
			}
			else if("REFDATE_AMT".equalsIgnoreCase(autoRecoFilter))
			{
				refDate=keyArray[0].toString();
				
				String format= genericUtility.getApplDateFormat();
				System.out.println("@@@@@ format["+format+"]");
				
				SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");
			    java.util.Date varDate=dateFormat.parse(refDate);
			    dateFormat=new SimpleDateFormat(format);
			    refDateTemp = dateFormat.format(varDate);
				System.out.println("@@@@@@@@@ refDateTemp["+refDateTemp+"]");
				
				//refDateTemp = Timestamp.valueOf(genericUtility.getValidDateString(refDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
				//refDateTemp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(refDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				System.out.println("@@@@@@@2refDate["+refDate+"]::::refDateTemp["+refDateTemp+"]");
				sql = sql + " ref_date = '"+refDateTemp+"' ";
				//sql = sql + " trim(ref_date)='"+refDate+"' ";
			}

			sql = sql + "and  site_code=? and bank_code=? and status in ('E', 'P')";	

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			pstmt.setString(2,bankCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{					
				tranId=rs.getString("tran_id");
				tranIdList.add(tranId);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		return tranIdList;

	}


	private String checkNull(String str)
	{
		if(str == null)
		{
			return "";
		}
		else
		{
			return str.trim() ;
		}

	}

	/*@Override
	public String getValuesForPopHelp(String sundryType) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getValuesForPopHelp(String sundryType, String keyString) {
		// TODO Auto-generated method stub
		return null;
	}*/
}