/**
 * PURPOSE : Post Save to update header from detail
 * AUTHOR : Abhishek Jaiswal
 * DATE : 20/02/2015
 */
package ibase.webitm.ejb.adm;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

import org.w3c.dom.*;


@javax.ejb.Stateless
public class EmpOvertimePos extends ValidatorEJB implements EmpOvertimePosLocal, EmpOvertimePosRemote
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String tranId, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{

		String errCode = "";
		String userId = "";
		String chgTerm = "";
		String loginEmpCode = "";
		String sql = "";
		String errString = "";

		int totOtMinutes = 0;
		int totCalOtMinutes = 0;
		int empoTimeUpdCnt = 0;

		double totOtHours = 0d;
		double totCalOtHours = 0d;

		Timestamp  currDate = null;

		PreparedStatement pstmt = null;		
		ResultSet rs = null;

		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();		
		AdmCommon admCommon = new AdmCommon();
		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			loginEmpCode  = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");

			sql = "SELECT FN_HRS_TO_MIN(A.OT_HOURS_TIME) AS OT_HOURS_TIME, FN_HRS_TO_MIN(A.CAL_OT_HRS_TIME) AS CAL_OT_HRS_TIME FROM EMPOTIME_DET A WHERE A.TRAN_ID = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				totOtMinutes = totOtMinutes + rs.getInt("OT_HOURS_TIME");
				totCalOtMinutes = totCalOtMinutes + rs.getInt("CAL_OT_HRS_TIME");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			sql = "SELECT FN_MIN_TO_DEC_HRS(?) AS TOT_OT_HOURS_TIME, FN_MIN_TO_DEC_HRS(?) AS TOT_CAL_OT_HRS_TIME FROM DUAL";

			pstmt = conn.prepareStatement(sql);
			pstmt.setInt(1, totOtMinutes);
			pstmt.setInt(2, totCalOtMinutes);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				totOtHours = rs.getDouble("TOT_OT_HOURS_TIME");
				totCalOtHours = rs.getDouble("TOT_CAL_OT_HRS_TIME");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "UPDATE EMPOTIME SET OT_HOURS = ROUND(? / 60 , 2) , CAL_OT_HOURS = ROUND(? / 60 , 2) , OT_HOURS_TIME = ? , CAL_OT_HRS_TIME = ? , CHG_DATE = ? , CHG_USER = ? , CHG_TERM = ? WHERE TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);

			pstmt.setDouble(1 , totOtMinutes);
			pstmt.setDouble(2 , totCalOtMinutes);
			pstmt.setDouble(3 , totOtHours);
			pstmt.setDouble(4 , totCalOtHours);
			pstmt.setTimestamp(5 , currDate);
			pstmt.setString(6 , userId);
			pstmt.setString(7, chgTerm);
			pstmt.setString(8 , tranId);

			empoTimeUpdCnt = pstmt.executeUpdate();
			System.out.println("EmpOvertimePos - EMPOTIME UPDATE COUNT [" + empoTimeUpdCnt + "]");

			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			try
			{

				System.out.println("Exception IN EmpOvertimePos::::"+e.getMessage());
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		}
		finally
		{
			try
			{	
				if(errString != null && errString.trim().length() > 0)
				{
					{
						conn.rollback();
					}
				}

				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception "+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}

	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal.trim();
	}

}

