package com.google.gwt.user.cellview.client;

import ibase.e12ria.e12widgets.client.E12PopupPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.ImageResource.ImageOptions;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.Range;

public class E12SimplePager extends AbstractPager {
	public static interface Resources extends ClientBundle {

	   @ImageOptions(flipRtl = true)
	    ImageResource simplePagerFastForward();
	
	    @ImageOptions(flipRtl = true)
	    ImageResource simplePagerFastForwardDisabled();
	    
	    
	    @ImageOptions(flipRtl = true)
	    ImageResource simplePagerFirstPage();
	
	    @ImageOptions(flipRtl = true)
	    ImageResource simplePagerFirstPageDisabled();
	
	    @ImageOptions(flipRtl = true)
	    ImageResource simplePagerLastPage();
	
	    @ImageOptions(flipRtl = true)
	    ImageResource simplePagerLastPageDisabled();
	    
	    //Next Image
	    @ImageOptions(flipRtl = true)
	    ImageResource pagerNext();
	
	    @ImageOptions(flipRtl = true)
	    ImageResource simplePagerNextPageDisabled();
	
	    //Previous Image
	    @ImageOptions(flipRtl = true)
	    ImageResource pagerPrev();
	
	    @ImageOptions(flipRtl = true)
	    ImageResource simplePagerPreviousPageDisabled();
	    
	    //Setting Image
	    @ImageOptions(flipRtl = true)
	    ImageResource pagerSetting();
	
	    @Source("SimplePager.css")
	    Style e12simplePagerStyle();
	}

  /**
   * Styles used by this widget.
   */
	public static interface Style extends CssResource {
	    /**
	     * Applied to buttons.
	     */
		String button();
	
	    /**
	     * Applied to disabled buttons.
	     */
	    String disabledButton();
	
	    /**
	     * Applied to the details text.
	     */
	    String pageDetails();
	}

  /**
   * The location of the text relative to the paging buttons.
   */
	public static enum TextLocation {
	    CENTER, LEFT, RIGHT;
	}
	
	  /**
	   * An {@link Image} that acts as a button.
	   */
	private static class ImageButton extends Image {
	    private boolean disabled;
	    private final ImageResource resDisabled;
	    private final ImageResource resEnabled;
	    private final String styleDisabled;

	    public ImageButton(ImageResource resEnabled, ImageResource resDiabled,String disabledStyle) {
	    	super(resEnabled);
		    this.resEnabled = resEnabled;
		    this.resDisabled = resDiabled;
		    this.styleDisabled = disabledStyle;
	    }

	    public boolean isDisabled() {
	    	return disabled;
	    }

	    @Override
	    public void onBrowserEvent(Event event) {
	      // Ignore events if disabled.
	    	if (disabled) {
	    		return;
		    }
	    	super.onBrowserEvent(event);
	    }

	    public void setDisabled(boolean isDisabled) {
	    	if (this.disabled == isDisabled) {
	    	  return;
	    	}
	    	this.disabled = isDisabled;
	    	if (disabled) {
	    		setResource(resDisabled);
	    		getElement().getParentElement().addClassName(styleDisabled);
	    	} else {
	    		setResource(resEnabled);
	    		getElement().getParentElement().removeClassName(styleDisabled);
	    	}
	    }
	}
	
	private static int DEFAULT_FAST_FORWARD_ROWS = 1000;
	private static Resources DEFAULT_RESOURCES;

	private static Resources getDefaultResources() {
		if (DEFAULT_RESOURCES == null) {
			DEFAULT_RESOURCES = GWT.create(Resources.class);
	    }
	    return DEFAULT_RESOURCES;
	}

	private final ImageButton fastForward;
	private final int fastForwardRows;
	private final ImageButton firstPage;

	/**
	 * We use an {@link HTML} so we can embed the loading image.
	 */
	private final HTML pagerLabel = new HTML();
	private final ImageButton lastPage;

	private final ImageButton nextPage;
	private final ImageButton prevPage;
	private final ImageButton settingPage;
	
	
	/**
	 * The {@link Resources} used by this widget.
	 */
	private final Resources resources;

	/**
	 * The {@link Style} used by this widget.
	 */
	private final Style style;

	  /**
	   * Construct a {@link E12SimplePager} with the default text location.
	   */
	public E12SimplePager() {
	    this(TextLocation.CENTER);
	}

	  /**
	   * Construct a {@link E12SimplePager} with the specified text location.
	   * 
	   * @param location the location of the text relative to the buttons
	   */
	@UiConstructor
	  // Hack for Google I/O demo
	public E12SimplePager(TextLocation location) {
		this(location, getDefaultResources(), true, DEFAULT_FAST_FORWARD_ROWS,false);
	}
	
	private Label rangeLabel = new Label();
	private TextBox rangeTxtField = new TextBox();
	private Command rangeCommand;
	
	
	/**
	* Construct a {@link E12SimplePager} with the specified resources.
	* 
	* @param location the location of the text relative to the buttons
	* @param resources the {@link Resources} to use
	* @param showFastForwardButton if true, show a fast-forward button that
	*          advances by a larger increment than a single page
	* @param fastForwardRows the number of rows to jump when fast forwarding
	* @param showLastPageButton if true, show a button to go the the last page
	*/
	public E12SimplePager(TextLocation location, Resources resources, boolean showFastForwardButton,  int fastForwardRows, boolean showLastPageButton) 
	{
		this.resources = resources;
		this.fastForwardRows = fastForwardRows;
		this.style = resources.e12simplePagerStyle();
		this.style.ensureInjected();
		
		// Create the buttons.
		String disabledStyle = style.disabledButton();
		//
		settingPage= new ImageButton(resources.pagerSetting(),resources.pagerSetting(),disabledStyle);
		settingPage.setStyleName("e12Pager-setting");
		settingPage.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				final E12PopupPanel pagerSettingPopup = new E12PopupPanel(true, true, "bottom", false);
				HorizontalPanel rowNoHPanel = new HorizontalPanel();
				rangeLabel.setText("Show the range upto:"); 
				//rangeTxtField.setText("50");
				rangeTxtField.setWidth("50px");
				rowNoHPanel.add( rangeLabel );
				rowNoHPanel.add( rangeTxtField );
				rowNoHPanel.setWidth("100%");
				
				Button rangeButton = new Button("Apply");
				rangeButton.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						if( rangeCommand != null )
						{
							rangeCommand.execute();
							if(!rangeTxtField.getText().contains("Error")){
								pagerSettingPopup.hide();	
							}
							else{
							rangeTxtField.setText("");
							}
						}
					}
				});
				rangeTxtField.addKeyUpHandler(new KeyUpHandler() {
					@Override
					public void onKeyUp(KeyUpEvent event) {
						int keyCode = event.getNativeKeyCode();
						if( keyCode == KeyCodes.KEY_ENTER && rangeCommand != null )
						{
							rangeCommand.execute();
							if(!rangeTxtField.getText().contains("Error")){
								pagerSettingPopup.hide();	
							}
							else{
								rangeTxtField.setText("");
							}
						}
					}
				});
				rangeButton.setStyleName("button green-Btn");
				rangeButton.getElement().setAttribute("style", "top:10px;");
				HorizontalPanel hPanel = new HorizontalPanel();
				hPanel.add(rangeButton);
				hPanel.setWidth("100%");
				hPanel.setCellHorizontalAlignment(rangeButton, HasHorizontalAlignment.ALIGN_RIGHT);
				
				
				VerticalPanel pagerSettingVPanel = new VerticalPanel();
				pagerSettingVPanel.setSpacing ( 6 );
				pagerSettingVPanel.add(rowNoHPanel);
				pagerSettingVPanel.add(hPanel);
				pagerSettingVPanel.setWidth("100%");

				
				pagerSettingPopup.getElement().getFirstChildElement().getStyle().setPaddingLeft( 13, Unit.PX );
				pagerSettingPopup.setWidth("250px") ;
				pagerSettingPopup.add(pagerSettingVPanel);
				pagerSettingPopup.showRelativeTo(settingPage);
				pagerSettingPopup.setPopupPosition(pagerSettingPopup.getAbsoluteLeft() + 35, pagerSettingPopup.getAbsoluteTop() + 31) ;
				/*settingPopupPanel.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
					@Override
					public void setPosition(int offsetWidth, int offsetHeight) {
						int right = ((Window.getClientWidth() - offsetWidth)-58);
				        int bottom = ((Window.getClientHeight() - offsetHeight)-40);
				        settingPopupPanel.setPopupPosition(right, bottom);	
					}
				}); */  
			}	
		});
			   
		//
		firstPage = new ImageButton(resources.simplePagerFirstPage(),resources.simplePagerFirstPageDisabled(), disabledStyle);
		firstPage.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				firstPage();
			}
		});
		nextPage = new ImageButton(resources.pagerNext(),resources.pagerNext(), disabledStyle);
		nextPage.setStyleName("nextPageButton");
		nextPage.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				nextPage();
			}
		});
		prevPage = new ImageButton(resources.pagerPrev(),resources.pagerPrev(), disabledStyle);
		prevPage.setStyleName("prevPageButton");
		prevPage.addClickHandler(new ClickHandler() {
			public void onClick(ClickEvent event) {
				previousPage();
		    }
		});
		if (showLastPageButton) {
			lastPage = new ImageButton(resources.simplePagerLastPage(),resources.simplePagerLastPageDisabled(), disabledStyle);
			lastPage.addClickHandler(new ClickHandler() {
				public void onClick(ClickEvent event) {
					lastPage();
			    }
			});
		} else {
			lastPage = null;
		}
		if (showFastForwardButton) {
			fastForward = new ImageButton(resources.simplePagerFastForward(),resources.simplePagerFastForwardDisabled(), disabledStyle);
			fastForward.addClickHandler(new ClickHandler() {
				public void onClick(ClickEvent event) {
					setPage(getPage() + getFastForwardPages());
			    }
			});
	    } else {
	    	fastForward = null;
	    }
				
		pagerLabel.setStyleName("pagerLabel");
		
		HorizontalPanel labelLayout = new HorizontalPanel();
		labelLayout.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		labelLayout.add(pagerLabel);

		HorizontalPanel pagerLayout = new HorizontalPanel();
		pagerLayout.add(settingPage);
		pagerLayout.setCellHorizontalAlignment(settingPage, HasHorizontalAlignment.ALIGN_CENTER);
		pagerLayout.setCellVerticalAlignment(settingPage, HasVerticalAlignment.ALIGN_MIDDLE);
		pagerLayout.add(prevPage);
		pagerLayout.setCellHorizontalAlignment(prevPage, HasHorizontalAlignment.ALIGN_CENTER);
		pagerLayout.setCellVerticalAlignment(prevPage, HasVerticalAlignment.ALIGN_MIDDLE);
		pagerLayout.add(nextPage);
		pagerLayout.setCellHorizontalAlignment(nextPage, HasHorizontalAlignment.ALIGN_CENTER);
		pagerLayout.setCellVerticalAlignment(nextPage, HasVerticalAlignment.ALIGN_MIDDLE);
		pagerLayout.setStyleName("e12pager-nav-button");
		
		// Construct the widget.
		HorizontalPanel layout = new HorizontalPanel();
		layout.setWidth("100%");
		layout.add(labelLayout);
		layout.setCellWidth(labelLayout, "85%");
		layout.add(pagerLayout);
		layout.setCellWidth(pagerLayout, "15%");
		
		if (showFastForwardButton) {
			fastForward.getElement().getParentElement().addClassName(style.button());
		}
		if (showLastPageButton) {
			lastPage.getElement().getParentElement().addClassName(style.button());
		}
		// Disable the buttons by default.
		setDisplay(null);
		initWidget(layout);
	}
	
	@Override
	public void firstPage() {
		super.firstPage();
	}

	@Override
	public int getPage() {
	    return super.getPage();
	}

	@Override
	public int getPageCount() {
	    return super.getPageCount();
	}

	@Override
	public boolean hasNextPage() {
	    return super.hasNextPage();
	}

	@Override
	public boolean hasNextPages(int pages) {
	    return super.hasNextPages(pages);
	}

	@Override
	public boolean hasPage(int index) {
	    return super.hasPage(index);
	} 

	@Override
	public boolean hasPreviousPage() {
	    return super.hasPreviousPage();
	}

	@Override
	public boolean hasPreviousPages(int pages) {
		return super.hasPreviousPages(pages);
	}

	@Override
	public void lastPage() {
	    super.lastPage();
	}

	@Override
	public void lastPageStart() {
	    super.lastPageStart();
	}

	@Override
	public void nextPage() {
	    super.nextPage();
	}

	@Override
	public void previousPage() {
	    super.previousPage();
	}
	
	@Override
	public void setDisplay(HasRows display) {
	    // Enable or disable all buttons.
		boolean disableButtons = (display == null);
	    setFastForwardDisabled(disableButtons);
	    setNextPageButtonsDisabled(disableButtons);
	    setPrevPageButtonsDisabled(disableButtons);
	    super.setDisplay(display);
	}

	@Override
	public void setPage(int index) {
	    super.setPage(index);
	}

	@Override
	public void setPageSize(int pageSize) {
	    super.setPageSize(pageSize);
	}

	@Override
	public void setPageStart(int index) {
	    super.setPageStart(index);
	}

	/**
	 * Let the page know that the table is loading. Call this method to clear all
	 * data from the table and hide the current range when new data is being
	 * loaded into the table.
	 */
	public void startLoading() {
	    getDisplay().setRowCount(0, true);
	    pagerLabel.setHTML("");
	}

	/**
	 * Get the text to display in the pager that reflects the state of the pager.
	 * 
	 * @return the text
	 */
	protected String createText() {
	    // Default text is 1 based.
	    NumberFormat formatter = NumberFormat.getFormat("#,###");
	    HasRows display = getDisplay();
	    Range range = display.getVisibleRange();
	    int pageStart = range.getStart() + 1;
	    int pageSize = range.getLength();
	    int dataSize = display.getRowCount();
	    int endIndex = Math.min(dataSize, pageStart + pageSize - 1);
	    endIndex = Math.max(pageStart, endIndex);
	    boolean exact = display.isRowCountExact();
	    return formatter.format(pageStart) + "-" + formatter.format(endIndex)
	        + (exact ? " of " : " of over ") + formatter.format(dataSize);
	}

	@Override
	protected void onRangeOrRowCountChanged() {
		HasRows display = getDisplay();
		pagerLabel.setText("Displaying records "+createText());
	    
	    // Update the prev and first buttons.
	    setPrevPageButtonsDisabled(!hasPreviousPage());

	    // Update the next and last buttons.
	    if (isRangeLimited() || !display.isRowCountExact()) {
	    	setNextPageButtonsDisabled(!hasNextPage());
	    	setFastForwardDisabled(!hasNextPages(getFastForwardPages()));
	    }
	}

	/**
	 * Check if the next button is disabled. Visible for testing.
	 */
	boolean isNextButtonDisabled() {
	    return nextPage.isDisabled();
	}

	/**
	 * Check if the previous button is disabled. Visible for testing.
	 */
	boolean isPreviousButtonDisabled() {
	    return prevPage.isDisabled();
	}

	/**
	 * Get the number of pages to fast forward based on the current page size.
	 * 
	 * @return the number of pages to fast forward
	 */
	private int getFastForwardPages() {
	    int pageSize = getPageSize();
	    return pageSize > 0 ? fastForwardRows / pageSize : 0;
	}

	/**
	  * Enable or disable the fast forward button.
	  * 
	  * @param disabled true to disable, false to enable
	  */
	private void setFastForwardDisabled(boolean disabled) {
	    if (fastForward == null) {
	    	return;
	    }
	    if (disabled) {
	    	fastForward.setResource(resources.simplePagerFastForwardDisabled());
	    	fastForward.getElement().getParentElement().addClassName(style.disabledButton());
	    } else {
	    	fastForward.setResource(resources.simplePagerFastForward());
	    	fastForward.getElement().getParentElement().removeClassName(style.disabledButton());
	    }
	}

	/**
	 * Enable or disable the next page buttons.
	 * 
	 * @param disabled true to disable, false to enable
	 */
	private void setNextPageButtonsDisabled(boolean disabled) {
		nextPage.setDisabled(disabled);
	    if (lastPage != null) {
	    	lastPage.setDisabled(disabled);
	    }
	}

	/**
	 * Enable or disable the previous page buttons.
	 * 
	 * @param disabled true to disable, false to enable
	 */
	private void setPrevPageButtonsDisabled(boolean disabled) {
		firstPage.setDisabled(disabled);
	    prevPage.setDisabled(disabled);
	}
	
	public String getRangeText(){
		return this.rangeTxtField.getText();
	}

	public void setRangeText( String rangeText ){
		this.rangeTxtField.setText( rangeText );
	}
	
	public void setRangeLabel( String rangeLabel ){
		this.rangeLabel.setText( rangeLabel );
	}

	public void setRangeCommand( Command rangeCommand ){
		this.rangeCommand = rangeCommand;
	}

}
