package ibase.dashboard.scm.servlet;
import ibase.dashboard.scm.ejb.SupplierInfoRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class PendingPurchaseServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData =null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}
  
	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		SupplierInfoRemote suppInfoRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String suppCode       = "";
		String prdCode        = "";
		String reportName     = "";
		try
		{
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			dataSourceName  =request.getParameter("dataSourceName"); 
			suppCode        =request.getParameter("suppCode");
			prdCode        	=request.getParameter("prdCode");
			reportName    	  = request.getParameter("reportName"); 
			session.setAttribute("reportName", reportName);
			System.out.println("reportName is =" + reportName );
			System.out.println("in doPost" + "suppCode is =" + suppCode );
			System.out.println( "prdCode is =" + prdCode );
			context = new InitialContext(appConnectParm.getProperty());
			suppInfoRemote = (SupplierInfoRemote)context.lookup("ibase/SupplierInfoEJB/remote");
			/*setUserInfo(userInfo) for DB connection on dated:14062016*/
			suppInfoRemote.setUserInfo(userInfo);
			JSONObject jsonObjData      = (JSONObject)suppInfoRemote.getPendingPurchase(suppCode,prdCode,dataSourceName);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for PendingPurchaseServlet build the Graph is===" + jsonObjData);	

		} catch (Exception e)
		{
			System.out.println("Exception : PendingPurchaseServlet :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
		
	}
}