CREATE TABLE SORDER_TEMP(
SALE_ORDER      CHAR(10)     NOT NULL,
ORDER_DATE    DATE        NOT NULL,
TRAN_DATE      DATE,       
ORDER_TYPE       VARCHAR2(3),
SITE_CODE  CHAR(5)        NOT NULL,       
ITEM_SER        CHAR(5),  
CUST_CODE       CHAR(10)    NOT NULL,
CUST_CODE__DLV       CHAR(10)    NOT NULL,
CUST_CODE__BIL       CHAR(10)    NOT NULL,
CR_TERM         CHAR(5)        NOT NULL, 
CRTERM_DESCR    VARCHAR2(40),
REMARKS         VARCHAR2(310),
DLV_TERM        CHAR(5)        NOT NULL,
TRAN_CODE       CHAR(10),
TRANS_MODE      CHAR(1),
PRICE_LIST      CHAR(5),   
EXCH_RATE       NUMBER(17,6),
CURR_CODE       CHAR(5), 
TERM_TABLE      CHAR(5),
UDF__STR1      VARCHAR2(25),
UDF__NUM2      VARCHAR2(25),
EMP_CODE        CHAR(10),
CHG_DATE        DATE,    
CHG_USER        CHAR(10), 
CHG_TERM        CHAR(15),
STATUS        CHAR(1),
DLV_ADD1 varchar2(50),
DLV_ADD2 varchar2(50),
DLV_ADD3 varchar2(50),
DLV_CITY varchar2(20),
DLV_PIN varchar2(10),
STATE_CODE__DLV char(5),
COUNT_CODE__DLV char(5),
STAN_CODE char(5),
TEL1__DLV VARCHAR2(15),
TEL2__DLV VARCHAR2(15),
PART_QTY CHAR(1),
DUE_DATE    DATE
            
)tablespace ITM_DIS_D2;

ALTER TABLE SORDER_TEMP ADD ( CONSTRAINT SORDER_TEMP PRIMARY KEY ( SALE_ORDER )) ;
ALTER TABLE SORDER_TEMP ADD ( CONSTRAINT FK_SORDER_TEMP_CURR FOREIGN KEY ( CURR_CODE ) REFERENCES CURRENCY );
ALTER TABLE SORDER_TEMP ADD ( CONSTRAINT FK_SORDER_TEMP_EMP FOREIGN KEY ( EMP_CODE ) REFERENCES EMPLOYEE ) ;
ALTER TABLE SORDER_TEMP ADD ( CONSTRAINT FK_SORDER_TEMP_ITEMSER FOREIGN KEY ( ITEM_SER ) REFERENCES ITEMSER ) ;
ALTER TABLE SORDER_TEMP ADD ( CONSTRAINT FK_SORDER_TEMP_CUST FOREIGN KEY ( CUST_CODE ) REFERENCES CUSTOMER ) ;
ALTER TABLE SORDER_TEMP ADD ( CONSTRAINT FK_SORDER_TEMP_TRANS FOREIGN KEY ( TRAN_CODE ) REFERENCES TRANSPORTER ) ;
CREATE INDEX SORDER_TEMP_ORD_DATE ON SORDER_TEMP ( ORDER_DATE ) ;
CREATE UNIQUE INDEX SORDER_TEMP_X ON SORDER_TEMP ( SALE_ORDER ) ;



CREATE TABLE SORDDET_TEMP
(
SALE_ORDER     CHAR(10)     NOT NULL,
SITE_CODE     CHAR(5)     NOT NULL,
ITEM_CODE     CHAR(10)     NOT NULL,
QUANTITY     NUMBER(14,3),
TAB_NO       CHAR(3),
DSP_DATE    DATE
)tablespace ITM_DIS_D2;

--ALTER TABLE SORDDET_TEMP ADD ( CONSTRAINT SORDDET_TEMP_X PRIMARY KEY ( SALE_ORDER )) ;
ALTER TABLE SORDDET_TEMP ADD ( CONSTRAINT FK_SORDDET_TEMP_ITEM FOREIGN KEY ( ITEM_CODE ) REFERENCES ITEM ) ;
ALTER TABLE SORDDET_TEMP ADD ( CONSTRAINT FK_SORDDET_TEMP_SITE FOREIGN KEY ( SITE_CODE ) REFERENCES SITE ) ;
--CREATE INDEX KEY_SORDLNNOITMCODE_TEMP ON PORDDET_TEMP (SALE_ORDER , LINE_NO , ITEM_CODE ) ;

-----------------------------------------------------------------------------------------------------------------------------

INSERT INTO transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,
REF_SER,VIEW_MODE,AUDIT_TRAIL_OPT,PERIOD_OPTION,TRAN_ID_COL,APPLICATION,TABLE_NAME)
VALUES ('w_sorderWiz','2','2', 'A', 'seq10', sysdate,'BASE','BASE','0',
'S-ORD','F','2','M','SALE_ORDER','WMS','SORDER');

INSERT INTO transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,
REF_SER,VIEW_MODE,AUDIT_TRAIL_OPT,PERIOD_OPTION,TRAN_ID_COL,APPLICATION,TABLE_NAME)
VALUES ('w_sorderTemp','2','2', 'A', 'TMP,_seq07', sysdate,'BASE','BASE','0',
'SO_TMP','F','2','M','SALE_ORDER','WMS','SORDER');

Insert into refser (REF_SER,DESCR,TYPE,SEQ_NAME) 
values ('SO_TMP','TEMP SORDER','S','SORDTEMP_SEQ');

CREATE SEQUENCE SORDTEMP_SEQ
  MINVALUE 1
  MAXVALUE 9999999999
  START WITH 100
  INCREMENT BY 1
  CACHE 20;

-----------------------------------------------------------------------------------------------------------------------------
Insert into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,
ICON_PATH,OBJ_TYPE,MOB_DEPLOY,CHG_USER,CHG_TERM,CHG_DATE) 
values ('WMS',12,0,0,0,0,'-','Sales','Sales',
'WMS.12.0.0.0.0','e12_logo.gif','T','','BASE','BASE',sysdate); 
        
Insert into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,
ICON_PATH,OBJ_TYPE,MOB_DEPLOY,CHG_USER,CHG_TERM,CHG_DATE) 
values ('WMS',12,1,0,0,0,'/ibase/webitm/jsp/E12WizardPage.jsp?OBJ_NAME=sorderWiz&amp;FORM_NO=1','Sale Order','Sale Order',
'WMS.12.1.0.0.0','e12_logo.gif','I','','BASE','BASE',sysdate);   

-----------------------------------------------------------------------------------------------------------------------------

Insert into obj_forms (WIN_NAME,TITLE,FORM_NO) 
values ('w_sorderWiz','Header',1);
Insert into obj_forms (WIN_NAME,TITLE,FORM_NO) 
values ('w_sorderWiz','Screen2',2);
Insert into obj_forms (WIN_NAME,TITLE,FORM_NO) 
values ('w_sorderWiz','Screen3',3);

-----------------------------------------------------------------------------------------------------------------------------

Insert into SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,
COMP_TYPE,COMP_NAME) values ('sorderWiz','default_data_wiz','1','get_itm_default_sorderWiz',sysdate,'BASE','BASE','2','0',
'EJB','SorderWizardEJB');

Insert into SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,
COMP_TYPE,COMP_NAME) values ('sorderWiz','post_item_change','1','poic_sorderWiz',sysdate,'BASE','BASE','2','0',
'EJB','SorderWizardEJB');

Insert into SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,
COMP_TYPE,COMP_NAME) values ('sorderWiz','pre_navigate_next','1','prv_sorderWiz',sysdate,'BASE','BASE','2','0',
'EJB','SorderWizardEJB');

Insert into SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,
COMP_TYPE,COMP_NAME) values ('sorderWiz','pre_validate','1','prv_sorderWiz',sysdate,'BASE','BASE','2','0',
'EJB','SorderWizardEJB');

Insert into SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,
COMP_TYPE,COMP_NAME) values ('sorderWiz','post_save','1','pos_sorderWiz',sysdate,'BASE','BASE','2','0',
'EJB','SorderWizardPosEJB');

-----------------------------------------------------------------------------------------------------------------------------

Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
values ('get_itm_default_sorderWiz','Item change','http://localhost:9090/axis/services/ValidatorService','itemChanged','String','S',sysdate,'BASE','BASE');
    
Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
values ('poic_sorderWiz','Item change','http://localhost:9090/axis/services/ValidatorService','itemChanged','String','S',sysdate,'BASE','BASE');

Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
values ('prv_sorderWiz','Validation','http://localhost:9090/axis/services/ValidatorService','wfValData','String','S',sysdate,'BASE','BASE');

Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
values ('pos_sorderWiz','Post Save','http://localhost:9090/axis/services/ValidatorService','postSave','String','S',sysdate,'BASE','BASE');

-----------------------------------------------------------------------------------------------------------------------------

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('get_itm_default_sorderWiz',1,'COMPONENT_TYPE','I',null,'S',null,sysdate,'BASE','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('get_itm_default_sorderWiz',2,'COMPONENT_NAME','I',null,'S',null,sysdate,'BASE','BASE','SorderWizardEJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('get_itm_default_sorderWiz',3,'XML_DATA__ALL','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('get_itm_default_sorderWiz',4,'XML_DATA_1','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('get_itm_default_sorderWiz',5,'XML_DATA_ALL','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('get_itm_default_sorderWiz',6,'OBJ_CONTEXT','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('get_itm_default_sorderWiz',7,'FOCUSED_COLUMN','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('get_itm_default_sorderWiz',8,'EDIT_FLAG','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('get_itm_default_sorderWiz',9,'XTRA_PARAMS','I',null,'S',null,sysdate,'BASE','BASE',null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_sorderWiz',1,'COMPONENT_TYPE','I',null,'S',null,sysdate,'BASE','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_sorderWiz',2,'COMPONENT_NAME','I',null,'S',null,sysdate,'BASE','BASE','SorderWizardEJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_sorderWiz',3,'XML_DATA__ALL','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_sorderWiz',4,'XML_DATA_1','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_sorderWiz',5,'XML_DATA_ALL','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_sorderWiz',6,'OBJ_CONTEXT','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_sorderWiz',7,'FOCUSED_COLUMN','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_sorderWiz',8,'EDIT_FLAG','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_sorderWiz',9,'XTRA_PARAMS','I',null,'S',null,sysdate,'BASE','BASE',null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_sorderWiz',1,'COMPONENT_TYPE','I','Component Type','S',null,sysdate,'BASE','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_sorderWiz',2,'COMPONENT_NAME','I','Component Name','S',null,sysdate,'BASE','BASE','SorderWizardEJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_sorderWiz',3,'XML_DATA__ALL','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_sorderWiz',4,'XML_DATA_1','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_sorderWiz',5,'XML_DATA_ALL','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_sorderWiz',6,'OBJ_CONTEXT','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_sorderWiz',7,'EDIT_FLAG','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_sorderWiz',8,'XTRA_PARAMS','I',null,'S',null,sysdate,'BASE','BASE',null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pos_sorderWiz',1,'COMPONENT_TYPE','I',null,'S',null,sysdate,'BASE','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pos_sorderWiz',2,'COMPONENT_NAME','I',null,'S',null,sysdate,'BASE','BASE','SorderWizardPosEJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pos_sorderWiz',3,'XML_DATA_ALL','I','XML_DATA_ALL','S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pos_sorderWiz',4,'<tran_id>','I',null,'B.String',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pos_sorderWiz',5,'EDIT_FLAG','I','EDIT_FLAG','S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pos_sorderWiz',6,'XTRA_PARAMS','I',null,'S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pos_sorderWiz',7,'DB_CONN','I',null,'S.Connection',null,sysdate,'BASE','BASE',null);

----------------------------------------------------------------------------------------------------------------------------- 

Insert into PROPERTIES (PROP_NAME,PROP_VALUE,DESCR,ITEM_SER,CHG_DATE,CHG_USER,CHG_TERM) 
values ('SORDERWIZ_SUCC_MSG_DTL','Detail1.sale_order,Detail1.udf__str2','Set Summary','',SYSDATE,'BASE','BASE');

----------------------------------------------------------------------------------------------------------------------------- 

------------Changed by wasim on 16-NOV-16 for QC issues and UTR [START]---------------------------------------

update system_events set event_code = 'pre_navigate' where OBJ_NAME = 'sorderWiz' and event_code = 'pre_navigate_next';

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTINVCUST','Invalid customer code!','Please enter valid customer code','E','Y',SYSDATE,'BASE','BASE');
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTCUSTDLV','Invalid customer delivery!','Please enter valid customer code delivery','E','Y',SYSDATE,'BASE','BASE');
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTCUSTBILL','Invalid customer code bill!','Please enter valid customer code bill','E','Y',SYSDATE,'BASE','BASE');

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
values ('VTORDTINV','Invalid Order Date.','Invalid Order Date,The Order Date not present in period status master','E','Y',sysdate,'BASE','BASE');
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
values ('VTPRDSAL','Period not open for sales.','Please check the date you have entered. Probably,
the date falls under the period whose sales transactions are already closed.','E','Y',sysdate,'BASE','BASE');

------------Changed by wasim on 16-NOV-16 for QC issues and UTR [END]---------------------------------------

------------Changed by wasim on 22-NOV-16 for opening screen in standard [START]---------------------------------------
Insert into OBJ_LINKS (OBJ_NAME,FORM_NO,FIELD_NAME,TARGET_OBJ_NAME,LINK_FORM_NAME,LINK_TITLE,LINK_URI,LINK_TYPE,LINK_ARG,UPDATE_FLAG,LINK_NAME,RIGHTS_CHAR) 
values ('sorder','1','terr_code','sorder','sorder11','Edit Order','/ibase/webitm/jsp/E12WizardPage.jsp?OBJ_NAME=sorderWiz&;FORM_NO=1','3','sale_order.String','0','S','S');
Insert into OBJ_LINKS (OBJ_NAME,FORM_NO,FIELD_NAME,TARGET_OBJ_NAME,LINK_FORM_NAME,LINK_TITLE,LINK_URI,LINK_TYPE,LINK_ARG,UPDATE_FLAG,LINK_NAME,RIGHTS_CHAR) 
values ('sorder','1','remarks','sorder','sorder11','Add Order','/ibase/webitm/jsp/E12WizardPage.jsp?OBJ_NAME=sorderWiz&;FORM_NO=1','3',' ','0','S','S');
------------Changed by wasim on 22-NOV-16 for opening screen in standard [END]---------------------------------------

------------Changed by wasim on 23-NOV-16  [START]---------------------------------------
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTDSPDT','Invalid Despatch Date.','Despatch date must be > =  Order date','E','Y',SYSDATE,'BASE','BASE');
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTDSPINV','Invalid Despatch Date.','Invalid Despatch Date,The Despatch Date not present in period status master','E','Y',SYSDATE,'BASE','BASE');
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTPRDSAL','Period not open for sales','Please check the date you have entered. Probably, the date falls under the period whose sales transactions are already closed.','E','Y',SYSDATE,'BASE','BASE');
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTDUEDT','Invalid Due Date.','Due date must be > =  Order date','E','Y',SYSDATE,'BASE','BASE');
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTINVDUE','Invalid Due Date','Invalid Due Date,The Due Date not present in period status master.','E','Y',SYSDATE,'BASE','BASE');
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTPRDDSP','Period not open for sales.','Please check the due date you have entered. Probably, the date falls under the period whose sales transactions are already closed.','E','Y',SYSDATE,'BASE','BASE');
------------Changed by wasim on 23-NOV-16  [START]---------------------------------------

