package ibase.webitm.ejb.mfg;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;
@Stateless
public class WoClsePobIC extends ValidatorEJB implements WoClsePobICLocal,WoClsePobICRemote
{

	E12GenericUtility genericUtility= new  E12GenericUtility();
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException 
	{
		String errString = "";
		System.out.println("wfValdata() called for WoClsePobIC");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try {
			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0) {
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) {
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag,
					xtraParams);
		} catch (Exception e) {
			throw new ITMException(e);
		}
		return (errString);
		
	}
	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException {
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String userId = "";
		String sql = "";
		String errorType = "";
		int cnt = 0,conf_cnt = 0;
		int ctr = 0;
		int childNodeListLength;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer(
				"<?xml version = \"1.0\"?> \r\n <Root> <Errors>");

		int currentFormNo = 0, recCnt = 0;
		int noOfParent = 0, ctr1 = 0;
		double maxQty = 0, minQty = 0;
		String lsworkorder = "", qorderNo = "", refNo = "", tranId = "", itemCode = "", locCode = "", lotNo = "", lotSl = "", siteCode = "";
		String status = "", porcpNo = "", porcpLineNo = "", qcLocCode = "", minQtyStr = "", available = "", keyFlag = "";
		Timestamp date2 = null, tranDate = null;
		String faciLocCode = "", faciSiteCode = "";

		double aprvLeadTime = 0;
		Timestamp qcOrderDate = null,WORecTranDate=null; // added by cpatil on 02/11/13
        Boolean workOrdCntflag = false ;
        String qcOrderItem="";
        int countItem=0;
        String qcOrdItemUnit="",byprodUnit="";
        double qcQty=0,netWeight=0,noArt=0;
		try {
			System.out.println("@@@@@@@@ wfvaldata called WoClsePobIC");
			//Changed by Poonam Gole for changing connection object :Start
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection() ;
			
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			DistCommon dcommon=new DistCommon();
			switch (currentFormNo) {
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("tran_id"))
					{ 
						sql="select key_flag from transetup where tran_window='w_wo_closepob'";
						pstmt=conn.prepareStatement(sql);
						rs=pstmt.executeQuery();
						if(rs.next())
						{
							keyFlag=rs.getString("key_flag");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
											
						if(keyFlag.equalsIgnoreCase("M"))
						{
							tranId= genericUtility.getColumnValue("tran_id", dom);
							if(tranId == null || (tranId.length() == 0))
							{
								errList.add("VMTRANID");
								errFields.add(childNodeName.toLowerCase());
							}
							if(tranId!= null && (tranId.trim().length() > 0))
							{
								sql = " select count(*) from Wo_Close where tran_id = ? ";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,tranId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									if(cnt > 0) 
									{
										errCode = "VMTRNIDINV";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());	
									}									
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("work_order")) 
					{
					
						lsworkorder = checkNull(genericUtility.getColumnValue("work_order", dom));
						System.out.println("@@@@ lsworkorder[ "+lsworkorder+"]");
						sql = "Select count(*) from workorder Where work_order 	= ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, lsworkorder);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							System.out.println("@@@@ cnt[" + cnt + "]");
							if (cnt <1) 
							{
								
								errCode = "VTWORDER1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								sql="select count(*) as wo_cnt from wo_close where work_order=?";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1, lsworkorder);
								rs=pstmt.executeQuery();
								if(rs.next())
								{
									cnt=rs.getInt("wo_cnt");
								}
								pstmt.close();
								pstmt=null;
								rs.close();
								rs=null;
								
								System.out.println("@V@ WO already exist cnt :- ["+cnt+"]");
								
								if(cnt>0)
								{
									errCode = "VTWOEXST";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								
								/**
								 * VALLABH KADAM
								 * Validation for (on demand issue request,deviated issue request )
								 * 17/FEB/17
								 * M16JSUN002
								 * */
								sql = "SELECT COUNT(1) FROM WORKORDER_ISS_REQ where work_order=?" +
										" AND CASE WHEN STATUS IS NULL THEN 'O' ELSE STATUS END='O'";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, lsworkorder);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									cnt = rs.getInt(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								System.out.println("@@@@ Deviated Issue request cnt :- [" + cnt + "]");
								if(cnt>0)
								{
									errCode = "VTWORDISRQ";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								
								
								sql = "Select status  From workorder Where work_order = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, lsworkorder);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									status = rs.getString(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								System.out.println("status ["+status+"]");								
								
								if("X".equalsIgnoreCase(status))
								{
									errCode = "VTWOCANC1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());	
								}
								else if ("C".equalsIgnoreCase(status))
								{
									errCode = "VTWORDER2";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								
								/**
								 * VALLABH KADAM
								 * Check work order issue exist
								 * from table 'WORKORDER_ISS'
								 * */
								
								sql = "select count(*) as cnt from workorder_iss where work_order=?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, lsworkorder);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									cnt = rs.getInt("cnt");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								if(cnt>0)
								{
									/**
									 * VALLABH KADAM
									 * Check unconfirmed 'N'
									 * issue pending for work order
									 * */
									
									sql = "select count(*) as conf_cnt from workorder_iss where confirmed='N' and work_order=?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, lsworkorder);
									rs = pstmt.executeQuery();
									if (rs.next()) 
									{
										conf_cnt = rs.getInt("conf_cnt");
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									
									if(conf_cnt>0)
									{
										errCode = "VTUNCNFISU";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								else
								{
									/**
									 * VALLABH KADAM
									 * No issue exist
									 * Check firm plan is already completed 'F'
									 * or stock is released 'R'
									 * */
									if ("F".equalsIgnoreCase(status))
									{
										errCode = "VTWOFRM";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
									else if ("R".equalsIgnoreCase(status))
									{
										errCode = "VTWORELS";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
								
						}
					}
				} // end for
				break; // case 1 end

			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if (errList != null && errListSize > 0) {
				for (cnt = 0; cnt < errListSize; cnt++) {
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn, errCode);
					if (errString.length() > 0) {
						String bifurErrString = errString.substring(
								errString.indexOf("<Errors>") + 8,
								errString.indexOf("<trace>"));
						bifurErrString = bifurErrString
								+ errString.substring(
										errString.indexOf("</trace>") + 8,
										errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if (errorType.equalsIgnoreCase("E")) {
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			} else {
				errStringXml = new StringBuffer("");
			}
		} catch (Exception e) {
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null) {
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}// end of validation
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		System.out.println("itemChanged() called for WoClsePobIC");
		String valueXmlString = "";
		try {
			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0) {
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) {
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext,
					currentColumn, editFlag, xtraParams);
		} catch (Exception e) {
			System.out
			.println("Exception : [QCTransferIC][itemChanged( String, String )] :==>\n"
					+ e.getMessage());
		}
		return valueXmlString;
	}
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException {
		String childNodeName = null;
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		int ctr = 0;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility= new  E12GenericUtility();
		ConnDriver connDriver = new ConnDriver();

		int currentFormNo = 0;
		String columnValue = "", itemCode = "", itemDescr = "";
		String siteDescr = "", lssitecode = "", loginSiteCode = "", lsworkorder = "", lssitecodewo = "";
		try {
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(currentDate.getTime());
			System.out.println("Now the date is :=>  " + sysDate);

			//Changed by Poonam Gole for changing connection object :Start
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection() ;
			//Changed by Poonam Gole for changing connection object :End
			conn.setAutoCommit(false);
			connDriver = null;
			
			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext.trim());
			}

			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			System.out.println("################ITEMCHANGE FOR CASE" + currentFormNo+ "##################");
			switch (currentFormNo) {
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				valueXmlString.append("<Detail1>");
				int childNodeListLength = childNodeList.getLength();
				do {
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals(currentColumn)) {
						if (childNode.getFirstChild() != null) {
							columnValue = childNode.getFirstChild()
									.getNodeValue().trim();
						}
					}
					ctr++;
				} while (ctr < childNodeListLength&& !childNodeName.equals(currentColumn));
				System.out.println("[" + currentColumn + "] ==> '"+ columnValue + "'");

				if (currentColumn.trim().equalsIgnoreCase("itm_default")) {
					System.out.println(" #################itm_default called#####################");
					loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
					System.out.println("@@@@@@@@loginSiteCode[" + loginSiteCode+ "]");
					valueXmlString.append("<tran_date>").append("<![CDATA[" + sysDate + "]]>").append("</tran_date>");
					valueXmlString.append("<site_code>").append("<![CDATA[" + loginSiteCode + "]]>").append("</site_code>");
					siteDescr = setDescription("descr", "site", "site_code",loginSiteCode, conn);
					System.out.println("siteDescr itm_default ["+siteDescr+"]");
					valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr + "]]>").append("</site_descr>");
				}
				else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					lssitecode = checkNull(genericUtility.getColumnValue("site_code", dom));
					System.out.println("Site Code is itm_defaultedit ["+lssitecode+"]");
					siteDescr = setDescription("descr", "site", "site_code",lssitecode, conn);
					System.out.println("siteDescr itm_defaultedit ["+siteDescr+"]");
					valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr + "]]>").append("</site_descr>");
				}
				else if (currentColumn.trim().equalsIgnoreCase("work_order"))
				{
					lsworkorder = checkNull(genericUtility.getColumnValue("work_order",dom));
					sql="select site_code from  workorder where  work_order = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsworkorder);
					rs = pstmt.executeQuery();
					if (rs.next()) 
					{
						lssitecodewo=rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					System.out.println("Site Code is in Work Worder ["+lssitecodewo+"]");
					valueXmlString.append("<site_code>").append("<![CDATA[" + lssitecodewo + "]]>").append("</site_code>");
					siteDescr = setDescription("descr", "site", "site_code",lssitecodewo, conn);
					System.out.println("siteDescr Work Order Column"+siteDescr+"]");
					valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr + "]]>").append("</site_descr>");
				}
				valueXmlString.append("</Detail1>");
				break;

			} // case 1 end
			valueXmlString.append("</Root>");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null) {
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}
	private String setDescription(String descrCol, String table, String field,String value, Connection conn) throws SQLException {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", descr = "";
		System.out.println("@@@@@@@@table[" + table + "]:::field[" + field+ "]::value[" + value + "]");
		sql = "select " + descrCol + " from " + table + " where " + field+ " = ? ";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, value);
		rs = pstmt.executeQuery();
		if (rs.next()) {
			descr = checkNull(rs.getString(1));
		}
		rs.close();
		rs = null;
		pstmt.close();
		pstmt = null;
		System.out.print("========>::descr[" + descr + "]");
		return descr;
	}
	private String checkNull(String input) {
		if (input == null) {
			input = "";
		}
		return input;
	}

	private String errorType(Connection conn, String errorCode) {
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try {
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				msgType = checkNull(rs.getString("MSG_TYPE"));
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return msgType;
	}


}
