/*
 * Author:Wasim Ansari
 * Date: 23-JAN-17
 * Request ID: D16JBAS001
 * Description: Invoice Cancellation
 */

package ibase.webitm.ejb.fin.adv;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.adv.SalesReturnConfirm;
import ibase.webitm.ejb.fin.adv.UndoRecievableAdjConfLocal;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;

@Stateless
public class InvoiceCancelEJB extends ActionHandlerEJB implements InvoiceCancelEJBLocal,InvoiceCancelEJBRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	CommonWmsUtil commonWmsUtility = CommonWmsUtil.getInstance();
	MasterStatefulLocal masterStatefulLocal = null;
	DistCommon distComm = new DistCommon();
	
	String userId = "",loginSiteCode = "",chgTerm = "";

	@Override
	//public String invoiceCancel(String actionType, String xmlString,String objContext,String xtraParams) throws RemoteException, ITMException
	public String actionHandler(String invoiceID, String xtraParams,String forcedFlag) throws RemoteException, ITMException 
	{
		String retString = "",sql = "";
		boolean isError = false;
		Connection conn = null;
		PreparedStatement pstmt = null,pstmtInsert = null;
		ResultSet rs = null;
		int cnt = 0;
		String confirmed = "",userInfo = "",orderDate = "";
		double refBalAmount = 0,totAmt = 0, adjAmt = 0;
		
		try
		{
			System.out.println("Inside invoiceCancelEJB \n invoiceID["+invoiceID+"] \n xtraParams["+xtraParams+"] \n forcedFlag["+forcedFlag+"]");
			
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			
			conn = getConnection();
			
			sql = " SELECT CONFIRMED FROM INVOICE WHERE INVOICE_ID = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, invoiceID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confirmed = checkNullAndTrim(rs.getString("CONFIRMED"));
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt=null;
			}
			if(rs != null)
			{
				rs.close();rs=null;
			}
			
			if(!"Y".equalsIgnoreCase(confirmed))
			{
				retString = itmDBAccessEJB.getErrorString("","VTINVCANC","","",conn);  
				return retString;
			}
			
			sql = " SELECT COUNT(*) FROM SRETURN WHERE INVOICE_ID = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, invoiceID);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt = rs.getInt(1);
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt=null;
			}
			if(rs != null)
			{
				rs.close();rs=null;
			}
			
			if(cnt > 0)
			{
				System.out.println("Sales Return already created for this invoice");
				retString = itmDBAccessEJB.getErrorString("","VTALRCNC","","",conn);  
				return retString;
			}
			cnt = 0;
			
			if(!"Y".equalsIgnoreCase(confirmed))
			{
				retString = itmDBAccessEJB.getErrorString("","VTINVCANC","","",conn);  
				return retString;
			}
			
			confirmed = "";
			
			sql = " SELECT H.CONFIRMED FROM RECEIPT H,RCPDET D WHERE H.TRAN_ID = D.TRAN_ID AND D.REF_NO = ? AND D.REF_SER = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, invoiceID);
			pstmt.setString(2, "S-INV");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confirmed = checkNullAndTrim(rs.getString("CONFIRMED"));
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt=null;
			}
			if(rs != null)
			{
				rs.close();rs=null;
			}
			
			if("Y".equalsIgnoreCase(confirmed))
			{
				retString = itmDBAccessEJB.getErrorString("","VTINVCCONF","","",conn);  
				return retString;
			}
			else
			{
				orderDate = getCurrdateAppFormat();
				
				retString = undoRecAdjustment(invoiceID, xtraParams,forcedFlag, conn);
				
				StringBuffer xmlString = new StringBuffer();
				StringBuffer xmlStringDet = new StringBuffer();
				StringBuffer xmlStringHdr= new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
				xmlStringHdr.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 escription</description>");
				xmlStringHdr.append("<Header0>");
				xmlStringHdr.append("<description>Header0 members</description>");
				xmlStringHdr.append("<objName><![CDATA[").append("salesreturn_retn").append("]]></objName>");
	            xmlStringHdr.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
	            xmlStringHdr.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
	            xmlStringHdr.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
	            xmlStringHdr.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
	            xmlStringHdr.append("<action><![CDATA[").append("SAVE").append("]]></action>");
	            xmlStringHdr.append("<elementName><![CDATA[").append("").append("]]></elementName>");
	            xmlStringHdr.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
	            xmlStringHdr.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
	            xmlStringHdr.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
	            xmlStringHdr.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
	            xmlStringHdr.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
	            
	            xmlStringHdr.append("<Detail1 dbID='' domID=\"1\" objName=\"salesreturn_retn\" objContext=\"1\">");
	            xmlStringHdr.append("<attribute pkNames=\"tran_id:\" status=\"N\" updateFlag=\"A\" selected=\"N\" />");
	            
	            xmlStringHdr.append("<tran_id><![CDATA[]]></tran_id>");
	            xmlStringHdr.append("<tran_date><![CDATA[").append(orderDate).append("]]></tran_date>");
	            xmlStringHdr.append("<tran_type><![CDATA[").append("FOR").append("]]></tran_type>");
	            xmlStringHdr.append("<invoice_id><![CDATA[").append(invoiceID).append("]]></invoice_id>");
	            xmlStringHdr.append("<site_code><![CDATA[").append(loginSiteCode).append("]]></site_code>");
	            xmlStringHdr.append("<full_ret><![CDATA[").append("Y").append("]]></full_ret>");
	            
	            xmlStringHdr.append("</Detail1>");
	            
	            String lineNoOrd = "",refSer = "",itemCode = "",quantity = "",lineNoInvoice = "";
	            int domID = 0;
	            
	            sql = " SELECT D.LINE_NO,D.ITEM_CODE,D.QUANTITY FROM INVOICE H,INVOICE_TRACE D WHERE H.INVOICE_ID = D.INVOICE_ID AND H.INVOICE_ID = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, invoiceID);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					domID++;
					
					lineNoInvoice = rs.getString("LINE_NO");
					itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
					quantity = checkNullAndTrim(rs.getString("QUANTITY"));
					
		            xmlStringDet.append("<Detail2 dbID=':' domID='"+ domID +"' objName='salesreturn_retn' objContext='2'>");
					xmlStringDet.append("<attribute pkNames='tran_id:line_no:' status='N' updateFlag='A' selected='N'/>");
	                
					lineNoOrd = "   " + domID;
					lineNoOrd = lineNoOrd.substring( lineNoOrd.length()-3 );
						
					xmlStringDet.append("<tran_id><![CDATA[]]></tran_id>");
					xmlStringDet.append("<line_no><![CDATA[").append(lineNoOrd).append("]]></line_no>");
					xmlStringDet.append("<invoice_id><![CDATA[").append(invoiceID).append("]]></invoice_id>");
					xmlStringDet.append("<line_no__invtrace><![CDATA[").append(lineNoInvoice).append("]]></line_no__invtrace>");
					xmlStringDet.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>");
					xmlStringDet.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>");
					xmlStringDet.append("<ret_rep_flag><![CDATA[").append("R").append("]]></ret_rep_flag>");
					
					xmlStringDet.append("</Detail2>");
					
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt=null;
				}
				if(rs != null)
				{
					rs.close();rs=null;
				}
	            
				xmlString.append(xmlStringHdr);
				xmlString.append(xmlStringDet);
				xmlString.append("</Header0></group0></DocumentRoot>");
				
				System.out.println("@@xmlString For generation Sales Return:: "+xmlString.toString());
	            masterStatefulLocal = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local"); 
	            
	            if(xtraParams == null)
	            {
	            	xtraParams = getXtraParams(userId,loginSiteCode,userId,conn);
	            }
	            userInfo  = getUserInfo(xtraParams);

	            retString = masterStatefulLocal.processRequest(userInfo, xmlString.toString(), true, conn);
	            
	            System.out.println("@@Sales Return return string"+retString);
	            
	            if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 )
				{
	            	String tranIDSreturn = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
					System.out.println("Sales Return Created :"+tranIDSreturn);
					
					cnt = 0;
					sql = " select tran_ser, (case when tot_amt is null then 0 else tot_amt end) as tot_amt ,(case when adj_amt is null then 0 else adj_amt end) as adj_amt "
						+ " from receivables where ref_no = ? and tran_ser = 'S-INV' ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, invoiceID);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						cnt++;
						refSer = rs.getString("tran_ser");
						totAmt = rs.getDouble("tot_amt");
						adjAmt = rs.getDouble("adj_amt");
						
						System.out.println("@@TotAmt["+rs.getDouble("tot_amt")+"]  @@AdjAmt["+rs.getDouble("adj_amt")+"] refSer["+refSer+"]");
						
						refBalAmount = totAmt - adjAmt;
						
						sql = " insert into sreturn_inv (tran_id,line_no,ref_ser,ref_no,ref_bal_amt,adj_amt) values (?,?,?,?,?,?) ";
						pstmtInsert = conn.prepareStatement(sql);
						pstmtInsert.setString(1, tranIDSreturn);
						pstmtInsert.setInt(2, cnt);
						pstmtInsert.setString(3, "S-INV");
						pstmtInsert.setString(4, invoiceID);
						pstmtInsert.setDouble(5, refBalAmount);
						pstmtInsert.setDouble(6, refBalAmount);
						pstmtInsert.executeUpdate();
						if (pstmtInsert != null )
						{
							pstmtInsert.close();pstmtInsert = null;
						}
					}
					if (pstmt != null )
					{
						pstmt.close();pstmt = null;
					}
					
					SalesReturnConfirm confObj = new SalesReturnConfirm();
					retString = confObj.confirm(tranIDSreturn,xtraParams,forcedFlag,conn);
					
					System.out.println("After confirming sales return ["+retString+"]");
					
					if ( retString.indexOf("VTSRTRNCMP") > -1 || retString.indexOf("VTCICONF3") > -1)
					{
						System.out.println("Sales return confirm successfully");
						
						retString = itmDBAccessEJB.getErrorString("","VTINVCNC","","",conn);  
					}
					else
					{
						isError = true;
						return retString;
					}
				}
	            else
	            {
	            	throw new Exception(retString);
	            }
	            
			}
		}
		catch(Exception e)
		{
			System.out.println("Inside Catch invoiceCancel="+e.getMessage());
			e.printStackTrace();
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside Finally invoiceCancel isError="+isError);
				
				if(isError)
				{
					System.out.println("Rollbacking Cancle Invoice.......");
					conn.rollback();
				}
				else
				{
					System.out.println("Comitting Cancle Invoice......");
					//conn.rollback();//Temporary for testing and to be removed  
					conn.commit();
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt=null;
				}
				if (pstmtInsert != null )
				{
					pstmtInsert.close();pstmtInsert = null;
				}
				if(rs != null)
				{
					rs.close();rs=null;
				}
				if(conn != null)
				{
					conn.close();conn=null;
				}
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
		}
		return retString;
	}
	
	public String undoRecAdjustment(String invoiceID, String xtraParams, String forcedFlag, Connection conn) throws RemoteException, ITMException 
	{
		String retString = "",sql = "",custCode = "",tranDate = "",tranID = "";
		boolean isError = false;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int cnt = 0;
		Timestamp today = null;
		
		try
		{
			
			sql=" select count(1) from receivables_adj where ref_no_adj= ? and ref_ser_adj= ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, invoiceID);
			pstmt.setString(2, "S-INV");
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt=rs.getInt(1);
			}						
			if(pstmt != null)
			{
				pstmt.close();pstmt=null;
			}
			if(rs != null)
			{
				rs.close();rs=null;
			}
			
			System.out.println("receivables_adj-->Count ["+cnt+"]");
			
			if(cnt > 0)
			{
				AppConnectParm appConnect = new AppConnectParm();
				Properties p = appConnect.getProperty();
				InitialContext ctx = new InitialContext(p);
				
				today = getCurrtDate();
				tranDate = getCurrdateAppFormat();
				
				sql = " SELECT CUST_CODE FROM INVOICE WHERE INVOICE_ID = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, invoiceID);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					custCode = checkNullAndTrim(rs.getString("CUST_CODE"));
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt=null;
				}
				if(rs != null)
				{
					rs.close();rs=null;
				}
				
				tranID = commonWmsUtility.generateTranTd("w_undo_rec_adj", tranDate, loginSiteCode, conn);
				
				sql = " INSERT INTO UNDO_REC_ADJ (TRAN_ID,TRAN_DATE,SITE_CODE,CUST_CODE,REF_NO,EMP_CODE__APRV,CONFIRMED,CONF_DATE,ADD_DATE,ADD_USER," //10
					 +" ADD_TERM,CHG_DATE,CHG_USER,CHG_TERM,REMARKS,TRAN_TYPE) " //16
					 +" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranID);
				pstmt.setTimestamp(2, today);
				pstmt.setString(3, loginSiteCode);
				pstmt.setString(4, custCode);
				pstmt.setString(5, invoiceID);
				pstmt.setString(6, userId);
				pstmt.setString(7, "N");
				pstmt.setString(8, "");
				pstmt.setTimestamp(9, today);
				pstmt.setString(10, userId);
				pstmt.setString(11, chgTerm);
				pstmt.setTimestamp(12, today);
				pstmt.setString(13, userId);
				pstmt.setString(14, chgTerm);
				pstmt.setString(15, "");
				pstmt.setString(16, "S-INV");
				
				int result = pstmt.executeUpdate();
				System.out.println("Header result="+result);
				
				UndoRecievableAdjConfLocal undoRcvAdjCnfLocal = null;
				undoRcvAdjCnfLocal = (UndoRecievableAdjConfLocal)ctx.lookup("ibase/UndoRecievableAdjConf/local"); 
				
				retString = undoRcvAdjCnfLocal.confirm(tranID, xtraParams,forcedFlag,conn);
				
				System.out.println("Return String confirm UndoRecievableAdjConf ["+retString+"]");
				
				if (retString.indexOf("VTCNFSUCC") > -1)	
				{
					System.out.println("Successfully reverted Receivable Adjustment");
				}
				else if (retString.indexOf("VTREF03") > -1)	
				{
					System.out.println("Proceed further..");
					retString = "";
				}
				else
				{
					throw new Exception(retString);
				}
			}
			else
			{
				System.out.println("receivables_adj does not exist for ");
				return "";
			}
		}
		catch(Exception e)
		{
			System.out.println("Inside Catch undoRecAdjustment="+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside Finally undoRecAdjustment isError="+isError);
				
				if(pstmt != null)
				{
					pstmt.close();pstmt=null;
				}
				if(rs != null)
				{
					rs.close();rs=null;
				}
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
		}
		return retString;
	}
	
	
	/*public String createSalesReturn(String invoiceID, String xtraParams,Connection conn) throws RemoteException, ITMException 
	{
		String retString = "",sql = "";
		boolean isError = false;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		String confirmed = "",userInfo = "",userId = "",loginSiteCode = "",orderDate = "";
		
		try
		{
			System.out.println("Inside createSalesReturn \n tranId["+invoiceID+"] \n xtraParams["+xtraParams+"] \n");
			
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			
			orderDate = getCurrdateAppFormat();
			
			StringBuffer xmlString = new StringBuffer();
			StringBuffer xmlStringDet = new StringBuffer();
			StringBuffer xmlStringHdr= new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			xmlStringHdr.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 escription</description>");
			xmlStringHdr.append("<Header0>");
			xmlStringHdr.append("<description>Header0 members</description>");
			xmlStringHdr.append("<objName><![CDATA[").append("salesreturn_retn").append("]]></objName>");
            xmlStringHdr.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
            xmlStringHdr.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
            xmlStringHdr.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
            xmlStringHdr.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
            xmlStringHdr.append("<action><![CDATA[").append("SAVE").append("]]></action>");
            xmlStringHdr.append("<elementName><![CDATA[").append("").append("]]></elementName>");
            xmlStringHdr.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
            xmlStringHdr.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
            xmlStringHdr.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
            xmlStringHdr.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
            xmlStringHdr.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
            
            xmlStringHdr.append("<Detail1 dbID='' domID=\"1\" objName=\"salesreturn_retn\" objContext=\"1\">");
            xmlStringHdr.append("<attribute pkNames=\"tran_id:\" status=\"N\" updateFlag=\"A\" selected=\"N\" />");
            
            xmlStringHdr.append("<tran_id><![CDATA[]]></tran_id>");
            xmlStringHdr.append("<tran_date><![CDATA[").append(orderDate).append("]]></tran_date>");
            xmlStringHdr.append("<tran_type><![CDATA[").append("FOR").append("]]></tran_type>");
            xmlStringHdr.append("<invoice_id><![CDATA[").append(invoiceID).append("]]></invoice_id>");
            xmlStringHdr.append("<site_code><![CDATA[").append(loginSiteCode).append("]]></site_code>");
            xmlStringHdr.append("<full_ret><![CDATA[").append("Y").append("]]></full_ret>");
            
            xmlStringHdr.append("</Detail1>");
            
            String lineNoOrd = "",refSer = "",itemCode = "",quantity = "",lineNoInvoice = "";
            int domID = 0;
            
            sql = " SELECT D.LINE_NO,D.ITEM_CODE,D.QUANTITY FROM INVOICE H,INVOICE_TRACE D WHERE H.INVOICE_ID = D.INVOICE_ID AND H.INVOICE_ID = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, invoiceID);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				domID++;
				
				lineNoInvoice = rs.getString("LINE_NO");
				itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
				quantity = checkNullAndTrim(rs.getString("QUANTITY"));
				
	            xmlStringDet.append("<Detail2 dbID=':' domID='"+ domID +"' objName='salesreturn_retn' objContext='2'>");
				xmlStringDet.append("<attribute pkNames='tran_id:line_no:' status='N' updateFlag='A' selected='N'/>");
                
				lineNoOrd = "   " + domID;
				lineNoOrd = lineNoOrd.substring( lineNoOrd.length()-3 );
					
				xmlStringDet.append("<tran_id><![CDATA[]]></tran_id>");
				xmlStringDet.append("<line_no><![CDATA[").append(lineNoOrd).append("]]></line_no>");
				xmlStringDet.append("<invoice_id><![CDATA[").append(invoiceID).append("]]></invoice_id>");
				xmlStringDet.append("<line_no__invtrace><![CDATA[").append(lineNoInvoice).append("]]></line_no__invtrace>");
				xmlStringDet.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>");
				xmlStringDet.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>");
				
				xmlStringDet.append("</Detail2>");
				
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt=null;
			}
			if(rs != null)
			{
				rs.close();rs=null;
			}
            
			xmlString.append(xmlStringHdr);
			xmlString.append(xmlStringDet);
			xmlString.append("</Header0></group0></DocumentRoot>");
			
			System.out.println("@@xmlString For generation Sales Return:: "+xmlString.toString());
            masterStatefulLocal = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local"); 
            
            if(xtraParams == null)
            {
            	xtraParams = getXtraParams(userId,loginSiteCode,userId,conn);
            }
            userInfo  = getUserInfo(xtraParams);

            retString = masterStatefulLocal.processRequest(userInfo, xmlString.toString(), true, conn); 
            
            System.out.println("@@Sales Return return string"+retString);
            
            if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 )
			{
            	String tranIDSreturn = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
				System.out.println("Sales Return Created :"+tranIDSreturn);
				
				retString = itmDBAccessEJB.getErrorString("","VTSRTRNCMP","","",conn);  
			}
            else
            {
            	throw new Exception(retString);
            }
		}
		catch(Exception e)
		{
			System.out.println("Inside Catch createSalesReturn="+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside Finally createSalesReturn isError="+isError);
				
				if(pstmt != null)
				{
					pstmt.close();pstmt=null;
				}
				if(rs != null)
				{
					rs.close();rs=null;
				}
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}
		}
		return retString;
	}*/
	
	public String getUserInfo( String xtraParams )throws ITMException
	{
		StringBuffer userInfoStr = new StringBuffer();
		String userId = "";
		String loginEmpCode = "";
		String loginSiteCode = "";
		String entityCode = "";
		String profileId = "";
		String userType = "";
		
		String chgTerm = "";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			profileId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"profileId");
			userType = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userType");
			
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			
			System.out.println("xtraParams  is @@@@@ " + xtraParams);

			userInfoStr.append("<UserInfo>");
			userInfoStr.append("<loginCode>").append("<![CDATA["+userId+"]]>").append("</loginCode>\r\n");
			userInfoStr.append("<empCode>").append("<![CDATA["+loginEmpCode+"]]>").append("</empCode>\r\n");
			userInfoStr.append("<siteCode>").append("<![CDATA["+loginSiteCode+"]]>").append("</siteCode>\r\n");
			userInfoStr.append("<entityCode>").append("<![CDATA["+entityCode+"]]>").append("</entityCode>\r\n");
			userInfoStr.append("<profileId>").append("<![CDATA["+profileId+"]]>").append("</profileId>\r\n");
			userInfoStr.append("<userType>").append("<![CDATA["+userType+"]]>").append("</userType>\r\n");
			
			userInfoStr.append("<remoteHost>").append("<![CDATA["+chgTerm+"]]>").append("</remoteHost>\r\n");
			userInfoStr.append("</UserInfo>");
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return userInfoStr.toString();
	}
	
	public String getXtraParams( String loginCode, String siteCode,String empCode,Connection  conn)throws Exception
	{
		String remotehost = "";
		String entityCode = "";
		String profileId = "";
		String userType = "";
		String userLang = "";
		String userCountry = "";	
		StringBuffer xtraParamsBuff = new StringBuffer();
		
		String sql = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
			
		
		try
		{
				sql = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID,LOGGER_TYPE,USER_LANG,"+
					  "USER_COUNTRY,TRANS_DB, USER_THEME FROM USERS WHERE CODE = ? ";
				pstmt = conn.prepareStatement(sql);			
				pstmt.setString(1,loginCode);			
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					entityCode = rs.getString("ENTITY_CODE");
					profileId  = rs.getString("PROFILE_ID");
					userType   = rs.getString("USER_TYPE");
					userLang   = rs.getString("USER_LANG");
					userCountry= rs.getString("USER_COUNTRY");
				}			
				
				remotehost =  InetAddress.getLocalHost().getHostAddress();
				String XTRA_PARAMS_SEPARATOR = "~~";
				
				xtraParamsBuff.append("loginCode=" + loginCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + empCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + siteCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + entityCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + profileId);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userType);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userLang);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userCountry);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + CommonConstants.ENCODING);
				
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId="+remotehost);
		
				String chgTerm = remotehost;
				if( chgTerm != null && chgTerm.length() > 15 )
				{
					chgTerm = chgTerm.substring(0, 15);
				}
				else if( chgTerm == null || chgTerm.length() == 0 )
				{
					chgTerm = remotehost;
				}
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm );
				
				System.out.println("xtraParamsBuff ["+xtraParamsBuff+"]");
				
				
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return xtraParamsBuff.toString();
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}
	
	private String getCurrdateAppFormat() 
	{
		String s = "";
		//GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(timestamp).toString();
		}
		catch (Exception localException)
		{
		}

		return s;
	}
}
