create table buglist(
bug_id  char(10) not null,
obj_name varchar2(50),
descr varchar2(500),
solu_desired  varchar2(500),
resolved_ver varchar2(500),
status char(1),-- P - Pending, D -- Deployed
trans_affected   varchar2(500),
comp_delivered varchar2(500),
add_user char(10) not null,
add_date date not null,
add_term varchar2(15) not null,
chg_user char(10) not null,
chg_date date not null,
chg_term varchar2(15) not null ) tablespace itm_data;
alter table buglist add constraint buglist_x primary key(bug_id) using index tablespace itm_index;

-----------------------------------------------------------------------------------------------------------------------------
create table bug_fixes (tran_id char(10) not null,
bug_id char(10) not null,
obj_name varchar2(50) not null,
ref_id char(10) not null,
execut_date date,
result_str varchar2(4000) ) tablespace itm_data;
alter table bug_fixes add constraint bug_fixes_x primary key(tran_id) using index tablespace itm_index;
-----------------------------------------------------------------------------------------------------------------------------

INSERT INTO transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,
REF_SER,VIEW_MODE,AUDIT_TRAIL_OPT,PERIOD_OPTION,TRAN_ID_COL,APPLICATION,TABLE_NAME,TABLE_DESC,CONFIRM_COL,CONFIRM_VAL)
VALUES ('w_buglist',
        '2','2', 'A', 'seq10', sysdate,'base','base',
        '0','B-LIST','F','2','M','BUG_ID','WMS','BUGLIST','Bug List descr','STATUS','D');

INSERT INTO transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,
REF_SER,VIEW_MODE,AUDIT_TRAIL_OPT,PERIOD_OPTION,TRAN_ID_COL,APPLICATION,TABLE_NAME)
VALUES ('w_bugresolution',
        '2','2', 'A', 'seq10', sysdate,'base','base  ',
        '0','','F','2','M','BUG_ID','WMS','BUGLIST');


INSERT INTO transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,
REF_SER,VIEW_MODE,AUDIT_TRAIL_OPT,PERIOD_OPTION,TRAN_ID_COL,APPLICATION,TABLE_NAME)
VALUES ('w_bugfixes',
        '2','2', 'A', 'seq10', sysdate,'base','base',
        '0','GLTRAN','F','2','M','TRAN_ID','WMS','bug_fixes');

-----------------------------------------------------------------------------------------------------------------------------

Insert into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,
ICON_PATH,OBJ_TYPE,CHG_USER,CHG_TERM,CHG_DATE,OPEN_ICON,MOB_DEPLOY) 
values ('WMS',3,7,0,0,0,'w_bugresolution','Bug Resolution','Bug Resolution','WMS.3.7.0.0.0','e12_logo.gif','I',null,null,null,null,null);

Insert into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,
ICON_PATH,OBJ_TYPE,CHG_USER,CHG_TERM,CHG_DATE,OPEN_ICON,MOB_DEPLOY) 
values ('WMS',3,8,0,0,0,'w_bugfixes','Bug Resolution','Bug Resolution','WMS.3.8.0.0.0','e12_logo.gif','T',null,null,null,null,null);

Insert into itm2menu (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,COMMENTS,MENU_PATH,
ICON_PATH,OBJ_TYPE,CHG_USER,CHG_TERM,CHG_DATE,OPEN_ICON,MOB_DEPLOY) 
values ('WMS',3,9,0,0,0,'w_buglist','Bug List','Bug List','WMS.3.9.0.0.0','e12_logo.gif','T',null,null,null,null,null);

-----------------------------------------------------------------------------------------------------------------------------

Insert into obj_forms (WIN_NAME,TITLE,FORM_NO,ASSISTED_MODE,DEFAULT_VIEW) values ('w_buglist','Bug List',1,'E','A');
Insert into obj_forms (WIN_NAME,TITLE,OBJ_BROW_NAME,FORM_NO) values ('w_bugresolution','Bug Resolution',1);
Insert into obj_forms (WIN_NAME,TITLE,FORM_NO,ASSISTED_MODE,DEFAULT_VIEW) values ('w_bugfixes','Bug Fixes status',1,'E','A');

-----------------------------------------------------------------------------------------------------------------------------

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('buglist','post_item_change','1','poic_default_ejb','0',sysdate,'BASE','BASE','2','EJB','BugListEJB');

Insert into SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
values ('bugresolution','process','1','bug_prc','0',sysdate,'BASE','BASE','2','EJB','BugResolutionPrc');

INSERT INTO system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('buglist','pre_validate','1','prv_default_ejb','0',sysdate,'BASE','BASE','2','EJB','BugListEJB');

-----------------------------------------------------------------------------------------------------------------------------

Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,
RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) 
values ('bug_prc','Process','http://localhost/axis/services/ProcessService',null,'process','String','S',null,null,SYSDATE,'BASE','BASE');

-----------------------------------------------------------------------------------------------------------------------------

Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER)
values ('bugresolution',1,null,'Bug resolution process','process','a','R','Process','1','3',null,'U',null,sysdate,'BASE','BASE');

INSERT INTO obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
values ('buglist',
       2,
       'edit.gif',
       'Editing Existing Record',
       'a',
       'a',
       'E',
       'Edit',
       '1',
       'S');


INSERT INTO obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE)
values ('buglist',
       1,
       'add.gif',
       'Saving',
       'a',
       'a',
       'A',
       'Add',
       '1',
       'S');
-----------------------------------------------------------------------------------------------------------------------------

INSERT INTO obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME)
VALUES ('buglist',
        '1',
        'itm_default');
        
INSERT INTO obj_itemchange (OBJ_NAME,FORM_NO,FIELD_NAME)
VALUES ('buglist',
        '1',
        'itm_defaultedit');
-----------------------------------------------------------------------------------------------------------------------------

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
 values ('bug_prc',1,'COMPONENT_TYPE','I','Component Type','C.String',null,sysdate,'BASE','BASE','EJB');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
 values ('bug_prc',2,'COMPONENT_NAME','I','Component Name','C.String',null,sysdate,'BASE','BASE','BugResolutionPrc');
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
 values ('bug_prc',3,'XML_DATA_1','I','XML data of form no 1','S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
 values ('bug_prc',4,'XML_DATA__ALL','I','XML data of form no 1','S',null,sysdate,'BASE','BASE',null);
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
 values ('bug_prc',5,'OBJ_CONTEXT','I','Object Context','S',null,sysdate,'BASE','BASE',null);
Insert Into system_service_args (Service_Code,Line_No,Arg_Name,Arg_Mode,Descr,Arg_Type,Arg_Xfrm,Chg_Date,Chg_User,Chg_Term,Arg_Value)
 Values ('bug_prc',6,'XTRA_PARAMS','I','Extra Arguments','S',Null,sysdate,'BASE','BASE',Null); 

-----------------------------------------------------------------------------------------------------------------------------

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTBUGID','Bug Id is blank','Bug Id should not be null or blank','E','Y',null,null,null,sysdate,'BASE','BASE');

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM) 
values ('VTBLNKID','Tran Id is blank','Tran Id should not be null or blank','E','Y',null,null,null,sysdate,'BASE','BASE');

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTBLNKOBJ','Obj name is not found','Worng Obj name not entered','E','Y',null,null,null,sysdate,'BASE','BASE');

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTDEPLOYED','Transaction can not be edited','Transaction is already deployed hence can not be processed','E','Y',null,null,null,sysdate,'BASE','BASE');

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM)
values ('UVFDREQ','Obj name is emply','Please enter obj name','E',null,null,null,null,SYSDATE,'BASE','BASE');

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM) 
values ('VTAFFTRAN','Transaction affected is blank','Transaction affected should not be null or blank','E','Y',null,null,null,SYSDATE,'BASE','BASE');

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM) 
values ('VTINVBUGID','Invalid Bug id','Bug Id not found in master','E','Y',null,null,null,SYSDATE,'BAS','BASE');

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM) 
values ('VTCOMPDEL','Components delivered is blank','Components delivered should not be null or blank','E','Y',null,
null,null,SYSDATE,'BASE','BASE');

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM) 
values ('VTRESVER','Resolved version is blank','Resolved version should not be null or blank','E','Y',null,null,null,
SYSDATE,'BASE','BASE');

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM)
values ('VTSOLDES','Solution Desired is blank','Solution desired should not be null or blank','E','Y',null,null,null,SYSDATE,'BASE','BASE');

-----------------------------------------------------------------------------------------------------------------------------

Insert into pophelp (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,
SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION) 
values ('OBJ_NAME','W_BUGLIST','SELECT SUBSTR(TRAN_WINDOW, 3),TABLE_NAME FROM TRANSETUP',null,'Window Name',80,100,
SYSDATE,'BASE','BASE','0',null,null,0,'C',null,null,null,null,null,'2');

Insert into pophelp (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,
SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION) 
values ('BUG_ID','W_BUGRESOLUTION','SELECT BUG_ID from BUGLIST',null,'Window Name',80,100,
SYSDATE,'BASE','BASE','0',null,null,0,'C',null,null,null,null,null,'2');

-----------------------------------------------------------------------------------------------------------------------------


create or replace 
PROCEDURE bugfixes_proc(bugID IN varchar2, tranID IN varchar2, resultStr OUT varchar2)
AS
BEGIN
   resultStr := 'SUCCESS';
   if(bugID = '0000000002' and tranID = '0000000464') then
      update inv_hold set remarks = 'test buglist' where tran_id = '0000000464';
   elsif (bugID = '0000000005' and tranID = 'PR00000007') then
      update pallet_req_det set quantity = '150' where tran_id = 'PR00000007';
   elsif (bugID = '0000000003' and tranID = 'PR00000008') then
      update pallet_req_det set quantity = '150' where tran_id = 'PR00000008';
   else
      resultStr := 'No update executed';
   end if;
   Exception
   when others then 
      rollback;
      resultStr := 'FAIL';
END;
