package ibase.dashboard.wms.servlet;

import ibase.dashboard.wms.ejb.WMS3PLSummDtlDashboardRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class OrderStatusSummaryPieServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		WMS3PLSummDtlDashboardRemote wms3PLSummDtlDashboardRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		
		String dataSourceName = "";
		String facilityCode = "";
		String businessType = "";
		JSONObject jsonObjData = null;
		OutputStream outputStream = null;
		HttpSession session = null;
		UserInfoBean userInfo = null;
		String sessionSiteCode = "";
		String sessionUserLevel = "";
		try
		{
			
			response.setContentType("application/xml");
			facilityCode = request.getParameter("facilityCode");
			businessType = request.getParameter("businessType");
			dataSourceName = request.getParameter("dataSourceName");

			session     	= request.getSession(true);
			userInfo 		= (UserInfoBean) session.getAttribute("USER_INFO");
			sessionSiteCode 	= userInfo.getSiteCode();
			sessionUserLevel    = userInfo.getUserLevel();
			System.out.println("in OrderStatusDtlPieQtyWiseServlet sessionSiteCode :"+sessionSiteCode);
			System.out.println("*********** In OrderStatusSummaryPieServlet facilityCode is *************** =" + facilityCode + " sessionUserLevel: "+sessionUserLevel);
			
			context = new InitialContext(appConnectParm.getProperty());
			wms3PLSummDtlDashboardRemote = (WMS3PLSummDtlDashboardRemote) context.lookup("ibase/WMS3PLSummDtlDashboard/remote");
			jsonObjData = (JSONObject) wms3PLSummDtlDashboardRemote.getOrderStatusSummaryPie(facilityCode, businessType, dataSourceName,sessionSiteCode,sessionUserLevel);
			outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			
			//String jsonObjDataStr = "{'SP101' :{'0':{'product_category':'Over Due','category_value':{'03-10-16':'91359590.736','04-10-16':'91359590.736'},'date':'1'},'1':{'product_category':'Outstanding','category_value':{'03-10-16':'22675'},'date':'2'},'2':{'product_category':'Pending Order','category_value':{'03-10-16':'43840974.179'},'date':'3'},'3':{'product_category':'Credit Limit','category_value':{'03-10-16':'10'},'date':'0'},'4':{'product_category':'Balance','category_value':{'03-10-16':'1.35223229915E8'},'date':'4'}}, 'SP102' :{'0':{'product_category':'Over Due','category_value':{'03-10-16':'91359590.736'},'date':'1'},'1':{'product_category':'Outstanding','category_value':{'03-10-16':'22675'},'date':'2'},'2':{'product_category':'Pending Order','category_value':{'03-10-16':'43840974.179'},'date':'3'},'3':{'product_category':'Credit Limit','category_value':{'03-10-16':'10'},'date':'0'},'4':{'product_category':'Balance','category_value':{'03-10-16':'1.35223229915E8'},'date':'4'}}}";
			/*String jsonObjDataStr ="{'0':{'value':'122','label':'TotalOrder'},'1':{'value':'147','label':'Shipment'},'2':{'value':'29','label':'Picked'},'3':{'value':'81','label':'Waved'},'4':{'value':'1','label':'WaitingforConfirmation'},'5':{'value':'0','label':'Credit_Hold'},'6':{'value':'14','label':'Canceled'},'7':{'value':'1','label':'Hold'},'8':{'value':'109','label':'Waiting Wave'}}";
			outputStream   = response.getOutputStream();			
			outputStream.write(jsonObjDataStr.toString().replace('\'', '"').getBytes());
			outputStream.flush();
			outputStream.close();*/
			System.out.println(" Final data set for OrderStatusSummaryPieServlet for the build the Graph is ===" + jsonObjData);		

		}
		catch (Exception e)
		{
			System.out.println("Exception : OrderStatusSummaryPieServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
