package ibase.dashboard.sfa.ejb;
import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;
/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class CurrentDayWrkSummary extends ValidatorEJB implements CurrentDayWrkSummaryLocal, CurrentDayWrkSummaryRemote
{
	public CurrentDayWrkSummary() {
        // TODO Auto-generated constructor stub
    }
	GenericUtility genericUtility = GenericUtility.getInstance();
    
	@SuppressWarnings("unchecked")
	@Override
    public JSONObject getCurrentDayWorkSummary(String dataSourceName, String date, String salePerson) throws RemoteException, ITMException
    {
		JSONObject rawDataEmployeeProdSurveylJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		int count =0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		
		
		String appendSqlStr = "";
		try
		{
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			dashboardUtility = new DashboardUtility();
			salePerson = dashboardUtility.getCommaSeparated(salePerson);
			System.out.println("Date getCurrentDayWorkSummary :"+date);
			System.out.println("Date.length getCurrentDayWorkSummary :"+date.length());
			if(date.length() == 0 || date == null)
			{
				System.out.println("in if date getCurrentDayWorkSummary ");
				DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
				java.util.Date currentDate = Calendar.getInstance().getTime();
				date = dtFormat.format( currentDate );
				date = genericUtility.getValidDateTimeString( date, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				
				appendSqlStr = " And SM.Sales_Pers In ( Select Emp_Code " +
						   " From Employee Start With Emp_code = (Select Emp_Code From Users Where Code = "+salePerson+") " +
					       " Connect By Prior Emp_Code =Report_To )";
			}
			else
			{
				System.out.println("in else date getCurrentDayWorkSummary");
				date = genericUtility.getValidDateTimeString( date, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				
				appendSqlStr = " And SM.Sales_Pers In ("+salePerson+") ";
			}
			
			System.out.println("In getCurrentDayWorkSummary==>>currDate II = ["+date+"] salePerson = ["+salePerson+"]" );
			
			sql =   " Select count(SalesPerson_Code)as people, nvl(Sum(Tot_calls),0) as TC, " +
			" nvl(Sum(TOT_PC),0) as PC, nvl(sum(call_bal),0) as CallBAL, nvl(sum(TLSD),0) as TLSD, " +
			" nvl(Sum(ORD_val),0) as ordval, nvl(sum(display),0) as display " +
			" from( " +
			" Select " +
			" To_CHAR(TRUNC(?),'DD-MM-YYYY') as show_Date , " +
			" SalesPerson_Code , " +
			" SalesPerson_Name , SUM(Tot_Calls) Tot_Calls , SUM(Tot_PC) Tot_PC , " +
			" SUM((To_Calls - Tot_Dist_Calls)) Call_Bal , SUM(TLSD) TLSD , " +
			" SUM(Ord_Val) Ord_Val , SUM(Display) Display " +
			" From ( Select SM.Sales_Pers as SalesPerson_Code , " +
			" SP.SP_Name as SalesPerson_Name ,nvl(count(strg_code),0) as Tot_Calls , nvl(count(Distinct strg_code),0) as Tot_Dist_Calls ," +
			" nvl((select count(distinct strg_code) from STRG_MEET_ORDER SMO " +
			" where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as Tot_PC ," +
			" NVL((Select count(sc_code) From Strg_Series Where Sales_Pers = SM.Sales_Pers " +
			" And Sc_Code in (Select sC_cODE From STRG_Customer_Retail " +
			" Where Locality_Code In (Select locality_Code From sPRS_TRAVEL " +
			" Where Sales_Pers = SM.Sales_Pers " +
			"AND travel_date = TO_DATE(To_CHAR(TRUNC(?),'DD-MM-YYYY'),'DD-MM-YYYY') " +
			" )) ),0) AS To_Calls , " +
			" nvl((select count(*) from STRG_MEET_ORDER SMO " +
			" where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as TLSD , " +
			" nvl((select sum(value) from STRG_MEET_ORDER SMO " +
			" where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as Ord_Val , " +
			" nvl((select count(distinct strg_code) from STRG_ITEM_DISPLAY SID " +
			" where SID.dcr_id=SM.dcr_id),0) as Display " +
			" FROM Strg_Meet SM ,Sales_Pers SP Where SM.Sales_Pers = SP.Sales_Pers " +
			" And SM.Event_Date = TO_DATE(To_CHAR(TRUNC(?),'DD-MM-YYYY'),'DD-MM-YYYY')" +
			" " + appendSqlStr + " " +
			" Group By SM.Sales_Pers ," +
			" SP.SP_Name ,SM.dcr_id ) " +
			" Group By SalesPerson_Name, SalesPerson_Code Order By SalesPerson_Name)";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(date));
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(date));
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(date));
			rs = pstmt.executeQuery();

			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("people",checkNull (rs.getString("PEOPLE")));						
				rowData.put("tc", checkNull(rs.getString("TC")));
				rowData.put("pc",checkNull( rs.getString("PC")));
				rowData.put("callbal", checkNull(rs.getString("CALLBAL")));
				rowData.put("tlsd",checkNull( rs.getString("TLSD")));
				rowData.put("ordval",checkNull( rs.getString("ORDVAL")));
				rowData.put("display",checkNull( rs.getString("DISPLAY")));
				
					
				rawDataEmployeeProdSurveylJson.put(count, rowData);
				count++;
				
				
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :CurrentDayWrkSummary : getCurrentDayWorkSummary" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataEmployeeProdSurveylJson;
		
	}
   
	
	@SuppressWarnings("unchecked")
	@Override
    public JSONObject getCurrentDayWorkSummaryDetail(String dataSourceName, String date, String salePerson) throws RemoteException, ITMException
    {
		JSONObject rawDataCurrentDayWrkSumDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		int count =0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		
		
		String appendSqlStr = "";
		try
		{
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			dashboardUtility = new DashboardUtility();
			salePerson = dashboardUtility.getCommaSeparated(salePerson);
			System.out.println("Date getCurrentDayWorkSummaryDetail:"+date);
			System.out.println("Date.length getCurrentDayWorkSummaryDetail:"+date.length());
			String userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator;
			
			if(date.length() == 0 || date == null)
			{
				System.out.println("in if date ");
				DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
				java.util.Date currentDate = Calendar.getInstance().getTime();
				date = dtFormat.format( currentDate );
				date = genericUtility.getValidDateTimeString( date, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				
				appendSqlStr = " And SM.Sales_Pers In ( Select Emp_Code " +
						   " From Employee Start With Emp_code = (Select Emp_Code From Users Where Code = "+salePerson+") " +
					       " Connect By Prior Emp_Code =Report_To )";
			}
			else
			{
				System.out.println("in else date ");
				date = genericUtility.getValidDateTimeString( date, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				
				appendSqlStr = " And SM.Sales_Pers In ("+salePerson+") ";
			}
			System.out.println("CommonConstants.TOMCAT_HOME = ["+CommonConstants.TOMCAT_HOME+"]" );
			System.out.println("In getCurrentDayWorkSummaryDetail==>>currDate II = ["+date+"] salePerson = ["+salePerson+"]" );
			
			sql =   "  Select " +
					//"To_CHAR(TRUNC(?),'DD-MM-YYYY') as show_Date , " +
					"SalesPerson_Code , To_Calls," +
			" SalesPerson_Name , nvl(SUM(Tot_Calls),0) as Tot_Calls , nvl(SUM(Tot_PC),0) as Tot_PC , " +
			" nvl(SUM((To_Calls - Tot_Dist_Calls)),0) as Call_Bal , nvl(SUM(TLSD),0) as TLSD , " +
			" nvl(SUM(Ord_Val),0) as Ord_Val , nvl(SUM(Display),0) as Display " +
			" From ( Select SM.Sales_Pers as SalesPerson_Code , " +
			" SP.SP_Name as SalesPerson_Name ,nvl(count(strg_code),0) as Tot_Calls , nvl(count(Distinct strg_code),0) as Tot_Dist_Calls ," +
			" nvl((select count(distinct strg_code) from STRG_MEET_ORDER SMO " +
			" where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as Tot_PC ," +
			" NVL((Select count(sc_code) From Strg_Series Where Sales_Pers = SM.Sales_Pers " +
			" And Sc_Code in (Select sC_cODE From STRG_Customer_Retail " +
			" Where Locality_Code In (Select locality_Code From sPRS_TRAVEL " +
			" Where Sales_Pers = SM.Sales_Pers " +
			"AND travel_date = TO_DATE(To_CHAR(TRUNC(?),'DD-MM-YYYY'),'DD-MM-YYYY') " +
			" )) ),0) AS To_Calls , " +
			" nvl((select count(*) from STRG_MEET_ORDER SMO " +
			" where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as TLSD , " +
			" nvl((select sum(value) from STRG_MEET_ORDER SMO " +
			" where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as Ord_Val , " +
			" nvl((select count(distinct strg_code) from STRG_ITEM_DISPLAY SID " +
			" where SID.dcr_id=SM.dcr_id),0) as Display " +
			" FROM Strg_Meet SM ,Sales_Pers SP Where SM.Sales_Pers = SP.Sales_Pers " +
			" And SM.Event_Date = TO_DATE(To_CHAR(TRUNC(?),'DD-MM-YYYY'),'DD-MM-YYYY')" +
			" " + appendSqlStr + " " +
			" Group By SM.Sales_Pers ," +
			" SP.SP_Name ,SM.dcr_id ) " +
			" Group By SalesPerson_Name, To_Calls, SalesPerson_Code Order By SalesPerson_Name";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(date));
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(date));
			//pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(date));
			rs = pstmt.executeQuery();

			
			while (rs.next())
			{
				rowData = new JSONObject();
				String salesPersName = checkNull (rs.getString("SALESPERSON_NAME")).trim();
				String salesPersCode = checkNull (rs.getString("SalesPerson_Code")).trim();
				rowData.put("people",salesPersName);	
				
				File file = new File(userImagePath+salesPersCode+".png");
				System.out.println("userImagePath :"+userImagePath+salesPersCode);
				if(file.exists())
				{
					rowData.put("salesperson_code", "<img class='cardProdImg' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+salesPersCode+".png'/>");
				}else
				{

					String[] splited = salesPersName.split(" ");
					System.out.println("splited getCurrentDayWorkSummaryDetail    :"+splited[0].charAt(0));
					String defaultUserImg = ""+splited[0].charAt(0);
					
					if(splited.length>1)
					{
						/*Get lastWord of salesPersName and add first char to image for more than one space in salesPersName by Dhanendra on Date 07-07-2016 */
						String lastWord = salesPersName.substring(salesPersName.lastIndexOf(" ")+1);
						System.out.println("lastWord  getCurrentDayWorkSummaryDetail  :"+lastWord);
						defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
					}
					System.out.println("defaultUserImg :"+defaultUserImg);
					
					rowData.put("salesperson_code", "<div class='defaultUserImg'> "+defaultUserImg+" </div>");
				}
				
				rowData.put("tc", checkNull(rs.getString("TOT_CALLS")));
				rowData.put("pc",checkNull( rs.getString("TOT_PC")));
				rowData.put("callbal", checkNull(rs.getString("CALL_BAL")));
				rowData.put("tlsd",checkNull( rs.getString("TLSD")));
				rowData.put("ordval",checkNull( rs.getString("ORD_VAL")));
				rowData.put("display",checkNull( rs.getString("DISPLAY")));
				
				rowData.put("To_Calls",checkNull( rs.getString("To_Calls")));
				rawDataCurrentDayWrkSumDtlJson.put(count, rowData);
				count++;
				
				
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :CurrentDayWrkSummary : getCurrentDayWorkSummaryDetail" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataCurrentDayWrkSumDtlJson;
		
	}
	
	@SuppressWarnings("unchecked")
	@Override
    public JSONObject getCurrentDayWorkDtl(String dataSourceName, String date, String salePerson) throws RemoteException, ITMException
    {
		JSONObject rawDataCurrentDayWrkSumDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		int count =0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		
		
		String appendSqlStr = "";
		try
		{
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			dashboardUtility = new DashboardUtility();
			salePerson = dashboardUtility.getCommaSeparated(salePerson);
			if(date.length() == 0 || date == null)
			{
				DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
				java.util.Date currentDate = Calendar.getInstance().getTime();
				date = dtFormat.format( currentDate );
				date = genericUtility.getValidDateTimeString( date, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				
				appendSqlStr = " And SM.Sales_Pers In ( Select Emp_Code " +
						   " From Employee Start With Emp_code = (Select Emp_Code From Users Where Code = "+salePerson+") " +
					       " Connect By Prior Emp_Code =Report_To )";
			}
			else
			{
				date = genericUtility.getValidDateTimeString( date, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				
				appendSqlStr = " And SM.Sales_Pers In ("+salePerson+") ";
			}
			
			System.out.println("In getCurrentDayWorkDtl==>>currDate II = ["+date+"] salePerson = ["+salePerson+"]" );
			
			sql =   " Select count(Sku_Name) as Sku_Name , nvl(sum(outlet_booked),0) as outlet_booked " + 
					" from( " +
					" Select  " +
					" I.Descr AS Sku_Name  " +
					" ,Sum(SMO.Quantity) as Qty_Booked  " +
					" ,Count(SMO.Strg_Code) as outlet_booked " + 
					" FROM Strg_Meet SM   " +
					" ,Sales_Pers SP  " +
					" ,Strg_Meet_Order SMO " + 
					" ,item I  " +
					" Where SM.Sales_Pers = SP.Sales_Pers  " +
					" And SM.Strg_Code = SMO.Strg_Code " + 
					" And SM.Dcr_Id = SMO.DCR_Id  " +
					" And I.Item_Code = SMO.Item_Code  " +
					" And SM.Event_Date = TO_DATE(To_CHAR(TRUNC(?),'DD-MM-YYYY'),'DD-MM-YYYY') " +
					" " + appendSqlStr + " " +
					" And (SMO.Quantity) > 0 " + 
					" Group By " + 
					" I.Descr " +
					" Order By Sku_Name)";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(date));
			rs = pstmt.executeQuery();

			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("sku_name",checkNull (rs.getString("SKU_NAME")));						
				rowData.put("outlet_booked", checkNull(rs.getString("OUTLET_BOOKED")));
				
				rawDataCurrentDayWrkSumDtlJson.put(count, rowData);
				count++;
				
				
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :CurrentDayWrkSummary : getCurrentDayWorkDtl" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataCurrentDayWrkSumDtlJson;
		
	}
	
	
	@SuppressWarnings("unchecked")
	@Override
    public JSONObject getCurrentDayWorkSKUDtl(String dataSourceName, String date, String salePerson) throws RemoteException, ITMException
    {
		JSONObject rawDataCurrentDayWrkSKUDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		int count =0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		
		
		String appendSqlStr = "";
		try
		{
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			dashboardUtility = new DashboardUtility();
			salePerson = dashboardUtility.getCommaSeparated(salePerson);
			if(date.length() == 0 || date == null)
			{
				DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
				java.util.Date currentDate = Calendar.getInstance().getTime();
				date = dtFormat.format( currentDate );
				date = genericUtility.getValidDateTimeString( date, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				
				appendSqlStr = " And SM.Sales_Pers In ( Select Emp_Code " +
						   " From Employee Start With Emp_code = (Select Emp_Code From Users Where Code = "+salePerson+") " +
					       " Connect By Prior Emp_Code =Report_To )";
			}
			else
			{
				date = genericUtility.getValidDateTimeString( date, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				
				appendSqlStr = " And SM.Sales_Pers In ("+salePerson+") ";
			}
			
			System.out.println("In getCurrentDayWorkSKUDtl==>>currDate II = ["+date+"] salePerson = ["+salePerson+"]" );
			
			sql = "Select " +
					" sm.sales_pers " +
					" ,SP.SP_Name as SalesPerson_Name " +
					" ,I.Descr AS Sku_Name " +
					" ,Sum(SMO.Quantity) as Qty_Booked " +
					" ,Count(SMO.Strg_Code) as outlet_booked " +
					" FROM Strg_Meet SM  " +
					" ,Sales_Pers SP " +
					" ,Strg_Meet_Order SMO " +
					" ,item I " +
					" Where SM.Sales_Pers = SP.Sales_Pers " +
					" And SM.Strg_Code = SMO.Strg_Code " +
					" And SM.Dcr_Id = SMO.DCR_Id " +
					" And I.Item_Code = SMO.Item_Code " +
					" And SM.Strg_Type = 'C' " +
					" And SM.Event_Date = TO_DATE(To_CHAR(TRUNC(?),'DD-MM-YYYY'),'DD-MM-YYYY')" +
					" " + appendSqlStr + " " +
					" And (SMO.Quantity) > 0 " +
					" Group By " +
					" sm.sales_pers " +
					" ,SP.SP_Name  " +
					" ,I.Descr " +
					" Order By SalesPerson_Name,Sku_Name";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(date));
			rs = pstmt.executeQuery();
			String salesPersnName = "";
			String prvSalesPersnName = "";
			String skuName = "";
			String skuImg = "";
			String salesPersCode = "";
			String userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator;
			while (rs.next())
			{
				rowData = new JSONObject();
				
				salesPersnName = checkNull(rs.getString("SALESPERSON_NAME"));
				salesPersCode  = checkNull(rs.getString("SALES_PERS")).trim();
				
				if(!salesPersnName.equalsIgnoreCase(prvSalesPersnName))
				{
					rowData.put("salesperson_name", salesPersnName);
					rowData.put("cardSalesPersonTitle", "cardSalesPersonTitle");
					
					rowData.put("item", "SKU Name");
					rowData.put("outlets_name", "Outlet");
					rowData.put("quantity_name", "Quantity");
					
					System.out.println("salesPersCode :"+salesPersCode);
					File file = new File(userImagePath+salesPersCode+".png");
					if(file.exists())
					{
						rowData.put("salesperson_code", "<img class='cardProdImg' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+salesPersCode+".png'/>");
					}else
					{
						salesPersnName = salesPersnName.trim();
						String[] splited = salesPersnName.split(" ");
						System.out.println("splited getCurrentDayWorkSKUDtl   :"+splited[0].charAt(0));
						String defaultUserImg = ""+splited[0].charAt(0);
						
						if(splited.length>1)
						{
							/*Get lastWord of salesPersName and add first char to image for more than one space in salesPersName by Dhanendra on Date 07-07-2016 */
							String lastWord = salesPersnName.substring(salesPersnName.lastIndexOf(" ")+1);
							System.out.println("lastWord getCurrentDayWorkSKUDtl  :"+lastWord);
							defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
						}
						System.out.println("defaultUserImg :"+defaultUserImg);
						
						rowData.put("salesperson_code", "<div class='defaultUserImg'> "+defaultUserImg+" </div>");
					}
					
					prvSalesPersnName  = salesPersnName;
				}else
				{
					rowData.put("salesperson_name", " ");
					rowData.put("salesperson_code", "");
					rowData.put("item", "");
					rowData.put("outlets_name", "");
					rowData.put("quantity_name", "");
				}
				skuName = checkNull (rs.getString("SKU_NAME"));
				System.out.println("skuName :"+skuName.length());
				if(skuName.length() > 0)
				{
					skuName = skuName.trim();
					String[] splited = skuName.split(" ");
					System.out.println("splited[0].toLowerCase() getCurrentDayWorkSKUDtl  :"+splited[0].toLowerCase());
					String productImgName = splited[0].toLowerCase();
					System.out.println("productImgName  getCurrentDayWorkSKUDtl :"+productImgName);
					File file = new File(userImagePath+productImgName+".png");
					if(file.exists())
					{
						rowData.put("sku_img", "<img class='cardProdImg' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+productImgName+".png'/>");
					}else
					{
						String[] splited1 = skuName.split(" ");
						productImgName = ""+splited1[0].charAt(0);
						
						if(splited1.length>1)
						{
							/*Get lastWord of productImgName and add first char to image for more than one space in productImgName by Dhanendra on Date 07-07-2016 */
							String lastWord = salesPersnName.substring(productImgName.lastIndexOf(" ")+1);
							System.out.println("lastWord product getCurrentDayWorkSKUDtl  :"+lastWord);
							productImgName = productImgName + ""+lastWord.charAt(0);
						}
						System.out.println("productImgName :"+productImgName);
						rowData.put("sku_img","<div class='defaultUserImg'> "+productImgName+" </div>");
					}
				}else {
					rowData.put("sku_img","");
				}
				rowData.put("sales_pers", checkNull(rs.getString("SALES_PERS")));
				rowData.put("salesperson_name_hidden", checkNull(rs.getString("SALESPERSON_NAME")));
				rowData.put("sku_name",checkNull (rs.getString("SKU_NAME")));						
				rowData.put("outlet_booked", checkNull(rs.getString("OUTLET_BOOKED")));
				rowData.put("qty_booked", checkNull(rs.getString("QTY_BOOKED")));
				
				rawDataCurrentDayWrkSKUDtlJson.put(count, rowData);
				count++;
				
				
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :CurrentDayWrkSummary : getCurrentDayWorkSKUDtl" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataCurrentDayWrkSKUDtlJson;
		
	}
	
	

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getMTDWorkParent(String dataSourceName, String month, String year, String salePerson) throws RemoteException, ITMException
	{
		JSONObject rawDataMTDWorkParentJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		int count =0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		
		Calendar cal = Calendar.getInstance();
		String appendSqlStr = "";
		try
		{
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			dashboardUtility = new DashboardUtility();
			salePerson = dashboardUtility.getCommaSeparated(salePerson);
			if(checkNull(month).length()<1 || checkNull(year).length()<1)
			{
				month = getMonth(""+(cal.get(Calendar.MONTH) + 1));
				year = ""+(cal.get(Calendar.YEAR));
				System.out.println("In getMTDWorkParent current ==>>month = ["+month+"] year = ["+year+"] salePers = ["+salePerson+"]" );
				
				appendSqlStr = " And SM.Sales_Pers In ( Select Emp_Code " +
						   " From Employee Start With Emp_code = (Select Emp_Code From Users Where Code = "+salePerson+") " +
					       " Connect By Prior Emp_Code =Report_To )";
			}else
			{
				appendSqlStr = " And SM.Sales_Pers In ("+salePerson+") ";
			}
			month = dashboardUtility.getCommaSeparated(checkNull(month));
			year = dashboardUtility.getCommaSeparated(checkNull(year));
			
			System.out.println("In getMTDWorkParent pophelp selected ==>>month = ["+month+"] year = ["+year+"] salePers = ["+salePerson+"]" );
			
			sql =  " Select count(SalesPerson_Name) as people, nvl(SUM(Tot_Calls),0) as Tot_Calls , " +
				" nvl(SUM(Tot_PC),0) as  Tot_PC , " +
				" nvl(SUM(ECO),0) as  ECO ,round(nvl(Sum(TLSD),0),2) as TLSD, nvl(SUM(Ord_Val),0) as Ord_Val ,nvl(SUM(Display),0) Display " + 
				" from( " +
				" Select  " +
				" SalesPerson_Name , " +
				" SUM(Tot_Calls) Tot_Calls , " +
				" SUM(Tot_PC) Tot_PC , " +
				" SUM(ECO) ECO , " +
				" (Case When Sum(Tot_FW_Days) = 0 Then 0 Else SUM(TLSD)/Sum(Tot_FW_Days) End) as TLSD , " +
				" SUM(Ord_Val) Ord_Val ,SUM(Display) Display  " +
				" From ( Select SM.Sales_Pers as SalesPerson_Code ,SP.SP_Name as SalesPerson_Name ,nvl(count(SM.strg_code),0) as Tot_Calls , " +
				" nvl((select count(distinct strg_code) from STRG_MEET_ORDER SMO where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as Tot_PC , " +
				" 0 as ECO ,nvl((select count(*) from STRG_MEET_ORDER SMO where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as TLSD , " +
				" nvl((select sum(value) from STRG_MEET_ORDER SMO where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as Ord_Val , " +
				" nvl((select count(distinct strg_code) from STRG_ITEM_DISPLAY SID where SID.dcr_id=SM.dcr_id),0) as Display , " +
				" nvl(COUNT(DISTINCT (case when FA.Activity_Type = 'FW' Then (SM.DCR_ID) end)),0) as Tot_FW_Days  FROM Strg_Meet SM , " +
				" Sales_Pers SP , " +
				" FieldActivity FA   " +
				" Where SM.Sales_Pers = SP.Sales_Pers And FA.Activity_Code = SM.Event_Type " + 
				" And SM.event_date  BETWEEN trunc(to_date("+month+" || "+year+", 'MONYYYY'), 'MON') AND last_day(to_date("+month+" || "+year+", 'MONYYYY')) " + 
				" "+appendSqlStr+ " " + 
				" Group By SM.Sales_Pers ,SP.SP_Name ,SM.dcr_id " +  
				" UNION ALL   " +
				" select SM.Sales_Pers as SalesPerson_Code , " +
				" SP.SP_Name as SalesPerson_Name , " +
				" 0 as Tot_Calls , " +
				" 0 as Tot_PC , " +
				" nvl(count(distinct smo.strg_code),0) as ECO , " +
				" 0 as TLSD , " +
				" 0 as Ord_Val , " +
				" 0 as Display , " +
				" 0 as Tot_FW_Days   " +
				" FROM Strg_Meet SM ,Sales_Pers SP , " +
				" Strg_Meet_Order SMO   " +
				" Where SM.Sales_Pers = SP.Sales_Pers " + 
				" And SM.Strg_Code = SMO.Strg_Code And SM.Dcr_Id = SMO.DCR_Id " + 
				" And SM.event_date BETWEEN trunc(to_date("+month+" || "+year+", 'MONYYYY'), 'MON') " + 
				" AND last_day(to_date("+month+" || "+year+", 'MONYYYY'))  " +
				" "+appendSqlStr+ " " +
				" And (SMO.Quantity) > 0 Group By SM.Sales_Pers,SP.SP_Name ) " + 
				" Group By  " +
				" SalesPerson_Name )";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();

			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("people",checkNull (rs.getString("PEOPLE")));						
				rowData.put("tc", checkNull(rs.getString("TOT_CALLS")));
				rowData.put("pc",checkNull( rs.getString("TOT_PC")));
				rowData.put("eco", checkNull(rs.getString("ECO")));
				rowData.put("tlsd",checkNull( rs.getString("TLSD")));
				rowData.put("ordval",checkNull( rs.getString("ORD_VAL")));
				rowData.put("display",checkNull( rs.getString("DISPLAY")));
				
				rawDataMTDWorkParentJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :CurrentDayWrkSummary : getMTDWorkParent" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataMTDWorkParentJson;
		
	}

	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getMTDWorkSummary(String dataSourceName, String month, String year, String salePerson) throws RemoteException, ITMException 
	{
		JSONObject rawDataMTDWorkParentJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		int count =0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		
		Calendar cal = Calendar.getInstance();
		String appendSqlStr = "";
		String userImagePath ="";
		String salesPersName = "";
		try
		{
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			dashboardUtility = new DashboardUtility();
			salePerson = dashboardUtility.getCommaSeparated(salePerson);
			userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator;
			if(checkNull(month).length()<1 || checkNull(year).length()<1)
			{
				month = getMonth(""+(cal.get(Calendar.MONTH) + 1));
				year = ""+(cal.get(Calendar.YEAR));
				System.out.println("In getMTDWorkSummary current ==>>month = ["+month+"] year = ["+year+"] salePers = ["+salePerson+"]" );
				
				appendSqlStr = " And SM.Sales_Pers In ( Select Emp_Code " +
						   " From Employee Start With Emp_code = (Select Emp_Code From Users Where Code = "+salePerson+") " +
					       " Connect By Prior Emp_Code =Report_To )";
			}else
			{
				appendSqlStr = " And SM.Sales_Pers In ("+salePerson+") ";
			}
			month = dashboardUtility.getCommaSeparated(checkNull(month));
			year = dashboardUtility.getCommaSeparated(checkNull(year));
			
			System.out.println("In getMTDWorkSummary pophelp selected ==>>month = ["+month+"] year = ["+year+"] salePers = ["+salePerson+"]" );
			
			sql =" Select  " +
				" SalesPerson_Code,SalesPerson_Name , " +
				" SUM(Tot_Calls) Tot_Calls , " +
				" SUM(Tot_PC) Tot_PC , " +
				" SUM(ECO) ECO , " +
				" round((Case When Sum(Tot_FW_Days) = 0 Then 0 Else SUM(TLSD)/Sum(Tot_FW_Days) End),2) as TLSD , " +
				" SUM(Ord_Val) Ord_Val ,SUM(Display) Display  " +
				" From ( Select SM.Sales_Pers as SalesPerson_Code ,SP.SP_Name as SalesPerson_Name ,nvl(count(SM.strg_code),0) as Tot_Calls , " +
				" nvl((select count(distinct strg_code) from STRG_MEET_ORDER SMO where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as Tot_PC , " +
				" 0 as ECO ,nvl((select count(*) from STRG_MEET_ORDER SMO where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as TLSD , " +
				" nvl((select sum(value) from STRG_MEET_ORDER SMO where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as Ord_Val , " +
				" nvl((select count(distinct strg_code) from STRG_ITEM_DISPLAY SID where SID.dcr_id=SM.dcr_id),0) as Display , " +
				" nvl(COUNT(DISTINCT (case when FA.Activity_Type = 'FW' Then (SM.DCR_ID) end)),0) as Tot_FW_Days  FROM Strg_Meet SM , " +
				" Sales_Pers SP , " +
				" FieldActivity FA   " +
				" Where SM.Sales_Pers = SP.Sales_Pers And FA.Activity_Code = SM.Event_Type " + 
				" And SM.event_date  BETWEEN trunc(to_date("+month+" || "+year+", 'MONYYYY'), 'MON') AND last_day(to_date("+month+" || "+year+", 'MONYYYY')) " + 
				" "+appendSqlStr+ " " + 
				" Group By SM.Sales_Pers ,SP.SP_Name ,SM.dcr_id " +  
				" UNION ALL   " +
				" select SM.Sales_Pers as SalesPerson_Code , " +
				" SP.SP_Name as SalesPerson_Name , " +
				" 0 as Tot_Calls , " +
				" 0 as Tot_PC , " +
				" nvl(count(distinct smo.strg_code),0) as ECO , " +
				" 0 as TLSD , " +
				" 0 as Ord_Val , " +
				" 0 as Display , " +
				" 0 as Tot_FW_Days   " +
				" FROM Strg_Meet SM ,Sales_Pers SP , " +
				" Strg_Meet_Order SMO   " +
				" Where SM.Sales_Pers = SP.Sales_Pers " + 
				" And SM.Strg_Code = SMO.Strg_Code And SM.Dcr_Id = SMO.DCR_Id " + 
				" And SM.event_date BETWEEN trunc(to_date("+month+" || "+year+", 'MONYYYY'), 'MON') " + 
				" AND last_day(to_date("+month+" || "+year+", 'MONYYYY'))  " +
				" "+appendSqlStr+ " " +
				" And (SMO.Quantity) > 0 Group By SM.Sales_Pers,SP.SP_Name ) " + 
				" Group By  " +
				" SalesPerson_Name,SalesPerson_Code";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();

			
			while (rs.next())
			{
				rowData = new JSONObject();
				
				salesPersName = checkNull (rs.getString("SALESPERSON_NAME"));
				rowData.put("salesperson_name",salesPersName);						
				
				String salesPersCode = checkNull (rs.getString("SalesPerson_Code")).trim();
				File file = new File(userImagePath+salesPersCode+".png");
				if(file.exists())
				{
					rowData.put("salesperson_code", "<img class='cardProdImg' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+salesPersCode+".png'/>");
				}else
				{
					salesPersName = salesPersName.trim();
					String[] splited = salesPersName.split(" ");
					System.out.println("splited  getMTDWorkSummary :"+splited[0].charAt(0));
					String defaultUserImg = ""+splited[0].charAt(0);
					
					if(splited.length>1)
					{
						/*Get lastWord of salesPersName and add first char to image for more than one space in salesPersName by Dhanendra on Date 07-07-2016 */
						String lastWord = salesPersName.substring(salesPersName.lastIndexOf(" ")+1);
						System.out.println("lastWord getMTDWorkSummary :"+lastWord);
						defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
					}
					System.out.println("defaultUserImg :"+defaultUserImg);
					rowData.put("salesperson_code", "<div class='defaultUserImg'> "+defaultUserImg+" </div>");
				}
				
				rowData.put("tc", checkNull(rs.getString("TOT_CALLS")));
				rowData.put("pc",checkNull( rs.getString("TOT_PC")));
				rowData.put("eco", checkNull(rs.getString("ECO")));
				rowData.put("tlsd",checkNull( rs.getString("TLSD")));
				rowData.put("ordval",checkNull( rs.getString("ORD_VAL")));
				rowData.put("display",checkNull( rs.getString("DISPLAY")));
				
				rawDataMTDWorkParentJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :CurrentDayWrkSummary : getMTDWorkSummary" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataMTDWorkParentJson;
		
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getMTDWorkDtlParent(String dataSourceName, String month, String year, String salePerson) throws RemoteException, ITMException 
	{
		JSONObject rawDataMTDWorkDtlParentJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		int count =0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		
		Calendar cal = Calendar.getInstance();
		String appendSqlStr = "";
		try
		{
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			dashboardUtility = new DashboardUtility();
			salePerson = dashboardUtility.getCommaSeparated(salePerson);
			if(checkNull(month).length()<1 || checkNull(year).length()<1)
			{
				month = getMonth(""+(cal.get(Calendar.MONTH) + 1));
				year = ""+(cal.get(Calendar.YEAR));
				System.out.println("In getMTDWorkDtlParent current ==>>month = ["+month+"] year = ["+year+"] salePers = ["+salePerson+"]" );
				
				appendSqlStr = " And sm.Sales_Pers In ( Select Emp_Code " +
						   " From Employee Start With Emp_code = (Select Emp_Code From Users Where Code = "+salePerson+") " +
					       " Connect By Prior Emp_Code =Report_To )";
			}else
			{
				appendSqlStr = " And sm.Sales_Pers In ("+salePerson+") ";
			}
			month = dashboardUtility.getCommaSeparated(checkNull(month));
			year = dashboardUtility.getCommaSeparated(checkNull(year));
			
			System.out.println("In getMTDWorkDtlParent pophelp selected ==>>month = ["+month+"] year = ["+year+"] salePers = ["+salePerson+"]" );
			
			sql =  " Select Count(SalesPerson_Name) as people,  nvl(SUM(Tot_Calls),0) as Tot_Calls ,nvl(Sum(Tot_PC),0) as Tot_PC  , " +
					" round(nvl(Sum(TLSD),0),2) as TLSD, " +
					" nvl(Sum(ORD_VAL),0) as ORD_VAL " +
					" from(  " +
					" Select  " +
				" SalesPerson_Code,SalesPerson_Name , " +
				" SUM(Tot_Calls) Tot_Calls , " +
				" SUM(Tot_PC) Tot_PC , " +
				" SUM(ECO) ECO , " +
				" (Case When Sum(Tot_FW_Days) = 0 Then 0 Else SUM(TLSD)/Sum(Tot_FW_Days) End) as TLSD , " +
				" SUM(Ord_Val) Ord_Val ,SUM(Display) Display  " +
				" From ( Select SM.Sales_Pers as SalesPerson_Code ,SP.SP_Name as SalesPerson_Name ,nvl(count(SM.strg_code),0) as Tot_Calls , " +
				" nvl((select count(distinct strg_code) from STRG_MEET_ORDER SMO where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as Tot_PC , " +
				" 0 as ECO ,nvl((select count(*) from STRG_MEET_ORDER SMO where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as TLSD , " +
				" nvl((select sum(value) from STRG_MEET_ORDER SMO where SMO.dcr_id=SM.dcr_id and SMO.Quantity > 0),0) as Ord_Val , " +
				" nvl((select count(distinct strg_code) from STRG_ITEM_DISPLAY SID where SID.dcr_id=SM.dcr_id),0) as Display , " +
				" nvl(COUNT(DISTINCT (case when FA.Activity_Type = 'FW' Then (SM.DCR_ID) end)),0) as Tot_FW_Days  FROM Strg_Meet SM , " +
				" Sales_Pers SP , " +
				" FieldActivity FA   " +
				" Where SM.Sales_Pers = SP.Sales_Pers And FA.Activity_Code = SM.Event_Type " + 
				" And SM.event_date  BETWEEN trunc(to_date("+month+" || "+year+", 'MONYYYY'), 'MON') AND last_day(to_date("+month+" || "+year+", 'MONYYYY')) " + 
				" "+appendSqlStr+ " " + 
				" Group By SM.Sales_Pers ,SP.SP_Name ,SM.dcr_id " +  
				" ) " + 
				" Group By  " +
				" SalesPerson_Name,SalesPerson_Code) ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();

			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("people",checkNull (rs.getString("people")));						
				rowData.put("tc", checkNull(rs.getString("Tot_Calls")));
				rowData.put("pc",checkNull( rs.getString("Tot_PC")));
				rowData.put("tlsd",checkNull( rs.getString("TLSD")));
				rowData.put("ordval",checkNull( rs.getString("ORD_VAL")));
				
				rawDataMTDWorkDtlParentJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :CurrentDayWrkSummary : getMTDWorkDtlParent" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataMTDWorkDtlParentJson;
		
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getMTDWorkDetail(String dataSourceName, String month, String year, String salePerson) throws RemoteException, ITMException 
	{
		JSONObject rawDataMTDWorkDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		int count =0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		
		Calendar cal = Calendar.getInstance();
		String appendSqlStr = "";
		try
		{
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			dashboardUtility = new DashboardUtility();
			salePerson = dashboardUtility.getCommaSeparated(salePerson);
			if(checkNull(month).length()<1 || checkNull(year).length()<1)
			{
				month = getMonth(""+(cal.get(Calendar.MONTH) + 1));
				year = ""+(cal.get(Calendar.YEAR));
				System.out.println("In getMTDWorkDetail current ==>>month = ["+month+"] year = ["+year+"] salePers = ["+salePerson+"]" );
				
				appendSqlStr = " And sales_pers.Sales_Pers In ( Select Emp_Code " +
						   " From Employee Start With Emp_code = (Select Emp_Code From Users Where Code = "+salePerson+") " +
					       " Connect By Prior Emp_Code =Report_To )";
			}else
			{
				appendSqlStr = " And sales_pers.Sales_Pers In ("+salePerson+") ";
			}
		
			month = dashboardUtility.getCommaSeparated(checkNull(month));
			year = dashboardUtility.getCommaSeparated(checkNull(year));
			System.out.println("In getMTDWorkDetail pophelp selected ==>>month = ["+month+"] year = ["+year+"] salePers = ["+salePerson+"]" );
			
			sql = "SELECT "+month+" AS Month, " +
					""+year+" AS Year, " +
					"strg_meet.sales_pers AS sales_pers_code, " +
					"sales_pers.sp_name AS SalesPerson, " +
					"to_char(To_Date(strg_meet.Event_Date),'DD-MON-YYYY') as EVENT_DATE, " +
					"Loc.Descr as Locality,  " +
					"Coalesce((select employee.name_prefix || ' ' || employee.emp_fname || ' ' || employee.emp_lname " +
					"from employee " +
					"where  employee.emp_code = SALES_PERS1.sales_pers ),'Self') AS Visited_With, " +
					"   listagg(strg_meet.strg_code, ',') within group (order by strg_meet.strg_code) as Strg_Code, " +
					"nvl(count(strg_meet.strg_code),0) as Tot_Calls  ," +
					"nvl((select count(distinct strg_code) from STRG_ITEM_DISPLAY SID where SID.dcr_id=strg_meet.dcr_id),0) as display ,"+
					"FN_R_TOT_PC(strg_meet.dcr_id,strg_meet.EVENT_DATE," +
					"strg_meet.sales_pers,strg_meet.Locality_Code) as Tot_PC  ," +
					"round((CASE When FN_R_FW_CUMM_DAYS(strg_meet.EVENT_DATE,strg_meet.sales_pers) = 0 then 0 " +
					"else FN_R_CUMM_SMO(strg_meet.EVENT_DATE,strg_meet.sales_pers)/FN_R_FW_CUMM_DAYS(strg_meet.EVENT_DATE,strg_meet.sales_pers) end),2) as TLSD  ," +
					" FN_R_CUMM_SMO(strg_meet.EVENT_DATE,strg_meet.sales_pers) as day_tlsd," +
					" FN_R_FW_CUMM_DAYS(strg_meet.EVENT_DATE,strg_meet.sales_pers) as day_count," +
					"FN_R_ORD_VAL(strg_meet.dcr_id,strg_meet.EVENT_DATE,strg_meet.sales_pers,strg_meet.Locality_Code) as Ord_Val  " +
					"FROM sales_pers " +
					"INNER JOIN " +
					"strg_meet ON sales_pers.sales_pers = strg_meet.sales_pers " +
					"Inner Join locality loc on  loc.Locality_Code = strg_meet.Locality_Code " +
					"LEFT JOIN sprs_travel SPT on strg_meet.dcr_id = SPT.dcr_id " +
					"and strg_meet.Sales_Pers = SPT.Sales_Pers and SPT.Locality_Code = strg_meet.Locality_Code " +
					"LEFT JOIN " +
					"sales_pers SALES_PERS1 " +
					"ON SALES_PERS1.sales_pers = SPT.sprs_code__ww  " +
					"WHERE strg_meet.strg_type = 'C' " +
					" "+appendSqlStr+ " " +
					"and strg_meet.EVENT_DATE BETWEEN trunc(to_date("+month+"||"+year+",'MONYYYY'),'MON') " +
					"AND last_day(to_date("+month+"||"+year+",'MONYYYY'))  Group By strg_meet.sales_pers, " +
					"sales_pers.sp_name, strg_meet.Event_Date, " +
					"strg_meet.dcr_id, " +
					"strg_meet.Locality_Code, " +
					"Loc.Descr, " +
					"SALES_PERS1.sales_pers  " +
					"Order By " +
					"SalesPerson," +
					"Event_DATE," +
					"VISITED_With," +
					"Locality";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();

			String salesPersnName = "";
			String salesPersCode = "";
			String prvSalesPersnName = "";
			String userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator;
			while (rs.next())
			{
				rowData = new JSONObject();
				salesPersnName = checkNull(rs.getString("SalesPerson"));
				salesPersCode  = checkNull(rs.getString("sales_pers_code")).trim();
				
				if(!salesPersnName.equalsIgnoreCase(prvSalesPersnName))
				{
					rowData.put("salesperson_name", salesPersnName);
					rowData.put("cardSalesPersonTitle", "cardSalesPersonTitle");
					System.out.println("salesPersCode :"+salesPersCode);
					File file = new File(userImagePath+salesPersCode+".png");
					if(file.exists())
					{
						rowData.put("salesperson_code", "<img class='cardProdImg' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+salesPersCode+".png'/>");
					}else
					{
						salesPersnName = salesPersnName.trim();
						String[] splited = salesPersnName.split(" ");
						System.out.println("splited getMTDWorkDetail :"+splited[0].charAt(0));
						String defaultUserImg = ""+splited[0].charAt(0);
						
						if(splited.length>1)
						{
							/*Get lastWord of salesPersName and add first char to image for more than one space in salesPersName by Dhanendra on Date 07-07-2016 */
							String lastWord = salesPersnName.substring(salesPersnName.lastIndexOf(" ")+1);
							System.out.println("lastWord  getMTDWorkDetail :"+lastWord);
							defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
						}
						System.out.println("defaultUserImg :"+defaultUserImg);
						
						rowData.put("salesperson_code", "<div class='defaultUserImg'> "+defaultUserImg+" </div>");
					}
					prvSalesPersnName  = salesPersnName;
				}else
				{
					rowData.put("salesperson_name", "");
					rowData.put("salesperson_code", "");
				}
				rowData.put("month",checkNull (rs.getString("MONTH")));						
				rowData.put("year", checkNull(rs.getString("YEAR")));
				rowData.put("sales_pers_code_hidden",checkNull( rs.getString("SALES_PERS_CODE")));
				rowData.put("salesperson_name_hidden",checkNull( rs.getString("SALESPERSON")));
				rowData.put("event_date",checkNull( rs.getString("EVENT_DATE")));
				rowData.put("locality",checkNull (rs.getString("LOCALITY")));						
				rowData.put("visited_with",checkNull( rs.getString("VISITED_WITH")));
				rowData.put("tc", checkNull(rs.getString("TOT_CALLS")));
				rowData.put("pc",checkNull( rs.getString("TOT_PC")));
				rowData.put("tlsd",checkNull( rs.getString("TLSD")));
				rowData.put("ordval",checkNull( rs.getString("ORD_VAL")));
				
				rowData.put("day_tlsd",checkNull( rs.getString("day_tlsd")));	//Added by chetan for calculate tlsd
				rowData.put("day_count",checkNull( rs.getString("day_count")));	//Added by chetan for calculate tlsd
				rowData.put("display",checkNull( rs.getString("display"))); //Added by chetan for calculate display
				rowData.put("Strg_Code",checkNull( rs.getString("Strg_Code"))); //Added by chetan for calculate eco
				
				rawDataMTDWorkDtlJson.put(count, rowData);
				count++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :CurrentDayWrkSummary : getMTDWorkDetail" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return rawDataMTDWorkDtlJson;
		
	}
	
	private String getMonth(String selectedMonth)
	  {
		  System.out.println(" selectedMonth = "+selectedMonth);
		  String monthInChar = "";
		  try
		  {
			if (selectedMonth.equals("1"))
			{
				monthInChar = "Jan";
			}
			if (selectedMonth.equals("2"))
			{
				monthInChar = "Feb";
			}
			if (selectedMonth.equals("3"))
			{
				monthInChar = "Mar";
			}
			if (selectedMonth.equals("4"))
			{
				monthInChar = "Apr";
			}
			if (selectedMonth.equals("5"))
			{
				monthInChar = "May";
			}
			if (selectedMonth.equals("6"))
			{
				monthInChar = "Jun";
			}
			if (selectedMonth.equals("7"))
			{
				monthInChar = "Jul";
			}
			if (selectedMonth.equals("8"))
			{
				monthInChar = "Aug";
			}
			if (selectedMonth.equals("9"))
			{
				monthInChar = "Sep";
			}
			if (selectedMonth.equals("10"))
			{
				monthInChar = "Oct";
			}
			if (selectedMonth.equals("11"))
			{
				monthInChar = "Nov";
			}
			if (selectedMonth.equals("12"))
			{
				monthInChar = "Dec";
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in :: CurrentDayWorkDetailSummaryEJB :: getMonth :: "+ e.getMessage());
		}
		System.out.println(" monthInChar = "+monthInChar);
		return monthInChar;
	  }

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}


	

}